/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.roles_and_permissions.assignments;

import com.dataiku.gh.core.models.roles.assignments.BlueprintRoleAssignments;
import com.dataiku.gh.core.models.roles.assignments.RoleAssignmentsRule;
import com.dataiku.gh.core.models.security.UsersContainer;
import com.dataiku.gh.core.services.roles_and_permissions.assignments.IBlueprintRoleAssignmentsDataService;
import com.dataiku.gh.core.services.utils.GHMandatoryTransaction;
import com.dataiku.gh.core.services.validation.errors.ValidationException;
import com.dataiku.gh.core.storage.blueprints.IBlueprintDAO;
import com.dataiku.gh.core.storage.roles.IRoleDAO;
import com.dataiku.gh.core.storage.roles.assignments.IBlueprintRoleAssignmentsDAO;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.springframework.beans.factory.annotation.Autowired;

public class BlueprintRoleAssignmentsDataService
implements IBlueprintRoleAssignmentsDataService {
    @Autowired
    private IBlueprintRoleAssignmentsDAO blueprintRoleAssignmentsDAO;
    @Autowired
    private IRoleDAO roleDAO;
    @Autowired
    private IBlueprintDAO blueprintDAO;

    @Override
    @GHMandatoryTransaction
    public BlueprintRoleAssignments getBlueprintRoleAssignments(String blueprintId) throws IOException {
        return (BlueprintRoleAssignments)this.blueprintRoleAssignmentsDAO.getMandatory(blueprintId);
    }

    @Override
    @GHMandatoryTransaction
    public BlueprintRoleAssignments getBlueprintRoleAssignmentsOrNull(String blueprintId) throws IOException {
        return (BlueprintRoleAssignments)this.blueprintRoleAssignmentsDAO.getOrNull(blueprintId);
    }

    @Override
    @GHMandatoryTransaction
    public List<BlueprintRoleAssignments> listBlueprintRoleAssignments() throws IOException {
        return this.blueprintRoleAssignmentsDAO.list();
    }

    @Override
    @GHMandatoryTransaction
    public BlueprintRoleAssignments createBlueprintRoleAssignments(BlueprintRoleAssignments blueprintRoleAssignments) throws IOException {
        return this.validateAndSave(blueprintRoleAssignments, true);
    }

    @Override
    @GHMandatoryTransaction
    public BlueprintRoleAssignments saveBlueprintRoleAssignments(BlueprintRoleAssignments blueprintRoleAssignments) throws IOException {
        return this.validateAndSave(blueprintRoleAssignments, false);
    }

    @Override
    @GHMandatoryTransaction
    public void deleteBlueprintRoleAssignments(String blueprintId) throws IOException {
        if (!this.blueprintRoleAssignmentsDAO.exists(blueprintId)) {
            throw new ValidationException("Blueprint role assignments for blueprint ID: " + blueprintId + " doesn't exist");
        }
        BlueprintRoleAssignments blueprintRoleAssignments = (BlueprintRoleAssignments)this.blueprintRoleAssignmentsDAO.getMandatory(blueprintId);
        this.lockBlueprintRoleAssignmentsAndRelated(blueprintRoleAssignments);
        this.blueprintRoleAssignmentsDAO.delete(blueprintId);
    }

    @Override
    @GHMandatoryTransaction
    public void deleteUserContainersFromAllBlueprintRoleAssignments(Predicate<UsersContainer> matcher) throws IOException {
        List blueprintRoleAssignmentsList = this.blueprintRoleAssignmentsDAO.list();
        for (BlueprintRoleAssignments blueprintRoleAssignments : blueprintRoleAssignmentsList) {
            boolean hasChanged = false;
            for (Map.Entry<String, List<RoleAssignmentsRule>> entry : blueprintRoleAssignments.roleAssignmentsRules.entrySet()) {
                for (RoleAssignmentsRule rar : entry.getValue()) {
                    for (int i = 0; i < rar.userContainers.size(); ++i) {
                        UsersContainer userContainer = rar.userContainers.get(i);
                        if (!matcher.test(userContainer)) continue;
                        rar.userContainers.remove(i--);
                        hasChanged = true;
                    }
                }
            }
            if (!hasChanged) continue;
            this.blueprintRoleAssignmentsDAO.save(blueprintRoleAssignments);
        }
    }

    private BlueprintRoleAssignments validateAndSave(BlueprintRoleAssignments blueprintRoleAssignments, boolean creation) throws IOException {
        if (creation == this.blueprintRoleAssignmentsDAO.exists(blueprintRoleAssignments.blueprintId)) {
            throw new ValidationException("Blueprint role assignments for blueprint ID: " + blueprintRoleAssignments.blueprintId + (creation ? " already exists" : " doesn't exist"));
        }
        this.lockBlueprintRoleAssignmentsAndRelated(blueprintRoleAssignments);
        if (creation) {
            this.blueprintRoleAssignmentsDAO.create(blueprintRoleAssignments);
        } else {
            this.blueprintRoleAssignmentsDAO.save(blueprintRoleAssignments);
        }
        return (BlueprintRoleAssignments)this.blueprintRoleAssignmentsDAO.getMandatory(blueprintRoleAssignments.blueprintId);
    }

    private void lockBlueprintRoleAssignmentsAndRelated(BlueprintRoleAssignments blueprintRoleAssignments) throws IOException {
        this.blueprintRoleAssignmentsDAO.lock(blueprintRoleAssignments.blueprintId);
        this.blueprintDAO.lock(blueprintRoleAssignments.blueprintId);
        for (String roleId : blueprintRoleAssignments.roleAssignmentsRules.keySet()) {
            this.roleDAO.lock(roleId);
        }
    }
}

