/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.security.mappings;

import com.dataiku.dip.DSSMetrics;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.gh.core.context.GovernActionContext;
import com.dataiku.gh.core.models.enriched.EnrichedArtifact;
import com.dataiku.gh.core.models.enriched.EnrichedArtifactDetails;
import com.dataiku.gh.core.models.history.ActionType;
import com.dataiku.gh.core.models.security.GlobalAPIKeyUsersContainer;
import com.dataiku.gh.core.models.security.GroupUsersContainer;
import com.dataiku.gh.core.models.security.PublicGlobalAPIKey;
import com.dataiku.gh.core.models.security.PublicGroup;
import com.dataiku.gh.core.models.security.UserUsersContainer;
import com.dataiku.gh.core.models.security.mappings.GlobalAPIKeyMapping;
import com.dataiku.gh.core.models.security.mappings.GroupMapping;
import com.dataiku.gh.core.models.security.mappings.UserMapping;
import com.dataiku.gh.core.models.ui.UIArtifact;
import com.dataiku.gh.core.services.artifacts.IArtifactsDataService;
import com.dataiku.gh.core.services.artifacts.context.EnrichedBlueprintVersionContext;
import com.dataiku.gh.core.services.roles_and_permissions.assignments.IBlueprintRoleAssignmentsDataService;
import com.dataiku.gh.core.services.security.mappings.IUsersMappingsService;
import com.dataiku.gh.core.services.signoff.ISignoffsEventService;
import com.dataiku.gh.core.services.subscriptions.ISubscriptionsDataService;
import com.dataiku.gh.core.services.system.ISystemArtifactService;
import com.dataiku.gh.core.services.system.SystemProvidedConstants;
import com.dataiku.gh.core.services.time_series.ITimeSeriesDataService;
import com.dataiku.gh.core.services.uploaded_files.IUploadedFilesService;
import com.dataiku.gh.core.services.user_config.IUserConfigurationDataService;
import com.dataiku.gh.core.services.utils.GHWriteTransaction;
import com.dataiku.gh.core.services.utils.ITransactionHandler;
import com.dataiku.gh.core.services.utils.ITransactionScope;
import com.dataiku.gh.core.storage.security.mappings.IGlobalAPIKeyMappingDAO;
import com.dataiku.gh.core.storage.security.mappings.IGroupMappingDAO;
import com.dataiku.gh.core.storage.security.mappings.IUserMappingDAO;
import com.dataiku.gh.dao.UsersDAO;
import com.dataiku.gh.security.model.GlobalScopePublicAPIKey;
import com.dataiku.gh.server.api.auth.PublicAPIKeysService;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.PostConstruct;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UsersMappingsService
implements IUsersMappingsService {
    private static final DKULogger logger = DKULogger.getLogger((String)"gh.service.users-mappings");
    private static final String LOG_MSG = "Failed to sync all user, group, global-api-key mappings";
    @Autowired
    private IArtifactsDataService artifactsDataService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private UsersDAO usersDAO;
    @Autowired
    private PublicAPIKeysService publicAPIKeysService;
    @Autowired
    private IUserMappingDAO userMappingDAO;
    @Autowired
    private IGroupMappingDAO groupMappingDAO;
    @Autowired
    private IGlobalAPIKeyMappingDAO globalAPIKeyMappingDAO;
    @Autowired
    private IBlueprintRoleAssignmentsDataService blueprintRoleAssignmentsDataService;
    @Autowired
    private ISystemArtifactService systemArtifactService;
    @Autowired
    private ISignoffsEventService signoffsEventService;
    @Autowired
    private ISubscriptionsDataService subscriptionsDataService;
    @Autowired
    private IUploadedFilesService uploadedFilesService;
    @Autowired
    private ITimeSeriesDataService timeSeriesDataService;
    @Autowired
    private IUserConfigurationDataService userConfigurationDataService;
    @Autowired
    private ITransactionHandler transactionHandler;

    @PostConstruct
    public void init() {
        logger.info((Object)"Govern server started: triggering a users mappings sync");
        try {
            this.syncAll();
        }
        catch (IOException e) {
            logger.error((Object)LOG_MSG, (Throwable)e);
        }
    }

    @Override
    public void syncAll() throws IOException {
        logger.info((Object)"Syncing all users, groups, and global api keys...");
        TransactionContext.assertNoAttachedTransaction();
        try (GovernActionContext.ContextContainer context = GovernActionContext.attachReuseCurrentContextOrCreateIfNone(ActionType.USERS_MAPPING_SYNC, null);
             RWTransaction rw = this.transactionService.beginWriteAsDSS();
             EnrichedBlueprintVersionContext.EnrichedBlueprintVersionContextContainer blueprintVersionCache = EnrichedBlueprintVersionContext.attachNewContextOrKeepExistingOne();
             DSSMetrics.TimeCtx ignored = DSSMetrics.timeCtx((String)"dku.gh.service.users-mappings.sync-all");
             ITransactionScope ts = this.transactionHandler.openNewWriteTransaction();){
            this.syncAllInternal();
            ts.commit();
        }
        catch (Exception e) {
            logger.error((Object)LOG_MSG, (Throwable)e);
            throw new IOException(LOG_MSG, e);
        }
    }

    private void syncAllInternal() throws IOException {
        TransactionContext.assertAttachedRWTransaction();
        logger.debug((Object)"Retrieving all users, groups, and global api keys from the datadir");
        Map groupsMap = this.usersDAO.listGroupsUnsafe().stream().collect(Collectors.toMap(group -> group.name, Function.identity()));
        Map usersMap = this.usersDAO.listUsersUnsafe().stream().collect(Collectors.toMap(user -> user.login, Function.identity()));
        Map globalAPIKeysMap = this.publicAPIKeysService.listGlobalAPIKeys().stream().collect(Collectors.toMap(apiKey -> apiKey.id, Function.identity()));
        logger.debug((Object)"Retrieving all user, group, and global api key mappings from the DB");
        Map existingGroupMappingsMap = this.groupMappingDAO.listAllGroupMappings().stream().collect(Collectors.toMap(gm -> gm.groupName, Function.identity()));
        Map existingUserMappingsMap = this.userMappingDAO.listAllUserMappings().stream().collect(Collectors.toMap(um -> um.userLogin, Function.identity()));
        Map existingGlobalAPIKeyMappingMap = this.globalAPIKeyMappingDAO.listAllGlobalAPIKeyMappings().stream().collect(Collectors.toMap(keyMapping -> keyMapping.apiKeyId, Function.identity()));
        Map groupMappingsToDelete = existingGroupMappingsMap.values().stream().filter(groupMapping -> !groupsMap.containsKey(groupMapping.groupName)).collect(Collectors.toMap(gm -> gm.groupName, Function.identity()));
        logger.debug((Object)("Deleting group mappings and archiving their corresponding artifacts: " + String.valueOf(groupMappingsToDelete.values())));
        this.groupMappingDAO.deleteGroupMappings(groupMappingsToDelete.values());
        for (Object groupMappingToDelete : groupMappingsToDelete.values()) {
            this.archivedArtifact(((GroupMapping)groupMappingToDelete).artifactId);
        }
        logger.debug((Object)("Upserting groups to artifacts, count: " + groupsMap.size()));
        HashMap<String, GroupMapping> groupMappingsToAdd = new HashMap<String, GroupMapping>();
        for (Object group2 : groupsMap.values()) {
            GroupMapping matchingGroupMapping = (GroupMapping)existingGroupMappingsMap.get(((UsersDAO.Group)group2).name);
            String artifactId = this.updateGroupArtifact(Optional.ofNullable(matchingGroupMapping).map(gm -> gm.artifactId).orElse(null), (UsersDAO.Group)group2);
            if (matchingGroupMapping != null) continue;
            groupMappingsToAdd.put(((UsersDAO.Group)group2).name, GroupMapping.build(((UsersDAO.Group)group2).name, artifactId));
        }
        logger.debug((Object)("Creating group mappings for new artifacts: " + String.valueOf(groupMappingsToAdd.values())));
        this.groupMappingDAO.createGroupMappings(groupMappingsToAdd.values());
        Map userMappingsToDelete = existingUserMappingsMap.values().stream().filter(userMapping -> !usersMap.containsKey(userMapping.userLogin)).collect(Collectors.toMap(keyMapping -> keyMapping.userLogin, Function.identity()));
        logger.debug((Object)("Deleting user mappings and archiving their corresponding artifacts: " + String.valueOf(userMappingsToDelete.values())));
        this.userMappingDAO.deleteUserMappings(userMappingsToDelete.values());
        for (Object userMappingToDelete : userMappingsToDelete.values()) {
            this.archivedArtifact(((UserMapping)userMappingToDelete).artifactId);
        }
        logger.debug((Object)("Upserting users to artifacts, count: " + usersMap.size()));
        HashMap<String, UserMapping> userMappingsToAdd = new HashMap<String, UserMapping>();
        for (Object user2 : usersMap.values()) {
            UserMapping matchingUserMapping = (UserMapping)existingUserMappingsMap.get(((UsersDAO.User)user2).login);
            Set<String> userGroupsArtifactIds = ((UsersDAO.User)user2).groups.stream().filter(groupName -> !groupMappingsToDelete.containsKey(groupName)).map(groupName -> existingGroupMappingsMap.getOrDefault(groupName, (GroupMapping)groupMappingsToAdd.get(groupName))).filter(Objects::nonNull).map(groupMapping -> groupMapping.artifactId).collect(Collectors.toSet());
            String artifactId = this.updateUserArtifact(Optional.ofNullable(matchingUserMapping).map(um -> um.artifactId).orElse(null), (UsersDAO.User)user2, userGroupsArtifactIds);
            if (matchingUserMapping != null) continue;
            userMappingsToAdd.put(((UsersDAO.User)user2).login, UserMapping.build(((UsersDAO.User)user2).login, artifactId));
        }
        logger.debug((Object)("Creating user mappings for new artifacts: " + String.valueOf(userMappingsToAdd.values())));
        this.userMappingDAO.createUserMappings(userMappingsToAdd.values());
        Map apiKeyMappingsToDelete = existingGlobalAPIKeyMappingMap.values().stream().filter(globalAPIKeyMapping -> !globalAPIKeysMap.containsKey(globalAPIKeyMapping.apiKeyId)).collect(Collectors.toMap(keyMapping -> keyMapping.apiKeyId, Function.identity()));
        logger.debug((Object)("Deleting global api key mappings and archiving their corresponding artifacts: " + String.valueOf(apiKeyMappingsToDelete.values())));
        this.globalAPIKeyMappingDAO.deleteGlobalAPIKeyMappings(apiKeyMappingsToDelete.values());
        for (GlobalAPIKeyMapping apiKeyMappingToDelete : apiKeyMappingsToDelete.values()) {
            this.archivedArtifact(apiKeyMappingToDelete.artifactId);
        }
        logger.debug((Object)("Upserting global api keys to artifacts, count: " + globalAPIKeysMap.size()));
        HashMap<String, GlobalAPIKeyMapping> globalAPIKeyMappingsToAdd = new HashMap<String, GlobalAPIKeyMapping>();
        for (GlobalScopePublicAPIKey apiKey2 : globalAPIKeysMap.values()) {
            GlobalAPIKeyMapping matchingGlobalAPIKeyMapping = (GlobalAPIKeyMapping)existingGlobalAPIKeyMappingMap.get(apiKey2.id);
            String artifactId = this.updateGlobalAPIKeyArtifact(Optional.ofNullable(matchingGlobalAPIKeyMapping).map(am -> am.artifactId).orElse(null), apiKey2);
            if (matchingGlobalAPIKeyMapping != null) continue;
            globalAPIKeyMappingsToAdd.put(apiKey2.id, GlobalAPIKeyMapping.build(apiKey2.id, artifactId));
        }
        logger.debug((Object)("Creating global api key mappings for new artifacts: " + String.valueOf(globalAPIKeyMappingsToAdd.values())));
        this.globalAPIKeyMappingDAO.createGlobalAPIKeyMappings(globalAPIKeyMappingsToAdd.values());
    }

    @Override
    public void setUserGroupGlobalAPIKeyInfoToUIArtifact(UIArtifact uiArtifact, EnrichedArtifactDetails enrichedArtifactDetails) throws IOException {
        Transaction t;
        if (StringUtils.isNotBlank((CharSequence)enrichedArtifactDetails.userLogin)) {
            try (Transaction t2 = this.transactionService.retrieveOrBeginRead();){
                uiArtifact.uiArtifactDetails.user = this.usersDAO.getPublicUser(enrichedArtifactDetails.userLogin);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)enrichedArtifactDetails.groupName)) {
            UsersDAO.Group group;
            t = this.transactionService.retrieveOrBeginRead();
            try {
                group = this.usersDAO.getGroupUnsafe(enrichedArtifactDetails.groupName);
            }
            finally {
                if (t != null) {
                    t.close();
                }
            }
            if (group == null) {
                logger.warn((Object)("Cannot find Group: " + enrichedArtifactDetails.groupName));
            } else {
                uiArtifact.uiArtifactDetails.group = PublicGroup.fromGroup(group);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)enrichedArtifactDetails.globalAPIKeyId)) {
            List<GlobalScopePublicAPIKey> listGlobalAPIKeys;
            t = this.transactionService.retrieveOrBeginRead();
            try {
                listGlobalAPIKeys = this.publicAPIKeysService.listGlobalAPIKeys();
            }
            finally {
                if (t != null) {
                    t.close();
                }
            }
            Optional<GlobalScopePublicAPIKey> apiKey = listGlobalAPIKeys.stream().filter(apikey -> StringUtils.equals((CharSequence)apikey.id, (CharSequence)enrichedArtifactDetails.globalAPIKeyId)).findAny();
            if (apiKey.isEmpty()) {
                logger.warn((Object)("Cannot find Global API Key: " + enrichedArtifactDetails.globalAPIKeyId));
            } else {
                uiArtifact.uiArtifactDetails.globalAPIKey = PublicGlobalAPIKey.build(apiKey.get());
            }
        }
    }

    @Override
    @GHWriteTransaction
    public void onUserCreate(UsersDAO.User user) throws IOException {
        logger.info((Object)("onUserCreate triggered for user: " + user.login));
        try (GovernActionContext.ContextContainer context = GovernActionContext.attachReuseCurrentContextOrCreateIfNone(ActionType.USER_CREATE, null);
             DSSMetrics.TimeCtx ignored = DSSMetrics.timeCtx((String)"dku.gh.service.users-mappings.on-user-create");){
            TransactionContext.assertAttachedRWTransaction();
            List<UserMapping> matchingUserMappings = this.userMappingDAO.listUserMappings(Collections.singletonList(user.login));
            logger.debug((Object)("Deleting existing mapping and archiving artifact for same user login: " + String.valueOf(matchingUserMappings)));
            this.userMappingDAO.deleteUserMappings(matchingUserMappings);
            for (UserMapping userMapping : matchingUserMappings) {
                this.archivedArtifact(userMapping.artifactId);
            }
            Set<String> userGroupsArtifactIds = this.groupMappingDAO.listGroupMappings(user.groups).stream().map(gm -> gm.artifactId).collect(Collectors.toSet());
            logger.debug((Object)("Retrieved artifacts IDs matching user's groups: " + String.valueOf(userGroupsArtifactIds)));
            String createdArtifactId = this.updateUserArtifact(null, user, userGroupsArtifactIds);
            logger.debug((Object)("Created new user artifact: " + createdArtifactId));
            UserMapping um = UserMapping.build(user.login, createdArtifactId);
            logger.debug((Object)("Creating new user mapping: " + String.valueOf(um)));
            this.userMappingDAO.createUserMappings(Collections.singletonList(um));
        }
    }

    @Override
    @GHWriteTransaction
    public void onUserSave(UsersDAO.User user) throws IOException {
        logger.info((Object)("onUserSave triggered for user: " + user.login));
        try (GovernActionContext.ContextContainer context = GovernActionContext.attachReuseCurrentContextOrCreateIfNone(ActionType.USER_SAVE, null);
             DSSMetrics.TimeCtx ignored = DSSMetrics.timeCtx((String)"dku.gh.service.users-mappings.on-user-save");){
            TransactionContext.assertAttachedRWTransaction();
            List<UserMapping> matchingUserMappings = this.userMappingDAO.listUserMappings(Collections.singletonList(user.login));
            if (CollectionUtils.isEmpty(matchingUserMappings)) {
                logger.warn((Object)("User mapping not found for user edition, fallback to user creation: " + user.login));
                this.onUserCreate(user);
            } else {
                logger.debug((Object)("User mapping found for user: " + String.valueOf(matchingUserMappings)));
                Set<String> userGroupsArtifactIds = this.groupMappingDAO.listGroupMappings(user.groups).stream().map(gm -> gm.artifactId).collect(Collectors.toSet());
                logger.debug((Object)("Retrieved artifacts IDs matching user's groups: " + String.valueOf(userGroupsArtifactIds)));
                for (UserMapping userMapping : matchingUserMappings) {
                    logger.debug((Object)("Upserting user artifact: " + userMapping.artifactId));
                    this.updateUserArtifact(userMapping.artifactId, user, userGroupsArtifactIds);
                }
            }
        }
    }

    @Override
    @GHWriteTransaction
    public void onUserDelete(String login) throws IOException {
        logger.info((Object)("onUserDelete triggered for user: " + login));
        try (GovernActionContext.ContextContainer context = GovernActionContext.attachReuseCurrentContextOrCreateIfNone(ActionType.USER_DELETE, null);
             DSSMetrics.TimeCtx ignored = DSSMetrics.timeCtx((String)"dku.gh.service.users-mappings.on-user-delete");){
            TransactionContext.assertAttachedRWTransaction();
            logger.debug((Object)"Deleting all user references in role assignments");
            this.blueprintRoleAssignmentsDataService.deleteUserContainersFromAllBlueprintRoleAssignments(userContainer -> {
                if (!(userContainer instanceof UserUsersContainer)) return false;
                UserUsersContainer userUsersContainer = (UserUsersContainer)userContainer;
                if (!StringUtils.equals((CharSequence)login, (CharSequence)userUsersContainer.login)) return false;
                return true;
            });
            logger.debug((Object)"Deleting all user subscriptions");
            this.subscriptionsDataService.deleteForUser(login);
            logger.debug((Object)"Deleting all user references in sign-offs");
            this.signoffsEventService.onUserDelete(login);
            logger.debug((Object)"Deleting all user references in uploaded file ownerships");
            this.uploadedFilesService.deleteOwnersFromUploadedFiles(login);
            logger.debug((Object)"Deleting all user references in timeseries ownerships");
            this.timeSeriesDataService.deleteOwnersFromTimeSeriesHeads(login);
            logger.debug((Object)"Deleting all user configuration");
            this.userConfigurationDataService.deleteUserConfigurationIfExists(login);
            List<UserMapping> matchingUserMappings = this.userMappingDAO.listUserMappings(Collections.singletonList(login));
            logger.debug((Object)("Deleting user mapping and archiving user artifact: " + String.valueOf(matchingUserMappings)));
            this.userMappingDAO.deleteUserMappings(matchingUserMappings);
            for (UserMapping userMapping : matchingUserMappings) {
                this.archivedArtifact(userMapping.artifactId);
            }
        }
    }

    @Override
    @GHWriteTransaction
    public void onGroupCreate(UsersDAO.Group group) throws IOException {
        logger.info((Object)("onGroupCreate triggered for group: " + group.name));
        try (GovernActionContext.ContextContainer context = GovernActionContext.attachReuseCurrentContextOrCreateIfNone(ActionType.GROUP_CREATE, null);
             DSSMetrics.TimeCtx ignored = DSSMetrics.timeCtx((String)"dku.gh.service.users-mappings.on-group-create");){
            TransactionContext.assertAttachedRWTransaction();
            List<GroupMapping> matchingGroupMappings = this.groupMappingDAO.listGroupMappings(Collections.singletonList(group.name));
            logger.debug((Object)("Deleting existing mapping and archiving artifact for same group name: " + String.valueOf(matchingGroupMappings)));
            this.groupMappingDAO.deleteGroupMappings(matchingGroupMappings);
            for (GroupMapping groupMapping : matchingGroupMappings) {
                this.archivedArtifact(groupMapping.artifactId);
            }
            String createdArtifactId = this.updateGroupArtifact(null, group);
            logger.debug((Object)("Created new group artifact: " + createdArtifactId));
            GroupMapping gm = GroupMapping.build(group.name, createdArtifactId);
            logger.debug((Object)("Creating new group mapping: " + String.valueOf(gm)));
            this.groupMappingDAO.createGroupMappings(Collections.singletonList(gm));
        }
    }

    @Override
    @GHWriteTransaction
    public void onGroupSave(UsersDAO.Group group) throws IOException {
        logger.info((Object)("onGroupSave triggered for group: " + group.name));
        try (GovernActionContext.ContextContainer context = GovernActionContext.attachReuseCurrentContextOrCreateIfNone(ActionType.GROUP_SAVE, null);
             DSSMetrics.TimeCtx ignored = DSSMetrics.timeCtx((String)"dku.gh.service.users-mappings.on-group-save");){
            TransactionContext.assertAttachedRWTransaction();
            List<GroupMapping> matchingGroupMappings = this.groupMappingDAO.listGroupMappings(Collections.singletonList(group.name));
            if (CollectionUtils.isEmpty(matchingGroupMappings)) {
                logger.warn((Object)("Group mapping not found for group edition, fallback to group creation: " + group.name));
                this.onGroupCreate(group);
            } else {
                logger.debug((Object)("Group mapping found for group: " + String.valueOf(matchingGroupMappings)));
                for (GroupMapping groupMapping : matchingGroupMappings) {
                    logger.debug((Object)("Upserting group artifact: " + groupMapping.artifactId));
                    this.updateGroupArtifact(groupMapping.artifactId, group);
                }
            }
        }
    }

    @Override
    @GHWriteTransaction
    public void onGroupDelete(String groupName) throws IOException {
        logger.info((Object)("onGroupDelete triggered for group: " + groupName));
        try (GovernActionContext.ContextContainer context = GovernActionContext.attachReuseCurrentContextOrCreateIfNone(ActionType.GROUP_DELETE, null);
             DSSMetrics.TimeCtx ignored = DSSMetrics.timeCtx((String)"dku.gh.service.users-mappings.on-group-delete");){
            TransactionContext.assertAttachedRWTransaction();
            logger.debug((Object)"Deleting all user references in role assignments");
            this.blueprintRoleAssignmentsDataService.deleteUserContainersFromAllBlueprintRoleAssignments(userContainer -> {
                if (!(userContainer instanceof GroupUsersContainer)) return false;
                GroupUsersContainer groupUsersContainer = (GroupUsersContainer)userContainer;
                if (!StringUtils.equals((CharSequence)groupName, (CharSequence)groupUsersContainer.groupName)) return false;
                return true;
            });
            logger.debug((Object)"Deleting all user references in sign-offs");
            this.signoffsEventService.onGroupDelete(groupName);
            List<GroupMapping> matchingGroupMappings = this.groupMappingDAO.listGroupMappings(Collections.singletonList(groupName));
            logger.debug((Object)("Deleting group mapping and archiving group artifact: " + String.valueOf(matchingGroupMappings)));
            this.groupMappingDAO.deleteGroupMappings(matchingGroupMappings);
            for (GroupMapping groupMapping : matchingGroupMappings) {
                this.archivedArtifact(groupMapping.artifactId);
            }
        }
    }

    @Override
    @GHWriteTransaction
    public void onGlobalAPIKeyCreate(GlobalScopePublicAPIKey apiKey) throws IOException {
        logger.info((Object)("onGlobalAPIKeyCreate triggered for global api key: " + apiKey.id));
        try (GovernActionContext.ContextContainer context = GovernActionContext.attachReuseCurrentContextOrCreateIfNone(ActionType.GLOBAL_API_KEY_CREATE, null);
             DSSMetrics.TimeCtx ignored = DSSMetrics.timeCtx((String)"dku.gh.service.users-mappings.on-global-api-key-create");){
            TransactionContext.assertAttachedRWTransaction();
            List<GlobalAPIKeyMapping> matchingGlobalAPIKeyMappings = this.globalAPIKeyMappingDAO.listGlobalAPIKeyMappings(Collections.singletonList(apiKey.id));
            logger.debug((Object)("Deleting existing mapping and archiving artifact for same global api key id: " + String.valueOf(matchingGlobalAPIKeyMappings)));
            this.globalAPIKeyMappingDAO.deleteGlobalAPIKeyMappings(matchingGlobalAPIKeyMappings);
            String createdArtifactId = this.updateGlobalAPIKeyArtifact(null, apiKey);
            logger.debug((Object)("Created new global api key artifact: " + createdArtifactId));
            GlobalAPIKeyMapping km = GlobalAPIKeyMapping.build(apiKey.id, createdArtifactId);
            logger.debug((Object)("Creating new global api key mapping: " + String.valueOf(km)));
            this.globalAPIKeyMappingDAO.createGlobalAPIKeyMappings(Collections.singletonList(km));
        }
    }

    @Override
    @GHWriteTransaction
    public void onGlobalAPIKeySave(GlobalScopePublicAPIKey apiKey) throws IOException {
        logger.info((Object)("onGlobalAPIKeySave triggered for global api key: " + apiKey.id));
        try (GovernActionContext.ContextContainer context = GovernActionContext.attachReuseCurrentContextOrCreateIfNone(ActionType.GLOBAL_API_KEY_SAVE, null);
             DSSMetrics.TimeCtx ignored = DSSMetrics.timeCtx((String)"dku.gh.service.users-mappings.on-global-api-key-save");){
            TransactionContext.assertAttachedRWTransaction();
            List<GlobalAPIKeyMapping> matchingApiKeyMappings = this.globalAPIKeyMappingDAO.listGlobalAPIKeyMappings(Collections.singletonList(apiKey.id));
            if (CollectionUtils.isEmpty(matchingApiKeyMappings)) {
                logger.warn((Object)("Global API Key mapping not found for global api key edition, fallback to global api key creation: " + apiKey.id));
                this.onGlobalAPIKeyCreate(apiKey);
            } else {
                logger.debug((Object)("Global API Key mapping found for global api key: " + String.valueOf(matchingApiKeyMappings)));
                for (GlobalAPIKeyMapping globalAPIKeyMapping : matchingApiKeyMappings) {
                    logger.debug((Object)("Upserting global api key artifact: " + globalAPIKeyMapping.artifactId));
                    this.updateGlobalAPIKeyArtifact(globalAPIKeyMapping.artifactId, apiKey);
                }
            }
        }
    }

    @Override
    @GHWriteTransaction
    public void onGlobalAPIKeyDelete(String globalAPIKeyId) throws IOException {
        logger.info((Object)("onGlobalAPIKeyDelete triggered for global api key: " + globalAPIKeyId));
        try (GovernActionContext.ContextContainer context = GovernActionContext.attachReuseCurrentContextOrCreateIfNone(ActionType.GLOBAL_API_KEY_DELETE, null);
             DSSMetrics.TimeCtx ignored = DSSMetrics.timeCtx((String)"dku.gh.service.users-mappings.on-global-api-key-delete");){
            TransactionContext.assertAttachedRWTransaction();
            logger.debug((Object)"Deleting all global api key references in role assignments");
            this.blueprintRoleAssignmentsDataService.deleteUserContainersFromAllBlueprintRoleAssignments(userContainer -> {
                if (!(userContainer instanceof GlobalAPIKeyUsersContainer)) return false;
                GlobalAPIKeyUsersContainer globalAPIKeyUsersContainer = (GlobalAPIKeyUsersContainer)userContainer;
                if (!StringUtils.equals((CharSequence)globalAPIKeyId, (CharSequence)globalAPIKeyUsersContainer.globalAPIKeyId)) return false;
                return true;
            });
            logger.debug((Object)"Deleting all global api key references in sign-offs");
            this.signoffsEventService.onGlobalAPIKeyDelete(globalAPIKeyId);
            logger.debug((Object)"Deleting all global api key references in uploaded file ownerships");
            this.uploadedFilesService.deleteOwnersFromUploadedFiles("api:" + globalAPIKeyId);
            logger.debug((Object)"Deleting all global api key references in timeseries ownerships");
            this.timeSeriesDataService.deleteOwnersFromTimeSeriesHeads("api:" + globalAPIKeyId);
            List<GlobalAPIKeyMapping> matchingGlobalAPIKeyMappings = this.globalAPIKeyMappingDAO.listGlobalAPIKeyMappings(Collections.singletonList(globalAPIKeyId));
            logger.debug((Object)("Deleting global api key mapping and archiving global api key artifact: " + String.valueOf(matchingGlobalAPIKeyMappings)));
            this.globalAPIKeyMappingDAO.deleteGlobalAPIKeyMappings(matchingGlobalAPIKeyMappings);
            for (GlobalAPIKeyMapping globalAPIKeyMapping : matchingGlobalAPIKeyMappings) {
                this.archivedArtifact(globalAPIKeyMapping.artifactId);
            }
        }
    }

    private String updateUserArtifact(@Nullable String existingArtifactId, UsersDAO.User user, Set<String> groupsArtifactId) throws IOException {
        EnrichedArtifact storedEnrichedArtifact = this.systemArtifactService.upsertPatchSystemArtifact(existingArtifactId, SystemProvidedConstants.USER.getSingleDefaultBlueprintVersionId(), ea -> {
            ea.artifact.name = user.displayName;
            if (CollectionUtils.isEmpty((Collection)groupsArtifactId)) {
                ea.artifact.fields.remove("groups");
            } else {
                ea.artifact.fields.put("groups", groupsArtifactId.stream().sorted().toList());
            }
        });
        return storedEnrichedArtifact.artifact.id;
    }

    private String updateGroupArtifact(@Nullable String existingArtifactId, UsersDAO.Group group) throws IOException {
        EnrichedArtifact storedEnrichedArtifact = this.systemArtifactService.upsertPatchSystemArtifact(existingArtifactId, SystemProvidedConstants.GROUP.getSingleDefaultBlueprintVersionId(), ea -> {
            ea.artifact.name = group.name;
        });
        return storedEnrichedArtifact.artifact.id;
    }

    private String updateGlobalAPIKeyArtifact(@Nullable String existingArtifactId, GlobalScopePublicAPIKey apiKey) throws IOException {
        String artifactName = StringUtils.isBlank((CharSequence)apiKey.label) ? "Global API Key (not labelled)" : apiKey.label;
        EnrichedArtifact storedEnrichedArtifact = this.systemArtifactService.upsertPatchSystemArtifact(existingArtifactId, SystemProvidedConstants.GLOBAL_API_KEY.getSingleDefaultBlueprintVersionId(), ea -> {
            ea.artifact.name = artifactName;
        });
        return storedEnrichedArtifact.artifact.id;
    }

    private void archivedArtifact(String artifactId) throws IOException {
        EnrichedArtifact enrichedArtifact = this.artifactsDataService.getArtifact(artifactId);
        enrichedArtifact.artifact.status.archived = true;
        this.artifactsDataService.storeArtifact(enrichedArtifact, false);
    }
}

