/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.signoff;

import com.dataiku.gh.core.models.security.GlobalAPIKeyUsersContainer;
import com.dataiku.gh.core.models.security.GroupUsersContainer;
import com.dataiku.gh.core.models.security.RoleUsersContainer;
import com.dataiku.gh.core.models.security.UserUsersContainer;
import com.dataiku.gh.core.models.signoff.Signoff;
import com.dataiku.gh.core.models.signoff.SignoffConfiguration;
import com.dataiku.gh.core.models.signoff.SignoffId;
import com.dataiku.gh.core.models.signoff.SignoffUser;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class SignoffUtils {
    public static String generateFeedbackId(Set<String> usedUUIDs) {
        String uuid;
        for (int watchdog = 1000; usedUUIDs.contains(uuid = UUID.randomUUID().toString()) && watchdog > 0; --watchdog) {
        }
        return uuid;
    }

    public static List<Signoff> buildInitialSignoffsFromConfig(String artifactId, @Nullable List<SignoffConfiguration> configurations) {
        if (CollectionUtils.isEmpty(configurations)) {
            return Collections.emptyList();
        }
        return configurations.stream().map(configuration -> SignoffUtils.buildSignoffFromConfig(artifactId, configuration)).collect(Collectors.toList());
    }

    public static Signoff buildSignoffFromConfig(String artifactId, SignoffConfiguration signoffConfiguration) {
        Signoff signoff = new Signoff();
        signoff.signoffId = SignoffId.build(artifactId, signoffConfiguration.id.stepId);
        signoff.configuration = signoffConfiguration;
        signoff.updateStatus(Signoff.SignoffStatus.NOT_STARTED);
        return signoff;
    }

    public static Predicate<SignoffUser> userUsersContainerContainsUser(String userLogin) {
        return user -> {
            if (userLogin == null || user == null || !(user.usersContainer instanceof UserUsersContainer)) {
                return false;
            }
            return StringUtils.equals((CharSequence)userLogin, (CharSequence)((UserUsersContainer)user.usersContainer).login);
        };
    }

    public static Predicate<SignoffUser> roleUsersContainerContainsRoleId(String roleId) {
        return user -> {
            if (user == null || !(user.usersContainer instanceof RoleUsersContainer)) {
                return false;
            }
            return StringUtils.equals((CharSequence)roleId, (CharSequence)((RoleUsersContainer)user.usersContainer).roleId);
        };
    }

    public static Predicate<SignoffUser> groupUsersContainerContainsGroupName(String groupName) {
        return user -> {
            if (user == null || !(user.usersContainer instanceof GroupUsersContainer)) {
                return false;
            }
            return StringUtils.equals((CharSequence)groupName, (CharSequence)((GroupUsersContainer)user.usersContainer).groupName);
        };
    }

    public static Predicate<SignoffUser> globalApikeyUsersContainerContainsApiKeyId(String globalAPIKeyId) {
        return user -> {
            if (user == null || !(user.usersContainer instanceof GlobalAPIKeyUsersContainer)) {
                return false;
            }
            return StringUtils.equals((CharSequence)globalAPIKeyId, (CharSequence)((GlobalAPIKeyUsersContainer)user.usersContainer).globalAPIKeyId);
        };
    }
}

