/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.storage.sql.subscriptions;

import com.dataiku.dip.exceptions.DataStoreIOException;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.gh.core.models.EntityType;
import com.dataiku.gh.core.models.subscriptions.Subscription;
import com.dataiku.gh.core.models.subscriptions.SubscriptionId;
import com.dataiku.gh.core.storage.sql.AbstractItemBasedDAO;
import com.dataiku.gh.core.storage.sql.model.QArtifactSubscriptions;
import com.dataiku.gh.core.storage.sql.model.QArtifactSubscriptionsHistory;
import com.dataiku.gh.core.storage.sql.subscriptions.SubscriptionRowMapper;
import com.dataiku.gh.core.storage.subscriptions.ISubscriptionDAO;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.SimplePath;
import com.querydsl.sql.RelationalPathBase;
import com.querydsl.sql.SQLQuery;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.RowMapper;

public class SubscriptionDAO
extends AbstractItemBasedDAO<SubscriptionId, Subscription, Subscription>
implements ISubscriptionDAO {
    private static final DKULogger logger = DKULogger.getLogger((String)"gh.storage.artifact-subscriptions");
    @Autowired
    private SubscriptionRowMapper subscriptionsRowMapper;

    @Override
    protected EntityType getEntityType() {
        return EntityType.SUBSCRIPTION;
    }

    @Override
    protected RowMapper<Subscription> getRowMapper() {
        return this.subscriptionsRowMapper;
    }

    @Override
    protected SubscriptionId getId(Subscription item) {
        return item.subscriptionId;
    }

    @Override
    protected RelationalPathBase<?> getItemTablePath() {
        return QArtifactSubscriptions.artifactSubscriptions;
    }

    @Override
    protected SimplePath<Object> getItemTableJsonColumnPath() {
        return QArtifactSubscriptions.artifactSubscriptions.artifactSubscriptionJson;
    }

    @Override
    protected Predicate getIdCondition(SubscriptionId subscriptionId) {
        return QArtifactSubscriptions.artifactSubscriptions.artifactSubscriptionArtifactId.eq((Object)subscriptionId.artifactId).and((Predicate)QArtifactSubscriptions.artifactSubscriptions.artifactSubscriptionUserLogin.eq((Object)subscriptionId.userLogin));
    }

    @Override
    protected RelationalPathBase<?> getHistoryTablePath() {
        return QArtifactSubscriptionsHistory.artifactSubscriptionsHistory;
    }

    @Override
    protected SimplePath<Object> getHistoryRevisionColumnPath() {
        return QArtifactSubscriptionsHistory.artifactSubscriptionsHistory._revisionJson;
    }

    @Override
    protected SimplePath<Object> getHistoryJsonColumnPath() {
        return QArtifactSubscriptionsHistory.artifactSubscriptionsHistory.artifactSubscriptionJson;
    }

    @Override
    public List<Subscription> listForUser(String userLogin) throws DataStoreIOException {
        SQLQuery query = (SQLQuery)this.buildBaseSelectQuery().where((Predicate)QArtifactSubscriptions.artifactSubscriptions.artifactSubscriptionUserLogin.eq((Object)userLogin));
        try {
            return this.querydslJdbcTemplate.query(query, this.subscriptionsRowMapper);
        }
        catch (DataAccessException e) {
            logger.error((Object)"Cannot reach Dataiku Govern database", (Throwable)e);
            throw new DataStoreIOException("Cannot reach Dataiku Govern database", (Throwable)e);
        }
    }

    @Override
    public List<Subscription> listForArtifact(String artifactId) throws DataStoreIOException {
        SQLQuery query = (SQLQuery)this.buildBaseSelectQuery().where((Predicate)QArtifactSubscriptions.artifactSubscriptions.artifactSubscriptionArtifactId.eq((Object)artifactId));
        try {
            return this.querydslJdbcTemplate.query(query, this.subscriptionsRowMapper);
        }
        catch (DataAccessException e) {
            logger.error((Object)"Cannot reach Dataiku Govern database", (Throwable)e);
            throw new DataStoreIOException("Cannot reach Dataiku Govern database", (Throwable)e);
        }
    }

    @Override
    public List<Subscription> listForArtifacts(List<String> artifactIds) throws DataStoreIOException {
        SQLQuery query = (SQLQuery)this.buildBaseSelectQuery().where((Predicate)QArtifactSubscriptions.artifactSubscriptions.artifactSubscriptionArtifactId.in(artifactIds));
        try {
            return this.querydslJdbcTemplate.query(query, this.subscriptionsRowMapper);
        }
        catch (DataAccessException e) {
            logger.error((Object)"Cannot reach Dataiku Govern database", (Throwable)e);
            throw new DataStoreIOException("Cannot reach Dataiku Govern database", (Throwable)e);
        }
    }

    @Override
    public List<Subscription> listForUserAndArtifacts(String userLogin, List<String> artifactIds) throws DataStoreIOException {
        SQLQuery query = (SQLQuery)this.buildBaseSelectQuery().where((Predicate)QArtifactSubscriptions.artifactSubscriptions.artifactSubscriptionUserLogin.eq((Object)userLogin).and((Predicate)QArtifactSubscriptions.artifactSubscriptions.artifactSubscriptionArtifactId.in(artifactIds)));
        try {
            return this.querydslJdbcTemplate.query(query, this.subscriptionsRowMapper);
        }
        catch (DataAccessException e) {
            logger.error((Object)"Cannot reach Dataiku Govern database", (Throwable)e);
            throw new DataStoreIOException("Cannot reach Dataiku Govern database", (Throwable)e);
        }
    }

    @Override
    public void lockByArtifact(String artifactId) throws DataStoreIOException {
        try {
            SQLQuery query = (SQLQuery)((SQLQuery)((SQLQuery)this.sqlQueryFactory.select(Expressions.constant((Object)1)).from((Expression)QArtifactSubscriptions.artifactSubscriptions)).where((Predicate)QArtifactSubscriptions.artifactSubscriptions.artifactSubscriptionArtifactId.eq((Object)artifactId))).forUpdate();
            this.querydslJdbcTemplate.queryForList(query);
        }
        catch (DataAccessException e) {
            logger.error((Object)"Cannot reach Dataiku Govern database", (Throwable)e);
            throw new DataStoreIOException("Cannot reach Dataiku Govern database", (Throwable)e);
        }
    }
}

