/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.security.ldap;

import com.dataiku.dip.security.ldap.LDAPConnectionFactory;
import com.dataiku.dip.security.ldap.LdapCredentialsAuthenticatorAndSupplier;
import com.dataiku.dip.server.services.licensing.DkuLicenseEnforcementService;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.gh.ApplicationConfigurator;
import com.dataiku.gh.dao.GeneralSettingsDAO;
import com.dataiku.gh.server.services.PubSubService;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GHLdapCredentialsAuthenticatorAndSupplier
extends LdapCredentialsAuthenticatorAndSupplier {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.auth");

    @Autowired
    public GHLdapCredentialsAuthenticatorAndSupplier(LDAPConnectionFactory ldapConnectionFactory, DkuLicenseEnforcementService licenseEnforcementService, GeneralSettingsDAO generalSettingsDao, PubSubService pubSubService) {
        super(ldapConnectionFactory, licenseEnforcementService);
        this.ldapSettings = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN().ldapSettings;
        pubSubService.subscribe("general-settings-changed", evt -> {
            try {
                GeneralSettingsDAO.GeneralSettings generalSettings = generalSettingsDao.getUnsafeAutoTXN();
                this.ldapSettings = generalSettings.ldapSettings;
            }
            catch (IOException e) {
                logger.error((Object)"Could not reload modified general settings", (Throwable)e);
            }
        });
    }
}

