/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.server.api.admin;

import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.api.PublicAPIControllerBase;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.gh.activity.GlobalUsageSummaryBuilder;
import com.dataiku.gh.security.IPermissionsService;
import com.dataiku.gh.security.auth.MetaAuthService;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class PublicAPIMonitoringController
extends PublicAPIControllerBase {
    @Autowired
    private MetaAuthService authService;
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private TransactionService transactionService;

    @AuditedCall(value={"msgType", "monitoring-global-usage"})
    @RequestMapping(value={"/publicapi/admin/monitoring/global-usage-summary"}, method={RequestMethod.GET})
    public void getGlobalUsageSummary(HttpServletRequest req, HttpServletResponse resp, @RequestParam(required=false, defaultValue="false") boolean withPerProject) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkAdmin(authCtx);
        }
        try {
            PublicAPIMonitoringController.writeJSON((HttpServletResponse)resp, (Object)new GlobalUsageSummaryBuilder().buildGlobalSummary(withPerProject));
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to build global report", (Throwable)e);
            throw e;
        }
    }
}

