/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.server.controllers;

import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.controllers.AuditNotNeeded;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.Id;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import com.dataiku.gh.security.auth.UIAuthService;
import com.dataiku.gh.server.services.ImageService;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.mutable.MutableLong;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class ImageController
extends DIPInternalControllerBase {
    @Autowired
    ImageService service;
    @Autowired
    UIAuthService authService;
    @Autowired
    TransactionService transactionService;

    @AuditNotNeeded
    @RequestMapping(value={"/api/image/set-image"})
    public void setTotem(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String type, @RequestParam String id, @RequestParam String dataUrl) throws IOException, DKUSecurityException {
        if (StringUtils.isBlank((String)projectKey) || "undefined".equals(projectKey)) {
            projectKey = null;
        }
        try (RWTransaction t = this.transactionService.beginWriteForUI(req, false);){
            AuthCtx u = this.authService.getMandatoryUser(req);
            if ("USER".equals(type)) {
                if (!u.isAdmin() && !u.getAssociatedDSSUser().equals(id)) {
                    throw new DKUSecurityException("You are not allowed to change another user's image");
                }
            } else {
                throw new IllegalArgumentException("Failed to check permissions with type=" + type + "; projectKey=" + projectKey);
            }
            String encodingPrefix = "base64,";
            int contentStartIndex = dataUrl.indexOf(encodingPrefix) + encodingPrefix.length();
            byte[] imageData = Base64.decodeBase64((String)dataUrl.substring(contentStartIndex));
            this.service.setImage(projectKey, type, id, imageData);
            ImageController.writeJSON((HttpServletResponse)resp, (Object)new Id(id));
            t.commit("Updated image for " + type + " " + id);
        }
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/image/remove-image"})
    public void removeTotem(HttpServletRequest req, HttpServletResponse resp, @RequestParam(value="projectKey", required=false) String projectKey, @RequestParam String type, @RequestParam String id) throws IOException, DKUSecurityException {
        if (StringUtils.isBlank((String)projectKey) || "undefined".equals(projectKey)) {
            projectKey = null;
        }
        try (RWTransaction t = this.transactionService.beginWriteForUI(req, true);){
            AuthCtx u = this.authService.getMandatoryUserNoXSRF(req);
            if ("USER".equals(type)) {
                if (!u.isAdmin() && !u.getAssociatedDSSUser().equals(id)) {
                    throw new DKUSecurityException("You are not allowed to remove another user's image");
                }
            } else {
                throw new IllegalArgumentException("Failed to check permissions with type=" + type + "; projectKey=" + projectKey);
            }
            this.service.removeImage(projectKey, type, id);
            if ("USER".equals(type)) {
                t.commit("Removed image for user " + id);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AuditNotNeeded
    @RequestMapping(value={"/api/image/get-image"})
    public void anyTotem(HttpServletRequest req, HttpServletResponse resp, @RequestParam(value="size", required=false) String requestedSize, @RequestParam(value="projectKey", required=false) String projectKey, @RequestParam(value="type", required=true) String type, @RequestParam(value="id", required=true) String id, @RequestParam(value="hash", required=false) String hash, @RequestParam(value="color", required=false) String color, @RequestParam(value="pattern", required=false) Integer pattern, @RequestParam(value="initials", required=false) String initials, @RequestParam(value="dashboardId", required=false) String dashboardId) throws IOException, DKUSecurityException {
        InputStream picData;
        MutableLong lastModified;
        long ifModifiedSince;
        if (StringUtils.isBlank((String)projectKey) || "undefined".equals(projectKey)) {
            projectKey = null;
        }
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx u = this.authService.getMandatoryUserNoXSRF(req);
            ifModifiedSince = req.getDateHeader("If-Modified-Since");
            lastModified = new MutableLong();
            picData = this.service.getImage(projectKey, type, id, requestedSize, lastModified, color, pattern, initials);
        }
        if (picData == null) {
            resp.setStatus(404);
            return;
        }
        resp.setDateHeader("Last-Modified", lastModified.longValue());
        resp.setContentType("image/png");
        if (StringUtils.isBlank((String)hash) || "undefined".equals(hash)) {
            resp.addDateHeader("Expires", System.currentTimeMillis() + 60000L);
        } else {
            resp.addDateHeader("Expires", System.currentTimeMillis() + 86400000L);
        }
        try {
            if (lastModified.longValue() <= ifModifiedSince) {
                resp.setStatus(304);
            } else {
                IOUtils.copy((InputStream)picData, (OutputStream)resp.getOutputStream());
            }
        }
        finally {
            picData.close();
        }
    }
}

