/*
 * Decompiled with CFR 0.152.
 */
package com.treasuredata.client.model;

import com.dataiku.dss.shadelibtd.com.fasterxml.jackson.databind.node.ObjectNode;
import com.treasuredata.client.model.TDJob;
import com.treasuredata.client.model.TDJobRequestBuilder;
import java.util.Optional;

public class TDJobRequest {
    private final String database;
    private final TDJob.Type type;
    private final String query;
    private final TDJob.Priority priority;
    private final Optional<String> resultOutput;
    private final Optional<Integer> retryLimit;
    private final Optional<String> poolName;
    private final Optional<String> table;
    private final Optional<ObjectNode> config;
    private final Optional<Long> scheduledTime;
    private final Optional<String> domainKey;
    private final Optional<Long> resultConnectionId;
    private final Optional<String> resultConnectionSettings;
    private final Optional<TDJob.EngineVersion> engineVersion;

    @Deprecated
    public TDJobRequest(String database, TDJob.Type type, String query, TDJob.Priority priority, Optional<String> resultOutput, Optional<Integer> retryLimit, Optional<String> poolName, Optional<String> table, Optional<ObjectNode> config) {
        this.database = database;
        this.type = type;
        this.query = query;
        this.priority = priority;
        this.resultOutput = resultOutput;
        this.retryLimit = retryLimit;
        this.poolName = poolName;
        this.table = table;
        this.config = config;
        this.scheduledTime = Optional.empty();
        this.domainKey = Optional.empty();
        this.resultConnectionId = Optional.empty();
        this.resultConnectionSettings = Optional.empty();
        this.engineVersion = Optional.empty();
    }

    private TDJobRequest(TDJobRequestBuilder builder) {
        this.database = builder.getDatabase();
        this.type = builder.getType();
        this.query = builder.getQuery();
        this.priority = builder.getPriority();
        this.resultOutput = builder.getResultOutput();
        this.retryLimit = builder.getRetryLimit();
        this.poolName = builder.getPoolName();
        this.table = builder.getTable();
        this.config = builder.getConfig();
        this.scheduledTime = builder.getScheduledTime();
        this.domainKey = builder.getDomainKey();
        this.resultConnectionId = builder.getResultConnectionId();
        this.resultConnectionSettings = builder.getResultConnectionSettings();
        this.engineVersion = builder.getEngineVersion();
    }

    public static TDJobRequest newPrestoQuery(String database, String query) {
        return new TDJobRequestBuilder().setType(TDJob.Type.PRESTO).setDatabase(database).setQuery(query).createTDJobRequest();
    }

    public static TDJobRequest newPrestoQuery(String database, String query, String resultOutput) {
        return new TDJobRequestBuilder().setType(TDJob.Type.PRESTO).setDatabase(database).setQuery(query).setResultOutput(resultOutput).createTDJobRequest();
    }

    public static TDJobRequest newPrestoQuery(String database, String query, String resultOutput, String poolName) {
        return new TDJobRequestBuilder().setType(TDJob.Type.PRESTO).setDatabase(database).setQuery(query).setResultOutput(resultOutput).setPoolName(poolName).createTDJobRequest();
    }

    public static TDJobRequest newHiveQuery(String database, String query) {
        return new TDJobRequestBuilder().setType(TDJob.Type.HIVE).setDatabase(database).setQuery(query).createTDJobRequest();
    }

    public static TDJobRequest newHiveQuery(String database, String query, String resultOutput) {
        return new TDJobRequestBuilder().setType(TDJob.Type.HIVE).setDatabase(database).setQuery(query).setResultOutput(resultOutput).createTDJobRequest();
    }

    public static TDJobRequest newHiveQuery(String database, String query, String resultOutput, String poolName) {
        return new TDJobRequestBuilder().setType(TDJob.Type.HIVE).setDatabase(database).setQuery(query).setResultOutput(resultOutput).setPoolName(poolName).createTDJobRequest();
    }

    public static TDJobRequest newPigQuery(String database, String query) {
        return new TDJobRequestBuilder().setType(TDJob.Type.PIG).setDatabase(database).setQuery(query).createTDJobRequest();
    }

    public static TDJobRequest newPigQuery(String database, String query, String resultOutput) {
        return new TDJobRequestBuilder().setType(TDJob.Type.PIG).setDatabase(database).setQuery(query).setResultOutput(resultOutput).createTDJobRequest();
    }

    public static TDJobRequest newPigQuery(String database, String query, String resultOutput, String poolName) {
        return new TDJobRequestBuilder().setType(TDJob.Type.PIG).setDatabase(database).setQuery(query).setResultOutput(resultOutput).setPoolName(poolName).createTDJobRequest();
    }

    public static TDJobRequest newBulkLoad(String database, String table, ObjectNode config) {
        return new TDJobRequestBuilder().setType(TDJob.Type.BULKLOAD).setDatabase(database).setTable(table).setConfig(config).setQuery("").createTDJobRequest();
    }

    public String getDatabase() {
        return this.database;
    }

    public Optional<String> getTable() {
        return this.table;
    }

    public TDJob.Type getType() {
        return this.type;
    }

    public String getQuery() {
        return this.query;
    }

    public TDJob.Priority getPriority() {
        return this.priority;
    }

    public Optional<Integer> getRetryLimit() {
        return this.retryLimit;
    }

    public Optional<String> getResultOutput() {
        return this.resultOutput;
    }

    public Optional<String> getPoolName() {
        return this.poolName;
    }

    public Optional<ObjectNode> getConfig() {
        return this.config;
    }

    public Optional<Long> getScheduledTime() {
        return this.scheduledTime;
    }

    public Optional<String> getDomainKey() {
        return this.domainKey;
    }

    public Optional<Long> getResultConnectionId() {
        return this.resultConnectionId;
    }

    public Optional<String> getResultConnectionSettings() {
        return this.resultConnectionSettings;
    }

    public Optional<TDJob.EngineVersion> getEngineVersion() {
        return this.engineVersion;
    }

    static TDJobRequest of(TDJobRequestBuilder builder) {
        return new TDJobRequest(builder);
    }

    public String toString() {
        return "TDJobRequest{database='" + this.database + '\'' + ", type=" + (Object)((Object)this.type) + ", query='" + this.query + '\'' + ", priority=" + (Object)((Object)this.priority) + ", resultOutput=" + this.resultOutput + ", retryLimit=" + this.retryLimit + ", poolName=" + this.poolName + ", table=" + this.table + ", config=" + this.config + ", scheduledTime=" + this.scheduledTime + ", domainKey=" + this.domainKey + ", resultConnectionId=" + this.resultConnectionId + ", resultConnectionSettings=" + this.resultConnectionSettings + ", engineVersion=" + this.engineVersion + '}';
    }
}

