/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.hive.shims;

import com.dataiku.dip.input.formats.hive.serde.DSSInspectionException;
import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import com.dataiku.dss.shadelib.org.joda.time.DateTimeZone;
import com.dataiku.dss.shadelib.org.joda.time.format.DateTimeFormatter;
import com.dataiku.dss.shadelib.org.joda.time.format.DateTimeFormatterBuilder;
import com.dataiku.dss.shadelib.org.joda.time.format.ISODateTimeFormat;
import org.apache.hadoop.hive.common.type.Timestamp;
import org.apache.hadoop.hive.serde2.io.TimestampWritableV2;
import org.apache.hadoop.hive.serde2.objectinspector.DSSBaseInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.JavaTimestampObjectInspector;

public class Hive3DSSTimestampObjectInspector
extends JavaTimestampObjectInspector
implements DSSBaseInspector {
    private static final DateTimeFormatter isoParser = ISODateTimeFormat.dateTimeParser().withZone(DateTimeZone.UTC);
    private static final DateTimeFormatter isoLocalParser = new DateTimeFormatterBuilder().append(ISODateTimeFormat.date()).appendLiteral(" ").append(ISODateTimeFormat.hourMinuteSecond()).appendOptional(new DateTimeFormatterBuilder().appendLiteral('.').appendFractionOfSecond(3, 9).toParser()).toFormatter().withZone(DateTimeZone.UTC);
    private DSSBaseInspector parent;

    public DSSBaseInspector getParent() {
        return this.parent;
    }

    public void setParent(DSSBaseInspector parent) {
        this.parent = parent;
    }

    public TimestampWritableV2 getPrimitiveWritableObject(Object o) {
        return o == null ? null : new TimestampWritableV2(Hive3DSSTimestampObjectInspector.asTimestampInternal(this, o));
    }

    public Timestamp getPrimitiveJavaObject(Object o) {
        return o == null ? null : Hive3DSSTimestampObjectInspector.asTimestampInternal(this, o);
    }

    static Timestamp asTimestampInternal(DSSBaseInspector asAnotherInspector, Object o) {
        if (o instanceof Timestamp) {
            return (Timestamp)o;
        }
        if (o instanceof String) {
            try {
                DateTime dt = isoParser.parseDateTime((String)o);
                return Timestamp.ofEpochMilli((long)dt.getMillis());
            }
            catch (IllegalArgumentException e) {
                RuntimeException enhancedException = new RuntimeException("Failed to parse DSS datetime with tz. " + e.getMessage(), e);
                throw new DSSInspectionException(asAnotherInspector, (Throwable)enhancedException);
            }
        }
        if (o == null) {
            throw new DSSInspectionException(asAnotherInspector, "Cannot be null here", null);
        }
        throw new RuntimeException("Unsupported convertion from " + o.getClass().getSimpleName() + " to Timestamp, should be a DSS datetime with tz", null);
    }

    static Timestamp asLocalTimestampInternal(DSSBaseInspector asAnotherInspector, Object o) {
        if (o instanceof Timestamp) {
            return (Timestamp)o;
        }
        if (o instanceof String) {
            try {
                DateTime dt = isoLocalParser.parseDateTime((String)o);
                return Timestamp.ofEpochMilli((long)dt.getMillis());
            }
            catch (IllegalArgumentException e) {
                RuntimeException enhancedException = new RuntimeException("Failed to parse DSS datetime no tz. " + e.getMessage(), e);
                throw new DSSInspectionException(asAnotherInspector, (Throwable)enhancedException);
            }
        }
        if (o == null) {
            throw new DSSInspectionException(asAnotherInspector, "Cannot be null here", null);
        }
        throw new RuntimeException("Unsupported convertion from " + o.getClass().getSimpleName() + " to Timestamp, should be a DSS datetime no tz", null);
    }
}

