/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.jdbc.jdbc41;

import com.databricks.client.dsi.dataengine.interfaces.IDataEngine;
import com.databricks.client.dsi.dataengine.interfaces.IResultSet;
import com.databricks.client.dsi.dataengine.utilities.MetadataSourceID;
import com.databricks.client.dsi.dataengine.utilities.OrderType;
import com.databricks.client.exceptions.ExceptionConverter;
import com.databricks.client.jdbc.common.SConnection;
import com.databricks.client.jdbc.common.SDatabaseMetaData;
import com.databricks.client.jdbc.jdbc41.S41MetaDataProxy;
import com.databricks.client.support.ILogger;
import com.databricks.client.support.LogUtilities;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class S41DatabaseMetaData
extends SDatabaseMetaData {
    private static final int JDBC_MINOR_VERSION = 1;

    public S41DatabaseMetaData(SConnection sConnection, ILogger iLogger) throws SQLException {
        super(sConnection, iLogger);
    }

    @Override
    protected synchronized ResultSet createMetaDataResult(MetadataSourceID metadataSourceID, List<String> list) throws SQLException {
        try {
            IResultSet iResultSet = ((IDataEngine)this.m_dataEngine).makeNewMetadataResult(metadataSourceID, (ArrayList)list, this.getSearchStringEscape(), this.getIdentifierQuoteString(), false, OrderType.JDBC_41);
            S41MetaDataProxy s41MetaDataProxy = new S41MetaDataProxy(this, iResultSet, metadataSourceID, this.m_logger);
            this.m_resultSets.add(s41MetaDataProxy);
            return s41MetaDataProxy;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener);
        }
    }

    @Override
    protected synchronized ResultSet createNullMetaDataResult(MetadataSourceID metadataSourceID) throws SQLException {
        try {
            S41MetaDataProxy s41MetaDataProxy = new S41MetaDataProxy(this, null, metadataSourceID, this.m_logger);
            this.m_resultSets.add(s41MetaDataProxy);
            return s41MetaDataProxy;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener);
        }
    }

    @Override
    protected synchronized ResultSet createUnorderedMetaDataResult(MetadataSourceID metadataSourceID, List<String> list) throws SQLException {
        try {
            IResultSet iResultSet = ((IDataEngine)this.m_dataEngine).makeNewMetadataResult(metadataSourceID, (ArrayList)list, this.getSearchStringEscape(), this.getIdentifierQuoteString(), false, OrderType.NONE);
            S41MetaDataProxy s41MetaDataProxy = new S41MetaDataProxy(this, iResultSet, metadataSourceID, this.m_logger);
            this.m_resultSets.add(s41MetaDataProxy);
            return s41MetaDataProxy;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener);
        }
    }

    @Override
    public int getJDBCMinorVersion() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            return 1;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public ResultSet getPseudoColumns(String string, String string2, String string3, String string4) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, string, string2, string3, string4);
            this.checkParentConnection();
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(string);
            arrayList.add(string2);
            arrayList.add(string3);
            arrayList.add(string4);
            return this.createMetaDataResult(MetadataSourceID.PSEUDO_COLUMNS_JDBC41, arrayList);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean generatedKeyAlwaysReturned() throws SQLException {
        return false;
    }
}

