/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.jdbc.utils;

import com.databricks.client.jdbc.core.DSDriver;
import com.databricks.client.jdbc.exceptions.CommonJDBCMessageKey;
import com.databricks.client.jdbc.utils.DSEncryptionProperties;
import com.databricks.client.support.ILogger;
import com.databricks.client.support.LogUtilities;
import com.databricks.client.support.exceptions.ErrorException;
import java.io.UnsupportedEncodingException;
import java.util.Base64;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;

public final class DSEncryptionUtils {
    public static String DecryptFromHex(String string, DSEncryptionProperties dSEncryptionProperties, ILogger iLogger) throws ErrorException {
        LogUtilities.logFunctionEntrance(iLogger, new Object[0]);
        try {
            return new String(dSEncryptionProperties.m_aesCipher_decrypt.doFinal(Base64.getDecoder().decode(string)));
        }
        catch (BadPaddingException | IllegalBlockSizeException generalSecurityException) {
            ErrorException errorException = DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.CACHE_ENCRYPTION_OPERATION_ERROR.name(), generalSecurityException.getMessage(), generalSecurityException.getCause());
            throw errorException;
        }
    }

    public static String EncryptFromHex(String string, DSEncryptionProperties dSEncryptionProperties, ILogger iLogger) throws ErrorException {
        LogUtilities.logFunctionEntrance(iLogger, new Object[0]);
        try {
            return Base64.getEncoder().encodeToString(dSEncryptionProperties.m_aesCipher_encrypt.doFinal(string.getBytes("UTF-8")));
        }
        catch (UnsupportedEncodingException | BadPaddingException | IllegalBlockSizeException exception) {
            ErrorException errorException = DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.CACHE_ENCRYPTION_OPERATION_ERROR.name(), exception.getMessage(), exception.getCause());
            throw errorException;
        }
    }
}

