/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.ml.prediction.overrides;

import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.Processor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.stream.Collectors;

public class ReadOnlyColumnFactory
implements ColumnFactory,
Serializable {
    private final LinkedHashMap<String, ReadOnlyColumn> orderedColumnsMap;

    public ReadOnlyColumnFactory(String[] columns) {
        this.orderedColumnsMap = Arrays.stream(columns).collect(Collectors.toMap(c -> c, ReadOnlyColumn::new, (x, y) -> y, LinkedHashMap::new));
    }

    @Override
    public Column column(String name) {
        Column column = this.getColumn(name);
        if (column == null) {
            throw new UnsupportedOperationException("Cannot create column");
        }
        return column;
    }

    @Override
    public Column column(String name, Processor.ProcessorRole role) {
        return this.column(name);
    }

    @Override
    public Column getColumn(String name) {
        return this.orderedColumnsMap.get(name);
    }

    @Override
    public Column columnAfter(String before, String after) {
        throw new UnsupportedOperationException("Cannot create column");
    }

    @Override
    public Column columnAfter(String before, String after, Processor.ProcessorRole role) {
        throw new UnsupportedOperationException("Cannot create column");
    }

    @Override
    public Column columnBefore(String after, String newCol) {
        throw new UnsupportedOperationException("Cannot create column");
    }

    @Override
    public Column columnBefore(String after, String newCol, Processor.ProcessorRole role) {
        throw new UnsupportedOperationException("Cannot create column");
    }

    @Override
    public Column getColumnAfter(String current) {
        throw new UnsupportedOperationException("Cannot get column after");
    }

    @Override
    public void deleteColumn(String name) {
        throw new UnsupportedOperationException("Cannot delete column");
    }

    @Override
    public void moveAtStart(String name) {
        throw new UnsupportedOperationException("Cannot move column");
    }

    @Override
    public void moveAtEnd(String name) {
        throw new UnsupportedOperationException("Cannot move column");
    }

    @Override
    public void moveBefore(String after, String name) {
        throw new UnsupportedOperationException("Cannot move column");
    }

    @Override
    public void moveAfter(String before, String name) {
        throw new UnsupportedOperationException("Cannot move column");
    }

    @Override
    public Iterable<Column> columns() {
        return new ArrayList<Column>(this.orderedColumnsMap.values());
    }

    private static class ReadOnlyColumn
    extends Column
    implements Serializable {
        private final String name;

        ReadOnlyColumn(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Column setName(String name) {
            throw new UnsupportedOperationException("Cannot rename column");
        }
    }
}

