/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.fs;

import com.dataiku.dip.fs.FSPath;
import com.dataiku.dip.fs.FilesSelectionRule;
import com.dataiku.dip.fs.FilesSelectionRules;
import com.dataiku.dip.variables.VariablesContext;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class FSEnumerationSettings {
    public boolean showHiddenFiles = false;
    public boolean firstNonEmpty = false;
    public boolean forReadinessComputation = false;
    public long totalSizeLimit = -1L;
    public FilesSelectionRules selectionRules = new FilesSelectionRules();

    public static void expandSelectionRulesInPlace(FilesSelectionRules selectionRules, VariablesContext vc) {
        for (FilesSelectionRule rule : selectionRules.excludeRules) {
            if (rule.expr == null) continue;
            rule.expr = vc.expandAllowUnresolved(rule.expr);
        }
        for (FilesSelectionRule rule : selectionRules.includeRules) {
            if (rule.expr == null) continue;
            rule.expr = vc.expandAllowUnresolved(rule.expr);
        }
        if (selectionRules.explicitFiles.size() > 0) {
            selectionRules.explicitFiles = selectionRules.explicitFiles.stream().map(f -> vc.expandAllowUnresolved((String)f)).collect(Collectors.toList());
        }
    }

    public List<FSPath> filter(List<FSPath> paths) {
        ArrayList ret = Lists.newArrayList();
        long totalSize = 0L;
        for (FSPath path : paths) {
            if (!this.selectionRules.includes(path.path().substring(1))) continue;
            if (this.shouldStopEnumeration(ret, totalSize)) break;
            if (this.firstNonEmpty && path.getSize() <= 0L) continue;
            ret.add(path);
            totalSize += path.getSize();
        }
        return ret;
    }

    public boolean isValidPath(String path) {
        return this.selectionRules.includes(path.substring(1));
    }

    public boolean shouldStopEnumeration(List<FSPath> accumulatedPaths, long accumulatedSize) {
        if (this.firstNonEmpty && !accumulatedPaths.isEmpty()) {
            return true;
        }
        return this.totalSizeLimit >= 0L && accumulatedSize >= this.totalSizeLimit;
    }

    public FSEnumerationSettings withHiddenFiles() {
        this.showHiddenFiles = true;
        return this;
    }

    public static FSEnumerationSettings firstNotEmpty() {
        FSEnumerationSettings settings = new FSEnumerationSettings();
        settings.firstNonEmpty = true;
        return settings;
    }

    public static FSEnumerationSettings filesPrefixedBy(String prefixRegex) {
        FSEnumerationSettings settings = new FSEnumerationSettings();
        FilesSelectionRule onlyTmpFiles = new FilesSelectionRule();
        onlyTmpFiles.matchingMode = FilesSelectionRule.MatchingMode.FILENAME;
        onlyTmpFiles.mode = FilesSelectionRule.Mode.REGEXP;
        onlyTmpFiles.expr = prefixRegex;
        settings.selectionRules.includeRules.add(onlyTmpFiles);
        settings.firstNonEmpty = false;
        settings.selectionRules.mode = FilesSelectionRules.Mode.RULES_INCLUDED_ONLY;
        return settings;
    }
}

