/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.fs;

import java.util.Arrays;
import org.apache.commons.lang.StringUtils;

public class FilesSelectionRule {
    public static final String DEEP_WILDCARD_PATTERN = "(?<=^|/)\\*\\*(?=$|/)";
    public MatchingMode matchingMode = MatchingMode.FULL_PATH;
    public Mode mode = Mode.GLOB;
    public String expr;

    public PartialMatchResult matchesPartly(String dirPath) {
        String[] specs;
        boolean nextIsDeepWildcard;
        if (StringUtils.isBlank((String)this.expr)) {
            return PartialMatchResult.WILL_MATCH_ALL;
        }
        if (this.matchingMode != MatchingMode.FULL_PATH) {
            return PartialMatchResult.MAY_MATCH;
        }
        if (this.mode != Mode.GLOB) {
            return PartialMatchResult.MAY_MATCH;
        }
        if (FilesSelectionRule.globMatchesAll(this.expr)) {
            return PartialMatchResult.WILL_MATCH_ALL;
        }
        String[] globalSpecs = this.expr.replaceAll("/+", "/").replaceFirst("\\*\\*/\\*$", "**").split(DEEP_WILDCARD_PATTERN, 3);
        String prefixSpec = this.cleanupLeadingTrailing(globalSpecs[0]);
        if (prefixSpec.isEmpty()) {
            return PartialMatchResult.MAY_MATCH;
        }
        boolean bl = nextIsDeepWildcard = globalSpecs.length > 1;
        if (dirPath.startsWith("/")) {
            throw new IllegalArgumentException("Path must be relative, was " + dirPath);
        }
        if (dirPath.isEmpty()) {
            return PartialMatchResult.MAY_MATCH;
        }
        String[] chunks = dirPath.split("/+");
        if (chunks.length >= (specs = prefixSpec.split("/")).length && !nextIsDeepWildcard) {
            return PartialMatchResult.WONT_MATCH;
        }
        return this.matchesPartlyUsingChunks(globalSpecs, nextIsDeepWildcard, chunks, specs);
    }

    private PartialMatchResult matchesPartlyUsingChunks(String[] globalSpecs, boolean nextIsDeepWildcard, String[] chunks, String[] specs) {
        int i = 0;
        for (String spec : specs) {
            if (i >= chunks.length) {
                if (i + 1 == specs.length && "*".equals(spec)) {
                    return PartialMatchResult.WILL_MATCH_FILES;
                }
                return PartialMatchResult.MAY_MATCH;
            }
            if (!FilesSelectionRule.globChunkMatches(chunks[i], spec)) {
                return PartialMatchResult.WONT_MATCH;
            }
            ++i;
        }
        if (chunks.length >= specs.length) {
            if (!nextIsDeepWildcard) {
                return PartialMatchResult.WONT_MATCH;
            }
            if (globalSpecs.length == i + 1 && (globalSpecs[i].isEmpty() || "*".equals(globalSpecs[i]))) {
                return PartialMatchResult.WILL_MATCH_ALL;
            }
        }
        return PartialMatchResult.MAY_MATCH;
    }

    private String cleanupLeadingTrailing(String prefixSpec) {
        String cleanPrefixSpec = prefixSpec;
        if (cleanPrefixSpec.startsWith("/")) {
            cleanPrefixSpec = cleanPrefixSpec.substring(1);
        }
        if (cleanPrefixSpec.endsWith("/")) {
            cleanPrefixSpec = cleanPrefixSpec.substring(0, cleanPrefixSpec.length() - 1);
        }
        return cleanPrefixSpec;
    }

    public boolean matches(String path) {
        if (StringUtils.isBlank((String)this.expr)) {
            return true;
        }
        if (this.matchingMode == MatchingMode.FULL_PATH && this.mode == Mode.GLOB && FilesSelectionRule.globMatchesAll(this.expr)) {
            return true;
        }
        if (path.startsWith("/")) {
            throw new IllegalArgumentException("Path must be relative, was " + path);
        }
        Object regex = "";
        if (this.mode == Mode.REGEXP) {
            regex = "(?i)^(?:" + this.expr + ")$";
        }
        if (this.matchingMode == MatchingMode.FILENAME) {
            String fileName = path.substring(path.lastIndexOf(47) + 1);
            if (fileName.isEmpty()) {
                return false;
            }
            return this.mode == Mode.GLOB ? FilesSelectionRule.globChunkMatches(fileName, this.expr) : fileName.matches((String)regex);
        }
        if (this.mode == Mode.GLOB) {
            StringBuilder sb = new StringBuilder(this.expr.length());
            String[] specs = this.expr.replaceAll("/+", "/").split(DEEP_WILDCARD_PATTERN);
            if (this.expr.startsWith("**/")) {
                sb.append("(?:^|.*?/)");
                specs = Arrays.copyOfRange(specs, 1, specs.length);
                if (specs.length > 0) {
                    specs[0] = specs[0].substring(1);
                }
            }
            for (int i = 0; i < specs.length; ++i) {
                String spec = specs[i];
                if (i > 0) {
                    sb.append(".*?(?<=/)");
                    spec = spec.substring(1);
                }
                sb.append(spec.replaceAll("[.\\\\\\[\\]{}()|+$^]", "\\\\$0").replace("?", "[^/]").replace("*", "[^/]*?"));
            }
            if (this.expr.endsWith("/**")) {
                sb.append(".++");
            }
            regex = "(?i)^(?:" + sb.toString() + ")$";
        }
        String truncatedPath = path;
        while (truncatedPath.startsWith("/")) {
            truncatedPath = truncatedPath.substring(1);
        }
        return !truncatedPath.isEmpty() && truncatedPath.matches((String)regex);
    }

    static boolean globMatchesAll(String globExpr) {
        return StringUtils.isBlank((String)globExpr) || "**".equals(globExpr) || "**/*".equals(globExpr);
    }

    public static boolean globChunkMatches(String fileName, String globChunkSpec) {
        Object globChunk = globChunkSpec;
        globChunk = "(?i)^(?:" + ((String)globChunk).replaceAll("[.\\\\\\[\\]{}()|+$^]", "\\\\$0").replace("?", ".").replace("*", ".*?") + ")$";
        return fileName.matches((String)globChunk);
    }

    public static enum MatchingMode {
        FULL_PATH,
        FILENAME;

    }

    public static enum Mode {
        GLOB,
        REGEXP;

    }

    public static enum PartialMatchResult {
        WONT_MATCH(false),
        MAY_MATCH(true),
        WILL_MATCH_FILES(true),
        WILL_MATCH_ALL(true);

        public final boolean mayMatch;

        private PartialMatchResult(boolean mayMatch) {
            this.mayMatch = mayMatch;
        }
    }
}

