import json
import os


class Preprocessor:

    FILENAME = None  # To be defined for each preprocessor

    @classmethod
    def load_parameters(cls, resources_folder):
        filename = os.path.join(resources_folder, "{}.json".format(cls.FILENAME))
        parameters = None
        if os.path.isfile(filename):
            with open(filename) as f:
                parameters = json.load(f)
        return parameters

    def process(self, X_numeric, X_non_numeric):
        """X_numeric and X_non_numeric are generated by the PrepareInput.process method

        They are IndexMatrix defines in the prepare_input module see that module
        for further informations on how to use these.

        X_numeric is mutable and will be populated within each process call
        X_non_numeric is generally not modified.

        This method should return the altered X_numeric and X_non_numeric.
        """
        raise NotImplementedError("Preprocessor needs to implement a process method!")
