# encoding: utf-8
"""
Executor for containerized execution of python llm evaluation recipe.
"""

import logging, json

from dataiku.base.utils import ErrorMonitoringWrapper
from dataiku.container.runner import setup_log
from dataiku.container.runner import read_execution


if __name__ == "__main__":
    setup_log()
    execution = read_execution()
    execution_id = execution['id']

    with ErrorMonitoringWrapper():
        payload = json.loads(execution['payload'])

        logging.info("Running llm evaluation recipe main")
        if execution['type'] == 'RECIPE_LLM_EVALUATION_PYTHON':
            from dataiku.llm.evaluation.llm_evaluation_recipe import LLMEvaluationRecipe
            runner = LLMEvaluationRecipe.build(
                execution["executionPath"],
                payload.get("modelEvaluationFolder"),
                payload.get("inputDatasetSmartName"),
                payload.get("outputDatasetSmartName"),
                payload.get("metricsDatasetSmartName"),
                payload.get("ragasMaxWorkers")
            )
            runner.run()
        else:
            raise Exception("Unsupported llm eval recipe type: %s" % execution['type'])
