(function() {
    'use strict';

    angular.module('dataiku.dashboards').component('dashboardGridBackground', {
        bindings: {
            columnNumber: '<', // number
            backgroundColor: '<', // string
            gridColor: '<', // string
            tileSpacing: '<', // number
            cellWidth: '<', // number
            cellHeight: '<', // number
            padding: '<' // number
        },
        templateUrl: '/static/dataiku/js/dashboards/components/dashboard-grid-background/dashboard-grid-background.component.html',
        controller: function() {
            const ctrl = this;
            ctrl.patternId = _.uniqueId('grid-pattern-');
            ctrl.verticalLines = [];

            ctrl.$onChanges = function() {
                updateGrid();
            };

            function updateGrid() {
                const newVerticalLines = [];
                if (ctrl.padding != null && ctrl.padding > 0) {
                    const x = ctrl.padding / 2;
                    newVerticalLines.push({
                        x1: x,
                        y1: 0,
                        x2: x,
                        y2: '100%',
                        strokeWidth: ctrl.padding
                    });
                }
                for (let i = 1; i < ctrl.columnNumber; i++) {
                    const x = i * ctrl.cellWidth + ctrl.padding - ctrl.tileSpacing / 2;
                    newVerticalLines.push({
                        x1: x,
                        y1: 0,
                        x2: x,
                        y2: '100%',
                        strokeWidth: ctrl.tileSpacing || 0.5
                    });
                }

                if (ctrl.padding != null && ctrl.padding > 0) {
                    const x = ctrl.columnNumber * ctrl.cellWidth + ctrl.padding / 2;
                    newVerticalLines.push({
                        x1: x,
                        y1: 0,
                        x2: x,
                        y2: '100%',
                        strokeWidth: ctrl.padding
                    });
                }

                ctrl.verticalLines = newVerticalLines;
                ctrl.gridWidth = ctrl.columnNumber * ctrl.cellWidth + ctrl.padding * 2 - ctrl.tileSpacing;
            }
        }
    });
})();
