/* Various controller fragments */
/* eslint-disable no-unused-vars, no-redeclare */
 function addDatasetUniquenessCheck($scope, DataikuAPI, projectKey) {
    DataikuAPI.datasets.listNames(projectKey).success(function(data) {
        $scope.datasets_names = data;
    });
    DataikuAPI.streamingEndpoints.listNames(projectKey).success(function(data) {
        $scope.streamingEndpoints_names = data;
    });

    let unicityCheck = function(value) {
        if ($scope.datasets_names) {
            for(let k in $scope.datasets_names) {
                let ds = $scope.datasets_names[k];
                if((ds||'').toLowerCase()===(value||'').toLowerCase()) {
                    return false;
                }
            }
        }
        if ($scope.streamingEndpoints_names) {
            for(let k in $scope.streamingEndpoints_names) {
                let ds = $scope.streamingEndpoints_names[k];
                if((ds||'').toLowerCase()===(value||'').toLowerCase()) {
                    return false;
                }
            }
        }
        return true;
    };
    $scope.isDatasetNameUnique = unicityCheck;
    $scope.isStreamingEndpointNameUnique = unicityCheck;
}

/* Mapping Code Mirror Editor Option Mode to language name */

function computeCodeMirrorMode(snippetType) {
	switch(snippetType) {
	    case 'jl':
	    case 'julia':
            return 'text/x-julia';
        case 'py':
	    case 'python':
            return 'text/x-python';
	    case 'pig':
	        return 'text/x-dkupig';
	    case 'R':
	        return 'text/x-rsrc';
	    case 'scala':
	    	return 'text/x-scala';
	    case 'shell':
	    	return 'text/x-sh';
	    case 'hive':
	    case 'impala':
	        return 'text/x-hivesql';
	    case 'sql':
	        return 'text/x-sql2';
	    case 'json':
	        return 'application/json';
	    case 'html':
	        return 'application/xml';
	    case 'css':
	        return 'text/css';
	    case 'javascript':
        case 'js':
	        return 'text/javascript';
	    default:
            return 'text/plain'
	}
}

function getDefaultConnection(list, cur, wantSQL, wantHDFS) {
    if (cur) return cur;
    if (list != null && list.length > 0) {
        if (wantSQL) {
            for (var i in list) {
                if (list[i].sql) return list[i].connection;
            }
        } else if (wantHDFS) {
            for (var i in list) {
                if (list[i].type == "HDFS") return list[i].connection;
            }
        } else {
            for (var i in list) {
                if (list[i].connection == "filesystem_managed") {
                    return list[i].connection;
                }
            }
        }
        return list[0].connection;
    } else {
        return null;
    }
}

function fetchManagedDatasetConnections($scope, DataikuAPI) {
    return DataikuAPI.datasets.listManagedDatasetConnections().success(function(data) {
        $scope.managedDatasetConnections = [];
        for (var i in data) {
            var c = data[i];
            $scope.managedDatasetConnections.push({"connection" : c.name, "type" : c.type, "sql" : c.sql, "label" : c.name + " (" + c.type + ")"});
        }
    }).error(setErrorInScope.bind($scope));
}


function filterSortLimitTagsAndQ($filter, list, query, sortOptions, max, customFilter) {
    if (list == null) {
        return {formatted : [], filtered : []};
    }
    var filtered = list;
    // Filter on tags
    if (query.tags){
    angular.forEach(query.tags, function(tag){
        filtered = $.grep(filtered, function(item){
            return item.tags && item.tags.indexOf(tag) >= 0;
        })
    })
    }
    // Filter on terms
    filtered = angular.element(document.body).injector().get('ListFilter').filter(filtered, query.q);
    // Custom filters
    if (typeof(customFilter) === "function") {
    	filtered = customFilter(filtered);
    }
    // sort
    var formatted = $filter('orderBy')(filtered, sortOptions.column, sortOptions.reverse);
    // limit
    formatted = formatted.slice(0, max);
    return {formatted : formatted, filtered : filtered};
}

;
(function() {
    'use strict';

    const app = angular.module('dataiku', [
        'angular-blocks',
        'dataiku.constants',
        'dataiku.credentials',
        'dataiku.controllers',
        'dataiku.constants',
        'dataiku.services',
        'dataiku.logger',
        'dataiku.charts',

        'dataiku.common.func',
        'dataiku.common.nav',
        'dataiku.common.build',
        'dataiku.common.datastructures',
        'dataiku.common.lists',
        'dataiku.common.pictures',
        'dataiku.common.sampling',

        'dataiku.shaker',
        'dataiku.shaker.analyse',
        'dataiku.shaker.table',
        'dataiku.shaker.misc',
        'dataiku.shaker.library',

        'dataiku.export.services',

        'dataiku.directives.bootstrap',
        'dataiku.directives.dip',
        'dataiku.directives.styling',
        'dataiku.directives.widgets',
        'dataiku.directives.forms',
        'dataiku.directives.snippetEditor',
        'dataiku.directives.scope',
        'dataiku.widgets.futures',
        'dataiku.widgets.integrations',
        'dataiku.widgets.drawers',
        'dataiku.widgets.tageditfield',

        'dataiku.filters',

        'dataiku.meanings',

        'dataiku.taggableobjects',

        'dataiku.notebooks.sql',
        'dataiku.notebooks.search',
        'dataiku.rstudioserverembed',

        'dataiku.llm',
        'dataiku.promptstudios',
        'dataiku.agents',
        'dataiku.agenttools',
        'dataiku.retrieval-augmented-llm',

        'dataiku.projects.settings',
        'dataiku.projects.actions',
        'dataiku.projects.directives',

        'dataiku.personal-home.directives',

        'dataiku.connections',

        'dataiku.datasets',
        'dataiku.datasets.custom',
        'dataiku.datasets.directives',
        'dataiku.datasets.foreign',
        'dataiku.datasets.partitioning',

        'dataiku.dashboards',
        'dataiku.dashboards.insights',

        'dataiku.webapps',
        'dataiku.report',

        'dataiku.admin.code-studios',
        'dataiku.code-studios',

        'dataiku.metrics.core',
        'dataiku.metrics.views',
        'dataiku.metrics.savedmodels.views',
        'dataiku.metrics.edit',

        'dataiku.flow.graph',
        'dataiku.flow.tools',
        'dataiku.flow.project',
        'dataiku.flow.runtime',

        'dataiku.recipes',
        'dataiku.recipes.customcode',
        'dataiku.directives.insights',
        'dataiku.directives.simple_report',
        'dataiku.filters',


        'dataiku.admin',
        'dataiku.admin.config',
        'dataiku.admin.codeenvs.common',
        'dataiku.admin.codeenvs.automation',
        'dataiku.admin.codeenvs.design',
        'dataiku.admin.security',
        'dataiku.admin.maintenance',
        'dataiku.admin.monitoring',
        'dataiku.admin.clusters',
        'dataiku.admin.alertMessageBanner',
        'dataiku.admin.globalApiKeyInput',
        'dataiku.admin.charts_dashboards',
        'dataiku.admin.stories_themes',

        'dataiku.plugins',
        'dataiku.plugindev',
        'dataiku.folder_edit',
        'dataiku.catalog',
        'dataiku.deployer',
        'dataiku.apideployer',
        'dataiku.projectdeployer',

        'dataiku.unified-monitoring',

        /* ML (shared between analysis, saved model and insight) */
        'dataiku.ml.core',
        'dataiku.ml.predicted',
        'dataiku.ml.report',
        'dataiku.ml.explainability',
        'dataiku.ml.hyperparameters',
        'dataiku.ml.gpuexecution',

        'dataiku.analysis.core',
        'dataiku.analysis.script',
        'dataiku.analysis.mlcore',

        'dataiku.savedmodels',
        'dataiku.modelevaluationstores',
        'dataiku.modelcomparisons',
        'dataiku.experimenttracking',
        'dataiku.managedfolder',
        'dataiku.retrievableknowledge',

        'dataiku.labeling',

        /* Streaming endpoints */
        'dataiku.streaming-endpoints',

        'dataiku.scenarios',
        'dataiku.continuous-activities',
        'dataiku.monitoring',
        'dataiku.runnables',

        'dataiku.lambda',

        'dataiku.collab.timeline',
        'dataiku.collab.discussions',
        'dataiku.collab.wikis',
        'dataiku.git',

        'dataiku.bundles.common',
        'dataiku.bundles.design',
        'dataiku.bundles.automation',

        'dkuSanitize',

        'dataiku.integrations.alation',

        'dataiku.ngXmigration',

        'dataiku.featurestore',

        /* Consumer workspaces */
        'dataiku.workspaces',

        /* Designer new filters */
        'dataiku.nestedFilters',

        /* Designer surveys */
        'dataiku.surveys',

        /* Designer Opals */
        'dataiku.opals',

        /* Designer auto feature generation */
        'dataiku.autoFeatureGeneration',

        /* Homepage */
        'dataiku.homepage',

        /* Designer AI assistants */
        'dataiku.aiExplanations',
        'dataiku.aiSqlGeneration',
        'dataiku.aiDatasetDescriptions',

        /* Schedule Scenario Modal */
        'dataiku.scheduleScenario',

        /* Homepage */
        'dataiku.homepage',

        /* Add dataset Workflow */
        'dataiku.addDatasetWorkflow',

        /* Processors */
        'dataiku.processors',

        /* Designer inbox */
        'dataiku.inbox',

        /* Widgets */
        'dataiku.widgets',

        /* Coloring */
        'dataiku.coloring',

        'dataiku.shared',

        /* Search notebooks */
        'dataiku.searchNotebooks',

        /* 3rd party */
        'ngRoute',
        'ngSanitize',
        'ui.sortable',
        'ui.tree',
        'ui.router',
        'ui.codemirror',
        'ui.keypress',
        'infinite-scroll',
        'platypus.utils',
        'ui-rangeSlider',
        'colorContrast',
        'LocalStorageModule',
        'monospaced.elastic',
        'checklist-model',
    '$strap',
    'pascalprecht.translate'
    ]);


    app.factory('dssInterceptor', function($location, $q, $rootScope, $httpParamSerializer) {
        return {
            'requestError': function(response) {
                const status = response.status;
                if (status == 401) {
                    /*Don't redirect to login on failed login :D */
                    if (response.config.url.indexOf("/api/login") >= 0) {
                        return $q.reject(response);
                    }
                    // It's not possible to inject $state here because of
                    // Uncaught Error: Circular dependency: $templateFactory <- $state <- $http <- $compile
                    // So we can't transition and have to refresh ...
                    if ($location.path() !== '/login/' && $location.path() !== '/login') {
                        $rootScope.$evalAsync('appConfig.loggedIn = false');
                        $location.url("/login/?redirectTo=" + $location.path() + "&search=" + $httpParamSerializer($location.search()));
                    } else {
                        return $q.reject(response);
                    }
                } else {
                    return $q.reject(response);
                }
            }
        };
    });

    // this doesn't redirect the children, it's just a shortcut to declare an abstract state for which all children are redirected with redirectState
    function redirectedAbstractState($stateProvider, fromState, url) {
        $stateProvider.state(fromState, {
            url,
            template: '<ui-view></ui-view>',
            abstract: true
        });
    }

    function redirectState($stateProvider, fromState, toState, fromUrl, passStateParams = false) {
        $stateProvider.state(fromState, {
            url: fromUrl,
            template: '<div ui-view></div>',
            controller: function($state, $stateParams, $timeout) {
                if ($state.current.name === fromState) {
                    // timeout() is needed so that the final state appears in the browser history
                    $timeout(() => $state.go(toState, passStateParams ? $stateParams : null, {location: 'replace'}));
                }
            }
        });
    }

    function declareRoutes($stateProvider,$urlRouterProvider, WorkspacesUIRouterStates, MLModelsUIRouterStates, InsightsUIRouterStates, GoToStateNameSuffixIfBase) {
        /* ************************* Top level routes ************************ */

        $stateProvider.state('root', {
            url: '/',
            templateUrl: '/templates/personal-home.html',
            controller: 'PersonalHomeController',
            pageTitle: () => {
                return "Home";
            }
        });
        $stateProvider.state('profile.ngx', {
            url: '/ngx-hello',
            template: '<ng2-downgrade-example></ng2-downgrade-example>'
        });
        $stateProvider.state('home', {
            url: '/home/',
            templateUrl: '/templates/personal-home.html',
            controller: 'PersonalHomeController',
            pageTitle: () => {
                return "Home";
            }
        });

        $stateProvider.state('wikis', {
            url: '/wikis/',
            params: {
                filterBy: undefined,
                standalone: true,
                row: 'wikis'
            },
            templateUrl: '/templates/wikis-home.html',
            controller: 'PersonalHomeController',
            pageTitle: () => {
                return "Wikis";
            }
        });

        $stateProvider.state('wikis.list', {
            url: 'list/',
            params: {
                filterBy: undefined,
                standalone: true,
                row: 'wikis'
            },
            templateUrl: '/templates/wikis-home.html',
            controller: 'PersonalHomeController',
            pageTitle: () => {
                return "Wikis";
            }
        });

        $stateProvider.state('home.expandedlist', {
            url: ':row/expandedlist',
            params: {
                filterBy: undefined
            },
            templateUrl: '/templates/personal-home.html',
            controller: 'PersonalHomeController',
            pageTitle: () => {
                return "Home expanded";
            }
        });

        $stateProvider.state('home.expandedmosaic', {
            url: ':row/expandedmosaic',
            params: {
                filterBy: undefined,
                standalone: undefined
            },
            templateUrl: '/templates/personal-home.html',
            controller: 'PersonalHomeController',
            pageTitle: () => {
                return "Home expanded mosaic";
            }
        });

        $stateProvider.state('project-list', {
            url: '/project-list/:folderId?forceDisplayMode',
            controller: 'ProjectsListController',
            templateUrl: '/templates/projects-list/projects-list.html',
            pageTitle: () => {
                return "Projects";
            }
        });

        $stateProvider.state('login', {
            url: '/login/?redirectTo&search',
            templateUrl: '/templates/login.html',
            controller: 'LoginController',
            pageTitle: () => {
                return "Login";
            }
        });

        $urlRouterProvider.when('/login', '/login/');

        $stateProvider.state('sso-error', {
            url: '/sso-error?error&errorDescription',
            templateUrl: '/templates/sso-error.html',
            controller: 'SSOErrorController',
            pageTitle: () => {
                return "SSO error";
            }
        });

        $stateProvider.state('logged-out', {
            url: '/logged-out',
            templateUrl: '/templates/logged-out.html',
            pageTitle: () => {
                return "Logged out";
            }
        });

        $stateProvider.state('feedback', {
            url: '/feedback/',
            templateUrl: '/templates/feedback.html'
        });

        $stateProvider.state("blackhole", {
            url: "/blackhole/"
        });

        $stateProvider.state('projects', {
            url: '/projects',
            abstract: true,
            template: '<div ui-view class="h100"></div>'
        });

        $stateProvider.state('dataquality', {
            url: '/data-quality',
            abstract: true,
            template: '<ng2-instance-data-quality-nav></ng2-instance-data-quality-nav><ui-view class="dss-page"></ui-view>',
            controller: function(TopNav) {
                TopNav.setLocation(TopNav.DSS_HOME, "dataquality");
            }
        });

        $stateProvider.state('dataquality.current-status', {
            url: '/',
            template: '<ng2-instance-status-panel></ng2-instance-status-panel>',
            pageTitle: () => {
                return "Instance - Data Quality";
            }
        });

        const dataQualityTemplatesPageTitle = () => "Data Quality Templates";

        $stateProvider.state('dataquality.templates', {
            url: '/templates',
            abstract: true,
            template: '<ui-view></ui-view>',
            pageTitle: dataQualityTemplatesPageTitle
        });

        $stateProvider.state('dataquality.templates.list', {
            url: '/',
            template: '<ng2-data-quality-templates></ng2-data-quality-templates>',
            pageTitle: dataQualityTemplatesPageTitle
        });

        $stateProvider.state('dataquality.templates.template', {
            url: '/:templateId',
            template: '<ng2-data-quality-template-edit-view [template-id]="$state.params.templateId"></ng2-data-quality-template-edit-view>',
            pageTitle: dataQualityTemplatesPageTitle
        });

        $stateProvider.state('dataquality.templates.template.new-rule', {
            url: '/new-rule',
            template: '<ng2-new-rule-panel id="new-rule-panel"></ng2-new-rule-panel>',
            pageTitle: dataQualityTemplatesPageTitle
        });

        $stateProvider.state('dataquality.templates.template.rule', {
            url: '/:ruleId',
            template: '<ng2-rule-edit [can-edit]="addToScope.canEdit" [rule-id]="$root.$state.params.ruleId"></ng2-rule-edit>',
            pageTitle: dataQualityTemplatesPageTitle
        });

        $stateProvider.state('jambon', {
            url: '/admin/jambon/',
            templateUrl: '/templates/widgets/image-uploader-dialog.html'
        });

        /* ************************** Home v2  ********************** */

        $stateProvider.state('homeV2', {
            url: '/home',
            abstract: true,
            template: '<div ui-view class="h100"></div>',
            controller: function(TopNav, $scope, $rootScope, $state) {
                TopNav.setLocation(TopNav.DSS_HOME);

                $scope.redirectForNoneProfile = $rootScope.appConfig.userProfile.profile === 'NONE' && $state.current.name !== 'homeV2.homepage';
                if ($scope.redirectForNoneProfile) {
                    $state.go('homeV2.homepage', null, {location: 'replace'});
                }
            }
        })

        $stateProvider.state('homeV2.homepage', {
            url: '/',
            templateUrl: '/templates/personal-home.html',
            pageTitle: () => {
                return "Home";
            }
        });

        $stateProvider.state('homeV2.projects', {
            url: '/projects/',
            template: '<ng2-projects-page [folder-id]="$root.$stateParams.folderId"></ng2-projects-page>',
            abstract: true,
        });

        $stateProvider.state('homeV2.projects.folder', {
            url: ':folderId',
            template: '',
            pageTitle: () => {
                return "Projects";
            }
        });

        $stateProvider.state('homeV2.applications', {
            url: '/applications',
            template: '<ng2-applications-page></ng2-applications-page>',
            pageTitle: () => {
                return "Applications"
            }
        });

        $stateProvider.state('homeV2.data-catalog', {
            url: '/data-catalog',
            abstract: true,
            template: '<div ui-view class="h100"></div>',
        });

        $stateProvider.state('homeV2.data-catalog.home', {
            url: '/',
            template: '<ng2-data-catalog-page></ng2-data-catalog-page>',
            pageTitle: () => {
                return "Data Catalog"
            }
        });

        $stateProvider.state('homeV2.data-catalog.data-collections', {
            url: '/data-collections',
            abstract: true,
            template: '<ng2-home-root class="h100"></ng2-home-root>'
        });

        $stateProvider.state('homeV2.data-catalog.data-collections.home', {
            url: '/',
            template: '<ng2-data-collections-page></ng2-data-collections-page>',
            pageTitle: () => "Data Collections"
        });

        $stateProvider.state('homeV2.data-catalog.data-collections.data-collection', {
            url: '/:dataCollectionId/',
            template: '<ng2-data-collection-page [id]="$root.$stateParams.dataCollectionId" [is-in-project]="false"></ng2-data-collection-page>',
            pageTitle: () => "Data Collections"
        });

        $stateProvider.state('homeV2.workspaces', {
            url: '/workspaces',
            template: '<ng2-workspaces-page></ng2-workspaces-page>',
            pageTitle: () => {
                return "Workspaces"
            }
        });

        $stateProvider.state('homeV2.data-catalog.database-explorer', {
            url: '/database-explorer?connectionName?schemaName?catalogName',
            template: `<ng2-database-explorer-page class="h100"></ng2-database-explorer-page>`,
            pageTitle: () => "Database explorer"
        });

        // must be placed after all other `homeV2.data-catalog.*` to prevent selectedTab to match with everything
        $stateProvider.state('homeV2.data-catalog.datasources', {
            url: '/:selectedTab',
            template: '<ng2-data-sources-page [query-on-load]="$root.$stateParams.queryOnLoad" [preselected-item]="$root.$stateParams.preselectedItem"></ng2-data-sources>',
            params: {
                queryOnLoad: null, // optionally set the query after load
                preselectedItem: undefined // optionally select an item (if it's in the results of the first query)
            },
            pageTitle: () => {
                return "Datasets & Indexed Tables"
            }
        });

        /* ************************** Project Apps ********************** */

        $stateProvider.state('apps', {
            url: '/apps',
            abstract: true,
            template: '<div ui-view class="h100"></div>'
        });

        $stateProvider.state('apps.list', {
            url: '/',
            controller: 'AppsListController',
            templateUrl: '/templates/apps/apps-list.html',
            params: {
                preSetQuery: '' // optional: fill in the search field on load
            },
            pageTitle: () => {
                return "Applications";
            }
        });

        $stateProvider.state('apps.app', {
            url: '/:appId',
            templateUrl: '/templates/apps/app-page.html',
            pageTitle: () => {
                return "App";
            }
        });

        /* ************************** Project ********************** */

        $stateProvider.state('projects.project', {
            url: '/:projectKey',
            abstract: true,
            controller: 'ProjectBaseController',
            templateUrl: '/templates/projects/project.html'
        });

        $stateProvider.state('projects.project.project-standards-report', {
            url: '/project-standards-report',
            template: '<ng2-project-standards-report-page [project-key]="$root.$state.params.projectKey"></ng2-project-standards-report-page>',
            pageTitle: () => {
                return "Project Standards Report";
            }
        });

        $stateProvider.state('projects.project.home', {
            abstract: true,
            url: '',
            templateUrl: '/templates/projects/home/index.html',
            controller: 'ProjectHomeTabController',
        });

        $stateProvider.state('projects.project.home.summary', {
            url: '/?discussionId&testInstance',
            templateUrl: '/templates/projects/home/project-home.html',
            controller: 'ProjectHomeController',
            pageTitle: () => {
                return "Summary";
            }
        });

        $stateProvider.state('projects.project.home.regular', {
            url: '?discussionId&testInstance',
            controller: 'ContextualProjectHomeController',
        });

        $stateProvider.state('projects.project.home.setup', {
            url: '/setup',
            templateUrl : '/templates/projects/home/setup-home.html',
            pageTitle: () => {
                return "Project setup"
            }
        });

        $stateProvider.state('projects.project.home.activity', {
            url: '/activity/',
            templateUrl: '/templates/projects/home/activity.html',
            controller: 'ProjectHomeController',
            pageTitle: () => {
                return "Summary";
            }
        });

        $stateProvider.state('projects.project.home.status', {
            url: '/status',
            abstract: true,
            templateUrl: '/templates/projects/home/status.html',
            controller: 'ProjectMetricsController',
            pageTitle: () => {
                return " Summary";
            }
        });

        $stateProvider.state('projects.project.home.status.settings', {
            url: '/settings',
            templateUrl: '/templates/projects/home/status-settings.html'
        });

        $stateProvider.state('projects.project.home.status.metrics', {
            url: '',
            templateUrl: '/templates/projects/home/status-metrics.html'
        });

        $stateProvider.state('projects.project.home.status.checks', {
            url: '/checks',
            templateUrl: '/templates/projects/home/status-checks.html'
        });

        /* Temporary redirect state */

        $stateProvider.state('projects.project.settings.tmp', {
            url: '/',
            controller: 'ProjectSettingsTmpController',
        });

        $stateProvider.state('projects.project.variables', {
            url: '/variables/',
            templateUrl: '/templates/projects/variables/variables.html'
        });

        $stateProvider.state('projects.project.appdesigner', {
            url: '/app-designer/',
            templateUrl: '/templates/apps/app-designer.html',
            controller: "AppDesignerController",
            pageTitle: () => {
                return "Application designer";
            }
        });

        $stateProvider.state('projects.project.statisticsWorksheet', {
            url: '/statistics/worksheet/:worksheetId',
            template: '<ng2-eda-worksheet-redirection-page></ng2-eda-worksheet-redirection-page>'
        });

        $stateProvider.state('projects.project.settings', {
            url: '/settings/:selectedTab',
            templateUrl: '/templates/projects/settings/settings.html'
        });

        $stateProvider.state('projects.project.integrations', {
            url: '/settings/integrations',
            templateUrl: '/templates/projects/integrations/messaging-like-selection.html'
        });

        $stateProvider.state('projects.project.security', {
            url: '/security/:selectedTab',
            templateUrl: '/templates/projects/security/security.html'
        });

        $stateProvider.state('projects.project.libedition', {
            url: '/libedition',
            abstract: true,
            templateUrl: '/templates/plugins/development/lib-edition-project.html'
        });

        $stateProvider.state("projects.project.libedition.versioned", {
            url: '/versioned?initialPath',
            templateUrl: '/templates/plugins/development/lib-versioned-edition-project.html',
            controller: 'ProjectFolderVersionedEditionController',
            params: {
                initialPath: ''
            },
            pageTitle: () => "Library Editor"
        });

        $stateProvider.state("projects.project.libedition.history", {
            url: '/history',
            templateUrl: '/templates/plugins/development/lib-versioned-history-project.html',
            controller: 'ProjectFolderVersionedHistoryController',
            pageTitle: () => "Library Editor"
        });

        $stateProvider.state("projects.project.libedition.resources", {
            url: '/resources',
            templateUrl: '/templates/plugins/development/lib-resources-edition-project.html',
            controller: 'ProjectFolderResourcesEditionController',
            pageTitle: () => "Library Editor"
        });

        $stateProvider.state('projects.project.libedition.libpython', {
            url: '/libpython',
            redirectTo: 'projects.project.libedition.versioned'
        });

        $stateProvider.state('projects.project.libedition.localstatic', {
            url: '/localstatic',
            redirectTo: 'projects.project.libedition.versioned'
        });

        $stateProvider.state('projects.project.flow', {
            url: '/flow/?id&?zoneId',
            templateUrl: '/templates/flow-editor/flow-editor.html',
            pageTitle: () => {
                return "Flow";
            }
        });

        $stateProvider.state('projects.project.version-control', {
            url: '/version-control/?commitId?branch',
            templateUrl: '/templates/projects/git/project-git.html',
            controller: "ProjectVersionControlController",
            pageTitle: () => {
                return "Version control";
            }
        });

        $stateProvider.state('projects.project.version-control-merge', {
            url: '/version-control-merge/:mergeRequestId',
            templateUrl: '/templates/git/merge-request.html',
            controller: "GitMergeRequestController",
            pageTitle: () => "Merge request"
        });

        /* ************************** Dataset ********************** */

        $stateProvider.state('projects.project.datasets', {
            url: '/datasets',
            abstract: true,
            template: '<div ui-view></div>'
        });

        $stateProvider.state('projects.project.datasets.list', {
            url: '/',
            templateUrl: '/templates/datasets/list.html',
            controller: 'DatasetsListController',
            pageTitle: () => {
                return "Datasets";
            }
        });

        $stateProvider.state('projects.project.datasets.dataset', {
            url: '/:datasetName?discussionId',
            abstract: true,
            controller: 'DatasetCommonController',
            templateUrl: '/templates/datasets/dataset.html'
        });

        $stateProvider.state('projects.project.datasets.dataset.settings', {
            url: '/settings/',
            templateUrl: '/templates/datasets/settings.html',
            controller: 'DatasetSettingsController',
            pageTitle: function(stateParams) {
                return stateParams.datasetName + " - Settings";
            }
        });

        $stateProvider.state('projects.project.datasets.dataset.history', {
            url: '/history/',
            templateUrl: '/templates/datasets/history.html',
            controller: 'DatasetHistoryController',
            pageTitle: function(stateParams) {
                return stateParams.datasetName + " - History";
            }
        });

        $stateProvider.state('projects.project.datasets.dataset.statistics', {
            url: '/statistics',
            template: `<ng2-eda
                dataset-name="{{$state.params.datasetName}}"
                project-key="{{$state.params.projectKey}}"
                worksheet-id="{{$state.params.worksheetId}}"></ng2-eda>`,
            controller: 'DatasetStatisticsController',
            reloadOnSearch: false,
            pageTitle: function(stateParams) {
                return stateParams.datasetName + " - Statistics";
            }
        });

        $stateProvider.state('projects.project.datasets.dataset.statistics.worksheet', {
            url: '/worksheet/:worksheetId',
            reloadOnSearch: false,
            pageTitle: function(stateParams) {
                return stateParams.datasetName + " - Statistics";
            }
        });

        /* *********************** Data Quality ******************** */

        const dataQualityPageTitle = function(stateParams) {
            return stateParams.datasetName + " - Data quality";
        };

        $stateProvider.state('projects.project.datasets.dataset.data-quality', {
            url: '/data-quality',
            template: '<div block-api-error></div><div ui-view></div>',
            controller: 'DatasetDataQualityController',
            abstract: true
        });

        $stateProvider.state('projects.project.datasets.dataset.data-quality.view', {
            url: '',
            template: `<ng2-dataset-quality-tab-view
                ng-if="datasetFullInfo"
                class="dataset__data-quality-panel-container"
                [can-edit]="projectSummary.canWriteProjectContent"
                [can-publish-to-dashboards]="projectSummary.canWriteDashboards"
                [is-foreign]="false"
                [is-partitioned]="datasetFullInfo.partitioned"
                [context-project-key]="$stateParams.projectKey"
                [project-key]="$root.$state.params.projectKey"
                [dataset-name]="$root.$state.params.datasetName"
                [(data-steward)]="datasetFullInfo.dataSteward"
                [default-data-steward]="datasetFullInfo.defaultDataSteward"
                [last-build-time]="datasetFullInfo.lastBuild ? datasetFullInfo.lastBuild.buildEndTime : -1"
                [partitioning-scheme]="datasetFullInfo.dataset.partitioning"
                [is-input-dataset]="!datasetFullInfo.upstreamBuildable"
            ></ng2-dataset-quality-tab-view>
            `,
            abstract: true
        });

        $stateProvider.state('projects.project.datasets.dataset.data-quality.view.current-status', {
            url: '/current-status',
            template: `<ng2-current-values-panel
                [can-edit]="addToScope.canEdit"
                [can-publish-to-dashboards]="addToScope.canPublishToDashboards"
                [dataset-name]="addToScope.datasetName"
                [context-project-key]="addToScope.contextProjectKey"
                [project-key]="addToScope.projectKey"
                [is-foreign]="false"
                [is-partitioned]="addToScope.isPartitioned"
                [selected-partition-id]="addToScope.selectedPartitionId"
                [data-steward]="addToScope.dataSteward"
                (data-steward-change)="addToScope.dataStewardChange($event)"
                [default-data-steward]="addToScope.defaultDataSteward"
                [last-build-time]="addToScope.lastBuildTime"
                [is-input-dataset]="addToScope.isInputDataset"
            ></ng2-current-values-panel>`,
            pageTitle: dataQualityPageTitle
        });

        $stateProvider.state('projects.project.datasets.dataset.data-quality.view.timeline', {
            url: '/timeline',
            template: `<ng2-timeline-panel
                [can-edit]="addToScope.canEdit"
                [dataset-name]="addToScope.datasetName"
                [project-key]="addToScope.projectKey"
                [context-project-key]="addToScope.contextProjectKey"
                [is-foreign]="false"
                [is-partitioned]="addToScope.isPartitioned"
                [selected-partition-id]="addToScope.selectedPartitionId"
            ></ng2-timeline-panel>`,
            pageTitle: dataQualityPageTitle
        });

        $stateProvider.state('projects.project.datasets.dataset.data-quality.view.history', {
            url: '/history?ruleIds?status?startDate?endDate',
            template: `<ng2-rule-history
                [dataset-name]="$root.$state.params.datasetName"
                [project-key]="$root.$state.params.projectKey"
                [context-project-key]="$root.$state.params.projectKey"
                [rule-ids]="$root.$state.params.ruleIds"
                [status]="$root.$state.params.status"
                [start-date]="$root.$state.params.startDate"
                [end-date]="$root.$state.params.endDate"
                [is-partitioned]="addToScope.isPartitioned"
                [selected-partition-id]="addToScope.selectedPartitionId"
                [can-edit]="addToScope.canEdit"
            ></ng2-rule-history>`,
            pageTitle: dataQualityPageTitle
        });

        $stateProvider.state('projects.project.datasets.dataset.data-quality.edit', {
            url: '/edit',
            templateUrl: '/templates/datasets/data-quality-edit.html',
        });

        $stateProvider.state('projects.project.datasets.dataset.data-quality.edit.new-rule', {
            url: '/new-rule',
            templateUrl: '/templates/datasets/data-quality-new-rule.html',
            params: {
                openTemplateModal: undefined
            },
            pageTitle: function(stateParams) {
                return stateParams.datasetName + " - Data quality (new rule)";
            }
        });

        $stateProvider.state('projects.project.datasets.dataset.data-quality.edit.rule', {
            url: '/:ruleId',
            template: '<ng2-rule-edit [can-edit]="addToScope.canEdit" [rule-id]="$root.$state.params.ruleId" [project-key]="$root.$state.params.projectKey"></ng2-rule-edit>',
            pageTitle: dataQualityPageTitle
        });

        /* ************************** Metrics ********************** */

        const metricsPageTitle = function(stateParams) {
            return stateParams.datasetName + " - Metrics";
        };

        $stateProvider.state('projects.project.datasets.dataset.metrics', {
            url: '/metrics',
            template: `
            <div block-api-error></div>
            <div class= "h100" object-metrics metrics-partition-selection dataset-metrics-main>
                <div ng-if="datasetFullInfo" class="h100" ng-controller="DatasetMetricsController">
                    <ui-view class="h100"></ui-view>
                </div>
            </div>`,
            abstract: true
        });

        $stateProvider.state('projects.project.datasets.dataset.metrics.view', {
            url: '',
            template:`
                <div class="h100" ng-if="datasetFullInfo" ng-controller="DatasetMetricsController">
                    <div class="h100" display-metrics ng-show="views.selected === 'Last value' || views.selected === 'History'" can-compute="true" metrics-tab="true"></div>
                    <div class="h100" display-metrics-per-partition ng-show="views.selected === 'Partitions' || views.selected === 'Table'" can-compute="true" metrics-tab="true"></div>
                    <div class="h100" display-metrics-per-column ng-show="views.selected === 'Columns'" can-compute="true" metrics-tab="true"></div>
                </div>`,
            pageTitle: metricsPageTitle
        });

        $stateProvider.state('projects.project.datasets.dataset.metrics.edit', {
            url: '/edit',
            template:`
                <div class="h100 boxed-next-to-sidebar no-padding">
                    <div ng-if="datasetFullInfo" class="h100 oa">
                        <form class="dkuform-modal-horizontal dkuform-modal-wrapper h100" name="theform" edit-probes-settings metrics-tab="true" novalidate >
                        </form>
                    </div>
                </div>
                `,
            pageTitle: metricsPageTitle
        });

        /* ***************** Agent Hub ********************* */
        redirectedAbstractState($stateProvider, 'projects.project.dataikuanswers', '/answers');
        redirectState($stateProvider, "projects.project.dataikuanswers.list","projects.project.agenthub.list","/")

        $stateProvider.state("projects.project.agenthub", {
            url : '/agenthub',
            template: '<div ui-view></div>',
            abstract: true
        });

        $stateProvider.state("projects.project.agenthub.list", {
            url : '/',
            templateUrl: '/templates/agent-hub/list.html',
            controller: 'ChatUIsListController',
            pageTitle: () => {
                return "Agent Hub";
            }
        });

        /* ***************** Experiment tracking ********************* */

        $stateProvider.state('projects.project.experiment-tracking', {
            url: '/experiment-tracking',
            template: '<div ui-view></div>',
            controller: 'ExperimentTrackingController',
            reloadOnSearch: false,
            abstract: true
        });

        $stateProvider.state('projects.project.experiment-tracking.list', {
            url: '/list?viewAllExperiments',
            params: {
                viewAllExperiments: "false"
            },
            template: `<ng2-experiment-tracking></ng2-experiment-tracking>`,
            reloadOnSearch: false,
            pageTitle: function() {
                return " Experiment Tracking - Runs";
            }
        });

        $stateProvider.state('projects.project.experiment-tracking.runs-list', {
            url: '/list-runs?experimentIds&viewAllExperiments&viewAllRuns',
            params: {
                experimentIds: undefined,
                viewAllExperiments: undefined,
                viewAllRuns: undefined
            },
            template: `<ng2-experiment-tracking-runs-list></ng2-experiment-tracking-runs-list>`,
            reloadOnSearch: false,
            pageTitle: function() {
                return " Experiment Tracking - Runs";
            }
        });

        $stateProvider.state('projects.project.experiment-tracking.run-details', {
            url: '/run/:runId/details?experimentIds&viewAllExperiments&viewAllRuns',
            params: {
                experimentIds: undefined,
                viewAllExperiments: undefined,
                viewAllRuns: undefined
            },
            template: `<ng2-experiment-tracking-run></ng2-experiment-tracking-run>`,
            reloadOnSearch: false,
            pageTitle: function(stateParams) {
                return " Experiment Tracking - Run";
            }
        });

        $stateProvider.state('projects.project.experiment-tracking.run-artifacts', {
            url: '/run/:runId/artifacts?experimentIds&viewAllExperiments&viewAllRuns&subfolder',
            params: {
                experimentIds: undefined,
                subfolder: undefined,
                viewAllExperiments: undefined,
                viewAllRuns: undefined
            },
            template: `<ng2-experiment-tracking-run></ng2-experiment-tracking-run>`,
            reloadOnSearch: false,
            pageTitle: function(stateParams) {
                return " Experiment Tracking - Run";
            }
        });

        $stateProvider.state('projects.project.datasets.dataset.edit', {
            url: '/edit/',
            templateUrl: '/templates/datasets/edit-dataset.html',
            controller: 'DatasetEditController',
            pageTitle: function(stateParams) {
                return stateParams.datasetName + " - Edit";
            }
        });

        $stateProvider.state('projects.project.datasets.dataset.explore', {
            url: '/explore/',
            templateUrl: '/templates/datasets/explore.html',
            pageTitle: function(stateParams) {
                return stateParams.datasetName + " - Explore";
            }
        });

        $stateProvider.state('projects.project.datasets.dataset.status', {
            url: '/status',
            abstract: true,
            template: '<ui-view />'
        });

        $stateProvider.state('projects.project.datasets.dataset.status.settings', {
            url: '/settings/:selectedTab',
            params: { selectedTab: null },
            controller: function($state, $stateParams) {
                if ($stateParams.selectedTab === 'checks') {
                    $state.go('projects.project.datasets.dataset.data-quality.edit', $stateParams, {location: 'replace'})
                } else {
                    $state.go('projects.project.datasets.dataset.metrics.edit', $stateParams, {location: 'replace'})
                }
            }
        });

        $stateProvider.state('projects.project.datasets.dataset.status.metrics', {
            url: '',
            controller: function($state, $stateParams) {
                $state.go('projects.project.datasets.dataset.metrics.view', $stateParams, {location: 'replace'})
            }
        });

        $stateProvider.state('projects.project.datasets.dataset.status.checks', {
            url: '/checks',
            controller: function($state, $stateParams) {
                $state.go('projects.project.datasets.dataset.data-quality.view.current-status', $stateParams, {location: 'replace'})
            }
        });

        $stateProvider.state('projects.project.datasets.dataset.visualize', {
            url: '/visualize/{chartId:[0-9a-zA-Z]*}{separator:_{0,1}}{chartName}',
            templateUrl: '/templates/datasets/visualize.html',
            pageTitle: function(stateParams) {
                return stateParams.datasetName + " - Visualize";
            }
        });

        $stateProvider.state('projects.project.datasets.new_with_type', {
            url: '/new/:type?fromOdbSmartId?fromOdbItemPath?fromOdbItemDirectory?zoneId',
            abstract: true,
            templateUrl: '/templates/datasets/dataset.html',
            controller: 'DatasetNewController',
        });

        $stateProvider.state('projects.project.datasets.new_with_type.settings', {
            url: '/?prefillParams',
            templateUrl: '/templates/datasets/new-settings.html',
            controller: 'DatasetSettingsController',
            pageTitle: function(stateParams) {
                return "New " + stateParams.type + " dataset";
            }
        });

        $stateProvider.state('projects.project.datasets.dataset.search', {
            url: '/search/',
            templateUrl: '/templates/datasets/search.html',
            params: {
                queryString: null,
            },
            pageTitle: function(stateParams) {
                return stateParams.datasetName + " - Search";
            }
        });

        /* ************************** Foreign view of datasets ********************** */

        $stateProvider.state('projects.project.foreigndatasets', {
            url: '/foreigndatasets',
            abstract: true,
            template: '<div ui-view></div>'
        });

        $stateProvider.state('projects.project.foreigndatasets.dataset', {
            url: '/:datasetFullName',
            abstract: true,
            controller: 'ForeignDatasetCommonController',
            templateUrl: '/templates/foreigndatasets/dataset.html'
        });

        $stateProvider.state('projects.project.foreigndatasets.dataset.explore', {
            url: '/explore/',
            templateUrl: '/templates/foreigndatasets/explore.html',
            pageTitle: function(stateParams) {
                return stateParams.datasetFullName + " - Explore";
            }
        });

        $stateProvider.state('projects.project.foreigndatasets.dataset.search', {
            url: '/search/',
            templateUrl: '/templates/foreigndatasets/search.html',
            params: {
                queryString: null,
            },
            pageTitle: function(stateParams) {
                return stateParams.datasetFullName + " - Search";
            }
        });

        $stateProvider.state('projects.project.foreigndatasets.dataset.visualize', {
            url: '/visualize/{chartId:[0-9a-zA-Z]*}{separator:_{0,1}}{chartName}',
            templateUrl: '/templates/foreigndatasets/visualize.html',
            pageTitle: function(stateParams) {
                return stateParams.datasetFullName + " - Visualize";
            }
        });

        $stateProvider.state('projects.project.foreigndatasets.dataset.statistics', {
            url: '/statistics',
            template: `<ng2-eda
                dataset-name="{{$state.params.datasetFullName}}"
                project-key="{{$state.params.projectKey}}"
                worksheet-id="{{$state.params.worksheetId}}"></ng2-eda>`,
            controller: 'DatasetStatisticsController',
            reloadOnSearch: false,
            pageTitle: function(stateParams) {
                return stateParams.datasetName + " - Statistics";
            }
        });

        $stateProvider.state('projects.project.foreigndatasets.dataset.statistics.worksheet', {
            url: '/worksheet/:worksheetId',
            reloadOnSearch: false,
            pageTitle: function(stateParams) {
                return stateParams.datasetName + " - Statistics";
            }
        });

        const dataQualityPageTitleForeign = function(stateParams) {
            return stateParams.datasetFullName + " - Data quality";
        };

        $stateProvider.state('projects.project.foreigndatasets.dataset.data-quality', {
            url: '/data-quality',
            template: '<div block-api-error></div><div ui-view></div>',
            controller: 'DatasetDataQualityController',
            abstract: true
        });

        $stateProvider.state('projects.project.foreigndatasets.dataset.data-quality.view', {
            url: '',
            template: `<ng2-dataset-quality-tab-view
                ng-if="datasetLoc && datasetFullInfo"
                class="dataset__data-quality-panel-container"
                [can-edit]="false"
                [is-foreign]="true"
                [is-partitioned]="datasetFullInfo.partitioned"
                [context-project-key]="$stateParams.projectKey"
                [project-key]="datasetLoc.projectKey"
                [dataset-name]="datasetLoc.name"
                [data-steward]="datasetFullInfo.dataSteward"
                [default-data-steward]="datasetFullInfo.defaultDataSteward"
                [last-build-time]="datasetFullInfo.lastBuild.buildEndTime"
                [partitioning-scheme]="datasetFullInfo.dataset.partitioning"
                [is-input-dataset]="!datasetFullInfo.upstreamBuildable"
            ></ng2-dataset-quality-tab-view>`,
            abstract: true
        });

        $stateProvider.state('projects.project.foreigndatasets.dataset.data-quality.view.current-status', {
            url: '/current-status',
            template: `<ng2-current-values-panel
                [can-edit]="addToScope.canEdit"
                [dataset-name]="addToScope.datasetName"
                [project-key]="addToScope.projectKey"
                [context-project-key]="addToScope.contextProjectKey"
                [is-foreign]="true"
                [is-partitioned]="addToScope.isPartitioned"
                [selected-partition-id]="addToScope.selectedPartitionId"
                [data-steward]="addToScope.dataSteward"
                [default-data-steward]="addToScope.defaultDataSteward"
                [last-build-time]="addToScope.lastBuildTime"
                [is-input-dataset]="addToScope.isInputDataset"
            ></ng2-current-values-panel>`,
            pageTitle: dataQualityPageTitleForeign
        });

        $stateProvider.state('projects.project.foreigndatasets.dataset.data-quality.view.timeline', {
            url: '/timeline',
            template: `<ng2-timeline-panel
                [can-edit]="addToScope.canEdit"
                [dataset-name]="addToScope.datasetName"
                [project-key]="addToScope.projectKey"
                [context-project-key]="addToScope.contextProjectKey"
                [is-foreign]="true"
                [is-partitioned]="addToScope.isPartitioned"
                [selected-partition-id]="addToScope.selectedPartitionId"
            ></ng2-timeline-panel>`,
            pageTitle: dataQualityPageTitleForeign
        });

        $stateProvider.state('projects.project.foreigndatasets.dataset.data-quality.view.history', {
            url: '/history?ruleIds?status?startDate?endDate',
            template: `<ng2-rule-history
                [dataset-name]="addToScope.datasetName"
                [project-key]="addToScope.projectKey"
                [context-project-key]="addToScope.contextProjectKey"
                [project-key]="addToScope.projectKey"
                [rule-ids]="$root.$state.params.ruleIds"
                [status]="$root.$state.params.status"
                [start-date]="$root.$state.params.startDate"
                [end-date]="$root.$state.params.endDate"
                [is-partitioned]="addToScope.isPartitioned"
                [selected-partition-id]="addToScope.selectedPartitionId"
                [can-edit]="addToScope.canEdit"
            ></ng2-rule-history>`,
            pageTitle: dataQualityPageTitleForeign
        });

        /* ************************** Streaming enpdoints ********************** */

        $stateProvider.state('projects.project.streaming-endpoints', {
            url: '/streaming-endpoints',
            abstract: true,
            template: '<div ui-view></div>'
        });

        $stateProvider.state('projects.project.streaming-endpoints.list', {
            url: '/',
            templateUrl: '/templates/streaming-endpoints/list.html',
            controller: 'StreamingEndpointsListController',
            pageTitle: () => {
                return "Streaming endpoints";
            }
        });

        $stateProvider.state('projects.project.streaming-endpoints.streaming-endpoint', {
            url: '/:streamingEndpointId?discussionId',
            abstract: true,
            controller: 'StreamingEndpointPageController',
            templateUrl: '/templates/streaming-endpoints/streaming-endpoint.html'
        });

        $stateProvider.state('projects.project.streaming-endpoints.streaming-endpoint.settings', {
            url: '/settings/',
            templateUrl: '/templates/streaming-endpoints/settings.html',
            controller: 'StreamingEndpointSettingsController',
            pageTitle: function(stateParams) {
                return stateParams.streamingEndpointId + " - Settings";
            }
        });

        $stateProvider.state('projects.project.streaming-endpoints.streaming-endpoint.history', {
            url: '/history/',
            templateUrl: '/templates/streaming-endpoints/history.html',
            controller: 'StreamingEndpointHistoryController',
            pageTitle: function(stateParams) {
                return stateParams.streamingEndpointId + " - History";
            }
        });

        $stateProvider.state('projects.project.streaming-endpoints.streaming-endpoint.explore', {
            url: '/explore/',
            templateUrl: '/templates/streaming-endpoints/explore.html',
            controller: 'StreamingEndpointExploreController',
            pageTitle: function(stateParams) {
                return stateParams.streamingEndpointId + " - Explore";
            }
        });

        /* ************************** Analysis ********************** */

        $stateProvider.state('projects.project.analyses', {
            url: '/analysis',
            abstract: true,
            template: '<div ui-view></div>'
        });

        $stateProvider.state('projects.project.analyses.list', {
            url: '/?datasetId',
            templateUrl: '/templates/analysis/list.html',
            controller: "AnalysesListController",
            pageTitle: () => {
                return " Analyses";
            }
        });

        $stateProvider.state('projects.project.analyses.analysis', {
            url: '/:analysisId?discussionId',
            abstract: true,
            templateUrl: '/templates/analysis/analysis.html',
            controller: "AnalysisCoreController",
            pageTitle: () => {
                return " Analysis";
            }
        });

        $stateProvider.state('projects.project.analyses.analysis.script', {
            url: '/script/',
            templateUrl: '/templates/analysis/script.html',
        });

        $stateProvider.state('projects.project.analyses.analysis.charts', {
            url: '/visualize/{chartId:[0-9a-zA-Z]*}{separator:_{0,1}}{chartName}',
            templateUrl: '/templates/analysis/charts.html',
        });

        $stateProvider.state('projects.project.analyses.analysis.ml', {
            url: '/ml',
            abstract: true,
            template: '<div ui-view></div>'
        });

        // You never stay on this state except if no mltask
        $stateProvider.state('projects.project.analyses.analysis.ml.list', {
            url: '/',
            templateUrl: '/templates/analysis/mltasks.html',
            controller: "AnalysisMLTasksController"
        });

        /* ******************** Analysis/ML/Prediction **************** */

        $stateProvider.state('projects.project.analyses.analysis.ml.predmltask', {
            url: '/p/:mlTaskId',
            abstract: true,
            template: '<div ui-view></div>'
        });

        $stateProvider.state('projects.project.analyses.analysis.ml.predmltask.list', {
            url: '/list',
            abstract: true,
            templateUrl: '/templates/analysis/prediction/models.html',
            controller: 'PMLTaskBaseController'
        });

        $stateProvider.state('projects.project.analyses.analysis.ml.predmltask.list.design', {
            url: '/design',
            templateUrl: '/templates/analysis/prediction/models-design.html',
            controller: function($scope, $state) {
                $scope.uiState = $scope.uiState || {};
                $scope.setSettingsPane = (pane) => {
                    $scope.uiState.settingsPane = pane;
                }

                const baseStateName = "projects.project.analyses.analysis.ml.predmltask.list.design";
                $scope.$on('$stateChangeStart', function (event, toState, toParams, fromState, fromParams) {
                    const suffix = MLModelsUIRouterStates.getPredictionDesignTabPrefix($scope) + "-learning";
                    GoToStateNameSuffixIfBase($state, toState, toParams, fromState, fromParams, baseStateName, suffix, event);
                });

                if ($state.current.name === baseStateName) {
                    const deregister = $scope.$watch("mlTaskDesign", (nv, ov) => {
                        if (!nv) {
                            return;
                        }
                        // redirect to learning page when arriving on "design", need to have mlTaskDesign to know the backend type...
                        const prefix = MLModelsUIRouterStates.getPredictionDesignTabPrefix($scope);
                        $state.go(`.${prefix}-learning`, null, {location: 'replace'});
                        deregister();
                    });
                }
            }
        });


        for (const {stateName, stateConfig} of MLModelsUIRouterStates.getPredictionMLTaskDesignUIRouterStates()) {
            $stateProvider.state(
                'projects.project.analyses.analysis.ml.predmltask.list.design.' + stateName,
                stateConfig
            )
        }

        $stateProvider.state('projects.project.analyses.analysis.ml.predmltask.list.results', {
            url: '/results',
            templateUrl: '/templates/analysis/prediction/models-results.html',
            controller: function($scope, $state, $timeout) {
                $scope.uiState = $scope.uiState || {};
                $scope.setViewMode = (pane) => {
                    $scope.uiState.viewMode = pane;
                }

                const baseStateName = "projects.project.analyses.analysis.ml.predmltask.list.results";
                $scope.$on('$stateChangeStart', function (event, toState, toParams, fromState, fromParams) {
                    GoToStateNameSuffixIfBase($state, toState, toParams, fromState, fromParams, baseStateName, "sessions", event);
                });

                if ($state.current.name === baseStateName) {
                    $timeout(() => $state.go(".sessions", null, {location: 'replace'}));
                }
            }
        });

        for (const {stateName, stateConfig} of MLModelsUIRouterStates.getAllResultsUIRouterStates()) {
            $stateProvider.state(
                'projects.project.analyses.analysis.ml.predmltask.list.results.' + stateName,
                stateConfig
            )
        }

        $stateProvider.state('projects.project.analyses.analysis.ml.predmltask.model', {
            url: '/:fullModelId',
            abstract: true,
            template: '<div ui-view></div>'
        });

        $stateProvider.state('projects.project.analyses.analysis.ml.predmltask.model.predictedtable', {
            url: '/table/',
            templateUrl: '/templates/analysis/prediction/model/model-predicted-table.html'
        });

        $stateProvider.state('projects.project.analyses.analysis.ml.predmltask.model.predictedcharts', {
            url: '/charts/{chartId:[0-9a-zA-Z]*}{separator:_{0,1}}{chartName}',
            templateUrl: '/templates/analysis/prediction/model/model-predicted-charts.html'
        });

        $stateProvider.state('projects.project.analyses.analysis.ml.predmltask.model.report', {
            url: '/report?exportMode?treatment',
            templateUrl: '/templates/analysis/prediction/model/model-report.html',
            controller: "MLBaseRouteReportController"
        });

        for (const {stateName, stateConfig} of MLModelsUIRouterStates.getAllPredictionReportAndModelViewUIRouterStates()) {
            $stateProvider.state(
                'projects.project.analyses.analysis.ml.predmltask.model.report.' + stateName,
                stateConfig
            )
        }

        /* ******************** Analysis/ML/Clustering **************** */

        $stateProvider.state('projects.project.analyses.analysis.ml.clustmltask', {
            url: '/c/:mlTaskId',
            abstract: true,
            template: '<div ui-view></div>'
        });

        $stateProvider.state('projects.project.analyses.analysis.ml.clustmltask.list', {
            url: '/list',
            abstract: true,
            templateUrl: '/templates/analysis/models.html',
            controller: 'CMLTaskBaseController'
        });

        $stateProvider.state('projects.project.analyses.analysis.ml.clustmltask.list.design', {
            url: '/design',
            templateUrl: '/templates/analysis/clustering/models-design.html',
            controller: function($scope, $state, $timeout) {
                $scope.uiState = $scope.uiState || {};
                $scope.setSettingsPane = (pane) => {
                    $scope.uiState.settingsPane = pane;
                }

                const baseStateName = "projects.project.analyses.analysis.ml.clustmltask.list.design";
                $scope.$on('$stateChangeStart', function (event, toState, toParams, fromState, fromParams) {
                    GoToStateNameSuffixIfBase($state, toState, toParams, fromState, fromParams, baseStateName, "clustering-learning", event);
                });

                if ($state.current.name === baseStateName) {
                    $timeout(() => $state.go(".clustering-learning", null, {location: 'replace'}));
                }
            }
        });

        for (const {stateName, stateConfig} of MLModelsUIRouterStates.getClusteringDesignUIRouterStates()) {
            $stateProvider.state(
                'projects.project.analyses.analysis.ml.clustmltask.list.design.' + stateName,
                stateConfig
            )
        }


        $stateProvider.state('projects.project.analyses.analysis.ml.clustmltask.list.results', {
            url: '/results',
            templateUrl: '/templates/analysis/clustering/models-results.html',
            controller: function($scope, $state, $timeout) {
                $scope.uiState = $scope.uiState || {};
                $scope.setViewMode = (pane) => {
                    $scope.uiState.viewMode = pane;
                }

                const baseStateName = "projects.project.analyses.analysis.ml.clustmltask.list.results";
                $scope.$on('$stateChangeStart', function (event, toState, toParams, fromState, fromParams) {
                    GoToStateNameSuffixIfBase($state, toState, toParams, fromState, fromParams, baseStateName, "sessions", event);
                });

                if ($state.current.name === baseStateName) {
                    $timeout(() => $state.go(".sessions", null, {location: 'replace'}));
                }
            }
        });

        for (const {stateName, stateConfig} of MLModelsUIRouterStates.getAllResultsUIRouterStates()) {
            $stateProvider.state(
                'projects.project.analyses.analysis.ml.clustmltask.list.results.' + stateName,
                stateConfig
            )
        }

        $stateProvider.state('projects.project.analyses.analysis.ml.clustmltask.model', {
            url: '/:fullModelId',
            abstract: true,
            template: '<div ui-view></div>'
        });
        $stateProvider.state('projects.project.analyses.analysis.ml.clustmltask.model.predictedtable', {
            url: '/table/',
            templateUrl: '/templates/analysis/clustering/model/c-model-predicted-table.html'
        });

        $stateProvider.state('projects.project.analyses.analysis.ml.clustmltask.model.predictedcharts', {
            url: '/charts/{chartId:[0-9a-zA-Z]*}{separator:_{0,1}}{chartName}',
            templateUrl: '/templates/analysis/clustering/model/c-model-predicted-charts.html'
        });

        $stateProvider.state('projects.project.analyses.analysis.ml.clustmltask.model.report', {
            url: '/report',
            templateUrl: '/templates/analysis/clustering/model/c-model-report.html',
            controller: function($scope, $state, $timeout) {
                $scope.uiState = $scope.uiState || {};
                $scope.setSettingsPane = (pane, skinId) => {
                    $scope.uiState.settingsPane = skinId ? pane + "-" + skinId : pane;
                    $scope.uiState.skinId = skinId;
                }

                const baseStateName = "projects.project.analyses.analysis.ml.clustmltask.model.report";
                $scope.$on('$stateChangeStart', function (event, toState, toParams, fromState, fromParams) {
                    GoToStateNameSuffixIfBase($state, toState, toParams, fromState, fromParams, baseStateName, "summary", event);
                });

                if ($state.current.name === baseStateName) {
                    $timeout(() => $state.go(".summary", null, {location: 'replace'}));
                }
            }
        });

        for (const {stateName, stateConfig} of MLModelsUIRouterStates.getClusteringReportAndModelViewUIRouterStates()) {
            $stateProvider.state(
                'projects.project.analyses.analysis.ml.clustmltask.model.report.' + stateName,
                stateConfig
            )
        }

        /* ************************** Saved Model (Flow) ********************** */

        $stateProvider.state('projects.project.savedmodels', {
            url: '/savedmodels',
            abstract: true,
            template: '<div ui-view></div>'
        });

        $stateProvider.state('projects.project.savedmodels.list', {
            url: '/',
            templateUrl: '/templates/savedmodels/list.html',
            controller: "SavedModelListController",
            pageTitle: () => {
                return " Saved Models"
            }
        });

        $stateProvider.state('projects.project.savedmodels.savedmodel', {
            url: '/:smId?discussionId',
            abstract: true,
            controller: "SavedModelController",
            templateUrl: '/templates/savedmodels/savedmodel.html'
        });

        $stateProvider.state('projects.project.savedmodels.savedmodel.settings', {
            url: '/settings/',
            controller: "SavedModelSettingsController",
            templateUrl: '/templates/savedmodels/settings.html'
        });

        $stateProvider.state('projects.project.savedmodels.savedmodel.status', {
            url: '/status',
            templateUrl: '/templates/savedmodels/status.html'
        });

        $stateProvider.state('projects.project.savedmodels.savedmodel.status.metrics', {
            url: '/metrics/',
            templateUrl: '/templates/savedmodels/status-metrics.html'
        });

        $stateProvider.state('projects.project.savedmodels.savedmodel.status.checks', {
            url: '/checks/',
            templateUrl: '/templates/savedmodels/status-checks.html'
        });

        $stateProvider.state('projects.project.savedmodels.savedmodel.versions', {
            url: '/versions/?redirectToActiveVersion',
            controller: "SavedModelVersionsController",
            templateUrl: '/templates/savedmodels/versions.html'
        });

        redirectState($stateProvider, 'projects.project.savedmodels.savedmodel.prediction', '.report', '/p/:fullModelId?exportMode?treatment');
        redirectState($stateProvider, 'projects.project.savedmodels.savedmodel.prediction.legacysummary', '^.report', '/tabular-summary');
        redirectState($stateProvider, 'projects.project.savedmodels.savedmodel.prediction.trailingslash', '^.report', '/');

        $stateProvider.state('projects.project.savedmodels.savedmodel.prediction.report', {
            url: '/report',
            templateUrl: '/templates/savedmodels/prediction-report.html',
            controller: "MLBaseRouteReportController"
        });

        $stateProvider.state('projects.project.savedmodels.savedmodel.prediction.predictedtable', {
            url: '/table',
            templateUrl: '/templates/savedmodels/prediction-saved-model-predicted-table.html'
        });

        for (const {stateName, stateConfig} of MLModelsUIRouterStates.getAllPredictionReportAndModelViewUIRouterStates()) {
            $stateProvider.state(
                'projects.project.savedmodels.savedmodel.prediction.report.' + stateName,
                stateConfig
            )
        }

        redirectState($stateProvider, 'projects.project.savedmodels.savedmodel.clustering', '.report', '/c/:fullModelId');
        redirectState($stateProvider, 'projects.project.savedmodels.savedmodel.clustering.legacysummary', '^.report', '/summary');
        redirectState($stateProvider, 'projects.project.savedmodels.savedmodel.clustering.trailingslash', '^.report', '/');

        $stateProvider.state('projects.project.savedmodels.savedmodel.clustering.report', {
            url: '/report',
            templateUrl: '/templates/savedmodels/clustering-report.html',
            controller: function($scope, $state, $timeout) {
                $scope.uiState = $scope.uiState || {};
                $scope.setSettingsPane = (pane, skinId) => {
                    $scope.uiState.settingsPane = skinId ? pane + "-" + skinId : pane;
                    $scope.uiState.skinId = skinId;
                }

                const baseStateName = "projects.project.savedmodels.savedmodel.clustering.report";
                $scope.$on('$stateChangeStart', function (event, toState, toParams, fromState, fromParams) {
                    GoToStateNameSuffixIfBase($state, toState, toParams, fromState, fromParams, baseStateName, "summary", event);
                });

                if ($state.current.name === baseStateName) {
                    $timeout(() => $state.go(".summary", null, {location: 'replace'}));
                }
            }
        });

        $stateProvider.state('projects.project.savedmodels.savedmodel.clustering.predictedtable', {
            url: '/table',
            templateUrl: '/templates/savedmodels/clustering-saved-model-predicted-table.html'
        });

        for (const {stateName, stateConfig} of MLModelsUIRouterStates.getClusteringReportAndModelViewUIRouterStates()) {
            $stateProvider.state(
                'projects.project.savedmodels.savedmodel.clustering.report.' + stateName,
                stateConfig
            )
        }

        $stateProvider.state('projects.project.savedmodels.savedmodel.llmGeneric', {
            url: '/llm-generic',
            abstract: true,
            template: '<div ui-view></div>'
        });

        $stateProvider.state('projects.project.savedmodels.savedmodel.llmGeneric.report', {
            url: '/:fullModelId',
            templateUrl: '/templates/savedmodels/llm-generic-report.html',
            controller: function($scope, $state, $timeout) {
                $scope.uiState = $scope.uiState || {};
                $scope.setSettingsPane = (pane, skinId) => {
                    $scope.uiState.settingsPane = skinId ? pane + "-" + skinId : pane;
                    $scope.uiState.skinId = skinId;
                }

                const baseStateName = "projects.project.savedmodels.savedmodel.llmGeneric.report";
                $scope.$on('$stateChangeStart', function (event, toState, toParams, fromState, fromParams) {
                    GoToStateNameSuffixIfBase($state, toState, toParams, fromState, fromParams, baseStateName, "summary", event);
                });

                if ($state.current.name === baseStateName) {
                    $timeout(() => $state.go(".summary", null, {location: 'replace'}));
                }
            }
        });

        for (const {stateName, stateConfig} of MLModelsUIRouterStates.getLlmReportUIRouterStates()) {
            $stateProvider.state(
                'projects.project.savedmodels.savedmodel.llmGeneric.report.' + stateName,
                stateConfig
            )
        }

        $stateProvider.state('projects.project.savedmodels.savedmodel.agent', {
            url: '/agent',
            abstract: true,
            template: '<div ui-view></div>'
        });

        $stateProvider.state('projects.project.savedmodels.savedmodel.agent.design', {
            url: '/:fullModelId',
            templateUrl: '/templates/savedmodels/agents/agent-version-design.html',
            controller: "AgentSavedModelDesignController"
        });

        $stateProvider.state('projects.project.savedmodels.savedmodel.agent.settings', {
            url: '/:fullModelId/settings',
            templateUrl: '/templates/savedmodels/agents/agent-version-settings.html',
            controller: "AgentSavedModelSettingsController"
        });

        $stateProvider.state('projects.project.savedmodels.savedmodel.agent.logs', {
            url: '/:fullModelId/logs',
            templateUrl: '/templates/savedmodels/agents/agent-version-logs.html',
            controller: "AgentSavedModelLogsController"
        });
        $stateProvider.state('projects.project.savedmodels.savedmodel.agent.history', {
            url: '/:fullModelId/history',
            controller: "AgentVersionHistoryController",
            templateUrl: '/templates/savedmodels/saved-model-git-log.html'
        });
        $stateProvider.state('projects.project.savedmodels.savedmodel.history', {
            url: '/history',
            controller: "AgentSavedModelHistoryController",
            templateUrl: '/templates/savedmodels/saved-model-git-log.html'
        });


        $stateProvider.state('projects.project.savedmodels.savedmodel.retrievalaugmentedllm', {
            url: '/retrieval-augmented-llm',
            abstract: true,
            template: '<div ui-view></div>'
        });

        $stateProvider.state('projects.project.savedmodels.savedmodel.retrievalaugmentedllm.design', {
            url: '/:fullModelId',
            templateUrl: '/templates/savedmodels/retrieval-augmented-llm/retrieval-augmented-llm-version-design.html',
            controller: "RetrievalAugmentedLLMSavedModelDesignController"
        });

        $stateProvider.state('projects.project.savedmodels.savedmodel.retrievalaugmentedllm.settings', {
            url: '/:fullModelId/settings',
            templateUrl: '/templates/savedmodels/retrieval-augmented-llm/retrieval-augmented-llm-version-settings.html',
            controller: "RetrievalAugmentedLLMSavedModelSettingsController"
        });
        $stateProvider.state('projects.project.savedmodels.savedmodel.retrievalaugmentedllm.history', {
            url: '/:fullModelId/history',
            templateUrl: '/templates/savedmodels/saved-model-git-log.html',
            controller: "RetrievalAugmentedLLMSavedModelHistoryController"
        });

        /* ************************** GenAI Models and Agents ********************** */

        $stateProvider.state('projects.project.genai', {
            url: '/genai',
            abstract: true,
            template: '<div ui-view></div>'
        });

        $stateProvider.state('projects.project.genai.list', {
            url: '/',
            templateUrl: '/templates/genai/list.html',
            controller: "GenAIListController",
            pageTitle: () => {
                return " GenAI Models and Agents"
            }
        });

        /* **************************  Model Comparisons (Flow) ********************** */

        $stateProvider.state('projects.project.modelcomparisons', {
            url: '/modelcomparisons',
            abstract: true,
            template: '<div ui-view></div>'
        });

        $stateProvider.state('projects.project.modelcomparisons.list', {
            url: '/',
            templateUrl: '/templates/modelcomparisons/list.html',
            controller: "modelComparisonListController",
            pageTitle: () => {
                return " Model Comparisons"
            }
        });

        $stateProvider.state('projects.project.modelcomparisons.modelcomparison', {
            url: '/:modelComparisonId?discussionId',
            templateUrl: '/templates/modelcomparisons/modelcomparison.html',
            controller: "modelComparisonController"
        });

        $stateProvider.state('projects.project.modelcomparisons.modelcomparison.summary', {
            url: '/summary',
            controller: "modelComparisonCompositionController",
            templateUrl: '/templates/modelcomparisons/comparison-tab.html'
        });

        $stateProvider.state('projects.project.modelcomparisons.modelcomparison.feature_importance', {
            url: '/feature_importance',
            controller: "modelComparisonCompositionController",
            templateUrl: '/templates/modelcomparisons/comparison-tab.html'
        });

        $stateProvider.state('projects.project.modelcomparisons.modelcomparison.decision_chart', {
            url: '/decision_chart',
            controller: "modelComparisonCompositionController",
            templateUrl: '/templates/modelcomparisons/comparison-tab.html'
        });

        $stateProvider.state('projects.project.modelcomparisons.modelcomparison.lift_chart', {
            url: '/lift_chart',
            controller: "modelComparisonCompositionController",
            templateUrl: '/templates/modelcomparisons/comparison-tab.html'
        });

        $stateProvider.state('projects.project.modelcomparisons.modelcomparison.calibration_curve', {
            url: '/calibration_curve',
            controller: "modelComparisonCompositionController",
            templateUrl: '/templates/modelcomparisons/comparison-tab.html'
        });

        $stateProvider.state('projects.project.modelcomparisons.modelcomparison.roc_curve', {
            url: '/roc_curve',
            controller: "modelComparisonCompositionController",
            templateUrl: '/templates/modelcomparisons/comparison-tab.html'
        });

        $stateProvider.state('projects.project.modelcomparisons.modelcomparison.pr_curve', {
            url: '/pr_curve',
            controller: "modelComparisonCompositionController",
            templateUrl: '/templates/modelcomparisons/comparison-tab.html'
        });

        $stateProvider.state('projects.project.modelcomparisons.modelcomparison.density_chart', {
            url: '/density_chart',
            controller: "modelComparisonCompositionController",
            templateUrl: '/templates/modelcomparisons/comparison-tab.html'
        });

        $stateProvider.state('projects.project.modelcomparisons.modelcomparison.scatter_plot', {
            url: '/scatter_plot',
            controller: "modelComparisonCompositionController",
            templateUrl: '/templates/modelcomparisons/comparison-tab.html'
        });

        $stateProvider.state('projects.project.modelcomparisons.modelcomparison.uplift_charts', {
            url: '/uplift_charts',
            controller: "modelComparisonCompositionController",
            templateUrl: '/templates/modelcomparisons/comparison-tab.html'
        });

        $stateProvider.state('projects.project.modelcomparisons.modelcomparison.features', {
            url: '/features',
            controller: "modelComparisonCompositionController",
            templateUrl: '/templates/modelcomparisons/comparison-tab.html'
        });


        $stateProvider.state('projects.project.modelcomparisons.modelcomparison.training_information', {
            url: '/training_information',
            controller: "modelComparisonCompositionController",
            templateUrl: '/templates/modelcomparisons/comparison-tab.html'
        });

        $stateProvider.state('projects.project.modelcomparisons.modelcomparison.algorithm', {
            url: '/algorithm',
            controller: "modelComparisonCompositionController",
            templateUrl: '/templates/modelcomparisons/comparison-tab.html'
        });

        $stateProvider.state('projects.project.modelcomparisons.modelcomparison.ts_resampling', {
            url: '/timeseries_resampling',
            controller: "modelComparisonCompositionController",
            templateUrl: '/templates/modelcomparisons/comparison-tab.html'
        });

        $stateProvider.state('projects.project.modelcomparisons.modelcomparison.row_by_row_analysis', {
            url:'/row_by_row_analysis',
            controller: "modelComparisonCompositionController",
            templateUrl: '/templates/modelcomparisons/comparison-tab.html'
        })

        /* **************************  Model Evaluation Store (Flow) ********************** */

        $stateProvider.state('projects.project.modelevaluationstores', {
            url: '/modelevaluationstores',
            abstract: true,
            template: '<div ui-view></div>'
        });

        $stateProvider.state('projects.project.modelevaluationstores.list', {
            url: '/',
            templateUrl: '/templates/modelevaluationstores/list.html',
            controller: "ModelEvaluationStoreListController",
            pageTitle: () => {
                return " Model Evaluation Stores"
            }
        });

        $stateProvider.state('projects.project.modelevaluationstores.modelevaluationstore', {
            url: '/:mesId?discussionId',
            abstract: true,
            controller: "ModelEvaluationStoreController",
            templateUrl: '/templates/modelevaluationstores/modelevaluationstore.html'
        });

        $stateProvider.state('projects.project.modelevaluationstores.modelevaluationstore.evaluations', {
            url: '/evaluations/',
            controller: "ModelEvaluationStoreEvaluationsController",
            templateUrl: '/templates/modelevaluationstores/evaluations.html'
        });

        $stateProvider.state('projects.project.modelevaluationstores.modelevaluationstore.llmevaluation', {
            url: '/llmevaluations/:evaluationId',
            abstract: true,
            controller: "ModelEvaluationStoreLlmEvaluationController",
            template: '<div class="h100 vertical-flex model-evaluation__page"><div block-api-error /><div ui-view class="flex"></div></div>'
        });

        $stateProvider.state('projects.project.modelevaluationstores.modelevaluationstore.evaluation', {
            url: '/evaluations/:evaluationId',
            abstract: true,
            controller: "ModelEvaluationStoreBaseEvaluationController",
            templateUrl: '/templates/modelevaluationstores/evaluation.html'
        });

        $stateProvider.state('projects.project.modelevaluationstores.modelevaluationstore.evaluation.report', {
            url: '/report?driftReference',
            reloadOnSearch: false,
            templateUrl: '/templates/modelevaluationstores/evaluation-report.html',
            controller: function($scope, $state, $timeout) {
                $scope.uiState = $scope.uiState || {};
                $scope.setSettingsPane = (pane, skinId) => {
                    $scope.uiState.settingsPane = skinId ? pane + "-" + skinId : pane;
                    $scope.uiState.skinId = skinId;
                }

                const baseStateName = "projects.project.modelevaluationstores.modelevaluationstore.evaluation.report";
                $scope.$on('$stateChangeStart', function (event, toState, toParams, fromState, fromParams) {
                    GoToStateNameSuffixIfBase($state, toState, toParams, fromState, fromParams, baseStateName, "tabular-summary", event);
                });

                if ($state.current.name === baseStateName) {
                    $timeout(() => $state.go(".tabular-summary", null, {location: 'replace'}));
                }
            }
        });

        for (const {stateName, stateConfig} of MLModelsUIRouterStates.getModelevaluationsReportAndModelViewUIRouterStates()) {
            $stateProvider.state(
                'projects.project.modelevaluationstores.modelevaluationstore.evaluation.report.' + stateName,
                stateConfig
            )
        }

        $stateProvider.state('projects.project.modelevaluationstores.modelevaluationstore.status', {
            url: '/status',
            templateUrl: '/templates/modelevaluationstores/status.html'
        });

        $stateProvider.state('projects.project.modelevaluationstores.modelevaluationstore.status.metrics', {
            url: '/metrics/',
            templateUrl: '/templates/modelevaluationstores/status-metrics.html'
        });

        $stateProvider.state('projects.project.modelevaluationstores.modelevaluationstore.status.checks', {
            url: '/checks/',
            templateUrl: '/templates/modelevaluationstores/status-checks.html'
        });

        $stateProvider.state('projects.project.modelevaluationstores.modelevaluationstore.settings', {
            url: '/settings/',
            controller: "ModelEvaluationStoreSettingsController",
            templateUrl: '/templates/modelevaluationstores/settings.html'
        });

        /* ************************** Retrievable Knowledge (flow) ********************** */

        $stateProvider.state('projects.project.retrievableknowledges', {
            url: '/knowledge-bank',
            abstract: true,
            template: '<div ui-view></div>'
        });

        $stateProvider.state('projects.project.retrievableknowledges.list', {
            url: '/',
            templateUrl: '/templates/retrievable-knowledge/list.html',
            controller: "RetrievableKnowledgeListController",
            pageTitle: () => {
                return " Knowledge Banks"
            }
        });

        $stateProvider.state('projects.project.retrievableknowledges.retrievableknowledge', {
            url: '/:retrievableKnowledgeId',
            abstract: true,
            controller: "RetrievableKnowledgeController",
            templateUrl: '/templates/retrievable-knowledge/retrievable-knowledge.html'
        });

        $stateProvider.state('projects.project.retrievableknowledges.retrievableknowledge.search', {
            url: '/search/',
            controller: "RetrievableKnowledgeSearchController",
            templateUrl: '/templates/retrievable-knowledge/search.html'
        });

        $stateProvider.state('projects.project.retrievableknowledges.retrievableknowledge.usage', {
            url: '/usage/',
            controller: "RetrievableKnowledgeUsageController",
            templateUrl: '/templates/retrievable-knowledge/usage.html'
        });

        $stateProvider.state('projects.project.retrievableknowledges.retrievableknowledge.settings', {
            url: '/settings/',
            controller: "RetrievableKnowledgeSettingsController",
            templateUrl: '/templates/retrievable-knowledge/settings.html'
        });

        /* ************************** Labeling Task (Flow) ********************** */
        $stateProvider.state('projects.project.labelingtasks', {
            url: '/labelingtasks',
            abstract: true,
            template: '<div ui-view></div>'
        });

        $stateProvider.state('projects.project.labelingtasks.list', {
            url: '/',
            controller: "LabelingTasksListController",
            templateUrl: '/templates/labelingtasks/list.html',
            pageTitle: () => {
                return "Labeling tasks";
            }
        });

        $stateProvider.state('projects.project.labelingtasks.labelingtask', {
            url: '/:labelingTaskId?discussionId&identifier',
            controller: "LabelingTaskController",
            templateUrl: '/templates/labelingtasks/labelingtask.html',
            pageTitle: () => {
                return "Labeling task";
            }
        });

        $stateProvider.state('projects.project.labelingtasks.labelingtask.annotate', {
            url: '/annotate/',
            controller: 'LabelingTaskAnnotateController'
        });
        $stateProvider.state('projects.project.labelingtasks.labelingtask.review', {
            url: '/review/',
            controller: "LabelingTaskReviewController",
        });
        $stateProvider.state('projects.project.labelingtasks.labelingtask.overview', {
            url: '/overview/',
            controller: "LabelingTaskOverviewController",
        });
        $stateProvider.state('projects.project.labelingtasks.labelingtask.io', {
            url: '/io/',
            controller: "LabelingTaskIOController",
            templateUrl: '/templates/labelingtasks/labeling-task-io-tab.html'
        });
        $stateProvider.state('projects.project.labelingtasks.labelingtask.settings', {
            url: '/settings/:selectedTab',
            controller: "LabelingTaskSettingsController",
        });
        $stateProvider.state('projects.project.labelingtasks.labelingtask.history', {
            url: '/history/',
            controller: 'LabelingTaskHistoryController',
            templateUrl: '/templates/labelingtasks/labeling-task-history.html',
        });


        /* ************************** Managed folder (Flow) ********************** */

        $stateProvider.state('projects.project.managedfolders', {
            url: '/managedfolder',
            abstract: true,
            template: '<div ui-view></div>'
        });

        $stateProvider.state('projects.project.managedfolders.managedfolder', {
            url: '/:odbId?discussionId',
            abstract: true,
            controller: "ManagedFolderBaseController",
            templateUrl: '/templates/managedfolder/managedfolder.html'
        });

        $stateProvider.state('projects.project.managedfolders.managedfolder.view', {
            url: '/view/',
            params: {
                preUploadedFiles: null,
            },
            controller: "ManagedFolderViewController",
            templateUrl: '/templates/managedfolder/view.html',
            pageTitle: () => {
                return " Folder";
            }
        });

        $stateProvider.state('projects.project.managedfolders.managedfolder.settings', {
            url: '/settings/',
            controller: "ManagedFolderSettingsController",
            templateUrl: '/templates/managedfolder/settings.html',
            pageTitle: () => {
                return " Folder";
            }
        });

        $stateProvider.state('projects.project.managedfolders.managedfolder.status', {
            url: '/status',
            abstract: true,
            templateUrl: '/templates/managedfolder/status.html',
            controller: 'ManagedFolderStatusController',
            pageTitle: () => {
                return " Folder";
            }
        });

        $stateProvider.state('projects.project.managedfolders.managedfolder.status.settings', {
            url: '/settings',
            templateUrl: '/templates/managedfolder/status-settings.html'
        });

        $stateProvider.state('projects.project.managedfolders.managedfolder.status.metrics', {
            url: '',
            templateUrl: '/templates/managedfolder/status-metrics.html'
        });

        $stateProvider.state('projects.project.managedfolders.managedfolder.status.checks', {
            url: '/checks',
            templateUrl: '/templates/managedfolder/status-checks.html'
        });

        /* ************************** Foreign view of managed folders ********************** */

        $stateProvider.state('projects.project.foreignmanagedfolders', {
            url: '/foreignmanagedfolder',
            abstract: true,
            template: '<div ui-view></div>'
        });

        $stateProvider.state('projects.project.foreignmanagedfolders.managedfolder', {
            url: '/:odbId?discussionId?sourceProjectKey',
            abstract: true,
            controller: "ManagedFolderBaseController",
            templateUrl: '/templates/foreignmanagedfolder/managedfolder.html'
        });
        $stateProvider.state('projects.project.foreignmanagedfolders.managedfolder.view', {
            url: '/view/',
            controller: "ManagedFolderViewController",
            templateUrl: '/templates/managedfolder/view.html',
            pageTitle: () => {
                return " Folder";
            }
        });
        /* ************************** Recipes ********************** */

        $stateProvider.state('projects.project.recipes', {
            url: '/recipes',
            abstract: true,
            template: '<div ui-view></div>'
        });

        $stateProvider.state('projects.project.recipes.list', {
            url: '/',
            templateUrl: '/templates/recipes/list.html',
            controller: 'RecipesListController',
            pageTitle: () => {
                return "Recipes";
            }
        });

        $stateProvider.state('projects.project.recipes.new', {
            url: '/new/:type/?prefill&input&output',
            templateUrl: '/templates/recipes/recipe-editor.html',
            controller: 'RecipeEditorController',
            pageTitle: function(stateParams) {
                return "New " + stateParams.type + " recipe";
            }
        });

        $stateProvider.state('projects.project.recipes.recipe', {
            url: '/:recipeName/?newlyCreated?discussionId',
            templateUrl: '/templates/recipes/recipe-editor.html',
            controller: 'RecipeEditorController',
            pageTitle: function(stateParams) {
                return stateParams.recipeName + " - Recipe";
            },
            params: { isAIGenerated: false }
        });

        /* ************************** Flow jobs / monitoring  ********************** */

        $stateProvider.state('projects.project.jobs', {
            url: '/jobs',
            abstract: true,
            template: '<div ui-view></div>'
        });

        $stateProvider.state('projects.project.jobs.list', {
            url: '/',
            templateUrl: '/templates/jobs/list.html',
            controller: 'FlowJobsBrowserController',
            pageTitle: () => {
                return "Jobs";
            }
        });

        $stateProvider.state('projects.project.jobs.job', {
            url: '/:jobId/?hideFlow',
            templateUrl: '/templates/jobs/job-status.html',
            pageTitle: function(stateParams) {
                return "Job " + stateParams.jobId + "";
            },
        });

        $stateProvider.state('projects.project.datasets.new', {
            url: '/new/?zoneId',
            templateUrl: '/templates/datasets/new-dataset.html',
            controller: function($scope, CreateModalFromTemplate, TopNav, GlobalProjectActions) {
                TopNav.setItem(null);
                TopNav.setLocation(TopNav.TOP_FLOW, "new-dataset", TopNav.TABS_NONE, null);
                $scope.newManagedDataset = function() {
                    CreateModalFromTemplate("/templates/flow-editor/new-managed-dataset.html",
                        $scope, "NewManagedDatasetController");
                };

                GlobalProjectActions.getAllDatasetsByTiles($scope).then(val => $scope.datasetTiles = val);
                GlobalProjectActions.getHighlightedDatasets($scope).then(val => $scope.highlightedDatasets = val);
                $scope.startDatasetCreation = GlobalProjectActions.startDatasetCreation;

                // similar to what's done for the new dataset menu. Instead of a submenu, we show a tile
                const pluginSections = {};
                // get connectors, grouped by ownerPluginId
                $scope.appConfig.customDatasets.forEach(function(x) {
                    let pluginSection = pluginSections[x.ownerPluginId];
                    if (pluginSection == null) {
                        pluginSection = {
                            pluginId: x.ownerPluginId,
                            items: []
                        };
                        pluginSections[x.ownerPluginId] = pluginSection;
                    }

                    pluginSection.items.push({
                        type: x.datasetType,
                        label: x.desc.meta != null && x.desc.meta.label != null ? x.desc.meta.label : x.ownerPluginId,
                        icon: x.desc.meta != null ? x.desc.meta.icon : null
                    });
                });
                // get fs providers, grouped by ownerPluginId
                $scope.appConfig.customFSProviders.forEach(function(x) {
                    let pluginSection = pluginSections[x.ownerPluginId];
                    if (pluginSection == null) {
                        pluginSection = {
                            pluginId: x.ownerPluginId,
                            items: []
                        };
                        pluginSections[x.ownerPluginId] = pluginSection;
                    }

                    pluginSection.items.push({
                        type: x.fsProviderType,
                        label: x.desc.meta != null && x.desc.meta.label != null ? x.desc.meta.label : x.ownerPluginId,
                        icon: x.desc.meta != null ? x.desc.meta.icon : null
                    });
                });
                // fetch plugin label for each ownerPluginId
                $scope.customConnectorPlugins = [];
                $.each(pluginSections, function(pluginId, pluginData) {
                    const plugin = Array.dkuFindFn($scope.appConfig.loadedPlugins, function(n) {
                        return n.id == pluginId
                    });
                    if (plugin == null || plugin.hideComponents) {
                        return;
                    }
                    pluginData.items.forEach(function(dtype) {
                        if (!dtype.icon) dtype.icon = plugin.icon;
                    });
                    $scope.customConnectorPlugins.push({
                        isSection: true,
                        id: "plugin_" + plugin.id,
                        icon: plugin.icon,
                        label: plugin.label || plugin.id,
                        connectors: pluginData.items,
                        plugin: plugin
                    });
                });
            },
            pageTitle: () => {
                return "New dataset";
            }
        });

        /* ************************** Notebooks (SQL and jupyter) ********************** */

        $stateProvider.state('projects.project.notebooks', {
            url: '/notebooks',
            abstract: true,
            template: '<div ui-view class="h100"></div>'
        });

        $stateProvider.state('projects.project.notebooks.list', {
            url: '/?datasetId',
            templateUrl: '/templates/notebooks/list.html',
            controller: 'NotebooksController',
            pageTitle: () => {
                return "Notebooks";
            }
        });

        $stateProvider.state('projects.project.notebooks.jupyter_notebook', {
            url: '/jupyter/:notebookId/?discussionId&kernel_name',
            templateUrl: '/templates/notebooks/jupyter_notebook.html',
            controller: 'IPythonController',
            pageTitle: function(stateParams) {
                return stateParams.notebookId + " | Jupyter notebook";
            }
        });

        $stateProvider.state('projects.project.notebooks.jupyter_notebook_copied', {
            url: '/jupyter/:notebookId/copy/',
            templateUrl: '/templates/notebooks/jupyter_notebook.html',
            controller: function($scope, $stateParams, $sce) {
                $scope.$stateParams = $stateParams;
                $scope.notebookURL = $sce.getTrustedResourceUrl("/jupyter/notebooks/" + $stateParams.projectKey + "/" + $stateParams.notebookId + '/copy');
            },
            pageTitle: () => {
                return "Jupyter notebook";
            }
        });

        $stateProvider.state('projects.project.notebooks.sql_notebook', {
            url: '/sql/:notebookId/?discussionId',
            templateUrl: '/templates/notebooks/sql_notebook.html',
            controller: 'SQLNotebookController',
            // The user-friendly name is not in the stateParams, so the controller overrides the title
            pageTitle: () => {
                return "SQL notebook";
            },
            params: { cellId: null }
        });

        $stateProvider.state('projects.project.notebooks.search_notebook', {
            url: '/search/:notebookId/?discussionId',
            templateUrl: '/templates/notebooks/search-notebook.html',
            controller: 'SearchNotebookController',
            // The user-friendly name is not in the stateParams, so the controller overrides the title
            pageTitle: () => {
                return "Search notebook";
            }
        });

        $stateProvider.state('projects.project.promptstudios', {
            url: '/prompt-studios',
            abstract: true,
            template: '<div ui-view class="h100"></div>'
        });

        $stateProvider.state('projects.project.promptstudios.list', {
            url: '/',
            templateUrl: '/templates/promptstudios/list.html',
            controller: 'PromptStudiosListController',
            pageTitle: () => {
                return "Prompt Studios";
            }
        });

        $stateProvider.state('projects.project.promptstudios.promptstudio', {
            url: '/:promptStudioId',
            params: { promptId: null},
            templateUrl: '/templates/promptstudios/prompt-studio.html',
            controller: 'PromptStudioController'
        });

        $stateProvider.state('projects.project.promptstudios.promptstudio.prompt', {
            url: '/prompt/:promptId'
        });


        $stateProvider.state('projects.project.agenttools', {
            url: '/agent-tools',
            abstract: true,
            template: '<div ui-view class="h100"></div>'
        });

        $stateProvider.state('projects.project.agenttools.list', {
            url: '/?createTool',
            templateUrl: '/templates/agent-tools/list.html',
            controller: 'AgentToolsListController',
            params: {
                createTool: { value: null }
            },
            pageTitle: () => {
                return "Agent Tools";
            }
        });

        $stateProvider.state('projects.project.agenttools.agenttool', {
            url: '/:agentToolId',
            templateUrl: '/templates/agent-tools/agent-tool.html',
            controller: 'AgentToolController'
        });


        /* ************************** RStudio Server ********************** */

        $stateProvider.state('projects.project.rstudioserver', {
            url: '/rstudio-server',
            abstract: true,
            template: "<div ui-view></div>"
        });

        $stateProvider.state('projects.project.rstudioserver.embed', {
            url: '/',
            templateUrl: '/templates/rstudio-server/embed.html',
            controller: "RStudioServerEmbedController",
            pageTitle: () => {
                return "RStudio Server"
            }
        });

        /* ***************** Webapps ********************** */

        $stateProvider.state('projects.project.webapps', {
            url : "/webapps",
            abstract : true,
            template : "<div ui-view></div>"
        });

        $stateProvider.state('projects.project.webapps.list', {
            url : "/",
            templateUrl: '/templates/webapps/list.html',
            controller: 'WebAppsListController',
            pageTitle: () => {
                return "Webapps";
            }
        });

        $stateProvider.state('projects.project.webapps.webapp', {
            url : "/{webAppId}_{webAppName}?discussionId",
            templateUrl: '/templates/webapps/webapp.html',
            controller: 'WebAppCoreController',
            abstract: true
        });

        $stateProvider.state('projects.project.webapps.webapp.edit', {
            url : "/edit?{safe-mode}",
            templateUrl: '/templates/webapps/edit.html',
            pageTitle: () => {
                return "Webapp";
            }
        });

        $stateProvider.state('projects.project.webapps.webapp.view', {
            url : "/view",
            templateUrl: '/templates/webapps/view.html',
            pageTitle: () => {
                return "Webapp";
            }
        });

        $stateProvider.state('projects.project.webapps.webapp.history', {
            url : "/history",
            templateUrl: '/templates/webapps/history.html',
            controller : "WebAppHistoryController",
            pageTitle: () => {
                return "Webapp";
            }
        });

        $stateProvider.state('projects.project.webapps.webapp.logs', {
            url : "/logs",
            templateUrl: '/templates/webapps/logs.html',
            pageTitle: () => {
                return "Webapp";
            }
        });

        /* ***************** CodeStudios ********************** */

        $stateProvider.state('projects.project.code-studios', {
            url : "/code-studios",
            abstract : true,
            template : "<div ui-view></div>"
        });

        $stateProvider.state('projects.project.code-studios.list', {
            url : "/",
            templateUrl: ' /templates/code-studios/list.html',
            controller: 'CodeStudiosListController',
            pageTitle: () => "Code Studios"
        });

        $stateProvider.state('projects.project.code-studios.code-studio', {
            url : "/{codeStudioObjectId}?discussionId",
            templateUrl: ' /templates/code-studios/code-studio.html',
            controller: 'CodeStudioCoreController',
            abstract: true
        });

        $stateProvider.state('projects.project.code-studios.code-studio.view', {
        url : "/view?zone&file",
            templateUrl: ' /templates/code-studios/view.html',
            controller: 'CodeStudioViewController'
        });

        $stateProvider.state('projects.project.code-studios.code-studio.actions', {
            url : "/actions",
            templateUrl: ' /templates/code-studios/actions.html',
            controller: 'CodeStudioActionsController'
        });

        $stateProvider.state('projects.project.code-studios.code-studio.logs', {
            url : "/logs",
            templateUrl: ' /templates/code-studios/logs.html',
            controller: 'CodeStudioLogsController',
            params: {
                tab: ''
            }
        });

        $stateProvider.state('projects.project.code-studios.code-studio.files', {
            url : "/files",
            templateUrl: ' /templates/code-studios/files.html',
            controller: 'CodeStudioFilesController'
        });


        /* ***************** Reports ********************** */

        $stateProvider.state('projects.project.reports', {
            url : "/report",
            abstract : true,
            template : "<div ui-view></div>"
        });

        $stateProvider.state('projects.project.reports.list', {
            url : "/",
            templateUrl: '/templates/code-reports/list.html',
            controller: 'ReportsListController',
            pageTitle: () => {
                return "Report";
            }
        });

        $stateProvider.state('projects.project.reports.report', {
            url : "/{reportId}?discussionId",
            templateUrl: '/templates/code-reports/report.html',
            controller: 'ReportCoreController',
            abstract: true
        });

        $stateProvider.state('projects.project.reports.report.edit', {
            url : "/edit",
            templateUrl: '/templates/code-reports/edit.html',
            controller: 'ReportEditController',
            pageTitle: () => {
                return "Report";
            }
        });

        $stateProvider.state('projects.project.reports.report.view', {
            url : "/view",
            templateUrl: '/templates/code-reports/view.html',
            controller: 'ReportViewController',
            pageTitle: () => {
                return "Report";
            }
        });

        $stateProvider.state('projects.project.reports.report.history', {
            url : "/history",
            templateUrl: '/templates/code-reports/history.html',
            controller : "ReportHistoryController",
            pageTitle: () => {
                return "Report";
            }
        });

        /* ***************** Dashboards ********************** */

        $stateProvider.state('projects.project.dashboards', {
            url: "/dashboards",
            abstract: true,
            template: "<div ui-view></div>"
        });

        $stateProvider.state('projects.project.dashboards.list', {
            url: "/",
            templateUrl: '/templates/dashboards/list.html',
            controller: 'DashboardsListController',
            pageTitle: () => {
                return "Dashboards";
            }
        });

        $stateProvider.state('projects.project.dashboards.dashboard', {
            // eslint-disable-next-line no-useless-escape
            url: "/{dashboardId:[0-9a-zA-Z]*}{separator:\_{0,1}}{dashboardName}?discussionId",
            templateUrl: '/templates/dashboards/dashboard.html',
            controller: 'DashboardCoreController',
            abstract: true
        });

        $stateProvider.state('projects.project.dashboards.dashboard.edit', {
            url: "/edit/:pageId",
            templateUrl: '/templates/dashboards/edit.html',
            controller: "DashboardEditController",
            pageTitle: () => {
                return "Dashboard";
            }
        });

        $stateProvider.state('projects.project.dashboards.dashboard.view', {
            // to avoid the tilde character to be doubled by angular-ui, we specify the type of the query params as any
            // https://github.com/angular-ui/ui-router/issues/3790
            url: "/view/:pageId?fullScreen&embedded&{filters:any}&{pageFilters:any}",
            reloadOnSearch: false, // Do not reload page on filters param change
            templateUrl: '/templates/dashboards/view.html',
            controller: function($scope, TopNav) {
                TopNav.setLocation(TopNav.TOP_DASHBOARD, 'dashboards', null, 'view');
                if ($scope.dashboard) {
                    TopNav.setPageTitle($scope.dashboard.name + " - Dashboard");
                }
            },
            pageTitle: () => {
                return "Dashboard";
            }
        });

        $stateProvider.state('projects.project.dashboards.insights', {
            url: "/insights",
            abstract: true,
            template: "<div ui-view></div>"
        });

        $stateProvider.state('projects.project.dashboards.insights.list', {
            url: "/",
            templateUrl: '/templates/dashboards/insights/list.html',
            controller: 'InsightsListController',
            pageTitle: () => {
                return "Insights";
            }
        });

        for (const state of InsightsUIRouterStates.getInsightUIRouterStates('projects.project.dashboards.insights')) {
            $stateProvider.state(state.stateName, state.stateConfig);
        }

        /* ************************** Bundles ********************** */

        // DSS Design node

        $stateProvider.state('projects.project.bundlesdesign', {
            url: '/bundles-design',
            abstract: true,
            template: '<div ui-view></div>'
        });

        $stateProvider.state('projects.project.bundlesdesign.list', {
            url: '/?showProgressModalFor&bundleId&bundleTab',
            templateUrl: '/templates/bundles/design/list.html',
            controller: "DesignBundlesListController",
            pageTitle: () => {
                return "Bundles export";
            }
        });

        $stateProvider.state('projects.project.bundlesdesign.new', {
            url: '/new/',
            templateUrl: '/templates/bundles/design/new.html',
            controller: "DesignBundlesNewController",
            pageTitle: () => {
                return "Create bundle";
            }
        });

        // DSS Automation node

        $stateProvider.state('projects.project.bundlesautomation', {
            url: '/bundles-automation',
            abstract: true,
            template: '<div ui-view></div>'
        });

        $stateProvider.state('projects.project.bundlesautomation.list', {
            url: '/',
            templateUrl: '/templates/bundles/automation/list.html',
            controller: "AutomationBundlesListController",
            pageTitle: () => {
                return "Bundles management";
            }
        });

        $stateProvider.state('projects.project.bundlesautomation.settings', {
            url: '/settings/',
            templateUrl: '/templates/bundles/automation/activation-settings.html',
            controller: "AutomationBundlesSettingsController",
            pageTitle: () => {
                return "Bundles settings";
            }
        });

        /* ************************** Mass import           ********************** */
        $stateProvider.state('projects.project.tablesimport', {
            url: '/import-tables?zoneId',
            templateUrl: '/templates/datasets/project-tables-import.html',
            controller: 'ProjectMassTableToDatasetController',
            params: {
                importData: null
            },
            pageTitle: () => {
                return "Import tables";
            }
        });

        $stateProvider.state('alationOpen', {
            url: '/alation-open/:alationOpenId',
            templateUrl: '/templates/datasets/alation-open.html',
            controller: "AlationOpenController",
            pageTitle: () => {
                return "Mass import";
            }
        });

        /* ************************** API Services (Lambda) ********************** */

        $stateProvider.state('projects.project.lambdaservices', {
            url: '/api-designer',
            abstract: true,
            template: '<div ui-view></div>'
        });

        $stateProvider.state('projects.project.lambdaservices.list', {
            url: '/',
            templateUrl: '/templates/lambda/list.html',
            controller: "LambdaServicesListController",
            pageTitle: () => {
                return "API Services";
            }
        });

        $stateProvider.state('projects.project.lambdaservices.service', {
            url: '/:serviceId?discussionId',
            abstract: true,
            controller: "LambdaServiceBaseController",
            templateUrl: '/templates/lambda/lambda-service.html'
        });

        $stateProvider.state('projects.project.lambdaservices.service.summary', {
            url: '/summary/',
            controller: "LambdaServiceSummaryController",
            templateUrl: '/templates/lambda/summary.html'
        });

        $stateProvider.state('projects.project.lambdaservices.service.endpoints', {
            url: '/endpoints/',
            controller: "LambdaServiceEndpointsController",
            templateUrl: '/templates/lambda/endpoints.html'
        });

        $stateProvider.state('projects.project.lambdaservices.service.config', {
            url: '/config/',
            controller: "LambdaServiceConfigController",
            templateUrl: '/templates/lambda/lambda-service-config.html'
        });

        $stateProvider.state('projects.project.lambdaservices.service.packages', {
            url: '/packages/',
            controller: "LambdaServicePackagesController",
            templateUrl: '/templates/lambda/packages.html'
        });

        /* ************************** Wiki ********************** */

        $stateProvider.state('projects.project.wiki', {
            url: '/wiki',
            controller: "WikiController",
            templateUrl: '/templates/wikis/wiki.html'
        });

        $stateProvider.state('projects.project.wiki.article', {
            url: '/:articleId/:articleName?fullScreen',
            abstract: true,
            controller: "ArticleController",
            params: {
                // When no articleName is given through the URL, the router will act as if it didn't exist
                // (aka having url:'/:articleId')
                articleName: {squash: true, value: null}
            },
            templateUrl: '/templates/wikis/article.html'
        });

        // templates for the 3 sub-routes for wiki are handled through ng-show and ng-if instead of ui-view because we need to keep the editor state when switching tabs
        // note that history template is kept at the top in order to trigger infinite-scroll directive when switching tabs
        $stateProvider.state('projects.project.wiki.article.view', {
            url: '?discussionId'
        });

        $stateProvider.state('projects.project.wiki.article.edit', {
            url: '/edit'
        });

        $stateProvider.state('projects.project.wiki.article.history', {
            url: '/history'
        });

        $stateProvider.state('projects.wikis', { //mjt placeholder for the page PC is writing
            url: '/wikis',
            templateUrl: '/templates/wikis/article-history.html'
        });

        /* ************************** Scenarios ********************** */

        $stateProvider.state('projects.project.scenarios', {
            url: '/scenarios',
            abstract: true,
            controller: "ScenarioCoreController",
            template: '<div ui-view></div>'
        });

        $stateProvider.state('projects.project.scenarios.list', {
            url: '/',
            templateUrl: '/templates/scenarios/list.html',
            controller: "ScenariosListController",
            pageTitle: () => {
                return "Scenarios";
            }
        });

        $stateProvider.state('projects.project.scenarios.scenario', {
            url: '/:scenarioId?discussionId',
            templateUrl: '/templates/scenarios/scenario.html',
            controller: "ScenarioController",
            pageTitle: () => {
                return "Scenario";
            }
        });

        $stateProvider.state('projects.project.scenarios.scenario.settings', {
            url: '/settings',
            templateUrl: '/templates/scenarios/fragments/scenario-settings.html'
        });

        $stateProvider.state('projects.project.scenarios.scenario.runs', {
            url: '/runs',
            abstract: true,
            templateUrl: '/templates/scenarios/fragments/scenario-runs-timeline.html'
        });

        $stateProvider.state('projects.project.scenarios.scenario.runs.list', {
            url: '/list',
            templateUrl: '/templates/scenarios/fragments/scenario-runs.html'
        });
        // same as above, but go directly to a run
        $stateProvider.state('projects.project.scenarios.scenario.runs.list.run', {
            url: '/:runId',
            templateUrl: '/templates/scenarios/scenario.html',
            controller: "ScenarioRunController",
            pageTitle: () => {
                return "Scenario";
            }
        });

        $stateProvider.state('projects.project.scenarios.scenario.runs.timeline', {
            url: '/timeline',
            templateUrl: '/templates/scenarios/fragments/scenario-timeline.html'
        });

        $stateProvider.state('projects.project.scenarios.scenario.history', {
            url: '/history',
            controller: "ScenarioHistoryController",
            templateUrl: '/templates/scenarios/fragments/scenario-git-log.html'
        });

        $stateProvider.state('projects.project.scenarios.scenario.steps', {
            url: '/steps',
            templateUrl: '/templates/scenarios/fragments/scenario-steps.html'
        });

        $stateProvider.state('projects.project.scenarios.scenario.script', {
            url: '/script',
            templateUrl: '/templates/scenarios/fragments/scenario-script.html'
        });

        $stateProvider.state('projects.project.data-quality', {
            url: '/data-quality',
            abstract: true,
            template: `<ng2-project-quality-tab-view
                [can-edit]="projectSummary.canWriteProjectContent"
                [can-publish-to-dashboards]="projectSummary.canWriteDashboards"
            ></ng2-project-quality-tabview>`
        });

        $stateProvider.state('projects.project.data-quality.current-status', {
            url: '/current-status',
            template: `
                <ng2-current-status-panel
                    [project-key]="$root.$state.params.projectKey"
                    [can-edit]="addToScope.canEdit"
                    [can-publish-to-dashboards]="addToScope.canPublishToDashboards"
                >
                </ng2-current-status-panel>
            `
        });

        $stateProvider.state('projects.project.data-quality.timeline', {
            url: '/timeline',
            template: '<ng2-project-quality-timeline-panel [project-key]="$root.$state.params.projectKey"></ng2-project-quality-timeline-panel>'
        });

        $stateProvider.state('projects.project.automation', {
            url: '/automation',
            abstract: true,
            template: '<div ui-view></div>',
            controller: "ScenariosMonitoringController",
        });

        const projectMonitoringParams = {
            templateUrl: '/templates/scenarios/scenarios-monitoring.html',
            pageTitle: () => {
                return "Monitoring";
            },
        };

        $stateProvider.state('projects.project.automation.test-dashboard', {
            url: '/test-dashboard',
            ...projectMonitoringParams,
            params: {
                activeTab: 'testDashboard',
                scopeToDay: null
            }
        });

        const projectMonitoringStates = [
            { name: 'timeline', route:'timeline', url: '/timeline' },
            { name: 'outcomes', route:'outcomes', url: '' },
            { name: 'timeline', route:'timeline.scoped', url: '/:scopeToDay' },
            { name: 'outcomes', route:'outcomes.scoped', url: '/:scopeToDay' }
        ];

        projectMonitoringStates.forEach(state => {
            $stateProvider.state(`projects.project.automation.${state.route}`, {
                url: state.url,
                ...projectMonitoringParams,
                params: {
                    activeTab: state.name,
                    scenarioQuery: null
                }
            });
        });

        /* ************************** Continuous Activities ********************** */
        $stateProvider.state('projects.project.continuous-activities', {
            url: '/continuous-activities',
            abstract: true,
            template: '<div ui-view></div>'
        });

        $stateProvider.state('projects.project.continuous-activities.list', {
            url: '/',
            templateUrl: '/templates/continuous-activities/list.html',
            controller: "ContinuousActivitiesListController",
            pageTitle: () => {
                return "Continuous Activities";
            }
        });

        $stateProvider.state('projects.project.continuous-activities.continuous-activity', {
            url: '/:continuousActivityId',
            templateUrl: '/templates/continuous-activities/continuous-activity.html',
            controller: "ContinuousActivityController",
            pageTitle: () => {
                return "Continuous Activity";
            }
        });

        $stateProvider.state('projects.project.continuous-activities.continuous-activity.runs', {
            url: '/runs?runId&attemptId',
            templateUrl: '/templates/continuous-activities/runs.html'
        });

        /* ************************** Macros ********************** */

        $stateProvider.state('projects.project.runnables', {
            url: '/macros',
            abstract: true,
            controller: "RunnableCoreController",
            template: '<div ui-view></div>'
        });

        $stateProvider.state('projects.project.runnables.list', {
            url: '/',
            templateUrl: '/templates/macros/runnables.html',
            controller: "RunnablesListController",
            pageTitle: () => {
                return "Macros";
            }
        });

        /* ************************** Dataiku Workspaces ********************** */

        WorkspacesUIRouterStates.getWorkspacesUIRouterStates().forEach(uiRouterState => {
            $stateProvider.state(uiRouterState.stateName, uiRouterState.stateConfig);
        });

        /* ************************** User profile pages ********************** */

        $stateProvider.state('profile', {
            abstract: true,
            url: '/profile',
            template: '<div ui-view></div>'
        });

        $stateProvider.state('profile.my', {
            url: '/',
            abstract: true,
            templateUrl: '/templates/profile/index.html',
            controller: 'ProfileController'
        });

        /* Default */
        $stateProvider.state('profile.my.settings', {
            url: '',
            templateUrl: '/templates/profile/settings.html',
            pageTitle: () => {
                return "Profile settings";
            },
            controller: 'MyProfileAccountController',
            params: { scrollTo: undefined },
            data: {selectedTab: 'settings'}
        });

        $stateProvider.state('profile.my.achievements', {
            url: 'achievements/',
            templateUrl: '/templates/profile/achievements.html',
            pageTitle: () => {
                return "My profile";
            },
            controller: 'MyProfileAchievementsController',
            data: {selectedTab: 'achievements'}
        });

        $stateProvider.state('profile.my.exports', {
            url: 'exports/',
            templateUrl: '/templates/profile/exports.html',
            pageTitle: () => {
                return "My exports";
            },
            controller: 'MyProfileExportController',
            data: {selectedTab: 'exports'}
        });

        $stateProvider.state('profile.my.stars', {
            url: 'stars/',
            templateUrl: '/templates/profile/stars.html',
            pageTitle: () => {
                return "My stars";
            },
            controller: 'MyProfileStarsController',
            data: {selectedTab: 'stars'}
        });

        $stateProvider.state('profile.my.credentials', {
            url: 'credentials/',
            templateUrl: '/templates/profile/credentials.html',
            pageTitle: () => {
                return "Personal credentials";
            },
            controller: 'MyProfileConnectionCredentialsController',
            data: {selectedTab: 'credentials'}
        });


        $stateProvider.state('profile.my.apikeys', {
            url: 'apikeys/',
            templateUrl: '/templates/profile/personal-api-keys.html',
            pageTitle: () => {
                return "Personal API Keys";
            },
            controller: 'MyProfilePersonalAPIKeysController',
            data: {selectedTab: 'apikeys'}
        });

        $stateProvider.state('profile.my.account', {
            url: 'account/',
            templateUrl: '/templates/profile/account.html',
            pageTitle: () => {
                return "Account";
            },
            controller: 'MyProfileEditController',
            data: {selectedTab: 'account'}
        });

        $stateProvider.state('profile.my.files', {
            url: 'files/',
            templateUrl: '/templates/profile/files.html',
            pageTitle: () => {
                return "Files";
            },
            controller: 'MyFilesEditController',
            data: {selectedTab: 'files'}
        });

        $stateProvider.state('profile.my.notifications', {
            url: 'notifications/',
            templateUrl: '/templates/profile/notifications.html',
            pageTitle: () => {
                return "My notifications";
            },
            data: {selectedTab: 'notifications'}
        });

        $stateProvider.state('oauth2-callback', {
            url: '/oauth2-callback',
            pageTitle: () => {
                return "OAuth2 callback";
            },
            controller: 'OAuth2CallbackController'
        });

        $stateProvider.state('profile.user', {
            url: '/:userLogin/',
            abstract: true,
            templateUrl: '/templates/profile/index.html',
            controller: 'ProfileController'
        });

        $stateProvider.state('profile.user.view', {
            url: '',
            templateUrl: '/templates/profile/achievements.html',
            controller: 'MyProfileAchievementsController',
            pageTitle: () => {
                return "Profile";
            }
        });

        /* ************************** Plugins ********************** */

        $stateProvider.state('plugins', {
            url: '/plugins-explore',
            controller: 'PluginsExploreController',
            templateUrl: '/templates/plugins/index.html',
            pageTitle: () => {
                return 'Plugins';
            }
        });

        $stateProvider.state('plugins.store', {
            url: '/store/:pluginid',
            templateUrl: '/templates/plugins/store-list.html',
            controller: 'PluginsStoreController',
            pageTitle: () => {
                return 'Plugins store';
            }
        });

        $stateProvider.state('plugins.installed', {
            url: '/installed/',
            templateUrl: '/templates/plugins/installed-list.html',
            pageTitle: () => {
                return 'Installed plugins';
            }
        });

        $stateProvider.state('plugins.development', {
            url: '/development/',
            templateUrl: '/templates/plugins/development-list.html',
            pageTitle: () => {
                return 'Plugins Development';
            }
        });

        /* ************************** Plugin page ********************** */

        $stateProvider.state('plugin', {
            url: '/plugins/:pluginId?pluginVersion',
            controller: 'PluginController',
            abstract: true,
            templateUrl: '/templates/plugins/plugin-details/index.html'
        });

        $stateProvider.state('plugin.installation', {
            url: '/installation/',
            controller: 'PluginInstallationController',
            templateUrl: '/templates/plugins/plugin-details/installation.html',
            pageTitle: function($stateParams) {
                return 'Installing ' + $stateParams.pluginId;
            }
        });

        $stateProvider.state('plugin.update', {
            url: '/update/',
            controller: 'PluginInstallationController',
            templateUrl: '/templates/plugins/plugin-details/installation.html',
            pageTitle: function($stateParams) {
                return 'Updating ' + $stateParams.pluginId;
            }
        });

        $stateProvider.state('plugin.upload', {
            url: '/upload',
            controller: 'PluginInstallationController',
            templateUrl: '/templates/plugins/plugin-details/installation.html',
            params: { uploadedPluginFile: null },
            pageTitle: function($stateParams) {
                return 'Uploading ' + $stateParams.pluginId;
            }
        });

        $stateProvider.state('plugin.upload.update', {
            url: '/update/',
            controller: 'PluginInstallationController',
            templateUrl: '/templates/plugins/plugin-details/installation.html',
            params: { uploadedPluginFile: null },
            pageTitle: function($stateParams) {
                return 'Updating ' + $stateParams.pluginId;
            }
        });

        $stateProvider.state('plugin.installationfromgit', {
            url: '/install-from-git/?uri&checkout&path&pluginName',
            controller: 'PluginInstallationController',
            templateUrl: '/templates/plugins/plugin-details/installation.html',
            pageTitle: () => {
                return 'Installing from Git'
            }
        });

        $stateProvider.state('plugin.updatefromgit', {
            url: '/update-from-git/?uri&checkout&path&pluginName',
            controller: 'PluginInstallationController',
            templateUrl: '/templates/plugins/plugin-details/installation.html',
            pageTitle: () => {
                return 'Updating from Git'
            }
        });


        $stateProvider.state('plugin.summary', {
            url: '/summary/',
            templateUrl: '/templates/plugins/plugin-details/summary.html',
            controller: 'PluginSummaryController',
            pageTitle: function($stateParams) {
                return 'Plugin - ' + $stateParams.pluginId ;
            }
        });

        $stateProvider.state('plugin.settings', {
            url: '/settings/:selectedTab',
            templateUrl: '/templates/plugins/plugin-details/settings.html',
            controller: 'PluginSettingsController',
            pageTitle: function($stateParams) {
                return 'Plugin settings - ' + $stateParams.pluginId ;
            }
        });

        $stateProvider.state('plugin.usages', {
            url: '/usages/',
            templateUrl: '/templates/plugins/plugin-details/usages.html',
            controller: 'PluginUsagesController',
            pageTitle: function($stateParams) {
                return 'Plugin usages - ' + $stateParams.pluginId ;
            }
        });

        $stateProvider.state('plugindev', {
            url: '/plugins/development/:pluginId',
            abstract: true,
            templateUrl: '/templates/plugins/development/plugin-details/index.html',
            controller: 'PlugindevEditionController'
        });

        $stateProvider.state('plugindev.definition', {
            url: '/definition/',
            templateUrl: '/templates/plugins/development/plugin-details/definition.html',
            controller: 'PlugindevDefinitionController',
            pageTitle: function($stateParams) {
                return 'Plugin - ' + $stateParams.pluginId;
            }
        });

        $stateProvider.state('plugindev.settings', {
            url: '/settings/:selectedTab',
            templateUrl: '/templates/plugins/development/plugin-details/settings.html',
            controller: 'PluginSettingsController',
            pageTitle: function($stateParams) {
                return 'Plugin settings - ' + $stateParams.pluginId;
            }
        });

        $stateProvider.state('plugindev.usages', {
            url: '/usages/',
            templateUrl: '/templates/plugins/plugin-details/usages.html',
            controller: 'PluginUsagesController',
            pageTitle: function($stateParams) {
                return 'Plugin usages - ' + $stateParams.pluginId ;
            }
        });

        $stateProvider.state('plugindev.editor', {
            url: '/editor/',
            templateUrl: '/templates/plugins/development/plugin-details/editor.html',
            controller: 'PlugindevEditorController',
            // to pass a param without putting it into the url
            resolve: {
                filePath: function($stateParams){
                    return $stateParams.filePath;
                }
            },
            params: {
                filePath: null
            },
            pageTitle: function($stateParams) {
                return 'Plugin Editor - ' + $stateParams.pluginId ;
            }
        });

        $stateProvider.state('plugindev.history', {
            url: '/development/history/',
            templateUrl: '/templates/plugins/development/plugin-details/history.html',
            controller: 'PlugindevHistoryController',
            pageTitle: function($stateParams) {
                return 'Plugin History - ' + $stateParams.pluginId ;
            }
        });

        $stateProvider.state("libedition", {
            url: '/libedition',
            abstract: true,
            templateUrl: '/templates/plugins/development/lib-edition.html',
            controller: 'TopLevelFolderEditionController'
        });

        $stateProvider.state('libedition.libpython', {
            url: '/libpython?initialPath',
            templateUrl: '/templates/plugins/development/lib-python-editor.html',
            params: {
                initialPath: ''
            },
        });

        $stateProvider.state('libedition.libr', {
            url: '/libr',
            templateUrl: '/templates/plugins/development/lib-r-editor.html'
        });

        $stateProvider.state('libedition.localstatic', {
            url: '/localstatic',
            templateUrl: '/templates/plugins/development/local-static-editor.html',
            controller: 'TopLevelLocalStaticEditorController'
        });

        /* ************************** Autogenerated Python Doc ********************** */
        $stateProvider.state('docportal', {
            url: '/docportal?scope&projectKey&packageName&moduleName&className',
            template: '<ng2-doc-portal-home-page' +
                ' [scope]="$state.params.scope"' +
                ' [project-key]="$state.params.projectKey"' +
                ' [package-name]="$state.params.packageName"' +
                ' [module-name]="$state.params.moduleName"' +
                ' [class-name]="$state.params.className"' +
                '></ng2-doc-portal-home-page>',
            pageTitle: () => "Documentation Portal",
            controller: function(TopNav, $stateParams) {
                TopNav.setLocation(TopNav.DSS_HOME, "docportal");
            }
        });

        /* ************************** Feature Store ********************** */
        $stateProvider.state('featurestore', {
            url: '/feature-store',
            template: '<ng2-feature-store></ng2-feature-store>',
            pageTitle: () => {
                return "Feature Store";
            }
        });

        $stateProvider.state('projects.project.featurestore', {
            url: '/feature-store?zoneId',
            template: '<ng2-feature-store project-key="{{$state.params.projectKey}}" [zone-id]="$state.params.zoneId"></ng2-feature-store>',
            pageTitle: () => {
                return "Feature Store";
            }
        });

        /* ************************** Catalog ********************** */

        $stateProvider.state("catalog", {
            url: '/search-dss-items',
            abstract: true,
            templateUrl: '/templates/catalog/index.html',
            controller: function(TopNav) {
                TopNav.setLocation("DSS_HOME", "catalog", "items", null);
            }
        });

        const catalogItems = {
            url: '/:hash',
            templateUrl: '/templates/catalog/search.html',
            controller: "CatalogItemsController",
            params: {
                scope: null,
                _type: null
            },
            pageTitle: () => {
                return "Search DSS Items";
            }
        };

        const catalogMeanings = {
            url: '/meanings/:hash',
            templateUrl: '/templates/catalog/search.html',
            controller: "CatalogMeaningsController",
            pageTitle: () => {
                return "Meanings";
            }
        };

        $stateProvider.state('meanings', {
            url: '/meanings',
            templateUrl: '/templates/meanings/index.html',
            controller: "CatalogMeaningsController",
            pageTitle: () => {
                return "Meanings";
            }
        });

        $stateProvider.state('projects.project.catalog', {
            url: '/search-dss-items',
            abstract: true,
            templateUrl: '/templates/catalog/index.html',
            controller: function(TopNav) {
                TopNav.setLocation(TopNav.TOP_FLOW, "datasets", TopNav.TABS_NONE, null);
                TopNav.setNoItem();
            }
        });

        $stateProvider.state("catalog.items", $.extend({}, catalogItems));
        $stateProvider.state("projects.project.catalog.items", $.extend({}, catalogItems, { url:catalogItems.url+'?zoneId' }));
        $stateProvider.state("projects.project.catalog.meanings", $.extend({}, catalogMeanings));

        /* ************************** DATA CATALOG ********************** */

        // --- Redirect legacy catalog to homepage v2
        redirectedAbstractState($stateProvider, 'oldcatalog', '/catalog');
        redirectState($stateProvider, "oldcatalog.connection-explorer", "homeV2.data-catalog.database-explorer", "/connection-explorer?connectionName?schemaName?catalogName", true);
        $stateProvider.state('oldcatalog.items', { // old catalog to the new search-dss page or data-catalog
            url: '/search/:hash',
            controller: function($state, $stateParams) {
                if($stateParams.hash.includes('scope=external') || $stateParams.hash.includes('_type=table')) {
                    $state.go('homeV2.data-catalog.datasources', { selectedTab: 'external-tables' }, { location: 'replace' });
                } else {
                    // scope=all isn't reachable in search-dss, so we replace it by dss.
                    const hash = $stateParams.hash.replace('scope=all', 'scope=dss');
                    $state.go('catalog.items', { hash }, { location: 'replace' });
                }
            }
        });

        // --- Redirect 2022 out-of-project catalog to homepage v2
        redirectedAbstractState($stateProvider, 'datacatalog', '/data-catalog');
        redirectState($stateProvider, 'datacatalog.home', 'homeV2.data-catalog.home', '/');
        redirectedAbstractState($stateProvider, 'datacatalog.datacollections', '/data-collections');
        redirectState($stateProvider, 'datacatalog.datacollections.home', 'homeV2.data-catalog.data-collections.home', '/');
        redirectState($stateProvider, 'datacatalog.datacollections.datacollection', 'homeV2.data-catalog.data-collections.data-collection', '/:dataCollectionId/', true);
        redirectState($stateProvider, 'datacatalog.database-explorer', 'homeV2.data-catalog.database-explorer', '/connection-explorer?connectionName?schemaName?catalogName', true);
        redirectState($stateProvider, 'datacatalog.datasources', 'homeV2.data-catalog.datasources', '/:selectedTab', true); // must be placed last in order to prevent /:selectedTab to match with other routes

        // in-project data-catalog

        $stateProvider.state("projects.project.datacatalog", {
            url: '/data-catalog?zoneId',
            abstract: true,
            template: '<ui-view></ui-view>',
            controller: function(TopNav) {
                TopNav.setLocation(TopNav.TOP_FLOW, "catalog");
            },
        });

        $stateProvider.state("projects.project.datacatalog.home", {
            url: '/',
            template: '<ng2-data-catalog-home-page></ng2-data-catalog-home-page>',
            pageTitle: () => "Data Catalog"
        });

        $stateProvider.state("projects.project.datacatalog.datacollections", {
            url: '/data-collections',
            abstract: true,
            template: '<ui-view></ui-view>'
        });

        $stateProvider.state("projects.project.datacatalog.datacollections.home", {
            url: '/',
            template: '<ng2-data-collections-home-page [from-project]="true"></ng2-data-collections-home-page>',
            pageTitle: () => "Data Catalog"
        });

        $stateProvider.state("projects.project.datacatalog.datacollections.datacollection", {
            url: '/:dataCollectionId/',
            template: '<ng2-data-collection-page class="db h100 page-background" [id]="$root.$stateParams.dataCollectionId" [is-in-project]="true"></ng2-data-collection-page>',
            pageTitle: () => "Data Catalog"
        });

        $stateProvider.state('projects.project.datacatalog.database-explorer', {
            url: '/database-explorer?connectionName?schemaName?catalogName',
            template: '<database-explorer is-in-project="true"></database-explorer>',
            controller: "DatabaseExplorerController",
            pageTitle: () => 'Database explorer'
        });

        redirectState($stateProvider, 'projects.project.datacatalog.connection-explorer', 'projects.project.datacatalog.database-explorer', '/connection-explorer?connectionName?schemaName?catalogName', true);

        // Data Catalog > Data Sources - keep last to no override other data-catalog/xxx routes
        $stateProvider.state('projects.project.datacatalog.datasources', {
            url: '/:selectedTab',
            template: '<ng2-data-sources [query-on-load]="$root.$stateParams.queryOnLoad" [preselected-item]="$root.$stateParams.preselectedItem"></ng2-data-sources>',
            params: {
                queryOnLoad: null, // optionally set the query after load
                preselectedItem: undefined // optionally select an item (if it's in the results of the first query)
            },
            pageTitle: () => "Datasets & Indexed Tables"
        });


        /* ************************** DATA LINEAGE ********************** */

        // --- Redirect from old data-lineage URLs (when it was inside Data catalog) to the new ones
        redirectedAbstractState($stateProvider, 'datacatalog.datalineage', '/data-lineage');
        redirectState($stateProvider, "datacatalog.datalineage.home", "datalineage.home", "/");
        redirectState($stateProvider, "datacatalog.datalineage.graph", "datalineage.graph", "/:contextProjectKey/:smartName/:columnName", true);
        redirectState($stateProvider, "datacatalog.datalineage.homeWithParams", "datalineage.homeWithParams", "/:contextProjectKey/:smartName/", true);
        redirectState($stateProvider, "datacatalog.datalineage.export", "datalineage.export", "/export/:contextProjectKey/:smartName/:columnName", true);


        // --- Current version
        $stateProvider.state('datalineage', {
            url: '/data-lineage',
            abstract: true,
            template: '<ui-view></ui-view>',
            controller: function(TopNav) {
                TopNav.setLocation(TopNav.DSS_HOME);
            },
        });

        $stateProvider.state("datalineage.export", {
            url: '/export/:contextProjectKey/:smartName/:columnName',
            template: `<ng2-data-lineage-home-page
                [context-project-key]="$stateParams.contextProjectKey"
                [smart-name]="$stateParams.smartName"
                [column-name]="$stateParams.columnName"
                [lineage-export]="true"
            ></ng2-data-lineage-home-page>`
        })

        const dataLineageHome = {
            url: '/',
            template: `<ng2-data-lineage-home-page></ng2-data-lineage-home-page>`,
            pageTitle: () => "Data Lineage"
        };
        $stateProvider.state("datalineage.home", {...dataLineageHome});

        const dataLineageHomeWithParams = {
            url: '/:contextProjectKey/:smartName/',
            template: `<ng2-data-lineage-home-page
                [context-project-key]="$stateParams.contextProjectKey"
                [smart-name]="$stateParams.smartName"
            ></ng2-data-lineage-home-page>`,
            pageTitle: () => "Data Lineage"
        };
        $stateProvider.state("datalineage.homeWithParams", {...dataLineageHomeWithParams});

        const dataLineageGraph = {
            url: '/:contextProjectKey/:smartName/:columnName',
            template: `<ng2-data-lineage-home-page
                [context-project-key]="$stateParams.contextProjectKey"
                [smart-name]="$stateParams.smartName"
                [column-name]="$stateParams.columnName"
            ></ng2-data-lineage-home-page>`,
            pageTitle: () => "Data Lineage"
        };
        $stateProvider.state("datalineage.graph", {...dataLineageGraph});


        /* ************************** EXTERNAL TABLES ********************** */
        $stateProvider.state("external-table", {
            url: '/external-table/:connection/:catalog/:schema/:table',
            abstract: true,
            templateUrl: '/templates/catalog/external-table/index.html',
            controller: "ExternalTableController"
        });

        $stateProvider.state("external-table.summary", {
            url: '',
            template: '<external-table-summary class="h100"></external-table-summary>'
        });

        $stateProvider.state("external-table.schema", {
            url: '/schema/',
            templateUrl: '/templates/catalog/external-table/schema.html'
        });
        $stateProvider.state("external-table.sample", {
            url: '/sample/',
            templateUrl: '/templates/catalog/external-table/sample.html'
        });
        $stateProvider.state("external-table.items", {
            url: '/items/',
            templateUrl: '/templates/catalog/external-table/items.html'
        });

        /* ************************** INBOX ********************** */

        $stateProvider.state("inbox", {
            url: "/inbox",
            template: "<inbox></inbox>",
            abstract: true,
        });

        /* ************************** NOTIFICATION CENTER ********************** */

        $stateProvider.state("inbox.requests", {
            url: "/requests/",
            template: "<request-center></request-center>" ,
            pageTitle: () => {
                return "Inbox - Requests center";
            },
        });

        $stateProvider.state("inbox.requests.selected", {
            url: ":requestId",
            template: '<request></request>', // note: request requires to be included in the request-center component
            pageTitle: () => {
                return "Inbox - Requests center";
            },
        });

        /* ************************** CONVERSATION CENTER ********************** */

        $stateProvider.state("inbox.conversations", {
            url: '/conversations/',
            templateUrl: '/templates/catalog/inbox.html',
            controller: 'DiscussionsInboxController',
            pageTitle: () => {
                return "Inbox - Conversations center";
            }
        });

        /* ************************** Deployer ********************** */

        $stateProvider.state('deployer', {
            url: '/deployer/',
            controller: 'DeployerHomeController',
            templateUrl: '/templates/deployer/index.html',
            pageTitle: () => "Deployer"
        });

        /* ************************** Unified Monitoring ********************** */

        $stateProvider.state('unified-monitoring', {
            url: '/unified-monitoring',
            controller: 'UnifiedMonitoringController',
            abstract: true,
            templateUrl: '/templates/unified-monitoring/index.html'
        });

        $stateProvider.state('unified-monitoring.overview', {
            url: '/',
            template: `<ng2-unified-monitoring-overview-page></ng2-unified-monitoring-overview-page>`,
            pageTitle: () => "Unified Monitoring Overview"
        });

        $stateProvider.state('unified-monitoring.projects', {
            url: '/projects',
            template: `<ng2-unified-monitoring-projects-page></ng2-unified-monitoring-projects-page>`,
            pageTitle: () => "Unified Monitoring Projects"
        });

        $stateProvider.state('unified-monitoring.endpoints', {
            url: '/endpoints',
            template: `<ng2-unified-monitoring-endpoints-page></ng2-unified-monitoring-endpoints-page>`,
            pageTitle: () => "Unified Monitoring Endpoints"
        });

        $stateProvider.state('unified-monitoring.alerting', {
            url: '/alerting',
            template: `<ng2-unified-monitoring-alerting-page></ng2-unified-monitoring-alerting-page>`,
            pageTitle: () => "Unified Monitoring Alerting"
        });

        $stateProvider.state('unified-monitoring.settings', {
            url: '/settings',
            template: `<ng2-unified-monitoring-settings-page></ng2-unified-monitoring-settings-page>`,
            pageTitle: () => "Unified Monitoring Settings"
        });

        $stateProvider.state('unified-monitoring.logs', {
            url: '/logs',
            template: `<ng2-unified-monitoring-logs-page></ng2-unified-monitoring-logs-page>`,
            pageTitle: () => "Unified Monitoring Logs"
        });

        /* ************************** API Deployer ********************** */

        $stateProvider.state('apideployer', {
            url: '/api-deployer/',
            controller: 'APIDeployerController',
            abstract: true,
            templateUrl: '/templates/api-deployer/index.html'
        });


        $stateProvider.state('apideployer.deployments', {
            url: 'deployments',
            abstract: true,
            template: '<div ui-view class="h100"></div>'
        });
        $stateProvider.state('apideployer.deployments.dashboard', {
            url: '/',
            controller: 'APIDeployerDeploymentsDashboardController',
            templateUrl: '/templates/api-deployer/deployment-dashboard.html',
            pageTitle: () => {
                return 'Deployments';
            }
        });
        $stateProvider.state('apideployer.deployments.deployment', {
            url: '/:deploymentId',
            abstract: true,
            controller: 'APIDeployerDeploymentController',
            templateUrl: '/templates/api-deployer/deployment.html'
        });
        $stateProvider.state('apideployer.deployments.deployment.status', {
            url: '/',
            controller: 'APIDeployerDeploymentStatusController',
            templateUrl: '/templates/api-deployer/deployment-status.html',
            pageTitle: function(stateParams) {
                return stateParams.deploymentId + ' - Deployments'
            }
        });
        $stateProvider.state('apideployer.deployments.deployment.updates', {
            url: '/last-updates/',
            controller: 'APIDeployerDeploymentUpdatesController',
            templateUrl: '/templates/api-deployer/deployment-updates.html',
            pageTitle: function(stateParams) {
                return stateParams.deploymentId + ' - Deployments'
            }
        });
        $stateProvider.state('apideployer.deployments.deployment.logs', {
            url: '/logs',
            controller: 'APIDeployerDeploymentLogsController',
            templateUrl: '/templates/api-deployer/deployment-logs.html',
            pageTitle: function(stateParams) {
                return stateParams.deploymentId + ' - Deployments'
            }
        });
        $stateProvider.state('apideployer.deployments.deployment.history', {
            url: '/history/',
            controller: 'APIDeployerDeploymentHistoryController',
            templateUrl: '/templates/api-deployer/deployment-history.html',
            pageTitle: function(stateParams) {
                return stateParams.deploymentId + ' - Deployments'
            }
        });
        $stateProvider.state('apideployer.deployments.deployment.settings', {
            url: '/settings/',
            controller: 'APIDeployerDeploymentSettingsController',
            templateUrl: '/templates/api-deployer/deployment-settings.html',
            pageTitle: function(stateParams) {
                return stateParams.deploymentId + ' - Deployments'
            }
        });


        $stateProvider.state('apideployer.services', {
            url: 'services',
            abstract: true,
            template: '<div ui-view class="h100"></div>'
        });
        $stateProvider.state('apideployer.services.list', {
            url: '/',
            controller: 'APIDeployerServicesListController',
            templateUrl: '/templates/api-deployer/published-services-list.html',
            pageTitle: () => {
                return 'Published API services';
            }
        });
        $stateProvider.state('apideployer.services.service', {
            url: '/:serviceId',
            abstract: true,
            controller: 'APIDeployerServiceController',
            templateUrl: '/templates/api-deployer/published-service.html'
        });
        $stateProvider.state('apideployer.services.service.status', {
            url: '/?versions',
            controller: 'APIDeployerServiceStatusController',
            params: {
                versions: { array: true }
            },
            templateUrl: '/templates/api-deployer/published-service-status.html',
            pageTitle: function(stateParams) {
                return stateParams.serviceId + ' - Published API services';
            }
        });
        $stateProvider.state('apideployer.services.service.history', {
            url: '/history/',
            controller: 'APIDeployerServiceHistoryController',
            templateUrl: '/templates/api-deployer/published-service-history.html',
            pageTitle: function(stateParams) {
                return stateParams.serviceId + ' - Published API services';
            }
        });
        $stateProvider.state('apideployer.services.service.settings', {
            url: '/settings/',
            controller: 'APIDeployerServiceSettingsController',
            templateUrl: '/templates/api-deployer/published-service-settings.html',
            pageTitle: function(stateParams) {
                return stateParams.serviceId + ' - Published API services';
            }
        });


        $stateProvider.state('apideployer.infras', {
            url: 'infras',
            abstract: true,
            template: '<div ui-view class="h100"></div>'
        });
        $stateProvider.state('apideployer.infras.list', {
            url: '/',
            controller: 'APIDeployerInfrasListController',
            templateUrl: '/templates/api-deployer/infras-list.html',
            pageTitle: () => {
                return 'API Infrastructures';
            }
        });
        $stateProvider.state('apideployer.infras.infra', {
            url: '/:infraId',
            controller: 'APIDeployerInfraController',
            abstract: true,
            templateUrl: '/templates/api-deployer/infra.html'
        });
        $stateProvider.state('apideployer.infras.infra.status', {
            url: '/',
            controller: 'APIDeployerInfraStatusController',
            templateUrl: '/templates/api-deployer/infra-status.html',
            pageTitle: function(stateParams) {
                return stateParams.infraId + ' - API Infrastructures';
            }
        });
        $stateProvider.state('apideployer.infras.infra.history', {
            url: '/history/',
            controller: 'APIDeployerInfraHistoryController',
            templateUrl: '/templates/api-deployer/infra-history.html',
            pageTitle: function(stateParams) {
                return stateParams.infraId + ' - API Infrastructures';
            }
        });
        $stateProvider.state('apideployer.infras.infra.settings', {
            url: '/settings/',
            controller: 'APIDeployerInfraSettingsController',
            templateUrl: '/templates/api-deployer/infra-settings.html',
            pageTitle: function(stateParams) {
                return stateParams.infraId + ' - API Infrastructures';
            }
        });

        /* ************************** Project Deployer ********************** */
        $stateProvider.state('projectdeployer', {
            url: '/project-deployer/',
            controller: 'ProjectDeployerController',
            abstract: true,
            template: '<div ui-view class="h100"></div>'
        });

        $stateProvider.state('projectdeployer.deployments', {
            url: 'deployments',
            abstract: true,
            controller: 'ProjectDeployerDeploymentsController',
            template: '<div ui-view class="h100"></div>'
        });
        $stateProvider.state('projectdeployer.deployments.dashboard', {
            url: '/',
            controller: 'ProjectDeployerDeploymentDashboardController',
            templateUrl: '/templates/project-deployer/deployment-dashboard.html',
            pageTitle: () => {
                return 'Deployments';
            }
        });
        $stateProvider.state('projectdeployer.deployments.deployment', {
            url: '/:deploymentId',
            abstract: true,
            controller: 'ProjectDeployerDeploymentController',
            templateUrl: '/templates/project-deployer/deployment.html'
        });
        $stateProvider.state('projectdeployer.deployments.deployment.status', {
            url: '/',
            controller: 'ProjectDeployerDeploymentStatusController',
            templateUrl: '/templates/project-deployer/deployment-status.html',
            pageTitle: function(stateParams) {
                return stateParams.deploymentId + ' - Deployments'
            }
        });
        $stateProvider.state('projectdeployer.deployments.deployment.settings', {
            url: '/settings/',
            controller: 'ProjectDeployerDeploymentSettingsController',
            templateUrl: '/templates/project-deployer/deployment-settings.html',
            pageTitle: function(stateParams) {
                return stateParams.deploymentId + ' - Deployments'
            }
        });
        $stateProvider.state('projectdeployer.deployments.deployment.updates', {
            url: '/last-updates/',
            controller: 'ProjectDeployerDeploymentUpdatesController',
            templateUrl: '/templates/project-deployer/deployment-updates.html',
            pageTitle: function(stateParams) {
                return stateParams.deploymentId + ' - Deployments'
            }
        });
        $stateProvider.state('projectdeployer.deployments.deployment.logs', {
            url: '/logs/',
            controller: 'ProjectDeployerDeploymentLogsController',
            templateUrl: '/templates/project-deployer/deployment-logs.html',
            pageTitle: function(stateParams) {
                return stateParams.publishedProjectKey + ' - Published Projects';
            }
        });
        $stateProvider.state('projectdeployer.deployments.deployment.history', {
            url: '/history/',
            controller: 'ProjectDeployerDeploymentHistoryController',
            templateUrl: '/templates/project-deployer/deployment-history.html',
            pageTitle: function(stateParams) {
                return stateParams.deploymentId + ' - Deployments'
            }
        });

        $stateProvider.state('projectdeployer.projects', {
            url: 'projects',
            abstract: true,
            controller: 'ProjectDeployerProjectsController',
            template: '<div ui-view class="h100"></div>'
        });
        $stateProvider.state('projectdeployer.projects.list', {
            url: '/',
            controller: 'ProjectDeployerProjectListController',
            templateUrl: '/templates/project-deployer/published-projects-list.html',
            pageTitle: () => {
                return 'Projects';
            },
            params: {
                selectedProjectKey: null // open specified project accordion table on load
            }
        });
        $stateProvider.state('projectdeployer.projects.project', {
            url: '/:publishedProjectKey',
            abstract: true,
            controller: 'ProjectDeployerProjectController',
            template: '<div ui-view class="h100"></div>'
        });
        $stateProvider.state('projectdeployer.projects.project.home', {
            url: '',
            abstract: true,
            templateUrl: '/templates/project-deployer/published-project.html'
        });
        $stateProvider.state('projectdeployer.projects.project.home.status', {
            url: '/',
            controller: 'ProjectDeployerProjectStatusController',
            templateUrl: '/templates/project-deployer/published-project-status.html',
            pageTitle: function(stateParams) {
                return stateParams.publishedProjectKey + ' - Published Projects';
            }
        });
        $stateProvider.state('projectdeployer.projects.project.home.settings', {
            url: '/settings/',
            controller: 'ProjectDeployerProjectSettingsController',
            templateUrl: '/templates/project-deployer/published-project-settings.html',
            pageTitle: function(stateParams) {
                return stateParams.publishedProjectKey + ' - Published Projects';
            }
        });
        $stateProvider.state('projectdeployer.projects.project.home.history', {
            url: '/history/',
            controller: 'ProjectDeployerProjectHistoryController',
            templateUrl: '/templates/project-deployer/published-project-history.html',
            pageTitle: function(stateParams) {
                return stateParams.publishedProjectKey + ' - Published Projects';
            }
        });
        $stateProvider.state('projectdeployer.projects.project.bundle', {
            url: '/bundle/:bundleId',
            controller: 'ProjectDeployerBundleController',
            abstract: true,
            templateUrl: '/templates/project-deployer/published-bundle.html'
        });
        $stateProvider.state('projectdeployer.projects.project.bundle.status', {
            url: '/',
            controller: 'ProjectDeployerBundleStatusController',
            templateUrl: '/templates/project-deployer/published-bundle-status.html',
            pageTitle: function(stateParams) {
                return stateParams.bundleId + ' - Published Bundles';
            }
        });

        $stateProvider.state('projectdeployer.infras', {
            url: 'infras',
            abstract: true,
            template: '<div ui-view class="h100"></div>'
        });
        $stateProvider.state('projectdeployer.infras.list', {
            url: '/',
            controller: 'ProjectDeployerInfrasListController',
            templateUrl: '/templates/project-deployer/infras-list.html',
            pageTitle: () => {
                return 'Infrastructures';
            }
        });
        $stateProvider.state('projectdeployer.infras.infra', {
            url: '/:infraId',
            controller: 'ProjectDeployerInfraController',
            abstract: true,
            templateUrl: '/templates/project-deployer/infra.html'
        });
        $stateProvider.state('projectdeployer.infras.infra.status', {
            url: '/',
            controller: 'ProjectDeployerInfraStatusController',
            templateUrl: '/templates/project-deployer/infra-status.html',
            pageTitle: function(stateParams) {
                return stateParams.infraId + ' - Automation Node Infrastructures';
            }
        });
        $stateProvider.state('projectdeployer.infras.infra.settings', {
            url: '/settings/',
            controller: 'ProjectDeployerInfraSettingsController',
            templateUrl: '/templates/project-deployer/infra-settings.html',
            pageTitle: function(stateParams) {
                return stateParams.infraId + ' - Automation Node Infrastructures';
            }
        });
        $stateProvider.state('projectdeployer.infras.infra.history', {
            url: '/history/',
            controller: 'ProjectDeployerInfraHistoryController',
            templateUrl: '/templates/project-deployer/infra-history.html',
            pageTitle: function(stateParams) {
                return stateParams.infraId + ' - Automation Node Infrastructures';
            }
        });

        /* ************************** Automation  ********************** */

        $stateProvider.state("automation", {
            url: '/automation',
            abstract: true,
            templateUrl: '/templates/scenarios/instance-monitoring.html',
            pageTitle: () => "Automation",
        });

        $stateProvider.state("automation.outcomes", {
            url: '/',
            templateUrl: '/templates/scenarios/outcomes-instance-view.html',
        });

        $stateProvider.state("automation.timeline", {
            url: '/timeline',
            templateUrl: '/templates/scenarios/timeline.html',
        });

        $stateProvider.state("automation.triggers", {
            url: '/triggers',
            templateUrl: '/templates/scenarios/triggers-instance-view.html',
        });

        $stateProvider.state("automation.reporters", {
            url: '/reporters',
            templateUrl: '/templates/scenarios/reporters-instance-view.html',
        });

        /* ************************** Administration ********************** */

        $stateProvider.state('admin', {
            url: '/admin/',
            abstract: true,
            templateUrl: '/templates/admin/index.html',
            controller: function(Breadcrumb) {
                Breadcrumb.set([{type: "admin"}]);
            }
        });

        $stateProvider.state('admin.home', {
            url: '',
            templateUrl: '/templates/admin/home.html',
            controller: "AdminLicensingController",
            pageTitle: () => {
                return "Administration";
            }
        });

        $stateProvider.state('admin.general', {
            url: 'general/',
            templateUrl: '/templates/admin/general/index.html',
            controller: "AdminGeneralSettingsController",
            params: {
                scrollTo: undefined,
            },
        });

        $stateProvider.state('admin.general.themes', {
            url: 'themes/',
            controller: "AdminThemeController" ,
            templateUrl: '/templates/admin/general/themes.html',
            pageTitle: () => {
                return "Themes";
            },
        });

        $stateProvider.state('admin.general.help', {
            url: 'help/',
            templateUrl: '/templates/admin/general/help.html',
            pageTitle: () => {
                return "Help";
            },
        });

        $stateProvider.state('admin.general.homepage', {
            url: 'homepage/',
            templateUrl: '/templates/admin/general/homepage.html',
            pageTitle: () => {
                return "Homepage";
            },
        });

        $stateProvider.state('admin.general.globaltags', {
            url: 'global-tags/',
            templateUrl: '/templates/admin/general/global-tags.html',
            pageTitle: () => {
                return "Global tag categories";
            },
        });

        $stateProvider.state('admin.general.type_badges', {
            url: 'type-badges/',
            templateUrl: '/templates/admin/general/type-badges.html',
            pageTitle: () => {
                return "Project AI Types";
            },
        });

        $stateProvider.state('admin.general.notifications', {
            url: 'notifications/',
            templateUrl: '/templates/admin/general/notifications.html',
            pageTitle: () => {
                return "Notifications";
            },
        });

        $stateProvider.state('admin.general.charts_dashboards', {
            url: 'charts-and-dashboards/',
            templateUrl: '/templates/admin/general/charts-and-dashboards.html',
            controller: 'ChartsAndDashboardsController',
            pageTitle: () => {
                return "Charts & Dashboards";
            },
        });

        $stateProvider.state('admin.general.stories_themes', {
            url: 'dataiku-stories-themes/',
            templateUrl: '/templates/admin/general/stories-themes.html',
            controller: 'StoriesThemesController',
            pageTitle: () => {
                return "Dataiku Stories";
            },
        });

        $stateProvider.state('admin.general.engines', {
            url: 'engines/',
            templateUrl: '/templates/admin/general/engines.html',
            pageTitle: () => {
                return "Engines";
            },
        });

        $stateProvider.state('admin.general.variables', {
            url: 'variables/',
            controller: 'AdminVariablesController',
            templateUrl: '/templates/admin/general/variables.html',
            pageTitle: () => {
                return "Variables";
            },
        });

        $stateProvider.state('admin.general.hadoop', {
            url: 'hadoop/',
            templateUrl: '/templates/admin/general/hadoop.html',
            pageTitle: () => {
                return "Hadoop";
            },
        });

        $stateProvider.state('admin.general.hive', {
            url: 'hive/',
            templateUrl: '/templates/admin/general/hive.html',
            pageTitle: () => {
                return "Hive";
            },
        });

        $stateProvider.state('admin.general.impala', {
            url: 'impala/',
            templateUrl: '/templates/admin/general/impala.html',
            pageTitle: () => {
                return "Impala";
            },
        });

        $stateProvider.state('admin.general.spark', {
            url: 'spark/',
            templateUrl: '/templates/admin/general/spark.html',
            pageTitle: () => {
                return "Spark";
            },
        });

        $stateProvider.state('admin.general.metastores', {
            url: 'metastores/',
            templateUrl: '/templates/admin/general/metastores.html',
            pageTitle: () => {
                return "Metastore catalogs";
            },
        });


        $stateProvider.state('admin.general.containers', {
            url: 'containers/',
            templateUrl: '/templates/admin/general/containers.html',
            pageTitle: () => {
                return "Containers";
            },
        });

        $stateProvider.state('admin.general.security', {
            url: 'security/',
            templateUrl: '/templates/admin/general/security.html',
            pageTitle: () => {
                return "Security";
            },
        });

        $stateProvider.state('admin.general.security_other', {
            url: 'security-other/',
            controller: 'AdminOtherSecurityController',
            templateUrl: '/templates/admin/general/security-other.html',
            pageTitle: () => {
                return "Security";
            },
        });


        $stateProvider.state('admin.general.limits', {
            url: 'limits/',
            templateUrl: '/templates/admin/general/limits.html',
            pageTitle: () => {
                return "Resources control";
            },
        });

        $stateProvider.state('admin.general.git', {
            url: 'git/',
            templateUrl: '/templates/admin/general/git.html',
            pageTitle: () => {
                return "Git";
            },
        });

        $stateProvider.state('admin.general.deployer', {
            url: 'deployer/',
            templateUrl: '/templates/admin/general/deployer.html',
            pageTitle: () => {
                return "Deployer";
            },
        });

        $stateProvider.state('admin.general.govern', {
            url: 'govern/',
            templateUrl: '/templates/admin/general/govern.html',
            pageTitle: () => {
                return "Govern";
            },
        });

        $stateProvider.state('admin.general.audit', {
            url: 'audit/',
            templateUrl: '/templates/admin/general/audit.html',
            pageTitle: () => {
                return "Audit";
            },
        });

        $stateProvider.state('admin.general.eventserver', {
            url: 'eventserver/',
            templateUrl: '/templates/admin/general/eventserver.html',
            pageTitle: () => {
                return "Event Server";
            },
        });

        $stateProvider.state('admin.general.genai', {
            url: 'genai/',
            controller: 'AdminGenAIController',
            templateUrl: '/templates/admin/general/genai.html',
            pageTitle: () => {
                return "Generative AI";
            },
        });

        $stateProvider.state('admin.general.aiservices', {
            url: 'aiservices/',
            controller: "AdminAiServicesSettingsController",
            templateUrl: '/templates/admin/general/aiservices.html',
            pageTitle: () => {
                return "AI Services";
            },
        });

        $stateProvider.state('admin.general.access', {
            url: 'access/',
            templateUrl: '/templates/admin/general/access.html',
            pageTitle: () => {
                return "Access & requests";
            },
        });

        $stateProvider.state('admin.general.misc', {
            url: 'misc/',
            templateUrl: '/templates/admin/general/misc.html',
            pageTitle: () => {
                return "Misc";
            },
        });

        $stateProvider.state('admin.general.stories', {
            url: 'stories/',
            templateUrl: '/templates/admin/general/datastory.html',
            pageTitle: () => {
                return "Dataiku Stories";
            },
        });

        /********************
         * Admin / Code envs
         ********************/

        $stateProvider.state('admin.codeenvs-design', {
            url: 'code-envs/design',
            abstract: true,
            templateUrl: '/templates/admin/code-envs/design/index.html'
        });

        $stateProvider.state('admin.codeenvs-design.list', {
            url: '/',
            controller: "AdminCodeEnvsDesignListController",
            templateUrl: '/templates/admin/code-envs/design/list.html',
            pageTitle: () => { return "Code envs"; }
        });

        $stateProvider.state('admin.codeenvs-design.internal', {
            url: '/internal',
            templateUrl: '/templates/admin/code-envs/common/internal-code-envs.html',
            pageTitle: () => { return "Internal code envs"; },
            controller: function(TopNav) {
                TopNav.setLocation(TopNav.DSS_HOME, "administration");
            }
        });

        $stateProvider.state('admin.codeenvs-design.create', {
            url: '/:draftId',
            controller: "AdminCodeEnvsDesignCreateFromDraftController",
            templateUrl: '/templates/admin/code-envs/design/list.html',
            pageTitle: () => { return "Code env creation"; }
        });

        $stateProvider.state('admin.codeenvs-design.python-edit', {
            url: '/python/:envName/',
            controller: "AdminCodeEnvsDesignPythonEditController",
            templateUrl: '/templates/admin/code-envs/design/python-edit.html',
            pageTitle: (stateParams) => { return stateParams.envName + " (Python) - Code Envs"; }
        });

        $stateProvider.state('admin.codeenvs-design.r-edit', {
            url: '/r/:envName/',
            controller: "AdminCodeEnvsDesignREditController",
            templateUrl: '/templates/admin/code-envs/design/R-edit.html',
            pageTitle: (stateParams) => { return stateParams.envName + " (R) - Code Envs";  }
        });

        $stateProvider.state('admin.codeenvs-automation', {
            url: 'code-envs/automation',
            abstract: true,
            templateUrl: '/templates/admin/code-envs/automation/index.html'
        });

        $stateProvider.state('admin.codeenvs-automation.list', {
            url: '/',
            controller: "AdminCodeEnvsAutomationListController",
            templateUrl: '/templates/admin/code-envs/automation/list.html',
            pageTitle: () => { return "Code Envs"; }
        });

        $stateProvider.state('admin.codeenvs-automation.internal', {
            url: '/internal',
            templateUrl: '/templates/admin/code-envs/common/internal-code-envs.html',
            pageTitle: () => { return "Internal code envs"; },
            controller: function(TopNav) {
                TopNav.setLocation(TopNav.DSS_HOME, "administration");
            }
        });

        $stateProvider.state('admin.codeenvs-automation.python-edit', {
            url: '/python/:envName/',
            controller: "AdminCodeEnvsAutomationPythonEditController",
            templateUrl: '/templates/admin/code-envs/automation/python-edit.html',
            pageTitle: (stateParams) => { return stateParams.envName + " (Python) - Code Envs"; }
        });

        $stateProvider.state('admin.codeenvs-automation.r-edit', {
            url: '/r/:envName/',
            controller: "AdminCodeEnvsAutomationREditController",
            templateUrl: '/templates/admin/code-envs/automation/R-edit.html',
            pageTitle: (stateParams) => { return stateParams.envName + " (R) - Code Envs"; }
        });

        /********************
         * Admin / Project Standards
         ********************/

        $stateProvider.state('admin.projectstandards', {
            url: 'project-standards/',
            abstract: true,
            templateUrl: '/templates/admin/project-standards/index.html'
        });

        $stateProvider.state('admin.projectstandards.checks', {
            url: 'checks-library/:checkId',
            template: `<ng2-project-standards-settings-checks [check-id]="$state.params.checkId"></ng2-project-standards-settings-checks>`,
            pageTitle: () => "Project Standards Checks Library"
        });

        $stateProvider.state('admin.projectstandards.scopes', {
            url: 'scopes/:scopeName',
            template: `<ng2-project-standards-settings-scopes [name]="$state.params.scopeName"></ng2-project-standards-settings-scopes>`,
            pageTitle: () => "Project Standards Scopes"
        });

        $stateProvider.state('admin.projectstandards.general', {
            url: 'general/',
            template: `<ng2-project-standards-settings-general-parameters></ng2-project-standards-settings-general-parameters>`,
            pageTitle: () => "General Parameters of Project Standards"
        });

        /********************
         * Admin / Maintenance
         ********************/

        $stateProvider.state('admin.maintenance', {
            url: 'maintenance/',
            templateUrl: '/templates/admin/maintenance/index.html'
        });

        $stateProvider.state('admin.maintenance.info', {
            url: 'info/',
            templateUrl: '/templates/admin/maintenance/info.html',
            pageTitle: () => {
                return "System info";
            },
            controller: "AdminMaintenanceInfoController"
        });

        $stateProvider.state('admin.maintenance.logs', {
            url: 'logs/',
            templateUrl: '/templates/admin/maintenance/logs.html',
            pageTitle: () => {
                return "Logs";
            },
            controller: "AdminLogsController"
        });

        $stateProvider.state('admin.maintenance.profiling', {
            url: 'profiling/',
            templateUrl: '/templates/admin/maintenance/profiling.html',
            pageTitle: () => {
                return "Performance profiling";
            },
            controller: "AdminProfilingController"
        });

        $stateProvider.state('admin.maintenance.diagnosis', {
            url: 'diagnosis/',
            templateUrl: '/templates/admin/maintenance/diagnosis.html',
            pageTitle: () => {
                return "Diagnosis";
            },
            controller: "AdminDiagnosticsController"
        });

        $stateProvider.state('admin.maintenance.scheduledtasks', {
            url: 'scheduled/',
            templateUrl: '/templates/admin/maintenance/scheduled-tasks.html',
            pageTitle: () => {
                return "Scheduled Tasks";
            },
            controller: "AdminScheduledTasksController" // Ugly ....
        });

        $stateProvider.state('admin.maintenance.sanitycheck', {
            url: 'sanitycheck/',
            templateUrl: '/templates/admin/maintenance/sanity-check.html',
            pageTitle: () => {
                return "Instance Sanity Check";
            },
            controller: "AdminSanityCheckController"
        });

        /********************
         * Admin / Monitoring
         ********************/

        $stateProvider.state('admin.monitoring', {
            url: 'monitoring',
            abstract: true,
            templateUrl: '/templates/admin/monitoring/index.html'
        });

        $stateProvider.state('admin.monitoring.summary', {
            url: '/',
            controller: "AdminMonitoringSummaryController",
            templateUrl: '/templates/admin/monitoring/global-summary.html',
            pageTitle: () => { return "Summary"; }
        });

        $stateProvider.state('admin.monitoring.clustertasks', {
            url: '/cluster-tasks/',
            controller: "AdminMonitoringClusterTasksController",
            templateUrl: '/templates/admin/monitoring/cluster-tasks.html',
            pageTitle: () => { return "Cluster & DB tasks"; }
        });

        $stateProvider.state('admin.monitoring.connectiondata', {
            url: '/connection-data/',
            controller: "AdminMonitoringConnectionDataController",
            templateUrl: '/templates/admin/monitoring/connection-data.html',
            pageTitle: () => { return "Per-connection data"; }
        });

        $stateProvider.state('admin.monitoring.bgtasks', {
            url: '/background-tasks/',
            controller: "AdminMonitoringBackgroundTasksController",
            templateUrl: '/templates/admin/monitoring/background-tasks.html',
            pageTitle: () => { return "Running background tasks"; }
        });

        $stateProvider.state('admin.monitoring.webapps', {
            url: '/webapp-backends/',
            controller: "AdminMonitoringWebAppBackendsController",
            templateUrl: '/templates/admin/monitoring/webapp-backends.html',
            pageTitle: () => { return "Webapp backends"; }
        });

        $stateProvider.state('admin.monitoring.integrations', {
            url: '/integrations/',
            controller: "AdminMonitoringIntegrationsController",
            templateUrl: '/templates/admin/monitoring/integrations.html',
            pageTitle : () => { return "Integrations"; }
        });

        /********************
         * Admin / Security
         ********************/

        $stateProvider.state('admin.security', {
            url: 'security/',
            abstract: true,
            templateUrl: '/templates/admin/security/index.html',
            controller: "AdminSecurityController"
        });

        $stateProvider.state('admin.security.users', {
            url: 'users/',
            abstract: true,
            template: '<div ui-view class="h100"></div>',
        });

        $stateProvider.state('admin.security.users.list', {
            url:'',
            templateUrl: '/templates/admin/security/users.html',
            controller: 'UsersController',
            pageTitle: () => {
                return "Users";
            }
        });

        $stateProvider.state('admin.security.users.new', {
            url: 'new/',
            templateUrl: '/templates/admin/security/user.html',
            controller: 'UserController',
            pageTitle: () => {
                return "New user";
            }
        });

        $stateProvider.state('admin.security.users.edit', {
            url: 'edit/:login/',
            templateUrl: '/templates/admin/security/user.html',
            controller: 'UserController',
            pageTitle: function(stateParams) {
                return "Edit "+stateParams.login+"";
            }
        });

        $stateProvider.state('admin.security.groups', {
            url: 'groups/',
            abstract: true,
            template: '<div ui-view class="h100"></div>',
        });

        $stateProvider.state('admin.security.groups.list', {
            url: '',
            templateUrl: '/templates/admin/security/groups.html',
            pageTitle: () => {
                return "Groups";
            },
            controller: "GroupsController"
        });

        $stateProvider.state('admin.security.groups.new', {
            url: 'new/',
            templateUrl: '/templates/admin/security/group.html',
            controller: 'GroupController',
            pageTitle: () => {
                return "New group";
            }
        });

        $stateProvider.state('admin.security.groups.edit', {
            url: 'edit/:name/',
            templateUrl: '/templates/admin/security/group.html',
            controller: 'GroupController',
            pageTitle: function(stateParams) {
                return "Edit "+stateParams.name+"";
            }
        });

        $stateProvider.state('admin.security.users.external', {
            url:'external/',
            templateUrl: '/templates/admin/security/external-users.html',
            controller: 'ExternalUsersController',
            pageTitle: () => {
                return "Import from external sources";
            }
        });

        $stateProvider.state('admin.security.globalapi', {
            url: 'apikeys/',
            abstract: true,
            template: '<div ui-view class="h100"></div>'
        });

        $stateProvider.state('admin.security.globalapi.list', {
            url: '',
            templateUrl: '/templates/admin/security/global-api-keys.html',
            pageTitle: () => {
                return "API";
            },
            controller: "GlobalPublicAPIKeysController"
        });

        $stateProvider.state('admin.security.globalapi.new', {
            url: 'new/',
            templateUrl: '/templates/admin/security/global-api-key.html',
            pageTitle: () => {
                return "API";
            },
            controller: "EditGlobalPublicAPIKeyController"
        });

        $stateProvider.state('admin.security.globalapi.edit', {
            url: 'edit/:id/',
            templateUrl: '/templates/admin/security/global-api-key.html',
            controller: 'EditGlobalPublicAPIKeyController',
            pageTitle: () => {
                return "API";
            }
        });

        $stateProvider.state('admin.security.personalapi', {
            url: 'personalapikeys/',
            templateUrl: '/templates/admin/security/personal-api-keys.html',
            pageTitle: () => {
                return "API";
            },
            controller: "AdminPersonalPublicAPIKeysController"
        });

        $stateProvider.state('admin.security.authorizationmatrix', {
            url: 'authorization-matrix/',
            templateUrl: '/templates/admin/security/authorization-matrix.html',
            controller: "AdminSecurityAuthorizationMatrixController",
            pageTitle: () => { return "Authorization Matrix"; }
        });

        $stateProvider.state('admin.security.auditbuffer', {
            url: 'audit-buffer/',
            templateUrl: '/templates/admin/security/audit-buffer.html',
            controller: "AdminSecurityAuditBufferController",
            pageTitle: () => { return "Audit trail"; }
        });

        // Connections management

        $stateProvider.state('admin.connections', {
            url: 'connections/',
            abstract: true,
            template: '<div ui-view></div>'
        });

        $stateProvider.state('admin.connections.list', {
            url: 'list/',
            templateUrl: '/templates/admin/connections.html',
            controller: 'ConnectionsController',
            pageTitle: () => {
                return "Overview";
            }
        });

        $stateProvider.state('admin.connections.hiveindexing', {
            url: 'hive-indexing/',
            templateUrl: '/templates/admin/connections.html', // Reuses the same template
            controller: 'ConnectionsHiveIndexingController',
            pageTitle: () => {
                return "Hive indexing";
            }
        });

        $stateProvider.state('admin.connections.new', {
            url: 'new/:type/',
            templateUrl: '/templates/admin/connection.html',
            controller: 'ConnectionController',
            pageTitle: function(stateParams) {
                return "New " + stateParams.type + " connection";
            }
        });

        $stateProvider.state('admin.connections.edit', {
            url: ':connectionName/',
            templateUrl: '/templates/admin/connection.html',
            controller: 'ConnectionController',
            pageTitle: function(stateParams) {
                return stateParams.connectionName + " - Connection";
            }
        });

        // Clusters admin
        $stateProvider.state('admin.clusters', {
            url: 'clusters',
            abstract: true,
            template: '<div ui-view></div>'
        });

        $stateProvider.state('admin.clusters.list', {
            url: '/',
            templateUrl: '/templates/admin/clusters/clusters.html',
            controller: "ClustersController",
            pageTitle: () => {
                return "Clusters";
            }
        });

        $stateProvider.state('admin.clusters.cluster', {
            url: '/:clusterId',
            templateUrl: '/templates/admin/clusters/cluster.html',
            controller: "ClusterController",
            pageTitle: () => {
                return "Cluster";
            }
        });

        // CodeStudios admin
        $stateProvider.state('admin.code-studios', {
            url: 'code-studios',
            abstract: true,
            template: '<div ui-view></div>'
        });

        $stateProvider.state('admin.code-studios.list', {
            url: '/',
            templateUrl: '/templates/admin/code-studios/code-studio-templates.html',
            controller: "CodeStudioTemplatesListController",
            pageTitle: () => "Code Studio templates"
        });

        $stateProvider.state('admin.code-studios.code-studio', {
            url: '/:codeStudioTemplateId',
            templateUrl: '/templates/admin/code-studios/code-studio-template.html',
            controller: "CodeStudioTemplateController",
            pageTitle: (stateParams) => stateParams.codeStudioTemplateId ? stateParams.codeStudioTemplateId : 'Code Studio template'
        });

        //last but not the least : a route to cach everything that could not be routed

        $stateProvider.state("otherwise", {
            url: "*path",
            templateUrl: "/templates/404.html",
            controller: function($scope, $stateParams) {
                $scope.$stateParams = $stateParams;
            }
        });
    };

    app.provider('routes', function($stateProvider, $urlRouterProvider, WorkspacesUIRouterStates, MLModelsUIRouterStates, InsightsUIRouterStates, GoToStateNameSuffixIfBase) {
        this.$get = function() {
            declareRoutes($stateProvider, $urlRouterProvider, WorkspacesUIRouterStates, MLModelsUIRouterStates, InsightsUIRouterStates, GoToStateNameSuffixIfBase);
            return {};
        }
    });

    app.factory('translate', function($translate, $interpolate, $translateSanitization) {
        return function(translateID, defaultValue, interpolateParams, interpolationId, forceLanguage, sanitizeStrategy = null) {
            let result = $translate.instant(translateID, interpolateParams, interpolationId, forceLanguage, sanitizeStrategy);
            if (result === translateID && defaultValue !== undefined) {
                // sanitize translation for the default value using the same strategy as for a non-default value
                const sanitizedInterpolateParams = $translateSanitization.sanitize(interpolateParams, 'params', sanitizeStrategy);
                const rawResult = $interpolate(defaultValue)(sanitizedInterpolateParams);
                return $translateSanitization.sanitize(rawResult, 'text', sanitizeStrategy);
            }
            return result;
        }
    });

    // Service holding the translation tables preloaded by the UI via the /get-configuation call
    // They are temporarily stored in this service until requested by dssTranslationLoader.
    // This allow to correctly bootstrap the first screens of the UI with translations already loaded.
    app.service("PreloadedTranslationTables", () => {
        const svc = {};
        svc.add = function(language, translations) {
            svc.translationTables[language] = translations;
        };
        svc.getAndRemove = function(language) {
            const result = svc.translationTables[language];
            delete svc.translationTables[language];
            return result;
        };
        svc.translationTables = {};
        return svc;
    });

    app.factory('dssTranslationLoader', function($q, $http, DataikuAPI, PreloadedTranslationTables) {
        return function(options) {
            // First look whether this language was preloaded, if not load it asynchronously
            const preloadedTranslations = PreloadedTranslationTables.getAndRemove(options.key);
            if (preloadedTranslations !== undefined) {
                return $q.resolve(preloadedTranslations);
            } else {
                const deferred = $q.defer();
                DataikuAPI.translations.get("frontend", options.key)
                    .success(function(data) {
                        return deferred.resolve(data.translations);
                    })
                    .catch(() => deferred.resolve({})); // Use an empty dictionary in case of error so that we use the fallbacks
                return deferred.promise;
            }
        }
    });


    app.config(function($locationProvider, $httpProvider, $compileProvider, $translateProvider, $provide, routesProvider) {
        $locationProvider.html5Mode(true);
        routesProvider.$get();
        $httpProvider.interceptors.push('dssInterceptor');

        $translateProvider.preferredLanguage('en');
        $translateProvider.keepContent(true);
        $translateProvider.useLoader('dssTranslationLoader');
        $translateProvider.useSanitizeValueStrategy('escapeParameters');
    });
})();

;
(function() {
    'use strict';
    // Module declaration
    angular.module('dataiku.constants', []);
})();
;
(function () {
    'use strict';
  
    const app = angular.module('dataiku.constants');
  
    const CSS_COLOR_HEX_CODE_BY_NAME = {
        ALICEBLUE: "#F0F8FF",
        ANTIQUEWHITE: "#FAEBD7",
        AQUA: "#00FFFF",
        AQUAMARINE: "#7FFFD4",
        AZURE: "#F0FFFF",
        BEIGE: "#F5F5DC",
        BISQUE: "#FFE4C4",
        BLACK: "#000000",
        BLANCHEDALMOND: "#FFEBCD",
        BLUE: "#0000FF",
        BLUEVIOLET: "#8A2BE2",
        BROWN: "#A52A2A",
        BURLYWOOD: "#DEB887",
        CADETBLUE: "#5F9EA0",
        CHARTREUSE: "#7FFF00",
        CHOCOLATE: "#D2691E",
        CORAL: "#FF7F50",
        CORNFLOWERBLUE: "#6495ED",
        CORNSILK: "#FFF8DC",
        CRIMSON: "#DC143C",
        CYAN: "#00FFFF",
        DARKBLUE: "#00008B",
        DARKCYAN: "#008B8B",
        DARKGOLDENROD: "#B8860B",
        DARKGRAY: "#A9A9A9",
        DARKGREY: "#A9A9A9",
        DARKGREEN: "#006400",
        DARKKHAKI: "#BDB76B",
        DARKMAGENTA: "#8B008B",
        DARKOLIVEGREEN: "#556B2F",
        DARKORANGE: "#FF8C00",
        DARKORCHID: "#9932CC",
        DARKRED: "#8B0000",
        DARKSALMON: "#E9967A",
        DARKSEAGREEN: "#8FBC8F",
        DARKSLATEBLUE: "#483D8B",
        DARKSLATEGRAY: "#2F4F4F",
        DARKSLATEGREY: "#2F4F4F",
        DARKTURQUOISE: "#00CED1",
        DARKVIOLET: "#9400D3",
        DEEPPINK: "#FF1493",
        DEEPSKYBLUE: "#00BFFF",
        DIMGRAY: "#696969",
        DIMGREY: "#696969",
        DODGERBLUE: "#1E90FF",
        FIREBRICK: "#B22222",
        FLORALWHITE: "#FFFAF0",
        FORESTGREEN: "#228B22",
        FUCHSIA: "#FF00FF",
        GAINSBORO: "#DCDCDC",
        GHOSTWHITE: "#F8F8FF",
        GOLD: "#FFD700",
        GOLDENROD: "#DAA520",
        GRAY: "#808080",
        GREY: "#808080",
        GREEN: "#008000",
        GREENYELLOW: "#ADFF2F",
        HONEYDEW: "#F0FFF0",
        HOTPINK: "#FF69B4",
        INDIANRED: "#CD5C5C",
        INDIGO: "#4B0082",
        IVORY: "#FFFFF0",
        KHAKI: "#F0E68C",
        LAVENDER: "#E6E6FA",
        LAVENDERBLUSH: "#FFF0F5",
        LAWNGREEN: "#7CFC00",
        LEMONCHIFFON: "#FFFACD",
        LIGHTBLUE: "#ADD8E6",
        LIGHTCORAL: "#F08080",
        LIGHTCYAN: "#E0FFFF",
        LIGHTGOLDENRODYELLOW: "#FAFAD2",
        LIGHTGRAY: "#D3D3D3",
        LIGHTGREY: "#D3D3D3",
        LIGHTGREEN: "#90EE90",
        LIGHTPINK: "#FFB6C1",
        LIGHTSALMON: "#FFA07A",
        LIGHTSEAGREEN: "#20B2AA",
        LIGHTSKYBLUE: "#87CEFA",
        LIGHTSLATEGRAY: "#778899",
        LIGHTSLATEGREY: "#778899",
        LIGHTSTEELBLUE: "#B0C4DE",
        LIGHTYELLOW: "#FFFFE0",
        LIME: "#00FF00",
        LIMEGREEN: "#32CD32",
        LINEN: "#FAF0E6",
        MAGENTA: "#FF00FF",
        MAROON: "#800000",
        MEDIUMAQUAMARINE: "#66CDAA",
        MEDIUMBLUE: "#0000CD",
        MEDIUMORCHID: "#BA55D3",
        MEDIUMPURPLE: "#9370DB",
        MEDIUMSEAGREEN: "#3CB371",
        MEDIUMSLATEBLUE: "#7B68EE",
        MEDIUMSPRINGGREEN: "#00FA9A",
        MEDIUMTURQUOISE: "#48D1CC",
        MEDIUMVIOLETRED: "#C71585",
        MIDNIGHTBLUE: "#191970",
        MINTCREAM: "#F5FFFA",
        MISTYROSE: "#FFE4E1",
        MOCCASIN: "#FFE4B5",
        NAVAJOWHITE: "#FFDEAD",
        NAVY: "#000080",
        OLDLACE: "#FDF5E6",
        OLIVE: "#808000",
        OLIVEDRAB: "#6B8E23",
        ORANGE: "#FFA500",
        ORANGERED: "#FF4500",
        ORCHID: "#DA70D6",
        PALEGOLDENROD: "#EEE8AA",
        PALEGREEN: "#98FB98",
        PALETURQUOISE: "#AFEEEE",
        PALEVIOLETRED: "#DB7093",
        PAPAYAWHIP: "#FFEFD5",
        PEACHPUFF: "#FFDAB9",
        PERU: "#CD853F",
        PINK: "#FFC0CB",
        PLUM: "#DDA0DD",
        POWDERBLUE: "#B0E0E6",
        PURPLE: "#800080",
        REBECCAPURPLE: "#663399",
        RED: "#FF0000",
        ROSYBROWN: "#BC8F8F",
        ROYALBLUE: "#4169E1",
        SADDLEBROWN: "#8B4513",
        SALMON: "#FA8072",
        SANDYBROWN: "#F4A460",
        SEAGREEN: "#2E8B57",
        SEASHELL: "#FFF5EE",
        SIENNA: "#A0522D",
        SILVER: "#C0C0C0",
        SKYBLUE: "#87CEEB",
        SLATEBLUE: "#6A5ACD",
        SLATEGRAY: "#708090",
        SLATEGREY: "#708090",
        SNOW: "#FFFAFA",
        SPRINGGREEN: "#00FF7F",
        STEELBLUE: "#4682B4",
        TAN: "#D2B48C",
        TEAL: "#008080",
        THISTLE: "#D8BFD8",
        TOMATO: "#FF6347",
        TURQUOISE: "#40E0D0",
        VIOLET: "#EE82EE",
        WHEAT: "#F5DEB3",
        WHITE: "#FFFFFF",
        WHITESMOKE: "#F5F5F5",
        YELLOW: "#FFFF00",
        YELLOWGREEN: "#9ACD32",
    };
  
    const CSS_COLOR_NAMES = Object.keys(CSS_COLOR_HEX_CODE_BY_NAME);
  
    app.constant('COLORS', {
        CSS_COLOR_HEX_CODE_BY_NAME,
        CSS_COLOR_NAMES,
    });
})();
  
;
(function() {
    'use strict';

    const app = angular.module('dataiku.constants');

    // ChartFilter.FilterType.java
    const FILTER_TYPES = {
        ALPHANUM_FACET: 'ALPHANUM_FACET',
        NUMERICAL_FACET: 'NUMERICAL_FACET',
        DATE_FACET: 'DATE_FACET'
    };

    // ChartFilter.FilterSelectionType.java
    const FILTER_SELECTION_TYPES = {
        RANGE_OF_VALUES: 'RANGE_OF_VALUES',
        SINGLE_SELECT: 'SINGLE_SELECT',
        MULTI_SELECT: 'MULTI_SELECT'
    };

    // AxisDef.type.java
    const COLUMN_TYPES = {
        ALPHANUM: 'ALPHANUM',
        NUMERICAL: 'NUMERICAL',
        DATE: 'DATE'
    };

    // ChartFilter.DateFilterPart.java
    const DATE_PARTS = {
        YEAR: 'YEAR',
        QUARTER_OF_YEAR: 'QUARTER_OF_YEAR',
        WEEK_OF_YEAR: 'WEEK_OF_YEAR',
        MONTH_OF_YEAR: 'MONTH_OF_YEAR',
        DAY_OF_MONTH: 'DAY_OF_MONTH',
        DAY_OF_WEEK: 'DAY_OF_WEEK',
        HOUR_OF_DAY: 'HOUR_OF_DAY'
    };

    // ChartFilter.DateFilterType.java
    const DATE_TYPES = {
        RANGE : 'RANGE',
        RELATIVE: 'RELATIVE',
        PART: 'PART'
    };

    const DAYS_OF_WEEK_LABELS = ['Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday', 'Sunday'];

    app.constant('CHART_FILTERS', {
        FILTER_TYPES,
        FILTER_SELECTION_TYPES,
        COLUMN_TYPES,
        DATE_PARTS,
        DATE_TYPES,
        DAYS_OF_WEEK_LABELS
    });

})();

;
(function() {
    'use strict';
    /** @typedef {import('../../types').ChartType} ChartType */

    /** @type {Record<string, ChartType>} */
    const CHART_TYPES = {
        GROUPED_COLUMNS: 'grouped_columns',
        STACKED_BARS: 'stacked_bars',
        STACKED_COLUMNS: 'stacked_columns',
        MULTI_COLUMNS_LINES: 'multi_columns_lines',
        LINES: 'lines',
        STACKED_AREA: 'stacked_area',
        PIVOT_TABLE: 'pivot_table',
        SCATTER: 'scatter',
        SCATTER_MULTIPLE_PAIRS: 'scatter_multiple_pairs',
        GROUPED_XY: 'grouped_xy',
        BINNED_XY: 'binned_xy',
        DENSITY_2D: 'density_2d',
        KPI: 'kpi',
        MAP: 'map',
        SCATTER_MAP: 'scatter_map',
        DENSITY_HEAT_MAP: 'density_heat_map',
        GEOMETRY_MAP: 'geom_map',
        ADMINISTRATIVE_MAP: 'admin_map',
        GRID_MAP: 'grid_map',
        BOXPLOTS: 'boxplots',
        PIE: 'pie',
        LIFT: 'lift',
        WEBAPP: 'webapp',
        TREEMAP: 'treemap',
        HEATMAP: 'heatmap',
        HEATMAP_MAP: 'heatmap_map',
        GROUPED_SCATTER_MAP: 'grouped_scatter_map',
        RADAR: 'radar',
        GAUGE: 'gauge',
        SANKEY: 'sankey',
        NUMERICAL_HEATMAP: 'numerical_heatmap',
        FILTERS: 'filters'
    }

    angular.module('dataiku.constants')
        .constant('CHART_TYPES', CHART_TYPES);

}());

;
(function() {
    'use strict';

    angular.module('dataiku.constants')
        .constant('DKU_OTHERS_VALUE', '___dku_others_value___');
}());
;
(function() {
    'use strict';

    angular.module('dataiku.constants')
        .constant('DKU_NO_VALUE', '___dku_no_value___');
}());

;
(function() {
    'use strict';

    const VALUES_DISPLAY_MODES = {
        VALUES: 'VALUES',
        LABELS: 'LABELS',
        VALUES_AND_LABELS: 'VALUES_AND_LABELS',
        VALUES_AND_TOTALS: 'VALUES_AND_TOTALS'
    }

    angular.module('dataiku.constants')
        .constant('VALUES_DISPLAY_MODES', VALUES_DISPLAY_MODES);

}());

;
(function() {
    'use strict';
    const CONVERSION_FIELD_ICON = 'icon';
    const CONVERSION_FIELD_NAME = 'name';
    const CONVERSION_FIELD_OTHER_NAME = 'otherName';
    const CONVERSION_FIELD_LANGUAGE = 'language';
    const CONVERSION_FIELD_CATEGORY = 'category';

    /**
     *
     * @param {string} icon
     * @param {string} name
     * @param {string} otherName
     * @param {boolean} newIconOnly
     * @returns {Object} type definition
     */
    function buildTypeDefinition(icon, name, otherName, newIconOnly=false) {
        return { [CONVERSION_FIELD_ICON]: icon, [CONVERSION_FIELD_NAME]: name, [CONVERSION_FIELD_OTHER_NAME]: otherName || name, newIconOnly: newIconOnly };
    }

    /**
     *
     * @param {string} icon icon class name
     * @param {string} category category icon is part of (e.g., visual, code, etc.)
     * @param {string} language language of code/continuous recipe
     * @param {string} newIconOnly true if icon is only available in the modern icon set
     * @returns {Object} recipe type definition
     */
    function buildRecipeTypeDefinition(icon, category, language, newIconOnly) {
        return {
            ...buildTypeDefinition(icon, undefined, undefined, newIconOnly),
            [CONVERSION_FIELD_CATEGORY]: category,
            [CONVERSION_FIELD_LANGUAGE]: language
        };
    }

    const FS_PROVIDER_TYPES = {
        'filesystem': buildTypeDefinition('icon-server_file_system_1', `Server's Filesystem`),
        'hdfs': buildTypeDefinition('icon-HDFS', 'Hadoop HDFS'),
        'ftp': buildTypeDefinition('icon-uncached_FTP', 'FTP'),
        'sftp': buildTypeDefinition('icon-dataset-ssh marker-sftp', 'SFTP'),
        'scp': buildTypeDefinition('icon-dataset-ssh marker-scp', 'SCP'),
        'azure': buildTypeDefinition('icon-azure-storage', 'Azure Blob Storage'),
        'gcs': buildTypeDefinition('icon-google-cloud-storage', 'Google Cloud Storage'),
        's3': buildTypeDefinition('icon-amazon_s3', 'Amazon S3'),
        'url': buildTypeDefinition(undefined, 'HTTP or FTP URL'),
        'sharepointonline': buildTypeDefinition('icon-microsoft-sharepoint', 'SharePoint Online'),
    };

    const COMMON_TYPES = {
        ...FS_PROVIDER_TYPES,
        'hiveserver2': buildTypeDefinition('icon-dku-hive', 'Hive'),
        'uploadedfiles': buildTypeDefinition('icon-upload', 'Uploaded Files'),
        'mongodb': buildTypeDefinition('icon-mongo_db', 'MongoDB'),
        'dynamodb': buildTypeDefinition('icon-dynamoDB', 'DynamoDB'),
        'mysql': buildTypeDefinition('icon-mySQL', 'MySQL'),
        'cassandra': buildTypeDefinition('icon-cassandra_1', 'Cassandra'),
        'postgresql': buildTypeDefinition('icon-postgreSQL', 'PostgreSQL'),
        'alloydb': buildTypeDefinition('icon-dku-alloydb', 'Google AlloyDB'),
        'vertica': buildTypeDefinition('icon-HP_vertica', 'Vertica'),
        'redshift': buildTypeDefinition('icon-amazon_redshift', 'Amazon Redshift'),
        'greenplum': buildTypeDefinition('icon-greenplum', 'Greenplum'),
        'databricks': buildTypeDefinition('icon-dku-databricks', 'Databricks'),
        'databricksvolume': buildTypeDefinition('icon-dku-databricks-volume', 'Databricks Volume'),
        'databrickslakebase': buildTypeDefinition('icon-dku-databricks-lakebase', 'Databricks Lakebase'),
        'teradata': buildTypeDefinition('icon-teradata', 'Teradata'),
        'oracle': buildTypeDefinition('icon-oracle', 'Oracle'),
        'athena': buildTypeDefinition('icon-athena', 'Athena'),
        'trino': buildTypeDefinition('icon-trino', 'Trino'),
        'denodo': buildTypeDefinition('icon-denodo', 'Denodo'),
        'kdbplus': buildTypeDefinition('dku-icon-clock', 'KDB+', undefined, true),
        'treasuredata': buildTypeDefinition('icon-treasuredata', 'Treasure Data'),
        'sqlserver': buildTypeDefinition('icon-sqlserver', 'MS SQL Server'),
        'synapse': buildTypeDefinition('icon-dku-azure-synapse', 'Azure Synapse'),
        'fabricwarehouse': buildTypeDefinition('icon-microsoft-fabric-warehouse', 'MS Fabric Warehouse'),
        'netezza': buildTypeDefinition('icon-netezza', 'IBM Netezza'),
        'saphana': buildTypeDefinition('icon-sap-hana', 'SAP Hana'),
        'bigquery': buildTypeDefinition('icon-google-bigquery', 'Google BigQuery'),
        'snowflake': buildTypeDefinition('icon-snowflake', 'Snowflake'),
        'jdbc': buildTypeDefinition('icon-other_sql', 'SQL database (JDBC)', 'Other SQL databases'),
        'elasticsearch': buildTypeDefinition('icon-elasticsearch', 'ElasticSearch'),
        'twitter': buildTypeDefinition('icon-twitter', 'Twitter'),
        'sharepointonlinelist': buildTypeDefinition('icon-microsoft-sharepoint', 'SharePoint List'),
        'openai': buildTypeDefinition('icon-openai', 'OpenAI'),
        'azureopenai': buildTypeDefinition('icon-azure', 'Azure OpenAI'),
        'azurellm': buildTypeDefinition('icon-azure', 'Azure LLM'),
        'azureaisearch': buildTypeDefinition('icon-azure', 'Azure AI Search'),
        'cohere': buildTypeDefinition('icon-cohere', 'Cohere'),
        'anthropic': buildTypeDefinition('icon-anthropic', 'Anthropic'),
        'bedrock': buildTypeDefinition('icon-bedrock', 'AWS Bedrock'),
        'mosaicml': buildTypeDefinition('icon-mosaicml', 'MosaicML (deprecated)'),
        'stabilityai': buildTypeDefinition('dku-icon-stability-ai', 'Stability AI', undefined, true),
        'nvidia-nim': buildTypeDefinition('dku-icon-nvidia', 'NVIDIA NIM'), // key needs to be lowercase, see typeProcessor in services.js
        'sagemaker-genericllm': buildTypeDefinition('icon-model-sagemaker', 'Amazon SageMaker LLM'),
        'vertexaillm': buildTypeDefinition('icon-vertex', 'Vertex Generative AI'),
        'databricksllm': buildTypeDefinition('icon-dku-databricks', 'Databricks Mosaic AI'),
        'snowflakecortex': buildTypeDefinition('icon-snowflake', 'Snowflake Cortex'),
        'mistralai': buildTypeDefinition('icon-mistral', 'MistralAI'),
        'huggingfaceinferenceapi': buildTypeDefinition('icon-hugging-face', 'Hugging Face API'),
        'huggingfacelocal': buildTypeDefinition('icon-hugging-face', 'Local Hugging Face'),
        'pinecone': buildTypeDefinition('icon-pinecone', 'Pinecone'),
        'customllm': buildTypeDefinition('icon-puzzle-piece', 'Custom LLM'),
        'kafka': buildTypeDefinition('icon-kafka', 'Kafka'),
        'sqs': buildTypeDefinition('icon-sqs', 'SQS'),
        'httpsse': buildTypeDefinition('icon-httpsse', 'HTTP Server Sent Events'),
    };

    const DATASET_TYPES = {
        ...COMMON_TYPES,
        'cachedhttp': buildTypeDefinition('icon-FTP-HTTP-SSH', 'HTTP (with cache)'),
        'filesinfolder': buildTypeDefinition('icon-box', 'Files in Folder'),
        'labels': buildTypeDefinition('icon-screenshot', 'Labels'),
        'http': buildTypeDefinition('icon-FTP-HTTP-SSH', 'HTTP'),
        'inline': buildTypeDefinition('icon-inline', 'Editable'),
        'jobsdb': buildTypeDefinition('icon-bar-chart', 'Metrics'),
        'statsdb': buildTypeDefinition('icon-tasks marker-internal-stats', 'Internal stats'),
        'experimentsdb': buildTypeDefinition('icon-dku-exp-tracking', 'Experiments'),
        'remotefiles': buildTypeDefinition('icon-FTP-HTTP-SSH'),
        'sample': buildTypeDefinition('icon-beaker'),
    };
    const STREAMING_ENDPOINT_TYPES = {
        'kafka': buildTypeDefinition('icon-double-angle-right'),
        'httpsse': buildTypeDefinition('icon-double-angle-right'),
        'sqs': buildTypeDefinition('icon-double-angle-right')
    };
    const CONNECTION_TYPES = {
        ...COMMON_TYPES,
        'ec2': buildTypeDefinition('icon-amazon_s3', 'Amazon S3'),
        'ssh': buildTypeDefinition('icon-FTP-HTTP-SSH', 'SCP/SFTP'),
        'vertexaillm': buildTypeDefinition('icon-vertex', 'Vertex Generative AI'),
        'sagemaker': buildTypeDefinition('icon-model-sagemaker', 'Amazon SageMaker'),
        'azureml': buildTypeDefinition('icon-model-azureml', 'Azure Machine Learning'),
        'vertexaimodeldeployment': buildTypeDefinition('icon-model-google-vertex', 'Google Vertex AI'),
        'databricksmodeldeployment': buildTypeDefinition('icon-dku-databricks', 'Databricks Model Depl.')
    };

    const CREDENTIAL_TYPES = {
        'single_field': buildTypeDefinition('icon-key', 'Secret'),
        'basic': buildTypeDefinition('icon-key', 'Password'),
        'azure_oauth_devicecode': buildTypeDefinition('icon-link', 'OAuth2'),
        'oauth_refresh_token': buildTypeDefinition('icon-link', 'OAuth2'),
    };

    const RECIPE_CATEGORIES = {
        CLUSTERING: 'clustering',
        SCORE: 'score',
        TRAIN: 'train',
        STANDALONE: 'standalone',
        EVALUATION: 'evaluation',
        EDA: 'eda',
        VISUAL: 'visual',
        CODE: 'code',
        NLP: 'nlp',
        CONTINUOUS: 'continuous'
    };
    const RECIPE_TYPES = {
        'clustering_cluster': buildRecipeTypeDefinition('icon-clustering_recipe', RECIPE_CATEGORIES.CLUSTERING),
        'clustering_scoring': buildRecipeTypeDefinition('icon-clustering_recipe', RECIPE_CATEGORIES.SCORE),
        'clustering_training': buildRecipeTypeDefinition('icon-train_recipe', RECIPE_CATEGORIES.TRAIN),
        'distinct': buildRecipeTypeDefinition('icon-visual_prep_distinct_recipe', RECIPE_CATEGORIES.VISUAL),
        'download': buildRecipeTypeDefinition('icon-visual_download_recipe', RECIPE_CATEGORIES.VISUAL),
        'eda_pca': buildRecipeTypeDefinition('icon-eda_pca_recipe', RECIPE_CATEGORIES.EDA), // [eda] fake icon making bridge between the old/new icon system
        'eda_stats': buildRecipeTypeDefinition('icon-eda_stats_recipe', RECIPE_CATEGORIES.EDA), // [eda] fake icon making bridge between the old/new icon system
        'eda_univariate': buildRecipeTypeDefinition('icon-eda_univariate_recipe', RECIPE_CATEGORIES.EDA), // [eda] fake icon making bridge between the old/new icon system
        'evaluation': buildRecipeTypeDefinition('icon-evaluation_recipe', RECIPE_CATEGORIES.EVALUATION),
        'standalone_evaluation': buildRecipeTypeDefinition('icon-standalone_evaluation_recipe', RECIPE_CATEGORIES.STANDALONE),
        'export': buildRecipeTypeDefinition('icon-visual_export_recipe', RECIPE_CATEGORIES.VISUAL),
        'extract_failed_rows': buildRecipeTypeDefinition('dku-icon-recipe-extract-failed-rows', RECIPE_CATEGORIES.VISUAL, undefined, true),
        'grouping': buildRecipeTypeDefinition('icon-visual_prep_group_recipe', RECIPE_CATEGORIES.VISUAL),
        'upsert': buildRecipeTypeDefinition('icon-visual_prep_upsert_recipe', RECIPE_CATEGORIES.VISUAL),
        'hive': buildRecipeTypeDefinition('icon-code_hive_recipe', RECIPE_CATEGORIES.CODE, 'text/x-hivesql'),
        'impala': buildRecipeTypeDefinition('icon-code_impala_recipe', RECIPE_CATEGORIES.CODE, 'text/x-hivesql'),
        'ipython': buildRecipeTypeDefinition('icon-python', 'python'),
        'labeling': buildRecipeTypeDefinition('icon-labeling', RECIPE_CATEGORIES.VISUAL),
        'join': buildRecipeTypeDefinition('icon-visual_prep_join_recipe', RECIPE_CATEGORIES.VISUAL),
        'fuzzyjoin': buildRecipeTypeDefinition('icon-visual_prep_fuzzyjoin_recipe', RECIPE_CATEGORIES.VISUAL),
        'generate_features': buildRecipeTypeDefinition('icon-visual_prep_auto_feature_generation_recipe', RECIPE_CATEGORIES.VISUAL),
        'geojoin': buildRecipeTypeDefinition('icon-visual_prep_geojoin_recipe', RECIPE_CATEGORIES.VISUAL),
        'merge_folder': buildRecipeTypeDefinition('icon-visual_prep_merge_folder_recipe', RECIPE_CATEGORIES.VISUAL),
        'list_folder_contents': buildRecipeTypeDefinition('icon-visual_prep_list_folder_contents_recipe', RECIPE_CATEGORIES.VISUAL),
        'list_access': buildRecipeTypeDefinition('icon-visual_prep_list_access_recipe', RECIPE_CATEGORIES.VISUAL),
        'julia': buildRecipeTypeDefinition('icon-code_julia_recipe', RECIPE_CATEGORIES.CODE, 'text/x-julia'),
        'pig': buildRecipeTypeDefinition('icon-code_pig_recipe', RECIPE_CATEGORIES.CODE, 'text/x-dkupig'),
        'pivot': buildRecipeTypeDefinition('icon-visual_prep_pivot_recipe', RECIPE_CATEGORIES.VISUAL),
        'prediction_scoring': buildRecipeTypeDefinition('icon-score_recipe', RECIPE_CATEGORIES.SCORE),
        'prediction_training': buildRecipeTypeDefinition('icon-train_recipe', RECIPE_CATEGORIES.TRAIN),
        'pyspark': buildRecipeTypeDefinition('icon-code_pyspark_recipe', RECIPE_CATEGORIES.CODE, 'text/x-python'),
        'python': buildRecipeTypeDefinition('icon-code_python_recipe', RECIPE_CATEGORIES.CODE, 'text/x-python'),
        'r': buildRecipeTypeDefinition('icon-code_r_recipe', RECIPE_CATEGORIES.CODE, 'text/x-rsrc'),
        'recipe': buildRecipeTypeDefinition('icon-circle', 'circle'),
        'sampling': buildRecipeTypeDefinition('icon-visual_prep_filter-sample_recipe', RECIPE_CATEGORIES.VISUAL),
        'shaker': buildRecipeTypeDefinition('icon-visual_prep_cleanse_recipe', RECIPE_CATEGORIES.VISUAL),
        'shell': buildRecipeTypeDefinition('icon-code_shell_recipe', RECIPE_CATEGORIES.CODE, 'text/x-sh'),
        'sort': buildRecipeTypeDefinition('icon-visual_prep_sort_recipe', RECIPE_CATEGORIES.VISUAL),
        'spark_scala': buildRecipeTypeDefinition('icon-code_spark_scala_recipe', RECIPE_CATEGORIES.CODE, 'text/x-scala'),
        'spark_sql_query': buildRecipeTypeDefinition('icon-code_sparksql_recipe', RECIPE_CATEGORIES.CODE, 'text/x-sql2'),
        'sparkr': buildRecipeTypeDefinition('icon-code_sparkr_recipe', RECIPE_CATEGORIES.CODE, 'text/x-rsrc'),
        'split': buildRecipeTypeDefinition('icon-visual_prep_split_recipe', RECIPE_CATEGORIES.VISUAL),
        'sql': buildRecipeTypeDefinition('icon-sql', 'sql'),
        'sql_query': buildRecipeTypeDefinition('icon-code_sql_recipe', RECIPE_CATEGORIES.CODE, 'text/x-sql2'),
        'sql_script': buildRecipeTypeDefinition('icon-code_sql_recipe', RECIPE_CATEGORIES.CODE, 'text/x-sql2'),
        'sync': buildRecipeTypeDefinition('icon-visual_prep_sync_recipe', RECIPE_CATEGORIES.VISUAL),
        'topn': buildRecipeTypeDefinition('icon-visual_prep_topn_recipe', RECIPE_CATEGORIES.VISUAL),
        'update': buildRecipeTypeDefinition('icon-visual_push_to_editable_recipe', RECIPE_CATEGORIES.VISUAL),
        'vstack': buildRecipeTypeDefinition('icon-visual_prep_vstack_recipe', RECIPE_CATEGORIES.VISUAL),
        'window': buildRecipeTypeDefinition('icon-visual_prep_window_recipe', RECIPE_CATEGORIES.VISUAL),
        'csync': buildRecipeTypeDefinition('icon-continuous_sync_recipe', RECIPE_CATEGORIES.CONTINUOUS),
        'ksql': buildRecipeTypeDefinition('icon-continuous_ksql_recipe', RECIPE_CATEGORIES.CONTINUOUS, 'text/x-sql'),
        'cpython': buildRecipeTypeDefinition('icon-continuous_python_recipe', RECIPE_CATEGORIES.CONTINUOUS, 'text/x-python'),
        'streaming_spark_scala': buildRecipeTypeDefinition('icon-continuous_spark_scala_recipe', RECIPE_CATEGORIES.CONTINUOUS, 'text/x-scala'),
        'prompt': buildRecipeTypeDefinition('icon-nlp_prompt_recipe', RECIPE_CATEGORIES.NLP),
        'nlp_llm_user_provided_classification': buildRecipeTypeDefinition('icon-nlp_text_classification_recipe', RECIPE_CATEGORIES.NLP),
        'nlp_llm_model_provided_classification': buildRecipeTypeDefinition('icon-nlp_text_classification_recipe', RECIPE_CATEGORIES.NLP),
        'nlp_llm_summarization': buildRecipeTypeDefinition('icon-nlp_summarization_recipe', RECIPE_CATEGORIES.NLP),
        'nlp_llm_finetuning': buildRecipeTypeDefinition('icon-nlp_fine_tuning_recipe', RECIPE_CATEGORIES.NLP),
        'nlp_llm_rag_embedding': buildRecipeTypeDefinition('icon-nlp_rag_embedding_recipe', RECIPE_CATEGORIES.NLP),
        'embed_documents': buildRecipeTypeDefinition('dku-icon-recipe-embed-document-circle-fill', RECIPE_CATEGORIES.NLP, undefined, true),
        'nlp_llm_evaluation': buildRecipeTypeDefinition('icon-nlp_llm_evaluation_recipe', RECIPE_CATEGORIES.NLP),
    };

    // graph.js (line 418) - recipeFlowIcon filter

    const ML_TYPES = {
        'prediction': buildTypeDefinition('icon-beaker'),
        'regression': buildTypeDefinition('icon-machine_learning_regression'),
        'clustering': buildTypeDefinition('icon-machine_learning_clustering'),
    };
    const OTHER_TAGGABLE_OBJECTS_TYPES = {
        'analysis': buildTypeDefinition('icon-dku-nav_analysis'),
        'managed_folder': buildTypeDefinition('icon-folder-open'),
        'saved_model': buildTypeDefinition('icon-machine_learning_regression'),
        'model_evaluation_store': buildTypeDefinition('icon-model-evaluation-store'),
        'retrievable_knowledge': buildTypeDefinition('icon-retrievable_knowledge'),
        'knowledge_bank': buildTypeDefinition('dku-icon-cards-stack', undefined, undefined, true), // IndexableType
        'prompt_studio': buildTypeDefinition('icon-prompt-iterative'),
        'agent_tool': buildTypeDefinition('dku-icon-tool-wrench', undefined, undefined, true),
        'model_comparison': buildTypeDefinition('icon-dku-comparator'),
        'labeling_task': buildTypeDefinition('icon-labeling-task'),
        'statistics_worksheet': buildTypeDefinition('icon-dku-statistics'),
        'scenario': buildTypeDefinition('icon-list'),
        'article': buildTypeDefinition('icon-dku-wiki'),
        'lambda_service': buildTypeDefinition('icon-cloud'),
        'flow_zone': buildTypeDefinition('icon-zone'),
        'code_studio': buildTypeDefinition('icon-code-studio'),
        'taggable_object': buildTypeDefinition('icon-puzzle-piece'), //Generic (used for heterogeneous groups of taggable objects)
        'workspace_link': buildTypeDefinition('icon-link'),
        'workspace_story': buildTypeDefinition('icon-dku-datastory'),
        'data_collection': buildTypeDefinition('dku-icon-stacked', undefined, undefined, true)
    };
    const NON_TAGGABLE_OBJECTS_TYPES = {
        'column': buildTypeDefinition('icon-list icon-rotate-90'),
        'meaning': buildTypeDefinition('icon-tags'),
        'discussion': buildTypeDefinition('icon-comments'),
    };
    const WEBAPPS_TYPES = {
        'web_app': buildTypeDefinition('icon-code'),
        'bokeh': buildTypeDefinition('icon-bokeh'),
        'dash': buildTypeDefinition('icon-dash'),
        'shiny': buildTypeDefinition('icon-code_r_recipe'),
        'standard': buildTypeDefinition('icon-code'),
        'code_studio_as_webapp': buildTypeDefinition('icon-code-studio'),
    };
    const DASHBOARDS_OR_INSIGHTS_TYPES = {
        'insight': buildTypeDefinition('icon-dku-nav_dashboard'),
        'data-quality': buildTypeDefinition('dku-icon-shield-check', undefined, undefined, true),
        'dashboard': buildTypeDefinition('icon-dku-dashboard'),
        'html': buildTypeDefinition('icon-code'),
        'group': buildTypeDefinition('dku-icon-group', undefined, undefined, true),
        'image': buildTypeDefinition('icon-picture'),
        'text': buildTypeDefinition('icon-font'),
        'static_file': buildTypeDefinition('icon-file-alt'),
        'iframe': buildTypeDefinition('icon-link'),
        'bokeh_export': buildTypeDefinition('icon-bokeh'),
        'dash_export': buildTypeDefinition('icon-dash'),
        'static_chart': buildTypeDefinition('icon-bar-chart'),
        'discussions': buildTypeDefinition('icon-comments-alt'),
        'runnable-button': buildTypeDefinition('icon-macro')
    };
    const OTHER_TYPES = {
        'project': buildTypeDefinition('icon-dkubird'),
        'app': buildTypeDefinition('icon-project-app'),
        'report': buildTypeDefinition('icon-DKU_rmd'),
        'new': buildTypeDefinition('icon-plus'),
        'help': buildTypeDefinition('icon-question-sign'),
        'workspace': buildTypeDefinition('icon-dku-workspace'),
    };
    const NOTEBOOKS_TYPES = {
        'notebook': buildTypeDefinition('icon-dku-nav_notebook'),
        'sql_notebook': buildTypeDefinition('icon-sql'),
        'search_notebook': buildTypeDefinition('icon-dku-search-notebook'),
        'jupyter_notebook': buildTypeDefinition('icon-dku-nav_notebook'),
    };
    const BACKEND_TYPES = {
        'h2o': buildTypeDefinition('dku-icon-h2o', undefined, undefined, true),
        'mllib': buildTypeDefinition('dku-icon-sparkmllib', undefined, undefined, true),
        'py_memory': buildTypeDefinition('dku-icon-python-circle', undefined, undefined, true),
        'keras': buildTypeDefinition('dku-icon-keras', undefined, undefined, true),
        'deep_hub': buildTypeDefinition('dku-icon-deep-hub', undefined, undefined, true),
        'vertica': COMMON_TYPES.vertica
    }
    const ALL_TYPES = {
        ...COMMON_TYPES, ...DATASET_TYPES, ...STREAMING_ENDPOINT_TYPES, ...CONNECTION_TYPES, ...CREDENTIAL_TYPES, ...RECIPE_TYPES, ...ML_TYPES, ...OTHER_TAGGABLE_OBJECTS_TYPES,
        ...NON_TAGGABLE_OBJECTS_TYPES, ...WEBAPPS_TYPES, ...DASHBOARDS_OR_INSIGHTS_TYPES, ...OTHER_TYPES, ...NOTEBOOKS_TYPES, ...BACKEND_TYPES
    };

    /*
        Visual analysis + saved model icons
        Do not include in ALL_TYPES (name collision; not a taggable object)
    */
    const VISUAL_ANALYSIS_TYPES = {
        'prediction': buildTypeDefinition('icon-dku-automl-prediction'),
        'clustering': buildTypeDefinition('icon-dku-automl-clustering'),
        'timeseries': buildTypeDefinition('icon-dku-timeseries-forecasting'),
        'causal': buildTypeDefinition('icon-dku-causal'),
        'keras': buildTypeDefinition('icon-dku-deeplearning-prediction'),
        'deephub_image_classification': buildTypeDefinition('icon-dku-deephub-image-classification'),
        'deephub_object_detection': buildTypeDefinition('icon-dku-deephub-object-detection')
    };
    const SAVED_MODEL_TYPES = {
        'prediction': buildTypeDefinition('dku-icon-machine-learning-regression', undefined, undefined, true),
        'clustering': buildTypeDefinition('dku-icon-machine-learning-clustering', undefined, undefined, true),
        'timeseries': buildTypeDefinition('dku-icon-saved-model-timeseries', undefined, undefined, true),
        'causal': buildTypeDefinition('dku-icon-saved-model-causal', undefined, undefined, true),
        'keras': buildTypeDefinition('dku-icon-saved-model-deep-learning', undefined, undefined, true),
        'deephub_image_classification': buildTypeDefinition('dku-icon-saved-model-computer-vision', undefined, undefined, true),
        'deephub_object_detection': buildTypeDefinition('dku-icon-saved-model-computer-vision', undefined, undefined, true),
        'mlflow': buildTypeDefinition('dku-icon-model-mlflow', undefined, undefined, true),
        'fine_tuning': buildTypeDefinition('dku-icon-saved-model-fine-tuning', undefined, undefined, true),
        'python_agent': buildTypeDefinition('dku-icon-ai-agent-code', undefined, undefined, true),
        'plugin_agent': buildTypeDefinition('dku-icon-ai-agent-plugin', undefined, undefined, true),
        'tools_using_agent': buildTypeDefinition('dku-icon-ai-agent-visual', undefined, undefined, true),
        'retrieval_augmented_llm': buildTypeDefinition('dku-icon-llm-augmented', undefined, undefined, true),
        'sagemaker': buildTypeDefinition('dku-icon-model-sagemaker', undefined, undefined, true),
        'vertex': buildTypeDefinition('dku-icon-model-google-vertex', undefined, undefined, true),
        'azureml': buildTypeDefinition('dku-icon-model-azureml', undefined, undefined, true),
        'databricks': buildTypeDefinition('dku-icon-model-databricks', undefined, undefined, true),
    };

    // Map the old icons to the new one. Icon migration campaign in 2023
    // All new icons start with 'dku-icon-'
    const NEW_ICON_TYPE_MAPPING = {
        'icon-dkubird': 'dku-icon-dataiku',
        'icon-dataset': 'dku-icon-dataset',
        'icon-project-app': 'dku-icon-application',
        'icon-machine_learning_regression': 'dku-icon-machine-learning-regression',
        'icon-dku-nav_dashboard': 'dku-icon-chart-vertical-bar',
        'icon-dku-dashboard': 'dku-icon-dashboard',
        'icon-picture': 'dku-icon-image',
        'icon-font': 'dku-icon-text-letter-character',
        'icon-file-alt': 'dku-icon-file',
        'icon-file-text-alt': 'dku-icon-file-text',
        'icon-link': 'dku-icon-link',
        'icon-bokeh': 'dku-icon-bokeh',
        'icon-bar-chart': 'dku-icon-chart-vertical-stack-bar',
        'icon-comments-alt': 'dku-icon-comment-multiple-question',
        'icon-code_r_recipe': 'dku-icon-recipe-r-circle-fill',
        'icon-dash': 'dku-icon-plotly',
        'icon-code': 'dku-icon-code',
        'icon-mongo_db': 'dku-icon-mongo',
        'icon-cassandra_1': 'dku-icon-cassandra',
        'icon-google-bigquery': 'dku-icon-google-bigquery',
        'icon-twitter': 'dku-icon-twitter',
        'icon-openai': 'dku-icon-openai',
        'icon-bedrock': 'dku-icon-amazon-aws-bedrock',
        'icon-pinecone': 'dku-icon-pinecone',
        'icon-azure': 'dku-icon-microsoft-azure',
        'icon-cohere': 'dku-icon-cohere',
        'icon-mistral': 'dku-icon-mistral',
        'icon-mosaicml': 'dku-icon-mosaicml',
        'icon-anthropic': 'dku-icon-anthropic',
        'icon-vertex': 'dku-icon-model-google-vertex',
        'icon-hugging-face': 'dku-icon-huggingface',
        'icon-postgreSQL': 'dku-icon-postgresql',
        'icon-snowflake': 'dku-icon-snowflake-brand',
        'icon-server_file_system_1': 'dku-icon-folder-multiple',
        'icon-HDFS': 'dku-icon-hdfs',
        'icon-google-cloud-storage': 'dku-icon-google-gcp-cloud-storage',
        'icon-microsoft-sharepoint': 'dku-icon-microsoft-sharepoint',
        'icon-amazon_s3': 'dku-icon-amazon-web-s3',
        'icon-FTP-HTTP-SSH': 'dku-icon-globe',
        'icon-uncached_FTP': 'dku-icon-data-ftp',
        'icon-other_sql': 'dku-icon-dataset',
        'icon-dku-databricks': 'dku-icon-databricks',
        'icon-dku-databricks-volume': 'dku-icon-databricks-volume',
        'icon-dku-databricks-lakebase': 'dku-icon-databricks-lakebase',
        'icon-sap-hana': 'dku-icon-sap-hana',
        'icon-HP_vertica': 'dku-icon-vertica',
        'icon-athena': 'dku-icon-athena',
        'icon-trino': 'dku-icon-trino',
        'icon-denodo': 'dku-icon-denodo',
        'icon-treasuredata': 'dku-icon-treasure-data',
        'icon-dku-alloydb': 'dku-icon-alloydb',
        'icon-dku-julia': 'dku-icon-julia-brand',
        'icon-greenplum': 'dku-icon-greenplum',
        'icon-mySQL': 'dku-icon-mysql',
        'icon-sqlserver': 'dku-icon-sql-server',
        'icon-microsoft-fabric-warehouse': 'dku-icon-microsoft-fabric-warehouse-diagram',
        'icon-oracle': 'dku-icon-oracle',
        'icon-tableau': 'dku-icon-tableau',
        'icon-teradata': 'dku-icon-teradata',
        'icon-dku-deepl': 'dku-icon-deepl',
        'icon-dropbox': 'dku-icon-dropbox',
        'icon-neo4j': 'dku-icon-neo4j',
        'icon-dku-azure-synapse': 'dku-icon-microsoft-azure-synapse',
        'icon-amazon-comprehend': 'dku-icon-amazon-comprehend',
        'icon-amazon-elastic-kubernetes': 'dku-icon-amazon-elastic-kubernetes',
        'icon-amazon-rekognition': 'dku-icon-amazon-rekognition',
        'icon-amazon_redshift': 'dku-icon-amazon-redshift',
        'icon-amazon-transcribe': 'dku-icon-amazon-transcribe',
        'icon-azure-cognitive-services': 'dku-icon-amazon-cognitive-services',
        'icon-azure-storage': 'dku-icon-microsoft-azure-blob-storage',
        'icon-azure-kubernetes-services': 'dku-icon-microsoft-azure-kubernetes',
        'icon-elasticsearch': 'dku-icon-elastic-search',
        'icon-gcp-cloud-dataproc': 'dku-icon-google-gcp-dataproc',
        'icon-gcp-kubernetes-engine': 'dku-icon-google-gcp-kubernetes',
        'icon-gcp-natural-language-api': 'dku-icon-gcp-naturallang',
        'icon-gcp-cloud-vision-api': 'dku-icon-google-gcp-vision',
        'icon-gcp-translation-api': 'dku-icon-google-gcp-translation',
        'icon-powerbi': 'dku-icon-microsoft-powerbi',
        'icon-netezza': 'dku-icon-netezza',
        'icon-dku-hive': 'dku-icon-hive',
        'icon-upload': 'dku-icon-arrow-circle-dataset-upload',
        'icon-inline': 'dku-icon-edit',
        'icon-score_recipe': 'dku-icon-recipe-score-circle-fill',
        'icon-train_recipe': 'dku-icon-recipe-train-circle-fill',
        'icon-visual_prep_distinct_recipe': 'dku-icon-recipe-distinct-circle-fill',
        'icon-visual_download_recipe': 'dku-icon-recipe-download',
        'icon-eda_pca_recipe': 'dku-icon-recipe-principal-component-analysis',
        'icon-eda_stats_recipe': 'dku-icon-recipe-statistical-test',
        'icon-eda_univariate_recipe': 'dku-icon-recipe-univariate-analysis',
        'icon-evaluation_recipe': 'dku-icon-recipe-evaluation-circle-fill',
        'icon-standalone_evaluation_recipe': 'dku-icon-recipe-ser',
        'icon-visual_export_recipe': 'dku-icon-recipe-export-circle-fill',
        'icon-visual_prep_group_recipe': 'dku-icon-recipe-group-circle-fill',
        'icon-visual_prep_upsert_recipe': 'dku-icon-recipe-upsert-circle-fill',
        'icon-labeling': 'dku-icon-recipe-labeling-circle-fill',
        'icon-visual_prep_fuzzyjoin_recipe': 'dku-icon-recipe-fuzzy-join-circle-fill',
        'icon-visual_prep_merge_folder_recipe': 'dku-icon-recipe-merge-folder',
        'icon-visual_prep_list_folder_contents_recipe': 'dku-icon-recipe-list-folder-contents-circle-fill',
        'icon-visual_prep_list_access_recipe': 'dku-icon-recipe-list-access',
        'icon-visual_prep_pivot_recipe': 'dku-icon-recipe-pivot-circle-fill',
        'icon-circle': 'dku-icon-recipe-type',
        'icon-visual_prep_filter-sample_recipe': 'dku-icon-recipe-filter-circle-fill',
        'icon-visual_prep_split_recipe': 'dku-icon-recipe-split-circle-fill',
        'icon-visual_prep_sync_recipe': 'dku-icon-recipe-sync-right',
        'icon-visual_prep_topn_recipe': 'dku-icon-recipe-top-n-circle-fill',
        'icon-visual_push_to_editable_recipe': 'dku-icon-recipe-push-to-editable',
        'icon-visual_prep_vstack_recipe': 'dku-icon-recipe-stack-circle-fill',
        'icon-visual_prep_window_recipe': 'dku-icon-recipe-window-circle-fill',
        'icon-continuous_sync_recipe': 'dku-icon-recipe-sync-right',
        'icon-continuous_ksql_recipe': 'dku-icon-recipe-ksql-circle-fill',
        'icon-continuous_python_recipe': 'dku-icon-python-circle',
        'icon-continuous_spark_scala_recipe': 'dku-icon-recipe-sparkscala-circle-fill',
        'icon-code_hive_recipe': 'dku-icon-recipe-hive-circle-fill',
        'icon-code_impala_recipe': 'dku-icon-recipe-impala-circle-fill',
        'icon-python': 'dku-icon-python',
        'icon-sql': 'dku-icon-sql',
        'icon-sql marker-database': 'dku-icon-dataset',
        'icon-code_sql_recipe': 'dku-icon-recipe-sql-circle-fill',
        'icon-visual_prep_cleanse_recipe': 'dku-icon-recipe-prepare-circle-fill',
        'icon-code_shell_recipe': 'dku-icon-recipe-shell',
        'icon-visual_prep_sort_recipe': 'dku-icon-recipe-sort-circle-fill',
        'icon-code_spark_scala_recipe': 'dku-icon-recipe-sparkscala-circle-fill',
        'icon-code_sparksql_recipe': 'dku-icon-recipe-sparksql-circle-fill',
        'icon-code_sparkr_recipe': 'dku-icon-recipe-sparkr-circle-fill',
        'icon-code_pyspark_recipe': 'dku-icon-recipe-sparkpython-circle-fill',
        'icon-code_python_recipe': 'dku-icon-python-circle',
        'icon-visual_prep_join_recipe': 'dku-icon-recipe-join-with-circle-fill',
        'icon-code_julia_recipe': 'dku-icon-recipe-julia-circle-fill',
        'icon-code_pig_recipe': 'dku-icon-apache-pig',
        'icon-visual_prep_geojoin_recipe': 'dku-icon-recipe-geo-join-circle-fill',
        'icon-nlp_prompt_recipe': 'dku-icon-recipe-prompt',
        'icon-nlp_fine_tuning_recipe': 'dku-icon-recipe-fine-tuning',
        'icon-nlp_text_classification_recipe': 'dku-icon-recipe-classification',
        'icon-nlp_summarization_recipe': 'dku-icon-recipe-summarization',
        'icon-nlp_rag_embedding_recipe': 'dku-icon-recipe-document-card-circle-fill',
        'icon-nlp_llm_evaluation_recipe': 'dku-icon-recipe-evaluation-llm-circle-fill',
        'icon-retrievable_knowledge': 'dku-icon-cards-stack',
        'icon-prompt-iterative': 'dku-icon-ai-prompt',
        'icon-book': 'dku-icon-book',
        'icon-clustering_recipe': 'dku-icon-recipe-clustering-circle-fill',
        'icon-list': 'dku-icon-list-bulleted',
        'icon-table': 'dku-icon-data-table',
        'icon-file-text': 'dku-icon-file-text',
        'icon-dashboard': 'dku-icon-dashboard',
        'icon-dku-modelize': 'dku-icon-modelize',
        'icon-dku-clustering': 'dku-icon-clustering',
        'icon-external-link': 'dku-icon-arrow-external-link',
        'icon-dku-nav_notebook': 'dku-icon-edit-note',
        'icon-folder-close-alt': 'dku-icon-folder-closed',
        'icon-DKU_rmd': 'dku-icon-rmd',
        'icon-kafka': 'dku-icon-kafka',
        'icon-sqs': 'dku-icon-amazon-sqs',
        'icon-httpsse': 'dku-icon-httpsse',
        'icon-dku-automl-prediction': 'dku-icon-automl-prediction',
        'icon-dku-timeseries-forecasting': 'dku-icon-time-series',
        'icon-dku-deeplearning-prediction': 'dku-icon-prediction-deep-learning',
        'icon-dku-deephub-image-classification': 'dku-icon-image-classification',
        'icon-dku-deephub-object-detection': 'dku-icon-object-detection',
        'icon-dku-automl-clustering': 'dku-icon-automl-clustering',
        'icon-dku-causal': 'dku-icon-causal',
        'icon-dku-nav_analysis': 'dku-icon-ml-analysis',
        'icon-dku-wiki': 'dku-icon-wiki',
        'icon-beaker': 'dku-icon-beaker',
        'icon-box': 'dku-icon-dataset-files-in-folder',
        'icon-calendar': 'dku-icon-calendar',
        'icon-database': 'dku-icon-dataset',
        'icon-dataset-ssh marker-sftp': 'dku-icon-data-sftp',
        'icon-dataset-ssh marker-scp': 'dku-icon-data-scp',
        'icon-dku-exp-tracking': 'dku-icon-experiment-tracking',
        'icon-dku-feature-store': 'dku-icon-feature-store-label',
        'icon-dku-share': 'dku-icon-flow-share',
        'icon-dku-meanings': 'dku-icon-barcode',
        'icon-dku-offline-translation': 'dku-icon-translation',
        'icon-dynamoDB': 'dku-icon-dynamo-db',
        'icon-filter': 'dku-icon-filter',
        'icon-model-evaluation-store': 'dku-icon-model-evaluation-store',
        'icon-signal': 'dku-icon-signal',
        'icon-tasks': 'dku-icon-chart-horizontal-stack-bar',
        'icon-tasks marker-internal-stats': 'dku-icon-statistics',
        'icon-time': 'dku-icon-clock',
        'icon-screenshot': 'dku-icon-image-tag',
        'icon-cloud': 'dku-icon-cloud',
        'icon-code-studio': 'dku-icon-code-studio',
        'icon-comments': 'dku-icon-comment-multiple',
        'icon-dku-comparator': 'dku-icon-model-comparison',
        'icon-dku-statistics': 'dku-icon-statistics',
        'icon-dku-workspace': 'dku-icon-workspaces',
        'icon-double-angle-right': 'dku-icon-chevron-double-right',
        'icon-folder-open': 'dku-icon-dataset-files-in-folder',
        'icon-labeling-task': 'dku-icon-label',
        'icon-list icon-rotate-90': 'dku-icon-columns',
        'icon-machine_learning_clustering': 'dku-icon-machine-learning-clustering',
        'icon-plus': 'dku-icon-plus',
        'icon-puzzle-piece': 'dku-icon-puzzle-piece',
        'icon-question-sign': 'dku-icon-question-circle-fill',
        'icon-tags': 'dku-icon-tag',
        'icon-visual_prep_auto_feature_generation_recipe': 'dku-icon-recipe-auto-feature-circle-fill',
        'icon-zone': 'dku-icon-zone',
        'icon-mail-forward': 'dku-icon-arrow-curve-right',
        'icon-eye': 'dku-icon-eye',
        'icon-globe': 'dku-icon-globe',
        'icon-dku-application-as-recipe': 'dku-icon-application-as-recipe',
        'icon-Filesystem': 'dku-icon-dataset-filesystem',
        'icon-cloud-download': 'dku-icon-cloud-download',
        'icon-cloud-upload': 'dku-icon-cloud-upload',
        'icon-flow_dataset_folder': 'dku-icon-dataset-files-in-folder',
        'recipe_cluster': 'dku-icon-machine-learning-clustering',
        'recipe_distinct': 'dku-icon-recipe-distinct-circle-fill',
        'recipe_download': 'dku-icon-recipe-download',
        'recipe_evaluation': 'dku-icon-recipe-evaluation-circle-fill',
        'recipe_export': 'dku-icon-recipe-export-circle-fill',
        'recipe_filter': 'dku-icon-recipe-filter-circle-fill',
        'recipe_fuzzyjoin': 'dku-icon-recipe-fuzzy-join-circle-fill',
        'recipe_geojoin': 'dku-icon-recipe-geo-join-circle-fill',
        'recipe_group': 'dku-icon-recipe-group-circle-fill',
        'recipe_hive': 'dku-icon-recipe-hive-circle-fill',
        'recipe_impala': 'dku-icon-recipe-impala-circle-fill',
        'recipe_join': 'dku-icon-recipe-join-with-circle-fill',
        'recipe_julia': 'dku-icon-recipe-julia-circle-fill',
        'recipe_ksql': 'dku-icon-recipe-ksql-circle-fill',
        'recipe_list_folder_contents': 'dku-icon-recipe-list-folder-contents-circle-fill',
        'recipe_list_access': 'dku-icon-recipe-list-access',
        'recipe_merge_folder': 'dku-icon-recipe-merge-folder',
        'recipe_pig': 'dku-icon-apache-pig',
        'recipe_pivot': 'dku-icon-recipe-pivot-circle-fill',
        'recipe_prepare': 'dku-icon-broom',
        'recipe_push_to_editable': 'dku-icon-recipe-push-to-editable',
        'recipe_pyspark': 'dku-icon-recipe-sparkpython-circle-fill',
        'recipe_python': 'dku-icon-python-circle',
        'recipe_R': 'dku-icon-recipe-r-circle-fill',
        'recipe_score': 'dku-icon-recipe-score-circle-fill',
        'recipe_shell': 'dku-icon-recipe-shell',
        'recipe_sort': 'dku-icon-recipe-sort-circle-fill',
        'recipe_spark_scala': 'dku-icon-recipe-sparkscala-circle-fill',
        'recipe_spark_sql': 'dku-icon-recipe-sparksql-circle-fill',
        'recipe_sparkr': 'dku-icon-recipe-sparkr-circle-fill',
        'recipe_split': 'dku-icon-recipe-split-circle-fill',
        'recipe_sql': 'dku-icon-recipe-sql-circle-fill',
        'recipe_stack': 'dku-icon-recipe-stack-circle-fill',
        'recipe_standalone_evaluation': 'dku-icon-recipe-ser',
        'recipe_sync': 'dku-icon-recipe-sync-circle-fill',
        'recipe_topn': 'dku-icon-recipe-top-n-circle-fill',
        'recipe_train': 'dku-icon-recipe-train-circle-fill',
        'recipe_window': 'dku-icon-recipe-window-circle-fill',
        'icon-dku-datastory': 'dku-icon-dataiku-story',
        'icon-dku-search-notebook': 'dku-icon-dataset-search',
        'icon-trash': 'dku-icon-trash',
        'icon-model-sagemaker': 'dku-icon-model-sagemaker',
        'icon-model-azureml': 'dku-icon-model-azureml',
        'icon-model-google-vertex': 'dku-icon-model-google-vertex',
        'icon-youtube-play' : 'dku-icon-youtube',
        'icon-envelope-alt' : 'dku-icon-mail',
        'icon-file' : 'dku-icon-file',
        'icon-bullseye': 'dku-icon-target',
        'icon-bug': 'dku-icon-bug',
        'icon-indent-right': 'dku-icon-text-indent',
        'icon-indent-left': 'dku-icon-text-indent',
        'icon-cogs': 'dku-icon-gear',
        'icon-gear': 'dku-icon-gear',
        'icon-gears': 'dku-icon-gear',
        'icon-sitemap': 'dku-icon-sitemap',
        'icon-forward': 'dku-icon-arrow-fast-forward',
        'icon-anchor': 'dku-icon-anchor',
        'icon-align-justify': 'dku-icon-text-align-justified',
        'icon-search': 'dku-icon-search',
        'icon-microphone': 'dku-icon-microphone',
        'icon-envelope': 'dku-icon-mail',
        'icon-list-alt': 'dku-icon-list-bulleted',
        'icon-magic': 'dku-icon-magic-wand',
        'icon-quote-left': 'dku-icon-text-quote',
        'icon-superscript': 'dku-icon-text-superscript',
        'icon-dollar': 'dku-icon-currency-usd',
        'icon-dku-collaborative-filtering': 'dku-icon-person-group',
        'icon-heart': 'dku-icon-heart-fill',
        'icon-barcode': 'dku-icon-barcode',
        'icon-rocket': 'dku-icon-api-connect',
        'icon-lock': 'dku-icon-lock-closed',
        'icon-cut': 'dku-icon-scissors-horizontal',
        'icon-eye-open': 'dku-icon-eye',
        'icon-sun': 'dku-icon-sun',
        'icon-group': 'dku-icon-person-group',
    };

    const app = angular.module('dataiku.constants');

    app.constant('TYPE_MAPPING', {
        CONVERSION_FIELD_ICON,
        CONVERSION_FIELD_NAME,
        CONVERSION_FIELD_OTHER_NAME,
        CONVERSION_FIELD_LANGUAGE,
        CONVERSION_FIELD_CATEGORY,

        FS_PROVIDER_TYPES,
        COMMON_TYPES,
        DATASET_TYPES,
        STREAMING_ENDPOINT_TYPES,
        CONNECTION_TYPES,
        CREDENTIAL_TYPES,
        RECIPE_TYPES,
        RECIPE_CATEGORIES,
        ML_TYPES,
        OTHER_TAGGABLE_OBJECTS_TYPES,
        NON_TAGGABLE_OBJECTS_TYPES,
        WEBAPPS_TYPES,
        DASHBOARDS_OR_INSIGHTS_TYPES,
        OTHER_TYPES,
        NOTEBOOKS_TYPES,
        BACKEND_TYPES,
        ALL_TYPES,

        VISUAL_ANALYSIS_TYPES,
        SAVED_MODEL_TYPES,
        NEW_ICON_TYPE_MAPPING,
    });

})();

;
(function() {
  const app = angular.module("dataiku.constants");

  const FileExtensions = {
    EXCELX: 'xlsx',
    EXCEL: 'xls',
    CSV: 'CSV'
  }
  app.constant("FILE_EXTENSIONS", FileExtensions);
})();
;
/* global clippy */
(function() {
'use strict';

const app = angular.module('dataiku.controllers', ['dataiku.services', 'dataiku.filters', 'dataiku.markdown', 'dataiku.shared']);



app.controller('DataikuController', function($cacheFactory, $filter, $http, $injector, $state, $location, $modal, $rootScope,
       $route, $scope, $controller, $stateParams, $templateCache, $timeout, $exceptionHandler, $translate, translate,
       PreloadedTranslationTables, Assert, Dialogs, ActivityIndicator, FlowToolsLoader, Discussions,
       BackendReportsService, Breadcrumb, Throttle, CachedAPICalls,
       CreateModalFromTemplate, DataikuAPI, localStorageService, ContextualMenu,
       LoggerProvider, Notification, TopNav, WebSocketService, TrackingService, WT1, FullstorySupport,
       Markdown, GrelMode, RMarkdownMode, //Not used but included here to force load
       TaggingService, ProjectFolderContext,
       ExportUtils, ErrorReporting, StateUtils, SmartId, IntercomSupport, RecipeDescService, MessengerUtils,
       AlationCatalogChooserService, CodeMirrorSettingService, UserImageUrl, ProjectStatusService, HomePageContextService,
       CatalogItemService, Debounce, FeatureFlagsService, DetectUtils, FullScreenService, $httpParamSerializer, TaggableObjectsUtils, CatalogUtils,
       RequestCenterService, TopbarDrawersService, TOPBAR_DRAWER_IDS, OpalsService, StateObserverService, DatasetTypesService, BuiltinMapBackgrounds) {

    $rootScope.DataikuAPI = DataikuAPI;
    $rootScope.$state = $state;
    $rootScope.translate = translate;
    $scope.isFullScreen = FullScreenService.isFullScreen;

    TopNav.setLocation(TopNav.DSS_HOME);

    // Since the controller is not properly declared, it's not possible to use "Logger" directly (see angular-instantiable.js)
    const Logger = LoggerProvider.getLogger('DataikuController');
    Logger.info("Starting DSS load");

    window.APIErrorLogger = LoggerProvider.getLogger("api.errors");

    $rootScope.wl = {
        productShortName: "DSS",
        productLongName: "Dataiku DSS"
    }
    const dssMinorVersion = "14";
    $rootScope.dssMinorVersion = dssMinorVersion;
    $rootScope.versionDocRoot = `https://doc.dataiku.com/dss/${dssMinorVersion}/`;
    $rootScope.apiDocRoot = `https://doc.dataiku.com/dss/api/${dssMinorVersion}/`;
    $rootScope.academyRootUrl = "https://academy.dataiku.com/";
    $rootScope.learnRootUrl = "https://www.dataiku.com/learn/";
    $rootScope.kbaseRootUrl = `https://knowledge.dataiku.com/${dssMinorVersion}/`;

    // change the bootstrap-dropdown keydown listener so that it leaves mat-menus alone
    $(document).off('keydown.dropdown.data-api');
    $(document).on('keydown.dropdown.data-api', '[data-toggle=dropdown], [role=menu]:not(.mat-menu-panel, .mat-mdc-menu-panel)', $.fn.dropdown.Constructor.prototype.keydown)

    $controller("DatasetsCommon", {$scope: $scope});

    $rootScope.isTemporalType = DatasetTypesService.isTemporalType;
    $rootScope.isDateOnly = DatasetTypesService.isDateOnly;

    function userAvatar(userLogin, size) {
        if (!userLogin) return "";
        const imageUrl = UserImageUrl(userLogin, size);
        const sizeClass = size ? "size-" + sanitize(size) : "size-fit";
        return `<img class="user-avatar ${sizeClass}" src="${imageUrl}" />`;
    }

    function dssObjectLink(objectType, projectKey, objectId, innerHTML) {
        var link = StateUtils.href.dssObject(objectType, objectId, projectKey);
        return '<a href="'+link+'" class="link-std">'+innerHTML+'</a>';
    }

    function pluginStoreLink(pluginId, innerHTML) {
        var link = StateUtils.href.pluginStore(pluginId);
        return '<a href="'+link+'" class="link-std">'+innerHTML+'</a>';
    }

    function pluginSummaryLink(pluginId, innerHTML) {
        var link = StateUtils.href.pluginSummary(pluginId);
        return '<a href="'+link+'" class="link-std">'+innerHTML+'</a>';
    }

    function codeEnvLink(envName, envLang, innerHTML) {
        const link = StateUtils.href.codeEnvEdit(envName, envLang);
        return link ? `<a href="${link}" class="link-std">${innerHTML}</a>` : innerHTML;
    }

    function projectLink(projectKey, innerHTML) {
        var link = StateUtils.href.project(projectKey);
        return '<a href="'+link+'" class="link-std">'+innerHTML+'</a>';
    }

    function appLink(appId, innerHTML) {
        var link = StateUtils.href.app(appId);
        return '<a href="'+link+'" class="link-std">'+innerHTML+'</a>';
    }

    function dssObjectLabel(objectName) {
        return '<span>' + objectName + '</span>';
    }

    function userLink(userLogin, innerHTML) {
        return '<a href="/profile/'+escape(userLogin)+'/" class="link-std">'+ innerHTML + '</a>';
    }

    $scope.$on("$stateChangeStart", function(event, toState, toParams, fromState, fromParams) {
        Logger.debug('State: '+((fromState && fromState.name)?fromState.name:'Unknown') + ' -> '+ ((toState && toState.name)?toState.name:'Unknown'), toParams);
    });

    // Check for unsaved changes in the page before leaving:
    window.addEventListener("beforeunload", function (event) {
        try {
            if (typeof window.dssHasDirtyThings == "function" && window.dssHasDirtyThings()) {
                var msg = 'Unsaved changes will be lost';
                event.returnValue = msg; //this string will not be displayed anyway
                return msg;
            }
        } catch (e){
            Logger.error("Failed to compute dirtiness. Let it go.", e);
        }
    });

    $scope.reflow = {};
    $scope.$on('reflow',function() {
        $scope.reflow = {};
    });

    Notification.registerEvent('websocket-status-changed',function(evt,data) {
        $scope.wsFail = false;
        $("body").removeClass("ws-disconnected");
        if(data.code == WebSocketService.ERROR_CODE.CONNECTION_FAILED) {
            $scope.wsFail = true;
        } else if(data.code == WebSocketService.ERROR_CODE.CONNECTION_LOST) {
            $("body").addClass("ws-disconnected");
        }
    });

    $rootScope.$watch("promptRefreshFromVersionId", function (newValue, oldValue) {
        if (newValue && oldValue !== newValue && $rootScope.promptRefresh) {
            // Create a modal for the user that prompts them to refresh their page.
            // This modal cannot be dismissed by clicking outside
            Dialogs.confirmImportant(
                $scope,
                "New DSS Version",
                `A new version of DSS is available and it is recommended that you refresh your browser tab.<br>
                You can also dismiss this window and refresh later at your convenience.</br>
                Would you like to refresh now?`)
                .then(() => {
                    window.location.reload();
            }, (resolution) => {
                    if (resolution === "Cancelled") {
                        // User clicked on Cancel, dismiss the modal and don't show it back.
                        $rootScope.promptRefresh = false;
                    } else {
                        // Modal was destroyed without confirmation from the user, trigger it back.
                        $rootScope.promptRefreshFromVersionId = undefined;
                        $timeout(() => {
                            $rootScope.promptRefreshFromVersionId = newValue;
                        });
                    }
            });
        }
    });

    $scope.closeContextualMenus = function(){
        ContextualMenu.prototype.closeAny();
    };

    $scope.reconnectWebSocket = function() {
        WebSocketService.connect();
    };

    $scope.sendOfflineQueues = function() {
        DataikuAPI.internal.sendOfflineQueues();
    };
    $scope.slowFailAllBackendCalls = function(params) {
        DataikuAPI.internal.slowFail(params);
    };
    $scope.sendDigests = function() {
        DataikuAPI.internal.sendDigests();
    };
    $scope.buildUsageSummaryReports = function () {
        DataikuAPI.internal.buildUsageSummaryReports();
    };

    /* Put some stuff in the global scopes */
    $rootScope.$stateParams = $stateParams;
    $rootScope.StateUtils = StateUtils;
    $rootScope.SmartId = SmartId;
    $rootScope.dismissUpgradeProfile = localStorageService.get("dismissUpgradeProfile");
    $scope.$state = $state;
    $scope.sanitize = sanitize;
    $scope.JSON = JSON;
    $scope.$route = $route;
    $scope.Object = Object;
    $scope.pendingRequests = $http.pendingRequests;
    $rootScope.spinnerPosition = undefined;
    $scope.isTouchDevice = isTouchDevice();
    $scope.TopbarDrawersService = TopbarDrawersService;
    $scope.TOPBAR_DRAWER_IDS = TOPBAR_DRAWER_IDS;

    Breadcrumb.set([])

    $timeout(function() {
        $('.selectpicker').selectpicker();
        $('[data-toggle=dropdown]').dropdown();
     },10);

    /* Some global state management */
    $scope.$on('$stateChangeSuccess', function(e, toState){
        WT1.setSessionParam("currentState", toState.name);
        WT1.event("state-changed");
        $rootScope.$broadcast("dismissModals");
        $rootScope.$broadcast("dismissPopovers");
    });

    /* *************** Global login / config management ***************** */

    $scope.isSAASAuth = function() {
        return $rootScope.appConfig && $rootScope.appConfig.saasAuth;
    };

    $scope.onConfigurationLoaded = function() {
        IntercomSupport.activate();
        FullstorySupport.activate();
        Assert.inScope($rootScope, 'appConfig');
        if(!$rootScope.appConfig.unattendedMode) {
            StateObserverService.init();
        }
        $rootScope.wl = $rootScope.appConfig.whiteLabeling;

        if ($rootScope.wl.referenceDocRootUrl) {
            $rootScope.versionDocRoot = $rootScope.wl.referenceDocRootUrl;
        }
        if ($rootScope.wl.apiDocRootUrl) {
            $rootScope.apiDocRoot = $rootScope.wl.apiDocRootUrl;
        }
        if ($rootScope.wl.academyRootUrl) {
            $rootScope.academyRootUrl = $rootScope.wl.academyRootUrl;
        }
        if ($rootScope.wl.learnRootUrl) {
            $rootScope.learnRootUrl = $rootScope.wl.learnRootUrl;
        }

        if ($rootScope.appConfig.loggedIn) {
            WebSocketService.connect();
            $scope.countNotifications();
            updateRequestCount();
            // Temporary stuff ... Just in case it remained here...
            WT1.delVisitorParam("tutorial-project");
            WT1.delVisitorParam("tutorial-id");
            WT1.configure();
            ErrorReporting.configure();
            TrackingService.configurePingTracking();
            if ($rootScope.appConfig.customJS) {
                function evalCustomJS() {
                    try {
                        eval($rootScope.appConfig.customJS); //NOSONAR
                    } catch (e){
                        $exceptionHandler(e);
                    }
                }
                evalCustomJS();
            }

            if ($rootScope.appConfig.loadedPlugins) {
                $rootScope.appConfig.loadedPlugins.forEach(function(pluginDesc) {
                    if (!pluginDesc.customJSSnippets) {
                        return;
                    }
                    function evalCustomJSSnippet(snippet) { //Keep a named function to easily spot custom js in stacks
                        try {
                            eval(snippet); //NOSONAR
                        } catch (e) {
                            $exceptionHandler(e);
                        }
                    }
                    pluginDesc.customJSSnippets.forEach(evalCustomJSSnippet);
                });
            }

            if ($rootScope.appConfig.theme) {
                $scope.setTheme($rootScope.appConfig.theme);
            }

            // For consumption only profiles, check if a profile upgrade request is pending
            if ($rootScope.mayRequestProfileUpgrade && $rootScope.mayRequestProfileUpgrade()) {
                RequestCenterService.checkPendingProfileRequestStatus($rootScope);
            }

            /** Additional license info */
            $rootScope.addLicInfo = {};
            $rootScope.addLicInfo.sparkLicensed = $rootScope.appConfig.licensedFeatures && $rootScope.appConfig.licensedFeatures.sparkAllowed || $rootScope.appConfig.ceEntrepriseTrial;
            $rootScope.addLicInfo.hiveLicensed = !$rootScope.appConfig.community;
            $rootScope.addLicInfo.pigLicensed = !$rootScope.appConfig.community;
            $rootScope.addLicInfo.impalaLicensed = !$rootScope.appConfig.community;
            $rootScope.addLicInfo.containersLicensed = !$rootScope.appConfig.community;

            if ($rootScope.appConfig.alationSettings.enabled) {
                AlationCatalogChooserService.install();
            }
        } else {
            /* Still configure WT1 for push login state event */
            WT1.configure();
        }
        if (window.devInstance) {
            Mousetrap.bind("@ r r", function(){
                $templateCache.removeAll();
                $cacheFactory.get("$http").removeAll();
                $state.go($state.current, $stateParams, {reload:true, inherit: false, notify: true});
            })
            Mousetrap.bind("@ c c", function(){
                $templateCache.removeAll();
                $cacheFactory.get("$http").removeAll();
            })
        }
    };

    function getParameters(location = window.location) {
        let params = {};

        const urlParams = new URLSearchParams(location.search);
        let iterator = urlParams.entries();
        let result = iterator.next();

        while( !result.done ) {
            params[result.value[0]] = result.value[1];
            result = iterator.next();
        }

        location.hash.substring(1).split('&').forEach(kv => {
            kv = kv.trim();
            if (kv) {
                const [k, v] = kv.split('=');
                params[k] = v;
            }
        });
        return params;
    }

    BuiltinMapBackgrounds.bindOnTranslateChangeSuccess()

    DataikuAPI.getConfiguration().success(function(data) {

        // on safari 15.x cookies are sometimes not set before success is invoked
        // this led to other requests to fail with a 403 because they are triggered by this success without cookie properly set.
        // the timeout solution is fragile but it works
        // see https://app.shortcut.com/dataiku/story/88346/connection-on-safari-is-buggy
        $timeout(()=> {
            $rootScope.appConfig = data;
            $scope.appConfig = data;
            window.dkuAppConfig = data;

            if(data.loggedIn) {
                if (data.userSettings && data.userSettings.uiLanguage) {
                    if (data.translations) {
                        PreloadedTranslationTables.add(data.userSettings.uiLanguage, data.translations);
                    }
                    $translate.use(data.userSettings.uiLanguage);
                } else if (data.userSettings) {
                    data.userSettings.uiLanguage = "en"; // Use English if no language is selected.
                }
                RecipeDescService.load($scope);
                CachedAPICalls.notifyLoggedIn();
            }

            var ac = data;
            WT1.event("studio-open", {
                loggedIn : ac.loggedIn,
                installId: ac.installId,
                version: ac.version,
                deploymentMode: ac.deploymentMode,
                cloudStacksCloud: ac.cloudStacksCloud,
                launcherVersion: ac.launcherVersion,
                vmInfo: ac.vmInfo,
                wslInfo: ac.wslInfo,
                hadoopVersion: ac.hadoopVersion,
                hasNodeName: !!ac.nodeName,
                hasExternalURL: !!ac.dssExternalURL,
                themeId: ac.theme && ac.theme.id,

                hadoopEnabled: ac.hadoopEnabled,
                hiveEnabled: ac.hiveEnabled,
                impalaEnabled: ac.impalaEnabled,
                pigEnabled: ac.pigEnabled,
                twitterEnabled: ac.twitterEnabled,
                rEnabled: ac.rEnabled,
                legacyH2OEnabled: ac.h2oEnabled,
                impersonationEnabled: ac.impersonationEnabled,
                sparkEnabled: ac.sparkEnabled,
                pluginDevExplicitCommit: ac.pluginDevExplicitCommit,
                pluginDevGitMode: ac.pluginDevGitMode,
                alationEnabled: !!ac.alationSettings && ac.alationSettings.enabled,
                anonRegistrationAllowed: ac.anonRegistrationAllowed,
                gitMode : ac.gitMode,

                nbProjectStatus: ac.projectStatusList && ac.projectStatusList.length || 0,

                plugins: ac.loadedPlugins.map(x => x.id).join(","),
                customCodeRecipes: ac.customCodeRecipes && ac.customCodeRecipes.length || 0,
                customDatasets: ac.customDatasets && ac.customDatasets.length || 0,
                customDialects: ac.customDialects && ac.customDialects.length || 0,
                customExporters: ac.customExporters && ac.customExporters.length || 0,
                customFSProviders: ac.customFSProviders && ac.customFSProviders.length || 0,
                customJavaFormats: ac.customJavaFormats && ac.customJavaFormats.length || 0,
                customJythonProcessors: ac.customJythonProcessors && ac.customJythonProcessors.length || 0,
                customPythonChecks: ac.customPythonChecks && ac.customPythonChecks.length || 0,
                customPythonFormats: ac.customPythonFormats && ac.customPythonFormats.length || 0,
                customPythonPluginSteps: ac.customPythonPluginSteps && ac.customPythonPluginSteps.length || 0,
                customPythonPluginTriggers: ac.customPythonPluginTriggers && ac.customPythonPluginTriggers.length || 0,
                customPythonProbes: ac.customPythonProbes && ac.customPythonProbes.length || 0,
                customRunnables: ac.customRunnables && ac.customRunnables.length || 0,
                customWebApps: ac.customWebApps && ac.customWebApps.length || 0,
                customSQLProbes: ac.customSQLProbes && ac.customSQLProbes.length || 0,
                nbHomeMessages: ac.homeMessages && ac.homeMessages.length || 0, // TODO @homepage cleanup when removing feature flag
                isOpalsEnabled: !!ac.opalsEnabled,

                noneProfileStartBehavior: ac.noneUsersCallToActionBehavior,
                allowRequestAccessWithStartedTrial: ac.allowRequestAccessWithStartedTrial,
                requiresExternalWelcomeEmail: !ac.emailChannelId || !(ac.welcomeEmailSettings && ac.welcomeEmailSettings.enabled),
            });

            if (ac && ac.version && ac.version.product_version && ac.version.product_version.includes('dev') && !window.localStorage.forceRollbar) {
                // Disable WT1 reporting for dev kits
                window.devInstance = true;
            }

            if (!$scope.appConfig.loggedIn) {
                /* Don't redirect to login access to the login or logout page */
                if ($location.path().indexOf("/login/openid-redirect-uri/") === 0) {
                    const params = getParameters(window.location);

                    if (params["error"]) {
                        Logger.info("An error happened during the authentication.");
                        $state.transitionTo("sso-error", {error : "Identity provider error: " + params["error"], errorDescription: params["error_description"]});
                        return;
                    }

                    var code = params["code"];
                    var state = params["state"];

                    let getStateFromLocalStorage = localStorageService.get("openid-state");
                    localStorageService.remove("openid-state");
                    if (getStateFromLocalStorage != state) {
                        Logger.info("An error happened during the authentication. The State is not matching the initial one");
                        $state.transitionTo("sso-error", {error : "DSS error ", errorDescription: "Initial state value not matching request state param. This could be an attack attempt, please contact your administrator."});
                        return;
                    }

                    DataikuAPI.exchangeAuthorizationCode(code, state).success(function(data){
                        const redirectTo = localStorageService.get("postSSOLoginRedirect");
                        const search = localStorageService.get("postSSOLoginSearch") || "";
                        if (redirectTo) {
                            Logger.info("There is a post-SSO login redirect, following it", redirectTo + "?" + search);
                            localStorageService.remove("postSSOLoginRedirect");
                            localStorageService.remove("postSSOLoginSearch");
                            const url = new URL(window.location.href);
                            url.search = search;
                            url.pathname = redirectTo;  // Only follow redirects to a local path, not to another site
                            window.location = url.href;
                            return;
                        }
                    }).error(function(error) {
                        Logger.info("An error happened during the authentication.");
                        $state.transitionTo("sso-error", {error : "DSS error " + (error.code ? error.code: "") , errorDescription: error.detailedMessage});
                    });

                    return;
                } else if ($location.path().indexOf("/login/") === 0 || $location.path().indexOf("/login") === 0 || $location.path().indexOf("/logged-out") === 0 || $location.path().indexOf("/sso-error") === 0) {
                    return;
                } else if ($scope.appConfig.licensingMode == 'NONE') {
                    Logger.info("Not logged in, but registration flow active, not redirecting");
                } else if ($scope.isSAASAuth() && !$scope.appConfig.saasAccess.loggedIn) {
                    Logger.info("You are not logged in, redirecting you ...");
                    window.location = $scope.appConfig.saasUserURL + "/login/?redirectTo=" + window.location + "&search=" + $httpParamSerializer($location.search());
                } else if ($scope.isSAASAuth() && $scope.appConfig.saasAccess.loggedIn) {
                    Logger.info("logged in but no SAAS access");
                } else if ($scope.appConfig.noLoginMode) {
                    Logger.info("Not logged in, but no-login-mode enabled, getting an access token");
                    DataikuAPI.noLoginLogin().success(_ => location.reload());
                } else if ($scope.appConfig.ssoLoginEnabled) {
                    const params = getParameters();
                    if (params["error"]) {
                        Logger.info("An error happened during the authentication.");
                        // Redirect to login
                        $state.transitionTo("sso-error", {error : params["error"], errorDescription: params["error_description"]});
                        return;
                    }
                    const setPostSSOLogin = () => {
                        let path = '/', search = '';
                        if ('redirectTo' in params) {
                            [path, ...search] = params.redirectTo.split('?');
                            search = search.join('?');
                        } else if ($location.path()) {
                            path = $location.path();
                            search = $httpParamSerializer($location.search());
                        }
                        Logger.info("Setting a post-SSO redirect to", path, search);
                        localStorageService.set("postSSOLoginRedirect", path);
                        localStorageService.set("postSSOLoginSearch", search);
                        let redirectTo = path;
                        if (search) redirectTo += '?' + search;
                        return redirectTo;
                    };
                    if ($scope.appConfig.ssoProtocol == "SAML") {
                        const redirectTo = setPostSSOLogin();
                        DataikuAPI.getSAMLRedirectURL(redirectTo).success(function(data){
                            Logger.info("SAML redirect url: " + data.url);
                            window.location = data.url;
                        }).error(function(error) {
                            Logger.info("An error happened during the authentication.");
                            $state.transitionTo("sso-error", {error : "DSS error ", errorDescription: error.message ? error.message : "Please contact your administrator." });
                        });
                    } else if ($scope.appConfig.ssoProtocol == "OPENID") {
                        setPostSSOLogin();
                        DataikuAPI.getOpenIDRedirectURL().success(function(data){
                            localStorageService.set("openid-state", data.state);
                            window.location = data.url;
                        }).error(function(error) {
                            Logger.info("An error happened during the authentication.");
                            $state.transitionTo("sso-error", {error : "DSS error ", errorDescription: error.message? error.message : error});
                        });
                    } else if ($scope.appConfig.ssoProtocol == "SPNEGO") {
                        Logger.info("SPNEGO mode, redirecting to login URL");
                        window.location = "/dip/api/spnego-login";
                    }
                } else {
                    Logger.info("You are not logged in, redirecting you ...");
                    const params = getParameters();
                    // Redirect to login
                    if ('redirectTo' in params) {
                        const [path, ...search] = params.redirectTo.split('?');
                        $state.transitionTo("login", {redirectTo: path, search: search.join('?')});
                    } else {
                        $state.transitionTo("login", {redirectTo: $location.path(), search: $httpParamSerializer($location.search())});
                    }
                }
            } else if (!$scope.appConfig.unattendedMode &&  // When launched by puppeteer and automated tools, do not display the licence warning
                        $scope.appConfig.licensing.expired &&
                        $scope.appConfig.loggedIn &&
                        $scope.appConfig.admin) {
                const last = localStorageService.get("licenseExpired");
                if (!last || last <= Date.now() - 24 * 3600000) {
                    Dialogs.ack($scope,
                        "License expired!",
                        "Your DSS license expired on " + (new Date($scope.appConfig.licensing.expiresOn)).toLocaleString()
                    );
                    localStorageService.set("licenseExpired", Date.now());
                }
            } else if (!$scope.appConfig.unattendedMode && // When launched by puppeteer and automated tools, do not display the licence warning
                    $scope.appConfig.licensing.expiresOn &&  // 0 on Free Edition
                    $scope.appConfig.licensing.expiresOn <= Date.now() + 7 * 24 * 3600000 &&
                    $scope.appConfig.loggedIn &&
                    $scope.appConfig.admin) {
                const last = localStorageService.get("licenseExpiring");
                if (!last || last <= Date.now() - 24 * 3600000) {
                    Dialogs.ack($scope,
                        "License expires soon!",
                        "Your DSS license expires on " + (new Date($scope.appConfig.licensing.expiresOn)).toLocaleString()
                    );
                    localStorageService.set("licenseExpiring", Date.now());
                }
            } else {
                const redirectTo = localStorageService.get("postSSOLoginRedirect");
                const search = localStorageService.get("postSSOLoginSearch") || "";
                if (redirectTo) {
                    Logger.info("There is a post-SSO login redirect, following it", redirectTo + "?" + search);
                    localStorageService.remove("postSSOLoginRedirect");
                    localStorageService.remove("postSSOLoginSearch");
                    const url = new URL(window.location.href);
                    url.search = search;
                    url.pathname = redirectTo;  // Only follow redirects to a local path, not to another site
                    if (window.location.href !== url.href) {
                        Logger.info("redirect from", window.location.href, "to", url.href);
                        window.location = url.href;
                    } else {
                        Logger.info("no redirect needed");
                    }
                    return;
                }

                /* None user --> redirects to /home for the call to action */
                if ($scope.appConfig.userProfile && $scope.appConfig.userProfile.profile == 'NONE' && $location.path().indexOf("/home/") !== 0) {
                    Logger.info("NONE profile directly accessing a page, redirecting to home");
                    // TODO @homepage cleanup one migration done
                    if($rootScope.featureFlagEnabled('homepageRedesign')) {
                        $state.go('homeV2.homepage', null, {location: "replace"});
                    } else {
                        $state.go('home', null, {location: "replace"});
                    }
                }
            }
            $scope.onConfigurationLoaded();
        });
    }).error(setErrorInScope.bind($scope));

    $scope.isDSSAdmin = function(permission) {
        return $scope.appConfig && $scope.appConfig.loggedIn && $scope.appConfig.admin;
    };
    $rootScope.isDSSAdmin = $scope.isDSSAdmin;
    $rootScope.mayRequestProfileUpgrade = () => {
        const consumptionOnlyProfiles = ["READER", "EXPLORER", "AI_CONSUMER", "AI_ACCESS_USER", "GOVERNANCE_MANAGER"];
        const weirdlyForbidden = $scope.isDSSAdmin();
        return !weirdlyForbidden && $rootScope.appConfig && $rootScope.appConfig.userProfile && consumptionOnlyProfiles.includes($rootScope.appConfig.userProfile.profile) && !$rootScope.dismissUpgradeProfile
        && !($rootScope.appConfig.trialStatus && $rootScope.appConfig.trialStatus.valid);
    }

    $rootScope.sendWT1RequestUpgradeProfileShow = function() {
        WT1.tryEvent("request-upgrade-profile-show", () => {
            return { origin: "error-pop-up" }
        });
    }

    $rootScope.sendWT1RequestUpgradeProfileOpenModal = function() {
        WT1.tryEvent("request-upgrade-profile-open-modal", () => {
            return { origin: "error-pop-up" }
        });
    }

    $rootScope.openProfileUpgradeModal = function(fromErrorPopup) {
        if (fromErrorPopup) {
            $scope.sendWT1RequestUpgradeProfileOpenModal();
        }
        return CreateModalFromTemplate("/templates/request-profile-upgrade-modal.html", $rootScope, null, function(newScope) {
            newScope.profileUpgradeText = "Your current user profiles gives you limited access to Dataiku capabilities (mainly viewing content, but not modifying it).";
            newScope.textArea = { requestMessage: "" };
            RequestCenterService.checkPendingProfileRequestStatus($rootScope);
            newScope.requestProfileUpgrade = function(requestMessage) {
                DataikuAPI.requests.createProfileUpgradeRequest(requestMessage).success((data) => {
                    RequestCenterService.WT1Events.onRequestSent("PROFILE", null, null, requestMessage, data.id);
                    ActivityIndicator.success("Profile upgrade request sent!", 5000);
                    newScope.dismiss();
                    $rootScope.hasPendingProfileRequest = true;
                }).error(setErrorInScope.bind(newScope));
            };
        });
    };

    // TODO @homepage should be deletable once homepage is migrated
    $scope.canWriteInProjectFolder = function() {
        let currentFolder = ProjectFolderContext.getCurrentProjectFolder();
        return ProjectFolderContext.getCurrentProjectFolderId() && (currentFolder || {}).id == ProjectFolderContext.getCurrentProjectFolderId() ? (currentFolder && currentFolder.canWriteContents) : $rootScope.appConfig.globalPermissions.mayWriteInRootProjectFolder;
    };
    $rootScope.canWriteInProjectFolder = $scope.canWriteInProjectFolder;

    $scope.isPluginDeveloper = function() {
        return $scope.appConfig && $scope.appConfig.loggedIn && ($scope.appConfig.admin || $scope.appConfig.globalPermissions.mayDevelopPlugins);
    };

    $scope.isCodeStudioTemplateDeveloper = function() {
        return $scope.appConfig && $scope.appConfig.loggedIn && ($scope.appConfig.admin || $scope.appConfig.globalPermissions.mayCreateCodeStudioTemplates || $scope.appConfig.globalPermissions.mayManageCodeStudioTemplates);
    };

    $scope.isLibFolderEditor = function() {
        return $scope.appConfig && $scope.appConfig.loggedIn && ($scope.appConfig.admin || $scope.appConfig.globalPermissions.mayEditLibFolders);
    };

    $scope.mayWriteSafeCode = function() {
        return $scope.appConfig && $scope.appConfig.loggedIn &&
        ($scope.appConfig.admin || $scope.appConfig.globalPermissions.mayWriteUnsafeCode || ($scope.appConfig.impersonationEnabled && $scope.appConfig.globalPermissions.mayWriteSafeCode));
    };

    $scope.mayWriteUnsafeCode = function() {
        return $scope.appConfig && $scope.appConfig.loggedIn &&
        ($scope.appConfig.admin || $scope.appConfig.globalPermissions.mayWriteUnsafeCode);
    };

    $scope.mayCreateActiveWebContent = function() {
        return $scope.appConfig && $scope.appConfig.loggedIn &&
        ($scope.appConfig.admin || $scope.appConfig.globalPermissions.mayCreateActiveWebContent);
    };

    $rootScope.mayCreateCodeEnvs = function() {
        return $scope.appConfig && $scope.appConfig.loggedIn &&
        ($scope.appConfig.admin || $scope.appConfig.globalPermissions.mayCreateCodeEnvs || $scope.appConfig.globalPermissions.mayManageCodeEnvs);
    }

    $scope.canSeeAdminMenu = function() {
        if (!$scope.appConfig || !$scope.appConfig.loggedIn) {
            return false;
        }
        /* Because of code envs, anybody must be allowed to access the administration screen
         * (almost anybody will have at least "use") */
        return true;
    };

    $scope.adminMenuSref = function() {
        if (!$scope.appConfig || !$scope.appConfig.dkuCloudLaunchpadUrl) {
            return 'admin.home';
        }

        if ($scope.appConfig.isAutomation) {
            return 'admin.codeenvs-automation.list';
        }

        return 'admin.codeenvs-design.list'
    };

    $scope.openRequestTrialModal = function(){
        CreateModalFromTemplate("/templates/request-trial-modal.html", $scope);
    };

    $scope.logout = function(){
        if ($scope.isSAASAuth()) {
            window.location = $scope.appConfig.saasUserURL + "/logout/";
        } else {
            DataikuAPI.logout().success(function(data) {
                // Violent redirect to avoid keeping a cached appConfig
                if ($scope.appConfig && $scope.appConfig.postLogoutBehavior == "CUSTOM_URL") {
                    window.location = $scope.appConfig.postLogoutCustomURL;
                } else {
                    window.location = "/logged-out";
                }
            });
        }
    };

    /* ********************* Keyboard shortcuts handling ******************* */
    $scope.keyboardsModal = { shown : false };
    $rootScope.showKeyboardShortcuts = function() {
        if (!$scope.keyboardsModal.shown) {
            $scope.closeContextualMenus();
            $scope.keyboardsModal.shown = true;
            CreateModalFromTemplate("/templates/shortcuts.html", $scope, null, function(newScope) {
                newScope.$on("$destroy", function(){ $scope.keyboardsModal.shown = false});
            });
        }
    }

    $rootScope.showAdminContactInfo = function(){
        CreateModalFromTemplate("/templates/dialogs/admin-contact.html", $scope);
    }

    const originalStopCallback = Mousetrap.prototype.stopCallback;
    Mousetrap.prototype.stopCallback = function(e, element) {
        // if the element or any of its ancestors has the class "prevent-mousetrap" then deactivate all keyboard shortcuts
        if (element.closest('.prevent-mousetrap')) {
            return true;
        }
        return originalStopCallback.apply(this, arguments)
    }

    Mousetrap.bind("?", function() {
        $scope.showKeyboardShortcuts();
        $scope.$apply();
    });

    Mousetrap.bind(": q", function() {
        window.location = "about:blank"
    })

    var goToView = function(viewRoute) {
        return function() {
            if ($stateParams.projectKey) {
                let zoneId = $scope.getDestZone();
                $state.go(viewRoute, {projectKey : $stateParams.projectKey, zoneId : zoneId}, {reload: true});
            }
        }
    };

    $scope.reloadPluginConfiguration = function() {
        // reload config & descriptors for smoother plugin development
        if ($rootScope.appConfig && $rootScope.appConfig.loggedIn) {
            // no point if you're not already logged in
            DataikuAPI.plugindev.reloadAll().success(function(data) {
                DataikuAPI.getConfiguration().success(function(data) {
                    $rootScope.appConfig = data;
                    $scope.appConfig = data;
                    window.dkuAppConfig = data;
                    if ( CachedAPICalls != null ) {
                        // reload recipe types
                        RecipeDescService.load($scope);
                    }
                });
            });
        }
    };

    $scope.reloadAppConfig = function() {
        // reload config after modifying the admin settings for example
        if ($rootScope.appConfig && $rootScope.appConfig.loggedIn) {
            // no point if you're not already logged in
            DataikuAPI.getConfiguration().success(function(data) {
                $rootScope.appConfig = data;
                $scope.appConfig = data;
                window.dkuAppConfig = data;
            });
        }
    };

    Mousetrap.bind("@ r c d", $scope.reloadPluginConfiguration);
    Mousetrap.bind("g c", function() { $state.go("catalog.items", {}, {reload: true});  });
    Mousetrap.bind("g f", goToView("projects.project.flow"));
    Mousetrap.bind("g n", goToView("projects.project.notebooks.list"));
    Mousetrap.bind("g d", goToView("projects.project.datasets.list"));
    Mousetrap.bind("g r", goToView("projects.project.recipes.list"));
    Mousetrap.bind("g a", goToView("projects.project.analyses.list"));
    Mousetrap.bind("g p", goToView("projects.project.dashboards.list"));
    Mousetrap.bind("g i", goToView("projects.project.dashboards.insights.list"));
    Mousetrap.bind("g j", goToView("projects.project.jobs.list"));
    Mousetrap.bind("g q", goToView("projects.project.data-quality.current-status"));
    Mousetrap.bind("g w", goToView("projects.project.wiki"));
    Mousetrap.bind("g l", goToView("projects.project.libedition.versioned"));
    Mousetrap.bind("g h", function() { $rootScope.showHelp(null); });

    Mousetrap.bind("0 0 7", goToView("projects.project.agenttools.list"));

    Mousetrap.bind("c h a m p i o n s", function() {
        $(".master-nav").addClass("master-nav-champions");
        $(".icon-dkubird").replaceWith("<img class='champions'>");
        $(".dku-icon-dataiku-24").replaceWith("<img class='champions not-hover'>");
        $(".champions").attr("src","/static/dataiku/images/coq.png");
    });

    Mousetrap.bind("c f o m o d e", function() {
        $(".pivot-chart").css("filter", "grayscale(1) blur(3px)")
    });

    Mousetrap.bind("@ r b", function(){
        if ($state.current.name.startsWith("projects.project.webapps.webapp")){
            DataikuAPI.webapps.restartBackend({"projectKey":$stateParams.projectKey, "id":$stateParams.webAppId})
        }
    })

    Mousetrap.bind("s e u m", function() {
        $(".master-nav").addClass("master-nav-seum");
    });

    Mousetrap.bind("k i t t y", function() {
        CreateModalFromTemplate("/templates/kitty.html", $scope, null, function(newScope) {
            $timeout(function(){
                $rootScope.$broadcast("reflow")
            }, 0);
        });
    });

    Mousetrap.bind("r o c k e t", function() {
        if ($state.current.name.startsWith('projectdeployer')) {
            const sentences = [
                {msg: "I'm stepping through the door"},
                {error: true, msg: "Your circuit's dead, there's something wrong"},
                {error: true, msg:"Can you hear me, Major Tom?"},
                {msg: "Now it's time to leave the capsule if you dare"}
            ];

            CreateModalFromTemplate("/templates/rocket.html", $scope, null, function(newScope) {
                $scope.leaveMessage = sentences[Math.floor(Math.random()*sentences.length)];
                $timeout(function(){
                    $rootScope.$broadcast("reflow")
                }, 0);
            });
        }
    });

    Mousetrap.bind("p u p p y", function() {
        CreateModalFromTemplate("/templates/puppy.html", $scope, null, function(newScope) {
            $timeout(function(){
                $rootScope.$broadcast("reflow")
            }, 0);
        });
    });

    Mousetrap.bind("c o m i c", function() {
        var rnd = Math.floor(Math.random()*3);
        var font = ["'Comic Neue'", "cursive", "fantasy"][rnd];

        $("head").append($("<link rel='stylesheet' type='text/css' href='https://dku-assets.s3.amazonaws.com/comicneue/comicneue.css'>"));
        $("head").append($("<style>div, button, p, span, a, input, textarea { font-family: " + font + " !important;}</style>"));
    });

    function setColor(x) {
        $("body").css("background-color", x);
        $("#flow-graph").css("background-color", x);
    }

    Mousetrap.bind("s a r c e l l e", function() {
        if (Math.random() > 0.75) {
           setColor("#045067");
        } else {
            setColor("#2AB1AC");
        }
    });

    Mousetrap.bind("p i n k", function() {
            $("body").css("background-color", "pink");
    });

    Mousetrap.bind("p u r p l e", function() {
            $("body").css("background-color", "purple");
    });

    Mousetrap.bind("& @ &", function(){
        CreateModalFromTemplate("/templates/debugging-tools.html", $scope, "DebuggingToolsController");
    });

    Mousetrap.bind("@ t", function() {
        if ($scope.appConfig && $scope.appConfig.loggedIn && $scope.appConfig.admin) {
            CreateModalFromTemplate("/templates/translation-tools.html", $scope, "TranslationToolsController");
        }
    });

    function trollMe() {
        $("i").addClass("icon-spin");
        $(".avatar20").addClass("icon-spin");
        $(".avatar32").addClass("icon-spin");
        $(".avatar").addClass("icon-spin");
    }

    function untrollMe() {
        $("i").removeClass("icon-spin");
        $(".avatar20").removeClass("icon-spin");
        $(".avatar32").removeClass("icon-spin");
        $(".avatar").removeClass("icon-spin");
    }

    window.showNativeNotification = function(txt, tag, onclick, user) {
        if ("document.hasFocus", document.hasFocus()) return; // Only display notification when the user is not on the page
        if (window.Notification.permission === "default") {
            // User did not choose the notifications type yet, ask (but don't wait for the answer to display in-window notification)
            window.Notification.requestPermission(function (permission) {
                WT1.event("allow-browser-notification", {permission : permission});
            });
        } else if (window.Notification.permission === "granted") {
            // User native browser Notifications
            var options = {
                icon: UserImageUrl(user || $rootScope.appConfig.login, 200),
                dir: "ltr",
                tag: tag,
                renotify: false,
                silent: true
            };
            var notification = new window.Notification(txt, options);

            notification.onclick = (function(onclick) {return function () {
                window.focus();
                if (onclick) onclick();
                this.close();
            };})(onclick);

            var timeout = setTimeout((function(n){return function(){ n.close()}; }(notification)), 5000);// native notifications have no custom timeout
        }
    }

    Notification.registerEvent('spinnee-troll',function() {
        trollMe();
    });

    Notification.registerEvent('spinnee-untroll',function() {
        untrollMe();
    });

    Mousetrap.bind("w h e e e", function() {
        // Troll others
        Notification.broadcastToOtherSessions('spinnee-troll',{lol:"salut"});

        // Untroll me
        untrollMe();
    });

    Mousetrap.bind("w h o o o", function() {
        // Untroll everyone
        Notification.broadcastToFrontends('spinnee-untroll',{lol:"salut"});
    })

    function fallingBird() {
        $(".dku-icon-dataiku-24").css("visibility", "hidden");
        var falling = $("<i class='icon-dkubird falling-bird' />");
        $("body").append(falling);
        $("body").append($("<audio src='/static/dataiku/css/rifle.mp3' autoplay/>"));
        window.setTimeout(function(){falling.css("top", "105%")}, 10);
    }

    Mousetrap.bind("p a n", fallingBird);
    Mousetrap.bind("b a n g", fallingBird);

    Mousetrap.bind("s o n i a", function () {
        $("body").append($("<audio src='/static/dataiku/css/sonia.mp3' autoplay/>"));
    });

    Mousetrap.bind("d r w h o", function() {
        if (!$state.current.name.startsWith('projects.project.savedmodels.savedmodel') && !$state.current.name.startsWith('projects.project.analyses.analysis.ml.predmltask')) return;
        CreateModalFromTemplate("/templates/drwho.html", $scope, null, function(newScope) {
            $timeout(function(){
                $rootScope.$broadcast("reflow")
            }, 0);
        });
    });

    Mousetrap.bind("f u r y r o a d", function() {
        if ($state.current.name.startsWith('apideployer')) {
            $('head').append($('<style>@keyframes furyroad{from{left:0%;}to{left:100%;}}</style>'));
            $('body').append($('<div style="position: fixed; height: 400px; width: 600px; bottom: 0; animation-name: furyroad; animation-duration: 4s; animation-timing-function: ease-in-out; animation-iteration-count: infinite;"><svg viewBox="0 0 600 400"><circle cx="145" cy="295" r="30" fill="#6b6c69" stroke="#000"/><circle cx="145" cy="295" r="20" fill="#907354" stroke="#000"/><circle cx="145" cy="295" r="5" fill="#6b6c69" stroke="#000"/><circle cx="395" cy="295" r="30" fill="#6b6c69" stroke="#000"/><circle cx="395" cy="295" r="20" fill="#907354" stroke="#000"/><circle cx="395" cy="295" r="5" fill="#6b6c69" stroke="#000"/><path d="m100 300v-100q0-20 20-20h100q30 0 50 20l10 10q20 20 50 20l100-10q10 0 10 10v70h-10v-10q-7-13-20-20h-30q-13 7-20 20v10h-180v-10q-7-13-20-20h-30q-13 7-20 20v10h-10z" fill="#907354" stroke="#000"/><path d="m110 260q35-20 70 0l40 20q20 10 40 10" fill="transparent" stroke="#000"/><path d="m110 230v-30q0-10 10-10h50v40h-60z" fill="#ba9e9a" stroke="#000"/><path d="m180 230v-40h50q20 5 40 25v15h-90z" fill="#ba9e9a" stroke="#000"/><path d="m422 240l20-10q5-5 10 0v30q-5 5-10 0l-20-10q-5-5 0-10z" fill="#7d4842" stroke="#000"/><path d="m100 290l-80-40v-15l80 50v5z" fill="#6b6c69" stroke="#000"/><path d="m100 280l-80-60v-20l80 75v5z" fill="#6b6c69" stroke="#000"/><path d="m418 220l4-200h-2v-10h6v10h-2l-4 200h-2z" fill="#444" stroke="#000"/><path d="m422 220l10-200h-2v-10h6v10h-2l-10 200h-2z" fill="#444" stroke="#000"/><path d="m120 180l-30-50 40 50z" fill="#7d4842" stroke="#000"/><path d="m140 180l10-40v40z" fill="#7d4842" stroke="#000"/><path d="m170 180l-10-80 20 80z" fill="#7d4842" stroke="#000"/><path d="m190 180l-20-50 30 50z" fill="#7d4842" stroke="#000"/><path d="m210 180l40-50-30 50z" fill="#7d4842" stroke="#000"/><path d="m220 180l10-90v90z" fill="#7d4842" stroke="#000"/><path d="m130 180l-30-100 40 100z" fill="#7d4842" stroke="#000"/><path d="m155 180l-10-90 20 90z" fill="#7d4842" stroke="#000"/><path d="m180 180l20-80-10 80z" fill="#7d4842" stroke="#000"/><path d="m195 180v-120l10 120z" fill="#7d4842" stroke="#000"/><path d="m205 180l10-50v50z" fill="#7d4842" stroke="#000"/><path d="m330 230l-20-50 30 49z" fill="#7d4842" stroke="#000"/><path d="m352 228l10-40v38z" fill="#7d4842" stroke="#000"/><path d="m370 226l-10-80 20 79z" fill="#7d4842" stroke="#000"/><path d="m388 224l25-50-15 49z" fill="#7d4842" stroke="#000"/><path d="m410 222l-20-120 30 118z" fill="#7d4842" stroke="#000"/><path d="m420 220l30-90-20 90z" fill="#7d4842" stroke="#000"/><path d="m340 229l10-90v89z" fill="#7d4842" stroke="#000"/><path d="m358 227l50-120-40 119z" fill="#7d4842" stroke="#000"/></svg></div>'));
        }
    });

    Mousetrap.bind("n e y m a r", function() {
        $('head').append($('<style>@keyframes neymar{from{left:0%;transform:rotate(0deg);}to{left:100%;transform:rotate(4000deg);}}</style>'));
        const el = $('.icon-dkubird');
        el.css('position', 'absolute').css('color', 'yellow').css('background', '#184bad').css('top', '12px').css('animation-name', 'neymar').css('animation-duration', '10s').css('animation-timing-function', 'linear').css('animation-iteration-count', 'infinite');
    });

    Mousetrap.bind("b i g b r o t h e r", function() {
        $('body').append($('<div style="position: absolute;z-index: 2147483647000;bottom: 0;left: 0;right: 0;width: 100%;height: 415px;background: white;box-shadow: #121212 2px 2px 14px 2px;"><div style="margin: 20px auto;width: 450px;"><h4>This website uses quotes <i class="icon-eye-open"/></h4><p style=" line-height: 1.6em; font-size: 1.2em;">“He thought of the telescreen with its never-sleeping ear. They could spy upon you night and day, but if you kept your head you could still outwit them. With all their cleverness they had never mastered the secret of finding out what another human being was thinking. . . . Facts, at any rate, could not be kept hidden. They could be tracked down by inquiry, they could be squeezed out of you by torture. But if the object was not to stay alive but to stay human, what difference did it ultimately make? They could not alter your feelings; for that matter you could not alter them yourself, even if you wanted to. They could lay bare in the utmost detail everything that you had done or said or thought; but the inner heart, whose workings were mysterious even to yourself, remained impregnable.”</p><p class="" style="text-align: right;font-weight: bold;">― George Orwell, 1984</p><div><button class="btn btn--primary pull-right">2 + 2 = 5</button></div></div></div>'));
        $('body').append($('<div style="position: absolute;z-index: 2147483647000;top: 0;left: 0;right: 0;width: 100%;height: 150px;background: white;box-shadow: #121212 2px 2px 14px 2px;"><div style="margin: 20px auto;width: 450px;"><div class="alert alert-danger">Warning angry cookies</div><p style="height: 45px; background: repeat-x url(data:image/png;base64,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)"></p></div></div>'));
    });

    Mousetrap.bind("r m space - r f space /", function() {
        if ($state.current.name.startsWith('project-list')) {
            const e=$("<div style=\"position:absolute;padding:4px;width:500px;height:350px;top:50%;left:50%;transform:translate(-50%,-50%);background:#000;color:#fff;font-size:10px;font-family:Monaco,'SF Mono',Consolas,Console;z-index:999999999999;line-height:12px;font-weight:lighter;border-radius:6px;border-top:solid 20px #dedede;box-shadow:0 10px 20px rgba(0,0,0,.19),0 6px 6px rgba(0,0,0,.23)\"></div>"),i=$('<div style="overflow-y:auto;height:100%"></div>');e.append($('<div style="position:absolute;border:solid 6px #ff6158; border-radius:6px;top:-16px;left:7px"></div><div style="position:absolute;border:solid 6px #ffbd2e; border-radius:6px;top:-16px;left:26px"></div><div style="position:absolute;border:solid 6px #27c940; border-radius:6px;top:-16px;left:45px"></div>')),e.append(i),$("body").append(e);const h=$("<div>MBP-DKU:~ dataiku$ rm -rf /</div>");function l(){const o="rm: cannot remove `"+(1==Math.floor(2*Math.random())+1?"/etc/"+function(){const o=Math.floor(6*Math.random())+3;let t="";for(let e=0;e<o;e++)t+="abcdefghijklmnopqrstuvwxyz"[Math.floor(25*Math.random())];return t}()+".d":"/proc/"+(Math.floor(10235*Math.random())+255))+"': Permissions denied",t=$("<div>"+o+"</div>");i.append(t),t[0].scrollIntoView(),Math.floor(3*Math.random())===0&&$(".project-folder, .project").first().remove(),$timeout(l,Math.floor(50*Math.pow(10,Math.random()+.1))+2)}i.append(h),l(); //NOSONAR
        }
    });

    Mousetrap.bind("m a s s e", function() {
        let items = [
            { title: 'A', desc: "Qu'il n'est pas encore arrivé à Toronto" },
            { title: 'B', desc: "Qu'il est supposé arriver à Toronto, mais qu'on l'attend toujours" },
            { title: 'C', desc: "Qu'est-ce qu'il fout ce maudit pancake tabernacle\u00A0?" },
            { title: 'D', desc: "La réponse D" }
        ];
        Dialogs.select($scope, "Qui veut gagner de l'argent en masse\u00A0?",
            "Lorsqu'un Pancake prend l'avion à destination de Toronto, et qui s'en va faire une escale technique à St Claude, qui c'est qu'on va dire de ce pancake là ?",
            items,
        ).then(function(bafouille) {
            Dialogs.confirmSimple($scope, "C'est votre ultime bafouille\u00A0?", true).then(function() {
                 Dialogs.ack($scope, bafouille === items[2] ? "Bravo Gui" : "Vous auriez dû prendre le super moit-moit");
            });
        });
    });

    Mousetrap.bind("u n d e r space t h e space h o o d", () => {
        $('#dku-under-the-hood-dku').remove();
        $('.right-panel__content').append($('<div id="dku-under-the-hood-dku" style="position: absolute;z-index: 2147483647000;bottom: -151px;right: 0;width: 200px;height: 151px;background: white;transition: bottom 2s ease;-webkit-transition: bottom 2s ease;-moz-transition: bottom 2s ease;"><img style="width: 200px;height: 151px;" src="data:image/jpeg;base64,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"></div>'));
        setTimeout(() => $('#dku-under-the-hood-dku').css('bottom', '0px'), 200);
    });

    // Begining Clippy.js
    var clippyjs_agent;
    function create_clippyjs_agent(name_agent, callback) {
        name_agent = typeof name_agent !== 'undefined' ? name_agent : 'Clippy';
        clippy.load(name_agent, function(agent) {
            clippyjs_agent = agent;
            clippyjs_agent.show();
            //clippyjs_agent.moveTo(window.innerWidth-200,window.innerHeight-200);
            if (callback && typeof(callback) === "function") {
                callback();
            }
        });
    }

    Mousetrap.bind("c l i p p y", function() {
        if (typeof clippyjs_agent == 'undefined') {
            // First call : initializing
            clippyjs_agent = null;
            $("head").append($("<link rel='stylesheet' type='text/css' href='https://dku-assets.s3.amazonaws.com/clippy-js/clippy.css'>"));
            $("head").append($("<style>#loader-clippy{position:fixed;top:0px;left:0px;width:100%}#loader-clippy>div{margin:10em auto;"
                             +"font-size:10px;position:relative;text-indent:-9999em;border-top:1.1em solid rgba(255,255,255,.2);"
                             +"border-right:1.1em solid rgba(255,255,255,.2);border-bottom:1.1em solid rgba(255,255,255,.2);"
                             +"border-left:1.1em solid #ffc324;-webkit-transform:translateZ(0);transform:translateZ(0);"
                             +"-webkit-animation:load8 1.1s infinite linear;animation:load8 1.1s infinite linear;border-radius:50%;"
                             +"width:10em;height:10em}@-webkit-keyframes load8{0%{transform:rotate(0deg)}100%{transform:rotate(360deg)}}"
                             +"@keyframes load8{0%{transform:rotate(0deg)}100%{transform:rotate(360deg)}}"
                             +".clippy,.clippy-balloon{z-index:4000 !important}</style>"));
            $("body").append($("<div id='loader-clippy'><div></div></div>"));
            $("body").append($("<script type='text/javascript' src='https://dku-assets.s3.amazonaws.com/clippy-js/clippy.min.js'>"));
            setTimeout(function(){
                create_clippyjs_agent('Clippy', function(){
                    $("#loader-clippy").remove();
                });
            }, 1500);
        }
        else if (clippyjs_agent !== null) {
            // After first call : switching agent
            clippyjs_agent.hide(true, function() {
                $('.clippy').remove();
                $('.clippy-balloon').remove();
                if (clippyjs_agent.path.indexOf('Clippy') > -1) {
                    create_clippyjs_agent('Links', function() {
                        clippyjs_agent.play('GetWizardy');
                    });
                } else if (clippyjs_agent.path.indexOf('Links') > -1) {
                    create_clippyjs_agent('Merlin');
                } else {
                    create_clippyjs_agent('Clippy');
                }
            });
        }
    });

    Notification.registerEvent("job-state-change", function(evt, message) {
        if (message.state == "RUNNING" && typeof clippyjs_agent != 'undefined') {
            clippyjs_agent.play('Writing');
        } else if (message.state == "DONE" && typeof clippyjs_agent != 'undefined') {
            clippyjs_agent.play('Congratulate');
        } else if (message.state == "FAILED" && typeof clippyjs_agent != 'undefined') {
            clippyjs_agent.play('Alert');
        }
    });
    // End Clippy.js

    Mousetrap.bind("m s g a l l", function() {
        if ($rootScope.appConfig.admin === true) {
            var msg = window.prompt("What message do you want to send to all users?");
            Notification.broadcastToFrontends('msg-all', {msg:msg, user:$rootScope.appConfig.user});
        }
        else {
            alert("You must be admin to send a message."); // NOSONAR: OK to use alert for this message
        }
    });
    Notification.registerEvent('msg-all',function(evt, data) {
        MessengerUtils.post({
          message: "<div><b>Message from " + userLink(data.user.login, sanitize(data.user.displayName)) + ":</b><br>"+sanitize(data.msg)+"</div>",
          icon: userAvatar(data.user.login),
          hideAfter: 120,
          showCloseButton: true,
          id: 'msg-all-'+data.msg,
          type: 'no-severity'
        });
    });

    Mousetrap.bind("h a d o o p", function() {
        $("body").append($("<audio src='/static/dataiku/css/hadoop.mp3' autoplay/>"));
    });

    Mousetrap.bind("p i g", function() {
        $("body").append($("<audio src='/static/dataiku/css/pig.mp3' autoplay/>"));
    });

    Mousetrap.bind("h i v e", function() {
        $("body").append($("<audio src='/static/dataiku/css/hive.mp3' autoplay/>"));
    });

    Mousetrap.bind("p y t h o n", function() {
        $("body").append($("<audio src='/static/dataiku/css/python.mp3' autoplay/>"));
    });

    Mousetrap.bind("ctrl+e", function() {
        $rootScope.appConfig.easterEggs = true;
    });

    Mousetrap.bind("m i n i n g", function() {
        var elt = $("<div class='modal-container'><div id='minesweeper' class='modal modal3 dku-modal'><div class='modal-header'>"+
            "<h4><button type='button' class='close' data-dismiss='modal' aria-hidden='true'>&times;</button>"+
            "This is not data mining</h4></div><iframe  style='height: 500px;width: 98%' "+
            "src='http://www.chezpoor.com/minesweeper/minecore.html' /></div></div>");
        elt.modal("show");
    });

     Mousetrap.bind("k a t t a r s h i a n s", function() {
        var elt = $("<div class='modal-container'><div id='kattarshians' class='modal modal3 dku-modal relative-modal-90-90'>"+
            "  <iframe  style='width: 100%; height: 100%' "+
            "src='http://nutiminn.is/kattarshians/' /></div></div>");
        elt.modal("show");
    });

    Mousetrap.bind('up up down down left right left right b a enter', function() {
        CreateModalFromTemplate("/templates/infinity.html", $scope);
    });

    Mousetrap.bind("g e l l y", function(){
        window.setInterval(function(){
            d3.selectAll("g.node,g.edge").transition().duration(600).ease("elastic").attr("transform", function(d, i) {
                var x = 70 * Math.random() - 35;
                var y = 70 * Math.random() - 35;
                return "translate(" + x + " , " + y + ")";
            });
        }, 600)
    });

    Notification.registerEvent('discussions-wizz',function() {
        var elt = $('.discussions-widget-popover, .right-panel--opened .right-panel__content');
        elt.effect('shake');
    });

    Mousetrap.bind("w i z z", function() {
        Notification.broadcastToOtherSessions('discussions-wizz',{lol:"kikoo"});
    });

    Mousetrap.bind("l e a k s", function() {
        if ($state.current.name.startsWith('projects.project.wiki')) {
            $('.wiki-article-content.wiki-article-body-main').append($('<div style="position: absolute; top: 0; left: 0; right: 0; bottom: 0;"><div class="water"><div class="drop"></div><div class="drop"></div><div class="drop"></div><div class="drop"></div></div><svg version="1.1" xmlns="http://www.w3.org/2000/svg"><defs><filter id="goo"><feGaussianBlur in="SourceGraphic" result="blur" stdDeviation="12"/><feColorMatrix in="blur" mode="matrix" values="1 0 0 0 0 0 1 0 0 0 0 0 1 0 0 0 0 0 18 -7" result="goo"/></filter></defs></svg><style>.water{background:#083a44;width:200%;height:19%;position:absolute;bottom:-11%;left:-50%;-webkit-filter:url(#goo);filter:url(#goo)}.drop,.water::before{background:inherit;position:absolute;bottom:598%}.water::before{content:"";width:100%;height:100%}.drop{width:64px;height:64px;left:50%;border-radius:0 50% 50%;-webkit-transform:translateX(-50%) rotate(45deg);transform:translateX(-50%) rotate(45deg);-webkit-animation:drop 2s ease-in infinite;animation:drop 2s ease-in infinite}.drop:nth-child(1){width:64px;height:64px;-webkit-animation-delay:.1875s;animation-delay:.1875s}.drop:nth-child(2){width:51.2px;height:51.2px;-webkit-animation-delay:375ms;animation-delay:375ms}.drop:nth-child(3){width:38.4px;height:38.4px;-webkit-animation-delay:.5625s;animation-delay:.5625s}.drop:nth-child(4){width:25.6px;height:25.6px;-webkit-animation-delay:.75s;animation-delay:.75s}@-webkit-keyframes drop{0%{bottom:598%}100%,50%{bottom:0}}@keyframes drop{0%{bottom:598%}100%,50%{bottom:0}}</style></div>'));
        }
    });

    Mousetrap.bind("w h a t i f", function() {
        $(".master-nav__tile a div div").text("Hasta la vista, baby");
        setInterval(() => {
            $("body").effect('shake');
            $("a,span,p,button,option,h1,h2,h3,h4").not(":has(*:not(i)").each((i, x) => {
                if (/[a-zA-Z0-9]/.test($(x).text())) {
                    const newText = $(x).text().split('').sort(_ => 0.5 - Math.random()).join('');
                    $(x).text(newText);
                }
            })
        }, 5000);
    });

    $scope.win = function() {
         Notification.publishToFrontend("achievement-unlocked", {achievementId : 'LOL'});
    };

    /* ********************* Various notification stuff ******************* */

    Notification.registerEvent("login", function(evt, message) {
        if ($rootScope.appConfig && $rootScope.appConfig.login === message.user) {
            return; // Ignore event as it is about the current user
        }
        MessengerUtils.post({
          message: '<span>' + userLink(message.user, sanitize(message.userDisplayName)) + " just connected</span>",
          icon: userAvatar(message.user),
          hideAfter: 5,
          showCloseButton: true,
          id: message.user+'connected',
          type: 'no-severity'
        });
    });

    Notification.registerEvent("logout", function(evt, message) {
        if ($rootScope.appConfig && $rootScope.appConfig.login === message.user) {
            return; // Ignore event as it is about the current user
        }
        MessengerUtils.post({
          message: '<span>' + userLink(message.user, sanitize(message.userDisplayName)) + " just disconnected</span>",
          icon: userAvatar(message.user),
          hideAfter: 5,
          showCloseButton: true,
          id: message.user+'disconnected',
          type: 'no-severity'
        });
    });


    Notification.registerEvent("access-request", function(_, evt) {
        if ($rootScope.appConfig && ($rootScope.appConfig.login === evt.request.requesterLogin || !$rootScope.appConfig.userSettings.frontendNotifications.requestAccess)) {
            return; // Ignore event as it is about the current user or if option is disabled
        }

        let message = "<span>" + userLink(evt.request.requesterLogin, sanitize(evt.details.userDisplayName)) + " requested ";

        if (evt.objectType == "PROJECT") {
            message += " access to project " + projectLink(evt.projectKey, evt.details.objectDisplayName) + "</span>";
        } else if (evt.objectType == "APP") {
            message += " to execute application " + appLink(evt.objectId, evt.details.objectDisplayName) + "</span>";
        } else {
            message += " to share " + TaggableObjectsUtils.humanReadableObjectType(evt.objectType) + " "
                + dssObjectLink(evt.objectType, evt.projectKey, evt.objectId, evt.details.objectDisplayName);
        }

        if (evt.request.requestMessage && evt.request.requestMessage !== "") {
            message += '<span class="messenger-comment">' + sanitize(evt.request.requestMessage) + '</span>'
        }

        MessengerUtils.post({
          message: message,
          icon: userAvatar(evt.request.requesterLogin),
          hideAfter: 5,
          showCloseButton: true,
          id: evt.request.requestId + '-access-request',
          type: 'no-severity',
          actions: {
              gotoRequest: {
                  label: "See Request",
                  action: () => StateUtils.go.inboxRequest(evt.request.requestId)
              }
          }
        });
    });

    Notification.registerEvent("instance-access-request", function(_, evt) {
        if ($rootScope.appConfig && ($rootScope.appConfig.login === evt.requesterLogin || !$rootScope.appConfig.userSettings.frontendNotifications.requestAccess)) {
            return; // Ignore event as it is about the current user or if option is disabled
        }

        let message = "<span>" + userLink(evt.requesterLogin, sanitize(evt.details.authorDisplayName)) + " requested access to this " + $rootScope.wl.productLongName + " instance";

        if (evt.requestMessage && evt.requestMessage !== "") {
            message += '<span class="messenger-comment">' + evt.requestMessage + '</span>'
        }

        MessengerUtils.post({
          message: message,
          icon: userAvatar(evt.requesterLogin),
          hideAfter: 5,
          showCloseButton: true,
          id: evt.requestId + '-instance-access-request',
          type: 'no-severity',
          actions: {
              gotoRequest: {
                  label: "See Request",
                  action: () => StateUtils.go.inboxRequest(evt.requestId)
              }
          }
        });
    });

    Notification.registerEvent("profile-upgrade-request", function(_, evt) {
        if ($rootScope.appConfig && ($rootScope.appConfig.login === evt.requesterLogin || !$rootScope.appConfig.userSettings.frontendNotifications.requestAccess)) {
            return; // Ignore event as it is about the current user or if option is disabled
        }

        let message = "<span>" + userLink(evt.requesterLogin, sanitize(evt.details.authorDisplayName)) + " requested to upgrade their profile";

        if (evt.requestMessage && evt.requestMessage !== "") {
            message += '<span class="messenger-comment">' + evt.requestMessage + '</span>'
        }

        MessengerUtils.post({
          message: message,
          icon: userAvatar(evt.requesterLogin),
          hideAfter: 5,
          showCloseButton: true,
          id: evt.requestId + '-profile-upgrade-request',
          type: 'no-severity',
          actions: {
              gotoRequest: {
                  label: "See Request",
                  action: () => StateUtils.go.inboxRequest(evt.requestId)
              }
          }
        });
    });

    Notification.registerEvent("profile-upgrade-approved", function(_, evt) {
        if ($rootScope.appConfig && $rootScope.appConfig.login !== evt.requesterLogin) {
            return; // Ignore event as it is not about the current user
        }

        MessengerUtils.post({
          message: "<span>Your profile has been upgraded to a " + evt.selectedUserProfile +  " profile</span>",
          icon: userAvatar(evt.requesterLogin),
          hideAfter: 5,
          showCloseButton: true,
          id: evt.requesterLogin + '-profile-upgrade-approved',
          type: 'no-severity',
          actions: {}
        });
    });

    Notification.registerEvent("plugin-request", function(_, evt) {
        if ($rootScope.appConfig && ($rootScope.appConfig.login === evt.requesterLogin || !$rootScope.appConfig.userSettings.frontendNotifications.requestAccess)) {
            return; // Ignore event as it is about the current user or if option is disabled
        }

        let message = "<span>" + userLink(evt.requesterLogin, sanitize(evt.details.userDisplayName)) + " requested ";
        let actionType = evt.requestType === "INSTALL_PLUGIN" ? "installation" : "update";
        message += " " + actionType + " of the plugin " + pluginStoreLink(evt.objectId, evt.details.objectDisplayName) + "</span>";

        if (evt.requestMessage && evt.requestMessage !== "") {
            message += '<span class="messenger-comment">' + sanitize(evt.requestMessage) + '</span>'
        }

        MessengerUtils.post({
          message: message,
          icon: userAvatar(evt.requesterLogin),
          hideAfter: 5,
          showCloseButton: true,
          id: evt.requestId + '-plugin-request',
          type: 'no-severity',
          actions: {
              gotoRequest: {
                  label: "See Request",
                  action: () => StateUtils.go.inboxRequest(evt.requestId)
              }
          }
        });
    });

    Notification.registerEvent("code-env-request", function(_, evt) {
        Notification.publishToFrontend("update-pending-requests");
        if ($rootScope.appConfig && ($rootScope.appConfig.login === evt.requesterLogin || !$rootScope.appConfig.userSettings.frontendNotifications.requestAccess)) {
            return; // Ignore event as it is about the current user or if option is disabled
        }

        const user = userLink(evt.requesterLogin, sanitize(evt.details.userDisplayName));
        const action = (evt.requestType === "INSTALL_CODE_ENV") ? "installation" : "update";
        const commentHtml = (evt.requestMessage && evt.requestMessage !== "") ? '<span class="messenger-comment">' + sanitize(evt.requestMessage) + '</span>' : "";
        const message = `<span>${user} requested ${action} of the code env ` + sanitize(evt.objectId) + `</span>${commentHtml}`;

        MessengerUtils.post({
          message: message,
          icon: userAvatar(evt.requesterLogin),
          hideAfter: 5,
          showCloseButton: true,
          id: evt.requestId + '-code-env-request',
          type: 'no-severity',
          actions: {
              gotoRequest: {
                  label: "See Request",
                  action: () => StateUtils.go.inboxRequest(evt.requestId)
              }
          }
        });
    });

    Notification.registerEvent("access-granted", function(_, evt) {
        if ($rootScope.appConfig && ($rootScope.appConfig.login != evt.request.requesterLogin || !$rootScope.appConfig.userSettings.frontendNotifications.requestAccess)) {
            return; // Ignore event as it is not about the current user or if option is disabled
        }

        let message = "<span>" + "You have been granted";
        let objectLabel;

        if (evt.objectType == "PROJECT") {
            message += " access to a project: "
                + dssObjectLabel(evt.details.objectDisplayName)
                + "</span>";
            objectLabel = evt.objectType;
        } else if (evt.objectType == "APP") {
            message += " rights to execute an application: "
                + dssObjectLabel(evt.details.objectDisplayName)
                + "</span>";
            objectLabel = evt.objectType;
        } else {
            message += " access to a"
                + (evt.objectType == "MODEL_EVALUATION_STORE" ? "n " : " ")
                + TaggableObjectsUtils.humanReadableObjectType(evt.objectType)
                + ": "
                + dssObjectLink(evt.objectType, evt.projectKey, evt.objectId, evt.details.objectDisplayName)
                + "</span>";
            objectLabel = TaggableObjectsUtils.humanReadableObjectType(evt.objectType);
        }

        MessengerUtils.post({
          message: message,
          icon: userAvatar(evt.request.requesterLogin),
          hideAfter: 5,
          showCloseButton: true,
          id: evt.request.requesterLogin + '-access-granted',
          type: 'no-severity',
          actions: {
              gotoRequest: {
                  label: "Open " + objectLabel,
                  action: () => StateUtils.goWithOptions({reload: true}).dssObject(evt.objectType, evt.objectId, evt.projectKey)
              }
          }
        });
    });

    Notification.registerEvent("plugin-request-granted", function(_, evt) {
        if ($rootScope.appConfig && ($rootScope.appConfig.login !== evt.requesterLogin || !$rootScope.appConfig.userSettings.frontendNotifications.requestAccess)) {
            return; // Ignore event as it is not about the current user or if option is disabled
        }

        let requestAction = evt.requestType === "INSTALL_PLUGIN" ? "installed" : "updated"
        let message = "<span>" + "Your requested plugin " + pluginSummaryLink(evt.objectId, evt.details.objectDisplayName) + " has been " + requestAction + "</span>";
        if (evt.requestMessage && evt.requestMessage !== "") {
            message += '<span class="messenger-comment">' + sanitize(evt.requestMessage) + '</span>'
        }

        MessengerUtils.post({
          message: message,
          icon: userAvatar(evt.requesterLogin),
          hideAfter: 5,
          showCloseButton: true,
          id: evt.requesterLogin + '-plugin-request-granted',
          type: 'no-severity',
          actions: {}
        });
    });

    Notification.registerEvent("code-env-request-granted", function(_, evt) {
        Notification.publishToFrontend("update-pending-requests");
        if ($rootScope.appConfig && ($rootScope.appConfig.login !== evt.requesterLogin || !$rootScope.appConfig.userSettings.frontendNotifications.requestAccess)) {
            return; // Ignore event as it is not about the current user or if option is disabled
        }

        const codeEnvName = sanitize((evt.details && evt.details.objectDisplayName) || evt.objectId);
        const commentHtml = (evt.requestMessage && evt.requestMessage !== "") ? '<span class="messenger-comment">' + sanitize(evt.requestMessage) + '</span>' : "";
        const codeEnvLinkHtml = codeEnvLink(codeEnvName, evt.envLang, codeEnvName);
        let message = `<span>Your requested code env ${codeEnvLinkHtml} has been installed</span>${commentHtml}`;
        if(evt.targetName){
            message = `<span>Your code env request has been processed ${codeEnvLinkHtml}</span>${commentHtml}`;
        }

        MessengerUtils.post({
          message: message,
          icon: userAvatar(evt.requesterLogin),
          hideAfter: 5,
          showCloseButton: true,
          id: evt.requesterLogin + '-code-env-request-granted',
          type: 'no-severity',
          actions: {}
        });
    });

    Notification.registerEvent("job-state-change", function(evt, message) {
        if (!displayUserTaskNotification(message)) return;

        // for job state changes coming from scenarios, only notify if corresponding user setting is enabled
        if (message.triggeredFrom === "SCHEDULER" && !$rootScope.appConfig.userSettings.frontendNotifications.scenarioRun) return;

        // If we are on the recipe page and the result panel is open, the info is already displayed
        try {
            var resultPanel = angular.element(".recipe-editor-job-result, .recipe-settings-floating-result");
            if (resultPanel.length && resultPanel.scope().isJobRunning()) {
                if (resultPanel.scope().startedJob.jobId == message.jobId) {
                    return;
                }
            }
        } catch (e) {
            Logger.error("Failed to check if user is on running recipe page.", e);
        }


        var initiatedByCurrentUser = $rootScope.appConfig.login == message.initiator;

        function jobLink(innerHTML) {
            var link = StateUtils.href.job(message.projectKey, message.jobId);
            return '<a href="'+link+'" class="link-std">'+innerHTML+'</a>';
        }

        function goToLogs() {
            return StateUtils.go.job(message.projectKey, message.jobId);
        }

        function goToFirstOutput() {
            var output = message.outputs[0];
            if (!output) {
                return;
            }
            if (!output.type) {
                throw new Error("Job output type not specified: "+ angular.toJson(output));
            }
            return StateUtils.go.dssObject(output.type, output.targetDataset, output.targetDatasetProjectKey);
        }

        var gotoJob = (function(message){ return function() {
            StateUtils.go.job(message.projectKey, message.jobId);
        }})(message);

        var triggerLabel = '<i class="icon-play"/> ';
        if (message.triggeredFrom == 'SCHEDULER') {
            triggerLabel = '<i class="icon-calendar" title="Scheduled in a scenario"/> ';
        } else if (message.triggeredFrom == 'API') {
            triggerLabel = '<i class="icon-code" title="Triggered from API"/> ';
        }

        var userLabel = initiatedByCurrentUser ? '' :
            userLink(message.initiator,
                        userAvatar(message.initiator, 20)
                        + '<span class="messenger-initiator">'
                        + sanitize(message.initiatorDisplayName || message.initiator)
                        + '</span>'
                    ) + '<br />';
        var jobLabel = jobLink(sanitize(message.humanReadableJobDesc));

        if (message.state == "DONE") {
            var warnLevel = message.warningsCount ? 'warning' : 'success';
            window.showNativeNotification("Job completed", message.jobId, gotoJob, message.initiator);
            if (!message.warningsCount) {
                MessengerUtils.post({
                    message: '<div>' + userLabel + 'Job completed<br/>' + jobLabel + '</div>',
                    icon: triggerLabel,
                    type: warnLevel + ' current-user',
                    id: message.jobId,
                    hideAfter: 5,
                    actions: {
                        target: {
                            label: "View",
                            action: goToFirstOutput
                        },
                        logs: {
                            label: "Logs",
                            action: goToLogs
                        }
                    }
                });
            }
        } else if (message.state == "PENDING") {
             MessengerUtils.post({
                 message: '<div>' + userLabel + 'Job pending<br/>' + jobLabel + '</div>',
                 icon: triggerLabel,
                 type: 'current-user',
                 hideAfter: 5,
                 id: message.jobId,
                 showCloseButton: true,
                 actions: {}
             });
        }  else if (message.state == "STARTING") {
            MessengerUtils.post({
                message: '<div>' + userLabel + 'Job starting<br/>' + jobLabel + '</div>',
                icon: triggerLabel,
                type: 'current-user',
                hideAfter: 5,
                id: message.jobId,
                showCloseButton: true,
                actions: {
                    logs: {
                        label: "Logs",
                        action: goToLogs
                    }
                }
            });
        } else if(message.state == "FAILED" || message.state == "ABORTED") {
            window.showNativeNotification("Job " + message.state.toLowerCase(), message.jobId, gotoJob, message.initiator);
            MessengerUtils.post({
                message: '<div>' + userLabel + 'Job ' + message.state.toLowerCase() + '<br/>' + jobLabel + '</div>',
                icon: triggerLabel,
                type: 'error current-user',
                showCloseButton: true,
                id: message.jobId,
                hideAfter: 5,
                actions: {
                    logs: {
                        label: "Logs",
                        action: goToLogs
                    }
                }
            });
        }
    });


    function mlTaskLink(mlTaskType, projectKey, analysisId, mlTaskId, innerHTML) {
        var href = StateUtils.href.mlTask(analysisId, projectKey, mlTaskType, mlTaskId);
        return '<a href="'+href+'" class="link-std">'+innerHTML+'</a>';
    }

    function displayUserTaskNotification(evt) {
        // For scenario-state-change, we can have multiple initiator
        // others event still use .initiator
        const initiatedByCurrentUser = evt.initiator === $rootScope.appConfig.login || (evt.initiators ? evt.initiators.includes($rootScope.appConfig.login) : false);
        var otherUsersTasks = $rootScope.appConfig.userSettings.frontendNotifications.otherUsersTasks;
        return initiatedByCurrentUser || otherUsersTasks;
    }

    Notification.registerEvent("mltask-state-change", function(evt, message) {
        if (!displayUserTaskNotification(message)) return;

        // If we are on the mltask page, the info is already displayed
        try {
            var x = 'projects.project.analyses.analysis.ml.';
            if (
                ($state.current.name.startsWith(x+'predmltask.list.results') || $state.current.name.startsWith(x+'clustmltask.list.results'))
                && message.projectKey == $stateParams.projectKey
                && message.taskId == $stateParams.mlTaskId
                ) {
                return;
            }
        } catch (e) {
            Logger.error("Failed to check if user is on running mlTask page.", e);
        }

        MessengerUtils.post({
            message: mlTaskLink(message.taskType, message.projectKey, message.analysisId, message.taskId, sanitize(message.name + ": training done")),
            icon: '<i class="icon-dku-nav_analysis" />',
            type: 'success',
            showCloseButton: true
        });
    });

    Notification.registerEvent("workspace-invitation-sent", (_, message) => handleInvitationSentEvent(message));

    Notification.registerEvent("project-invitation-sent", (_, message) => handleInvitationSentEvent(message));

    const handleInvitationSentEvent = (message) => {
        if ($rootScope.appConfig && $rootScope.appConfig.login !== message.user) {
            return; // Ignore event as it is not triggered by the current user
        }
        if (message && message.result && message && message.result.infoMessages) {
            message.result.infoMessages.messages.forEach((message) => {
                MessengerUtils.post({
                    message: '<b> ' + message.title + '</b><div>' + message.details + '</div>',
                    type: 'error',
                    icon: '<i class="dku-icon-mail-24"/>',
                    hideAfter: 5,
                    showCloseButton: true
                });
            });
        }
        if (message && message.result && message && message.result.sentEmails) {
            message.result.sentEmails.forEach((email) => {
                MessengerUtils.post({
                    message: `Invitation email sent to ${email}`,
                    type: 'success',
                    icon: '<i class="dku-icon-mail-24"/>',
                    hideAfter: 5,
                    showCloseButton: true
                });
            });
        }
    }

    Notification.registerEvent("timeline-item", function(evt, message) {
        if (message.item.action == "COMMENT") {
            MessengerUtils.post({
                message: userLink(message.item.user, sanitize(message.item.details.userDisplayName))
                    + " commented on "
                    + dssObjectLink(message.item.objectType, message.item.projectKey, message.item.objectId, sanitize(message.item.details.objectDisplayName))
                    + ":"
                    + '<span class="messenger-comment">'
                    + sanitize(message.item.details.text.substr(0,400))
                    + (message.item.details.text.length > 400 ? '[...]' : '')
                    + '</span>'
                    ,
                icon: userAvatar(message.item.user),
                type: 'no-severity',
                hideAfter: 5,
                showCloseButton: true
            });
        } else if (message.item.action == "EDIT_COLLABORATIVE_METADATA") {
            Assert.trueish(message.item.details.doneTasks != null, 'no done tasks');
            var tasks = "";
            for (var i = 0; i < message.item.details.doneTasks.length; ++i) {
                tasks += '<i class="icon-ok" /> ' + sanitize(message.item.details.doneTasks[i]);
            }

            MessengerUtils.post({
                message: userLink(message.item.user, sanitize(message.item.details.userDisplayName))
                    + " completed a task on "
                    + dssObjectLink(message.item.objectType, message.item.projectKey, message.item.objectId, sanitize(message.item.details.objectDisplayName))
                    + ":"
                    + '<span class="messenger-comment">'
                    + tasks
                    + '</span>'
                    ,
                icon: userAvatar(message.item.user),
                type: 'no-severity',
                hideAfter: 5,
                showCloseButton: true
            });
        }
    });

    Notification.registerEvent("commit-mention", function(evt, message) {
        MessengerUtils.post({
            message: userLink(message.author, sanitize(message.details.authorDisplayName || message.author))
                + " mentioned you in commit: "
                + '<span class="messenger-comment">'
                + sanitize(message.message.substr(0,400))
                + (message.message.length > 400 ? '[...]' : '')
                + '</span>'
                ,
            icon: userAvatar(message.author),
            type: 'no-severity',
            showCloseButton: true
        });
    });

    Notification.registerEvent("interest-added", function(evt, message) {
        MessengerUtils.post({
            message: '<i class="icon-star interests-star active"></i>'
                + userLink(message.user, sanitize(message.details.userDisplayName))
                + ' starred '
                + dssObjectLink(message.objectType, message.projectKey, message.objectId, sanitize(message.details.objectDisplayName)),
            icon: userAvatar(message.user),
            id: message.user+'starred'+message.details.objectDisplayName,
            type: 'no-severity',
            showCloseButton: true
        });
    });

    Notification.registerEvent("scenario-run-failed-check-logs", function(evt, message) {
        if (!displayUserTaskNotification(message) || !$rootScope.appConfig.userSettings.frontendNotifications.scenarioRun) return;
        MessengerUtils.post({
          message: "Failed to run scenario " + message.projectKey+"."+message.scenarioId + ": " + message.message + ".\nPlease check logs",
          icon: '<i class="icon-calendar"/>',
          type: "error",
          id: "ScenarioState"+ message.scenarioId,
          showCloseButton: true
        });
    });

    Notification.registerEvent("scenario-state-change", function(evt, message) {
        if (!$rootScope.appConfig.userSettings.frontendNotifications.scenarioRun) return;
        function goToLogs() {
            return StateUtils.go.scenario(message.scenarioId, message.projectKey);
        }
        if (!displayUserTaskNotification(message)) return;
        var msg = {
                DONE: 'finished',
                DONE_WITH_WARNING: 'finished',
                RUNNING: 'started',
                FAILED: 'failed',
                ABORTED: 'aborted'
            };
        var isSuccess = ['DONE'].indexOf(message.state) >= 0;
        var isWarning = ['DONE_WITH_WARNING'].indexOf(message.state) >= 0;
        var isError = ['FAILED', 'ABORTED'].indexOf(message.state) >= 0;
        var triggerLabel = '<i class="icon-calendar" /> ';
        var actions = {};
        if (isSuccess || isWarning || isError) {
            actions.logs = {label: "Logs",action: goToLogs};
        }
        MessengerUtils.post({
          message: "Scenario " + msg[message.state] + "<br/>" + dssObjectLink('SCENARIO', message.projectKey, message.scenarioId, message.scenarioName),
          icon: triggerLabel,
          id: "ScenarioState"+ message.scenarioId,
          type: isSuccess ? 'success' : (isError ? 'error' : (isWarning ? 'warning' : '')),
          showCloseButton: true,
          actions : actions
        });
    });

    $scope.showAbout = function() {
        $scope.closeContextualMenus();
        CreateModalFromTemplate("/templates/about-dss.html", $scope, null, function(modalScope){
            modalScope.currentYear = new Date().getFullYear();
        });
    };

    $scope.showAboutPartitioning = function() {
        $scope.closeContextualMenus();
         CreateModalFromTemplate("/templates/about-partitioning.html", $scope);
    };

    $rootScope.showFeedbackModal = function() {
        $scope.closeContextualMenus();
        CreateModalFromTemplate("/templates/widgets/topbar_drawers/feedback-modal.html", $scope, 'FeedbackController');
    };

    $scope.HOME_STATE_HOMEPAGE = $rootScope.featureFlagEnabled('homepageRedesign') ? 'homeV2.homepage' : 'home';
    $scope.PREVIOUS_HOME_STATE = $scope.HOME_STATE_HOMEPAGE;
    $scope.PREVIOUS_HOME_STATE_PARAMS = undefined;

    $scope.redirectHome = () => {
        $state.go($scope.HOME_STATE_HOMEPAGE, {}, { reload: true });
    };

    $scope.isOnProjectHome = () => $state.includes('projects.project.home.summary');

    $scope.isOnHome = () => {
        const currentState = $state.current.name;
        return currentState.startsWith('homeV2') || currentState === 'home';
    }

    $scope.homeButtonTooltip = () => {
        if($scope.isOnHome()) return '';
        return 'Home';
    }

    $scope.freshWidgetInitDone = false;

    $rootScope.showHelp = function(opalsPage) {
        OpalsService.isEnabled().then(function(isOpalsEnabled) {
            if (isOpalsEnabled) {
                if (opalsPage === null) {
                    TopbarDrawersService.getDrawer(TOPBAR_DRAWER_IDS.OPALS_HELP).show();
                } else {
                    OpalsService.navigateToAndShowDrawer(opalsPage ? opalsPage : OpalsService.PAGES.HELP);
                }
                return;
            }
            function showSupportWidget() {
                if (window.dkuAppConfig && window.dkuAppConfig.offlineFrontend){
                    ActivityIndicator.error("Offline mode - Support widget not available");
                    return;
                }
                if (!$scope.freshWidgetInitDone) {
                    const version = $rootScope.dssMinorVersion;
                    const instanceId = $rootScope.appConfig.dipInstanceId;
                    if (!window.devInstance) {
                        window.FreshWidget.init("", {
                            "queryString": "&widgetType=popup&helpdesk_ticket[custom_field][dss_version_112979]=" + version
                                + "&helpdesk_ticket[custom_field][dss_instance_112979]=" + instanceId,
                            "widgetType": "popup", "buttonType": "text", "buttonText": "Support",
                            "buttonColor": "white", "buttonBg": "#006063", "alignment": "4",
                            "submitThanks" : "Thanks for your message. We'll get in touch very soon",
                            "offset": "-1500px", "formHeight": "500px",
                            "url": "https://dataiku.freshdesk.com",
                            "loadOnEvent" : "immediate"
                        } );
                    } else {
                        ActivityIndicator.error("Support widget not available on a dev instance");
                        return;
                    }
                    $scope.freshWidgetInitDone = true;
                }
                window.FreshWidget.show();
            }
            let wt1EventParams;
            if ($rootScope.wl) {
                wt1EventParams = {
                    wlReferenceDocRootUrlSet: !!$rootScope.wl.referenceDocRootUrl,
                    wlApiDocRootUrlSet: !!$rootScope.wl.apiDocRootUrl,
                    wlAcademyRootUrlSet: !!$rootScope.wl.academyRootUrl,
                    wlLearnRootUrlSet: !!$rootScope.wl.learnRootUrl,
                    wlGetHelpModalTitleSet: !!$rootScope.wl.getHelpModalTitle,
                    wlGetHelpModalTextSet: !!$rootScope.wl.getHelpModalText,
                };
            } else {
                wt1EventParams = {};
            }
            if ($rootScope.appConfig) {
                wt1EventParams.admin = !!$rootScope.appConfig.admin;
                wt1EventParams.studioAdminContactSet = !!$rootScope.appConfig.studioAdminContact;
                wt1EventParams.communityEdition = !!$rootScope.appConfig.communityEdition;
            }
            wt1EventParams.intercomEnabled = !!$rootScope.intercomEnabled;
            WT1.event("help-open-get-help", wt1EventParams);
            CreateModalFromTemplate("/templates/widgets/topbar_drawers/get-help-modal.html", $scope, null, function(newScope) {
                newScope.openSupport = function() {
                    newScope.dismiss();
                    showSupportWidget();
                };
                newScope.openIntercom = function() {
                    newScope.dismiss();
                    $scope.forceShowIntercom();
                };
                OpalsService.getHelpCenterUrl().then(function(url) {
                    newScope.helpCenterUrl = url;
                });
            });
        });
    };

    const getZoomedZoneCtxKey = () => {
        return `dku.flow.zoneId.${$stateParams.projectKey}`;
    }

    $scope.getDestZone = function() {
        if ($stateParams.zoneId || $state.current.name.includes('projects.project.home.summary')) {
            localStorageService.remove(getZoomedZoneCtxKey());
            return null;
        }
        return localStorageService.get(getZoomedZoneCtxKey());
    }

    $scope.$on("$stateChangeSuccess", function(_event, to, toParams, from, fromParams) {
        if (to.pageTitle) {
            TopNav.setPageTitle(to.pageTitle(toParams));
        }
        if (to.name.includes('projects.project.flow')) {
            localStorageService.set(getZoomedZoneCtxKey(), toParams.zoneId);
        }
        if ($rootScope.featureFlagEnabled('homepageRedesign') && (from.name.includes('homeV2') || from.name === 'home')) {
            $scope.PREVIOUS_HOME_STATE = from.name;
            $scope.PREVIOUS_HOME_STATE_PARAMS = fromParams;
        }
    });


    /* ******************* Persistent notifications handling ****************** */

    $scope.pnotifications = {};

    $scope.countNotifications = function() {
        DataikuAPI.notifications.count().success(function(data) {
            $scope.pnotifications.totalUnread = data.totalUnread;
            $rootScope.totalUnreadNotifications = data.totalUnread;
            TopNav.refreshPageTitle();
        });
    };

    Notification.registerEvent("update-notifications-count", function(evt, message) {
        // Manytimes the sent event contains the totalUnread value, no need to fetch it again
        if (message.totalUnread == -1) {
            $scope.countNotifications();
        } else {
            $scope.pnotifications.totalUnread = message.totalUnread;
            $rootScope.totalUnreadNotifications = message.totalUnread;
            TopNav.refreshPageTitle();
        }
    });

    $rootScope.discussionsUnreadStatus = $rootScope.discussionsUnreadStatus || {};
    Notification.registerEvent("discussions-unread-full-ids-changed", function(evt, message) {
        let newFIDs = angular.copy(message.unreadFullIds || []);
        $rootScope.discussionsUnreadStatus.unreadFullIds = newFIDs;
    });

    function updateRequestCount() {
        RequestCenterService.getAllRequests().then(result => {
            $scope.pendingAccessRequests = RequestCenterService.numberOfPendingRequests(result);
            $scope.hasAccessRequests = RequestCenterService.hasRequests(result);
        })
    }

    $scope.pendingAccessRequests = 0;
    Notification.registerEvent("update-pending-requests", function() {
       updateRequestCount();
    });

    $scope.hasUnreadThings = function() {
        return $scope.pnotifications.totalUnread || ($rootScope.discussionsUnreadStatus.unreadFullIds || []).length;
    };


    /* ******************* Exports handling ****************** */

    Notification.registerEvent("export-state-change", function(evt, message) {
        if (!displayUserTaskNotification(message)) {
            return;
        }
        var txt = null;
        var type = null;
        if (message.status.state == 'DONE') {
            var lowerDescription = message.status.inputDescription.description ? message.status.inputDescription.description.toLowerCase() : '';
            const datasetName = sanitize(message.status.inputDescription.name);
            const datasetProjectKey = sanitize(message.status.inputDescription.projectKey);
            if (lowerDescription.startsWith("dataset")) {
                txt = 'Export done: dataset <a href="/projects/'+datasetProjectKey+'/datasets/'+datasetName+'/explore/" class="link-std">'+ datasetName + '</a>';
            } else if (lowerDescription.startsWith("apply shaker")) {
                txt = 'Export done: apply shaker on <a href="/projects/'+datasetProjectKey+'/datasets/'+datasetName+'/explore/" class="link-std">'+ datasetName + '</a>';
            } else {
                txt = sanitize("Export done: "+ message.status.inputDescription.name);
            }
            type = 'success';
        } else if (message.status.state == 'FAILED'){
            txt = sanitize("Export failed : "+ message.status.inputDescription.name);
            type = 'error';
        }
        if (txt) {
            MessengerUtils.post({
                 message: txt,
                 icon: '<i class="icon-download-alt"></i>',
                 type: type,
                 hideAfter: 5,
                 showCloseButton: true
             });
        }
    });

    /* ********* Global actions we want in every scope ********************* */

    /* Open the modal for exporting a dataset */
    $scope.exportDataset = function(projectKey, datasetName, overrideFeatures) {
        ExportUtils.exportDataset($scope, projectKey, datasetName, $stateParams.projectKey, overrideFeatures);
    };

    $scope.datasetSmartHRef = function(smartName, subState) {
        if (!smartName) return;
        if(!subState) {
            subState = 'explore';
        }
        if (smartName.indexOf(".") > 0) {
            var chunks = smartName.split(".");
            return $state.href("projects.project.datasets.dataset."+subState, {projectKey :chunks[0], datasetName : chunks[1]})
        } else {
            return $state.href("projects.project.datasets.dataset."+subState, {projectKey :$stateParams.projectKey, datasetName :smartName})
        }
    };

    /* Shortcut : put the service in the scope so we can use it directly in templates */
    $scope.WT1Event = function(type, params) {
        WT1.event(type, params);
    };

    $scope.setSpinnerPosition = function(position){
        $rootScope.spinnerPosition = position;
    };

    $scope.setTheme = function(theme) {
        if (theme) {
            var uri = $scope.getThemeUri(theme);
            var cssUri = uri + "theme.css";
            $("#theme-stylesheet").remove();
            $("head").append('<link id="theme-stylesheet" rel="stylesheet" type="text/css" href="'+cssUri+'">');
            if (!theme.isUnitedColorBg) {
                let imgUri;
                if (theme.background.startsWith("http") || theme.background.startsWith("/")) {
                    imgUri = theme.background;
                } else {
                    imgUri = uri + theme.background;
                }
                $("#root-dom-element").css("background-image","url("+imgUri+")");
            } else {
                $("#root-dom-element").css("background-image","none");
            }
        } else {
            $("#theme-stylesheet").remove();
            $("#root-dom-element").css("background-image","none");
        }
        /* Update or revert favicon */
        var faviconLink = $("head").find("link[rel='shortcut icon']");
        if (theme && theme.favicon) {
            var faviconUri = uri + theme.favicon + '?t=' + new Date().getTime();
            faviconLink.attr("href", faviconUri);
        } else {
            faviconLink.attr("href", "/favicon.ico?v=3");
        }
    };

    $scope.getThemeUri = function(theme) {
        var uri;
        switch (theme.origin) {
            case "BUILTIN":
                uri = "/themes/builtin/" + theme.id + "/";
                break;
            case "PLUGIN":
                uri = "/plugins/" + theme.pluginId + "/resource/themes/" + theme.id + "/";
                break;
            case "USER":
                uri = "/themes/user/"  + theme.id + "/";
                break;
        }
        return uri;
    };

    // refactor status color handling out into a service for easier usage in separated scopes
    $scope.getProjectStatusColor = function(status) {
        return ProjectStatusService.getProjectStatusColor(status);
    };


        $scope.codeMirrorSettingService = CodeMirrorSettingService;

    /* ******************* Top nav override ****************** */
    $scope.onEnterSecondNav = function(type){
        TopNav.setOverrideLeftType(type);
    };

    $scope.onLeaveSecondNav = function(){
        TopNav.setOverrideLeftType(null);
    };

    Logger.info("DSS loaded");

    $scope.closeNavMenu = function (triggerId) {
        let trigger = document.querySelector('#' + triggerId);
        trigger.classList.add('js-blurred');
        let blurListener = trigger.addEventListener('mouseout', function() {
            trigger.classList.remove('js-blurred');
            trigger.removeEventListener('mouseout', blurListener);
        })
    };

    /* ******************* Global Finder ****************** */
    Mousetrap(document.body).bind("mod+shift+f", e => {
        const inCodeMirror = $(e.target).closest('.CodeMirror').length > 0;
        if (inCodeMirror === false || $scope.isMacOS) {
            e.preventDefault();
            $scope.openGlobalFinder();
        }
    });

    $scope.isMacOS = DetectUtils.getOS() === "macos"; //also used in shortcuts.html
    $scope.modKey = $scope.isMacOS ? "⌘" : "Ctrl"; //also used in shortcuts.html
    $scope.altKey = $scope.isMacOS ? "⌥" : "Alt"; //also used in shortcuts.html
    $scope.globalFinderShortcut = $scope.isMacOS ? `${$scope.modKey}⇧F` : `${$scope.modKey}+Shift+F`;
    $scope.globalFinderLocalStorageKey = "global-search__last-searches";
    $scope.globalFinderTabStorageKey = "global-search__last-tabId";


    $scope.initQuery = (filter = '') => {
        $scope.globalfinder = Object.assign({}, $scope.globalfinder, { q: filter, results: [], hits: [], searchResultsAnswers: {hits: []}, searchResultsDoc: {hits: []}, searchResultsLearn: {hits: []} });
        $scope.initLastSearches();
    };

    $scope.initLastSearches = () => {
        let searches = localStorageService.get($scope.globalFinderLocalStorageKey);
        if (searches === null || Array.isArray(searches) === false) {
            searches = [];
        }
        let data = searches.map((q, index) => ({$idx: index, _type: 'search', _category: 'recent', _source: {name: q.query, query: q.query, time: q.time, tabId: q.tabId }, icon: 'global-finder-modal__search-type-icon--smaller--nomargin icon-time'}));
        $scope.initial.index = 1;
        data.unshift({_type: 'search-separator', selectable: false, _source: {name: translate('GLOBAL_SEARCH.RECENT_SEARCHES', 'Recent searches'), query: '' }});
        $scope.globalfinder.results = data;
        $scope.globalfinder.allData = [...data];
    };

    $scope.globalFinderModal = null;

    $scope.openGlobalFinder = (filter = '') => {
        if ($scope.globalFinderModal !== null) { // Forbid two modal at the same time
            return;
        }
        if (!$rootScope.appConfig.userProfile || $rootScope.appConfig.userProfile.profile === "NONE") {
            return;
        }
        const filterPattern = '(\\w+:(".+"|[^ ]+))';
        $scope.initial = { index: 0 };
        $scope.initQuery(filter);

        $scope.globalFinderModal = CreateModalFromTemplate("/templates/global-finder-modal.html", $scope, null, newScope => {

            const projectNames = {};
            DataikuAPI.projects.list(true)
                .success(function (response) {
                    angular.forEach(response, function (project) {
                        projectNames[project.projectKey] = project.name;
                    })
                })
                .error(setErrorInScope.bind($scope));

            const users = {};
            DataikuAPI.security.listUsers()
                .success(function (response) {
                    angular.forEach(response, function (user) {
                        users[user.login] = user.displayName;
                    })
                })
                .error(setErrorInScope.bind($scope));

            newScope.inProject = !!newScope.$stateParams.projectKey;

            newScope.getHelp = function () {
                newScope.dismiss();
                $scope.showHelp();
            };

            newScope.helpIntegrationEnabled = () => newScope.wl.contextualHelpSearchEnabled && newScope.appConfig.helpIntegrationEnabled;

            newScope.updateLastSearches = (newSearch) => {
                if (newSearch === '') {
                    return;
                }

                let searches = localStorageService.get($scope.globalFinderLocalStorageKey);
                if (searches === null || Array.isArray(searches) === false) {
                    searches = [];
                }
                let index = searches.map(s => s.query.toLowerCase()).indexOf(newSearch.toLowerCase());
                if (index !== -1) {
                    searches.splice(index, 1);
                }
                let savedSearch = {
                    query: newSearch,
                    time: Date.now()
                };
                searches.unshift(savedSearch);

                if (searches.length > 5) {
                    searches.splice(5);
                }
                localStorageService.set($scope.globalFinderLocalStorageKey, searches)
            };

            newScope.onSmartInputChange = () => {
                newScope.initial.index = 0;
                newScope.triggerSearch();
            };

            newScope.triggerSearch = function (shouldHandleLoading = true) {
                if (shouldHandleLoading) {
                    newScope.globalfinder.searching = true;
                    newScope.globalfinder.results = [];
                    newScope.globalfinder.allData = [];
                }
                newScope.globalfinder.trimmedQuery = newScope.trimQuery(newScope.globalfinder.q);
                if (newScope.globalfinder.trimmedQuery === '') {
                    newScope.globalfinder.searching = false;
                }
                newScope.debouncedTriggerSearch();
            };

            newScope.debouncedTriggerSearch = Debounce().withDelay(200, 200).wrap(function () {
                let query = newScope.globalfinder.q;
                if (query === "") {
                    $scope.initQuery('');
                    return;
                }

                if (newScope.helpIntegrationEnabled()) {
                    newScope.globalfinder.search(query);
                }

                DataikuAPI.globalfinder.search(query, 15, newScope.$stateParams.projectKey)
                    .success(data => {
                        newScope.globalfinder.hits = data.hits.map(hit => Object.assign({url: newScope.getLink(hit)}, hit));
                        newScope.globalfinder.aggregations = data.aggregations;
                        newScope.buildResult();
                    })
                    .error(() => {
                        newScope.globalfinder.hits = [];
                        newScope.buildResult();
                    });

                newScope.focusSearchInput();
            });

            newScope.trimQuery = query => {
                return query.replace(new RegExp(filterPattern, 'g'), '').trim().replace(/\s{2,}/g, ' ').trim();
            };

            newScope.emptySearch = () => {
                newScope.globalfinder.q = "";
                newScope.triggerSearch();
                newScope.focusSearchInput();
            };

            newScope.focusSearchInput = () => {
                const searchInputs = document.getElementsByClassName("global-finder-modal__search-input");
                if (searchInputs && searchInputs.length > 0) {
                    searchInputs[0].focus();
                }
            };

            newScope.hasFilter = filter => newScope.globalfinder.q.includes(filter);

            newScope.formatItemName = item => {
                if (!item) {
                    return '';
                }
                if (item._type === 'discussion') {
                    return item._source.discussions && item._source.discussions.length && item._source.discussions[0].topic ? item._source.discussions[0].topic : "Unnamed discussion";
                }
                if (item._type === 'chart') {
                    return item._source.name || "Untitled chart"; // TODO : change done near release. We should factorize the untitled behavior to all types
                }
                return item._source.name;
            };

            newScope.formatItemPath = item => {
                if (!item) {
                    return '';
                }
                if (newScope.isNavigation(item)) {
                    return item._source.path.replace(new RegExp(" > " + item._source.name + "$","g"), "");
                }
                if (item._type === 'discussion') {
                    return item._source.projectName + " > " + item._source.objectName;
                }
                if (item._type === 'project') {
                    return item._source.shortDesc;
                }
                return item._source.projectName;
            };

            newScope.formatItemHelpType = item => {
                if (item && item._type) {
                    return $filter('capitalize')(item._type.replace(/_/g, " "));
                }
                return "Help";
            };


            newScope.chunkSize = () => 3;
            if (newScope.globalfinder === undefined){
                newScope.globalfinder = {};
            }
            newScope.globalfinder.searchResults = {hits: []};

            newScope.globalfinder.search = (query = newScope.globalfinder.q) => {
                const trimmedQuery = newScope.trimQuery(query);
                // Google search does not accept empty query
                if (!trimmedQuery) {
                    return;
                }
                return DataikuAPI.help.search({query: trimmedQuery,pageSize: 3})
                    .success(newScope.onResult("searchResults"))
                    .error(onError(newScope.globalfinder, "searchResults", {hits: []}));
            }

            const onError = (globalfinder, fieldName, defaultValue = []) => () => {
                globalfinder[fieldName] = defaultValue;
                newScope.buildResult();
            };

            newScope.onResult = fieldName => content => {
                newScope.globalfinder[fieldName] = Object.assign({hits: (content.results ? content.results : []).map(result => Object.assign({title:result.document.derivedStructData.title, url: result.document.derivedStructData.link, isHelp: true, isExternalUrl: true, _type: newScope.getItemType(result), _id:result.id}))});
                newScope.buildResult();
            };

            newScope.getItemType = result => {
                                const type = result && result.document && result.document.derivedStructData && result.document.derivedStructData.pagemap && result.document.derivedStructData.pagemap.metatags ? result.document.derivedStructData.pagemap.metatags.map(metatag => metatag["og:site_name"]).find(site => site) : undefined;
                if (type === undefined && result.document.derivedStructData.displayLink) {
                    return  result.document.derivedStructData.displayLink.match("^[^.]*")[0];
                }
                return type;
            };

            const nameMatch = (hit, query) => {
                if (!hit) {
                    return false;
                }
                if (hit._source.name) {
                    return hit._source.name.toLowerCase() === query.toLowerCase();
                }
                else if (hit._source.objectName) {
                    return hit._source.objectName.toLowerCase() === query.toLowerCase();
                }
                return false;
            };

            newScope.mergeResult = () => {
                const helpData = newScope.helpIntegrationEnabled() ? newScope.globalfinder.searchResults.hits : [];
                const initialData = {_type: 'search', _source: { name: `Search ${newScope.globalfinder.q}`, query:newScope.globalfinder.q }, icon: "global-finder-modal__search-type-icon icon-dku-search"};
                const hits = newScope.globalfinder.hits.map(hit => {
                    if($rootScope.appConfig.governURL) {
                        hit.isExternalUrl = hit.url.includes(':governURL:');
                        if (hit.isExternalUrl) {
                            hit.url = hit.url.replace(':governURL:', $rootScope.appConfig.governURL);
                        }
                    }
                    if (hit.url && newScope.$stateParams.projectKey) {
                        hit.url = hit.url.replace(':projectKey:', newScope.$stateParams.projectKey);
                    }
                    return hit;
                });

                const firstResults = hits.length > 0 && nameMatch(hits[0], newScope.globalfinder.trimmedQuery)
                    ? [hits[0], initialData]
                    : [initialData, hits[0]];

                newScope.globalfinder.results = firstResults.concat(hits.slice(1)).concat(helpData).filter(el => el);
                newScope.globalfinder.results.forEach((val, index) => val.$idx = index);
                newScope.globalfinder.allData = [...newScope.globalfinder.results];
                newScope.globalfinder.searching = false;
            };

            newScope.buildResult = Debounce().withDelay(100, 100).wrap(newScope.mergeResult);

            newScope.clickItem = item => {
                if (item === null || item === undefined) {
                    return;
                }
                WT1.event("global-finder-item-open", {
                    type: item._type,
                    id: item._id || item.objectID,
                    currentTab: '', filters: [] // used to contain more specific info when we had the advanced modal. kept for consistency of the WT1 data even if not really useful anymore.
                });
                if (item._type === 'search') {
                    newScope.updateLastSearches(newScope.globalfinder.q);
                    $state.go('catalog.items', {hash: CatalogUtils.getHash(item._source.query, {})});
                    return;
                }
                if (newScope.simulateClick(item)) {
                    newScope.focusSearchInput(); // reset activeElement after a click
                }
            };

            newScope.openItem = item => {
                if (item && item.url) {
                    const aElem = document.querySelector(`.global-finder-modal__line a[href="${item.url}"]`);
                    if (aElem) {
                        $timeout(() => {
                            aElem.focus();
                            aElem.click();
                        });
                    }
                } else {
                    newScope.clickItem(item);
                }
            };

            newScope.simulateClick = item => {
                const itemURL = new URL(item.isExternalUrl ? item.url : `${window.location.protocol}//${window.location.host}${item.url}`);
                // The redirect behavior is different if the user is already on the desired page
                if (window.location.pathname === itemURL.pathname) {
                    newScope.dismiss();
                    if (itemURL.hash) {
                        window.location.hash = itemURL.hash;
                        document.getElementById(itemURL.hash.substr(1)).scrollIntoView();
                    }
                    return false;
                }
                return true;
            };

            newScope.selectItem = item => {
                if (item.selectable === false || item.$idx === newScope.selected.index) {
                    return;
                }
                newScope.selectIndex(item.$idx);
            };
        });

        $scope.globalFinderModal.catch(() => {
            $scope.globalFinderModal = null
        });
    };

    $scope.isItemSelectable = item => item.selectable === undefined || item.selectable === true;
    $scope.isNavigation = item => item && item._type === 'page';

    $scope.itemToIcon = (item, inList, size) => {
        if (!item) {
            return;
        }
        if (item.isHelp) {
            return 'icon-dku-help';
        }
        if (item._type === 'page') {
            return 'icon-list'
        }
        return CatalogItemService.itemToIcon(item._type, item._source, inList, size);
    };

    $scope.itemToColor = item => {
        if (!item) {
            return;
        }
        if (item._type === 'page') {
            return 'navigation';
        }
        if (item.isHelp) {
            return 'home';
        }
        return CatalogItemService.itemToColor(item._type, item._source);
    };

    $scope.disableItemIcon = item => {
        if (item && item._source && item._source.closed) {
            return 'global-finder-modal__search-type-icon--disabled';
        }
    };

    $scope.getLink = (item, discussionId) => {
        if (!item || item.isHelp) {
            return;
        }
        if (item._type === 'page') {
            return item._source.url;
        }
        return CatalogItemService.getLink(item._type, item._source, discussionId);
    };
});


app.controller('RequestEETrialController', function ($scope, $state, Assert, DataikuAPI, DataikuCloudAPI, $rootScope) {
    Assert.inScope($scope, 'appConfig');
    Assert.trueish($scope.appConfig.licensing.community, 'not a free edition');
    $scope.request = {
        state : "initial"
    };

    $scope.request.updatedEmailAddress = $scope.appConfig.licensing.ceRegistrationEmail;

    $scope.sendRequest = function() {
        DataikuCloudAPI.community.requestEETrial(
                $scope.appConfig.licensing.ceInstanceId,
                $scope.request.updatedEmailAddress).success(function(data){

            $scope.trialRequestResponse = data;
            if (data.granted) {
                $scope.request.state = "granted";
            } else {
                $scope.request.state = "denied";
            }
        }).error(setErrorInScope.bind($scope));
    };
});


app.controller('RegisterController', function ($scope, $state, Assert, DataikuAPI, DataikuCloudAPI, $rootScope) {
    Assert.inScope($scope, 'appConfig');

    $scope.register = {
        state: 'welcome',
        wantEETrial: false,
        step: '1'
    };
    $scope.newAccount = {
        newsletter: true
    };
    $scope.existingAccount = {};
    $scope.existingKey = {};

    function fetchWebConfig() {
        DataikuCloudAPI.getWebConfig().then(function(id) {
            $scope.webVisitorId = id;
        });
         DataikuCloudAPI.getNewWebConfig().then(function(data) {
            $scope.webVisitorLocalId = data.visitor_id;
            $scope.webVisitorHSId = data.hs_id;
        });
    }
    fetchWebConfig();

    $scope.logMeIn = function() {
        window.location = '/';
    };

    $scope.switchStep = function(state, step) {
        $scope.register.state = state;
        $scope.register.step = step;
    }

    $scope.$watch("register.mode", function(nv, ov) {
        $scope.fatalAPIError = null;
    });

    function setCEThanks(data) {
        if (!data.trialRequestResponse) {
            $scope.register.state = "thanks-ce";
        } else if (data.trialRequestResponse.granted) {
            $scope.register.state = "thanks-ee-trial-granted";
        } else if (!data.trialRequestResponse.granted) {
            $scope.register.state = "thanks-ee-trial-denied";
        }
    }

    $scope.registerNewAccount = function() {
        Assert.trueish($rootScope.appConfig.saasManagerURL, 'Not a saas instance');

        DataikuCloudAPI.community.register(
            $scope.newAccount.firstName, $scope.newAccount.lastName,
            $scope.newAccount.company, $scope.newAccount.persona,
            $scope.newAccount.userEmail,
            $scope.newAccount.newsletter,
            $scope.register.wantEETrial,
            $rootScope.appConfig.version.product_version,
            $scope.webVisitorId, $scope.webVisitorLocalId, $scope.webVisitorHSId,
            $rootScope.appConfig.registrationChannel
        ).success(function(data) {
            /* Write the received license */
            DataikuAPI.registration.initialRegisterCommunity(
                $scope.newAccount.firstName, $scope.newAccount.lastName,
                $scope.newAccount.userEmail,
                data.instanceId, data.license).success(function(data2) {

                $scope.register.registrationResult = data;
                $scope.register.loginInfo = data2;
                if (data.trialRequestResponse && data.trialRequestResponse.granted) {
                    $scope.switchStep('enter-trial-license', 3);
                } else {
                    setCEThanks($scope.register.registrationResult);
                }
            }).error(setErrorInScope.bind($scope));
        }).error(setErrorInScope.bind($scope));
    };

    $scope.registerNoAccount = function () {
        Assert.trueish($rootScope.appConfig.saasManagerURL, 'not a saas instance');

        var firstName = "Unknown";
        var lastName = "Unknown";
        var company = "Unknown";
        var ts = new Date().getTime();
        var userEmail = $scope.webVisitorId + "-" + ts +  "@unknownvisitor.no";
        var password = "Unknown";

        DataikuCloudAPI.community.registerNewAccount(
            firstName, lastName,
            company, userEmail,
            password, 0,
            false,
            $rootScope.appConfig.version.product_version,
            $scope.webVisitorId, $scope.webVisitorLocalId, $scope.webVisitorHSId,
            $rootScope.appConfig.registrationChannel
        ).success(function(data) {
                /* Write the received license */
                DataikuAPI.registration.initialRegisterCommunity(
                    $scope.newAccount.firstName, $scope.newAccount.lastName,
                    $scope.newAccount.userEmail,
                    data.instanceId, data.license).success(function(data2) {

                        $scope.register.registrationResult = data;
                        $scope.register.loginInfo = data2;
                        setCEThanks(data);

                    }).error(setErrorInScope.bind($scope));
            }).error(setErrorInScope.bind($scope));
    };

    $scope.registerExistingAccount = function() {
        Assert.trueish($rootScope.appConfig.saasManagerURL, 'not a saas instance');

        DataikuCloudAPI.community.registerExistingAccount(
            $scope.existingAccount.userEmail,
            $scope.existingAccount.password,
            $scope.register.wantEETrial,
            $rootScope.appConfig.version.product_version,
            $scope.webVisitorId, $scope.webVisitorLocalId, $scope.webVisitorHSId,
            $rootScope.appConfig.registrationChannel
        ).success(function(data) {
            DataikuAPI.registration.initialRegisterCommunity(
                data.firstName, data.lastName,
                $scope.existingAccount.userEmail,
                data.instanceId, data.license).success(function(data2) {

                $scope.register.registrationResult = data;
                $scope.register.loginInfo = data2;
                setCEThanks(data);

            }).error(setErrorInScope.bind($scope));
        }).error(setErrorInScope.bind($scope));
    };

    $scope.setLicense = function() {
        DataikuAPI.registration.initialRegisterLicensed($scope.existingKey.license).success(function(data) {
            $scope.register.loginInfo = data;
            $scope.register.state = "thanks-license";
        }).error(setErrorInScope.bind($scope));
    };
});


app.controller('RenewLicenseController', function($scope, $state, Assert, DataikuAPI, DataikuCloudAPI, $rootScope) {
    Assert.inScope($scope, 'appConfig');
    $scope.existingKey = {}

    $scope.logMeIn = function(){
        window.location = '/';
    };

    $scope.setLicense = function() {
        DataikuAPI.registration.renewExpiredLicense($scope.existingKey.license).success(function(data) {
            $scope.registrationSuccessful = {}
        }).error(setErrorInScope.bind($scope));
    };
});

app.controller("FeedbackController", function($scope, WT1, OpalsService){
    $scope.feedbackContent = {
        comment: '',
        email: $scope.appConfig.user && $scope.appConfig.user.email ? $scope.appConfig.user.email : ''
    }
    $scope.finished = false;

    $scope.sendFeedback = function() {
        $scope.finished = true;
        WT1.event("dss-feedback", $scope.feedbackContent);
    }

    OpalsService.isEnabled().then(function(isOpalsEnabled) {
        $scope.isOpalsEnabled = isOpalsEnabled;
    });
});

app.controller("NoneUserHomeController", function($rootScope, $scope, $state, DataikuAPI, RequestCenterService, CreateModalFromTemplate, WT1){

    $scope.message = "";

    $scope.startTrialFromNoneUser = function() {
        WT1.event("none-user-trial-start");
        DataikuAPI.security.startTrialFromNoneUser().success((data) => {
            WT1.event("none-user-trial-start-success");
            // Violent redirect to avoid keeping a cached appConfig
            window.location = "/";
        }).error(function(a,b,c) {
            setErrorInScope.bind($scope)(a,b,c);
            WT1.event("none-user-trial-start-failed");
        });
    }

    $scope.requestLicenseFromNoneUser = (message) => {
        DataikuAPI.requests.createInstanceAccessRequest(message).success((data) => {
            RequestCenterService.WT1Events.onRequestSent("INSTANCE", null, null, message, data.id);
            $scope.state = "pending-request";
        }).error(setErrorInScope.bind($scope));
    };

    $scope.logoutNoneUser = () => {
        DataikuAPI.logout().success(function(data) {
            // Violent redirect to avoid keeping a cached appConfig
            window.location = "/";
        }).error(setErrorInScope.bind($scope));
    };

    const fetchLatestRequest = () => {
        DataikuAPI.requests.getLatestRequestForCurrentUser("", "INSTANCE", "")
        .then(response => {
            $scope.hasPreviousRequest = response.data.status === "PENDING";
        }, error => {
            $scope.hasPreviousRequest = false;
        }).finally(() => {
            if ($scope.hasPreviousRequest) {
                $scope.state = "pending-request";
            } else if ($scope.appConfig.noneUsersCallToActionBehavior === 'ALLOW_REQUEST_ACCESS') {
                $scope.state = "request-access";
            } else if ($scope.appConfig.noneUsersCallToActionBehavior === 'ALLOW_START_TRIAL' && $scope.appConfig.allowRequestAccessWithStartedTrial && hasTrialToken && $scope.appConfig.trialStatus.expired) {
                $scope.state = "request-access";
            }
        });
    };

    const hasTrialToken = $scope.appConfig.trialStatus && $scope.appConfig.trialStatus.exists;
    if (hasTrialToken && $scope.appConfig.trialStatus.illegal) {
        $scope.state = "illegal-token";
    } else if (!hasTrialToken && $scope.appConfig.noneUsersCallToActionBehavior === 'ALLOW_START_TRIAL') {
        $scope.state = "start-trial";
    } else {
        $scope.state = "message-only";
        fetchLatestRequest();
    }
});

app.controller('LoginController', function($scope, $state, $location, DataikuAPI, TopNav, LoggerProvider, LocalStorage) {

    const Logger = LoggerProvider.getLogger('LoginController');
    TopNav.setLocation(TopNav.LOGIN, "login");
    $scope.ssoEnabled = false;

    DataikuAPI.getConfiguration().success(function(data) {
        $scope.ssoEnabled = data.ssoLoginEnabled;
    });

    var lic = $scope.appConfig.licensing;
    $scope.communityLook = lic.community && !lic.ceEntrepriseTrial;
    if (lic.ceEntrepriseTrialUntil > Date.now()) {
        $scope.daysLeft = Math.floor((lic.ceEntrepriseTrialUntil - Date.now()) / (24 * 3600 * 1000));
    }

    $scope.submit = function() {
        var formLogin = $("input[name=login]").val(),
            formPassword = $("input[name=password]").val();

        $scope.loginFailed = false;
        $scope.loginErrorMessage = '';
        DataikuAPI.login(formLogin, formPassword).success(function(data) {
            const redirectTo = $state.params.redirectTo;
            const search = $state.params.search || "";
            if (redirectTo) {
                Logger.info("GO " + redirectTo);
                // ui-router does not seem to manage changes of $location.url ... It just does not do anything
                // And since I have a URL, I can't use transitionTo
                // SO I have to reload. It sucks
                const url = new URL(window.location.href);
                url.search = search;
                url.pathname = redirectTo;  // Only follow redirects to a local path, not to another site
                window.location = url.href;
            } else {
                // I also do it here to ensure that we reload appConfig
                window.location = "/";
            }
            LocalStorage.set("dss.hasUsedDashboardFilters", false);
        }).error(function(data, status, headers) {
            $scope.loginFailed = true;
            if (data.errorType) {
                $scope.loginError = getErrorDetails(data, status, headers)
            } else {
                $scope.loginErrorMessage = data;
            }
        });
    };

    if ($scope.appConfig.loggedIn && !$scope.appConfig.noLoginMode) {
        // it's confusing to leave people on a blank login screen when they are actually logged in
        $scope.redirectHome();
    }

    $scope.redirectToSSO = function() {
        window.location = "/";
    }
});

app.controller('SSOErrorController', function($scope, $state, TopNav) {

    TopNav.setLocation(TopNav.LOGIN, "login");

    $scope.error = $state.params.error;
    $scope.errorDescription = $state.params.errorDescription;

    if ($scope.appConfig.loggedIn && !$scope.appConfig.noLoginMode) {
        // it's confusing to leave people on a blank login screen when they are actually logged in
        $scope.redirectHome();
    }
});

// You MUST call setCurrentProjectFolderId with the appropriate folderId in the link method of CreateModal...
app.controller('NewLearningProjectController', function($scope, $rootScope, Assert, DataikuAPI, $state, WT1, CreateModalFromTemplate, ListFilter, ProjectFolderContext, ProjectFolderService, PathUtils, PromiseService, translate) {

    $scope.facets = [
        { "id": "type", "label": "Type", values: [], $open: true, $allChecked: true }
    ];
    $scope.query = { q:"" };
    $scope.filteredProjects = [];
    $scope.selectedProject = null;

    $scope.targetProjectFolder = null; // used in the project folder service
    $scope.defaultProjectFolderId = null;

    $scope.setCurrentProjectFolderId = (folderId) => {
        ProjectFolderService.getDefaultFolderForNewProject(folderId).then((folder) => {
            $scope.targetProjectFolder = folder;
            $scope.defaultProjectFolderId = folder.id;
        }).catch(setErrorInScope.bind($scope));
    }

    $scope.browse = folderIds => {
        // Use last id in path
        $scope.destination = PathUtils.makeNLNT(folderIds).split('/').pop();
        // browse-path expects a success-error promise so we need to wrap with qToHttp for now (catch() does not return a monkey-patched promise)
        return PromiseService.qToHttp(ProjectFolderService.getBrowseNode($scope.destination).catch(setErrorInScope.bind($scope)));
    };

    $scope.getProjectFolderName = item => item.name;
    $scope.canSelectFolder = item => item.canWriteContents;

    function getFacet(facetId) {
        return $scope.facets.find(facet => facet["id"] === facetId);
    }

    function populateSections() {
        if (!$scope.tutorialsList) return;

        $scope.tutorialsList.items.forEach(function(project) {
            if (project.archiveType !== 'FETCH' ) {
                // get the image from the backend for builtin tutorials. Remote tutorials have
                // to provide the image themselves, so we can use their imageURL directly
                project.imageURL = '/dip/api/image/get-tutorial-thumbnail?tutorialId=' + project.id;
            }
            addSectionsToFacet(project.sectionName, "type");
        });
    }

    function addSectionsToFacet(sectionName, facetId) {
        let values = getFacet(facetId).values;
        if (!values.some(value => value.label === sectionName)) {
            values.push({ label: sectionName, $checked: false });
        }
    }

    DataikuAPI.projects.listTutorials().success(function(data) {
        $scope.tutorialsList = data;
        $scope.tutorialsList.items = $scope.tutorialsList.items
            .filter(d => d.type === 'SAMPLE' || d.type === 'TUTORIAL')
            .map(d => {
                // patch tutorials
                if (d.type === 'SAMPLE') {
                    d.sectionName = 'Sample';
                } else if (d.sectionName === "Core Designer / Basics") {
                    // Fix the section name so that old tutorials are displayed in the new category
                    d.sectionName = 'Core Designer';
                }
                return d;
            });

        $scope.filteredProjects = $scope.tutorialsList.items;

        populateSections();
    }).error(setErrorInScope.bind($scope));

    $scope.$watch("query", () => {
        updateFilteredProjects();
    }, true);

    function matchesFacet(facetName, sectionName) {
        const facet = getFacet(facetName);
        if (facet.$allChecked) {
            return true;
        }
        const selectedValues = facet.values
            .filter(facetItem => facetItem.$checked)
            .map(facetItem => facetItem.label);
        return selectedValues.includes(sectionName);

    }

    function updateFilteredProjects() {
        if (!$scope.tutorialsList || !$scope.tutorialsList.items) return;

        $scope.filteredProjects = ListFilter
            .filter($scope.tutorialsList.items || [], $scope.query.q)
            .filter(tutorial => matchesFacet("type", tutorial.sectionName)
            );
    }

    $scope.setSelectedProject = function(project) {
        return $scope.selectedProject = project;
    }

    $scope.onFacetItemClicked = function(facet) {
        facet.$allChecked = facet.values.every(facetItem => !facetItem.$checked);
        updateFilteredProjects();
    }

    $scope.onFacetAllItemClicked = function(facet) {
        if (facet.$allChecked) {
            facet.values.forEach(facetItem => facetItem.$checked = false);
        }
        updateFilteredProjects();
    }

    $scope.start = function(project, targetProjectFolder, defaultProjectFolderId) {
        Assert.trueish(project.id, 'No tutorial id');

        // note to self: pass the parent scope of this modal's scope as the download modal's scope's parent, since
        // we're going to dismiss this modal right now (and if the download modal was using this scope, then it would be
        // created non functional...)
        CreateModalFromTemplate("/templates/projects/tutorial-download.html", $scope.attachDownloadTo, null, function(newScope) {
            newScope.tutorialIdToInstall = project.id;
            newScope.tutorialType = project.type;
            newScope.tutorialDescription = project.description;
            newScope.tutorialName = project.name;
            newScope.targetProjectFolder = targetProjectFolder;
            newScope.defaultProjectFolderId = defaultProjectFolderId;
        });

        $scope.dismiss();
    };

    $scope.installButtonTooltip = function(selectedProject, targetProjectFolder) {
        if (selectedProject === null) {
            return translate("HOME.PROJECTS.NEW.TUTORIALS.HELP", "Select a project to install");
        }

        if (!$scope.mayCreateProjectsFromTemplates()) {
            return translate("HOME.PROJECTS.NEW.TUTORIALS.NO_PERM.HELP", "You do not have permission to create projects using templates");
        }

        if (!targetProjectFolder.canWriteContents) {
            return translate("HOME.NEW_PROJECT.FOLDER.CANNOT_WRITE.HELP", "You cannot write to this folder");
        }

        return "";
    };

    $scope.mayCreateProjectsFromTemplates = function() {
        return $rootScope.appConfig && $rootScope.appConfig.globalPermissions.mayCreateProjectsFromTemplates;
    };

});

// You MUST call setCurrentProjectFolderId with the appropriate folderId in the link method of CreateModal...
app.controller('NewSolutionProjectController', function($sce, $scope, $rootScope, Assert, DataikuAPI, $state, WT1, CreateModalFromTemplate, ListFilter, ProjectFolderContext, ProjectFolderService, PathUtils, PromiseService, translate, $window) {

    $scope.facets = [
        { "id": "industry", "label": "Industry", values: [], $open: true, $allChecked: true },
        { "id": "lineOfBusiness", "label": "Line of Business", values: [], $open: true, $allChecked: true },
        { "id": "type", "label": "Type", values: [], $open: true, $allChecked: true }
    ];
    $scope.query = { q:"" };
    $scope.filteredSolutions = [];
    $scope.selectedSolution = null;

    $scope.targetProjectFolder = null; // used in the project folder service
    $scope.defaultProjectFolderId = null;

    $scope.browse = folderIds => {
        // Use last id in path
        $scope.destination = PathUtils.makeNLNT(folderIds).split('/').pop();
        // browse-path expects a success-error promise so we need to wrap with qToHttp for now (catch() does not return a monkey-patched promise)
        return PromiseService.qToHttp(ProjectFolderService.getBrowseNode($scope.destination).catch(setErrorInScope.bind($scope)));
    };

    $scope.getProjectFolderName = item => item.name;
    $scope.canSelectFolder = item => item.canWriteContents;

    function getFacet(facetId) {
        return $scope.facets.find(facet => facet["id"] === facetId);
    }

    function addSections(solution) {
        addSectionsToFacet(solution.solutionCategories, "industry");
        addSectionsToFacet(solution.solutionLineOfBusiness, "lineOfBusiness");
        addSectionsToFacet(solution.solutionType, "type");
    }

    function addSectionsToFacet(items, facetId) {
        if (items) {
            items.forEach((sectionName) => {
                let values = getFacet(facetId).values;
                if (!values.some(value => value.label === sectionName)) {
                    values.push({ label: sectionName, $checked: false });
                }
            });
        }
    }

    function matchesFacet(facetName, facetValues) {
        const facet = getFacet(facetName);
        if (facet.$allChecked) {
            return true;
        }
        const selectedValues = facet.values
            .filter(facetItem => facetItem.$checked)
            .map(facetItem => facetItem.label);
        return Array.isArray(facetValues) && facetValues.some(item => selectedValues.includes(item));

    }

    function updateFilteredSolutions() {
        $scope.filteredSolutions = ListFilter
            .filter($scope.solutions || [], $scope.query.q)
            .filter(solution => matchesFacet("industry", solution.solutionCategories)
                && matchesFacet("lineOfBusiness", solution.solutionLineOfBusiness)
                && matchesFacet("type", solution.solutionType)
            );
    }

    $scope.setSelectedSolution = function(solution) {
        WT1.tryEvent("solution-browsed", () => {
            return {
                tutorialId: solution.id
            };
        })
        return $scope.selectedSolution = solution;
    }

    $scope.onFacetItemClicked = function(facet) {
        facet.$allChecked = facet.values.every(facetItem => !facetItem.$checked);
        updateFilteredSolutions();
    }

    $scope.onFacetAllItemClicked = function(facet) {
        if (facet.$allChecked) {
            facet.values.forEach(facetItem => facetItem.$checked = false);
        }
        updateFilteredSolutions();
    }

    $scope.$watch("query", () => {
        updateFilteredSolutions();
    }, true);

    $scope.openDocumentationUrl = function(solution) {
        WT1.tryEvent("solution-documentation-opened", () => {
             return {
                 tutorialId: solution.id
             };
        });
        $window.open(solution.documentationURL, '_blank');
    };

    $scope.start = function(solution, targetProjectFolder, defaultProjectFolderId) {
        Assert.trueish(solution.id, 'No tutorial id');

        WT1.tryEvent("tutorial-project-creating", () => {
            return {
                tutorialId: solution.id
            };
        });

        // note to self: pass the parent scope of this modal's scope as the download modal's scope's parent, since
        // we're going to dismiss this modal right now (and if the download modal was using this scope, then it would be
        // created non functional...)
        CreateModalFromTemplate("/templates/projects/solution-download.html", $scope.attachDownloadTo, null, function(newScope) {
            newScope.tutorialIdToInstall = solution.id;
            newScope.tutorialType = "INDUSTRY_SOLUTION";
            newScope.documentationURL = solution.documentationURL;
            newScope.tutorialName = solution.name;
            newScope.targetProjectFolder = targetProjectFolder;
            newScope.defaultProjectFolderId = defaultProjectFolderId;
        });

        $scope.dismiss();
    };

    DataikuAPI.projects.listTutorials().success(function(data){
        $scope.tutorialsList = data;

        if ($scope.tutorialsList && $scope.tutorialsList.items) {
            $scope.solutions = $scope.tutorialsList.items.filter(tutorial => tutorial.type === 'INDUSTRY_SOLUTION');
            $scope.solutions.forEach(function(solution) {
                if (solution.archiveType !== 'FETCH') {
                    // get the image from the backend for builtin tutorials. Remote tutorials have
                    // to provide the image themselves, so we can use their imageURL directly
                    solution.imageURL = '/dip/api/image/get-tutorial-thumbnail?tutorialId=' + solution.id;
                }

                // Check conditions to show the flags
                solution.showFlag = solution.flagRelease === "New Solution" || solution.flagRelease === "Upgrade Available";
                if (solution.flagMaxDate) {
                    solution.isBeforeMaxDate = new Date() < new Date(solution.flagMaxDate);
                }
                $scope.getLabel = function(project) {
                    switch (project.flagRelease) {
                        case "New Solution":
                            return "New";
                        case "Upgrade Available":
                            return "Updated";
                        default:
                            return ""; // Default label if neither condition is met
                    }
                };

                solution.previewURL = $sce.trustAsResourceUrl(solution.previewURL);

                addSections(solution);
            });
        } else {
            $scope.solutions = [];
        }
        $scope.filteredSolutions = $scope.solutions;
    }).error(setErrorInScope.bind($scope));

    $scope.installButtonTooltip = function(selectedSolution, targetProjectFolder) {
        if (selectedSolution === null) {
            return translate("HOME.NEW_SOLUTION.INSTALL_BUTTON.NONE_SELECTED.HELP", "Select a Dataiku Solution to install");
        }

        if (!$scope.mayCreateProjectsFromTemplates()) {
            return translate("HOME.NEW_SOLUTION.INSTALL_BUTTON.NO_PERM.HELP", "You do not have permission to create projects using templates");
        }

        if (!targetProjectFolder.canWriteContents) {
            return translate("HOME.NEW_PROJECT.FOLDER.CANNOT_WRITE.HELP", "You cannot write to this folder");
        }

        return "";
    };

    $scope.mayCreateProjectsFromTemplates = function() {
        return $rootScope.appConfig && $rootScope.appConfig.globalPermissions.mayCreateProjectsFromTemplates;
    };

    $scope.setCurrentProjectFolderId = (folderId) => {
        if ($scope.mayCreateProjectsFromTemplates()) {
            ProjectFolderService.getDefaultFolderForNewProject(folderId).then((folder) => {
                $scope.targetProjectFolder = folder;
                $scope.defaultProjectFolderId = folder.id;
            }).catch(setErrorInScope.bind($scope));
        }
    }

});

app.controller('TutorialDownloadController', function($scope, $rootScope, QuestionnaireService, PageSpecificTourService, DataikuAPI, MonoFuture, Fn, WT1, $state, ProjectFolderService, OpalsService) {
    $scope.state = "NOT_STARTED";

    function go(){
        MonoFuture($scope).wrap(DataikuAPI.projects.createTutorial)($scope.tutorialIdToInstall, $scope.tutorialType, $scope.targetProjectFolder.id).success(function(data) {
            $scope.state = data.result.success ? "DONE" : "FAILED";
            $scope.stateShown = null;
            if (!data.result.success) {
                $scope.failure = {
                    aborted : data.aborted,
                    message : data.result.installationError.detailedMessage
                }
                WT1.tryEvent("tutorial-project-creation-failed", () => {
                    return {
                        tutorialId : $scope.tutorialIdToInstall
                    };
                });
            } else {
                $scope.needsGoingToTutorial = true;
                $scope.projectKey = data.result.projectKey;
                WT1.tryEvent("tutorial-project-created", () => {
                    return {
                        tutorialId : $scope.tutorialIdToInstall,
                        isInSuggestedFolder: $scope.targetProjectFolder.id === $scope.defaultProjectFolderId,
                        isInRoot: ProjectFolderService.isInRoot($scope.targetProjectFolder.id),
                        isUnderSandbox: ProjectFolderService.isUnderSandbox($scope.targetProjectFolder)
                    };
                });
            }

            $scope.installingFuture = null;
        }).update(function(data) {
            $scope.stateShown = data.progress != null && data.progress.states != null && data.progress.states.length > 0 ?
                                                                    data.progress.states[data.progress.states.length - 1] : null;
            $scope.state = "RUNNING";
            $scope.installingFuture = data;
        }).error(function (data, status, headers) {
            $scope.state = "FAILED";
            if ( data.aborted) {
                $scope.failure = {
                    aborted : data.aborted,
                    message : "Aborted"
                }
            } else if (data.hasResult) {
                $scope.failure = {
                    aborted : data.aborted,
                    message : data.result.errorMessage
                }
            } else {
                $scope.failure = {
                    aborted : data.aborted,
                    message : "Unexpected error"
                }
            }
            $scope.installingFuture = null;
        });
    }

    $scope.abort = function() {
        $scope.state = "FAILED";
        $scope.failure = {
            message : "Aborted"
        }
        DataikuAPI.futures.abort($scope.installingFuture.jobId);
    };

    $scope.closeAndGo = function(){
        $scope.dismiss();
        $state.go("projects.project.home.regular", {projectKey : $scope.projectKey});
    }

    $scope.$on("$destroy", function(){
        if ($scope.state == "RUNNING") {
            $scope.abort();
        }
    });

    /* Wait for the plugin id to start */
    $scope.$watch("tutorialIdToInstall", Fn.doIfNv(go));
});

app.controller('BusinessSolutionDownloadController', function($scope, DataikuAPI, MonoFuture, Fn, WT1, $state, $window, StateUtils, Assert, $rootScope, Notification, RequestCenterService, ProjectFolderService) {
    $scope.state = "NOT_STARTED";
    $scope.phase = "READY_TO_DOWNLOAD";
    $scope.downloadData = {};
    $scope.importSettings = {
        remapping : {
            connections : []
        },
    };

    $scope.isDSSAdmin = $rootScope.isDSSAdmin();

    function download(){
        $scope.phase = "DOWNLOADING";

        MonoFuture($scope).wrap(DataikuAPI.projects.downloadTutorial)($scope.tutorialIdToInstall, $scope.tutorialType).success(function(data) {
            $scope.state = data.result.success ? "DONE" : "FAILED";
            $scope.stateShown = null;

            if (!data.result.success) {
                $scope.failure = {
                    aborted : data.aborted,
                    message : data.result.downloadError.detailedMessage
                }
                WT1.tryEvent("tutorial-project-creation-failed", () => {
                    return {
                        tutorialId : $scope.tutorialIdToInstall
                    };
                });
            } else {
                $scope.downloadResult = data.result;
                $scope.prepareImport();
            }
            $scope.installingFuture = null;
        }).update(function(data) {
            $scope.stateShown = data.progress != null && data.progress.states != null && data.progress.states.length > 0 ?
                                                                    data.progress.states[data.progress.states.length - 1] : null;
            $scope.state = "RUNNING";
            $scope.installingFuture = data;
        }).error(handleJobError);
    };

    function handleJobError(data, status, headers) {
        $scope.state = "FAILED";
        if ( data.aborted) {
           $scope.failure = {
                aborted : data.aborted,
                message : "Aborted"
           }
        } else if (data.hasResult) {
           $scope.failure = {
                aborted : data.aborted,
                message : data.result.errorMessage
           }
        } else {
           $scope.failure = {
                aborted : data.aborted,
                message : "Unexpected error"
           }
        }
        $scope.installingFuture = null;
    }

    $scope.prepareImport = function() {
        $scope.phase = "PREPARE_IMPORT";
        $scope.state = "RUNNING";

        DataikuAPI.projects.prepareImportTutorial($scope.downloadResult.importId)
            .success(function(data) {
                $scope.prepareResponse = data;
                $scope.state = "DONE";
                if($scope.prepareResponse.success){
                    $scope.startImport();
                }else if($scope.prepareResponse.prepareError){
                    $scope.state = "FAILED";
                    $scope.failure = {
                        aborted : false,
                        message : $scope.prepareResponse.prepareError.detailedMessage
                    }
                }else{
                    $scope.updatePreviousRequests();
                    Notification.registerEvent("plugin-request-granted", function(_, evt) {
                        removePluginWarnings(evt.objectId);
                    });
                    Notification.registerEvent("plugin-request", function(_, evt) {
                        const requestedPluginInstall = $scope.prepareResponse.notInstalledPlugins.find(element => {
                            return element.id === evt.objectId;
                        });
                        if(requestedPluginInstall && $rootScope.appConfig.login === evt.requesterLogin){
                            requestedPluginInstall.hasPreviousRequest = true;
                        }
                        const requestedPluginUpdate = $scope.prepareResponse.notUpToDatePlugins.find(element => {
                            return element.id === evt.objectId;
                        });
                        if(requestedPluginUpdate && $rootScope.appConfig.login === evt.requesterLogin){
                            requestedPluginUpdate.hasPreviousRequest = true;
                        }
                    });
                    Notification.registerEvent("plugin-changed", function(_, evt) {
                        if(evt.action !== 'INSTALLED'){
                            return;
                        }
                        removePluginWarnings(evt.pluginId);
                    });
                    Notification.registerEvent("code-env-request-granted", function(_, evt) {
                        removeCodeEnvErrors(evt.objectId);
                    });
                    Notification.registerEvent("code-env-request", function(_, evt) {
                        const requestedCodeEnv = $scope.prepareResponse.missingCodeEnvs.find(element => {
                            return element.id === evt.objectId;
                        });
                        if(requestedCodeEnv && $rootScope.appConfig.login === evt.requesterLogin){
                            requestedCodeEnv.hasPreviousRequest = true;
                        }
                    });
                    Notification.registerEvent("code-env-changed", function(_, evt) {
                        if(evt.action == 'CREATED'){
                            removeCodeEnvErrors(evt.envName);
                        }
                    });
                }
            }).error(setErrorInScope.bind($scope));
    }

    function removePluginWarnings(pluginId){
        const requestedPluginInstall = $scope.prepareResponse.notInstalledPlugins.find(element => {
            return element.id === pluginId;
        });
        if(requestedPluginInstall){
            requestedPluginInstall.hasPreviousRequest = false;
            let index = $scope.prepareResponse.notInstalledPlugins.indexOf(requestedPluginInstall);
            if (index !== -1) {
                $scope.prepareResponse.notInstalledPlugins.splice(index, 1);
            }
        }
        const requestedPluginUpdate = $scope.prepareResponse.notUpToDatePlugins.find(element => {
            return element.id === pluginId;
        });
        if(requestedPluginUpdate){
            requestedPluginUpdate.hasPreviousRequest = false;
            let index = $scope.prepareResponse.notUpToDatePlugins.indexOf(requestedPluginUpdate);
            if (index !== -1) {
                $scope.prepareResponse.notUpToDatePlugins.splice(index, 1);
            }
        }
    }

    function removeCodeEnvErrors(codeEnvName){
        const codeEnv = $scope.prepareResponse.missingCodeEnvs.find(element => {
            return element.envName === codeEnvName;
        });
        if(codeEnv){
            codeEnv.hasPreviousRequest = false;
            let index = $scope.prepareResponse.missingCodeEnvs.indexOf(codeEnv);
            if (index !== -1) {
                $scope.prepareResponse.missingCodeEnvs.splice(index, 1);
            }
        }
    }

    $scope.updatePreviousRequests = function(){
        for(let p of $scope.prepareResponse.notInstalledPlugins){
            updatePreviousPluginRequest(p);
        }
        for(let p of $scope.prepareResponse.notUpToDatePlugins){
            updatePreviousPluginRequest(p);
        }
        for(let p of $scope.prepareResponse.missingCodeEnvs){
            updatePreviousCodeEnvRequest(p);
        }
    }

    function updatePreviousPluginRequest(pluginRequirement){
        DataikuAPI.requests.getLatestRequestForCurrentUser(pluginRequirement.id, "PLUGIN", "")
        .then(response => {
            if (response.data.status === "PENDING") {
                pluginRequirement.hasPreviousRequest = true;
                pluginRequirement.latestRequest = response.data;
            } else {
                pluginRequirement.hasPreviousRequest = false;
                pluginRequirement.latestRequest = {};
            }
        }, error => {
            if(error.status === 404){
                pluginRequirement.hasPreviousRequest = false;
                pluginRequirement.latestRequest = {};
            } else {
                setErrorInScope.bind($scope)(error);
            }
        });
    }

    function updatePreviousCodeEnvRequest(codeEnv){
        DataikuAPI.requests.getLatestRequestForCurrentUser(codeEnv.envName, "CODE_ENV", "")
        .then(response => {
            if (response.data.status === "PENDING") {
                codeEnv.hasPreviousRequest = true;
                codeEnv.latestRequest = response.data;
            } else {
                codeEnv.hasPreviousRequest = false;
                codeEnv.latestRequest = {};
            }
        }, error => {
            if(error.status === 404){
                codeEnv.hasPreviousRequest = false;
                codeEnv.latestRequest = {};
            } else {
                setErrorInScope.bind($scope)(error);
            }
        });
    }

    $scope.startImport = function() {
        Assert.trueish($scope.phase === "PREPARE_IMPORT" && $scope.state === "DONE", 'not ready to import');
        Assert.trueish($scope.downloadResult.importId, 'no download id');

        $scope.phase = "IMPORTING";
        $scope.state = "RUNNING";

        resetErrorInScope($scope);

        MonoFuture($scope).wrap(DataikuAPI.projects.startImportTutorial)($scope.downloadResult.importId, $scope.tutorialIdToInstall, $scope.downloadResult.projectKey, $scope.targetProjectFolder.id).success(function(data) {
            $scope.state = data.result.success ? "DONE" : "FAILED";
            $scope.stateShown = null;
            if (!data.result.success) {
                $scope.failure = {
                    aborted : data.aborted,
                    message : data.result.installationError.detailedMessage
                }
                WT1.tryEvent("tutorial-project-creation-failed", () => {
                    return {
                        tutorialId : $scope.tutorialIdToInstall
                    };
                });
            } else {
                $scope.projectKey = data.result.projectKey;
                WT1.tryEvent("tutorial-project-created", () => {
                    return {
                        tutorialId : $scope.tutorialIdToInstall,
                        isInSuggestedFolder: $scope.targetProjectFolder.id === $scope.defaultProjectFolderId,
                        isInRoot: ProjectFolderService.isInRoot($scope.targetProjectFolder.id),
                        isUnderSandbox: ProjectFolderService.isUnderSandbox($scope.targetProjectFolder)
                    };
                });
            }

            $scope.installingFuture = null;
        }).update(function(data) {
            $scope.stateShown = data.progress != null && data.progress.states != null && data.progress.states.length > 0 ?
                                                                    data.progress.states[data.progress.states.length - 1] : null;
            $scope.state = "RUNNING";
            $scope.installingFuture = data;
        }).error(handleJobError);
    }

    $scope.abort = function() {
        $scope.state = "FAILED";
        $scope.failure = {
            message : "Aborted"
        }
        DataikuAPI.futures.abort($scope.installingFuture.jobId);
    };

    $scope.closeAndGo = function(){
        $scope.dismiss();
        $state.go("projects.project.home.regular", {projectKey : $scope.projectKey})
    }

    $scope.openPluginInstall = function(pluginId){
        $window.open(StateUtils.href.pluginStore(pluginId), '_blank');
    }

    $scope.openCodeEnvCreate = function(codeEnv){
        DataikuAPI.admin.codeenvs.design.prepareDraftFromProjectImport(codeEnv.envLang, codeEnv.envName, JSON.stringify(codeEnv.desc), codeEnv.specCondaEnvironment, codeEnv.specPackageList).success((data) => {
             $window.open(StateUtils.href.codeEnvCreation(data.config.id), '_blank');
        }).error(setErrorInScope.bind($scope));
    }

    $scope.sendInstallPluginRequest = function(pluginRequirement){
        $scope.sendPluginRequest(pluginRequirement, 'INSTALL_PLUGIN');
    }

    $scope.sendCreateCodeEnvRequest = function(codeEnv){
        let requestMessage = "Required code-env to install the industry solution: " + $scope.tutorialName;
        DataikuAPI.requests.createCodeEnvRequest("INSTALL_CODE_ENV", codeEnv.envName, codeEnv.envLang, JSON.stringify(codeEnv.desc) ,codeEnv.specPackageList, codeEnv.specCondaEnvironment, requestMessage)
        .success(function(data){
            codeEnv.hasPreviousRequest = true;
            RequestCenterService.WT1Events.onRequestSent("CODE_ENV", null, codeEnv.envName, requestMessage, data.id);
        }).error(() => {
            setErrorInScope.bind($scope);
        });
    }

    $scope.sendUpdatePluginRequest = function(pluginRequirement){
        $scope.sendPluginRequest(pluginRequirement, 'UPDATE_PLUGIN');
    }

    $scope.sendPluginRequest = function(pluginRequirement, requestType){
        let requestTypeLabel = requestType === "INSTALL_PLUGIN" ? "install" : "update";
        let requestMessage = "Required plugin to install the Dataiku Solution: " + $scope.tutorialName;
        DataikuAPI.requests.createPluginRequest(requestType, pluginRequirement.id, requestMessage)
        .success((data) => {
            pluginRequirement.hasPreviousRequest = true;
            RequestCenterService.WT1Events.onRequestSent("PLUGIN", null, pluginRequirement.id, requestMessage, data.id);
        }).error(() => {
            setErrorInScope.bind($scope);
        });
    }

    $scope.hasErrors = function(){
        return $scope.prepareResponse
                && $scope.prepareResponse.missingCodeEnvs.length > 0;
    }
    $scope.hasWarnings = function(){
        return $scope.prepareResponse
                && ($scope.prepareResponse.notInstalledPlugins.length > 0 ||
                    $scope.prepareResponse.notUpToDatePlugins.length > 0 ||
                    $scope.prepareResponse.notExistingPlugins.length > 0);
    }

    $scope.$on("$destroy", function(){
        if ($scope.state == "RUNNING") {
            $scope.abort();
        }
    });

    /* Wait for the plugin id to start */
    $scope.$watch("tutorialIdToInstall", Fn.doIfNv(download));
});

// You MUST call setCurrentProjectFolderId with the appropriate folderId in the link method of CreateModal...
app.controller('NewProjectController', function($scope, DataikuAPI, $state, $stateParams, WT1, ProjectFolderContext, PromiseService, ProjectFolderService, PathUtils) {

    $scope.modalTabState = { active: "create" };
    $scope.newProject = {};
    $scope.uniq = true;

    $scope.targetProjectFolder = null; // used in the project folder service
    $scope.defaultProjectFolderId = null;

    $scope.setCurrentProjectFolderId = (folderId) => {
        ProjectFolderService.getDefaultFolderForNewProject(folderId).then((folder) => {
            $scope.targetProjectFolder = folder;
            $scope.defaultProjectFolderId = folder.id;
        }).catch(setErrorInScope.bind($scope));
    }

    $scope.getProjectFolderName = item => item.name;
    $scope.canSelectFolder = item => item.canWriteContents;

    DataikuAPI.projects.listAllKeys()
        .then(function(resp) { $scope.allProjectKeys = resp.data; })
        .catch(setErrorInScope.bind($scope));

    function isProjectKeyUnique(value) {
        return !$scope.allProjectKeys || $scope.allProjectKeys.indexOf(value) < 0;
    };

    $scope.$watch("newProject.projectKey", function(nv, ov) {
        $scope.uniq = !nv || isProjectKeyUnique(nv);
    });

    const isNum = (v) => v && !isNaN(v);
    $scope.projectKeyIsNum = () => isNum($scope.newProject.projectKey);

    $scope.$watch("newProject.name", function(nv, ov) {
        if (!nv) return;
        let slug = nv.toUpperCase().replace(/\W+/g, ""),
            cur = isNum(slug) ? 'P' + slug : slug,
            i = 0;
        while (!isProjectKeyUnique(cur)) {
            cur = slug + "_" + (++i);
        }
        $scope.newProject.projectKey = cur;
    });

    $scope.create = function() {
        DataikuAPI.projects.create($scope.newProject.projectKey, $scope.newProject.name, $scope.targetProjectFolder.id)
            .success(function(data) {
                $scope.dismiss();
                $state.transitionTo("projects.project.home.regular", {projectKey : $scope.newProject.projectKey});
            }).error(setErrorInScope.bind($scope));
        WT1.tryEvent("project-create", () => {
            return {
                hashedProjectId: md5($scope.newProject.projectKey),
                isInSuggestedFolder: $scope.targetProjectFolder.id === $scope.defaultProjectFolderId,
                isInRoot: ProjectFolderService.isInRoot($scope.targetProjectFolder.id),
                isUnderSandbox: ProjectFolderService.isUnderSandbox($scope.targetProjectFolder)
            };
        });
    };

    $scope.browse = folderIds => {
        // Use last id in path
        $scope.destination = PathUtils.makeNLNT(folderIds).split('/').pop();
        // browse-path expects a success-error promise so we need to wrap with qToHttp for now (catch() does not return a monkey-patched promise)
        return PromiseService.qToHttp(ProjectFolderService.getBrowseNode($scope.destination).catch(setErrorInScope.bind($scope)));
    };
});


// Re-render dku-bs-select every time the source connection to update connection sorting
app.directive("importProjectRemappingForm", function() {
    return {
        scope: false,
        link: function($scope, $elt) {
            $scope.$watch("conn.source", function(nv) {
                if (!nv) return;
                $elt.find('select[dku-bs-select]').selectpicker('refresh');
            })
            $scope.$watch("codeEnv.source", function(nv) {
                if (!nv) return;
                $elt.find('select[dku-bs-select]').selectpicker('refresh');
            })
        }
    }
});

// You MUST call setCurrentProjectFolderId with the appropriate folderId in the link method of CreateModal...
app.controller('ImportProjectController', function($scope, Assert, DataikuAPI, $state, $filter,
               FutureWatcher, ProgressStackMessageBuilder, CreateModalFromTemplate, Dialogs, $timeout, Fn, WT1, ProjectFolderContext, PromiseService, ProjectFolderService, PathUtils) {
    // get the list, don't get it from the home (in case the call to populate the home is too slow)
    DataikuAPI.projects.listAllKeys()
    .success(function(data) { $scope.allProjectKeys = data; })
    .error(setErrorInScope.bind($scope));

    $scope.importData = {}
    $scope.importSettings = {
        remapping : {
            connections : []
        },
        targetProjectFolderId: null
    };
    $scope.uiState = {
        targetProjectFolder: null
    }

    $scope.setCurrentProjectFolderId = (folderId) => {
        ProjectFolderService.getDefaultFolderForNewProject(folderId).then((folder) => {
            $scope.uiState.targetProjectFolder = folder;
            $scope.importSettings.targetProjectFolderId = folder.id;
            $scope.defaultProjectFolderId = folder.id;
        }).catch(setErrorInScope.bind($scope));
    }

    $scope.getProjectFolderName = item => item.name;
    $scope.canSelectFolder = item => item.canWriteContents;

    $scope.browse = folderIds => {
        // Use last id in path
        $scope.destination = PathUtils.makeNLNT(folderIds).split('/').pop();
        // browse-path expects a success-error promise so we need to wrap with qToHttp for now (catch() does not return a monkey-patched promise)
        return PromiseService.qToHttp(ProjectFolderService.getBrowseNode($scope.destination).catch(setErrorInScope.bind($scope)));
    };

    $scope.phase = "READY_TO_UPLOAD";
    $scope.prepare = {enabled: false};

    $scope.selectFilter = function(selected) {
        return function(connection) {
            return !connection.mapped || connection.name == selected;
        }
    };

    $scope.updateSelect = function(e) {
        // Nothing to do
    };

    $scope.connComparator = function(sourceCon) {
        var
            source = $scope.findConnection(
            $scope.prepareResponse.usedConnections, sourceCon);
        var sourceType = source && source.type;
        return function(connection) {
            const niceConnectionType = $filter('connectionTypeToNameForList')(connection.type);
            if (connection.type == sourceType) {
                return "AAAAA" + niceConnectionType + "." + connection.name;
            } else {
                return "ZZZZZ" + niceConnectionType + "." + connection.name;
            }
        };
    };

    $scope.codeEnvComparator = function(sourceCodeEnv) {
        var
            source = $scope.findCodeEnv(
            $scope.prepareResponse.usedCodeEnvs, sourceCodeEnv);
        var sourceEnvLang = source && source.envLang;
        return function(codeEnv) {
            if (codeEnv.envLang == sourceEnvLang) {
                return "AAAAA" + codeEnv.envLang + "." + codeEnv.name;
            } else {
                return "ZZZZZ" + codeEnv.envLang + "." + codeEnv.name;
            }
        };
    };

    $scope.findConnection = function(connections, connection) {
        return Array.dkuFindFn(connections, function(c) { return c.name == connection });
    };

    $scope.findCodeEnv = function(codeEnvs, codeEnvName) {
        return Array.dkuFindFn(codeEnvs, function(c) { return c.envName == codeEnvName });
    };

    var abortHook = null;
    $scope.attemptImport = function(){
        Assert.trueish($scope.phase == "READY_TO_IMPORT", 'not ready to import');
        Assert.trueish($scope.uploadResult.id, 'no upload id');

        $scope.phase = "IMPORTING";

        resetErrorInScope($scope);
        DataikuAPI.projects.startImport($scope.uploadResult.id, $scope.importSettings).success(function(initialResponse){
            abortHook = function() {
                DataikuAPI.futures.abort(initialResponse.jobId).error(setErrorInScope.bind($scope));
            };
            FutureWatcher.watchJobId(initialResponse.jobId)
                .success(function(data) {
                    abortHook = null;
                    $scope.futureResponse = null;
                    $scope.importResponse = data.result;
                    if ($scope.importResponse && $scope.importResponse.success){
                        var p2 = $scope.$parent.$parent;
                        $scope.dismiss();
                        Dialogs.infoMessagesDisplayOnly(p2, "Import report", $scope.importResponse).then(function(){
                            $state.transitionTo("projects.project.home.regular", {projectKey : $scope.importResponse.usedProjectKey});
                        });
                    } else {
                        $scope.phase = "READY_TO_IMPORT";

                        // fetch the new manifest in case the migration added some stuff
                        $scope.prepare.enabled = true;
                        prepareImport();
                    }

                }).update(function(data){
                    $scope.percentage =  ProgressStackMessageBuilder.getPercentage(data.progress);
                    $scope.futureResponse = data;
                    $scope.stateLabels = ProgressStackMessageBuilder.build($scope.futureResponse.progress, true);
                }).error(function(data, status, headers) {
                    abortHook = null;
                    $scope.futureResponse = null;
                    $scope.importResponse = null;
                    $scope.phase = "READY_TO_IMPORT";
                    setErrorInScope.bind($scope)(data, status, headers);
                    $timeout(checkProjectKey);
                });
        }).error(function(a,b,c){
            $scope.phase = 'READY_TO_IMPORT';
            setErrorInScope.bind($scope)(a,b,c);
            $scope.importResponse = null;
            $timeout(checkProjectKey);
        });
        WT1.tryEvent("project-import", () => {
            return {
                displayAdvancedOptions : $scope.prepare.enabled,
                nbRemappings : $scope.importSettings.remapping ? $scope.importSettings.remapping.connections ? $scope.importSettings.remapping.connections.length : 0 : 0,
                isInSuggestedFolder: $scope.uiState.targetProjectFolder.id === $scope.defaultProjectFolderId,
                isInRoot: ProjectFolderService.isInRoot($scope.uiState.targetProjectFolder.id),
                isUnderSandbox: ProjectFolderService.isUnderSandbox($scope.uiState.targetProjectFolder),
            };
        });
    }

    $scope.$on("$destroy", function() {
        // cancel import if modal dismissed
        if (abortHook) abortHook();
    });

    $scope.startImport = function(){

        $scope.phase = "UPLOADING";

        DataikuAPI.projects.uploadForImport($scope.importData.file, function(e){
            if (e.lengthComputable) {
                $scope.$apply(function () {
                    $scope.uploadProgress = Math.round(e.loaded * 100 / e.total);
                });
            }
        }).then(function (data) {
            $scope.uploadResult = JSON.parse(data);
            prepareImport();

        }).catch((error) => {
            $scope.phase = '';
            setErrorInScope2.call($scope, error);
        });
    };

    function prepareImport() {
        DataikuAPI.projects.prepareImport($scope.uploadResult.id, $scope.importSettings)
            .success(function(data) {
                $scope.prepareResponse = data;

                $scope.usedConnections = data.usedConnections.map(Fn.prop('name'));
                $scope.usedCodeEnvs = data.usedCodeEnvs.map(Fn.prop('envName'));
                $scope.usedContainerExecConfs = data.usedContainerExecConfs.map(Fn.prop('name'));
                $scope.availableCodeEnvs = [{envLang:'PYTHON', envName:'Builtin', builtin:true}, {envLang:'R', envName:'Builtin', builtin:true}].concat($scope.prepareResponse.availableCodeEnvs);
                $scope.$watch("importSettings.targetProjectKey", checkProjectKey);

                $scope.phase = "READY_TO_IMPORT";
                if (!$scope.prepare.enabled) $scope.attemptImport();
            }).error(setErrorInScope.bind($scope));
    }

    $scope.refreshConnections = function() {
        $scope.prepare.enabled = true;
        prepareImport();
    };

    $scope.refreshCodeEnvs = function() {
        $scope.prepare.enabled = true;
        prepareImport();
    };

    $scope.refreshContainerExecConfs = function() {
        $scope.prepare.enabled = true;
        prepareImport();
    };

    function checkProjectKey(nv) {
        if ($scope.phase != "READY_TO_IMPORT") return;

        var unique;
        if(!$scope.importSettings.targetProjectKey) {
            unique = $scope.allProjectKeys.indexOf($scope.prepareResponse.originalProjectKey) == -1;
        } else {
            unique = $scope.allProjectKeys.indexOf($scope.importSettings.targetProjectKey.toUpperCase().replace(/\W+/g, "")) == -1;
        }
        $scope.importProjectForm.projectKey.$dirty = true;
        $scope.importProjectForm.projectKey.$setValidity("unique", unique);
    }
});

// You MUST call setCurrentProjectFolderId with the appropriate folderId in the link method of CreateModal...
app.controller('DuplicateProjectController', function($scope, DataikuAPI, FutureWatcher, ProgressStackMessageBuilder, WT1, PathUtils, $filter, $state, PromiseService, ProjectFolderService, ProjectFolderContext, $q, $window) {
    $scope.hasPartitionedDataset = false;
    $scope.uniq = true;
    $scope.dupProject = {
        projectKey: "COPY_OF_" + $scope.projectSummary.projectKey,
        name: "Copy of " + $scope.projectSummary.name
    };
    $scope.dupOptions = {
        exportAnalysisModels: true,
        exportSavedModels: true,
        exportGitRepository: $scope.projectSummary.canExportGitRepository,
        exportInsightsData: true,
        duplicationMode: 'UPLOADS_ONLY',
        exportUploads: true,
        exportEditableDatasets: true,
        exportAllInputDatasets: true,
        exportAllInputManagedFolders: true,
        exportAllDatasets: false,
        exportManagedFolders: false,
        exportProjectResources: false,
        exportNotebooksWithOutputs: true,
        exportPromptStudioHistories: true,
        targetProjectFolderId: ProjectFolderContext.getCurrentProjectFolderId() || "",
    };
    $scope.phase = 'READY_TO_DUPLICATE';

    $scope.uiState = {
        showAdvancedOptions: false,
        canExportGitRepository: $scope.projectSummary.canExportGitRepository
    };

    DataikuAPI.projects.listAllKeys()
        .success(function(data) {
            $scope.allProjectKeys = data;
            $scope.$watch("dupProject.name", function(nv, ov) {
                if (!nv) return;
                var slug = nv.toUpperCase().replace(/\W+/g, ""),
                    cur = slug,
                    i = 0;
                while (!isProjectKeyUnique(cur)) {
                    cur = slug + "_" + (++i);
                }
                $scope.dupProject.projectKey = cur;
            });
        })
        .error(setErrorInScope.bind($scope));

    $scope.uiState = {
        targetProjectFolder: null,
        defaultProjectFolderId: null
    };

    $scope.setCurrentProjectFolderId = (folderId) => {
        $scope.dupOptions.targetProjectFolderId = folderId;
        ProjectFolderService.getDefaultFolderForNewProject($scope.dupOptions.targetProjectFolderId).then((folder) => {
            $scope.uiState.targetProjectFolder = folder;
            $scope.uiState.defaultProjectFolderId = folder.id;
            $scope.dupOptions.targetProjectFolderId = folder.id;
        }).catch(setErrorInScope.bind($scope));
    }

    function isProjectKeyUnique(value) {
        return !$scope.allProjectKeys || $scope.allProjectKeys.indexOf(value) < 0;
    }

    $scope.uniq = isProjectKeyUnique($scope.dupProject.projectKey);

    $scope.$watch("dupProject.projectKey", function(nv, ov) {
        $scope.uniq = !nv || isProjectKeyUnique(nv);
    });

    $scope.connComparator = function(sourceCon) {
        var
            source = $scope.findConnection(
            $scope.prepareResponse.usedConnections, sourceCon);
        var sourceType = source && source.type;
        return function(connection) {
            /**
             * Returns the order in which the available connections will be displayed in the selector
             * - high up in the list if the connection types are compatible (so starting with "AAAAA")
             * - last in the list if they are not (starting with "ZZZZZ")
             */
             const niceConnectionType = $filter('connectionTypeToNameForList')(connection.type);
            if (connection.type == sourceType) {
                return "AAAAA" + niceConnectionType + "." + connection.name;
            } else {
                return "ZZZZZ" + niceConnectionType + "." + connection.name;
            }
        };
    };

    $scope.findConnection = function(connections, connection) {
        return Array.dkuFindFn(connections, function(c) { return c.name == connection });
    };

    $scope.refreshConnections = function(projectKey) {
        DataikuAPI.projects.getProjectDatasets(
            projectKey
        ).then(function(initialResponse){
            $scope.prepareResponse = $scope.prepareResponse ? $scope.prepareResponse : {};
            $scope.prepareResponse.usedConnections = [];
            $scope.usedConnections = [];
            for (let requiredConnection in initialResponse.data.requiredConnections) {
                $scope.prepareResponse.usedConnections.push(initialResponse.data.requiredConnections[requiredConnection]);
                $scope.usedConnections.push(initialResponse.data.requiredConnections[requiredConnection].name);
            }
            $scope.hasPartitionedDataset = initialResponse.data.hasPartitionedDataset;
        });

        DataikuAPI.projects.prepareImport('', '')
            .then(function(response) {
                $scope.prepareResponse = $scope.prepareResponse ? $scope.prepareResponse : {};
                $scope.prepareResponse.availableConnections = [];
                response.data.availableConnections.forEach(function(availableConnection){
                    $scope.prepareResponse.availableConnections.push(availableConnection);
                });
            })
    };

    $scope.setDuplicationMode = function(mode) {
        $scope.dupOptions.duplicationMode = mode;
    };

    var abortHook = null;

    $scope.gotoResult = function() {
        $scope.dismiss();
        const targetProjectFolderId = $scope.dupOptions.targetProjectFolderId;
        // When duplicating a project from the project summary page we redirect to the new duplicated project summary page
        // Else we redirect to the projects folder homepage where the project has been duplicated to
        if ($state.includes('projects.project')) {
            $state.go('projects.project.home.regular', { projectKey: $scope.dupProject.projectKey })
        } else {
            $state.go('homeV2.projects.folder', { folderId: targetProjectFolderId }, { reload: true })
        }
    };

    $scope.duplicate = function() {
        $scope.phase = 'DUPLICATING';
        $scope.dupOptions.targetProjectKey = $scope.dupProject.projectKey;
        $scope.dupOptions.targetProjectName = $scope.dupProject.name;
        DataikuAPI.projects.startProjectDuplication(
            $scope.projectSummary.projectKey,
            $scope.dupOptions
        ).success(function(initialResponse){
            abortHook = function() {
                DataikuAPI.futures.abort(initialResponse.jobId).error(setErrorInScope.bind($scope));
            };
            FutureWatcher.watchJobId(initialResponse.jobId).success(function(data){
                abortHook = null;
                $scope.futureResponse = null;
                $scope.duplicateResponse = data.result;
                if (!data.aborted && (data.result.success || data.result.messages == null || data.result.messages.length == 0)) {
                    $scope.gotoResult();
                } else if ((data.result.warning || data.result.error) && !data.result.fatal) {
                    $scope.phase = "SHOW_WARNINGS";
                } else {
                    $scope.phase = "READY_TO_DUPLICATE";
                }
            }).update(function(data){
                $scope.percentage = ProgressStackMessageBuilder.getPercentage(data.progress);
                $scope.futureResponse = data;
                $scope.stateLabels = ProgressStackMessageBuilder.build($scope.futureResponse.progress, true);
            }).error(function(data, status, headers) {
                abortHook = null;
                $scope.futureResponse = null;
                $scope.duplicateResponse = null;
                $scope.phase = "READY_TO_DUPLICATE";
                setErrorInScope.bind($scope)(data, status, headers);
            })
        }).error(function(a,b,c){
            $scope.phase = 'READY_TO_DUPLICATE';
            setErrorInScope.bind($scope)(a,b,c);
            $scope.duplicateResponse = null;
        });
        WT1.tryEvent("project-duplicate", () => {
            return {
                duplicationMode: $scope.dupOptions.duplicationMode,
                exportAnalysisModels: $scope.dupOptions.exportAnalysisModels,
                exportSavedModels: $scope.dupOptions.exportSavedModels,
                exportModelEvaluationStores: $scope.dupOptions.exportModelEvaluationStores,
                exportProjectResources: $scope.dupOptions.exportProjectResources,
                exportGitRepository: $scope.dupOptions.exportGitRepository,
                exportInsightsData: $scope.dupOptions.exportInsightsData,
                isInSuggestedFolder: ($scope.uiState.targetProjectFolder.id === $scope.uiState.defaultProjectFolderId),
                isInRoot: ProjectFolderService.isInRoot($scope.uiState.targetProjectFolder.id),
                isUnderSandbox: ProjectFolderService.isUnderSandbox($scope.uiState.targetProjectFolder),
                nbRemappings: $scope.dupOptions.remapping ? $scope.dupOptions.remapping.connections ? $scope.dupOptions.remapping.connections.length : 0 : 0
            };
        });
    };

    $scope.$on("$destroy", function() {
        // cancel import if modal dismissed
        if (abortHook) abortHook();
    });

    $scope.refreshConnections($scope.projectSummary.projectKey);

    $scope.browse = folderIds => {
        // Use last id in path
        $scope.destination = PathUtils.makeNLNT(folderIds).split('/').pop();
        // browse-path expects a success-error promise so we need to wrap with qToHttp for now (catch() does not return a monkey-patched promise)
        return PromiseService.qToHttp(ProjectFolderService.getBrowseNode($scope.destination).catch(setErrorInScope.bind($scope)));
    };

    $scope.canSelect = item => item.canWriteContents;

    $scope.getProjectFolderName = item => item.name;
});

app.controller('DebuggingToolsController', function($scope, DataikuAPI, $state, $stateParams, Dialogs, $window, OpalsService) {
    $scope.$state = $state;
    $scope.uiState = {};
    $scope.fakeFutureTypes = [];
    $scope.fakeFutureTypes.push({"name":"export from dataset", "payloadClassName":"com.dataiku.dip.export.LocalExportFutureThread", "payloadMethodName":"buildFuturePayload"});
    $scope.fakeFutureTypes.push({"name":"sql query in notebook", "payloadClassName":"com.dataiku.dip.server.services.SQLNotebooksService", "payloadMethodName":"buildFuturePayload"});
    $scope.fakeFutureTypes.push({"name":"sample building", "payloadClassName":"com.dataiku.dip.shaker.SampleBuilder", "payloadMethodName":"buildFuturePayload"});
    $scope.killBackend = function(){
        DataikuAPI.internal.debugKillBackend();
    }
    $scope.getBackendStacks = function(){
        DataikuAPI.internal.debugGetBackendStacks().success(function(data){
            $scope.retdata = data;
        })
    }
    $scope.restartAllHTMLBackends = function(){
        DataikuAPI.internal.restartAllHTMLBackends().success(function(data){
            $scope.retdata = data;
        })
    }
    $scope.runScenarioTriggers = function(){
        DataikuAPI.internal.runScenarioTriggers().success(function(data){
            $scope.retdata = data;
        })
    }
    $scope.insertFakeFuture = function(){
        var f = $scope.uiState.fakeFutureType;
        DataikuAPI.internal.fakeFuture($stateParams.projectKey, f.payloadClassName, f.payloadMethodName, false).success(function(data){
            $scope.retdata = data;
            $scope.uiState.fakeFutureType = null;
        })
    }
    $scope.getTriggerQueueingInfo = function(){
        DataikuAPI.internal.getTriggerQueueingInfo().success(function(data){
            $scope.retdata = data;
        })
    }
    $scope.resyncProjectFolders = () => {
        DataikuAPI.internal.resyncProjectFolders();
    };
    $scope.clearScenarioReportsCaches = function () {
        DataikuAPI.internal.clearScenarioReportsCaches();
    }
    $scope.invalidateEDACaches = function () {
        DataikuAPI.internal.invalidateEDACaches();
    }
    $scope.invalidateDriftCaches = function () {
        DataikuAPI.internal.invalidateDriftCaches();
    }
    $scope.killLLMRequests = function () {
        DataikuAPI.internal.killLLMRequests();
    }
    $scope.killLLMKernels = function () {
        DataikuAPI.internal.killLLMKernels();
    }
    $scope.dumpLLMMesh = function () {
        $window.open(DataikuAPI.internal.dumpLLMMeshURL());
    }
    $scope.dumpLLMCostLimitCounters = function () {
        $window.open(DataikuAPI.internal.dumpLLMCostLimitCountersURL());
    }
    $scope.clearLLMCostLimitCounters = function () {
        DataikuAPI.internal.clearLLMCostLimitCounters();
    }
    $scope.massGenerateLogs = function () {
        DataikuAPI.internal.massGenerateLogs().success(function(data){
            $scope.retdata = data;
        });
    }
    $scope.invalidateConfigCache = function () {
         var options = {type: 'text'};
         Dialogs.prompt($scope, "Invalidate cache", "Path to invalidate", "", options)
                .then(function(path) {
                    DataikuAPI.admin.invalidateConfigCache(path);
                 });
    }
    $scope.invalidateInMemoryAPIKeys = function () {
        DataikuAPI.internal.invalidateInMemoryAPIKeys();
    }
    $scope.listInMemoryAPIKeys = function () {
        DataikuAPI.internal.listInMemoryAPIKeys().success(function(data){
            $scope.retdata = data;
        });
    }
    $scope.reloadTutorials = function () {
         DataikuAPI.internal.reloadTutorials();
    }

    $scope.toggleQaSelectors = function () {
        window.toggleQaSelectors();
    }

    const emptyQuestionnaire = {
        skippedQuestionnaire: false,
        finishedQuestionnaire: false,
        finishedOnboardingChoice: false,
        answers: []
    };

    $scope.resetInProductOnboarding = function () {
        $scope.resetInProductOnboardingNoOpals();
        OpalsService.setLocalStorage('onboardingQuestionnaire', JSON.stringify(emptyQuestionnaire));
        OpalsService.setLocalStorage('prepareTourCompleted', "false");
        OpalsService.setLocalStorage('flowTourCompleted', "false");
        OpalsService.setLocalStorage('exploreTourCompleted', "false");
    }

    $scope.resetInProductOnboardingNoOpals = function () {
        DataikuAPI.profile.setQuestionnaire(emptyQuestionnaire).error(setErrorInScope.bind($scope));
        DataikuAPI.profile.updatePageSpecificTourSettings({}).error(setErrorInScope.bind($scope)); // reset the pageSpecificTour settings to default values by sending an empty object
    }

});

app.controller('TranslationToolsController', function($scope, DataikuAPI, $rootScope, $translate) {
    $scope.dirty = false;
    $scope.dirtyRows = new Map();
    $scope.location = "frontend";
    $scope.language = $rootScope.appConfig.userSettings.uiLanguage || "en";
    $scope.translationTable = [];
    $scope.translationReferences = {};

    function confirmChanges() {
        return confirm("This will discard any unsaved changes. Are you sure?");
    }

    function buildTranslationTable(translations) {
        const translationTable = [];
        const allKeys = new Set(Object.keys(translations)).union(new Set(Object.keys($scope.translationReferences)))
        for (const key of [...allKeys].sort()) {
            translationTable.push({
                key: key,
                reference: $scope.translationReferences[key],
                value: translations[key],
                originalValue: translations[key]
            });
        }
        $scope.translationTable = translationTable;
        $scope.dirty = false;
        $scope.dirtyRows.clear();
    }

    function loadTranslationTable() {
        DataikuAPI.translations.get($scope.location, $scope.language)
            .success(data => buildTranslationTable(data.translations))
            .error(setErrorInScope.bind($scope));
    }

    $scope.markAsDirty = function(row) {
        if (row.value === row.originalValue) {
            $scope.dirtyRows.delete(row.key);
        } else {
            $scope.dirtyRows.set(row.key, row);
        }
        $scope.dirty = ($scope.dirtyRows.size !== 0);
    }
    $scope.save = function() {
        const translations = {};
        for (const translation of $scope.translationTable) {
            translations[translation["key"]] = translation["value"];
        }
        DataikuAPI.translations.save($scope.location, $scope.language, { "translations": translations }).success(function() {
            $scope.dirtyRows.forEach(row => row["originalValue"] = row["value"]);
            $scope.dirty = false;
            $scope.dirtyRows.clear();
            if ($scope.location === "frontend" && $rootScope.appConfig.userSettings.uiLanguage === $scope.language) {
                $translate.refresh();
            }
        }).error(setErrorInScope.bind($scope));
    }
    $scope.upload = function() {
        const uploadFile = $('<input type="file" id="fileUpload" accept=".json" />');
        uploadFile.on("change", () => {
            if (uploadFile[0].files.length > 0) {
                const reader = new FileReader();
                reader.onload = event => {
                    DataikuAPI.translations.save($scope.location, $scope.language, event.target.result, true).success(() => {
                        DataikuAPI.translations.get($scope.location, $scope.language)
                            .success(function(data) {
                                buildTranslationTable(data.translations);
                                if ($scope.location === "frontend" && $rootScope.appConfig.userSettings.uiLanguage === $scope.language) {
                                    $translate.refresh();
                                }
                            }).error(setErrorInScope.bind($scope));
                    }).error(setErrorInScope.bind($scope));
                };
                reader.readAsDataURL(uploadFile[0].files[0]);
            }
        });
        uploadFile.click();
    }
    $scope.onLocationChange = function(ov) {
        if ($scope.dirty && !confirmChanges()) {
            $scope.location = ov;
        }
    }
    $scope.onLanguageChange = function(ov) {
        if ($scope.dirty && !confirmChanges()) {
            $scope.language = ov;
        }
    }
    $scope.onClose = function() {
        if (!$scope.dirty || confirmChanges()) {
            $scope.dismiss();
        }
    }
    $scope.$watch("location", function(nv, ov) {
        if (ov && nv !== ov) {
            DataikuAPI.translations.get($scope.location, "en").success(function(data) {
                $scope.translationReferences = data.translations;
                loadTranslationTable();
            }).error(setErrorInScope.bind($scope));
        }
    });
    $scope.$watch("language", function(nv, ov) {
        if (ov && nv !== ov) {
            loadTranslationTable();
        }
    });

    // Load the initial translation table
    DataikuAPI.translations.get($scope.location, "en").success(function(data) {
        $scope.translationReferences = data.translations;
        loadTranslationTable();
    }).error(setErrorInScope.bind($scope));
});

app.controller("NameFolderCommonController", $scope => {
    $scope.isNameValid = (nameFormInput, isPristineOk) => {
        if (!nameFormInput) {
            return false;
        }
        const name = nameFormInput.$viewValue;
        const isPristine = nameFormInput.$pristine;
        const hasName = name && name.length > 0;
        return (isPristineOk && isPristine) || hasName;
    };
});

app.directive("dkuShow", function($timeout) {
    return {
        scope: false,
        link: function(scope, elem, attrs) {
            let showTimer;
            let delay = parseInt(attrs.delay);
            delay = angular.isNumber(delay) ? delay : 200;

            scope.$watch(attrs.dkuShow, newVal => {
              newVal ? showSpinner() : hideSpinner();
            });

            const showSpinner = () => {
              if (showTimer) {
                  return;
              }
              showTimer = $timeout(showElement.bind(this, true), delay);
            }

            const hideSpinner = () =>  {
              if (showTimer) {
                $timeout.cancel(showTimer);
              }
              showTimer = null;
              showElement(false);
            }

            const showElement = (show) => {
              show ? elem.css({display:''}) : elem.css({display:'none'});
            }
        }
    }
});
}());

;
(function() {
'use strict';

const app = angular.module('dataiku.services', [ 'dataiku.constants' ]);

// Mapping DOMRect to Object for better usability
function getBoundingClientRect(element) {
    const rect = element.getBoundingClientRect();
    return {
        top: rect.top,
        right: rect.right,
        bottom: rect.bottom,
        left: rect.left,
        width: rect.width,
        height: rect.height,
        x: rect.x,
        y: rect.y
    };
}

app.factory("DKUConstants", function($rootScope) {
    const cst = {
        ARCHIVED_PROJECT_STATUS: "Archived",
        design: {
            alertClasses: {
                SUCCESS: 'alert-success',
                FATAL: 'alert-danger',
                ERROR: 'alert-danger',
                WARNING: 'alert-warning',
                INFO: 'alert-info'
            }
        }
    };
    $rootScope.DKUConstants = cst;

    return cst;
});


app.service('AppConfig', function (Logger) {
    let config;
    this.set = function(cfg) {
        Logger.info('Set appConfig')
        config = cfg;
    };
    this.get = function() {
        return config;
    }
});

app.service('FeatureFlagsService', function($rootScope) {
    this.featureFlagEnabled = function(flagName) {
        return $rootScope.appConfig && $rootScope.appConfig.featureFlags.includes(flagName);
    };

    // put in rootScope for easy use in templates
    $rootScope.featureFlagEnabled = this.featureFlagEnabled;
});

app.service('uiCustomizationService', ['$rootScope', 'DataikuAPI', '$q', function($rootScope, DataikuAPI, $q) {
    const datasetTypeStatus = { HIDE: 'HIDE', SHOW: 'SHOW', NO_CONNECTION: 'NO_CONNECTION'};
    let computeDatasetTypeStatusCache = {}; // this is project-dependant, we cache for each project

    this.datasetTypeStatus = datasetTypeStatus;

    // returns a promise resolving into a function (type) => datasetTypeStatus
    this.getComputeDatasetTypesStatus = (scope, projectKey) => {
        if(! computeDatasetTypeStatusCache[projectKey]) {
            const deferred = $q.defer();
            DataikuAPI.datasets.listCreatableDatasetTypes(projectKey).success((datasetTypes) => {
                const uiCustomization = $rootScope.appConfig.uiCustomization; // just a shortcut

                deferred.resolve((type) => {
                    const typeIsIn = (array) => array.indexOf(type) !== -1;

                    // Hive is always hidden if showTraditionalHadoop is unchecked
                    if(!uiCustomization.showTraditionalHadoop && type === 'hiveserver2') {
                        return datasetTypeStatus.HIDE;
                    }

                    if(uiCustomization.hideDatasetTypes && uiCustomization.hideDatasetTypes.length !== 0) {
                        // we hide datasets that are blackListed except if they are allowed by personal connections
                        const isBlackListed = typeIsIn(uiCustomization.hideDatasetTypes);
                        const fromPersonalConnections = typeIsIn(datasetTypes.fromPersonalConnections);
                        if(isBlackListed && !fromPersonalConnections) {
                            return datasetTypeStatus.HIDE;
                        }
                    }

                    if(! uiCustomization.showDatasetTypesForWhichThereIsNoConnection) {
                        // we hide / disable dataset that have no adequate connection available
                        let hasConnection = typeIsIn(datasetTypes.fromAllConnections) || typeIsIn(datasetTypes.outsideOfConnections);

                        // if user is admin we consider all connections are available since he could create them (except UploadedFiles)
                        if($rootScope.isDSSAdmin() && type !== 'UploadedFiles') {
                            hasConnection = true;
                        }
                        // if user can create personal connections, we consider all connections (except UploadedFiles, Filesystem and hiveserver2) are available since he could create them
                        if($rootScope.appConfig.globalPermissions.mayCreateAuthenticatedConnections
                                && type !== 'UploadedFiles' && type !== 'Filesystem' && type !== 'hiveserver2') {
                            hasConnection = true;
                        }

                        if(!hasConnection) {
                            return datasetTypeStatus.NO_CONNECTION;
                        }

                    }

                    return datasetTypeStatus.SHOW;
                });
            }).error(setErrorInScope.bind(scope))
            .catch(() => {
                // In case of API error, we resolve the promise with a filter that will show every dataset type
                // not ideal, but better than showing nothing
                deferred.resolve(() => datasetTypeStatus.SHOW);
            });
            computeDatasetTypeStatusCache[projectKey] = deferred.promise;
        }
        return computeDatasetTypeStatusCache[projectKey];
    }

    // clear the cache when settings are changed.
    $rootScope.$watch(() => $rootScope.appConfig.uiCustomization, () => computeDatasetTypeStatusCache = {});
}]);

    /**
     * ActiveProjectKey is intended to replace explicit references to $stateParams.projectKey references
     * that litter the current code base.  These references make it impossible to use many directives outside
     * of an opened project.
     * The service get() method will return $stateParams.projectKey whenever possible, but when this is not
     * defined it will return a value previously saved via the set() method.
     */
    app.service('ActiveProjectKey', function($stateParams) {
    let explicitProjectKey;
    this.set = function(projectKey) {
        explicitProjectKey = projectKey;
    };
    this.get = function() {
        let key = $stateParams.projectKey;
        if (typeof(key) === 'undefined') key = explicitProjectKey;
        return key;
    }
});

app.factory("TableChangePropagator", function() {
    var svc = {seqId: 0};
    svc.update = function() {
        svc.seqId++;
    };
    return svc;
});

app.factory("executeWithInstantDigest", function($timeout) {
    return function executeWithInstantDigest(fn, scope) {
        $timeout(function(){
            scope.$apply(fn);
        });
    }
});




app.factory("textSize", function() {
    // if text is a string returns its length
    // if text is a list of texts returns the maximum width.
    // if container is not undefined, append it to container
    // element will be added and then remove before any repaint.
    return function(texts, tagName, className, container) {
        if (texts.length === undefined) {
            texts = [texts];
        }
        if (className === undefined) {
            className = "";
        }
        className += " text-sizer";
        if (container === undefined) {
            container = $("body");
        }
        else {
            container = $(container);
        }
        var maxWidth = 0;
        var elements = [];
        for (let i = 0; i < texts.length; i++) {
            let text = texts[i];
            let el = document.createElement(tagName);
            el.className = className;
            let $el = $(el);
            $el.text(text);
            container.append($el);
            elements.push($el);
        }
        ;
        for (let i = 0; i < elements.length; i++) {
            let $el = elements[i];
            maxWidth = Math.max(maxWidth, $el.width());
            $el.remove();
        }
        ;
        return maxWidth;
    }
});


app.factory("CollectionFiltering", function(Fn) {
    // service to filter collection with complex filters
    // i.e. magic around $filter('filter')

    // usage : CollectionFiltering.filter([obj,obj,obj], filterQuery, params)

    // filterQuery is an object that's matched against objects from the list
    // JS objects : {} means a logical AND
    // JS arrays : [] means a logical OR
    // string/Regex properties are then matched against each others with a substr logic

    // ** Parameters **
    // * filterQuery.userQuery : special str property that's matched against all properties of the object
    // *        this filter is cumulative (AND behavior) with regard to other fields in filterQuery,
    // *        but has an OR behavior with regard to the object properties (only needs to match a single field to validate)
    // *        property:value strings are extracted from filterQuery.userQuery and added to the filterQuery object
    // * params.userQueryTargets : single (or list of) dotted property paths to restrict the match of userQuery
    // *                            (except specified property:value patterns in the userQuery, which will bypass this restriction)
    // * params.propertyRules : if you want to give the user shortcuts for properties (replace dict)
    // * params.exactMatch: array of keys for which the search will require an exact match

    // params are enriched with :
    // * params.userQueryResult : a list of Regex+str that where used in the matching (for highlight in list)
    // * params.userQueryErrors : a dict : {str:errMessage} that occurred during parsing

    /**
     * Returns true if the query and obj matches
     *
     * @param query the search term to look for in the object (can be a regex or string)
     * @param obj the object to match
     * @param exactMatch if the string comparison requires an exact match
     *
     * @return {Boolean} true if the search term matches the object
     */
    var matchString = function(query, obj, exactMatch) {
        if (query instanceof RegExp) {
            return query.test(obj);
        } else {
            return !exactMatch ? ('' + obj).toLowerCase().indexOf(query) > -1 : ('' + obj).toLowerCase() === query;
        }
    }

    /**
     * Returns true if the searchTerm matches any allowed property from the specified object
     *
     * @param searchTerm the search term to look for in the object properties
     * @param obj the object on which properties to look
     * @param searchInFields list of allowed fields to search in (absolute paths). if undefined, allows any path
     * @param currentPath current absolute path of the object being tested (used to compare with the allowed paths when matching)
     * @return {Boolean} true if the search term matches any property from the object
     */
    var searchTermMatchesAnyProperty = function(searchTerm, obj, searchInFields, currentPath = '') {
        if (Array.isArray(obj)) {
            // ok if any of the array item matches. array dereference does not 'consume' path
            return obj.some(item => searchTermMatchesAnyProperty(searchTerm, item, searchInFields, currentPath));
        } else if ($.isPlainObject(obj)) {
            // ok if any of the field matches, but if the subpath matches the allowed paths.
            return Object.keys(obj)
                .filter((objKey) => objKey.charAt(0) !== '$' && hasOwnProperty.call(obj, objKey))
                .some((objKey) => {
                    const newPath = currentPath + '.' + objKey;
                    return searchTermMatchesAnyProperty(searchTerm, obj[objKey], searchInFields, newPath);
                });
        } else if (searchTerm instanceof RegExp || ((typeof(searchTerm) === "string" || typeof(searchTerm) === "number") && searchTerm !== "")) {
            return (searchInFields === undefined || searchInFields.some(allowedPath => currentPath.startsWith('.'+allowedPath))) // startsWith because if the match is deep under an allowed path, it's ok
                && matchString(searchTerm, obj);
        } else {
            return true;
        }
    };

    /**
     * Returns true if each word the query matches any property from the specified object (with an AND behaviour)
     * For special syntax (i.e. when you search for tag:tag_name) it must match any value for that specific property
     *
     * @param query an object containing the prepared and clean query of the user
     *        The object usually looks something like :
     *          {
     *             userQuery: '',
     *             tags: [],
     *             interest: {
     *                 starred: '',
     *             },
     *          }
     * @param params the filter params for that query. Contains the properties we want to target, those on which we want an exact match, property shortcuts, etc.
     * @param obj the object we want to search on
     * @param queryArrayIsAND if true and the query is an array, all terms must match a property of obj to return true
     * @param exactMatch true if the two compared strings must be exact match
     *
     * @return {Boolean} true if the query matches any property from the specified object
     */
    var filterFilter = function(query, params, obj, queryArrayIsAND, exactMatch) {
        if (Array.isArray(query)) {
            if (query.length == 0) {
                return true
            }
            if (queryArrayIsAND) {
                return query.every(searchTerm => filterFilter(searchTerm, params, obj, undefined, exactMatch));
            } else {
                return query.some(searchTerm => filterFilter(searchTerm, params, obj, undefined, exactMatch));
            }
        } else if (Array.isArray(obj)) {
            if (obj.length == 0 && query != "") {
                return false;
            }
            return obj.some(value => filterFilter(query, params, value, undefined, exactMatch));
        } else if ($.isPlainObject(obj) || $.isPlainObject(query)) {
            if (!$.isPlainObject(obj)) {
                return false
            }
            if (!$.isPlainObject(query)) {
                return true
            }

            // $requiredSearchTerms must all appear in the object, though not necessarily all in the same field
            if (query.$requiredSearchTerms) {
                const userQueryTargets = params.userQueryTargets
                        ? Array.isArray(params.userQueryTargets) ? params.userQueryTargets : [params.userQueryTargets]
                        : undefined;
                if(!query.$requiredSearchTerms.every(
                    searchTerm => searchTermMatchesAnyProperty(searchTerm, obj, userQueryTargets)
                )) {
                    return false;
                }
            }

            for (var objKey in query) {
                const requiresExactMatch = params.exactMatch && params.exactMatch.includes(objKey);

                if (objKey.charAt(0) !== '$' && objKey !== 'userQuery') {
                    const queryIsNOT = objKey.endsWith("__not");
                    const queryIsAND = objKey.endsWith("__and");
                    if (!queryIsNOT && !queryIsAND
                        && !filterFilter(query[objKey], params, Fn.propStr(objKey)(obj), undefined, requiresExactMatch)) {
                        return false;
                    }
                    if (!queryIsNOT && queryIsAND) {
                        const objValue = Fn.propStr(objKey.substr(0,objKey.length-5))(obj)
                        if (!objValue || !filterFilter(query[objKey], params, objValue, true, requiresExactMatch)) {
                            return false;
                        }
                    }
                    if (queryIsNOT && !queryIsAND) {
                        const objValue = Fn.propStr(objKey.substr(0,objKey.length-5))(obj)
                        if (objValue && filterFilter(query[objKey], params, objValue, undefined, requiresExactMatch)) {
                            return false;
                        }
                    }
                }
            }
            return true;
        } else if (query instanceof RegExp || ((typeof(query) === "string" || typeof(query) === "number") && query !== "")) {
            return matchString(query, obj, exactMatch);
        } else {
            return true;
        }
    };

    var prepareStringKey = function(params, a) {
        if (a.endsWith("/") && a.startsWith("/") && a.length > 2) {
            try {
                return new RegExp(a.substr(1, a.length - 2));
            } catch (err) {
                if (params) {
                    params.userQueryErrors = params.userQueryErrors || {};
                    params.userQueryErrors[a] = err;
                }
                return a;
            }
        } else {
            return a.toLowerCase();
        }
    };

    var cleanFilterQuery = function(obj, params) {
        if ($.isPlainObject(obj)) {
            for (let k in obj) {
                obj[k] = cleanFilterQuery(obj[k], params);
                if (($.isEmptyObject(obj[k]) && !(obj[k] instanceof RegExp) && (typeof obj[k] !== 'boolean')) || obj[k] === "") {
                    delete obj[k]
                }
            }
        } else if ($.isArray(obj)) {
            for (let k = obj.length - 1; k >= 0; k--) {
                obj[k] = cleanFilterQuery(obj[k], params);
                if (($.isEmptyObject(obj[k]) && !(obj[k] instanceof RegExp) && (typeof obj[k] !== 'boolean')) || obj[k] === "") {
                    obj.splice(k, 1)
                }
            }
        } else if (typeof(obj) === "string" || typeof(obj) === "number" || typeof(obj) === "boolean") {
            obj = prepareStringKey(params, ''+obj);
        }
        return obj;
    };


    var translatePropertyName = function(params, propName) {
        if (propName === 'not') {
            return propName
        }
        propName = (params.propertyRules || {})[propName] || propName;
        if (propName.charAt(0) === '-') {
            propName = ((params.propertyRules || {})[propName.substr(1)] || propName.substr(1)) + "__not"
        } else {
            propName = propName + "__and"
        }
        return propName;
    }

    /**
     * Adds the value to the propStr entry (propStr -> value) of obj
     * If it's not an array convert it to an array and add value
     * If value is an array, add each value of array
     *
     * @param obj the object to add the value to
     * @param propStr the property on which to add the value
     * @param value the value to add
     *
     * @return void
     */
    var safePushProp = function(obj, propStr, value) {
        if (!obj || !propStr) {
            return
        }
        var initialValue = Fn.propStrSafe(propStr)(obj);
        if (!$.isArray(initialValue)) {
            if (initialValue) {
                Fn.setPropStr([initialValue], propStr)(obj)
            }
            else {
                Fn.setPropStr([], propStr)(obj)
            }
            initialValue = Fn.propStr(propStr)(obj);
        }
        if ($.isArray(value)) {
            value.forEach(function(o) {
                initialValue.push(o)
            })
        }
        else {
            initialValue.push(value)
        }
    }

    var handleUserQuery = function(filterQuery, params) {
        if (!filterQuery.userQuery) {
            return filterQuery
        }
        var remainingUserQuery = [];
        filterQuery.userQuery.split(" ").filter(function(o) {
            return o !== ""
        }).forEach(function(dottedProp) {
            if (dottedProp.indexOf(':') > -1 && !( dottedProp.startsWith("/") && dottedProp.endsWith("/") )) {
                var fqelem = dottedProp.split(":");
                var propName = translatePropertyName(params, fqelem.shift());
                safePushProp(filterQuery, propName, fqelem.join(":"));
            } else {
                remainingUserQuery.push(dottedProp);
            }
        });
        filterQuery.userQuery = remainingUserQuery.join(" ").trim();

        // prepare the remaining search terms so that we can match them on the object properties
        filterQuery.$requiredSearchTerms = ('' + filterQuery.userQuery).split(" ").filter(a => a != "").map(prepareStringKey.bind(null, null));

        params.userQueryResult = ('' + filterQuery.userQuery).split(" ").filter(a => a).map(prepareStringKey.bind(null, null));
        return filterQuery;
    };

    var handleUserQueryTargets = function(filterQuery, params) {
        if (!params.userQueryTargets || !filterQuery) {
            return filterQuery
        }
        var userQueryTargets = $.isArray(params.userQueryTargets) ? params.userQueryTargets : [params.userQueryTargets];
        // TODO : there should be a proper "summary of the query after the whole processing"

        // Add appropriate filters if user imputed not:something (only applies to userQueryTargets)
        if (filterQuery.not) {
            userQueryTargets.forEach(function(userQueryTarget) {
                safePushProp(filterQuery, userQueryTarget + "__not", filterQuery.not)
            });
            delete filterQuery.not;
        }

        return filterQuery
    };

    var filterWrapper = function(collection, query, params) {
        var filterQuery = angular.copy(query || {});
        if (!params) {
            params = {}
        } else {
            delete params.userQueryErrors;
            delete params.userQueryResult;
        }
        filterQuery = handleUserQuery(filterQuery, params);
        // console.info('HANDLE',JSON.stringify(filterQuery));
        filterQuery = handleUserQueryTargets(filterQuery, params);
        // console.info('TARGETS',JSON.stringify(filterQuery));
        filterQuery = cleanFilterQuery(filterQuery, params);
        // console.info('CLEANED',JSON.stringify(filterQuery));
        return collection.filter(function(o) {
            return filterFilter(filterQuery, params, o);
        });
    };

    return {
        filter: filterWrapper,
    }
});


let algorithmsPaletteColors = [
    "#f07c48", // poppy red (no, it's actually orange)
    "#fdc766", // chicky yellow
    "#7bc9a6", // turquoisy green
    "#4ec5da", // sky blue
    "#548ecb", // sea blue
    "#d848c0", // lilas
    "#41bb15" // some no name green
    //"#97668f", // lilas
    //"#5e2974", // dark purple
];

app.factory("algorithmsPalette", function() {
    var COLORS = algorithmsPaletteColors;
    return function(i) {
        return COLORS[i % COLORS.length];
    }
});


app.factory("categoricalPalette", function() {  // Keep in sync with PaletteFactory/categorical
    var COLORS = [
        "#f06548", // poppy red
        "#fdc766", // chicky yellow
        "#7bc9a6", // turquoisy green
        "#4ec5da", // sky blue
        "#548ecb", // sea blue
        "#97668f", // lilas
        "#5e2974", // dark purple
    ];
    return function(i) {
        return COLORS[i % COLORS.length];
    }
});

app.factory("gradientGenerator", function() {
    function toHexString(n) {
        return Math.round(n).toString(16);
    }
    function toHexColor(c) {
        return `#${toHexString(c.r)}${toHexString(c.g)}${toHexString(c.b)}`;
    }

    return function(hexColor, nbColors) {
        let currentColor = d3.rgb(hexColor);
        const colors = [];
        for (let i = 0; i < nbColors; i++) {
            colors.push(currentColor);
            currentColor = currentColor.brighter(0.05);
        }

        return colors.map(toHexColor);
    }
})

app.factory("divergingPalette", function() {
    /* given a value going from -1 to 1
     returns the color associated by a diverging palette
     going form blue to red. */
    var rgbToHsl = function(s) {
        return d3.rgb(s).hsl();
    };
    var RED_SCALE = ["#fbefef", "#FBDAC8", "#F3A583", "#D75D4D", "#B11F2C"].map(rgbToHsl);
    var BLUE_SCALE = ["#f0f1f1", "#CFE6F1", "#94C5DE", "#4793C3", "#2966AB"].map(rgbToHsl);

    var divergingPalette = function(r) {
        var SCALE = (r > 0) ? RED_SCALE : BLUE_SCALE;
        if (r < 0) {
            r = -r;
        }
        if (r >= 1.) r = 0.99;
        var N = SCALE.length - 1;
        var bucket = r * N | 0;
        var low_color = SCALE[bucket];
        var high_color = SCALE[bucket + 1];
        r = r * N - bucket;
        var h = high_color.h;
        var l = low_color.l * (1 - r) + high_color.l * r;
        var s = low_color.s * (1 - r) + high_color.s * r;
        return d3.hsl(h, s, l);
    };
    return divergingPalette;
});

app.constant("COLOR_PALETTES", {
    highContrast: ['#FFD502', '#02FFFF', '#FF0256', '#02FFD5', '#FF02AB', '#02D5FF', '#2C02FF', '#8102FF', '#022CFF', '#02ABFF', '#FF02D5', '#FF02FF', '#02FF81', '#FF0281', '#F0E704', '#02FFAB', '#5602FF', '#AB02FF', '#CDF600', '#D502FF', '#0256FF', '#FF5602', '#FF8102', '#0281FF', '#FFAB02', '#ABFF02'],
    algorithms: algorithmsPaletteColors
});

app.factory("AnyLoc", function(Assert) {
    // Caution: not in line with backend type AnyLoc
    // On the angular side, to keep in line with server/src/frontend/src/app/utils/loc.ts
    return {
        makeLoc : function(projectKey, localId) {
            return {
                    projectKey: projectKey,
                    localId: localId,
                    fullId: projectKey + "." + localId
            }
        },
        getLocFromSmart: function(contextProjectKey, name) {
            if (name.indexOf(".") >= 0) {
                return {
                    projectKey: name.split(".")[0],
                    localId: name.split(".")[1],
                    fullId: name
                }
            } else {
                return {
                    projectKey: contextProjectKey,
                    localId: name,
                    fullId: contextProjectKey + "." + name
                }
            }
        },
        getLocFromFull: function(fullName) {
            Assert.trueish(fullName.includes('.'), 'no dot in fullname');
            return {
                projectKey: fullName.split(".")[0],
                localId: fullName.split(".")[1],
                fullId: fullName
            };
        },
    }
});

app.factory("AutomationUtils", function() {
    const svc = {
        pythonEnvImportTimeModes: [
            ["INSTALL_IF_MISS", "Create new if not present"],
            ["FAIL_IF_MISS", "Fail if not present"],
            ["DO_NOTHING", "Ignore"]
        ],
        pythonEnvImportTimeModeDescs: [
            "When the bundle declares a dependency on a code env that does not exist on this instance, create a new code env with that name",
            "When the bundle declares a dependency on a code env that does not exist on this instance, stop the preloading",
            "Do not take action if a code env is missing"
        ],
        envImportSpecificationModes: [
            ["SPECIFIED", "User-specified list of packages"],
            ["ACTUAL", "Actual list of packages"]
        ],
        envImportSpecificationModeDescs: [
            "Use the list of packages that the user specified, and the default list of required packages",
            "Use the list of packages built by inspecting the environment"
        ]
    }

    return svc;
});

app.factory("ConnectionUtils", function() {
    const connectionSqlTypes =
        ["hiveserver2", "MySQL", "PostgreSQL", "AlloyDB", "Vertica", "Greenplum", "Redshift", "Teradata", "Oracle", "SQLServer", "Synapse", "FabricWarehouse", "Netezza", "BigQuery", "SAPHANA", "Snowflake", "JDBC", "Athena", "Trino", "Databricks", "DatabricksLakebase", "TreasureData"]; //TODO @datasets remove
    return {
        isIndexable: function(connection) {
            return connection && connection.type && connectionSqlTypes.includes(connection.type);
        }
    }
});

app.factory("DatasetUtils", function(Assert, DataikuAPI, $q, Logger, $rootScope, SmartId, RecipesUtils) {
    const sqlTypes = ["MySQL", "PostgreSQL", "AlloyDB", "Vertica", "Greenplum", "Redshift", "Teradata", "Oracle", "SQLServer", "Synapse", "FabricWarehouse", "Netezza", "BigQuery", "SAPHANA", "Snowflake", "JDBC", "Athena", "Trino", "Denodo", "Databricks", "DatabricksLakebase", "TreasureData"]; //TODO @datasets remove
    const sqlAbleTypes = ["S3"];
    const svc = {
        canUseSQL: function(dataset) {
            if (sqlTypes.indexOf(dataset.type) >= 0 &&
                dataset.params.mode == "table") {
                return true;
            }
            if (sqlAbleTypes.indexOf(dataset.type) >= 0) {
                return true;
            }
            if (dataset.type == "HDFS" || dataset.type == "hiveserver2") {// && $scope.appConfig.impalaEnabled) {
                return true;
            }
            Logger.info("Dataset is not SQL-capable: " + dataset.type);
            return false;
        },

        canUseSparkSQL: function(dataset) {
            if ($rootScope.appConfig.interactiveSparkEngine == "DATABRICKS") {
                return dataset.type == "HDFS";
            } else {
                if (sqlTypes.indexOf(dataset.type) >= 0 && dataset.params.mode == "table") {
                    return false;
                }
                return true;
            }
        },

        hasSizeStatus: function(type) {
            return svc.getKindForConsistency({type: type}) == "files";
        },

        isSQL: function(dataset) {
            return sqlTypes.indexOf(dataset.type) >= 0;
        },

        isSQLTable: function(dataset) {
            return sqlAbleTypes.indexOf(dataset.type) >= 0 ||
                sqlTypes.indexOf(dataset.type) >= 0 && (!dataset.params || dataset.params.mode == "table"); // A bit hackish, when we don't have the params, let's not block functionality
        },

        // Can we run SQL queries on this dataset
        isSQLQueryAble: function(dataset) {
            return sqlAbleTypes.indexOf(dataset.type) >= 0 ||
                sqlTypes.indexOf(dataset.type) >= 0;
        },

        supportsReadOrdering : function(dataset) {
            return svc.isSQLTable(dataset);
        },

        getKindForConsistency : function(dataset) {
            if (sqlTypes.indexOf(dataset.type) >= 0) {
                return "sql";
            } else if (dataset.type == "MongoDB") {
                return "mongodb";
            } else if (dataset.type == "SharePointOnlineList") {
                return "sharepointonlinelist";
            } else if (dataset.type == "DynamoDB") {
                return "dynamodb";
            } else if (dataset.type == "Cassandra") {
                return "cassandra";
            } else if (dataset.type == "Twitter") {
                return "generic";
            } else if (dataset.type == "ElasticSearch") {
                return "generic";
            } else if (dataset.type == "Kafka") {
                return "generic";
            } else if (dataset.type == "SQS") {
                return "generic";
            } else {
                return "files";
            }
        },

        getLocFromSmart: function(contextProjectKey, name) {
            if (name.indexOf(".") >= 0) {
                return {
                    projectKey: name.split(".")[0],
                    name: name.split(".")[1],
                    fullName: name
                };
            } else {
                return {
                    projectKey: contextProjectKey,
                    name: name,
                    fullName: contextProjectKey + "." + name
                };
            }
        },

        getLocFromFull: function(fullName) {
            Assert.trueish(fullName.includes('.'), 'no dot in fullname');
            return {
                projectKey: fullName.split(".")[0],
                name: fullName.split(".")[1],
                fullName: fullName
            };
        },

        getSchema: function(scope, datasetName) {
            return svc.getSchemaFromComputablesMap(scope.computablesMap,datasetName)
        },

        getSchemaFromComputablesMap: function(computablesMap, datasetName) {
            if (!computablesMap || !computablesMap[datasetName]) {
                return;
            }
            var it = computablesMap[datasetName];
            if (!it || !it.dataset) {
                throw Error('dataset is not in computablesMap');
            }
            return it.dataset.schema;
        },

        makeLoc: function(datasetProjectKey, datasetName) {
            return {
                projectKey: datasetProjectKey,
                name: datasetName,
                fullName: datasetProjectKey + "." + datasetName
            };
        },

        makeSmart: function(loc, contextProjectKey) {
            if (loc.projectKey == contextProjectKey) {
                return loc.name;
            } else {
                return loc.fullName;
            }
        },

        makeHeadSelection: function(lines) {
            return {
                partitionSelectionMethod: "ALL",
                samplingMethod: "HEAD_SEQUENTIAL",
                maxRecords: lines
            };
        },

        updateRecipeComputables: function(scope, recipe, projectKey, contextProjectKey) {
            if (!scope.computablesMap) return Promise.resolve();
            let references = new Set(RecipesUtils.getFlatIOList(recipe).map(role => role.ref));
            references = [...references].filter(ref => (ref in scope.computablesMap) && ((scope.computablesMap[ref].dataset && !scope.computablesMap[ref].dataset.schema) || (scope.computablesMap[ref].streamingEndpoint && !scope.computablesMap[ref].streamingEndpoint.schema)));
            return $q.all(references
                .map(name => {
                    let resolvedSmartId = SmartId.resolve(name, contextProjectKey);
                    if (scope.computablesMap[name].dataset) {
                        return DataikuAPI.datasets.get(resolvedSmartId.projectKey, resolvedSmartId.id, contextProjectKey).success(function(data){
                            scope.computablesMap[name].dataset = data;
                        }).error(setErrorInScope.bind(scope));
                    } else if (scope.computablesMap[name].streamingEndpoint) {
                        return DataikuAPI.streamingEndpoints.get(resolvedSmartId.projectKey, resolvedSmartId.id, contextProjectKey).success(function(data){
                            scope.computablesMap[name].streamingEndpoint = data;
                        }).error(setErrorInScope.bind(scope));
                    }
                })
            );
        },

        updateDatasetInComputablesMap: function(scope, dsName, projectKey, contextProjectKey) {
            let resolvedSmartId = SmartId.resolve(dsName, contextProjectKey);
            return DataikuAPI.datasets.get(resolvedSmartId.projectKey, resolvedSmartId.id, contextProjectKey).success(function(data){
                scope.computablesMap[dsName].dataset = data;
            }).error(setErrorInScope.bind(scope));
        },

        listDatasetsUsabilityForAny: function(contextProjectKey) {
            return DataikuAPI.flow.listUsableComputables(contextProjectKey, {
                datasetsOnly: true
            });
        },

        listFoldersUsabilityForOutput : function(contextProjectKey, recipeType) {
            var d = $q.defer();
            DataikuAPI.flow.listUsableComputables(contextProjectKey, {
                datasetsOnly : false,
                forRecipeType : recipeType,
            }).success(function(data) {
                data.forEach(function(x) {
                    x.usable = x.usableAsInput;
                    x.usableReason = x.inputReason;
                });
                d.resolve(data);
            });
            return d.promise;
        },

        listDatasetsUsabilityForInput: function(contextProjectKey, recipeType) {
            var d = $q.defer();
            DataikuAPI.flow.listUsableComputables(contextProjectKey, {
                datasetsOnly: true,
                forRecipeType: recipeType,
            }).success(function(data) {
                data.forEach(function(x) {
                    x.usable = x.usableAsInput;
                    x.usableReason = x.inputReason;
                });
                d.resolve(data);
            });
            return d.promise;
        },

        /**
         * Returns a promise on an arry of two array, "availableInputDatasets" and "availableOutputDataset"
         * On each, the "usable" and "usableReason" are set
         */
        listDatasetsUsabilityInAndOut: function(contextProjectKey, recipeType, datasetsOnly) {
            var d = $q.defer();
            DataikuAPI.flow.listUsableComputables(contextProjectKey, {
                datasetsOnly: datasetsOnly == null ? true : datasetsOnly,
                forRecipeType: recipeType,
            }).success(function(data) {
                var avlIn = angular.copy(data);
                var avlOut = angular.copy(data);
                avlIn.forEach(function(x) {
                    x.usable = x.usableAsInput;
                    x.usableReason = x.inputReason;
                });
                avlOut.forEach(function(x) {
                    x.usable = x.usableAsOutput;
                    x.usableReason = x.outputReason;
                });
                d.resolve([avlIn, avlOut]);
            });
            return d.promise;
        },

        /**
         * Returns a promise on an arry of two array, "availableInputDatasets" and "availableOutputDataset"
         * On each, the "usable" and "usableReason" are set
         */
        listUsabilityInAndOut: function(contextProjectKey, recipeType) {
            var d = $q.defer();
            DataikuAPI.flow.listUsableComputables(contextProjectKey, {
                forRecipeType: recipeType
            }).success(function(data) {
                var avlIn = angular.copy(data);
                var avlOut = angular.copy(data);
                avlIn.forEach(function(x) {
                    x.usable = x.usableAsInput;
                    x.usableReason = x.inputReason;
                });
                avlOut.forEach(function(x) {
                    x.usable = x.usableAsOutput;
                    x.usableReason = x.outputReason;
                });
                d.resolve([avlIn, avlOut]);
            });
            return d.promise;
        },

        isOnDifferentConnection: function (dataset, primaryDatasetConnection) {
            return primaryDatasetConnection && dataset.dataset.params.connection !== primaryDatasetConnection;
        },

        isOutputDataset: function (dataset, recipe, outputDatasetName) {
            return (dataset.dataset.name === outputDatasetName && recipe.projectKey && dataset.dataset.projectKey === recipe.projectKey);
        },

        INVALID_INPUT_DATASET_REASONS: {
            DIFF_CONN: "Dataset connection is different from primary one",
            IS_RECIPE_OUTPUT: "Dataset cannot be the recipe's output"
        },

        /**
         * Mark the recipe output dataset as unusable.
         * Currently used for join input dataset select options.
         * @param datasets
         * @returns Copy of input datasets with the recipe output dataset marked as unusable.
         */
        setInputDatasetsUsability: function (datasets, recipe, outputDatasetName) {
            const availableInputDatasetsForJoin = [];
            for (const originalDataset of datasets) {
                const dataset = angular.copy(originalDataset);
                if (this.isOutputDataset(dataset, recipe, outputDatasetName)) {
                    dataset.usable = false;
                    dataset.usableReason = this.INVALID_INPUT_DATASET_REASONS.IS_RECIPE_OUTPUT;
                }
                availableInputDatasetsForJoin.push(dataset);
            }
            return availableInputDatasetsForJoin;
        }
    };
    return svc;
});


app.factory("Breadcrumb", function($stateParams, $rootScope) {
    var ret = {}
    $rootScope.masterBreadcrumbData = {}

    ret.setProjectSummary = function(projectSummary) {
        $rootScope.currentProjectSummary = projectSummary;
    }

    ret.setData = function(k, v) {
        $rootScope.masterBreadcrumbData[k] = v;
    }

    ret.projectBreadcrumb = function() {
        return [
            //{ "type" : "home" },
            {"type": "project", "projectKey": $stateParams.projectKey}
        ]
    }
    ret.datasetBreadcrumb = function() {
        return ret.projectBreadcrumb().concat([
            //{"type" : "datasets", projectKey : $stateParams.projectKey},
            {
                "type": "dataset", projectKey: $stateParams.projectKey, id: $stateParams.datasetName,
                displayName: $stateParams.datasetName
            }
        ]);
    }
    ret.recipeBreadcrumb = function() {
        return ret.projectBreadcrumb().concat([
            {"type": "recipes", projectKey: $stateParams.projectKey},
            {
                "type": "recipe", projectKey: $stateParams.projectKey, id: $stateParams.recipeName,
                displayName: $stateParams.recipeName
            }
        ]);
    }
    ret.insightBreadcrumb = function(insightName) {
        return ret.projectBreadcrumb().concat([
            {"type": "insights", "projectKey": $stateParams.projectKey},
            {
                "type": "insight",
                "projectKey": $stateParams.projectKey,
                "id": $stateParams.insightId,
                displayName: insightName
            }
        ]);
    }

    ret.set = function(array) {
        $rootScope.masterBreadcrumb = array;
    }

    ret.setWithProject = function(array) {
        ret.set(ret.projectBreadcrumb().concat(array));
    }
    ret.setWithDataset = function(array) {
        ret.set(ret.datasetBreadcrumb().concat(array));
    }
    ret.setWithInsight = function(insightName, array) {
        ret.set(ret.insightBreadcrumb(insightName).concat(array));
    }
    ret.setWithRecipe = function(array) {
        ret.set(ret.recipeBreadcrumb().concat(array));
    }
    ret.setWith
    return ret;
});


app.service('LocalStorage', ['$window', function($window) {
    return {
        set: function(key, value) {
            if (value !== undefined) {
                $window.localStorage[key] = JSON.stringify(value);
            }
        },
        get: function(key) {
            var ret = $window.localStorage[key];
            if (ret !== undefined) {
                ret = JSON.parse(ret);
            }
            return ret;
        },
        clear: function(key) {
            delete $window.localStorage[key];
        }
    }
}]);


app.service('RemoteResourcesLinksUtils', function() {
    const svc = this;

    svc.getSageMakerResourceLink = function(resource, region, resourceName) {
        return `https://${region}.console.aws.amazon.com/sagemaker/home#/${resource}/${resourceName}`;
    }

    svc.getVertexAIResourceLink = function(resource, project, location, resourceId) {
        return `https://console.cloud.google.com/vertex-ai/locations/${location}/${resource}/${resourceId}?project=${project}`;
    }

    const getWsid = function(workspace, resourceGroup, subscription) {
        return `wsid=/subscriptions/${subscription}/resourcegroups/${resourceGroup}/providers/Microsoft.MachineLearningServices/workspaces/${workspace}`;
    }

    const getTid = function(tenantId) {
        return (tenantId) ? `tid=${tenantId}` : '';
    }

    svc.getAzureMLReference = function(resourceName, resourceVersion) {
        return `azureml:${resourceName}:${resourceVersion}`;
    }

    svc.getAzureMLModelLink = function(resourceInfo) {
        const wsid = getWsid(resourceInfo.azWorkspace, resourceInfo.azResourceGroup, resourceInfo.azSubscription);
        const tid = '&' + getTid(resourceInfo.azTenantId);
        return `https://ml.azure.com/model/${resourceInfo.azModelName}:${resourceInfo.azModelVersion}/details?${wsid}${tid}`;
    }

    svc.getAzureMLEnvironmentLink = function(resourceInfo) {
        const wsid = getWsid(resourceInfo.azWorkspace, resourceInfo.azResourceGroup, resourceInfo.azSubscription);
        const tid = '&' + getTid(resourceInfo.azTenantId);
        return `https://ml.azure.com/environments/${resourceInfo.azEnvironmentName}/version/${resourceInfo.azEnvironmentVersion}?${wsid}${tid}`;
    }

    svc.getAzureMLOnlineEndpointLink = function(resourceInfo) {
        const wsid = getWsid(resourceInfo.azWorkspace, resourceInfo.azResourceGroup, resourceInfo.azSubscription);
        const tid = '&' + getTid(resourceInfo.azTenantId);
        return `https://ml.azure.com/endpoints/realtime/${resourceInfo.azOnlineEndpointName}?${wsid}${tid}`;
    }

    svc.getDatabricksEndpointLink = function(host, endpointName) {
        return `https://${host}/ml/endpoints/${endpointName}`;
    }

    svc.getDatabricksModelLink = function(host, isUnityCatalogUsed, modelName) {
        if (isUnityCatalogUsed) {
            const [catalogName, schemaName, unityCatalogModelName] = modelName.split(".");
            return `https://${host}/explore/data/models/${catalogName}/${schemaName}/${unityCatalogModelName}`;
        }
        return `https://${host}/ml/models/${modelName}`;
    }

    svc.getDatabricksModelVersionLink = function(host, isUnityCatalogUsed, modelName, modelVersion) {
        const modelLink = svc.getDatabricksModelLink(host, isUnityCatalogUsed, modelName);
        if (isUnityCatalogUsed) {
            return `${modelLink}/version/${modelVersion}`;
        }
        return `${modelLink}/versions/${modelVersion}`;
    }

    svc.getDatabricksExperimentLink = function(host, expId) {
        return `https://${host}/ml/experiments/${expId}`;
    }

    svc.getDatabricksExperimentRunLink = function(host, expId, runId) {
        return `https://${host}/ml/experiments/${expId}/runs/${runId}`;
    }
});

app.factory("ContextualMenu", function($compile, $rootScope, $templateCache, $window, $http) {
        // Class describing a menu.
        // Can be used for both contextual menu and
        // regular menues.
        //
        function Menu(params) {
            /*
             Contextual or not, only one menu can be visible at the same time
             on the screen.
             The contextual menu content does not live in the DOM until it is displayed
             to the user.

             Parameters contains the following options
             - template (required) : template path for the content of the menu.
             - controller (optional) : name of the controller
             - scope  (optional) : if not added, a new scope will be created.
             - contextual (option, true|false, default:true
             in contextual menu mode, all clicks outside of the
             popup is captured.
             - onOpen (optional): called on menu open
             - onClose (optional): called on menu close
             - cssClass: CSS class on the ul
             */
            this.template = params.template;
            if (typeof this.template != "string") {
                throw "Template parameter is required";
            }
            this.cssClass = params.cssClass;
            this.controller = params.controller;
            this.contextual = params.contextual;
            if (this.contextual === undefined) {
                this.contextual = true;
            }
            this.enableClick = params.enableClick;
            if (this.enableClick === undefined) {
                this.enableClick = false;
            }
            this.handleKeyboard = params.handleKeyboard;
            if (this.handleKeyboard === undefined) {
                this.handleKeyboard = true;
            }
            this.scope = params.scope;
            this.tmplPromise = $http.get(this.template, {cache: $templateCache});
            this.onClose = params.onClose || function() {
                };
            this.onOpen = params.onOpen || function() {
                };
        }

        Menu.prototype.newScope = function() {
            if (this.scope) {
                return this.scope.$new();
            }
            else {
                return $rootScope.$new(true);
            }
        };

        Menu.prototype.globalOnClose = function() {
        };
        Menu.prototype.globalOnOpen = function() {
        };

        // close any popup currently visible on the screen.
        Menu.prototype.closeAny = function(e) {
            // remove and unbind any overlays
            Menu.prototype.$overlay.unbind("click");
            Menu.prototype.$overlay.unbind("contextmenu");
            Menu.prototype.$overlay.remove();

            // remove the document click
            $(document).off(".closeMenu");

            Menu.prototype.$menu.remove();
            Menu.prototype.globalOnClose();
            Menu.prototype.globalOnClose = function() {
            };
            Menu.prototype.globalOnOpen = function() {
            };
            Menu.prototype.$menu.removeClass();
            Menu.prototype.$menu.addClass('dropdown-menu');
            if (e) e.preventDefault();
            return false;
        };

        Menu.prototype.setup = function($menu) {
            var me = this;

            Menu.prototype.globalOnClose = this.onClose;
            Menu.prototype.globalOnOpen = this.onOpen;
            var index = -1;
            var currentMenu = Menu.prototype.$menu;

            if (me.contextual) {
                $menu.before(Menu.prototype.$overlay);
                $(Menu.prototype.$overlay).bind("contextmenu", me.closeAny.bind(me));
                Menu.prototype.$overlay.click(me.closeAny.bind(me));
            } else {
                window.setTimeout(function() {
                    // handle click when menu is open
                    $(document)
                        .on('click.closeMenu', function(evt) {
                            const targetParents = $(evt.target).parents();
                            const isClickedOutsideMenu = targetParents.index(Menu.prototype.$menu) === -1;
                            // Dropdown panels can be appended in the body but clicking in a dropdown panel shouldn't close a contextual menu.
                            const isClickedElementADropdownItem = targetParents.toArray().some(parent => parent.className.includes('ng-dropdown-panel'));
                            if (isClickedOutsideMenu && !isClickedElementADropdownItem) {
                                Menu.prototype.closeAny();
                            }
                        });
                }, 0);
            }
            if (!me.enableClick) {
                $menu.on('click.ctxmenu', function(e) {
                    me.closeAny();
                });
            }

            window.setTimeout(function() {
                // makes the links focusable
                Menu.prototype.$menu.find('a').attr('tabindex', -1);
                // focus on the first link
                const items = Menu.prototype.$menu.find('a');
                if (items.length > 0) {
                    const item = items.eq(0);
                    const parentMenus = item.parents('ul');
                    if (parentMenus.length > 0) {
                        currentMenu = parentMenus.eq(0);
                        index = 0;
                        item.focus();
                    }
                }

                var handleKey = function(evt) {
                    if (Menu.prototype.$menu.height()) {
                        if (evt.which === 27) {
                            // esc
                            Menu.prototype.closeAny();
                        }

                        const isTargetInMenu = $(evt.target).parents().index(currentMenu) !== -1; // Only process events when the target is an item of the menu
                        if (isTargetInMenu) {
                            if (evt.which === 40) {
                                // down
                                const items = currentMenu.find('>li>a');
                                if (items.length) {
                                    index = Math.min(items.length - 1, index + 1);
                                    items[index].focus();
                                }
                                evt.preventDefault();
                                evt.stopPropagation();
                            }
                            if (evt.which === 38) {
                                // up
                                index = Math.max(0, index - 1);
                                const items = currentMenu.find('>li>a, >*>li>a');
                                if (items.length) {
                                    items[index].focus();
                                }
                                evt.preventDefault();
                                evt.stopPropagation();
                            }

                            if (evt.which === 37) {
                                // left
                                // Go up one menu
                                if (currentMenu != Menu.prototype.$menu) {
                                    index = currentMenu.parents('ul').eq(0).find('>li>a').index(currentMenu.parent('li.hover').removeClass('hover').find('>a'));
                                    currentMenu = currentMenu.parents('ul').eq(0);
                                    const items = currentMenu.find('>li>a');
                                    if (items.length) {
                                        items[index].focus();
                                    }
                                }
                                evt.preventDefault();
                                evt.stopPropagation();
                            }
                            if (evt.which === 39) {
                                // right
                                // go into submenu
                                const items = currentMenu.find('>li>a');
                                const submenus = items.eq(index).siblings('ul');
                                if (submenus.length) {
                                    items.eq(index).parent().addClass('hover');
                                    currentMenu = submenus.eq(0);
                                    index = 0;
                                    currentMenu.find('a').eq(0).focus();
                                }
                                evt.preventDefault();
                                evt.stopPropagation();
                            }
                            if (evt.which === 13) {
                                // enter
                                currentMenu.find('>li>a').eq(index).trigger('click');
                                Menu.prototype.closeAny();
                            }
                        }
                    }
                };
                if (me.handleKeyboard) {
                    $(document).on('keydown.closeMenu', handleKey); // handle keypress while the menu doesn't have the focus
                    Menu.prototype.$menu.on('keydown', handleKey);
                }
                Menu.prototype.$menu.on('mouseenter', 'a', function(e) {
                    Menu.prototype.$menu.find('.hover').removeClass('hover');
                    currentMenu = $(this).parents('ul').eq(0);
                    const items = currentMenu.find('>li>a')
                    index = items.index($(this));
                    if (index !== -1) {
                        items[index].focus(); // Set focus to current item, making it the target for keyboard events
                    }
                });

            });
        };

        // Fill the shared menu element with menu instance
        // content.
        //
        // Template is compiled against the scope
        // at each call.
        //
        Menu.prototype.fill = function(cb) {
            var me = this;
            this.tmplPromise.success(function(tmplData) {
                if (me.controller !== undefined) {
                    me.$menu.attr("ng-controller", me.controller);
                }
                else {
                    me.$menu.removeAttr("ng-controller");
                }
                me.$menu.html(tmplData);
                Menu.prototype.destroyCurrentScope();
                var newScope = me.newScope();
                $compile(me.$menu)(newScope);
                Menu.prototype.currentScope = newScope;
                if (cb !== undefined) {
                    cb(me.$menu);
                }
                if (me.cssClass) {
                    me.$menu.addClass(me.cssClass);
                }
            });
        };

        Menu.prototype.destroyCurrentScope = function() {
            if (Menu.prototype.currentScope != undefined) {
                Menu.prototype.currentScope.$destroy();
            }
            Menu.prototype.currentScope = undefined;
        };

        Menu.prototype.openAlignedWithElement = function(alignElement, callback, followScroll, exactAlignment) {
            var me = this;
            me.closeAny();
            me.fill(function($menu) {
                // place the element.
                var $body = $("body");
                var $alignElement = $(alignElement);
                var alignElementOffset = $alignElement.offset();
                var scrollOffsetLeft = alignElementOffset.left;
                var scrollOffsetTop = alignElementOffset.top;

                var box = $alignElement.offset();
                box.width = $alignElement.width();
                box.height = $alignElement.outerHeight();
                $body.append($menu);
                var left = Math.max(0, box.left - (exactAlignment ? 0 : 10));

                // we also want to move the dropdown menu to the left
                // to stay on the screen.
                var menuWidth = $menu.width();
                var bodyWidth = $body.width();

                $menu.detach();

                left = Math.min(left, bodyWidth - menuWidth - 10);

                if (bodyWidth - left - menuWidth < 180) {
                    // let's step into bizarro land
                    // where submenues open to the left.
                    $menu.addClass("bizarro");
                }
                else {
                    $menu.removeClass("bizarro");
                }

                var position = {
                    left: left,
                    top: box.top + box.height,
                    bottom: "auto",
                    right: "auto"
                };

                let containerElement = $body;

                if (followScroll) {
                    containerElement = $(alignElement).offsetParent();
                    const alignElementPosition = $alignElement.position();
                    scrollOffsetLeft = alignElementPosition.left - box.left;
                    scrollOffsetTop = alignElementPosition.top - box.top;
                    position.left += scrollOffsetLeft;
                    position.top += scrollOffsetTop;
                }

                $menu.appendTo(containerElement);
                $menu.css(position);

                me.setup($menu);
                if (callback !== undefined) {
                    callback($menu);
                }
                Menu.prototype.globalOnOpen();
            });
        };

        Menu.prototype.openAtXY = function(left, top, callback, dummyLateralPosition, dummyVerticalPosition) {
            var me = this;
            me.closeAny();
            me.fill(function($menu) {
                $("body").append($menu);
                var offset = {};
                if (left < $($window).width() / 2 || dummyLateralPosition) {
                    offset.left = left;
                    offset.right = 'auto';
                } else {
                    offset.left = 'auto';
                    offset.right = $($window).width() - left;
                }
                if (top < $($window).height() / 2 || dummyVerticalPosition) {
                    offset.top = top;
                    offset.bottom = 'auto';
                } else {
                    offset.top = 'auto';
                    offset.bottom = $($window).height() - top;
                }
                $menu.css(offset);
                me.setup($menu);
                if (callback !== undefined) {
                    callback($menu);
                }
                Menu.prototype.globalOnOpen();
            });
        };

        Menu.prototype.openAtEventLoc = function (evt) {
            if (!evt) return;
            this.openAtXY(evt.pageX, evt.pageY);
        }

        // TODO get rid of the id
        Menu.prototype.$menu = $('<ul id="dku-contextual-menu" class="dropdown-menu" style="position:absolute" role="menu">');
        // overlay element that helps capturing any click
        // outside of the menu.
        // Used in ContextualMenu mode.
        Menu.prototype.$overlay = $('<div class="contextualMenuOverlay"></div>');
        // Menu.prototype.$overlay

        return Menu;
    });


app.factory("ActivityIndicatorManager", ["$timeout", function($timeout) {
    function hide(activityIndicator) {
        activityIndicator.hidden = true;
    }

    function getActivityIndicatorType(type) {
        switch (type) {
            case 'waiting':
            case 'info':
                return 'progress';
            case 'success':
                return 'success';
            case 'warning':
                return 'warning';
            case 'error':
                return 'error';
            default:
                throw new Error('Unknown type: ' + type);
        }
    }

    return {
        hide,
        /**
         *
         * @param {ActivityIndicator} activityIndicator
         * @param {'waiting' | 'success' | 'warning' | 'info' | 'error'} type
         * @param {string} text
         * @param {number} time
         * @param {boolean?} faded
         * @param {{ label: string, callback: () => void, icon?: string }} action
         */
        configureActivityIndicator: function (activityIndicator, type, text, time, faded = true, action) {
            activityIndicator.hidden = false;
            activityIndicator.text = text;
            activityIndicator.type = getActivityIndicatorType(type);
            activityIndicator.faded = faded;
            activityIndicator.action = action;
            activityIndicator.hide = () => hide(activityIndicator);

            if (type === 'waiting') {
                activityIndicator.spinner = true;
            } else {
                activityIndicator.spinner = false;
                if (!time) {
                    time = 2000;
                }
                if(activityIndicator.pending) {
                    $timeout.cancel(activityIndicator.pending);
                }
                activityIndicator.pending = $timeout(function () {
                    activityIndicator.pending = undefined;
                    hide(activityIndicator);
                }, time);
            }
        },
        buildDefaultActivityIndicator: function() {
            return {
                pending: undefined,
                hidden: true,
                text: '',
                type: 'progress',
                spinner: false,
                faded: true
            };
        },
        isDisplayed: function(activityIndicator) {
            return !activityIndicator.hidden;
        }
    };
}]);

app.factory("ActivityIndicator", ["$rootScope", "ActivityIndicatorManager", function($rootScope, ActivityIndicatorManager) {
    $rootScope.activityIndicator = ActivityIndicatorManager.buildDefaultActivityIndicator();
    return {
        isDisplayed: function() {
            return ActivityIndicatorManager.isDisplayed($rootScope.activityIndicator)
        },
        waiting: function(text) {
            ActivityIndicatorManager.configureActivityIndicator($rootScope.activityIndicator, 'waiting', text);
        },
        hide: function() {
            ActivityIndicatorManager.hide($rootScope.activityIndicator);
        },
        success: function(text, time, action) {
            ActivityIndicatorManager.configureActivityIndicator($rootScope.activityIndicator,'success', text, time, true, action);
        },
        warning: function(text, time, action) {
            ActivityIndicatorManager.configureActivityIndicator($rootScope.activityIndicator,'warning', text, time, true, action);
        },
        info: function(text, time, action) {
            ActivityIndicatorManager.configureActivityIndicator($rootScope.activityIndicator,'info', text, time, true, action);
        },
        error: function(text, time, action) {
            ActivityIndicatorManager.configureActivityIndicator($rootScope.activityIndicator,'error', text, time, true, action);
        }
    };
}]);

app.factory("ChartActivityIndicator", ["ActivityIndicatorManager", function(ActivityIndicatorManager) {
    return {
        buildDefaultActivityIndicator: function () {
            return ActivityIndicatorManager.buildDefaultActivityIndicator()
        },
        displayBackendError: function (chartActivityIndicator, errorMessage) {
            ActivityIndicatorManager.configureActivityIndicator(chartActivityIndicator, 'error', errorMessage, 5000, false);
        }
    };
}]);

app.factory("APIXHRService", ["$rootScope", "$http", "$q", "Logger", "HistoryService", function($rootScope, $http, $q, Logger, HistoryService) {
    $rootScope.httpRequests = [];

    var unloadingState = false;

    $(window).bind("beforeunload", function() {
        unloadingState = true;
    });

    // Return a proxified promise that can be disabled
    function disableOnExit(promise) {

        function isEnabled() {
            return !unloadingState;
        }

        var deferred = $q.defer();

        // $q promises
        promise.then(function(data) {

                if (isEnabled()) {
                    deferred.resolve(data);
                }
            },
            function(data) {
                if (isEnabled()) {
                    deferred.reject(data);
                }
            },
            function(data) {
                if (isEnabled()) {
                    deferred.notify(data);
                }
            });

        // $http specific
        if (promise.success) {
            deferred.promise.success = function(callback) {
                promise.success(function(data, status, headers, config, statusText, xhrStatus) {
                    if (isEnabled()) {
                        callback(data === 'null' ? null : data, status, headers, config, statusText, xhrStatus);
                    }
                });
                return deferred.promise;
            };
        }

        if (promise.error) {
            promise.error(function(data, status, headers) {
                var apiError = getErrorDetails(data, status, headers);
                Logger.error("API error: ", apiError.errorType + ": " + apiError.message);
            })
            deferred.promise.error = function(callback) {
                promise.error(function(data, status, headers, config, statusText, xhrStatus) {
                    if (isEnabled()) {
                        callback(data, status, headers, config, statusText, xhrStatus);
                    }
                });
                return deferred.promise;
            };
        }

        if (promise.noSpinner) {
            deferred.promise.noSpinner = promise.noSpinner;
        }

        return deferred.promise;
    }

    return function(method, url, data, spinnerMode, contentType, timeoutPromise) {
        var headers = {
            'Content-Type': contentType === 'json' ? 'application/json;charset=utf-8' : 'application/x-www-form-urlencoded;charset=utf-8'
        };
        var versionIdHeader = "version-id";

        if ($rootScope.versionId && !isAbsoluteURL(url)) {
            headers[versionIdHeader] = $rootScope.versionId;
        }

        var start = new Date().getTime();
        Logger.debug("[S] " + method + ' ' + url);

        var params = {
            method: method,
            url: url,
            headers: headers,
            transformRequest: function(data) {
                // Transform data based on the content type
                if (contentType === 'json') {
                    return angular.isObject(data) ? JSON.stringify(data) : data;
                } else {
                    return angular.isObject(data) && String(data) !== '[object File]' ? jQuery.param(data) : data;
                }
            },
        };
        if ($rootScope.appConfig) {
            params.xsrfCookieName = $rootScope.appConfig.xsrfCookieName;
        }
        if (method == 'GET') {
            params.params = data;
        } else {
            params.data = data;
        }
        if (timeoutPromise) {
            params.timeout = timeoutPromise;
        }

        var promise = $http(params);
        var disableSpinner = spinnerMode && spinnerMode == "nospinner";

        var logDone = function(result) {
            var end = new Date().getTime();
            var backendTime = null;
            if (result != null && result.headers != null) {
                backendTime = result.headers("DKU-Call-BackendTime");
            }
            Logger.debug("[D] " + method + ' ' + url + " (" + (end - start) + "ms)" + (backendTime == null ? null : " (bkd=" + backendTime + ")"));

        }
        promise.then(logDone, logDone);

        if (!disableSpinner) {
            promise.spinnerMode = spinnerMode;
            $rootScope.httpRequests.push(promise);

            var removeRequest = function(result) {
                var idx = $rootScope.httpRequests.indexOf(promise);
                if (idx != -1) $rootScope.httpRequests.splice(idx, 1);
            };

            promise.noSpinner = function() {
                removeRequest();
                safeApply($rootScope);
                return promise;
            };

            promise.spinner = function(enable = true) {
                if (enable === false) {
                    promise.noSpinner();
                }
                return promise;
            };

            promise.then(removeRequest, removeRequest);
        }

        function isAbsoluteURL(url) {
            try {
                new URL(url);
            } catch (e) {
                if (e instanceof TypeError) {
                    return false;
                } else {
                    throw e;
                }
            }
            return true;
        }

        function retrieveVersionId(result) {
            if (result.headers) {
                const versionId = result.headers(versionIdHeader)

                if (versionId && !$rootScope.versionId) {
                    $rootScope.versionId = versionId;
                }
            }
        }

        promise.then(retrieveVersionId, retrieveVersionId);

        function promptRefreshOnVersionMismatch(result) {
            if (result.headers) {
                const promptRefresh = Boolean(result.headers("version-mismatch-refresh-prompt"));
                const backendVersionId = result.headers(versionIdHeader);

                if (promptRefresh && $rootScope.versionId &&
                    $rootScope.versionId !== $rootScope.promptRefreshFromVersionId &&
                    backendVersionId !== $rootScope.promptRefreshFromVersionId) {
                    $rootScope.promptRefresh = promptRefresh;
                    $rootScope.promptRefreshFromVersionId=backendVersionId;
                }
            }
        }

        promise.then(promptRefreshOnVersionMismatch, promptRefreshOnVersionMismatch);


        if (method=="POST") HistoryService.recordItemPost(url, data);

        return app.addSuccessErrorToPromise(promise);
    };
}]);


app.factory("CreateModalFromDOMElement", function(CreateModalFromHTML) {
    return function(selector, scope, controller, afterCompileCallback) {
        return CreateModalFromHTML($(selector).html(), scope, controller, afterCompileCallback, false);
    };
});

app.factory("CreateModalFromTemplate", function(CreateModalFromHTML, $http, $templateCache, $q) {
    /**
     * Callback for preparing the modal scope
     *
     * @callback afterCompileCallback
     * @param {Object} modalScope the initialized modal scope
     * @returns {void}
     */


    /**
     * Create a modal popup from a template
     *
     * @param {String} location path to the modal HTML template
     * @param {Object} scope The scope variable that can be passed along and used in the controller
     * @param {String} controller The name of the controller that the modal scope should inherit from during initialization
     * @param {afterCompileCallback} afterCompileCallback an anonymous function that will be executed after the controller initialization
     * @param noFocus
     * @param backdrop can be 'true', 'false' or 'static' (check bootstrap documentation) or custom 'confirm' value (in this case a click on the backdrop will be treated as a confirmation on the modal)
     * @param keyboard
     */
    return function(location, scope, controller, afterCompileCallback, noFocus, backdrop, keyboard) {
        var deferred = $q.defer();
        $q.when($templateCache.get(location) || $http.get(location, {cache: true})).then(function(template) {
            if (angular.isArray(template)) {
                template = template[1];
            } else if (angular.isObject(template)) {
                template = template.data;
            }
            deferred.resolve(CreateModalFromHTML(template, scope, controller, afterCompileCallback, noFocus, backdrop, keyboard));
        });
        return deferred.promise;
    }
});

/**
 * Create a modal from an AngularJS component
 *
 * Usage:
 *
 *  CreateModalFromComponent(injectedComponentDirective, {
 *       paramOne: ...,
 *       paramTwo: ...,
 *  }, ['custom-modal-class-1', 'custom-modal-class-2']);
 *
 *  1) 'paramOne' & 'paramTwo' will be respectively bound to the 'param-one' and 'param-two' inputs of the component
 *  2) 'injectedComponentDirective' is the component's directive
 *     /!\ For a component('myComponent') you need to inject 'myComponentDirective' (AngularJS magically appends a 'Directive' suffix to all components names)
 *  3) the 3rd parameter is an optional array of CSS classes to add to the modal (for example, 'modal-wide')
 */
app.factory("CreateModalFromComponent", function(CreateModalFromHTML, $rootScope) {
    function camelToKebab(input) {
        return input.replace(/([A-Z])/g, function($1){return "-"+$1.toLowerCase();});
    }

    function getComponentTagName(component) {
        return camelToKebab(component[0].name); // Lol
    }

    return function(component, params, customClasses) {
        const newScope = $rootScope.$new(true);
        const tagName = getComponentTagName(component);
        let html = '<div class="modal modal3';
        if (customClasses) {
            for (let customClass of customClasses) {
                html += ` ${customClass}`;
            }
        }
        html += '"><' + tagName + ' ';
        for (let p in params) {
            newScope[p] = params[p];
            html += camelToKebab(p) + "=" + '"' + p + '" ';
        }
        html += 'modal-control="modalControl"'
        html += '></'+tagName+ '><div>';
        const promise = CreateModalFromHTML(html, newScope, null, function($scope, element) {
            newScope.modalControl = {
                resolve: value => $scope.resolveModal(value),
                dismiss: () => $scope.dismiss()
            }
        });
        return promise;
    }
});

app.factory("CreateModalFromHTML", function($timeout, $compile, $q, $rootScope) {
    let activeModals = [];

    $rootScope.$on('dismissModals', function() {
        activeModals.forEach((modalScope)=> unregisterModal(modalScope));
    });

    function registerModal(modalScope) {
        activeModals.unshift(modalScope);
    }

    function unregisterModal(modalScope) {
        activeModals = activeModals.filter((activeModalScope)=> {
            if(modalScope == activeModalScope) {
                modalScope.dismiss();
                return false;
            }
            return true;
        });
    }

    return function(template, scope, controller, afterCompileCallback, noFocus, backdrop, keyboard) {
        var deferred = $q.defer();
        var newDOMElt = $(template);
        if (controller != null) {
            newDOMElt.attr("ng-controller", controller);
        }
        newDOMElt.addClass("ng-cloak");

        const $existingModal = $('div.modal-container');
        let stackedClass = "";
        let waitForTransition = 0;
        if ($existingModal.length>0) {
            $existingModal.addClass('aside').removeClass('restored'); //move aside any existing modal in case of stacking
            waitForTransition = 250;
            stackedClass = "new-stacked"
        }

        var wrapper = $("<div>").addClass("modal-container " + stackedClass).append(newDOMElt);
        $("body").append(wrapper);

        if(scope.fromAngularContext === true) {
            wrapper.addClass("modal-container--from-angular");
        }

        $timeout(function() {
            var newScope = scope.$new();
            $compile(newDOMElt)(newScope);

            var modalScope = angular.element(newDOMElt).scope();

            if (afterCompileCallback) {
                modalScope.$apply(afterCompileCallback(modalScope, newDOMElt));
            }
            newDOMElt.on('hidden', function(e){
                if (e.target == newDOMElt.get(0)) {
                    unregisterModal(modalScope);
                    wrapper.remove();
                    modalScope.$destroy();
                    if (deferred != null) {
                        deferred.reject("modal hidden");
                        deferred = null;
                    }
                }
            });

            var prepareForModalStack = function () {
                $('div.modal-backdrop').addClass('modal-rollup').removeClass('non-see-through'); //mjt in the event of stacking a modal
                $("div.modal-container.new-stacked").addClass("modal-stacked-on-top").removeClass("new-stacked");
            }
            prepareForModalStack();

            if (backdrop) {
                 newDOMElt.attr('data-backdrop', backdrop === 'confirm' ? 'static' : backdrop);
            }

            newDOMElt.modal("show");
            $rootScope.$broadcast("dismissPopovers");

            modalScope.unwindModalStack = function (newDOMElt) {
                $('div.modal-backdrop.modal-rollup').removeClass('modal-rollup').click(modalScope.dismiss);
                $('div.modal-container.aside').removeClass('aside').addClass('restored'); //move aside any existing modal in case of stacking
            };
            modalScope.dismiss = function() {
                newDOMElt.modal("hide");
                if (deferred != null) {
                    deferred.reject("dismissed modal");
                    deferred = null;
                }
            };

            registerModal(modalScope);

            modalScope.resolveModal = function(value) {
                if (deferred != null) {
                    deferred.resolve(value);
                    deferred = null;
                }
                newDOMElt.modal("hide");
            };
            modalScope.$modalScope = modalScope;

            $(newDOMElt).on('hide.bs.modal', function (e) {
                if (modalScope && modalScope.canCloseModal && typeof modalScope.canCloseModal === 'function') {
                    if (!modalScope.canCloseModal()) {
                        e.preventDefault();
                        e.stopImmediatePropagation();
                        return false;
                    }
                }
                modalScope.unwindModalStack(newDOMElt);
            });

            if (backdrop === 'confirm') {
                // a click on the backdrop will be treated as a confirmation
                     $(".modal-backdrop").on('click', function() {
                            modalScope.confirm();
                    });
            }

            modalScope.$on("dismissModal", modalScope.dismiss);

            if (!noFocus) {
                // the first form of the modal, should contain the modal-body in 99% of cases
                var firstForm = newDOMElt.find('form').first();
                // list of focusable elements we want to try, in order of preference
                var focusCandidateFinders = [];
                focusCandidateFinders.push(function() {
                    return firstForm.find('input[type="text"]:not([readonly])').first();
                });
                focusCandidateFinders.push(function() {
                    return firstForm.find('button:submit').first();
                });
                focusCandidateFinders.push(function() {
                    return firstForm.find('button:button').first();
                });
                // if the modal has no form, or footer buttons are not in the form, look in the full modal
                focusCandidateFinders.push(function() {
                    return newDOMElt.find('input[type="text"]:not([readonly])').first();
                });
                focusCandidateFinders.push(function() {
                    return newDOMElt.find('button:submit').first();
                });
                focusCandidateFinders.push(function() {
                    return newDOMElt.find('button:button').first();
                });
                focusCandidateFinders.push(function() {
                    return newDOMElt.find('.close').first();
                });

                var focusCandidate;
                for (var i = 0; i < focusCandidateFinders.length; i++) {
                    var focusCandidateFinder = focusCandidateFinders[i];
                    focusCandidate = focusCandidateFinder().not('.no-modal-autofocus');
                    if (focusCandidate.length > 0) {
                        focusCandidate.focus();
                        // in some cases the element is disabled by a ng-disabled, and the focus behavior becomes a bit erratic
                        // so for safety we focus once more
                        $timeout(function() {
                            focusCandidate.focus();
                        });
                        break;
                    }
                }

                // in case the submit button is dangerous, prevent submit-on-enter
                if (firstForm.length > 0 && focusCandidate.hasClass('btn--danger')) { //NOSONAR: focusCandidate always initialized thanks to jquery first() specs
                    focusCandidate.bind("keydown keypress", function(event) {
                        if (event.which === 13) {
                            event.preventDefault();
                        }
                    });
                }
            }
        }, waitForTransition);

        return deferred.promise;
    };
});


/**
 * Create a custom body-attached DOM element within a new scope.
 * The new scope is fitted with a "dismiss" function, which destroys the DOM
 * element and the scope.
 */
app.factory("CreateCustomElementFromTemplate", ["$http", "$timeout", "$compile", "$templateCache", "$q", "$window",
    function($http, $timeout, $compile, $templateCache, $q, $window) {
        return function(location, scope, controller, afterCompileCallback, domInsertionCallback) {
            $q.when($templateCache.get(location) || $http.get(location, {cache: true})).then(function onSuccess(template) {
                if (angular.isArray(template)) {
                    template = template[1];
                } else if (angular.isObject(template)) {
                    template = template.data;
                }
                var newDOMElt = $(template);
                if (controller != null) {
                    newDOMElt.attr("ng-controller", controller);
                }

                if (domInsertionCallback != null) {
                    domInsertionCallback(newDOMElt);
                } else {
                    $("body").append(newDOMElt);
                }

                /* Now, compile the element, set its scope, call the callback */
                $timeout(function() {
                    var newScope = scope.$new();
                    $compile(newDOMElt)(newScope);
                    var newScope2 = angular.element(newDOMElt).scope();

                    if (afterCompileCallback) {
                        newScope2.$apply(afterCompileCallback(newScope2));
                    }
                    newScope2.$on("dismissModalInternal_", function() {
                        $timeout(function() {
                            newScope2.dismiss();
                        }, 0);
                    });
                    newScope2.dismiss = function() {
                        newDOMElt.remove();
                        newScope2.$destroy();
                    };
                    scope.$on("$destroy", newScope2.dismiss);
                });
            });
        };
    }
]);


/** Keeps a map of promises for static API calls */
app.factory("CachedAPICalls", function(DataikuAPI, Assert, $http, $rootScope, $q, translate, $translate) {
    var deferredLogin = $q.defer();
    var whenLoggedIn = deferredLogin.promise;

    let staticData = app.addSuccessErrorToPromise(whenLoggedIn.then(() => DataikuAPI.staticData.getStaticData($translate.proposedLanguage())));

    return {
        notifyLoggedIn: () => {
            deferredLogin.resolve();
        },
        processorsLibrary: app.addSuccessErrorToPromise(whenLoggedIn.then(() => DataikuAPI.shakers.getProcessorsLibrary($translate.proposedLanguage()).success(function(processors) {
            processors.deprecatedTypes = [];

            // Inject the doc link at this point so it is only done once.
            processors.processors.forEach(function(p) {
                if (p.docPage) {
                    p.help += "\n\n" + translate("SHAKER.PROCESSORS.HELP.MORE_INFO",
                        "For more info, <a target=\"_blank\" href=\"{{docPageUrl}}\">please see the processor's reference</a>",
                        { docPageUrl: $rootScope.versionDocRoot + "preparation/processors/" + p.docPage + ".html"})
                        + "\n";
                }

                if (p.deprecated) {
                    processors.deprecatedTypes.push(p.type);

                    var deprecationMsg = "### " + translate("SHAKER.PROCESSORS.HELP.DEPRECATED", "This processor is deprecated.");
                    if (p.replacementDocLink) {
                        var replacementLink = $rootScope.versionDocRoot + p.replacementDocLink + ".html";
                        var replacementOptions = p.replacementName ? (p.replacementName + " options") : "options";
                        deprecationMsg += ` Please see <a target="_blank" href="${replacementLink}">our documentation</a> for our newer ${replacementOptions}.`;
                    }
                    p.help = deprecationMsg + "\n\n---\n\n" + p.help;
                    p.enDescription = "<span class=\"deprecation-tag\">"+ translate("SHAKER.PROCESSORS.DESCRIPTION.DEPRECATED", "[DEPRECATED]") + " </span>" + p.enDescription;
                }
            });

            return processors
        }))),
        staticData: staticData,
        customFormulasFunctions: staticData.then(resp => resp.data.customFormulasFunctions),
        udafCustomFormulasFunctions: staticData.then(resp => resp.data.udafCustomFormulasFunctions),
        customFormulasReference: staticData.then(resp => resp.data.customFormulasReference),
        udafCustomFormulasReference: staticData.then(resp => resp.data.udafCustomFormulasReference),
        datasetCommonCharsets: staticData.then(resp => resp.data.datasetCommonCharsets),
        datasetFormatTypes: staticData.then(resp => resp.data.datasetFormatTypes),
        datasetTypes: staticData.then(resp => resp.data.datasetTypes),
        pmlGuessPolicies: staticData.then(resp => resp.data.pmlGuessPolicies),
        cmlGuessPolicies: staticData.then(resp => resp.data.cmlGuessPolicies),
        timezonesList: staticData.then(resp => resp.data.timezonesList),
        timezonesShortList: staticData.then(resp => resp.data.timezonesShortList),
        webAppTypes: staticData.then(resp => resp.data.webAppTypes),
        mlCommonDiagnosticsDefinition: staticData.then(resp => resp.data.mlCommonDiagnosticsDefinition),
        pmlDiagnosticsDefinition: staticData.then(resp => function(backendType, predictionType) {
            const backendTypeNullable = backendType === null ? undefined : backendType;
            const matchingItem = resp.data.pmlDiagnosticsDefinition.find((item) => item.backendType === backendTypeNullable && item.predictionType === predictionType);
            return !matchingItem ? {} : matchingItem.definitions;
        }),
        cmlDiagnosticsDefinition: staticData.then(resp => function(backendType) {
            const backendTypeNullable = backendType === null ? undefined : backendType;
            const matchingItem = resp.data.cmlDiagnosticsDefinition.find((item) => item.backendType === backendTypeNullable);
            return !matchingItem ? {} : matchingItem.definitions;
        }),
        flowIcons: $http.get("/static/dataiku/flow-iconset.json"),
        emojisTable: $http.get("/static/third/emoji.json").then(function(response) {
            Assert.trueish(response.data, 'No emoji returned');
            Assert.trueish(angular.isArray(response.data), 'Emojis were not returned as an array');
            const emojisTable = {};
            response.data.forEach(function(x) {
                emojisTable[x['sn']] = x['code'].split('-').map(x => '&#x' + x + ';').join('');
            });
            return emojisTable;
        })
    };
});


app.service('ComputablesService', function(CreateModalFromTemplate, DataikuAPI, TaggableObjectsUtils, Dialogs) {
    this.clear = function(scope, taggableItems) {
        return CreateModalFromTemplate("/templates/taggable-objects/clear-data-modal.html", scope, null, function(modalScope) {
            modalScope.taggableItems = taggableItems;
            modalScope.itemsType = TaggableObjectsUtils.getCommonType(taggableItems, it => it.type);

            modalScope.confirm = function() {
                DataikuAPI.taggableObjects.clear(taggableItems).success(function(data) {
                    if (data.anyMessage && !data.success) {
                        modalScope.dismiss();
                        Dialogs.infoMessagesDisplayOnly(scope, "Clear result", data);
                    } else {
                        modalScope.resolveModal(data);
                    }
                }).error(setErrorInScope.bind(scope));
            }
        });
    };
});


app.service('DatasetsService', function($rootScope, $q, DataikuAPI, Logger, Notification, ComputablesService, FutureProgressModal, CreateModalFromTemplate, FlowGraph) {
    const svc = this;

    const listsWithAccessiblePerProject = {};

    svc.listWithAccessible = function(projectKey) {
        if (listsWithAccessiblePerProject[projectKey] == null) {
            listsWithAccessiblePerProject[projectKey] = DataikuAPI.datasets.listWithAccessible(projectKey);
        }
        return listsWithAccessiblePerProject[projectKey];
    };

    svc.clear = function(scope, projectKey, datasetName) {
        return ComputablesService.clear(scope, [{
            type: 'DATASET',
            projectKey: projectKey,
            id: datasetName,
            displayName: datasetName
        }]);
    };

    svc.refreshSummaries = function (scope, selectedItems, computeRecords = true, forceRecompute = false, displayErrorsInFlow = false) {
        const deferred = $q.defer();
        DataikuAPI.datasets.refreshSummaries(selectedItems, computeRecords, forceRecompute).success(function (data) {
            FutureProgressModal.show(scope, data, "Refresh datasets status")
                .then(data => deferred.resolve(data), data => deferred.reject(data));
        }).error(displayErrorsInFlow ? FlowGraph.setError() : setErrorInScope.bind(scope));
        return deferred.promise;
    };

    svc.setVirtualizable = function(scope, selectedItems, virtualizable) {
        const datasets = selectedItems.filter(it => it.type == 'DATASET');
        return DataikuAPI.datasets.setVirtualizable(datasets, !!virtualizable)
            .error(setErrorInScope.bind(scope));
    };

    svc.startSetAutoCountOfRecords = function(selectedItems) {
        return CreateModalFromTemplate("/templates/datasets/set-auto-count-of-records-modal.html", $rootScope, null, function(modalScope) {
            modalScope.autoCountOfRecords = false;

            modalScope.ok = function(vitualizable) {
                svc.setAutoCountOfRecords(selectedItems, modalScope.autoCountOfRecords)
                    .then(modalScope.resolveModal, setErrorInScope.bind(modalScope));
            };
        });
    };

    svc.setAutoCountOfRecords = function(selectedItems, autoCountOfRecords) {
        return DataikuAPI.datasets.setAutoCountOfRecords(selectedItems, autoCountOfRecords);
    };

    Notification.registerEvent("datasets-list-changed", function(evt, message) {
        Logger.info("Datasets list changed, updating");
        delete listsWithAccessiblePerProject[message.projectKey]; // just invalidate
    });
});

/** Cached access to datasets information */
app.factory("DatasetInfoCache", function($stateParams, DataikuAPI, $q, Notification, Logger) {
    // Cache for results of datasets/get
    var simpleCache = {}
    Notification.registerEvent("websocket-status-changed", function() {
        Logger.info("Websocket status change, dropping dataset cache");
        simpleCache = {};
    });
    Notification.registerEvent("datasets-list-changed", function(evt, message) {
        Logger.info("Datasets list changed, dropping cache for ", message.projectKey);
        delete simpleCache[message.projectKey];
    });
    var svc = {
        getSimple: function(projectKey, name) {
            var projectCache = simpleCache[projectKey];
            if (projectCache != null) {
                var data = projectCache[name];
                if (data != null) {
                    Logger.info("Cache hit: " + projectKey + "." + name);
                    return $q.when(data);
                }
            } else {
                simpleCache[projectKey] = {};
            }
            Logger.info("Cache miss: " + projectKey + "." + name);
            return DataikuAPI.datasets.get(projectKey, name, $stateParams.projectKey).then(function(data) {
                simpleCache[projectKey][name] = data.data;
                return data.data;
            });
        }
    }
    return svc;
});

// Queue
//
// var lockable = Queue();
// lockable.exec(function() { alert('A'); }); // Executed right now
// var unlock = lockable.lock(); // Lock the object
// lockable.exec(function() { alert('B'); }); // Not executed
// lockable.exec(function() { alert('C'); }); // Not executed
// unlock(); // Execute alert('A') & alert('B');
//
// The queue can be tied to a promise
// lockable.lockOnPromise(DataikuAPI.xxx(yyy,zzz).success(function() {
//     ...
// }));
//
app.factory("Queue", function() {

    return function() {

        var semaphore = 0;
        var queue = [];
        var destroyed = false;
        var scopeUnregisterer = undefined;
        var inside = false;

        var processQueue = function() {
            while (!destroyed && semaphore == 0 && queue.length > 0) {
                if (!inside) {
                    try {
                        inside = true;
                        queue.splice(0, 1)[0]();
                    } finally {
                        inside = false;
                    }
                } else {
                    break;
                }
            }
        };

        var exec = function(fn) {
            if (fn && !destroyed) {
                queue.push(fn);
                processQueue();
            }
        };

        var destroy = function() {
            destroyed = true;
            queue = [];
        };

        var wrap = function(func) {
            return function() {
                var args = arguments;
                exec(function() {
                    if (func) {
                        func.apply(null, args);
                    }
                });
            };
        };

        var lock = function() {
            if (destroyed) {
                return;
            }
            semaphore++;
            var unlocked = false;
            return function() {
                if (!unlocked) {
                    semaphore--;
                    unlocked = true;
                    processQueue();
                }
            };
        };

        var ret = {

            withScope: function(scope) {
                if (scopeUnregisterer) {
                    scopeUnregisterer();
                }
                if (scope) {
                    scopeUnregisterer = scope.$on('$destroy', destroy);
                }
                return ret;
            },
            locked: function() {
                return destroyed || semaphore > 0;
            },
            exec: function(fn) {
                exec(fn);
            },
            wrap: function(fn) {
                return wrap(fn);
            },
            lockOnPromise: function(promise) {
                if (promise && promise['finally']) {
                    var unlocker = lock();
                    promise['finally'](function() {
                        unlocker();
                    });
                }
                return promise;
            },
            lock: function() {
                return lock();
            }
        };
        return ret;
    };

});
// DeducedMonoFuture
//
// - Manages API calls that return a future, ensuring only one is active at a time.
// - If a new call is made while another is running, it queues the new call.
// - Any previously queued call is discarded, ensuring only the most recent request is executed next.
// - Effectively debounces rapid calls, processing them sequentially.
//
// Usage :
//
// var future = DeducedMonoFuture(scope); // If a scope is passed, it handles automatic cleanup.
// var apiCall = future.wrap(DataikuAPI.xxx.getYYYFuture);
//
// // This will be executed. If called again quickly, the new call will wait.
// apiCall(zzz).success(function(data) {
//     // ...
// }).error(...);
//
//
app.factory("DeducedMonoFuture", ["$q", "DataikuAPI", "Throttle", function($q, DataikuAPI, Throttle) {
    const rejectionPayload = {
                data: { aborted: true, reason: "Superseded by new call" },
                status: -1, // Custom status for client-side abort
                // This is the fully compatible dummy function.
                headers: function(key) {
                    return key ? null : {};
                }
            };
    // The factory returns this function, which now accepts the same arguments as the original.
    return function(scope, spinner = true, delay = 1000) {
        let isBusy = false;
        let pendingCall = null;
        let currentCall = null; // Tracks the currently active call, including its jobId for polling
        // Aborts any pending or currently polling operation.
        const abort = function() {
            if (pendingCall) {
                pendingCall.deferred.reject(rejectionPayload);
                pendingCall = null;
            }
            if (currentCall && currentCall.jobId) {
                DataikuAPI.futures.abort(currentCall.jobId, spinner);
                currentCall.deferred.reject(rejectionPayload);
                currentCall = null;
            }
        };

        // This function handles the polling, using the 'delay' parameter.
        const refreshFutureState = Throttle().withDelay(delay).wrap(function() {

            if (!currentCall || currentCall.hasResult || !currentCall.jobId) {
                return;
            }

            DataikuAPI.futures.getUpdate(currentCall.jobId).success(function(data) {

                if (data.hasResult) {
                    currentCall.hasResult = true;
                    // The final result is in the 'data' from the poll, not the initial response.
                    currentCall.deferred.resolve(data);
                } else {
                    currentCall.deferred.notify(data); // Notify of progress
                    refreshFutureState(); // Poll again
                }
            }).error(function(err) {
                currentCall.hasResult = true;
                currentCall.deferred.reject(err);
            });
        });

        const wrap = function(apiFunc) {
            const wrappedExecutor = function(...args) {
                const deferred = $q.defer();

                if (isBusy) {
                    // Queue the latest call, rejecting any previously pending one.

                    if (pendingCall) {
                        pendingCall.deferred.reject(rejectionPayload);
                    }
                    pendingCall = { func: apiFunc, args: args, deferred: deferred };
                } else {
                    // Execute immediately.
                    isBusy = true;
                    currentCall = { deferred: deferred, hasResult: false, jobId: null };

                    const apiPromise = apiFunc.apply(null, args);
                    apiPromise.success(function(initialData) {
                        if (initialData.hasResult) {
                            // The API returned the final result immediately.
                            currentCall.hasResult = true;
                            deferred.resolve(initialData);
                        } else {
                            // The API returned a job ID. We must poll for the result.
                            currentCall.jobId = initialData.jobId;
                            refreshFutureState();
                        }
                    }).error(function(err) {
                        currentCall.hasResult = true;
                        deferred.reject(err);
                    });
                }

                // This .finally() block ensures the queue is processed after a promise completes.
                deferred.promise.finally(function() {
                    // This check ensures we only proceed if this was the 'current' call.
                    if (currentCall && currentCall.deferred === deferred) {
                        isBusy = false;
                        currentCall = null;

                        if (pendingCall) {
                           const nextCall = pendingCall;
                           pendingCall = null;
                           // Immediately execute the next item from the queue.
                           wrappedExecutor.apply(null, nextCall.args)
                                .then(nextCall.deferred.resolve, nextCall.deferred.reject);
                        }
                    }
                });

                // Add .success and .error for compatibility with the calling code.
                deferred.promise.success = function(fn) {
                    deferred.promise.then(function(data) { fn(data); });
                    return deferred.promise;
                };
                deferred.promise.error = function(fn) {
                    deferred.promise.then(null, function(data) { fn(rejectionPayload); });
                    return deferred.promise;
                };

                return deferred.promise;
            };
            return wrappedExecutor;
        };

        // Listen for scope destruction to clean up.
        if (scope && scope.$on) {
            scope.$on('$destroy', abort);
        }

        return {
            wrap: wrap,
            abort: abort
        };
    };
}]);


function enrichFuturePromise(promise) {
    promise.success = function(fn) {
        promise.then(function(data) {
            fn(data.data, data.status, data.headers);
        });
        return promise;
    };

    promise.error = function(fn) {
        promise.then(null, function(data) {
            fn(data.data, data.status, data.headers);
        });
        return promise;
    };

    promise.update = function(fn) {
        promise.then(null, null,function(data) {
            fn(data.data, data.status, data.headers);
        });
        return promise;
    };
    return promise;
}

// MonoFuture
//
// - Wait for future result
// - Abort the previous future as soon as a new one is started
//
// Usage :
//
// var monoFuture = MonoFuture(scope); // If a scope is passed, life time of monofuture = life time of the scope
// monoFuture.exec(DataikuAPI.xxx.getYYYFuture(zzz)).success(function(data) {
// ...
// }).update(function(data) {
// ...
// }).error(...);
//
//  OR by wrapping the DataikuAPI function directly
//
//  var apiCall = MonoFuture().wrap(DataikuAPI.xxx.getYYYFuture);
//  apiCall(zzz).success(...);
//
//
//

app.factory("MonoFuture", ["$q", "DataikuAPI", "Throttle", function($q, DataikuAPI, Throttle) {

    return function(scope, spinner=true, delay=1000) {

        var promises = [];
        var destroyed = false;

        // Refresh the state of the last promise
        var refreshFutureState = Throttle().withDelay(delay).wrap(function() {

            updateInternalState();

            if (promises.length > 0) {
                var last = promises[promises.length - 1];
                if (!last.hasResult && !last.waiting) {
                    last.waiting = true;
                    DataikuAPI.futures.getUpdate(last.id).success(function(data, status, headers) {

                        last.waiting = false;
                        last.result = {data: data, status: status, headers: headers};
                        if (data.hasResult) {
                            last.hasResult = true;
                        } else {
                            if (!last.aborted) {
                                last.deferred.notify(last.result);
                            }
                            refreshFutureState();
                        }

                        updateInternalState();

                    }).error(function(data, status, headers) {

                        last.failed = true;
                        last.result = {data: data, status: status, headers: headers};
                        last.hasResult = true;
                        last.waiting = false;

                        updateInternalState();
                    });
                }
            }
        });

        // Update current state
        var updateInternalState = function() {
            // Abort all abortable futures & remove them
            var loop = false;
            do {
                loop = false;
                for (var i = 0; i < promises.length; i++) {
                    var isLast = i == (promises.length - 1);
                    var promise = promises[i];
                    promise.aborted |= !isLast;
                    if (promise.aborted && !promise.waiting) {

                        // We have the future id, and not the result meaning that the future is running
                        if (promise.id && !promise.hasResult) {
                            // Abort me
                            DataikuAPI.futures.abort(promise.id, spinner);
                        }

                        promises.splice(i, 1);
                        loop = true;
                        break;
                    }
                }
            } while (loop);

            // Check last one : finished?
            if (promises.length > 0) {
                var last = promises[promises.length - 1];
                if (last.hasResult && !last.aborted) {
                    promises.splice(promises.length - 1, 1);
                    if (last.failed) {
                        last.deferred.reject(last.result);
                    } else if (last.result && last.result.data && last.result.data.aborted) {
                        // The future has been aborted by someone
                        last.deferred.reject(last.result);
                    } else {
                        last.deferred.resolve(last.result);
                    }
                }
            }
        };

        var fakePromise = function() {
            var promise = $q.defer().promise;
            promise.success = function() {
                return promise;
            };
            promise.error = function() {
                return promise;
            };
            promise.update = function() {
                return promise;
            };
            return promise;
        };

        var exec = function(apiPromise) {
            if (destroyed || !apiPromise || !apiPromise.success) {
                return fakePromise();
            }
            var deferred = $q.defer();
            var promise = {
                id: null,
                hasResult: false,
                result: undefined,
                deferred: deferred,
                aborted: false,
                failed: false,
                waiting: true,
                noSpinner: apiPromise.noSpinner
            };
            promises.push(promise);
            updateInternalState();
            apiPromise.success(function(data, status, headers) {
                promise.waiting = false;
                promise.result = {data, status, headers};
                if (data) {
                    promise.id = data.jobId;
                }
                if (data.hasResult) {
                    promise.hasResult = true;
                } else {
                    refreshFutureState();
                }
                updateInternalState();
            }).error(function(data, status, headers) {
                promise.failed = true;
                promise.result = {data, status, headers};
                if (data) {
                    promise.id = data.jobId;
                }
                promise.hasResult = true;
                promise.waiting = false;
                updateInternalState();
            });

            enrichFuturePromise(deferred.promise);

            deferred.promise.noSpinner = function() {
                promises.forEach(function(p) {
                    if (p.noSpinner) p.noSpinner();
                });
                return deferred.promise;
            };

            return deferred.promise;
        };

        var abort = function() {
            if (promises.length > 0) {
                promises[promises.length - 1].aborted = true;
                updateInternalState();
            }
        };

        var destroy = function() {
            abort();
            destroyed = true;
        };

        const active = function() {
            return promises.length > 0;
        };

        if (scope && scope.$on) {
            scope.$on('$destroy', destroy);
        }

        return {

            exec: exec,
            wrap: function(func) {
                return function() {
                    return exec(func.apply(func, arguments));
                };
            },
            abort: abort,
            destroy: destroy,
            active: active,
            destroyed: () => destroyed
        };
    };
}]);


/* MonoFuturePool
    Wrapper around MonoFuture that allows a bunch of related monofutures to run sequencially, while keeping the throttled behavior from DeducedMonoFuture on each one
    API is mostly the same as for the MonoFuture, except: exec makes no sense for the pool you have to use wrap, and the returned promise doesn't have the noSpinner method.

   Example: imagine you have this kind of stuff in a component:

    const wrapper = MonoFuture(scope).wrap(DataikuApi.blah.blah);
    $scope.$watch('someApiParams', (nv) => {
        $scope.something = wrapper(nv)
    });

    And there are 20 instances of this component => you may have many future running in parallel, one for each component

    Using:
    // in some shared place
    const pooledMonoFuture = MonoFuturePool(scope);

    ...

    //in each component
    const wrapper = pooledMonoFuture.createMonoFuture(scope, false).wrap(DataikuApi.blah.blah);
    $scope.$watch('someApiParams', (nv) => {
        $scope.something = wrapper(nv)
    });

    Future calls from each component will be queued and only one will run at once.
    If any of the components triggers a new call (someApiParams changed) while a future is running, it will be put on hold to be executed once the running query is done. If any of the component triggers a new call while it already has a call on hold, the previous one is dropped and replaced by the new one.

    Timeline example:
    - Component 1 triggers a future with call A1 => api call is done & progress is tracked
    - Component 2 triggers a future with call A2 => put on hold
    - Component 3 triggers a future with call A3 => put on hold
    - Component 3 triggers a future with call B3 => put on hold, A3 is dropped
    - API call A1 is done => API call A2 is triggered and and progress is tracked
    - API call A2 is done => API call B3 is triggered and and progress is tracked

    key points:
    - only one future is in progress at any time
    - A3 has been dropped before even started because it has been discarded by B3
    - The results obtained by each component is no different than what they would have got independantly, except for the longer delay.

    When the pool is created with a scope, all child MonoFutures are destroyed when this scope is destroyed
    When a child MonoFuture is created with a scope, it's destroyed when this scope is destroyed (and releases the lock for the others when applicable)
    It is possible to use both scope-based auto-destroy at the same time (if the Pool is bound to a component but each MonoFuture to one of many chilren for example)
*/

app.factory("MonoFuturePool", ["$q", "$timeout", "MonoFuture", "Queue", function($q, $timeout, MonoFuture, Queue) {
    return function MonoFuturePool(poolScope) {
        const allMonoFutures = new Set();
        const lockable = Queue().withScope(poolScope);
        poolScope?.$on?.('$destroy', destroy);

        return {
            createMonoFuture,
            destroy,
        };

        function createMonoFuture(monoFutureScope, spinner, delay) {
            const monoFuture = MonoFuture(undefined, spinner, delay); // we don't give the scope to the base monofuture because we need to manage destroy here to release the lock
            let waitingTask // the next scheduled task for this MonoFuture. When the monofuture is wrapping an API call, running waitingTask is what triggers the API call.
            let releaseThisMonoFutureLockIfAny = () => {}; // method to unlock the current query lock - only works when current monoFuture holds the lock, otherwise it's a noop

            const pooledMonoFuture = {
                wrap: function(func) {
                    return function(...args) {
                        const pendingMonoFuturePromiseDeferred = $q.defer(); // simple wrapper on the MonoFuture.exec output to handle the fact we don't have it synchronously, but we need to return it

                        if (waitingTask) {
                            // there is already a waiting task for this MonoFuture => we don't need to schedule anything, we just override the waitingTask & it will be executed in place of the previously scheduled one.
                            waitingTask = () => func.apply(func, args);
                        } else {
                            // otherwise, we schedule the task for when the lock is released. If the lock is free, lockable.exec will run synchronously
                            waitingTask = () => func.apply(func, args);
                            lockable.exec(() => {
                                releaseThisMonoFutureLockIfAny = lockable.lock();

                                // at this point, waitingTask may have been overridden by a later call, or the monoFuture may have be destroyed
                                // we run the task if the monoFuture has not be destroyed / the task has not been discarded in-between
                                const apiPromise = monoFuture.destroyed() ? undefined : waitingTask?.(); // let's not even make the call if destroyed
                                waitingTask = undefined;

                                if (!apiPromise || !apiPromise.success) {
                                    // cases when there isn't anything to query anymore: monoFuture is destroyed, task cancelled, wrapped method didn't return a promise
                                    // nothing is pending aymore => release the lock
                                    releaseThisMonoFutureLockIfAny();
                                } else {
                                    // normal case: track progress using MonoFuture then release lock
                                    const run = monoFuture.exec(apiPromise).finally(() => {
                                        releaseThisMonoFutureLockIfAny();
                                    });
                                    pendingMonoFuturePromiseDeferred.resolve(run); // forwards resolve, notify & rejects from the inner MonoFuture to the outer pooled one.
                                }
                            });
                        }

                        return enrichFuturePromise(pendingMonoFuturePromiseDeferred.promise);
                    };
                },
                abort() {
                    waitingTask = undefined; // before release otherwise a waiting task could be triggered
                    releaseThisMonoFutureLockIfAny();
                    monoFuture.abort();
                },
                destroy() {
                    waitingTask = undefined;
                    // when many monoFuture instances from the same pool are destroyed at once, we could have each destroy release the lock let the next query start, just for it to be destroyed after
                    // this micro-delay allows the next task to only be executed after the end of a synchronous bulk delete.
                    $timeout(releaseThisMonoFutureLockIfAny, 0);
                    allMonoFutures.delete(pooledMonoFuture);
                    monoFuture.destroy();
                },
                active() {
                    return monoFuture.active() || waitingTask !== undefined;
                },
            }

            if (monoFutureScope && monoFutureScope.$on) {
                monoFutureScope.$on('$destroy', () => pooledMonoFuture.destroy());
            }

            allMonoFutures.add(pooledMonoFuture);
            return pooledMonoFuture;
        }

        function destroy() {
            [...allMonoFutures].forEach(mf => mf.destroy());
        }
    }

}]);


// Provide a way to take/release the spinner
//
// Usage:
//
//  var spinner = SpinnerService();   // The spinner is permanently released automatically when scope is destroyed
//  spinner.acquire();
//  /* spinning... */
//  spinner.release(); // It's safe to release it multiple time
//
//
//  The spinner can be tied to a promise like that:
//  SpinnerService.lockOnPromise(promise);
app.factory("SpinnerService", ["$rootScope", function($rootScope) {
    let fakeReq = {}; // Doesn't matter what this object is, it's never used anyway...
    let actives = 0; // Number of active spinners
    let scopeUnregisterer = null;

    // TODO : implement this properly
    // (currently it's  is a little hack around $rootScope.httpRequests)
    function update() {
        // Reset
        let idx = $rootScope.httpRequests.indexOf(fakeReq);
        if (idx != -1) {
            $rootScope.httpRequests.splice(idx, 1);
        }
        // Activate
        if (actives > 0) {
            $rootScope.httpRequests.push(fakeReq);
        }
    }

    function fnr() {
        let acquired = false;
        let destroyed = false;
        function acquire() {
            if (destroyed) {
                return;
            }
            if (!acquired) {
                acquired = true;
                actives++;
                update();
            }
        }
        function release() {
            if (acquired) {
                acquired = false;
                actives--;
                update();
            }
        }
        function destroy() {
            destroyed = true;
            release();
        }

        const ret = {
            acquire: acquire,
            release: release,
            destroy: destroy,
            withScope: function(scope) {
                if (scopeUnregisterer) {
                    scopeUnregisterer();
                }
                if (scope) {
                    scopeUnregisterer = scope.$on('$destroy', destroy);
                }
                return ret;
            }
        };
        return ret;
    };

    fnr.lockOnPromise = function(promise) {
        if (promise && promise['finally']) {
            var lock = fnr();
            lock.acquire();
            promise['finally'](function() {
                lock.release();
            });
        }
    }
    return fnr;
}]);


// Ability to merge watch calls into one (old value is kept, new value is updated)
function wrapWatchHelper(ctrl, fn) {
    var isSet = false;
    var oldVal = undefined;
    var newVal = undefined;

    var trueExec = ctrl.wrap(function() {
        if (!angular.equals(newVal, oldVal)) {
            isSet = false;
            fn(newVal, oldVal);
        }
    });

    return function(nv, ov) {
        if (isSet) {
            newVal = angular.copy(nv);
        } else {
            isSet = true;
            oldVal = angular.copy(ov);
            newVal = angular.copy(nv);
        }
        trueExec();
    };
};

// Debounce
// API is similar to Throttle but it implements a behavior similar to the "onSmartChange" directive as a service
//
// var fn = Debounce
//    .withDelay(500,1000)   // initial delay = 500ms, then delay = 1000ms
//    .withSpinner(true)
//    .wrap(function() {
//        console.log('hello');
//     });
//
// Example 1:
//
// fn(); // Will be executed in 500ms
//
// Example 2 :
// fn();  // Will be dropped
// [sleep less than 100ms]
// fn();  // Will be executed in 1000s
//
//
app.factory("Debounce", ["SpinnerService", "$rootScope", function(SpinnerService, $rootScope) {

    return function(scope) {

        var initialDelay = 0;
        var delay = 0;
        var destroyed = false;
        var spinner = SpinnerService();
        var enableSpinner = false;
        var stdTimer = null;
        var initTimer = null;
        var scopeUnregisterer = null;

        var exec = function(func) {

            if (destroyed) {
                return;
            }

            var wrapped = function debounceExecWrapped() {
                var toBeExec;
                if (func) {
                    spinner.release();
                    toBeExec = func;
                    func = null;
                }
                if (toBeExec) {
                    $rootScope.$apply(function debounceExec() {
                        toBeExec();
                    });
                } else {
                    // Important because the activity state may have changed!
                    $rootScope.$digest();
                }
            };

            var isFirst = true;
            if (stdTimer) {
                clearTimeout(stdTimer.key);
                stdTimer = null;
                isFirst = false;
            }

            if (initTimer) {
                clearTimeout(initTimer.key);
                initTimer = null;
                isFirst = false;
            }

            if (enableSpinner) {
                spinner.acquire();
            }

            if (isFirst) {

                initTimer = {
                    key: setTimeout(function() {
                        initTimer = null;
                        wrapped();
                    }, initialDelay)
                };

                stdTimer = {
                    key: setTimeout(function() {
                        stdTimer = null;
                        wrapped();
                    }, delay)
                };

            } else {

                stdTimer = {
                    key: setTimeout(function() {
                        stdTimer = null;
                        wrapped();
                    }, delay)
                };
            }
        }

        var abort = function() {
            spinner.release();
            if (initTimer) {
                clearTimeout(initTimer.key);
                initTimer = null;
            }
            if (stdTimer) {
                clearTimeout(stdTimer.key);
                stdTimer = null;
            }
        };

        var wrap = function debounceWrap(func) {
            return function debounceWrapped() {
                var args = arguments;
                var argsArray = Array.prototype.slice.call(arguments);

                if (argsArray.indexOf("SkipDebounceAndRunImmediately") !== -1) {
                    // eslint-disable-next-line no-console
                    console.debug("Skipping debounce, running function immediately");
                    argsArray = argsArray.filter(arg => arg != "SkipDebounceAndRunImmediately");
                    func.apply(null, argsArray);
                } else {
                    exec(function debounceWrappedCB() {
                        func.apply(null, args);
                    });
                }
            };
        };

        var destroy = function() {
            // eslint-disable-next-line no-console
            console.info("Destroy debounce on scope", scope); // NOSONAR
            destroyed = true;
            abort();
        };

        var ret = {
            exec: function(func) {
                exec(func);
            },
            wrap: function(func) {
                return wrap(func);
            },
            wrapWatch: function(fn) {
                return wrapWatchHelper(ret, fn);
            },
            active: function() {
                return !!(initTimer || stdTimer);
            },
            abort: function() {
                abort();
            },
            destroy: function() {
                destroy();
            },
            withDelay: function(newInitialDelay, newDelay) {
                delay = newDelay;
                initialDelay = newInitialDelay;
                return ret;
            },
            withSpinner: function(enabled) {
                enableSpinner = enabled;
                return ret;
            },
            withScope: function(scope) {
                if (scopeUnregisterer) {
                    scopeUnregisterer();
                }
                if (scope) {
                    scopeUnregisterer = scope.$on('$destroy', destroy);
                }
                spinner.withScope(scope);
                return ret;
            }
        };
        return ret;

    };
}]);


// Limit the maximum update frequency to 1/delay
// Some calls will be dropped in order to limit update frequency
//
// Usage:
//
// var throttle = Throttle().withScope(scope).withDelay(1000);  // If a scope is passed, life time of monofuture = life time of the scope
//
// throttle.exec(func1); // Executed now (= after the current event loop)
// throttle.exec(func2); // Dropped (because of func3)
// throttle.exec(func3); // Dropped (because of func4)
// throttle.exec(func4); // Executed 1 second later
//
// It's also possible to permanently wrap a function :
// myFunc = Throttle().wrap(function() {
//    ...
// });
// myFunc(); // executed (= after the current event loop)
// myFunc(); // dropped
// myFunc(); // delayed
//
app.factory("Throttle", ["$timeout", function($timeout) {

    return function() {

        var delay = 0;
        var currentlyWaitingOn = null;
        var storedFunc = null;
        var destroyed = false;
        var scopeUnregisterer = null;

        var waitCallback = function() {
            var toBeExec;
            if (storedFunc) {
                toBeExec = storedFunc;
                storedFunc = null;
                currentlyWaitingOn = $timeout(waitCallback, delay);
            } else {
                currentlyWaitingOn = null;
            }
            // Re-entrant safe
            if (toBeExec) {
                toBeExec();
            }
        }
        var exec = function(func) {
            if (destroyed) {
                return;
            }
            if (!func) {
                func = function() {
                };
            }
            if (currentlyWaitingOn) {
                storedFunc = func;
                // It will be called later :)
            } else {
                // Execute now
                // ... and setup a timeout to drop further calls for 'delay' ms
                $timeout(func);
                storedFunc = null;
                currentlyWaitingOn = $timeout(waitCallback, delay);
            }
        };

        var wrap = function(func) {
            return function() {
                var args = arguments;
                exec(function() {
                    func.apply(null, args);
                });
            };
        };

        var abort = function() {
            if (currentlyWaitingOn) {
                $timeout.cancel(currentlyWaitingOn);
                currentlyWaitingOn = null;
            }
            storedFunc = null;
        };

        var destroy = function() {
            abort();
            destroyed = true;
        };


        var ret = {
            exec: function(func) {
                exec(func);
            },
            wrap: function(func) {
                return wrap(func);
            },
            wrapWatch: function(fn) {
                return wrapWatchHelper(ret, fn);
            },
            active: function() {
                return !!storedFunc;
            },
            abort: function() {
                abort();
            },
            destroy: function() {
                destroy();
            },
            withDelay: function(newDelay) {
                delay = newDelay;
                return ret;
            },
            withScope: function(scope) {
                if (scopeUnregisterer) {
                    scopeUnregisterer();
                }
                if (scope) {
                    scopeUnregisterer = scope.$on('$destroy', destroy);
                }
                return ret;
            }
        };
        return ret;
    };

}]);


app.factory("DKUtils", function($rootScope, $state, $stateParams, $timeout, Logger) {
    return {
        /* Reflows at current digest */
        reflowNow: function() {
            $rootScope.$broadcast("reflow");
        },

        /* Reflows at next digest */
        reflowNext: function() {
            $timeout(function() {
                $rootScope.$broadcast("reflow")
            }, 0);
        },
        /* It's probably bad if you need this */
        reflowLater: function() {
            $timeout(function() {
                Logger.info("delayed reflow");
                $rootScope.$broadcast("reflow")
            }, 400);
        },
        /* Reload current state. Works around broken $state.reload() */
        reloadState: function() {
            return $state.transitionTo($state.current,
                angular.copy($stateParams),
                {reload: true, inherit: true, notify: true});
        }
    }
});


app.factory("PluginsService", function($rootScope, DataikuAPI, WT1, StateUtils, $q, DataikuCloudService) {
    const namingConvention = '^[a-z][a-z0-9-]*$';

    const isUniqueInPlugin = function(newComponentId, pluginId, pluginComponentsOfSameType) {
        return !pluginComponentsOfSameType.some(existingComponent => existingComponent.id == newComponentId
                               || `${pluginId}_${existingComponent.id}` === newComponentId
                               || existingComponent.id === `${pluginId}_${newComponentId}`
                               || `${pluginId}_${existingComponent.id}` === `${pluginId}_${newComponentId}`);
    }

    const validateComponentId = function(newComponentId, pluginId, pluginComponentsOfSameType) {
        if (!newComponentId) return [];
        const warnings = [];
        if (!new RegExp(namingConvention).test(newComponentId)) {
            warnings.push("Component ID is invalid. It should start with a letter and continue with letters, numbers or hyphens.");
        }
        if (newComponentId.startsWith(pluginId)) {
            warnings.push("Component ID starts with plugin ID.");
        }
        if (!isUniqueInPlugin(newComponentId, pluginId, pluginComponentsOfSameType)) {
            warnings.push("Component ID is not unique.");
        }
        return warnings;
    }

    const isValidComponentId = function(newComponentId, pluginId, pluginComponentsOfSameType) {
        if (!newComponentId) return false;
        return validateComponentId(newComponentId, pluginId, pluginComponentsOfSameType).length == 0;
    };

    const getLoadedDescForDataset = function(svc, datasetType) {
        return svc.getDatasetLoadedDesc(datasetType) ||
            svc.getFSProviderLoadedDesc(datasetType) ||
            svc.getSampleLoadedDesc(datasetType);
    };

    var svc = {
        namingConvention: namingConvention,
        transformToDevPlugin: function(modalScope, convertAPIFunc, getAPICallParams, eventWT1Name, componentType, originalType) {
            DataikuAPI.plugindev.list().success(function(data) {
                modalScope.devPlugins = data;
            }).error(setErrorInScope.bind(modalScope));

            modalScope.convert = {
                mode: 'NEW',
                pattern: namingConvention
            };

            const noErrorMessage = {"display": false, "message": ""};
            const mustNotStartWithPluginId = {"display": true, "message": "New plugin recipe id should not start with the plugin id."};
            const mustBeUnique = {"display": true, "message": "New plugin recipe id must be unique across the recipe components of this plugin."};
            modalScope.matchesTargetFolder = function(pluginId) {
                return modalScope.convert.targetFolder.startsWith(pluginId);
            }
            modalScope.matchesOtherComponent = function(pluginId) {
                const plugin = modalScope.devPlugins.find(_ => _.desc.id === pluginId);
                return !isUniqueInPlugin(modalScope.convert.targetFolder, pluginId, plugin.content[componentType])
            }

            modalScope.modalWarning = function() {
            /**
            we add a special warning to explicitly say what the problem is, but only when it may be hard to understand
            **/
                if (modalScope.convert.mode === 'EXISTING') {
                    if (modalScope.convert.targetFolder && modalScope.matchesTargetFolder(modalScope.convert.targetPluginId)) {
                        return mustNotStartWithPluginId;
                    }
                    if (modalScope.convert.targetPluginId && modalScope.matchesOtherComponent(modalScope.convert.targetPluginId)) {
                        return mustBeUnique;
                    }
                } else {
                    if (modalScope.convert.targetFolder && modalScope.matchesTargetFolder(modalScope.convert.newPluginId)) {
                        return mustNotStartWithPluginId;
                    }
                }
                return noErrorMessage;
            };

            modalScope.isIdValid = function() {
                if (modalScope.convert.mode === 'EXISTING') {
                    if (!modalScope.convert.targetPluginId) return false;
                    const plugin = modalScope.devPlugins.find(_ => _.desc.id === modalScope.convert.targetPluginId);
                    return isValidComponentId(modalScope.convert.targetFolder,
                                                            modalScope.convert.targetPluginId,
                                                            plugin.content[componentType]);
                }
                if (!modalScope.convert.newPluginId) return false;
                return isValidComponentId(modalScope.convert.targetFolder,
                                                        modalScope.convert.newPluginId,
                                                        []);
            };

            modalScope.go = function() {
                resetErrorInScope(modalScope);
                convertAPIFunc(...getAPICallParams(modalScope)).success(function(data) {
                    WT1.event(eventWT1Name, {original: originalType});
                    modalScope.reloadPluginConfiguration();
                    StateUtils.go.pluginEditor(data.pluginId, data.relativePathToOpen);
                }).error(setErrorInScope.bind(modalScope));
            };
        },
        validateComponentId: validateComponentId,
        isValidComponentId: isValidComponentId,
        getPluginDesc(pluginId) {
            return $rootScope.appConfig.loadedPlugins.find(x => x.id == pluginId);
        },
        isPluginLoaded: function(pluginId) {
            var i, plugin;
            for (i = 0; i < $rootScope.appConfig.loadedPlugins.length; i++) {
                plugin = $rootScope.appConfig.loadedPlugins[i];
                if (plugin.id == pluginId) return true;
            }
            return false;
        },
        getSampleLoadedDesc : function(datasetType) {
            return $rootScope.appConfig.customSampleDatasets.find(x => x.datasetType === datasetType);
        },
        getDatasetLoadedDesc : function(datasetType) {
            return $rootScope.appConfig.customDatasets.find(x => x.datasetType == datasetType);
        },
        getFSProviderLoadedDesc : function(fsProviderType) {
            return $rootScope.appConfig.customFSProviders.find(x => x.fsProviderType == fsProviderType);
        },
        getRecipeLoadedDesc : function(recipeType) {
            return $rootScope.appConfig.customCodeRecipes.find(x => x.recipeType == recipeType);
        },
        getOwnerPluginDesc: function(loadedDesc) {
            if (loadedDesc != null) {
                return $rootScope.appConfig.loadedPlugins.find(x => x.id == loadedDesc.ownerPluginId);
            } else {
                return null; // plugin most likely removed
            }
        },
        getRecipeIcon: function(recipeType) {
            var loadedDesc = svc.getRecipeLoadedDesc(recipeType);
            if (loadedDesc && loadedDesc.desc && loadedDesc.desc.meta && loadedDesc.desc.meta.icon) {
                return loadedDesc.desc.meta.icon;
            } else {
                var pluginDesc = svc.getOwnerPluginDesc(loadedDesc);
                if (pluginDesc) {
                    return pluginDesc.icon || "icon-visual_prep_sync_recipe";
                } else {
                    return "icon-visual_prep_sync_recipe"; // plugin has been removed
                }
            }
        },
        getDatasetIcon: function(datasetType) {
            const loadedDesc = getLoadedDescForDataset(svc, datasetType);
            const defaultSampleDatasetIcon = "fas fa-flask";

            if (loadedDesc == null) {
                return datasetType.startsWith("Sample_") ? defaultSampleDatasetIcon : "icon-question-sign";
            }

            return loadedDesc.desc?.meta?.icon ||
                svc.getOwnerPluginDesc(loadedDesc)?.icon ||
                (datasetType.startsWith("Sample_") ? defaultSampleDatasetIcon : "icon-puzzle-piece");
        },
        getDatasetLabel : function(datasetType) {
            return getLoadedDescForDataset(svc, datasetType)?.desc?.meta?.label || datasetType;
        },
        checkInstalledStatus: function(pluginId, forceFetch) {
            return $q((resolve, reject) => {
                DataikuAPI.plugins.list(forceFetch)
                .success(function(data) {
                    const isInstalled = data.plugins.some(plugin => plugin.id === pluginId && plugin.installed);
                    resolve(isInstalled);
                })
                .error(reject)
            });
        },
        getPluginVersion: function(pluginId, forceFetch) {
            return $q((resolve, reject) => {
                DataikuAPI.plugins.list(forceFetch)
                .success(function(data) {
                    const plugin = data.plugins.find(plugin => plugin.id === pluginId);
                    if (plugin && plugin.installedDesc && plugin.installedDesc.desc) {
                        resolve(plugin.installedDesc.desc.version);
                    } else {
                        reject(undefined);
                    }
                })
                .error(reject)
            });
        },
        /**
         * Get the link to the plugin details store listing of the plugin with the specified ID
         * @param {String} pluginId
         * @param {Boolean} isPluginInstalled
         * @param {Boolean} isAppDeploymentCloud
         * @returns {String} If DSS cloud is detected the listing will be the public wordpress info page. Otherwise the local store listing will be returned\
         */
        getPluginDetailsLink: function(pluginId, isPluginInstalled, isAppDeploymentCloud) {
            if (isAppDeploymentCloud) return `https://www.dataiku.com/product/plugins/${pluginId}/`;
            if (isPluginInstalled) return `plugins/${pluginId}/summary/`;
            return `/plugins-explore/store/${pluginId}`;
        },
        /**
         * Get the link to the plugin store depending on how DSS is deployed (Cloud and On Prem.)
         */
        getPluginStoreLink: function(cloudInfo = {}, pluginName = '') {
            if (cloudInfo.isDataikuCloud && cloudInfo.isSpaceAdmin) {
                return DataikuCloudService.getLaunchpadUrl() + '/plugins/';
            }

            return (cloudInfo.isDataikuCloud ? 'https://www.dataiku.com/product/plugins/' : StateUtils.href.pluginStore()) + pluginName;
        }
    };
    return svc;
});


app.factory("PluginConfigUtils", function() {
    return {
        setDefaultValues: function(params, customConfig) {
            if (!customConfig) {
                return;
            }
            params.forEach(function(param) {
                if (customConfig[param.name] === undefined) {
                    if (param.defaultValue) {
                        // the type is not checked, so if the default is not of the right type, strange things can happen
                        customConfig[param.name] = param.defaultValue;
                    } else if (param.type == 'BOOLEAN') {
                        customConfig[param.name] = false;
                    } else if (param.type == 'INT' || param.type == 'DOUBLE') {
                        customConfig[param.name] = 0;
                    } else if (param.type == 'MAP') {
                        customConfig[param.name] = {};
                    } else if (param.type == 'KEY_VALUE_LIST') {
                        customConfig[param.name] = [];
                    } else if (param.type == 'ARRAY') {
                        customConfig[param.name] = [];
                    } else if (param.type == 'OBJECT_LIST') {
                        customConfig[param.name] = [];
                    }
                }
            });
        },
        shouldComponentBeVisible: function (loadedPlugins, selectedComponentId, componentIdGetter = (c) => c.id) {
            return (component) => {
                const ownerPlugin = loadedPlugins.find(p => p.id === component.ownerPluginId);

                const isHiddenByPlugin = ownerPlugin && ownerPlugin.hideComponents;
                const isSelected = selectedComponentId && selectedComponentId === componentIdGetter(component);

                return !isHiddenByPlugin || isSelected;
            };
        }
    }
});


app.factory("FutureProgressUtils", function() {
    var svc = {
        getTotalProgressPercentage: function(progress) {
            var percentage = 0;
            var fractionOf = 100;
            if (progress && progress.states) {
                angular.forEach(progress.states, function(state) {
                    if (state.target > 0) {
                        fractionOf = fractionOf / (state.target + 1);
                        percentage += fractionOf * state.cur;
                    }
                });
            }
            return percentage;
        }
    }
    return svc;
})

// Store large things, and give them a unique ID. It's backed by a very small LRU cache, and its purpose is
// to overcome the limitations of $stateParams when trying to pass big data in the URL
app.factory("BigDataService", ['$cacheFactory', function($cacheFactory) {
    var cache = $cacheFactory('BigDataServiceCache', {
        number: 20
    });
    return {
        store: function(bigdata) {
            var id = generateRandomId(10);
            cache.put(id, {data: bigdata});
            return id;
        },
        fetch: function(id) {
            var val = cache.get(id);
            if (!val) {
                return undefined;
            }
            return val.data;
        }
    };
}]);


app.factory("SQLExplorationService", ['$rootScope', '$cacheFactory', '$q', '$stateParams', 'Logger', 'DataikuAPI',
            function($rootScope, $cacheFactory, $q, $stateParams, Logger, DataikuAPI) {

    var cache = $cacheFactory('SQLExplorationServiceCache', {
        number: 50
    });

    var sep = '^~\n$* \\#';

    function connectionKey(connectionName) {
        return 'CNX' + sep + connectionName + sep;
    }

    function tableKey(projectKey, connection, schema, table) {
        if (!schema) {
            schema = '';
        }
        return 'TBL' + sep + schema + sep + table + sep + connection + sep + projectKey;
    }

    function listFieldsForTable(connection, table, projectKey) {
        var deferred = $q.defer();

        var key = tableKey(projectKey, connection, table.schema, table.table);
        var cached = cache.get(key);
        if (cached) {
            deferred.resolve(cached);
            Logger.info("Loaded fields of table " + table.table + " from cache");
        } else {
            DataikuAPI.connections.listSQLFields(connection, [table], projectKey).success(function(data) {
                cache.put(key, data);
                deferred.resolve(data);
                Logger.info("Loaded fields of table " + table.table + " from backend");
            }).error(setErrorInScope.bind($rootScope));
        }

        return deferred.promise;

    }

    return {
        getCacheId: function(connectionName, projectKey, catalog, schema) {
            let id = connectionKey(connectionName) + '__all__' + projectKey;
            if (catalog) {
                id += '__catalog__' + catalog
            }
            if (schema) {
                id += '__schema__' + schema
            }
            return id;
        },
        getCacheIdFromProject: function(connectionName, projectKey) {
            return connectionKey(connectionName) + '__fromProject__' + projectKey;
        },
        isTableInCache: function(id) {
            return cache.get(id);
        },
        listTables: function(connectionName, projectKey, catalog, schema) {
            const deferred = $q.defer();
            const id = this.getCacheId(connectionName, projectKey, catalog, schema)
            const cached = this.isTableInCache(id);

            if (cached) {
                deferred.resolve(cached);
                Logger.info("Loaded tables list for connection " + connectionName + " from cache");
            } else {
                DataikuAPI.connections.listSQLTables(connectionName, projectKey, catalog, schema).success(function(data) {
                    cache.put(id, data);
                    deferred.resolve(angular.copy(data));
                    Logger.info("Loaded tables list for connection " + connectionName + " from backend");
                }).error(function(...data) {
                    deferred.reject(data);
                });
            }
            return deferred.promise;
        },
        listTablesFromProject: function(connectionName, projectKey) {
            const deferred = $q.defer();
            const id = this.getCacheIdFromProject(connectionName, projectKey)
            const cached = this.isTableInCache(id);

            if (cached) {
                deferred.resolve(cached);
                Logger.info("Loaded tables list for connection " + connectionName + " and projectKey " + projectKey + " using cache");
            } else {
                DataikuAPI.connections.listSQLTablesFromProject(connectionName, projectKey).success(function(data) {
                    cache.put(id, data);
                    deferred.resolve(angular.copy(data));
                    Logger.info("Loaded tables list for connection " + connectionName + " and projectKey " + projectKey + " from backend");
                }).error(function(...data) {
                    deferred.reject(data);
                });
            }
            return deferred.promise;
        },
        clearCache: function() {
            cache.removeAll();
        },
        listFields: function(connectionName, tables) {
            var promises = [];
            for (var i = 0; i < tables.length; i++) {
                promises.push(listFieldsForTable(connectionName, tables[i], $stateParams.projectKey));
            }
            var deferred = $q.defer();
            $q.all(promises).then(function(results) {
                var out = [];
                for (var i in results) {
                    out = out.concat(results[i]);
                }
                deferred.resolve(angular.copy(out));
            });
            return deferred.promise;
        }
    };
}]);


app.factory("SmartId", function($stateParams) {
    return {
        create: function(id, contextProjectKey) {
            if (contextProjectKey == $stateParams.projectKey) {
                return id;
            } else {
                return contextProjectKey + "." + id;
            }
        },

        resolve: function(smartId, contextProject) {
            if (contextProject === undefined) {
                contextProject = $stateParams.projectKey
            }
            if (smartId && smartId.indexOf(".") > 0) {
                var chunks = smartId.split(".");
                return {projectKey: chunks[0], id: chunks[1]}
            } else {
                return {projectKey: contextProject, id: smartId};
            }
        },

        fromRef: function(smartObjectRef, contextProject) {
            if (contextProject === undefined) {
                contextProject = $stateParams.projectKey
            }
            if (smartObjectRef.objectType == 'PROJECT') {
                return smartObjectRef.objectId;
            }
            if (!smartObjectRef.projectKey || !smartObjectRef.projectKey.length || smartObjectRef.projectKey == contextProject) {
                return smartObjectRef.objectId;
            } else {
                return smartObjectRef.projectKey + "." + smartObjectRef.objectId;
            }
        },

        fromTor: function(tor, contextProject) {
            if (contextProject === undefined) {
                contextProject = $stateParams.projectKey
            }
            if (tor.taggableType == 'PROJECT') {
                return tor.id;
            }
            if (!tor.projectKey || !tor.projectKey.length || tor.projectKey == contextProject) {
                return tor.id;
            } else {
                return tor.projectKey + "." + tor.id;
            }
        }
    }
});


app.service("FeatureNameUtils", function($filter, Fn) {

    /*
     Returns an object with :
     .elements, an array of strings representing
     consecutive elements of processed the feature name.
     .isCode, an array of booleans with same length indicating whether the corresponding
     element should be treated as "code"
     .value, an optional value for the feature. Defaults to null.
     .operator, the operator describing the operation when there is a value. Defaults to null.
     .no_operator, the inverse operator. Defaults to null.
     */
    var getAsElements = function(input, asHtml) {
        if (asHtml === undefined) {
            asHtml = false;
        }
        if (input == null) {
            input = "";
        }
        // Formatting
        var esc = asHtml ? $filter('escapeHtml') : Fn.SELF;
        var code = [];
        var els = [];
        var value = null, rawValue = null;
        var operator = null;
        var no_operator = null;
        var type = null;

        var addCode = function(c) {
            code.push(true);
            els.push(esc(c));
        };

        var addText = function(c) {
            code.push(false);
            els.push(esc(c));
        };

        let match;
        const elts = input.split(":");
        if ( (match = input.match(/^dummy:([^:]+):(.*)/)) ) {
            addCode(match[1]);
            switch (match[2].trim()) {
                case '':
                    value = "empty";
                    operator = "is";
                    no_operator = "is not";
                    break;
                case '__Others__':
                    value = "other";
                    operator = "is";
                    no_operator = "is not";
                    break;
                default:
                    value = esc(match[2]);
                    operator = "is";
                    no_operator = "is not";
            }
        } else if ( (match = input.match(/^(?:thsvd|hashvect):(.+):(\d+)$/)) ) {
            addCode(match[1]);
            addText('[text #' + match[2] + ']');
        } else if ( (match = input.match(/^unfold:([^:]+):(.*)$/)) ) {
            addCode(match[1]);
            addText('[element #' + match[2] + ']');
        } else if (input.startsWith("impact:")) {
            /*reg: impact:ft:all_target_values*/
            /*multi: impact:ft:target_value:<target_value>*/
            if (elts.length == 4) {
                addCode(elts[1]);
                addText('[impact #' + elts[3] + ']');
            } else {
                addCode(elts[1]);
                addText("[impact on target]");
            }
        } else if (input.startsWith("glmm:")) {
            /*reg: glmm:ft:all_target_values*/
            /*multi: glmm:ft:target_value:<target_value>*/
            if (elts.length == 4) {
                addCode(elts[1]);
                addText('[glmm #' + elts[3] + ']');
            } else {
                addCode(elts[1]);
                addText("[glmm on target]");
            }
        } else if (input.startsWith("frequency:")) {
            /*frequency: frequency:ft:frequency*/
            /*count: frequency:ft:count*/
            addCode(elts[1]);
            addText("[" + elts[2] + " encoded]");
        } else if (input.startsWith("ordinal:")) {
            /*lexicographic: ordinal:ft:lexicographic*/
            /*count: ordinal:ft:count*/
            addCode(elts[1]);
            addText("[ordinal encoded (" + elts[2] + ")]");
        } else if (input.startsWith("datetime_cyclical:")) {
            /* datetime_cyclical:ft:<period>:<cos|sin> */
            addCode(elts[1]);
            addText(`[${elts[2]} cycle (${elts[3]})]`);
        } else if ( (match = input.match(/^poly_int:(.*)$/)) ) {
            addCode(match[1]);
            addText("(computed)");
        } else if ( (match = input.match(/^pw_linear:(.*)$/)) ) {
            addCode(match[1]);
            addText("(computed)");
        } else if ( (match = input.match(/countvec:(.+):(.+)$/)) ) {
            addCode(match[1]);
            operator = 'contains';
            no_operator = "does not contain";
            value = match[2];
            type = "countvec";
        } else if ( (match = input.match(/tfidfvec:(.+):(.+):(.+)$/)) ) {
            addCode(match[1]);
            operator = 'contains';
            no_operator = "does not contain";
            value = match[3] + "(idf=" + match[2] + ")";
            rawValue = match[3];
            type = "tfidfvec";
        } else if(input.startsWith("hashing:")) {
            addCode(elts[1]);
            value = elts[2];
            operator = "hashes to";
            no_operator = "does not hash to";
            type = "hashing";
        } else if (input.startsWith("interaction")) {
            if (elts.length == 3) {
                addCode(elts[1]);
                addText("x");
                addCode(elts[2]);
            } else if (elts.length == 4) {
                addCode(elts[1]);
                addText("x");
                addCode(elts[2] + " = " + elts[3]);
            } else {
                addCode(elts[1] + " = " + elts[3]);
                addText("and");
                addCode(elts[2] + " = " + elts[4]);
            }
        } else {
            addCode(input);
        }

        return {
            elements: els,
            isCode: code,
            value: value,
            operator: operator,
            no_operator: no_operator,
            type : type,
            rawValue : rawValue
        };
    }

    var getAsHtmlString = function(feature) {
        var els = getAsElements(feature, true);
        var htmlArray = [];
        for (var i = 0; i < els.elements.length; i++) {
            if (els.isCode[i]) {
                htmlArray.push("<code>" + els.elements[i] + "</code>")
            } else {
                htmlArray.push(els.elements[i]);
            }
        }
        if (els.value != null) {
            htmlArray.push(els.operator, "<code>" + els.value + "</code>");
        }
        return htmlArray.join(" ");
    };

    var getAsTextElements = function(feature) {
        var els = getAsElements(feature);
        return {
            feature: els.elements.join(" "),
            operator: els.operator,
            no_operator: els.no_operator,
            value: els.value,
            type : els.type,
            rawValue : els.rawValue
        };
    };

    var getAsText = function(feature, negate) {
        if (negate === undefined) {
            negate = false;
        }
        var els = getAsElements(feature);
        if (els.value == null) {
            return els.elements.join(" ");
        } else {
            return els.elements.concat([negate ? els.no_operator : els.operator, els.value]).join(" ");
        }
    }

    return {
        getAsElements: getAsElements,
        getAsHtmlString: getAsHtmlString,
        getAsTextElements: getAsTextElements,
        getAsText: getAsText
    };

})

app.filter("getNameValueFromMLFeature", function(FeatureNameUtils) {
    return function(feature) {
        var els = FeatureNameUtils.getAsTextElements(feature);
        return {
            name: els.feature,
            value: els.value
        };
    }
});


app.factory("InfoMessagesUtils", function() {
    var svc = {
        /* Returns the first of the info messages with a given line, or null if there is none */
        getMessageAtLine: function(im, line) {
            if (!im || !im.messages) return null;
            for (var i = 0; i < im.messages.length; i++) {
                if (im.messages[i].line == line) return im.messages[i];
            }
            return null;
        },
        /* Filter the messages of all categories by line */
        filterForLine : function(im, line) {
            if (!im || !im.messages) return null;
            var fim = {};
            fim.messages = im.messages.filter(function(m) {return m.line == line;});
            fim.anyMessage = fim.messages.length > 0;
            fim.error = fim.messages.filter(function(m) {return m.severity == 'ERROR'}).length > 0;
            fim.warning = fim.messages.filter(function(m) {return m.severity == 'WARNING'}).length > 0;
            fim.maxSeverity = fim.error ? 'ERROR' : (fim.warning ? 'WARNING' : (fim.anyMessage ? 'INFO' : null));
            return fim;
        },
        getMessageAtColumn : function(im, column) {
            if (!im || !im.messages) return null;
            for (var i = 0; i < im.messages.length; i++) {
                if (im.messages[i].column == column) return im.messages[i];
            }
            return null;
        }
    }
    return svc;
});


app.factory("MessengerUtils", function($sanitize) {
    Messenger.options = {
        extraClasses: 'messenger-fixed messenger-on-bottom messenger-on-right',
        theme: 'dss'
    };

    const svc = {
        post: function(options) {
            let msg = null;
            options.actions = options.actions || {};
            if (options.showCloseButton) {
                options.actions.close = {
                    label: "Close",
                    action: function() {
                        msg.hide();
                    }
                };
                delete options.showCloseButton;
            }
            if (options.icon) {
                options.message = '<div style="width: 100%;"><div class="messenger-icon">' + $sanitize(options.icon) + '</div>' + $sanitize(options.message) + '</div>'
                delete options.icon;
            } else {
                options.message = '<div style="width: 100%;">' + $sanitize(options.message) + '</div>'
            }
            msg = Messenger().post(options);
        }
    }
    return svc;
});


// Front-end equivalent of StringNormalizationMode.java
app.factory("StringNormalizer", function() {

    var inCombiningDiatricalMarks = /[\u0300-\u036F]/g;
    var punct = /!"#\$%&'\(\)\*\+,-\.\/:;<=>\?@\[\]\^_`\{\|\}~/g;

    var svc = {
        get: function(stringNormalizationMode) {
            switch(stringNormalizationMode) {
                case 'EXACT':
                    return function(str) {
                        return str;
                    };

                case 'LOWERCASE':
                    return function(str) {
                        return str.toLowerCase();
                    };

                case 'NORMALIZED':
                default:
                    return function(str) {
                        return svc.normalize(str);
                    };
            }
        },

        normalize: function(str) {
            return str.normalize('NFD').replace(inCombiningDiatricalMarks, '');
        },

        removePunct: function(str) {
            return str.replace(punct, '');
        }
    };

    return svc;
});


app.service('HiveService', function($rootScope, Dialogs, ActivityIndicator, DataikuAPI, ToolBridgeService, CreateModalFromTemplate, $q) {
    this.convertToImpala = function(selectedRecipes) {
        var deferred = $q.defer();
        //TODO @flow need a dedicated modal or rather a generic confirm modal that can have errors in scope
        Dialogs.confirm($rootScope, "Convert recipes to Impala", `Are you sure you want to convert ${selectedRecipes.length} Hive recipes to Impala?`).then(function() {
            DataikuAPI.flow.recipes.massActions.convertToImpala(selectedRecipes, true)
                .success(function() {
                    deferred.resolve("converted");
                }).error(function(a,b,c) {
                    deferred.reject("conversion failed");
                    setErrorInScope.bind($rootScope)(a,b,c);
                });
        }, function() {deferred.reject("user cancelled");});
        return deferred.promise;
    };

    this.resynchronizeMetastore = function(selectedDatasets) {
        Dialogs.confirmPositive($rootScope,
            'Hive metastore resynchronization',
            'Are you sure you want to resynchronize datasets to the Hive metastore?')
        .then(function() {
            ActivityIndicator.waiting('Synchronizing Hive metastore...');
            DataikuAPI.datasets.synchronizeHiveMetastore(selectedDatasets).success(function(data) {
                if (data.anyMessage && (data.warning || data.error)) {
                    ActivityIndicator.hide();
                    Dialogs.infoMessagesDisplayOnly($rootScope, "Metastore synchronization", data);
                } else {
                    // nothing to show
                    ActivityIndicator.success('Hive metastore successfully synchronized');
                }
            }).error(function(data, status, headers) {
                ActivityIndicator.hide();
                setErrorInScope.call($rootScope, data, status, headers);
            });
        });
    };

    this.startChangeHiveEngine = function(selectedRecipes) {
        return CreateModalFromTemplate('/templates/recipes/fragments/hive-engine-modal.html', $rootScope, null, function(modalScope) {
            modalScope.options = {executionEngine: 'HIVESERVER2'};

            DataikuAPI.flow.recipes.massActions.startSetHiveEngine(selectedRecipes).success(function(data) {
                modalScope.messages = data;
                ToolBridgeService.emitRefreshView('HiveModeView');
            }).error(function(...args) {
                modalScope.fatalError = true;
                setErrorInScope.apply(modalScope, args);
            });

            modalScope.ok = function() {
                DataikuAPI.flow.recipes.massActions.setHiveEngine(selectedRecipes, modalScope.options.executionEngine)
                    .success(function() {
                        $rootScope.$emit('recipesHiveEngineUpdated');
                        modalScope.resolveModal();
                    })
                    .error(setErrorInScope.bind(modalScope));
            };
        });
    };
});


app.service('ImpalaService', function($rootScope, Dialogs, CreateModalFromTemplate, ToolBridgeService, DataikuAPI, $q) {

    this.convertToHive = function(selectedRecipes) {
        var deferred = $q.defer();
        //TODO @flow need a dedicated modal or rather a generic confirm modal that can have errors in scope
        Dialogs.confirm($rootScope, "Convert recipes to Hive", `Are you sure you want to convert ${selectedRecipes.length} Impala recipes to Hive?`).then(function() {
            DataikuAPI.flow.recipes.massActions.convertToHive(selectedRecipes, true)
                .success(function() {
                    deferred.resolve("converted");
                }).error(function(a,b,c) {
                    deferred.reject("conversion failed");
                    setErrorInScope.bind($rootScope)(a,b,c);
                });
        }, function() {deferred.reject("user cancelled");});
        return deferred.promise;
    };

    this.startChangeWriteMode = function(selectedRecipes) {
        return CreateModalFromTemplate('/templates/recipes/fragments/impala-write-flag-modal.html', $rootScope, null, function(modalScope) {
            modalScope.options = {runInStreamMode: true};

            DataikuAPI.flow.recipes.massActions.startSetImpalaWriteMode(selectedRecipes).success(function(data) {
                modalScope.messages = data;
                ToolBridgeService.emitRefreshView('ImpalaWriteModeView');
            }).error(function(...args) {
                modalScope.fatalError = true;
                setErrorInScope.apply(modalScope, args);
            });

            modalScope.ok = function() {
                DataikuAPI.flow.recipes.massActions.setImpalaWriteMode(selectedRecipes, modalScope.options.runInStreamMode)
                    .success(function() {
                        $rootScope.$emit('recipesImpalaWriteModeUpdated');
                        modalScope.resolveModal();
                    })
                    .error(setErrorInScope.bind(modalScope));
            };
        });
    };
});


app.service('SparkService', function($rootScope, CreateModalFromTemplate, DataikuAPI) {
    this.startChangeSparkConfig = function(selectedItems) {

        return CreateModalFromTemplate('/templates/recipes/fragments/spark-config-modal.html', $rootScope, null, function(modalScope) {
            modalScope.selectedRecipes = selectedItems.filter(it => it.type == 'RECIPE');
            modalScope.options = {};

            DataikuAPI.flow.recipes.massActions.startSetSparkConfig(modalScope.selectedRecipes).success(function(data) {
                modalScope.messages = data;
            }).error(function(...args) {
                modalScope.fatalError = true;
                setErrorInScope.apply(modalScope, args);
            });

            modalScope.ok = function() {
                DataikuAPI.flow.recipes.massActions.setSparkConfig(modalScope.selectedRecipes, modalScope.options.sparkConfig)
                    .success(function() {
                        $rootScope.$emit('recipesSparkConfigUpdated');
                        modalScope.resolveModal();
                    })
                    .error(setErrorInScope.bind(modalScope));
            };
        });
    };
});


app.service('PipelineService', function($rootScope, CreateModalFromTemplate, DataikuAPI) {
    this.startChangePipelineability = function(selectedItems, pipelineType) {
        return CreateModalFromTemplate('/templates/recipes/fragments/pipelineability-modal.html', $rootScope, null, function(modalScope) {
            modalScope.selectedRecipes = selectedItems.filter(it => it.type === 'RECIPE');

            modalScope.pipelineTypeText = (pipelineType === 'SPARK' ? 'Spark' : 'SQL');

            modalScope.options = {
                allowStart: true,
                allowMerge: true
            };

            DataikuAPI.flow.recipes.massActions.startSetPipelineability(modalScope.selectedRecipes, pipelineType).success(function(data) {
                modalScope.messages = data;
            }).error(function(...args) {
                modalScope.fatalError = true;
                setErrorInScope.apply(modalScope, args);
            });

            modalScope.ok = function() {
                DataikuAPI.flow.recipes.massActions.setPipelineability(modalScope.selectedRecipes, pipelineType, modalScope.options.allowStart, modalScope.options.allowMerge)
                    .success(function() {
                        modalScope.resolveModal();
                    })
                    .error(setErrorInScope.bind(modalScope));
            };
        });
    };
});


app.service('ColorPalettesService', function() {

    const svc = this;

    const DEFAULT_COLORS = [
        "#1ac2ab",
        "#0f6d82",
        "#FFD83D",
        "#de1ea5",
        "#9dd82b",
        "#28aadd",
        "#00a55a",
        "#d66b9b",
        "#77bec2",
        "#94be8e",
        "#123883",
        "#a088bd",
        "#c28e1a"
    ];

    svc.fixedColorsPalette = function(name, colors=DEFAULT_COLORS) {
        const colorMap = {};
        return function(key) {
            key = key + ''; //force conversion
            if (colorMap[key]) {
                return colorMap[key];
            }
            colorMap[key] = colors[Object.keys(colorMap).length % colors.length];
        };
    };

});


/*
 * TODO: finally this service is a bit of a duplicate of what CodeBasedEditorUtils was supposed to be. Would be good to merge both at some point...
 */
app.service('CodeMirrorSettingService', function($rootScope) {

    const INDENT_MORE_SHORTCUT = "Tab";
    const INDENT_LESS_SHORTCUT = "Shift-Tab";
    const FIND_SHORTCUT = "Ctrl-F";
    const REPLACE_SHORTCUT = "Ctrl-Alt-F";
    const JUMP_TO_LINE_SHORTCUT = "Ctrl-L";
    const TOGGLE_COMMENT_SHORTCUT_QWERTY = "Cmd-/";
    const TOGGLE_COMMENT_SHORTCUT_AZERTY = "Shift-Cmd-/";
    const TOGGLE_COMMENT_SHORTCUT_RSTUDIO = "Shift-Ctrl-C";
    const AUTOCOMPLETE_SHORTCUT = "Ctrl-Space";
    const FULL_SCREEN_SHORTCUT = "F11";

    this.getShortcuts = function() {
        return {
            "INDENT_MORE_SHORTCUT": INDENT_MORE_SHORTCUT,
            "INDENT_LESS_SHORTCUT": INDENT_LESS_SHORTCUT,
            "FIND_SHORTCUT": FIND_SHORTCUT,
            "REPLACE_SHORTCUT": REPLACE_SHORTCUT,
            "JUMP_TO_LINE_SHORTCUT": JUMP_TO_LINE_SHORTCUT,
            "TOGGLE_COMMENT_SHORTCUT": TOGGLE_COMMENT_SHORTCUT_QWERTY,
            "AUTOCOMPLETE_SHORTCUT": AUTOCOMPLETE_SHORTCUT,
            "FULL_SCREEN_SHORTCUT": FULL_SCREEN_SHORTCUT}
    }

    this.get = function(mimeType, options) {
        var extraKeys = {};

        if (!$rootScope.appConfig.userSettings.codeEditor || !$rootScope.appConfig.userSettings.codeEditor.keyMap || $rootScope.appConfig.userSettings.codeEditor.keyMap == "default") {
            extraKeys[INDENT_MORE_SHORTCUT] = "indentMore";
            extraKeys[INDENT_LESS_SHORTCUT] = "indentLess";
            extraKeys[FIND_SHORTCUT] = "find";
            extraKeys[REPLACE_SHORTCUT] = "replace";
            extraKeys[JUMP_TO_LINE_SHORTCUT] = "jumpToLine";
            extraKeys[TOGGLE_COMMENT_SHORTCUT_QWERTY] = "toggleComment";
            extraKeys[TOGGLE_COMMENT_SHORTCUT_AZERTY] = "toggleComment";
            extraKeys[TOGGLE_COMMENT_SHORTCUT_RSTUDIO] = "toggleComment";
            extraKeys[AUTOCOMPLETE_SHORTCUT] = this.showHint(mimeType, options && options.words ? options.words : []);
        }
        if (!options || !options.noFullScreen) {
            extraKeys[FULL_SCREEN_SHORTCUT] = function(cm) {
                if (cm.getOption("fullScreen")) {
                    cm.setOption("fullScreen", false);
                } else {
                    cm.setOption("fullScreen", !cm.getOption("fullScreen"));
                }
            };
        }


        var settings =  {
            mode: mimeType,
            theme: $rootScope.appConfig.userSettings.codeEditor && $rootScope.appConfig.userSettings.codeEditor.theme ? $rootScope.appConfig.userSettings.codeEditor.theme : 'default',

            //left column
            lineNumbers : true,
            foldGutter: true,
            gutters: ["CodeMirror-linenumbers", "CodeMirror-foldgutter"],

            //indentation
            indentUnit: $rootScope.appConfig.userSettings.codeEditor && $rootScope.appConfig.userSettings.codeEditor.indentUnit ? $rootScope.appConfig.userSettings.codeEditor.indentUnit : 4,
            tabSize: $rootScope.appConfig.userSettings.codeEditor && $rootScope.appConfig.userSettings.codeEditor.tabSize ? $rootScope.appConfig.userSettings.codeEditor.tabSize : 4,
            indentWithTabs: $rootScope.appConfig.userSettings.codeEditor ? $rootScope.appConfig.userSettings.codeEditor.indentWithTabs : false,

            //edition
            autoCloseBrackets: $rootScope.appConfig.userSettings.codeEditor ? $rootScope.appConfig.userSettings.codeEditor.autoCloseBrackets : true,
            autoCloseTags: $rootScope.appConfig.userSettings.codeEditor ? $rootScope.appConfig.userSettings.codeEditor.autoCloseTags : true,

            // readonly
            readOnly: options && options.readOnly,

            //code reading
            matchBrackets: true,
            matchTags: true,
            highlightSelectionMatches: true,
            styleSelectedText: true,
            styleActiveLine: true,

            keyMap: $rootScope.appConfig.userSettings.codeEditor && $rootScope.appConfig.userSettings.codeEditor.keyMap ? $rootScope.appConfig.userSettings.codeEditor.keyMap : 'default',
            extraKeys: extraKeys,
            onLoad: function(cm) {
                if ($rootScope.appConfig.userSettings.codeEditor && $rootScope.appConfig.userSettings.codeEditor.fontSize) {
                    $($(cm.getTextArea()).siblings('.CodeMirror')[0]).css('font-size', $rootScope.appConfig.userSettings.codeEditor.fontSize + 'px');
                }
                if (options && options.onLoad && typeof(options.onLoad) == "function") {
                    options.onLoad(cm);
                }
            }
        };

        return settings;
    }

    this.showHint = function(mode, words) {
        return function(cm) {
            const modes = {
                'text/x-python': CodeMirror.hintWords.python,
                'text/css': CodeMirror.hintWords.css
            };

            CodeMirror.showHint(cm, function(editor) {
                const anyWordHint = CodeMirror.hint.anyword(cm);
                const recipeWords = words || [];
                const codeKeywords = CodeMirror.hintWords[mode] || modes[mode] || [];

                let combinedWords = [recipeWords, [' '], codeKeywords, [' '], anyWordHint && anyWordHint.list ? anyWordHint.list : []]
                    .reduce((a, b) => a.concat(b.filter(_ => _ === ' ' || !a.includes(_)))); // deduplicates

                /*
                    Filter functionality based off of https://github.com/amarnus/ng-codemirror-dictionary-hint/blob/master/lib/ng-codemirror-dictionary-hint.js
                */
                var cur = editor.getCursor();
                var curLine = editor.getLine(cur.line);
                var start = cur.ch;
                var end = start;
                while (end < curLine.length && /[\w$]/.test(curLine.charAt(end))) ++end;
                while (start && /[\w$]/.test(curLine.charAt(start - 1))) --start;
                var curWord = start !== end && curLine.slice(start, end);
                return {
                    list: (!curWord ? combinedWords : combinedWords.filter(_ => _.startsWith(curWord) && _ !== curWord)),
                    from: CodeMirror.Pos(cur.line, start),
                    to: CodeMirror.Pos(cur.line, end)
                }
            }, { completeSingle: false });
        };
    }
});

app.service('CodeEnvService', function(DataikuAPI, $stateParams, FutureProgressModal, Dialogs, Deprecation, CreateModalFromTemplate, $q, FutureWatcher, FeatureFlagsService) {
    const allInterpreters = [
        ["PYTHON36", "Python 3.6"],
        ["PYTHON37", "Python 3.7"],
        ["PYTHON38", "Python 3.8"],
        ["PYTHON39", "Python 3.9"],
        ["PYTHON310", "Python 3.10"],
        ["PYTHON311", "Python 3.11"],
        ["PYTHON312", "Python 3.12"],
        ["PYTHON313", "Python 3.13"],
        ["CUSTOM", "Custom (lookup in PATH)"]
    ];
    if (FeatureFlagsService.featureFlagEnabled('allowPython2CodeEnv')) {
        allInterpreters.unshift(["PYTHON27", "Python 2.7"])
    }

    const experimentalInterpreters = [
    ]

    const condaInterpreters = [
        ["PYTHON36", "Python 3.6"],
        ["PYTHON37", "Python 3.7"],
        ["PYTHON38", "Python 3.8"],
        ["PYTHON39", "Python 3.9"],
        ["PYTHON310", "Python 3.10"],
        ["PYTHON311", "Python 3.11"],
        ["PYTHON312", "Python 3.12"],
        ["PYTHON313", "Python 3.13"]
    ];
    if (FeatureFlagsService.featureFlagEnabled('allowPython2CodeEnv')) {
        condaInterpreters.unshift(["PYTHON27", "Python 2.7"])
    }

    const condaInterpretersWithDeprecationNotice = dkuDeepCopy(condaInterpreters);
    condaInterpretersWithDeprecationNotice.filter(interpreter => Deprecation.isPythonDeprecated(interpreter[0])).forEach(interpreter => interpreter[1] += " - Deprecated");

    let availableInterpreters;
    let enrichedInterpreters;

    function getAvailableInterpretersPromise() {
        const deferred = $q.defer();
        if (availableInterpreters) {
            deferred.resolve(availableInterpreters);
        } else {
            DataikuAPI.codeenvs.listAvailablePythonInterpreters().success(function (data) {
                availableInterpreters = data;
                // CUSTOM should always be available
                availableInterpreters.push("CUSTOM");
                deferred.resolve(availableInterpreters)
            });
        }
        return deferred.promise;
    }

    function enrichInterpreterDescription(availableInterpretersList) {
        const enrichedInterpreters = [];
        // make sure the list of available interpreters has been retrieved from backend
        for (const interpreter of allInterpreters) {
            const interpreterId = interpreter[0];
            const interpreterDesc = interpreter[1];
            if (!availableInterpretersList.includes(interpreterId)) {
                enrichedInterpreters.push([interpreterId, interpreterDesc + " - Not available"]);
            } else if (Deprecation.isPythonDeprecated(interpreterId)) {
                enrichedInterpreters.push([interpreterId, interpreterDesc + " - Deprecated"]);
            } else if (experimentalInterpreters.includes(interpreterId)) {
                enrichedInterpreters.push([interpreterId, interpreterDesc + " - Experimental"]);
            } else {
                enrichedInterpreters.push([interpreterId, interpreterDesc]);
            }
        }
        return enrichedInterpreters;
    }

    const svc = {
        pythonInterpreters: allInterpreters, // these interpreters can be used as default, but will not contain enrichments
        getPythonInterpreters: function() {
            if (enrichedInterpreters) {
                return $q.when(enrichedInterpreters);
            }
            return getAvailableInterpretersPromise()
                .then((interpreters) => {
                    enrichedInterpreters = enrichInterpreterDescription(interpreters);
                    return enrichedInterpreters;
                });
        },
        pythonCondaInterpreters: condaInterpretersWithDeprecationNotice,
        getPackagesThatAreBothRequiredAndInstalled : function(spec, actual) {
            if (!spec || !actual) {
                return new Set();
            }
            return svc.intersection(svc.getPackageNames(spec), svc.getPackageNames(actual));
        },
        intersection : function(setA, setB) {
            let intersection = new Set();
            for (let elt of setB) {
                if (setA.has(elt)) {
                    intersection.add(elt)
                }
            }
            return intersection;
        },
        difference : function(setA, setB) {
            let difference = new Set();
            for (let elt of setA) {
                if (!setB.has(elt)) {
                    difference.add(elt)
                }
            }
            return difference;
        },
        getPackagesThatAreRequired : function(codeEnv, packageSystem) {
            let spec = null;
            let mandatory = null;
            if (packageSystem == 'pip') {
                spec = codeEnv.specPackageList;
                mandatory = codeEnv.mandatoryPackageList;
            } else if (packageSystem == 'conda') {
                spec = codeEnv.specCondaEnvironment;
                mandatory = codeEnv.mandatoryCondaEnvironment;
            }
            let packages = !spec ? new Set() : svc.getPackageNames(spec);
            if (mandatory) {
                svc.getPackageNames(mandatory).forEach(p => packages.add(p));
            }
            return packages;
        },
        getPackageNames : function(listStr) {
            /** Gets the set of package names mentioned in a code env listing */
            let ret = new Set();
            for (let line of listStr.split("\n")) {
                // Ignore packages that are not clean package names
                if (line.indexOf("-e") >= 0 || line.indexOf("git+") >= 0 || line.indexOf("ssh") >= 0) continue;

                const chunks = line.split(/[\s>=<,[\]]+/);
                const packageName = chunks[0].trim().replaceAll('"',"");
                if (packageName.length > 0) {
                    ret.add(packageName.toLowerCase());
                }
            }
            return ret;
        },
        listLogs : function($scope){
            return DataikuAPI.admin.codeenvs.design.listLogs($scope.envLang, $stateParams.envName).then(function(response) {
                $scope.logs = response.data;
            }).catch(setErrorInScope.bind($scope));
        },
        makeCurrentDesc : function(desc) {
            return {
                yarnPythonBin: angular.copy(desc.yarnPythonBin),
                yarnRBin: angular.copy(desc.yarnRBin),
                owner: angular.copy(desc.owner),
                installJupyterSupport : desc.installJupyterSupport,
                installCorePackages : desc.installCorePackages,
                corePackagesSet : desc.corePackagesSet,
                envSettings : angular.copy(desc.envSettings),
                dockerImageResources: desc.dockerImageResources,
                updateResourcesApiNode: desc.updateResourcesApiNode,
                dockerfileAtStart: desc.dockerfileAtStart,
                dockerfileBeforePackages: desc.dockerfileBeforePackages,
                dockerfileAfterCondaPackages: desc.dockerfileAfterCondaPackages,
                dockerfileAfterPackages: desc.dockerfileAfterPackages,
                dockerfileAtEnd: desc.dockerfileAtEnd,
                containerCacheBustingLocation: desc.containerCacheBustingLocation,
                predefinedContainerHooks: angular.copy(desc.predefinedContainerHooks)
            };
        },
        makeCurrentSpec : function(spec) {
            return {
                specPackageList: angular.copy(spec.specPackageList),
                desc: svc.makeCurrentDesc(spec.desc),
                specCondaEnvironment: angular.copy(spec.specCondaEnvironment),
                permissions: angular.copy(spec.permissions),
                usableByAll: spec.usableByAll,
                allContainerConfs: angular.copy(spec.allContainerConfs),
                containerConfs: angular.copy(spec.containerConfs),
                allSparkKubernetesConfs: angular.copy(spec.allSparkKubernetesConfs),
                sparkKubernetesConfs: angular.copy(spec.sparkKubernetesConfs),
                rebuildDependentCodeStudioTemplates: angular.copy(spec.rebuildDependentCodeStudioTemplates),
                resourcesInitScript: angular.copy(spec.resourcesInitScript)
                };
        },
        refreshEnv : function($scope) {
            const getEnvPromise = DataikuAPI.admin.codeenvs.design.get($scope.envLang, $stateParams.envName).then(function(response) {
                const codeEnv = response.data;
                $scope.codeEnv = codeEnv;
                $scope.codeEnv.pythonInterpreterFriendlyName = svc.pythonInterpreterFriendlyName($scope.codeEnv.desc.pythonInterpreter);
                $scope.previousSpec = svc.makeCurrentSpec(codeEnv);
                $scope.previousPackagesSetForRemovalWarning['pip'] = svc.getPackagesThatAreBothRequiredAndInstalled(codeEnv.specPackageList, codeEnv.actualPackageList);
                $scope.previousPackagesSetForRemovalWarning['conda'] = svc.getPackagesThatAreBothRequiredAndInstalled(codeEnv.specCondaEnvironment, codeEnv.actualCondaEnvironment);
            }).catch(setErrorInScope.bind($scope));
            const listLogsPromise = svc.listLogs($scope);
            return $q.all([getEnvPromise, listLogsPromise]);
        },
        updateEnv : function($scope, envName, upgradeAllPackages, updateResources, forceRebuildEnv, envLang, callback){
            var updateSettings = {
                upgradeAllPackages: upgradeAllPackages,
                updateResources: $scope.uiState.updateResources,
                forceRebuildEnv: $scope.uiState.forceRebuildEnv
            }

            var buildTemplates = function(templatesToRebuild) {
                DataikuAPI.codeStudioTemplates.massBuild(templatesToRebuild)
                    .then(response => FutureProgressModal.show($scope, response.data, "Build Code Studio templates", undefined, 'static', 'false', true)
                        .then(result => {
                            if (result) {
                                Dialogs.infoMessagesDisplayOnly($scope, "Build Code Studio templates result", result.messages, result.futureLog);
                            }
                        })
                    ).catch(function(a,b,c){
                        setErrorInScope.bind($scope)(a,b,c);
                    });
            }

            var doUpdateEnv = function(templatesToRebuild) {
                DataikuAPI.admin.codeenvs.design.update($scope.envLang, $stateParams.envName, updateSettings).success(data => {
                    FutureProgressModal.show($scope, data, "Env update", undefined, 'static', false)
                        .then(result => {
                            if (result) {
                                function buildTemplatesIfNeeded() {
                                    if (templatesToRebuild) {
                                        buildTemplates(templatesToRebuild);
                                    }
                                };
                                if(result.messages.maxSeverity == 'ERROR') { // 'ERROR' also in case of abort
                                    Dialogs.infoMessagesDisplayOnly($scope, "Update Code Env result", result.messages, result.futureLog);
                                    // no template building if error
                                } else if(result.messages.maxSeverity == 'WARNING') {
                                    // warning is not serious enough to imply no template building
                                    Dialogs.infoMessagesDisplayOnly($scope, "Update Code Env result", result.messages, result.futureLog).then(buildTemplatesIfNeeded);
                                } else {
                                    buildTemplatesIfNeeded();
                                }
                            }
                            svc.refreshEnv($scope);
                            $scope.$broadcast('refreshCodeEnvResources', {envName: $scope.codeEnv.envName});
                            if (callback) {
                                callback();
                            }
                        })
                }).error(setErrorInScope.bind($scope));
            }

            if (["ASK", "ALL"].includes($scope.codeEnv.rebuildDependentCodeStudioTemplates)){
                let getOnlyGlobalUsages = true; // We only need usages in CodeStudio templates
                DataikuAPI.admin.codeenvs.design.listUsages($scope.codeEnv.envLang, $scope.codeEnv.envName, getOnlyGlobalUsages).success(usagesList => {
                    const templatesToRebuild = usagesList
                        .filter(u => u.envUsage === 'CODE_STUDIO_TEMPLATE' && u.projectKey === '__DKU_ANY_PROJECT__' && u.objectId !== 'OBJECT_NOT_ACCESSIBLE') // will be empty if you don't have the rights
                        .map(u => u.objectId);
                    if ($scope.codeEnv.rebuildDependentCodeStudioTemplates === 'ASK' && templatesToRebuild.length > 0){
                        CreateModalFromTemplate("/templates/admin/code-envs/design/code-studio-rebuild-modal.html", $scope, null, newScope => {
                            newScope.templatesToRebuild = templatesToRebuild;
                            newScope.rebuildAll = () => {
                                newScope.dismiss();
                                doUpdateEnv(templatesToRebuild);
                            }
                            newScope.rebuildNone = () => {
                                newScope.dismiss();
                                doUpdateEnv();
                            }
                        });
                    } else {
                        doUpdateEnv(templatesToRebuild);
                    }
                }).error(() => {
                    setErrorInScope.bind($scope);
                    doUpdateEnv();
                });
            } else {
                doUpdateEnv();
            }
        },
        pythonInterpreterFriendlyName: function(pythonInterpreter) {
            let interpreter = allInterpreters.filter(interpreter => interpreter[0] == pythonInterpreter);
            if (interpreter.length) {
                return interpreter[0][1];
            } else {
                return pythonInterpreter;
            }
        }
    }
    return svc;
});

app.service('TimingService', function($rootScope) {
    return {
        wrapInTimePrinter: function(prefix, fn) {
            return function() {
                const before = performance.now();
                const retval = fn.apply(this, arguments);
                const after = performance.now();
                // eslint-disable-next-line no-console
                console.info("Timing: " + prefix + ": " + (after - before) + "ms");
                return retval;
            }
        }
    };
});

app.service('PromiseService', function() {
    const svc = this;

    /**
     * Wrap a $q promise in a $http promise (in order to keep the .success and .error methods)
     */
    svc.qToHttp = function(p) {
        return {
            then: p.then,
            success: function (fn) {
                return svc.qToHttp(p.then(fn));
            },
            error: function (fn) {
                return svc.qToHttp(p.then(null, fn));
            }
        }
    }

})

app.service('ProjectStatusService', function(TaggingService, $rootScope)  {
    const svc = this;
    let projectStatusMap = {};

    svc.getProjectStatusColor = function(status) {
        if(projectStatusMap && projectStatusMap[status]) {
            return projectStatusMap[status];
        } else {
            return TaggingService.getDefaultColor(status);
        }
    }

    function computeProjectStatusMap() {
        projectStatusMap = {};
        if ($rootScope.appConfig && $rootScope.appConfig.projectStatusList) {
            $rootScope.appConfig.projectStatusList.forEach(function(projectStatus) {
                projectStatusMap[projectStatus.name] = projectStatus.color;
            });
        }
    }
    $rootScope.$watch('appConfig.projectStatusList', computeProjectStatusMap, true);
});


app.service('ProjectFolderService', function(DataikuAPI, $q) {
    const svc = this;
    const ROOT_ID = 'ROOT';

    /**
     * Maps from ProjectFolderSummary to browse node information consisting
     * - children - an array of folder ids
     * - pathElts - an array of folder ids, from the root down to and including this node
     * - exists - always true
     * - directory - always true
     */
    svc.buildBrowseNode = function(folder) {
        const folders = folder.children.map(f => angular.extend({}, f, { directory: true, fullPath: f.id }))
        const pathElts = treeToList(folder, item => item.parent);
        return({
            children: folders,
            pathElts: pathElts.map(f => angular.extend({}, f, { toString: () => f.id })),
            exists: true,
            directory: true,
        });
    };

    /*
     * Adds pathElts to ProjectFolderSummary, a string like /Sandbox/marketing/summer
     */
    svc.addPathToFolder = (folder) => {
        const pathElts = treeToList(folder, item => item.parent);
        return angular.extend({}, folder, { pathElts: pathElts.map(f => f.name).join('/') });
    };

    // Return (a promise which returns) a ProjectFolderSummary object for the given folderId with minimal info
    svc.getFolder = function(folderId) {
        const requestFolderId = folderId || ROOT_ID;
        return DataikuAPI.projectFolders.getSummary(requestFolderId, 1, true, true).then(resp => {
            return resp.data;
        });
    };

    // Returns a function which sets the given path on the root folder if necessary
    const setRootPath = function(rootPath) {
        return function(folder) {
            if (folder.id === ROOT_ID) {
                folder.pathElts = rootPath;
            }
            return folder;
        }
    }

    svc.getDefaultFolder = function(folderId) {
        const requestFolderId = folderId || ROOT_ID;
        return DataikuAPI.projectFolders.getDefaultFolderSummary(requestFolderId).then(resp => {
            return resp.data;
        });
    };

    svc.getBrowseNode = function(folderId) {
        return svc.getFolder(folderId).then(svc.buildBrowseNode);
    }

    svc.getFolderWithPath = function(folderId) {
        return svc.getFolder(folderId).then(svc.addPathToFolder).then(setRootPath('/'));
    }

    // Return (a promise which returns) a folder with a path (in pathElts) to be used in a folder-path-input
    // If the folder cannot be found (or is not visible to the user) we fallback to the root folder
    // rootFolderDisplayText is the text or path to display when we fallback to the root
    svc.getFolderFallbackRoot = function(folderId, rootFolderDisplayText) {
        const deferred = $q.defer();
        this.getFolderWithPath(folderId).then((folder) => {
            deferred.resolve(folder);
        }).catch(() => {
            this.getFolder('').then(setRootPath(rootFolderDisplayText)).then((folder) => {
                deferred.resolve(folder);
            });
        });
        return deferred.promise;
    }

    // Return (a promise which returns) a folder (ProjectFolderSummary) with a path (pathElts) for initialising folder creation or duplication dialogs
    // If we are in the root folder, currentFolderId will be an empty string - meaning we will fallback to the default configured
    svc.getDefaultFolderForNewProject = function(currentFolderId) {
         // set rootpath to '/' to match what is added in browseDoneFn in folderPathInput (when show-root-folder-path="true")
        return svc.getDefaultFolder(currentFolderId).then(svc.addPathToFolder).then(setRootPath('/'));
    }

    svc.isInRoot = function(folderId) {
        return folderId === ROOT_ID;
    }

    // Return true if a folder is the SANDBOX folder or any SUBFOLDER of it
    svc.isUnderSandbox = function(folder) {
        if (!folder) {
            return false;
        }

        return folder.id === 'SANDBOX' || !!(folder.parent && svc.isUnderSandbox(folder.parent));
    }

});

/**
 * Enhance fattable elements with dragging capabilities.
 * Mandatory class fat-draggable should be added for parent draggable zone.
 * Mandatory class fat-draggable__item should be added for each items that can be dragged.
 * Mandatory class fat-draggable__handler should be added to trigger drag. It should be a child of an item or the item itself.
 * Mandatory data-column-name attribute should be added at fat-draggable__item level to keep a reference to the column when DOM is being recycled.
 *
 * To enable drag on an element, call the setDraggable() method with the following options :
 *
 * @param {Object}              options                         - The available options
 * @param {HTMLElement}         options.element                 - (Mandatory) element containing the draggable items.
 * @param {String}              [options.axis="x"]              - Define the dragging axis. Default to horizontal dragging.
 * @param {Function}            [options.onDrop]                - Drop callback
 * @param {Function}            [options.onPlaceholderUpdate]   - Placeholder dimensions update. Use it to reshape / position the placeholder. Called with the placeholder dimensions
 * @param {ScrollBarProxy}      [options.scrollBar]             - Fattable scrollbar to be updated if necessary
 *
 * @example
 *
 * <div class="fat-draggable">
 *  <div class="fat-draggable__item" data-column-name="{{column.name}}">
 *       <i class="fat-draggable__handler"></i>
 *       ...
 *  </div>
 * </div>
 */
app.factory('FatDraggableService', function() {
    const MAIN_CLASSNAME = 'fat-draggable';
    const HANDLER_CLASSNAME = MAIN_CLASSNAME + '__handler';
    const ITEM_CLASSNAME = MAIN_CLASSNAME + '__item';
    const PLACEHOLDER_CLASSNAME = MAIN_CLASSNAME + '__placeholder';
    const BAR_CLASSNAME = MAIN_CLASSNAME + '__bar';
    const DRAGGING_CLASSNAME = MAIN_CLASSNAME + '--dragging';
    const DRAGGED_CLASSNAME = ITEM_CLASSNAME + '--dragged';
    const COLUMN_NAME_ATTRIBUTE = 'data-column-name';
    const BAR_THICKNESS = 2;
    const MINIMAL_MOVE_TO_DRAG = 10;
    let classNamesToIgnore;
    let scrollBar;
    let element;
    let axis = 'x';
    let axisClassname;
    let placeholderDOM = document.createElement('div');
    let barDOM = document.createElement('div');
    let draggedItem;
    let draggedColumnName;
    let disabledTarget;
    let draggedItemDimensions = {};
    let placeholderDimensions = {};
    let barDimensions = {};
    let elementDimensions = {};
    let hoveredItem;
    let hoveredColumnName;
    let hoveredItemDimensions = {};
    let dragging = false;
    let downing = false;
    let onDrop;
    let onPlaceholderUpdate;
    let cursorInitialPosition = -1;
    let cursorPosition = -1;
    let gap = -1;

    // Ensures requestAnimationFrame cross-browsers support
    window.requestAnimationFrame = window.requestAnimationFrame || window.mozRequestAnimationFrame || window.webkitRequestAnimationFrame || window.msRequestAnimationFrame;

    /* HELPERS */

    // Gets the draggable item matching the mouse target
    function getDraggableItem(target) {
        return target.closest('.' + ITEM_CLASSNAME);
    }

    function getColumnName(columnDOM) {
        if (columnDOM) {
            return columnDOM.getAttribute(COLUMN_NAME_ATTRIBUTE) || (columnDOM.firstElementChild && columnDOM.firstElementChild.getAttribute(COLUMN_NAME_ATTRIBUTE));
        }
    }

    function getColumnDOM(columnName) {
        if (columnName) {
            return element.querySelector('[' + COLUMN_NAME_ATTRIBUTE + '="' + columnName + '"]');
        }
    }

    // Returns true if we are dragging before (on top in y axis or on left on x axis) the item being dragged
    function isDraggingBefore() {
        return cursorPosition && draggedItemDimensions && (cursorPosition <= draggedItemDimensions[axis === 'y' ? 'top' : 'left']);
    }

    // Retrieves the item around the cursor position
    function getHoveredItem() {
        let items = element.querySelectorAll('.' + ITEM_CLASSNAME);
        let vertical = (axis === 'y');
        for (let i = 0; i < items.length; i++) {
            let currentItem = items[i];
            let itemDimensions = getBoundingClientRect(currentItem);
            if (vertical) {
                if (itemDimensions.top <= cursorPosition && cursorPosition < itemDimensions.top + itemDimensions.height) {
                    return currentItem;
                }
            } else {
                if (itemDimensions.left <= cursorPosition && cursorPosition < itemDimensions.left + itemDimensions.width) {
                    return currentItem;
                }
            }
        }
        return null;
    }

    // Sets hover style for the draggable item matching the mouse target
    function updateHoveredItem() {
        let draggingBefore = isDraggingBefore();
        let target = getHoveredItem();

        if (!target) {
            return;
        }
        if (hoveredItem && hoveredItem === target) {
            return;
        }

        hoveredItem = target;
        hoveredColumnName = getColumnName(hoveredItem);

        if (hoveredItem !== draggedItem) {
            hoveredItemDimensions = getBoundingClientRect(hoveredItem);
            elementDimensions = getBoundingClientRect(element);

            if (axis === 'y') {
                barDimensions.top = draggingBefore ? hoveredItemDimensions.top : hoveredItemDimensions.top + hoveredItemDimensions.height;
                barDimensions.height = BAR_THICKNESS;
                barDimensions.width = placeholderDimensions.width;
                barDimensions.left = elementDimensions.left;
            } else {
                barDimensions.left = draggingBefore ? hoveredItemDimensions.left : hoveredItemDimensions.left + hoveredItemDimensions.width;
                barDimensions.height = placeholderDimensions.height;
                barDimensions.width = BAR_THICKNESS;
                barDimensions.top = elementDimensions.top;
            }
        } else {
            barDimensions.width = 0;
            barDimensions.height = 0;
        }

        updateBarBoundingBox(barDimensions);
    }

    // Redraw the placeholder according the mouse position
    function updatePlaceholderBoundingBox(dimensions) {

        if (typeof onPlaceholderUpdate === 'function') {
            onPlaceholderUpdate(dimensions);
        }

        if (dimensions.top >= 0) {
            if (dimensions.top <= elementDimensions.top - placeholderDimensions.height / 2) {
                // If overflowing on top
                // Putting at top of parent element - half of the placeholder (for better auto scroll)
                dimensions.top = elementDimensions.top - placeholderDimensions.height / 2;
            } else if (dimensions.top + placeholderDimensions.height - placeholderDimensions.height / 2 >= elementDimensions.top + elementDimensions.height) {
                // If overflowing on bottom
                // Putting at bottom of parent element + half of the placeholder (for better auto scroll)
                dimensions.top = elementDimensions.top + elementDimensions.height - placeholderDimensions.height / 2;
            }
            placeholderDOM.style.top = dimensions.top + 'px';
        }
        if (dimensions.left >= 0) {
            if (dimensions.left <= elementDimensions.left - placeholderDimensions.width / 2) {
                // If overflowing on the left
                // Putting at left of parent element - half of the placeholder (for better auto scroll)
                dimensions.left = elementDimensions.left - placeholderDimensions.width / 2;
            } else if (dimensions.left + placeholderDimensions.width - placeholderDimensions.width / 2 >= elementDimensions.left + elementDimensions.width) {
                // If overflowing on the right
                // Putting at right of parent element + half of the placeholder (for better auto scroll)
                dimensions.left = elementDimensions.left + elementDimensions.width - placeholderDimensions.width / 2;
            }
            placeholderDOM.style.left = dimensions.left + 'px';
        }

        if (dimensions.height >= 0) {
            placeholderDOM.style.height = dimensions.height + 'px';
        }
        if (dimensions.width >= 0) {
            placeholderDOM.style.width = dimensions.width + 'px';
        }
    }

    // Wrap the placeholder position update in a callback for requestAnimationFrame()
    function placeholderDOMRedraw() {
        updatePlaceholderBoundingBox(axis === 'y' ? {top: (cursorPosition - gap)} : {left: (cursorPosition - gap)});
    }

    // Redraw the bar according the given dimensions
    function updateBarBoundingBox(dimensions) {
        if (dimensions.top >= 0) {
            if (dimensions.top <= elementDimensions.top) {
                dimensions.top = elementDimensions.top;
            } else if (dimensions.top >= elementDimensions.top + elementDimensions.height) {
                dimensions.top = elementDimensions.top + elementDimensions.height;
            }
            barDOM.style.top = dimensions.top + 'px';
        }
        if (dimensions.left >= 0) {
            if (dimensions.left <= elementDimensions.left) {
                dimensions.left = elementDimensions.left;
            } else if (dimensions.left >= elementDimensions.left + elementDimensions.width) {
                dimensions.left = elementDimensions.left + elementDimensions.width;
            }
            barDOM.style.left = dimensions.left + 'px';
        }
        if (dimensions.height >= 0) {
            barDOM.style.height = dimensions.height + 'px';
        }
        if (dimensions.width >= 0) {
            barDOM.style.width = dimensions.width + 'px';
        }
    }

    // Generic fatTable scroll update
    function updateScroll () {
        if (!scrollBar) {
            return;
        }
        if (axis === 'y') {
            let elementTop = getBoundingClientRect(element).top;
            let elementBottom = elementTop + element.offsetHeight;
            let placeholderTop= placeholderDOM.offsetTop;
            let placeholderBottom = placeholderTop + placeholderDOM.offsetHeight;

            if (placeholderBottom > elementBottom) {
                scrollBar.setScrollXY(element.scrollLeft, scrollBar.scrollTop + placeholderBottom - elementBottom);
            } else if (placeholderTop < elementTop) {
                scrollBar.setScrollXY(element.scrollLeft, scrollBar.scrollTop + placeholderTop - elementTop);
            }
        } else {
            let elementLeft = getBoundingClientRect(element).left;
            let elementRight = elementLeft + element.offsetWidth;
            let placeholderLeft = placeholderDOM.offsetLeft;
            let placeholderRight = placeholderLeft + placeholderDOM.offsetWidth;

            if (placeholderRight > elementRight) {
                scrollBar.setScrollXY(scrollBar.scrollLeft + placeholderRight - elementRight, element.scrollTop);
            } else if (placeholderLeft < elementLeft) {
                scrollBar.setScrollXY(scrollBar.scrollLeft + placeholderLeft - elementLeft, element.scrollTop);
            }
        }
    }

    // Clean every dragging-related things
    function reset() {
        document.body.contains(placeholderDOM) && document.body.removeChild(placeholderDOM);
        barDOM.style.top = '';
        barDOM.style.left = '';
        barDOM.style.height = '';
        barDOM.style.width = '';
        document.body.removeChild(barDOM);
        draggedItem && draggedItem.classList.remove(DRAGGED_CLASSNAME);
        document.body.classList.remove(DRAGGING_CLASSNAME);

        window.removeEventListener('mousemove', onMouseMove);
        window.removeEventListener('mouseup', onMouseUp);
        disabledTarget.removeEventListener('mouseup', disableClick);
        Mousetrap.unbind("esc", onEscape);

        dragging = false;
        downing = false;
        draggedItem = null;
        draggedColumnName = null;
        hoveredItem = null;
        hoveredColumnName = null;
        disabledTarget = null;
        draggedItemDimensions = {};
        placeholderDimensions = {};
        barDimensions = {};
        hoveredItemDimensions = {};
        elementDimensions = {};
        cursorPosition = -1;
        cursorInitialPosition = -1;
        gap = -1;
    }

    // Prevent the beginning of the drag
    function cancel() {
        if (dragging) {
            reset();
        } else {
            cursorInitialPosition = -1;
            downing = false;
            draggedItem = null;
            draggedColumnName = null;
            window.removeEventListener('mousemove', onMouseMove);
        }
    }

    /* EVENTS LISTENERS */
    function onMouseUp() {

        if (!dragging) {
            cancel();
            return;
        }
        if (typeof onDrop === 'function' && draggedColumnName && hoveredColumnName && draggedColumnName !== hoveredColumnName) {
            onDrop(draggedItem, hoveredItem, draggedColumnName, hoveredColumnName);
        }
        reset();
    }

    // When the dragging has started we do not want any click to be triggered on the element
    function disableClick(event) {
        event.stopImmediatePropagation();
        event.preventDefault();
        onMouseUp();
    }

    // If moving the placeholder, update its position according the given axis
    function onMouseMove(event) {

        // If not yet dragging, initiate drag, else update the placeholder position
        if (!dragging && downing) {
            if (axis === 'y') {
                cursorPosition = event.clientY;
                gap = cursorInitialPosition - draggedItemDimensions.y;
            } else {
                cursorPosition = event.clientX;
                gap = cursorInitialPosition - draggedItemDimensions.x;
            }

            // Do not start drag if the mouse has not moved enough
            if (Math.abs(cursorPosition - cursorInitialPosition) < MINIMAL_MOVE_TO_DRAG) {
                return;
            }

            dragging = true;
            // Bind mouseup for dragging end and click on target to prevent other listeners to be triggered
            window.addEventListener('mouseup', onMouseUp);
            disabledTarget = event.target;
            disabledTarget.addEventListener('click', disableClick);

            // Inject placeholder and bar in DOM and add the drag-related class names
            document.body.appendChild(placeholderDOM);
            document.body.appendChild(barDOM);
            document.body.classList.add(DRAGGING_CLASSNAME);
            draggedItem.classList.add(DRAGGED_CLASSNAME);

            placeholderDimensions = angular.copy(draggedItemDimensions);
            updatePlaceholderBoundingBox(placeholderDimensions);

            Mousetrap.bind("esc", onEscape);
        } else {
            cursorPosition = axis === 'y' ? event.clientY : event.clientX;
            requestAnimationFrame(placeholderDOMRedraw);
            updateScroll();
            // If the dragged column DOM from fattable has been removed try to re-fetch it
            if (!document.body.contains(draggedItem)) {
                let newDraggedItem = getColumnDOM(draggedColumnName);
                if (newDraggedItem) {
                    draggedItem = newDraggedItem;
                    draggedItem.classList.add(DRAGGED_CLASSNAME);
                }
            // If the dragged column DOM and column name are inconsistent, invalidate it and try to refetch it
            } else if (!draggedItem.getAttribute(COLUMN_NAME_ATTRIBUTE) || draggedItem.getAttribute(COLUMN_NAME_ATTRIBUTE) !== draggedColumnName) {
                draggedItem.classList.remove(DRAGGED_CLASSNAME);
                draggedItem = null;
                let newDraggedItem = getColumnDOM(draggedColumnName);
                if (newDraggedItem) {
                    draggedItem = newDraggedItem;
                    draggedItem.classList.add(DRAGGED_CLASSNAME);
                }
            }
        }

        updateHoveredItem();
    }

    // Press escape to stop the current drag
    function onEscape() {
        if (!dragging) {
            return;
        }
        reset();
    }

    function onMouseDown(event) {

        // Do not drag if the selected element has at least one class marking it as not-draggable
        try {
            classNamesToIgnore.forEach(className => {
                if (event.target.closest('.' + className)) {
                    throw new Error("Ignoring drag, element not draggable.");
                }
            });
        } catch (e) {
            return;
        }

        if (!event.target.closest('.' + HANDLER_CLASSNAME)) {
            return;
        }

        // Do not consider right click
        if (event.which === 3) {
            return;
        }

        downing = true;
        draggedItem = getDraggableItem(event.target);
        draggedColumnName = getColumnName(draggedItem);

        window.addEventListener('mousemove', onMouseMove);

        // If a click occurred, prevent dragging
        element.addEventListener('click', cancel);

        // Prevent native drag
        event.preventDefault();

        // Ensure mandatory class name are here
        element.classList.add(MAIN_CLASSNAME);
        element.classList.add(axisClassname);

        draggedItemDimensions = getBoundingClientRect(draggedItem);

        if (axis === 'y') {
            cursorInitialPosition = event.clientY;
        } else {
            cursorInitialPosition = event.clientX;
        }
    }

    return {

        setDraggable: function(options) {
            if (!options || !options.element) { return }
            element = options.element;
            onDrop = options.onDrop;
            onPlaceholderUpdate = options.onPlaceholderUpdate;
            scrollBar = options.scrollBar;
            classNamesToIgnore = options.classNamesToIgnore;

            element.classList.add(MAIN_CLASSNAME);

            axis = options.axis && options.axis === 'y' ? 'y' : 'x';
            axisClassname = axis === 'y' ? 'fat-draggable-y-axis' : 'fat-draggable-x-axis';
            element.classList.add(axisClassname);

            placeholderDOM.className = PLACEHOLDER_CLASSNAME;
            barDOM.className = BAR_CLASSNAME;

            // If clicking on a drag handler, retrieve dragged item data and attach mouse move
            element.addEventListener('mousedown', onMouseDown);
        }
    }
});

/**
 * Enhance fattable elements with resize capabilities.
 * Mandatory class fat-resizable__item should be added for each items that can be dragged.
 * Mandatory class fat-resizable__handler should be added to trigger resize. It should be a child of an item or the item itself.
 * Mandatory data-column-name and data-column-index attributes should be added at fat-resizable__item level to keep a reference to the column when DOM is being recycled.
 *
 * To enable resize on an element, call the setResizable() method with the following options :
 *
 * @param {Object}              options                         - The available options
 * @param {HTMLElement}         options.element                 - (Mandatory) element containing the resizable items.
 * @param {Function}            options.onDrop               - Drop callback. Returns an object containing resized column data: index, name and width.
 *
 * @example
 *
 * <div fat-resizable>
 * ...
 *  <div class="fat-resizable__item" data-column-name="{{column.name}}" data-column-index="{{columnIndex}}">
 *      ...
 *      <span class="fat-resizable__handler"></span>
 *      ...
 *  </div>
 * ...
 * </div>
 */
app.factory('FatResizableService', function () {
    const MAIN_CLASSNAME = 'fat-resizable';
    const ITEM_CLASSNAME = MAIN_CLASSNAME + '__item';
    const HANDLER_CLASSNAME = MAIN_CLASSNAME + '__handler';
    const BAR_CLASSNAME = MAIN_CLASSNAME + '__bar';
    const COLUMN_INDEX_ATTRIBUTE_NAME = 'data-column-index';
    const COLUMN_NAME_ATTRIBUTE_NAME = 'data-column-name';
    const BAR_THICKNESS = 4;
    const ITEM_MIN_WIDTH = 60;

    let element,
        onDrop,
        resizing = false,
        downing = false,
        cursorPosition = -1,
        barDimensions = {},
        elementDimensions,
        resizableItem = null,
        resizedItemDimensions = {},
        draggingLowerBound,
        disabledTarget,
        barDOM = document.createElement('div');

    /* HELPERS */

    // Gets the resizable item matching the mouse target
    function getResizableItem(target) {
        return target.closest('.' + ITEM_CLASSNAME);
    }

    function updateBar() {
        elementDimensions = elementDimensions || getBoundingClientRect(element);
        barDimensions.left = cursorPosition;
        barDimensions.top = elementDimensions.top;
        barDOM.style.top = barDimensions.top + 'px';
        barDOM.style.left = barDimensions.left + 'px';
        barDOM.style.height = barDimensions.height + 'px';
        barDOM.style.width = barDimensions.width + 'px';
    }

    // Clean every resizing-related things
    function reset() {
        barDOM.style.top = '';
        barDOM.style.left = '';
        barDOM.style.height = '';
        barDOM.style.width = '';
        document.body.removeChild(barDOM);

        window.removeEventListener('mousemove', onMouseMove);
        window.removeEventListener('mouseup', onMouseUp);
        disabledTarget.removeEventListener('mouseup', disableClick);
        Mousetrap.unbind("esc", onEscape);

        resizing = false;
        downing = false;
        barDimensions.left = 0;
        barDimensions.right = 0;
        cursorPosition = -1;
        draggingLowerBound = null;
        resizableItem = null;
        resizedItemDimensions = {};
    }

    // Prevent the beginning of the drag
    function cancel() {
        if (resizing) {
            reset();
        } else {
            downing = false;
            resizableItem = null;
            resizedItemDimensions = {};
            window.removeEventListener('mousemove', onMouseMove);
        }
    }

    /* EVENTS LISTENERS */

    function onMouseUp() {

        if (!resizing) {
            cancel();
            return;
        }

        if (typeof onDrop === 'function') {
            let resizedWidth = cursorPosition - resizedItemDimensions.x;
            resizedWidth = resizedWidth > ITEM_MIN_WIDTH ? resizedWidth : ITEM_MIN_WIDTH;
            onDrop({
                index: resizableItem.getAttribute(COLUMN_INDEX_ATTRIBUTE_NAME),
                name: resizableItem.getAttribute(COLUMN_NAME_ATTRIBUTE_NAME),
                width: resizedWidth
            });
        }
        reset();
    }

    // When the dragging has started we do not want any click to be triggered on the element
    function disableClick(event) {
        event.stopImmediatePropagation();
        event.preventDefault();
        onMouseUp();
    }

    function onMouseMove(event) {

        // If not yet dragging, initiate drag, else update the placeholder position
        if (!resizing && downing) {

            resizing = true;
            // Bind mouseup for dragging end and click on target to prevent other listeners to be triggered
            window.addEventListener('mouseup', onMouseUp);
            disabledTarget = event.target;
            disabledTarget.addEventListener('click', disableClick);

            // Inject bar in DOM
            document.body.appendChild(barDOM);

            Mousetrap.bind("esc", onEscape);
        } else {
            cursorPosition = event.clientX;
        }

        if (!draggingLowerBound) {
            draggingLowerBound = getBoundingClientRect(resizableItem).x
        }

        // Prevent resizing beyond the previous column
        if (cursorPosition <= draggingLowerBound + ITEM_MIN_WIDTH) { return }

        updateBar();
    }

    function onMouseDown(event) {

        if (!event.target.closest('.' + HANDLER_CLASSNAME)) {
            return;
        }

        // Do not consider right click
        if (event.which === 3) {
            return;
        }

        downing = true;
        resizableItem = getResizableItem(event.target);

        window.addEventListener('mousemove', onMouseMove);

        // If a click occurred, prevent dragging
        element.addEventListener('click', cancel);

        // Prevent native drag
        event.preventDefault();

        resizedItemDimensions = getBoundingClientRect(resizableItem);
    }

    // Press escape to stop the current drag
    function onEscape() {
        if (!resizing) {
            return;
        }
        reset();
    }

    return {

        setResizable: function(options) {
            if (!options || !options.element) { return }

            onDrop = options.onDrop;
            element = options.element;

            // Prepare vertical bar used as feedback while resizing
            barDimensions.height = options.barHeight;
            barDimensions.width = BAR_THICKNESS;
            barDOM.className = BAR_CLASSNAME;

            // If clicking on a drag handler, retrieve dragged item data and attach mouse move
            element.addEventListener('mousedown', onMouseDown);
        }
    }
})

app.service('FatTouchableService', function($timeout) {
    /**
     * Make a fattable/fatrepeat scrollable through touch interaction
     * @param scope: scope of the fattable/fatrepeat directive
     * @param element: DOM element of the fattable/fatrepeat directive
     * @param fattable: fattable object of the fattable/fatrepeat directive
     * @returns function to remove event listeners added by this function
     */
    this.setTouchable = function(scope, element, fattable) {
        /**
         * Return an object wrapping callbacks. This function will be called each time a touchstart is emmited in order
         * to give callbacks to the added the touchmove and touchend event listeners.
         */
        let getOnTouchCallbacks = (function() {
            /*
             * Callbacks
             */

            /**
             * Turns the touchMoveEvent passed in parameter into a scrollOrder to the fattable
             * @param event
             */
            let startScroll;
            let lastScroll;
            let startTouch;
            let lastTouch;
            function scrollFattable(touchMoveEvent) {
                fattable.scroll.dragging = true; //otherwise fattable behaves as user had scrolled using scrollbars, which triggers multiple reflows, which is bad for performances
                touchMoveEvent.preventDefault();
                touchMoveEvent.stopPropagation();
                let newTouch = touchMoveEvent.originalEvent.changedTouches[0];

                // Tracking for direction change
                function getTouchedDistance(t) {
                    return {
                        x: startTouch.screenX - t.screenX,
                        y: startTouch.screenY - t.screenY
                    }
                }
                let touchedDistance = getTouchedDistance(newTouch);
                let lastTouchedDistance = getTouchedDistance(lastTouch);
                if (Math.abs(lastTouchedDistance) - Math.abs(touchedDistance) > 0) {
                    startTouch = lastTouch;
                    startScroll = lastScroll;
                    touchedDistance = getTouchedDistance(newTouch);
                }
                // Scrolling
                requestAnimationFrame(_ => fattable.scroll.setScrollXY(startScroll.x + touchedDistance.x, startScroll.y + touchedDistance.y));
                // Updating memory
                lastTouch = touchMoveEvent.originalEvent.changedTouches[0];
                lastScroll = {
                    x: fattable.scroll.scrollLeft,
                    y: fattable.scroll.scrollTop
                }
            }

            /**
             * Keeps track of touch velocity in order to generate momentum when touchmove will stop.
             * (Tracking will stop at touchEnd)
             * @type {number}
             */
            const SPEED_FILTER = 0.8; // Arbitrary chosen constant
            let prevScroll;
            let velocity;
            let lastTimestamp;
            let keepTrackingVelocity;
            function trackVelocity() {
                // current scroll position
                let scroll = {
                    x: fattable.scroll.scrollLeft,
                    y: fattable.scroll.scrollTop
                };
                // scrolled distance since last track
                let delta = {
                    x: scroll.x - prevScroll.x,
                    y: scroll.y - prevScroll.y
                };
                // if scroll changed direction then we do not take previous velocity into account
                let prevVelocityCoeff = {
                    x: delta.x * velocity.x > 0 ? 0.2 : 0,
                    y: delta.y * velocity.y > 0 ? 0.2 : 0,
                };
                // computing velocity
                let timeStamp = Date.now();
                velocity.x = SPEED_FILTER * delta.x * 1000 / (1 + timeStamp - lastTimestamp) + prevVelocityCoeff.x * velocity.x;
                velocity.y = SPEED_FILTER * delta.y * 1000 / (1 + timeStamp - lastTimestamp) + prevVelocityCoeff.y * velocity.y;
                // updating memory
                lastTimestamp = timeStamp;
                prevScroll = scroll;
                if (keepTrackingVelocity) {
                    $timeout(trackVelocity, 10);
                }
            }

            /**
             * Generates a momentum animation when touch stops
             * @param event
             */
            function animateMomentum() {
                keepTrackingVelocity = false;
                let endTime = Date.now();
                // Momentum appears only if velocity was greater than 10px/s
                if (Math.abs(velocity.x) > 10 || Math.abs(velocity.y) > 10) {
                    // Detach event listeners when momentum ends
                    let onMomentumEnd = function () {
                        element.off('touchstart', stopMomentumAnimation);
                        element.off('touchmove', stopMomentumAnimation);
                        fattable.scroll.dragging = false;
                    }

                    // Stop momentum on new touchevent
                    let interruptedMomentum = false;
                    let stopMomentumAnimation = function () {
                        interruptedMomentum = true;
                        onMomentumEnd();
                    }
                    element.on('touchstart', stopMomentumAnimation);
                    element.on('touchmove', stopMomentumAnimation);

                    // Compute if scroll can go further with inertia
                    let canScroll = function (delta) {
                        let canScrollH = (delta.x < 0 && fattable.scroll.scrollLeft > 0) || (delta.x > 0 && fattable.scroll.scrollLeft < fattable.scroll.maxScrollHorizontal);
                        let canScrollV = (delta.y < 0 && fattable.scroll.scrollTop > 0) || (delta.y > 0 && fattable.scroll.scrollTop < fattable.scroll.maxScrollVertical);
                        return canScrollH || canScrollV;
                    }

                    /*
                     * MOMENTUM (all formulas come from this article: https://ariya.io/2013/11/javascript-kinetic-scrolling-part-2)
                     */

                    // additional distance to scroll while momentum
                    let amplitude = {
                        x: SPEED_FILTER * velocity.x,
                        y: SPEED_FILTER * velocity.y
                    }
                    let previousScroll = {x: 0, y: 0};
                    let autoScroll = function () {
                        const TIME_CONSTANT = 325; // arbitrary constant chosen experimentally
                        let elapsedSinceStop = Date.now() - endTime; // elapsed time since touchend
                        let exponentialDecay = Math.exp(-elapsedSinceStop / TIME_CONSTANT);
                        // where scroll should be at this time (due to inertia)
                        let scroll = {
                            x: amplitude.x * (1 - exponentialDecay),
                            y: amplitude.y * (1 - exponentialDecay)
                        }
                        // missing scroll distance (where scroll should be minus where scroll is now)
                        let delta = {
                            x: scroll.x - previousScroll.x,
                            y: scroll.y - previousScroll.y
                        }
                        // scrolling of missing scrolled distance
                        fattable.scroll.setScrollXY(fattable.scroll.scrollLeft + delta.x, fattable.scroll.scrollTop + delta.y);
                        previousScroll = scroll;
                        // momentum keeps going on until amplitude is almost reached or animation got interrupted by a new touchevent
                        if ((Math.abs(amplitude.x - scroll.x) > 0.5 || Math.abs(amplitude.y - scroll.y) > 0.5) && !interruptedMomentum && canScroll(delta)) {
                            requestAnimationFrame(autoScroll);
                        } else {
                            onMomentumEnd()
                        }
                    }
                    requestAnimationFrame(autoScroll);
                }
            }

            /*
             * Actual getOnTouchCallbacks function
             */
            return function (touchStartEvent) {
                // Initialization of scrollFattable variables
                startScroll = {
                    x: fattable.scroll.scrollLeft,
                    y: fattable.scroll.scrollTop
                };
                lastScroll = {
                    x: fattable.scroll.scrollLeft,
                    y: fattable.scroll.scrollTop
                };
                startTouch = touchStartEvent.originalEvent.changedTouches[0];
                lastTouch = touchStartEvent.originalEvent.changedTouches[0];

                // Initialization of trackVelocity variables
                prevScroll = {
                    x: fattable.scroll.scrollLeft,
                    y: fattable.scroll.scrollTop
                };
                velocity = {x: 0, y: 0};
                lastTimestamp = Date.now();
                keepTrackingVelocity = true;

                return {
                    onTouchStart: function (e) {
                        trackVelocity(e);
                    },
                    onTouchMove: function (e) {
                        scrollFattable(e);
                    },
                    onTouchEnd: function (e) {
                        animateMomentum(e);
                    }
                };
            }
        })();

        function onTouchStart(event) {
            let currentOnTouchCallbacks = getOnTouchCallbacks(event, element);
            currentOnTouchCallbacks.onTouchStart();
            element.on("touchmove", currentOnTouchCallbacks.onTouchMove);
            let onTouchEnd = function(event) {
                currentOnTouchCallbacks.onTouchEnd(event);
                element.off("touchmove", currentOnTouchCallbacks.onTouchMove);
                element.off("touchend", onTouchEnd);
            }
            element.on("touchend", onTouchEnd);
        }

        element.on("touchstart", onTouchStart);

        let removeOnDestroy = scope.$on('$destroy', function() {
            element.off("touchstart", onTouchStart);
        });

        return function() {
            removeOnDestroy();
            element.off("touchstart", onTouchStart)
        }
    }
});

app.service('ClipboardUtils', function($q, $rootScope, translate, ActivityIndicator) {
    const svc = this;

    /**
     * Copy some text into the clipboard and notify users of success/failure with an ActivityIndicator banner message.
     *
     * @param text text to copy to the clipbard. If empty, does nothing and immediately resolves the promise (successfully).
     * @param successMessage Localized message to display with ActivityIndicator upon success. Use null/undefined to use the default message.
     *          Use an empty string to prevent the service from displaying any message.
     * @param errorMessage Localized message to display with ActivityIndicator in case of error. Use null/undefined to use the default message.
     *          Use an empty string to prevent the service from displaying any message in case of error.
     * @return {Promise<void>|*} A promise that resolves when 'text' has been copied to the clipboard, or if an error occurred.
     */
    svc.copyToClipboard = function(text, successMessage, errorMessage) {
        function showSuccess(triggerDigest = true) {
            if (successMessage === undefined || successMessage === null) {
                successMessage = translate('GLOBAL.CLIPBOARD.COPY_SUCCESS', 'Copied to clipboard!');
            }
            if (successMessage) {
                ActivityIndicator.success(successMessage, 5000);
                if (triggerDigest) {  // Trigger an immediate digest as we are outside AngularJS
                    $rootScope.$apply();
                }
            }
        }
        function showError(triggerDigest = true) {
            if (errorMessage === undefined || errorMessage === null) {
                errorMessage = translate('GLOBAL.CLIPBOARD.COPY_ERROR', 'Failed to copy to the clipboard!');
            }
            if (errorMessage) {
                ActivityIndicator.error(errorMessage, 5000);
                if (triggerDigest) {  // Trigger an immediate digest as we are outside AngularJS
                    $rootScope.$apply();
                }
            }
        }
        if (!text) {
            return Promise.resolve();
        }
        if (!navigator.clipboard) { // In case we are not in a secure context (for example a self-signed certificate)
            let tempInput = document.createElement("textarea");
            tempInput.style = "position: absolute; left: -1000px; top: -1000px";
            tempInput.value = text;
            document.body.appendChild(tempInput);
            tempInput.select();
            try {
                // noinspection JSDeprecatedSymbols
                if (document.execCommand("copy")) {
                    showSuccess(false);
                    return Promise.resolve();
                } else {
                    showError(false);
                    return Promise.reject(new Error('execCommand copy failed'));
                }
            } catch (err) {
                showError(false);
                return Promise.reject(err);
            } finally {
                document.body.removeChild(tempInput);
            }
        }
        return navigator.clipboard.writeText(text).then(showSuccess, showError);
    };
    // for pasting into non-editable element
    // called after capturing ctrl + v keydown event
    svc.pasteFromClipboard = function(event, callback) {
        let tempInput = document.createElement("textarea");
        tempInput.style = 'position: absolute; left: -1000px; top: -1000px';
        document.body.appendChild(tempInput);
        tempInput.select();
        // delay to capture imput value
        window.setTimeout(function() {
            let data = tempInput.value;

            callback(data);

            document.body.removeChild(tempInput);

            if (event) {
                event.currentTarget.focus();
            }
        }, 100);
    }
});

app.factory('DetectUtils', function() {
    const svc = {
        getOS: function() {
            let browser = '';

            if (navigator.appVersion.indexOf("Win") !== -1){
                browser = 'windows';
            }

            if (navigator.appVersion.indexOf("Mac")!=-1){
                browser = 'macos';
            }

            if (navigator.appVersion.indexOf("X11")!=-1){
                browser = 'unix';
            }

            if (navigator.appVersion.indexOf("Linux")!=-1){
                browser = 'linux';
            }

            return browser;
        },
        isMac: function() {
            return svc.getOS() === 'macos';
        },
        isWindows: function() {
            return svc.getOS() === 'windows';
        },
        isUnix: function() {
            return svc.getOS() === 'unix';
        },
        isLinux: function() {
            return svc.getOS() === 'linux';
        }
    };

    return svc;
});

app.constant("GRAPHIC_EXPORT_OPTIONS", {
    fileTypes: ['PDF','JPEG','PNG'],
    orientationMap: {
        'LANDSCAPE': 'Landscape',
        'PORTRAIT': 'Portrait'
    },
    paperSizeMap: {
        'A4': 'A4',
        'A3': 'A3',
        'US_LETTER': 'US Letter',
        'LEDGER': 'Ledger (ANSI B)',
        'SCREEN_16_9': '16:9 (Computer screen)',
        'CUSTOM': 'Custom'
    },
    paperSizeMapPage: {
        'A4': 'A4',
        'A3': 'A3',
        'US_LETTER': 'US Letter',
        'LEDGER': 'Ledger (ANSI B)'
    },
    paperInchesMap: {
        'A4': 11.6929,
        'A3': 16.5354,
        'US_LETTER': 11,
        'LEDGER': 17,
        'SCREEN_16_9': 11
    },
    ratioMap: {
        'A4': Math.sqrt(2),
        'A3': Math.sqrt(2),
        'US_LETTER': 11 / 8.5,
        'LEDGER': 17 / 11,
        'SCREEN_16_9': 16 / 9,
        'CUSTOM': 16 / 9
    }
});

app.service('GraphicImportService', function(GRAPHIC_EXPORT_OPTIONS) {
    const svc = this;
    svc.computeHeight = function (width, paperSize, orientation) {
        if (orientation == "PORTRAIT") {
            return Math.round(width * GRAPHIC_EXPORT_OPTIONS.ratioMap[paperSize]);
        } else {
            return Math.round(width / GRAPHIC_EXPORT_OPTIONS.ratioMap[paperSize]);
        }
    };
});

app.service('StringUtils',  function() {
    return {
        transmogrify: function(name, usedNames, makeName, offset = 2, alwaysAddSuffix = false) {
            if (! (usedNames instanceof Set)) {
                usedNames = new Set(usedNames);
            }
            if (! usedNames.has(name) && !alwaysAddSuffix) {
                return name;
            }
            if (! makeName) {
                makeName = i => `${name} ${i}`;
            }

            let i = offset;
            while (usedNames.has(makeName(i, name))) {
                i++;
            }
        return makeName(i, name);
        },
        /**
         * Compute the real width (in pixels) that a given text will take once rendered in DOM for the given font.
         */
        getTextWidth(text, font = '12px Arial', canvas) {
            if (!canvas) {
                canvas = document.createElement('canvas');
            }
            const context = canvas.getContext('2d');
            context.font = font;
            return context.measureText(text).width || 0;
        },
        /**
         * Compute the real height (in pixels) that a given text will take once rendered in DOM for the given font.
         */
        getTextHeight(text, font = '12px Arial', canvas) {
            if (!canvas) {
                canvas = document.createElement('canvas');
            }
            const context = canvas.getContext('2d');
            context.font = font;
            const metrics = context.measureText(text);
            return metrics.actualBoundingBoxAscent + metrics.actualBoundingBoxDescent || 0;
        },
        /**
         * Return a string truncated such that its length when encoded in bytes does not exceed maxBytes.
         * Useful for WT1 mixpanel event param values which have a max length of 255 bytes in utf-8.
         * @param {string} text - string to truncate
         * @param {num} maxBytes - length in bytes to not be exceeded
         * @param {string} encodingScheme - optional, to indicate encoding if not utf-8
         * @returns text truncated as necessary
         */
        truncateTextToLengthInBytes(text, maxBytes, encodingScheme = 'utf-8') {
            const encoder = new TextEncoder(encodingScheme);
            const encoded = encoder.encode(text);
            if (encoded.length <= maxBytes) {
                return text;
            }

            // We need to truncate - but we need to make sure it is still a valid string
            // if it's invalid, keep slicing off bytes until it is valid
            const decoder = new TextDecoder(encodingScheme, {fatal : true});
            let trimmedEncoded = encoded.slice(0, maxBytes);
            let decodedText = null;
            while (!decodedText){
                try {
                    decodedText = decoder.decode(trimmedEncoded);
                } catch (e) {
                    trimmedEncoded = trimmedEncoded.slice(0, trimmedEncoded.length - 1);
                }
            };
            return decodedText;
        }
    };
});

app.service('PermissionsService', function(Dialogs, Logger) {
    return {
        buildUnassignedGroups: function(item, allGroups) {
            if (!item || !allGroups) return;

            return allGroups.filter(function(groupName) {
                return item.permissions.every(perm => perm == null || perm.group !== groupName);
            });
        },
        buildUnassignedUsers: function(item, allUsers) {
            return allUsers.filter(user =>
                item.owner !== user.login && item.permissions.every(perm => perm == null || perm.user !== user.login));
        },
        transferOwnership: function(scope, item, itemName, ownerUiField="ownerLogin") {
            const ownerUi = scope.ui && scope.ui[ownerUiField];
            if (!ownerUi || !item || ownerUi === item.owner) return;
            const newOwnerDisplayName = scope.allUsers.find(user => user.login === ownerUi).displayName || ownerUi;

            Dialogs.confirm(scope, 'Ownership transfer',
                `Are you sure you want to transfer ${itemName} ownership to '${newOwnerDisplayName}' ?`).then(function() {
                Logger.info(`Transferring ${itemName} ownership to ${ownerUi}`);
                item.owner = ownerUi;
            },function() {
                scope.ui[ownerUiField] = item.owner;
            });
        }
    }
});

    app.service('FullScreenService', ['$location', '$state', function ($location, $state) {
        return {
            isFullScreen: () => $location.search().fullScreen && $location.search().fullScreen !== "false"
        }
    }]);

    app.service('MLUtilsService', function () {
        return {
            getMLCategory: (taskType, backendType, predictionType, savedModelType, proxyModelProtocol) => {
                // Keep aligned with SavedModel.getMLCategory in `SavedModel.java`
                switch (savedModelType) {
                    case 'MLFLOW_PYFUNC':
                        return 'mlflow';
                    case 'LLM_GENERIC':
                        return 'fine_tuning';
                    case 'PYTHON_AGENT':
                        return 'python_agent';
                    case 'PLUGIN_AGENT':
                        return 'plugin_agent';
                    case 'TOOLS_USING_AGENT':
                        return "tools_using_agent";
                    case 'RETRIEVAL_AUGMENTED_LLM':
                        return "retrieval_augmented_llm";
                    case 'PROXY_MODEL':
                        switch (proxyModelProtocol) {
                            case 'sagemaker':
                                return 'sagemaker';
                            case 'vertex-ai':
                                return 'vertex';
                            case 'azure-ml':
                                return 'azureml';
                            case 'databricks':
                                return 'databricks';
                        }
                    default:
                        break;
                }

                switch (taskType) {
                    case 'CLUSTERING':
                        return 'clustering';
                    case 'PREDICTION':
                        if (backendType === 'KERAS') {
                            return 'keras';
                        }
                        switch (predictionType) {
                            case 'TIMESERIES_FORECAST':
                                return 'timeseries';
                            case 'CAUSAL_REGRESSION':
                            case 'CAUSAL_BINARY_CLASSIFICATION':
                                return 'causal';
                            case 'DEEP_HUB_IMAGE_CLASSIFICATION':
                                return 'deephub_image_classification';
                            case 'DEEP_HUB_IMAGE_OBJECT_DETECTION':
                                return 'deephub_object_detection';
                        }
                    default:
                        return 'prediction';
                }
            },
        };
    });

    app.service('AgentToolService', function($rootScope) {
        const AGENT_TOOL_TYPES_UI_DATA = [
            {
                type: "InlinePython",
                typeInUI: "Inline Python",
                label: "Inline Python",
                description: "Implement your own custom tool in Python code",
                documentationLink: "/agents/tools/custom-tools",
                icon: "dku-icon-python-20",
                codeEnvSelectionSupported: true,
                containerExecutionSupported: true,
                testQuery: {},
                showStopDevKernelBtn: true,
            },
            {
                type: "DatasetRowLookup",
                label: "Dataset Lookup",
                description: "Find a record in a dataset based on conditions on one or several columns",
                documentationLink: "/agents/tools/dataset-lookup",
                icon: "dku-icon-dataset-20",
                testQuery: {
                    "input": {
                        "filter": {
                            "column": "<COLUMN_NAME>",
                            "operator": "EQUALS",
                            "value": "<VALUE>"
                        }
                    }
                },
                showStopDevKernelBtn: false,
            },
            {
                type: "VectorStoreSearch",
                label: "Knowledge Bank Search",
                description: "Search a Knowledge Bank for relevant information",
                documentationLink:"/agents/tools/knowledge-bank-search",
                icon: 'dku-icon-cards-stack-20',
                testQuery: {
                    "input": {
                        "searchQuery": "Enter search query here"
                    }
                },
                showStopDevKernelBtn: true,
            },
            {
                type: "LLMMeshLLMQuery",
                label: "Query an LLM/Agent",
                description: "Send a request to an LLM or Agent registered in the LLM Mesh",
                documentationLink:"/agents/tools/llm-mesh-query",
                icon: 'dku-icon-ai-prompt-20',
                testQuery: {
                    "input": {
                        "question": "Ask your question here"
                    }
                },
                showStopDevKernelBtn: false,
            },
            {
                type: "DatasetRowAppend",
                label: "Dataset Append",
                description: "Write a record to a Dataiku dataset",
                documentationLink:"/agents/tools/dataset-append",
                icon: "dku-icon-data-table-row-20",
                testQuery: {
                    "input": {
                        "record": {
                            "<COLUMN1_NAME>": "<COLUMN1_VALUE>",
                            "<COLUMN2_NAME>": "<COLUMN2_VALUE>"
                        }
                    }
                },
                showStopDevKernelBtn: false,
            },
            {
                type: "DataikuReporter",
                label: "Send Message",
                description: "Send a message through a Dataiku Messaging Channel (email, Slack, Teams, ...)",
                icon: "dku-icon-data-user-email-20",
                testQuery: {
                    "input": {
                        "parameters": {
                            "message": "The message to send"
                        }
                    }
                },
                showStopDevKernelBtn: false,
            },
            {
                type: "ClassicalPredictionModelPredict",
                label: "Model Predict",
                description: "Predict a record with a Dataiku model",
                documentationLink:"/agents/tools/model-predict",
                icon: "dku-icon-automl-prediction-20",
                testQuery: {
                    "input": {
                        "record": {
                            "<FEATURE1_NAME>": "<FEATURE1_VALUE>",
                            "<FEATURE2_NAME>": "<FEATURE2_VALUE>"
                        }
                    }
                },
                showStopDevKernelBtn: false,
            },
            {
                type: "GRELCalculator",
                typeInUI: "Calculator",
                label: "Calculator",
                description: "Perform arithmetic, trigonometry, boolean, date, and geometry calculations",
                documentationLink: "/agents/tools/calculator",
                icon: "dku-icon-calculator-20",
                testQuery: {
                    "input": {
                        "formula": "sqrt(441) * 2"
                    }
                },
                showStopDevKernelBtn: false,
            },
            {
                type: "ApiEndpoint",
                label: "API Endpoint",
                description: "Use any API endpoint deployed with Dataiku",
                documentationLink: "/agents/tools/api-endpoint",
                icon: "dku-icon-api-service-deploy-20",
                testQuery: {},
                showStopDevKernelBtn: false,
            },
            {
                type: "GenericStdioMCPClient",
                typeInUI: "Local MCP",
                label: "Run a local MCP server",
                description: "Use tools from any local MCP server",
                blueBoxDescription: "Configure the server settings manually or by pasting the JSON config",
                documentationLink: "/agents/tools/local-mcp",
                icon: "dku-icon-mcp-client-local-20",
                codeEnvSelectionSupported: true,
                containerExecutionSupported: true,
                testQuery: {
                    "input": {},
                    "subtoolName": "name of the subtool to use, must be enabled",
                },
                showStopDevKernelBtn: true,
            }
        ];
        if ($rootScope.appConfig && $rootScope.appConfig.customAgentTools) {
            for (let agentTool of $rootScope.appConfig.customAgentTools) {
                AGENT_TOOL_TYPES_UI_DATA.push({
                    type: "Custom_" + agentTool.desc.id,
                    label: agentTool.desc.meta.label,
                    description: agentTool.desc.meta.description,
                    documentationLink: "/agents/tools/index",
                    icon: agentTool.desc.meta.icon ?? "dku-icon-puzzle-piece-20",
                    containerExecutionSupported: true,
                    showStopDevKernelBtn: true,
                });
            }
        }

        this.listAgentToolTypesUiData = function() {
            return AGENT_TOOL_TYPES_UI_DATA;
        }

        this.getAgentToolTypesUiDataForType = function(agentToolType) {
            return AGENT_TOOL_TYPES_UI_DATA.find(toolTypeUiData => agentToolType === toolTypeUiData.type);
        }

        this.getAgentToolTypesUiData = function(agentTool) {
            return this.getAgentToolTypesUiDataForType(agentTool.type);
        }

        this.checkShowStopDevKernelBtn = function (agentToolType) {
            const toolUiData = AGENT_TOOL_TYPES_UI_DATA.find((item) => item.type === agentToolType);
            return toolUiData ? toolUiData.showStopDevKernelBtn : false;
        };

        this.getAgentToolQuickTestQueryForType = function(agentToolType) {
            const agentToolTypeUiData =  AGENT_TOOL_TYPES_UI_DATA.find(toolTypeUiData => agentToolType === toolTypeUiData.type);

            let testQuery = {"input": {}, "context": {}};
            if (agentToolTypeUiData) {
                Object.assign(testQuery, agentToolTypeUiData.testQuery);
            }

            return testQuery;
        }

    });

    app.service('TypeMappingService', function(PluginsService, RecipeDescService, TYPE_MAPPING, LoggerProvider, DashboardUtils, WebAppsService, MLUtilsService, AgentToolService) {

        this.mapRecipeTypeToName = RecipeDescService.getRecipeTypeName;

        /**
         * @param {string} type
         * @returns {string}
         */
        this.mapDatasetTypeToName = (type) => typeProcessor(type, TYPE_MAPPING.DATASET_TYPES, TYPE_MAPPING.CONVERSION_FIELD_NAME, LoggerProvider.getLogger('DisplayFilters'),
        defaultValueForDataset);

        /**
         * @param {string} type
         * @returns {string}
         */
        this.mapInsightTypeToIcon = (type, size) => this.iconProcessor(type, TYPE_MAPPING.DASHBOARDS_OR_INSIGHTS_TYPES, undefined, defaultValueForInsight(type), size);


        /**
         * @param {string} type
         * @param {number} size - Only used for new icons only, like data collections.
         * @returns {string}
         */
        this.mapTypeToIcon = (type, size) => this.iconProcessor(type, TYPE_MAPPING.ALL_TYPES, undefined, defaultValueForDataset, size);

        /**
         * @param {string} type
         * @returns {string}
         */
        this.mapOldIconTypeToModernIcon = (oldIcon, size = 16) => {
            // sometimes the input is not defined, make sure we don't make an error in that case
            if(oldIcon === undefined || oldIcon === null || oldIcon === '') {
                return oldIcon;
            }

            // Note: oldIcon may contain multiple classes
            const iconClasses = oldIcon.split(' ');

            // Find the first class that is a modern icon and add a size if missing
            const index = iconClasses.findIndex(iconClass => iconClass.startsWith('dku-icon'));
            if (index > -1) {
                const modernIcon = iconClasses[index];
                // check if icon is missing a size suffix
                if (!/(12|16|20|24|32|48)$/.test(modernIcon)) {
                    iconClasses[index] = modernIcon + '-' + size;
                }
            } else {
                // Check each icon for a modern equivalent and convert the first valid one -- otherwise just return oldIcon
                const mappedIconClasses = iconClasses.map(iconClass => TYPE_MAPPING.NEW_ICON_TYPE_MAPPING[iconClass]);
                const mappedIndex = mappedIconClasses.findIndex(iconClass => !!iconClass);
                if (mappedIndex === -1) {
                    if (window.devInstance) {
                        LoggerProvider.getLogger('icons-migration').warn(`Old icon "${oldIcon}" mapping to modern icon unsupported."`)
                    }
                } else {
                    iconClasses[mappedIndex] = `${mappedIconClasses[mappedIndex]}-${size}`;
                }
            }

            return iconClasses.join(' ');
        }

        /**
         * @param {string} subtype
         * @param {string} type
         * @param {number} size - Only used for new icons only, like data collections.
         * @returns {string}
         */
        this.mapSubtypeToIcon = (subtype, type, size) => {
            var subtypeFilters = {
                'INSIGHT': this.mapInsightTypeToIcon,
                'DATASET': this.mapDatasetTypeToIcon,
                'RECIPE': this.mapRecipeTypeToIcon,
                'WEB_APP': this.mapWebappTypeToIcon,
                'STREAMING_ENDPOINT': this.mapDatasetTypeToIcon,
                'SAVED_MODEL': this.mapSavedModelMLCategoryToIcon
            };
            if (subtype && type && subtypeFilters[type.toUpperCase()]) {
                return subtypeFilters[type.toUpperCase()](subtype, size);
            } else {
                return this.mapTypeToIcon(type, size);
            }
        }

        /**
         * @param {string} type
         * @param (boolean) forDetailView
         * @returns {string}
         */
        this.mapConnectionTypeToName = (type, forDetailView) => {
            const conversionField = forDetailView ? TYPE_MAPPING.CONVERSION_FIELD_NAME : TYPE_MAPPING.CONVERSION_FIELD_OTHER_NAME;
            return typeProcessor(type, TYPE_MAPPING.CONNECTION_TYPES, conversionField, undefined, defaultValue);
        }

        /**
         * @param {string} type
         * @returns {string}
         */
        this.mapConnectionTypeToNameForList = (type) => this.mapConnectionTypeToName(type, false);

        /**
         * @param {string} type
         * @returns {string}
         */
        this.mapConnectionTypeToNameForItem = (type) => this.mapConnectionTypeToName(type, true);

        /**
         * @param {string} type
         * @returns {string}
         */
        this.mapConnectionTypeToIcon = (type, size) => this.iconProcessor(type, TYPE_MAPPING.CONNECTION_TYPES, LoggerProvider.getLogger('connectionTypeToIcon'), defaultValue, size);

        /**
         * @param {string} type
         * @returns {string}
         */
        this.mapCredentialTypeToIcon = (type, size) => this.iconProcessor(type, TYPE_MAPPING.CREDENTIAL_TYPES, LoggerProvider.getLogger('credentialTypeToIcon'), defaultValue, size);

        /**
         * @param {string} type
         * @returns {string}
         */
        this.mapDatasetTypeToIcon = (type, size) => this.iconProcessor(type, TYPE_MAPPING.DATASET_TYPES, LoggerProvider.getLogger('datasetTypeToIcon'), defaultValueForDataset, size);

        /**
         * @param {string} type
         * @returns {string}
         */
        this.mapRecipeTypeToIcon = (type, size) => this.iconProcessor(type, TYPE_MAPPING.RECIPE_TYPES, undefined, defaultValueForRecipe, size);

        /**
         * @param {string} type
         * @returns {string}
         */
        this.mapModelTypeToIcon = (type, size) => this.iconProcessor(type, TYPE_MAPPING.ML_TYPES, undefined, defaultValueForRecipe, size);

        /**
         * @param {string} type
         * @returns {string}
         */
        this.mapRecipeTypeToLanguage = (type) => {
            function defaultToUndefined() {
                return undefined;
            }
            return typeProcessor(type,TYPE_MAPPING. RECIPE_TYPES, TYPE_MAPPING.CONVERSION_FIELD_LANGUAGE, undefined, defaultToUndefined);
        }

        /**
         * @param {string} type
         * @returns {string} one of TYPE_MAPPING.RECIPE_CATEGORIES.CODE or undefined if unknown or custom
         */
        this.mapRecipeTypeToCategory = (type) => {
            const recipeTypeObject = TYPE_MAPPING.RECIPE_TYPES[type];
            return recipeTypeObject ? recipeTypeObject.category : undefined;
        }


        /**
         * @param {string} type
         * @returns {string}
         */
        this.mapRecipeTypeToColorClass = (type) => {
            const customRecipeColors = ['red', 'pink', 'purple', 'blue', 'green', 'sky', 'yellow', 'orange', 'brown', 'gray'];

            if (!type) {
                return 'recipe-custom';
            }
            if (!RecipeDescService.isRecipeType(type) && type !== 'labeling') {
                return;
            }

            const loadedDesc = PluginsService.getRecipeLoadedDesc(type);
            if (loadedDesc) {
                let colorClass = 'recipe-custom';

                if (loadedDesc && loadedDesc.desc && loadedDesc.desc.meta) {
                    const iconColor = loadedDesc.desc.meta.iconColor;

                    if (customRecipeColors.indexOf(iconColor) > -1) {
                        colorClass = colorClass + '-' + iconColor;
                    }
                }
                return colorClass;
            }

            if (type.startsWith('App_')) {
                return 'app';
            }

            return 'recipe-' + typeProcessor(type, TYPE_MAPPING.RECIPE_TYPES, TYPE_MAPPING.CONVERSION_FIELD_CATEGORY, undefined, () => '');
        }

        /**
         * @param {string} type
         * @param {boolean} background
         * @returns {string}
         */
        this.mapTypeToColor = (type, background = false) => {
            const supportedTypes = [
                'project',
                'dataset',
                'streaming_endpoint',
                'recipe',
                'analysis',
                'notebook',
                'scenario',
                'saved_model',
                'model_evaluation_store',
                'model_comparison',
                'prompt_studio',
                'retrievable_knowledge',
                'agent_tool',
                'managed_folder',
                'web_app',
                'report',
                'dashboard',
                'insight',
                'article',
                'labeling_task',
                'app'];


            if (!type) return '';

            const recipeColor = this.mapRecipeTypeToColor(type);
            if (recipeColor) {
                return recipeColor;
            }

            const stdType = getStandardType(type);
            if (stdType && supportedTypes.indexOf(stdType) >= 0) {
                return background ? 'universe-background ' + stdType : 'universe-color ' + stdType;
            }
            return '';
        }

        /**
         *
         * @param {string} subtype a subtype to be mapped.
         * @param {string} type the "parent" type.
         * @returns  {string}
         */
        this.mapSubtypeToColor = (subtype, type) => {
            const subtypeFilters = {
                'INSIGHT': this.mapInsightTypeToColor,
                'RECIPE': this.mapRecipeTypeToColor,
                'WORKSPACE_STORY': () => 'workspace-object-datasory-icon__color',
                'SAVED_MODEL': (subType) => this.mapSavedModelTypeToClassColor(subType, true)
              };
            if (subtypeFilters[type.toUpperCase()]) {
                return subtypeFilters[type.toUpperCase()](subtype);
            } else {
                return this.mapTypeToColor(type);
            }
        }

        /**
         *
         * @param {string} taskType
         * @param {string} predictionType
         * @returns {string}
         */
        this.mapMlTaskTypeToIcon = (taskType, predictionType) => {
            if (!taskType || !predictionType) {
                return;
            }
            if (taskType.toLowerCase() == 'clustering') {
                return 'icon-clustering';
            }
            // TODO @deepHub icons for new prediction types? Otherwise, fallback
            return 'icon-prediction-' +predictionType.toLowerCase();
        }

        /**
         *
         * @param {type} taskType
         * @returns {string}
         */
        // TODO @deepHub icons for new backend? Otherwise, fallback
        this.mapBackendTypeToIcon = (type, size) => 'icon-ml ' + this.iconProcessor(type ? type.toLowerCase() : '', TYPE_MAPPING.BACKEND_TYPES, undefined, defaultValue, size);

        /**
         *
         * @param {string} taskType
         * @param {string} backendType
         * @returns {string}
         */
        this.mapAnalysisTypeToIcon = (taskType, backendType, predictionType, size) => {
            const mlCategory = MLUtilsService.getMLCategory(taskType, backendType, predictionType);

            return this.iconProcessor(mlCategory, TYPE_MAPPING.VISUAL_ANALYSIS_TYPES, undefined, defaultValue, size);
        }

        /**
         *
         * @param {string} mlCategory
         * @param {number} size
         * @returns {string}
         */
        this.mapSavedModelMLCategoryToIcon = (mlCategory, size) => {
            return this.iconProcessor(mlCategory, TYPE_MAPPING.SAVED_MODEL_TYPES, undefined, defaultValue, size);
        }

        /**
         *
         * @param {string} taskType
         * @param {string} backendType
         * @param {string} predictionType
         * @param {string} savedModelType
         * @param {string} proxyModelProtocol
         * @param {number} size
         * @returns {string}
         */
        this.mapSavedModelSubtypeToIcon = (taskType, backendType, predictionType, savedModelType, proxyModelProtocol, size) => {
            const mlCategory = MLUtilsService.getMLCategory(taskType, backendType, predictionType, savedModelType, proxyModelProtocol);
            return this.iconProcessor(mlCategory, TYPE_MAPPING.SAVED_MODEL_TYPES, undefined, defaultValue, size);
        }

        this.mapSavedModelTypeToClassColor = (savedModelType, withUniverse) => {
            let classColor = withUniverse ? 'universe-color ' : ' ';
            classColor += ['LLM_GENERIC', 'PYTHON_AGENT', 'PLUGIN_AGENT', 'TOOLS_USING_AGENT', 'RETRIEVAL_AUGMENTED_LLM'].includes(savedModelType) ? 'llm-saved-model' : 'saved-model';
            return classColor;
        };

        this.mapSavedModelMLCategoryToColor = (mlCategory, withUniverse) => {
            let classColor = withUniverse ? 'universe-color ' : ' ';
            classColor += ['fine_tuning', 'python_agent', 'plugin_agent', 'tools_using_agent', 'retrieval_augmented_llm'].includes(mlCategory) ? 'llm-saved-model' : 'saved-model';
            return classColor;
        };

        this.mapAgentToolTypeToIcon = (agentToolType, size) => {
            const uiData = AgentToolService.getAgentToolTypesUiDataForType(agentToolType);
            if (uiData === undefined) {
                return "";
            }
            return uiData.icon.replace(/20$/, size);
        };

        /**
         *
         * @param {string} type
         * @returns {string}
         */
        this.mapToFsProviderDisplayName = (type) => typeProcessor(type, TYPE_MAPPING.FS_PROVIDER_TYPES, TYPE_MAPPING.CONVERSION_FIELD_NAME, undefined, defaultValue);

        /**
         *
         * @param {string} type
         * @returns {string}
         */
        this.mapToNiceType = (type) => typeProcessor(type, TYPE_MAPPING.DATASET_TYPES, TYPE_MAPPING.CONVERSION_FIELD_NAME, undefined,
            this.mapConnectionTypeToNameForItem.bind(this))

        /**
         *
         * @param {string} type
         * @param {boolean} noBackground
         * @returns {string}
         */
        this.mapInsightTypeToColor = (type, noBackground = true) => {
            let color = '';
            switch (type) {
                case 'text':
                case 'iframe':
                case 'image':
                color = 'comments';
                break;
                default:
                color = (DashboardUtils.getInsightHandler(type) || {}).color;
                break;
            }

            return !noBackground ? 'universe-background insight-icon ' + color : color;
        }

        /**
         *
         * @param {string} type
         * @returns {string}
         */

        this.mapInsightTypeToDisplayableName = (type) => {
            var handler = DashboardUtils.getInsightHandler(type);
            if (!handler || !handler.name) return type;
            return handler.name;
        }

        this.mapWebappTypeToIcon = (type, size) => {
            return this.iconProcessor(type,  TYPE_MAPPING.WEBAPPS_TYPES, undefined, defaultValueForWebApp(type), size);
        }

        this.mapWebappTypeToColor = (type) => {
            if (WebAppsService.getBaseType(type) == type) {
                return 'notebook'; //native webapp => code color
            } else {
                return 'flow';
            }
        }

        this.mapWebappTypeToName = (type) => {
            return typeProcessor(type, TYPE_MAPPING.WEBAPPS_TYPES, TYPE_MAPPING.CONVERSION_FIELD_NAME, undefined,
                defaultValueForWebApp(type));
        }

        /**
         * @param {string} type
         * @returns {string}
         */
        this.mapRecipeTypeToColor = (type) => {
            if (!type) {
                return 'universe-color recipe-custom';
            }
            const colorClass = this.mapRecipeTypeToColorClass(type);
            if (!colorClass) {
                return '';
            }
            return 'universe-color ' + colorClass;
        }

        /**
         * @param {string} objectType
         * @returns {string}
         */
        this.mapChartTypeToColor = (objectType) => {
            if (objectType === 'dataset') {
                return 'dataset';
            } else if (objectType === 'analysis') {
                return 'analysis';
            }
            return 'chart';
        }

        /**
         *
         * @param {string} type
         * @returns {string}
         */
        const getStandardType = (type) => {
            if (!type) return '';
            if (type.endsWith('_NOTEBOOK')) {
                return 'notebook';
            }
            return type.toLowerCase();
        }

        /**
         *
         * @param {string} type
         * @param {cord<string, any>} types
         * @param {string} conversionField
         * @param {Logger} Logger
         * @param {Function} defaultValueFunction
         * @returns {string}
         */
        const typeProcessor = (type, types, conversionField, Logger, defaultValueFunction) => {
            if(!type) {
                return '';
            }
            const existingType = types[type.toLowerCase()];
            const result = existingType && existingType[conversionField];
            if (result !== undefined) {
                return result;
            }
            return defaultValueFunction(type, conversionField, Logger);
        }

        /**
         * Returns a function to be used by a mapXTypeToIcon filter.
         *
         * @param {string} type
         * @param {Record<string, any>} types
         * @param {Logger} Logger
         * @param {Function} defaultValueFunction
         * @param {number} size the size of the produced icon (only used for modern icons)
         * @returns {string}
         */
        this.iconProcessor = (type, types, Logger, defaultValueFunction, size) =>  {
            const newIconOnly = typeProcessor(type, types, 'newIconOnly', Logger, () => false);
            const icon = typeProcessor(type, types, TYPE_MAPPING.CONVERSION_FIELD_ICON, Logger, defaultValueFunction);

            if (newIconOnly) {
                if (!size) {
                    LoggerProvider.getLogger('icons-migration').warn(`New icon mapping used without size for type ${type}."`);
                    size = 16;
                }

                return icon + '-' + size;
            }

            return icon;
        }

        /**
         *
         * @param {string} key
         * @param {string} conversionField
         * @param {Logger} Logger
         * @returns {string}
         */
        const defaultValue = (key, conversionField, Logger) => {
            const defaultPrefix = TYPE_MAPPING.CONVERSION_FIELD_ICON === conversionField ? 'icon-' : '';
            const result = defaultPrefix + key.toLowerCase();
            if (Logger !== undefined) {
                Logger.error('Unknown type: ' + key + '.Returning default value: ' + result);
            }
            return result;
        }


        const defaultValueForDataset = (originalKey, conversionField, Logger) => {
            const key = originalKey.toLowerCase();
            if (key.startsWith('custom') || key.startsWith('fsprovider_') || key.startsWith('sample_')) {
                if (TYPE_MAPPING.CONVERSION_FIELD_ICON === conversionField) {
                    return PluginsService.getDatasetIcon(originalKey);
                } else {
                    return PluginsService.getDatasetLabel(originalKey);
                }
            }
            return defaultValue(key, conversionField, Logger);
        }

        const defaultValueForRecipe = (originalKey, conversionField, Logger) => {
            const key = originalKey.toLowerCase();
            if (key.startsWith('custom')) {
                if (TYPE_MAPPING.CONVERSION_FIELD_ICON === conversionField) {
                    return PluginsService.getRecipeIcon(originalKey);
                }
            } else if (key.startsWith('app_')) {
                for (let ar of window.dkuAppConfig.appRecipes) {
                    if (ar.recipeType == originalKey) {
                        return ar.icon;
                    }
                }
            }
            return defaultValue(key, conversionField, Logger);
        }


        const defaultValueForWebApp = (type) => {
            return function(originalKey, conversionField, Logger) {
                if (conversionField === TYPE_MAPPING.CONVERSION_FIELD_ICON) {
                    return WebAppsService.getWebAppIcon(originalKey) || 'icon-code';
                } else if (conversionField === TYPE_MAPPING.CONVERSION_FIELD_NAME) {
                    return WebAppsService.getWebAppTypeName(originalKey) || type;
                } else {
                    return defaultValue(originalKey.toLowerCase(), conversionField, Logger);
                }
            };
        }

        const defaultValueForInsight = (type) => {
            return function() {
                return (DashboardUtils.getInsightHandler(type) || {}).icon;
            }
        }
    });

    app.service('PrettyPrintDoubleService', function() {
        // regexp to find string values that are doubles in scientific notation
        const scientificNotationRegexp = /^[+-]?\d*(\.\d*)?[eE][+-]?\d+$/;

        // Keep this regex in sync with java class FrenchDoubleMeaning (note that we
        // removed the ? after the exponential term because we only want to detect
        // scientific notation numbers with an exponential)
        const frenchDoubleScientificNotationRegexp = /^[+-]?([0-9]{1,3} ([0-9]{3} )*)?[0-9]+(([eE][+-]?[0-9]+)$|,[0-9]+([eE][+-]?[0-9]+))$/

        // convert a double as non-scientific notation if exponent value is <= 15. Otherwise, rawValue is unchanged
        function avoidScientificNotation(rawValue) {
            let formatter = null;
            let doubleValue = null;

            if(rawValue && scientificNotationRegexp.test(rawValue)) {
                // Regular Decimal number
                // only apply on values the look like a scientific notation

                // we force en-US as a base in order to have consistent UI for all users
                formatter = new Intl.NumberFormat('en-US', {
                    numberingSystem: 'standard',
                    useGrouping: false,
                    minimumFractionDigits: 1,
                    maximumFractionDigits: 15,
                });

                doubleValue = parseFloat(rawValue); // might be nan for non-number cells
            } else if(rawValue && frenchDoubleScientificNotationRegexp.test(rawValue)) {
                // Decimal (comma), a.k.a FrenchDoubleMeaning
                // only apply on values the look like a scientific notation

                // we force fr-FR as a base in order to have consistent UI for all users
                formatter = new Intl.NumberFormat('fr-FR', {
                    numberingSystem: 'standard',
                    useGrouping: true,
                    style: "decimal",
                    minimumFractionDigits: 1,
                    maximumFractionDigits: 15,
                });

                doubleValue = parseFloat(rawValue.replace(/ /g, "").replace(/,/g,".")); // might be nan for non-number cells
            }

            if(formatter !== null && doubleValue !== null && !isNaN(doubleValue) && Math.abs(doubleValue)>=1e-15 && Math.abs(doubleValue)<1e16) {
                return formatter.format(doubleValue)
            }

            return rawValue;
        }

        // apply avoidScientificNotation to all columns that have a float or double type
        function patchFormulaPreview(previewTable, sampleType, columns) {
            previewTable.colNames.forEach((colName, colIdx) => {
                const colWithType = colIdx === 0 // first column is always output, but is not named
                    ? {type: sampleType}
                    : columns.find(col => col.name === colName);
                const colType = colWithType && colWithType.type;
                if(colType === 'double' || colType === 'float') {
                    previewTable.rows.forEach(row => {
                        row.data[colIdx] = avoidScientificNotation(row.data[colIdx]);
                    });
                }
            })
        }

        return {
            avoidScientificNotation,
            patchFormulaPreview,
        };
    })
    app.service('Deprecation', [function() {
        const deprecation = {};

        deprecation.isPythonDeprecated = (pythonInterpreter) => ["PYTHON27", "PYTHON34", "PYTHON35", "PYTHON36", "PYTHON37", "PYTHON38"].includes(pythonInterpreter);

        return deprecation;

    }]);
    app.service('PathUtils', [function() {
        const pathUtils = {};

        //set trailing slash
        pathUtils.makeT = (path) =>
            path && path.substr(-1) === '/' ? path : (path || '') + '/';

        //set no trailing slash
        pathUtils.makeNT = (path) =>
            (path || '').replace(/\/+$/, '');

        //set leading slash
        pathUtils.makeL = (path) =>
            path && path[0] === '/' ? path : '/' + (path || '');

        //set no leading slash
        pathUtils.makeNL = (path) =>
            (path || '').replace(/^\/+/, '');

        //set leading & trailing slash
        pathUtils.makeLT = (path) =>
            pathUtils.makeT(pathUtils.makeL(path));

        //set no leading & no trailing slash
        pathUtils.makeNLNT = (path) =>
            pathUtils.makeNT(pathUtils.makeNL(path));

        //concat path segments with no leading slash & no trailing slash
        pathUtils.concatNLNT =  (...paths) =>
           paths
               .filter(p => p)                        //remove undefined/null/empty entries
               .map(p => p.replace(/^\/+|\/+$/g, '')) //remove leading & ending slashes
               .filter(p => p.length>0)               //remove empty entries
               .join('/');

        //concat path segments with leading slash & no trailing slash
        pathUtils.concatLNT =  (...paths) =>
           '/' + pathUtils.concatNLNT(...paths);

        pathUtils.absPathFromUserPath = (usrPath, currentAbsPath) => {
            const path = (usrPath || '').trim();
            if (!path) return '/'; //discutable (legacy?) behavior, '' means '/'
            if (path[0] === '/') return pathUtils.makeLT(path);
            return pathUtils.concatLNT(currentAbsPath, path);
        };

        return pathUtils;
    }]);

app.service('ClipboardReadWriteService', function(ClipboardUtils, CreateModalFromTemplate) {
    const writeItemsToClipboard = function(items, separator = "\n") {
        let toCopy = "";
        if (items && items.length) {
            toCopy = items.join(separator);
        }
        ClipboardUtils.copyToClipboard(toCopy);
    }

    const readItemsFromNavigatorClipboard = async function() {
        if (!navigator.clipboard || !navigator.clipboard.readText) {
            throw new Error('Browser does not support the readText API');
        }

        try {
            const data = await navigator.clipboard.readText();
            if (!data) return;

            let items = data.trim().split(/[\r\n]+/);
            if (items && Array.isArray(items) && items.length > 0) {
                if (items.length === 1) {
                    items = items[0].split(",").map(e => e.trim());
                }
                return items;
            }
        } catch (error) {
            throw new Error('Failed to read from clipboard');
        }
    };

    const readItemsUsingPopup = async function(scope, popupHeader) {
        return new Promise((resolve, reject) => {
            let newScope = scope.$new();
            CreateModalFromTemplate("/templates/list-copy-paste-modal.html", newScope, 'PasteModalController', function(modalScope) {
                modalScope.header = popupHeader;

                // Override the onPasteText defined in the PasteModalController
                modalScope.onPasteText = function(event) {
                    let data = event.originalEvent.clipboardData.getData('text/plain');
                    if (!data) {
                        modalScope.uiState.hasError = true;
                        return;
                    }
                    try {
                        let stringArray = data.trim().split(/[\r\n]+/);
                        if (!stringArray || !Array.isArray(stringArray) || stringArray.length === 0) {
                            modalScope.uiState.hasError = true;
                            reject(new Error('Not a valid array'));
                            return;
                        }

                        if (stringArray.length === 1) {
                            stringArray = stringArray[0].split(",").map(e => e.trim());
                        }

                        let classes = stringArray.map((class_label, index) => ({ class_label, index }));
                        if (!modalScope.validateData(classes)) {
                            modalScope.uiState.hasError = true;
                            reject(new Error('Invalid data'));
                            return;
                        }

                        modalScope.uiState.editMode = false;
                        modalScope.uiState.hasError = false;
                        modalScope.uiState.items = classes;
                    } catch (error) {
                        modalScope.uiState.hasError = true;
                        reject(error);
                    }
                };

                modalScope.pasteItems = function() {
                    resolve(modalScope.uiState.items.map(item => item.class_label));
                };

                modalScope.validateData = (classes) => {
                    try {
                        return classes.every(aClass => aClass.class_label.length > 0);
                    } catch (e) {
                        return false;
                    }
                }
            });
        });
    }

    const readItemsFromClipboard = async function(scope, popupHeader) {
        try {
            return await readItemsFromNavigatorClipboard();
        } catch (_) {
            return await readItemsUsingPopup(scope, popupHeader)
        }
    }

    return {
        writeItemsToClipboard: writeItemsToClipboard,
        readItemsFromClipboard: readItemsFromClipboard
    }

});


app.service("FilePatternUtils", function(){

    //if there is a char like this in the glob string we need to replace - Does not include * or ? which mean something in GLOB
    const REGEXP_CHARS_PATTERN = /[/\-\\^$+.()|[\]{}]/g;

    //Replace with escaped match
    const REGEXP_CHARS_REPLACEMENT = '\\$&';

    // basically matches /**/ or **/ at the beginning but final slash not included in the capture and clever things so it is not inefficient
    const DEEP_WILDCARD_PATTERN = /(?<=^|\/)\*\*(?=$|\/)/g;

    const srv = {
        /**
         * Convert a glob string to a regexp to use on file paths.
         * It is not a global regexp, it is not stateful, and either matches the whole path string or not.
         * E.g. use `.test(path)` to see if this matches given path.
         *
         * Follows implemention in com.dataiku.dip.fs.FileSelectionRule.java
         *
         * @param {string} expr GLOB string
         * @returns {RegExp}
         * @throws exception if expr could not be compiled as a regexp
         */
        fullPathGlobRegExp: function(expr) {
            expr = expr.trim();
            DEEP_WILDCARD_PATTERN.lastIndex = 0;
            let specs = expr.replaceAll(/\/+/g, "/").split(DEEP_WILDCARD_PATTERN);
            let globRegExpString = "^";

            if (expr === "**" || expr === "**/*") {
                // Simplest to hard code these to match anything
                globRegExpString += ".*";
            } else {
                if (expr.startsWith("**/")) {
                    globRegExpString += "(?:^|.*?/)"; // can be any prefix path, including empty
                    specs = specs.slice(1);
                    if (specs.length > 0) {
                        specs[0] = specs[0].substring(1); // eat up the leading / from the next spec, / included above
                    }
                }

                for (let i = 0; i < specs.length; i++) {
                    let spec = specs[i];
                    if (i > 0) {
                        globRegExpString += ".*?(?<=\\/)";  // `**` is any char sequence denoting intermediate directories, including empty
                        spec = spec.substring(1); // eat up the leading / from the upcoming spec, / mandatory above
                    }

                    REGEXP_CHARS_PATTERN.lastIndex = 0;
                    globRegExpString += spec.replaceAll(REGEXP_CHARS_PATTERN, REGEXP_CHARS_REPLACEMENT)
                                        .replaceAll("?", "[^/]")     // `?` is any char but /
                                        .replaceAll("*", "[^/]*");  // `*` is any char sequence (including empty) without /   (NOTE: removed  ? from end of replacement that is in the backend)
                }

                if (expr.endsWith("/**")) {
                    // note this is .++ in backend, the extra + for possessive, but this is not possible in JS
                    globRegExpString += ".+";  // `**` is any char sequence
                }
            }

            globRegExpString += "$";

            // g flag not needed (and we'd would have to reset the lastIndex every time)
            return new RegExp(globRegExpString, "i");
        },

        /**
         * Convert a glob string to a regexp to use on file names (not whole paths just the name)
         * It is not a global regexp, it is not stateful, and either matches the whole name string or not.
         * E.g. use `.test(filename)` to see if this matches given name.
         *
         * Follows implemention in com.dataiku.dip.fs.FileSelectionRule.java - globChunkMatches()
         *
         * @param {string} expr GLOB string for a file name (not a path)
         * @returns {RegExp}
         * @throws exception if expr could not be compiled as a regexp
         */
        fileNameGlobRegExp: function(expr) {
            REGEXP_CHARS_PATTERN.lastIndex = 0;
            let globRegexString = "^"+ expr.replaceAll(REGEXP_CHARS_PATTERN, '\\$&')
                               .replaceAll("?", ".")    // `?` is any char
                               .replaceAll("*", ".*?")  // `*` is any char sequence (including empty)
                            + "$";

            // g flag not needed (and we'd would have to reset the lastIndex every time)
            return new RegExp(globRegexString, "i");
        },

        // Removes leading and trailing `/` slashes and collapses multiple to one where they are retained
        // Returns empty string if nothing left after this
        // Equivalent to PathUtils.slashes(path, false, false, true, "");
        normalizeSlashes: function (path) {
            const trimmedPath =  path.trim();
            if (!trimmedPath) return null;
            const collapsedPath  = path.trim().replaceAll(/\/+/g, "/");
            const slashAtStart = collapsedPath.startsWith("/");
            const slashAtEnd = collapsedPath.endsWith("/");

            if (slashAtStart) {
                return slashAtEnd ? collapsedPath.slice(1, -1) : collapsedPath.slice(1);
            } else {
                return slashAtEnd ?  collapsedPath.slice(0, -1) : collapsedPath;
            }
        },

        /**
         * @param {string} path - file path ending in file name -  must be normalised with normalizeSlashes
         * @returns file name at the end of the path with no slashes
         */
        extractFileNameFromPath: function (path) {
            if (!path) return null;
            return path.substring(path.lastIndexOf('/') + 1);
        }
    };
    return srv;
});

app.service('DataikuCloudService', function($q, DataikuAPI, $rootScope) {
    this.isDataikuCloud = function() {
        return $rootScope.appConfig.deploymentMode === 'CLOUD';
    };

    this.getLaunchpadUrl = function() {
        if (!this.isDataikuCloud()) {
            return;
        }

        const saasFrontendHook = window.dkuSaas || {}

        const host = saasFrontendHook.API_HOST || ''; // format is usually api-XXXXXXXX-YYYYYYY, though "api" can change
        const hostMatch = host.match(/[a-z-]*-.{8}-(.{8})/);
        const spaceId = hostMatch ?  (hostMatch.length > 1 ? hostMatch[1] : '') : '';

        return `${saasFrontendHook.URL_CONSOLE}/spaces/${spaceId}`;
    }

    this.getCloudInfo = function() {
        const info = {
            isDataikuCloud: this.isDataikuCloud(),
            isSpaceAdmin: $rootScope.appConfig.admin
        };
        const deferred = $q.defer();
        deferred.resolve(info);
        return deferred.promise;
    }
});

app.service('PuppeteerLoadedService', function (Debounce) {
    this.getDebouncedSetField = function($scope, $element, loadedStateField) {
        const setPuppeteerField = function() {
            const thisLoadedStateField = loadedStateField ? loadedStateField : "puppeteerHook_elementContentLoaded";

            $scope[thisLoadedStateField] = true;
            // in cases where we set a specific field, we set it also as an attribute on the element to be used by the puppeteer code css selector
            if (loadedStateField) {
                $element.attr(loadedStateField, true);
            }
        };

        return Debounce().withDelay(50,200).wrap(setPuppeteerField);
    };
});

//this is a singleton to share the rating feedback parameters for all AI features
app.factory("RatingFeedbackParams", () => {
    const state = {
        requestIdForFeedback: null,
        featureRated: null,
        showRatingFeedback: false,
    };

    return state;
});

app.factory("AvailableLanguages", ($rootScope) => {
    let languageList = [{id: 'en', label: 'English'}, {id: 'ja', label: '日本語'}, { id: 'fr', label: 'Français' }]
    languageList.sort((a, b) => a.label.localeCompare(b.label));
    return languageList;
});

app.service('ProfileService', function ($rootScope) {
    this.isTechnicalAccount = function () {
        return $rootScope?.appConfig?.userProfile?.profile === 'TECHNICAL_ACCOUNT';
    }
});

app.factory('AccessibleObjectsCacheService', function(DataikuAPI, $q) {
    const TYPE_WITHOUT_PROJECT_KEY = ['PROJECT', 'WORKSPACE', 'DATA_COLLECTION', 'APP'];
    const EMPTY_ARRAY = [];
    const EMPTY_CACHE_ENTRY = { value: EMPTY_ARRAY, promise: $q.when(EMPTY_ARRAY) }; // avoid having subsequent calls with the same param return a different ref

    const svc = {
        /**
         * Get a cached lazy accessible object getter. API query are done automatically on request, but shared between many calls with the same parameters.
         * Designed to share API call data between many object-picker instances or similar in order to avoid doing the same API queries multiple times
         *
         * Usage example to select many projects without doing one project list call per selector:
         * $scope.getAccessibleObjects = AccessibleObjectsCacheService.createCachedGetter('READ', setErrorInScope.bind($scope)).asValue;
         * (...)
         *  <div ng-for="item of manySelectors"
         *     type="PROJECT" object-picker="item.projectKey"
         *     input-available-objects="getAccessibleObjects('PROJECT')"
         *  ></div>
         *
         * @param {string} mode 'READ' or 'WRITE' to filter on readable or writeable objects (default 'READ')
         * @param {function} setErrorInScopeFunction If provided, used in API call catch statement to set API call error in the scope
         * @returns {object} Object containing two functions (keys `asValue` or `asPromise`)
         *
         * The asValue function:
         *      @param {string} type Type of the accessible objects to list (e.g. 'PROJECT', 'WORKSPACE', 'DATASET', 'WEB_APP', ...)
         *      @param {string} projectKey (optional for types that are not project objects)
         *      @returns {AccessibleObject[]} empty array while API query is pending, then the list of object once API call is finished (do not snapshot the returned value!)
         *
         * The asPromise function:
         *      @param {string} type Type of the accessible objects to list (e.g. 'PROJECT', 'WORKSPACE', 'DATASET', 'WEB_APP', ...)
         *      @param {string} projectKey (optional for types that are not project objects)
         *      @returns {Promise<AccessibleObject[]>} Promise of the list of objects (do not snapshot the returned value!)

         */
        createCachedGetter(mode = "READ", setErrorInScopeFunction = () => {}) {
            const cache = {};
            return {
                asValue: (type, projectKey) => getAccessibleObjects(type, projectKey, mode, cache, setErrorInScopeFunction).value,
                asPromise: (type, projectKey) => getAccessibleObjects(type, projectKey, mode, cache, setErrorInScopeFunction).promise,
            };
        },
    }

    return svc;

    //////////////

    function getAccessibleObjects(type, projectKey, mode, accessibleObjectsCache, setErrorInScopeFunction) {
        if (!type) {
            return EMPTY_CACHE_ENTRY;
        }

        if(TYPE_WITHOUT_PROJECT_KEY.includes(type)) {
            if (angular.isDefined(accessibleObjectsCache[type])) {
                return accessibleObjectsCache[type];
            }

            const listingPromise = DataikuAPI.taggableObjects.listAccessibleObjects(undefined, type, mode).then(function({data}) {
                accessibleObjectsCache[type].value = data;
                return data;
            }).catch(setErrorInScopeFunction);
            accessibleObjectsCache[type] = { value: EMPTY_ARRAY, promise: listingPromise };

            return accessibleObjectsCache[type];
        } else {
            if(!projectKey) {
                return EMPTY_CACHE_ENTRY;
            }
            if(!angular.isDefined(accessibleObjectsCache[type])) {
                accessibleObjectsCache[type] = {}
            }
            if(angular.isDefined(accessibleObjectsCache[type][projectKey])) {
                return accessibleObjectsCache[type][projectKey];
            }

            const listingPromise = DataikuAPI.taggableObjects.listAccessibleObjects(projectKey, type, mode).then(function({data}) {
                accessibleObjectsCache[type][projectKey].value = data;
                return data;
            }).catch(setErrorInScopeFunction);
            accessibleObjectsCache[type][projectKey] = { value: EMPTY_ARRAY, promise: listingPromise };

            return accessibleObjectsCache[type][projectKey]
        }
    }
});

app.service('SemanticVersionService', function ($rootScope) {
    this.compareVersions = function (version1, version2) {
            const splitVersion = (v) => v.split('.').map(Number);
            const [v1, v2] = [splitVersion(version1), splitVersion(version2)];

            for (let i = 0; i < Math.max(v1.length, v2.length); i++) {
                const num1 = v1[i] || 0;
                const num2 = v2[i] || 0;

                if (num1 > num2) return 1;
                if (num1 < num2) return -1;
            }
            return 0;
        }
});

app.service('ProjectStandardsService', function() {
    const STATUS = {
        RUN_SUCCESS: 'RUN_SUCCESS',
        RUN_ERROR: 'RUN_ERROR',
    };

    function mapSeverity(result) {
        switch (result.status) {
            case STATUS.RUN_SUCCESS:
                return result.severity;
            default:
                return 0;
        }
    }

    function getProjectStandardsSummaryFromReport(projectStandardsRunReport) {
        const bundleChecksRunInfo = Object.values(projectStandardsRunReport.bundleChecksRunInfo);
        const worstSeverityNumber = Math.max(
                ...bundleChecksRunInfo.map(runInfo =>
                    mapSeverity(runInfo.result)
                ),
                0
            );
        return {
            worstSeverityNumber: worstSeverityNumber,
            checksInError: bundleChecksRunInfo.filter(c => c.result.status === STATUS.RUN_ERROR).length,
            checkCount: bundleChecksRunInfo.length,
        }
    }

    function getProjectStandardsSummaryFromRunReportSummary(projectStandardsRunReportSummary) {
        const checkCount = Object.values(projectStandardsRunReportSummary.nbOfChecksBySeverity).reduce((acc, val) => acc + val, 0)
                             + projectStandardsRunReportSummary.nbOfChecksNotApplicable
                             + projectStandardsRunReportSummary.nbOfChecksInError;
        const severitiesWithAtLeastOneCheck = Object.entries(projectStandardsRunReportSummary.nbOfChecksBySeverity)
                                      .filter(([key, value]) => value > 0)
                                      .map(([key, value]) => key);
        return {
            worstSeverityNumber:  Math.max(...severitiesWithAtLeastOneCheck, 0),
            checksInError: projectStandardsRunReportSummary.nbOfChecksInError,
            checkCount: checkCount,
        }
    }

    return {
        getProjectStandardsSummaryFromReport: getProjectStandardsSummaryFromReport,
        getProjectStandardsSummaryFromRunReportSummary: getProjectStandardsSummaryFromRunReportSummary,
        STATUS: STATUS
    }
});

})();

;
(function() {
'use strict';

var app = angular.module('dataiku.controllers');

 // TODO : move those controllers !!


 app.controller('ConfirmDialogController', function($scope) {
    // Focus should already have been stolen in the
    // template, but sometimes it does not work ...
    window.setTimeout(function(){
        $(":focus").blur()
    }, 0);
    $scope.confirm = function() {
       if($scope.acceptDeferred) {
           $scope.acceptDeferred.resolve("Accepted");
       }
       $scope.acceptDeferred = null;
       $scope.dismiss();
   };
   $scope.cancel = function() {
       if($scope.acceptDeferred) {
           $scope.acceptDeferred.reject("Cancelled");
       }
       $scope.acceptDeferred = null;
       $scope.dismiss();
   };
});


app.controller('PromptDialogController', function($scope) {
    $scope.confirm = function() {
        if($scope.acceptDeferred) {
            $scope.acceptDeferred.resolve($scope.value);
        }
        $scope.acceptDeferred = null;
        $scope.dismiss();
    };
    $scope.cancel = function() {
        if($scope.acceptDeferred) {
            $scope.acceptDeferred.reject();
        }
        $scope.acceptDeferred = null;
        $scope.dismiss();
    };
});


app.controller('SelectDialogController', function($scope) {
    $scope.confirm = function() {
        if($scope.acceptDeferred) {
            $scope.acceptDeferred.resolve($scope.selectedItem);
        }
        $scope.acceptDeferred = null;
        $scope.dismiss();
    };
    $scope.cancel = function() {
        if($scope.acceptDeferred) {
            $scope.acceptDeferred.reject();
        }
        $scope.acceptDeferred = null;
        $scope.dismiss();
    };
    $scope.selectItem = function(item) {
        if (item.selectable != false) {
            $scope.selectedItem = item;
        }
    };

});

app.controller('ConflictDialogController', function($scope) {
    $scope.erase = function() {
        if($scope.acceptDeferred) {
            $scope.acceptDeferred.resolve("erase");
        }
        $scope.acceptDeferred = null;
        $scope.dismiss();
    };

    $scope.cancel = function() {
        if($scope.acceptDeferred) {
            $scope.acceptDeferred.reject();
        }
        $scope.acceptDeferred = null;
        $scope.dismiss();
    };

    $scope.forget = function() {
        if($scope.acceptDeferred) {
            $scope.acceptDeferred.resolve("ignore");
        }
        $scope.acceptDeferred = null;
        $scope.dismiss();
    };
});

app.controller('PasteModalController', function($scope, DetectUtils, WT1) {
    $scope.os = DetectUtils.getOS();

    $scope.uiState = {
        editMode: true,
        hasError: false,
        items: [],
        type: ''
    };

    $scope.validateData = $scope.validateData || (() => true);

    $scope.onPasteText = function(event) {
        let data = {};

        try {
            data = JSON.parse(event.originalEvent.clipboardData.getData('text/plain'));
        } catch (e) { /* Nothing for now */ }
        if (typeof $scope.applyGenericFormat === 'function') {
            data = $scope.applyGenericFormat(data);
        }
        if (data[$scope.itemKey] 
            && data[$scope.itemKey].length 
            && $scope.copyType === data.type
            && $scope.validateData(data[$scope.itemKey])) {
            let items = data[$scope.itemKey];

            if (typeof $scope.formatData === 'function') {
                items = $scope.formatData(data[$scope.itemKey]);
            }

            $scope.uiState.editMode = false;
            $scope.uiState.hasError = false;
            $scope.uiState.items = items;
            $scope.uiState.type = data.type;
        } else {
            $scope.uiState.hasError = true;
        }

        event.preventDefault();
    };

    $scope.confirm = function(data) {
        $scope.pasteItems($scope.uiState.items, data);
        WT1.event('paste-modal-submit', { dataType: $scope.uiState.type });
        $scope.dismiss();
    };
});

app.controller('ShareInWorkspaceDialogController', function($scope, DataikuAPI, $state, WorkspaceDisplayService, WT1) {
    const shareInWorkspaceDialogCtrl = this;

    // Exposed objects
    shareInWorkspaceDialogCtrl.modalTitle = undefined;
    shareInWorkspaceDialogCtrl.selectedObjects = undefined;
    shareInWorkspaceDialogCtrl.share = share;
    shareInWorkspaceDialogCtrl.workspaceKey = undefined;
    shareInWorkspaceDialogCtrl.workspacesList = [];
    shareInWorkspaceDialogCtrl.isObjectAuthorized = undefined;

    //////////////////

    let succeeded = false;

    $scope.init = (selectedObjects) => {
        shareInWorkspaceDialogCtrl.selectedObjects = selectedObjects;
        shareInWorkspaceDialogCtrl.modalTitle = getModalTitle(shareInWorkspaceDialogCtrl.selectedObjects);
        shareInWorkspaceDialogCtrl.numObjectsToShare = 0;
        WT1.event('workspaces-add-object-open', { from: 'share' });

        if (!selectedObjects.every(object => (object.reference && object.reference.type === 'DASHBOARD') || object.appId)) {
            const projectKey = selectedObjects[0].reference.projectKey;
            DataikuAPI.projects.getDashboardAuthorizations(projectKey, false).noSpinner().success(data => {
                if (!data.allAuthorized) {
                    shareInWorkspaceDialogCtrl.numObjectsToShare = selectedObjects.reduce((result, object) => {
                        if (object.reference.type === 'DASHBOARD' ||
                            data.authorizations.find(({ objectRef, modes }) => 
                                objectRef.objectId === object.reference.id &&
                                objectRef.objectType === object.reference.type &&
                                modes.includes('READ')
                            )
                        ) {
                            return result;
                        }
                        return result + 1;
                    }, 0);
                }
            }).error(setErrorInScope.bind($scope));
        }
    };

    $scope.$on('$destroy', () => {
        if (!succeeded) {
            WT1.event('workspaces-add-object-cancel', { from: 'share' });
        }
    });

    function getModalTitle(selectedObjects) {
        let modalTitle;

        switch (selectedObjects.length) {
            case 1:
                if (selectedObjects[0].reference) {
                    modalTitle = `Publish ${selectedObjects[0].reference.type.toLowerCase()} in workspace`;
                } else if (selectedObjects[0].appId) {
                    modalTitle = "Publish application in workspace";
                } else {
                    modalTitle = "Publish object on a workspace";
                }
            break;
            default:
                modalTitle = `Share ${ selectedObjects.length } objects in workspace`;
            break;
        }
        return modalTitle;
    }

    DataikuAPI.workspaces.list("WRITE").success(workspacesList => {
        shareInWorkspaceDialogCtrl.workspacesList = workspacesList;
    }).error((data, status, headers, config, statusText) => {
        setErrorInScope.bind($scope.errorScope || $scope.$parent)(data, status, headers, config, statusText);
    });

    function share() {
        const objectsToShare = shareInWorkspaceDialogCtrl.selectedObjects.map(so => {
            if (so.reference) {
                return { ...so, reference: { ...so.reference, workspaceKey: shareInWorkspaceDialogCtrl.workspaceKey }};
            }
            return so;
        });
        DataikuAPI.workspaces.addObjects(shareInWorkspaceDialogCtrl.workspaceKey, objectsToShare).success(() => {
            succeeded = true;
            const multi = objectsToShare.length > 1;
            objectsToShare.forEach(object =>
                WT1.event('workspaces-add-object-success', { from: 'share', objectType: WorkspaceDisplayService.getObjectType(object), multi })
            );
            $state.transitionTo('workspaces.workspace', { workspaceKey: shareInWorkspaceDialogCtrl.workspaceKey });
        }).error((data, status, headers, config, statusText) => {
            setErrorInScope.bind($scope.errorScope || $scope.$parent)(data, status, headers, config, statusText);
        });
    }
});

app.controller('AddToDataCollectionDialogController', function($scope, $rootScope, DataikuAPI, ActivityIndicator, StateUtils, WT1, $q, $state, CreateModalFromTemplate, ActiveProjectKey) {
    // This modal is used from many places (in the object's source project, in a project they are shared to, in the data catalog...). Be careful to not add code that relies on any assumption about which page is currently opened.

    const $ctrl = this;

    // Exposed objects
    $ctrl.canWriteProject = $rootScope.topNav.isProjectAnalystRW;
    $ctrl.addObjects = addObjects;
    $ctrl.addIsDisabled = addIsDisabled;
    $ctrl.completenessIssuesMessage = completenessIssuesMessage
    $ctrl.dataCollectionItem = undefined;
    $ctrl.completenessChecksMessageLevelColumns = undefined;
    $ctrl.completenessChecksMessageLevelDesc = undefined;
    $ctrl.excludedObjects = undefined;
    $ctrl.objectWithColumnsIssue = [];
    $ctrl.objectWithDescriptionIssue = [];
    $ctrl.ICONS_METADATA = [ "dku-icon-checkmark-16 text-success", "dku-icon-info-circle-outline-16 text-info", "dku-icon-warning-outline-16 text-warning", "dku-icon-dismiss-16 text-error" ];
    $ctrl.dataCollectionsList = [];
    $ctrl.authPopoverMessageMulti = `Datasets with no object authorization will not be visible in the data-collection for users who don't have read access to the project.  \n<a target="_blank" href="${$rootScope.versionDocRoot}data-catalog/data-collections/permissions-and-dataset-visibility.html">More details in the documentation</a>`;

    let succeeded = false;

    function getDatasetCompletenessInfo(object) {
        let tooltip = "";
        let iconLevel = 0; // Represents severity: 0 (OK), 1 (Info), 2 (Warning), 3 (Error)

        const completenessChecks = $ctrl.dataCollectionItem?.metadataCompletenessChecks;
        const dataCollectionQualityIsDefault = completenessChecks?.longDescriptionCheck === "DISABLED" && completenessChecks?.columnsDescriptionCheck === "DISABLED";

        const showDefaultMessageForInfoStatus = dataCollectionQualityIsDefault || !$ctrl.dataCollectionItem;

        const processSingleCheck = (status, config) => {
            let msg = "";
            let icon = 0; // Default icon level (0 for OK)

            switch (status) {
                case "ERROR":
                    msg = config.error.msg;
                    icon = config.error.icon;
                    break;
                case "WARNING":
                    msg = config.warning.msg;
                    icon = config.warning.icon;
                    break;
                default: 
                    if (showDefaultMessageForInfoStatus) {
                        msg = config.default.msg;
                        icon = config.default.icon;
                    }
            }
            return { msg, icon };
        };

        // Dataset Description Check
        if (object && !object.hasLongDescription) {
            const datasetDescConfig = {
                error:   { msg: "You must set a long description", icon: 3 },
                warning: { msg: "You should set a long description", icon: 2 },
                default: { msg: "Missing dataset long description", icon: 1 } 
            };
            const result = processSingleCheck(completenessChecks?.longDescriptionCheck, datasetDescConfig);
            tooltip = result.msg;
            iconLevel = result.icon;
        }

        // Columns Description Check
        if (object && object.numberOfEmptyColumns !== 0) {
            const columnsDescConfig = {
                error:   { msg: `You must fill in ${object.numberOfEmptyColumns}/${object.totalNumberOfColumns} columns description`, icon: 3 },
                warning: { msg: `You should fill in ${object.numberOfEmptyColumns}/${object.totalNumberOfColumns} columns description`, icon: 2 },
                default: { msg: `Missing ${object.numberOfEmptyColumns}/${object.totalNumberOfColumns} columns description`, icon: 1 } 
            };
            const result = processSingleCheck(completenessChecks?.columnsDescriptionCheck, columnsDescConfig);
            if (tooltip.length > 0) {
                tooltip += " <br/>";
            }
            tooltip += result.msg;
            iconLevel = Math.max(iconLevel, result.icon);
        }
        return {
            message: tooltip,
            icon: $ctrl.ICONS_METADATA[iconLevel]
        };
    };

    $ctrl.getDatasetCompletenessMessage = function(object) {
        return getDatasetCompletenessInfo(object).message;
    }

    $ctrl.getDatasetCompletenessIcon = function(object) {
        return getDatasetCompletenessInfo(object).icon;
    }

    $ctrl.generateDatasetDescription = function(obj) {
        if ($ctrl.canWriteProject === undefined) {
            //from the data catalog page, we have no project, so no $rootScope.topNav.isProjectAnalystRW;
            DataikuAPI.projects.getSummary(obj.projectKey).success(data => {
                        $ctrl.canWriteProject = data.object.canWriteProjectContent;
            });
        }
        // we can use object.projectKey as contextProjectKey because if we get to here it means we have the publish to collection auth, which implies read on the source project. So a call 'from the source project' will succeed, regardless of where we actually are.
        DataikuAPI.datasets.get(obj.projectKey, obj.id, obj.projectKey).noSpinner()
            .success(function(data) {
                $scope.object = data;
                $scope.canWriteProject = () => $ctrl.canWriteProject;
                CreateModalFromTemplate(
                    "/static/dataiku/ai-dataset-descriptions/generate-documentation-modal/generate-documentation-modal.html",
                    $scope,
                    "AIDatasetDescriptionsModalController"
                ).then(() => {
                    // refresh the dataset status
                    DataikuAPI.datasets.getFullInfo(obj.projectKey, obj.projectKey, obj.id)
                    .then(({data}) => $ctrl.updateObjectInfo(data, obj));
                });
            }).error(setErrorInScope.bind($scope));
        };

    $ctrl.getDatasetEditSchemaHref = function(obj) {
        return obj.subType === 'Inline'
            ? $state.href('projects.project.datasets.dataset.edit', {projectKey: obj.projectKey, datasetName: obj.id})
            : $state.href('projects.project.datasets.dataset.settings', {projectKey: obj.projectKey, datasetName: obj.id, '#': 'schema'});
    };

    function addIsDisabled(addToDataCollectionForm) {
        if( !$ctrl.filteredSelectedObjects || !addToDataCollectionForm || $ctrl.filteredSelectedObjects.length === 0) {
            return true;
        }
        if (addToDataCollectionForm && addToDataCollectionForm.$invalid) {
            return true;
        }
        return $ctrl.filteredSelectedObjects.some(obj => {
            if (obj.numberOfEmptyColumns !== 0 && $ctrl.dataCollectionItem?.metadataCompletenessChecks?.columnsDescriptionCheck == "ERROR" ) {
                return true;
            }
            if (!obj.hasLongDescription && $ctrl.dataCollectionItem?.metadataCompletenessChecks?.longDescriptionCheck == "ERROR" ) {
                return true;
            }
            return false;
        });
    }

    $ctrl.updateObjectInfo = function(data, object) {
        object.hasLongDescription = data.dataset.description !== undefined && data.dataset.description.trim().length > 0;

        let numberOfEmptyColumns = 0;
        let totalNumberOfColumns = 0;
        const columns = data.dataset.schema?.columns;

        if (Array.isArray(columns)) {
            totalNumberOfColumns = columns.length;
            numberOfEmptyColumns = columns.filter(column =>
                !column.comment || column.comment.trim() === ''
            ).length;
        }

        object.numberOfEmptyColumns = numberOfEmptyColumns;
        object.totalNumberOfColumns = totalNumberOfColumns;
        const allColumnDescriptionsFilled = numberOfEmptyColumns === 0;

        const colIndex = $ctrl.objectWithColumnsIssue.indexOf(object.displayName);
        if (!allColumnDescriptionsFilled && colIndex === -1) {
            $ctrl.objectWithColumnsIssue.push(object.displayName);
        }else if (colIndex > -1) {
            $ctrl.objectWithColumnsIssue.splice(colIndex, 1);
        }
        const descIndex = $ctrl.objectWithDescriptionIssue.indexOf(object.displayName);
        if (!object.hasLongDescription && descIndex === -1) {
            $ctrl.objectWithDescriptionIssue.push(object.displayName);
        }else if (descIndex > -1) {
            $ctrl.objectWithDescriptionIssue.splice(descIndex, 1);
        }
        return object.id;
    };

    $scope.init = (selectedObjects, wt1Context = {}) => {
        $ctrl.wt1Context = wt1Context;
        $ctrl.modalTitle = getModalTitle();
        $ctrl.nbFilteredObjects = 0;

        DataikuAPI.dataCollections.getObjectsAuthorizations(selectedObjects.map(refFromSelectedObject)).success(function (objectsAuthorizations){
            $ctrl.filteredSelectedObjects = selectedObjects
                .map((object) => ([
                    object,
                    objectsAuthorizations.find(( {ref} ) => ref.id === object.id && ref.type === object.type && ref.projectKey === object.projectKey)
                ]))
                .filter(([, authorizationsForThisItem]) => authorizationsForThisItem)
                .map(([object, authorizationsForThisItem]) => {
                    const dashboardAuthorizationsForThisItem = authorizationsForThisItem.authorizations
    
                    let allowNone, allowDiscover;
                    if (authorizationsForThisItem.allAuthorized
                        || dashboardAuthorizationsForThisItem.includes('READ')
                        || dashboardAuthorizationsForThisItem.includes('WRITE')) {
                        allowNone = false;
                        allowDiscover = false;
                    } else if (dashboardAuthorizationsForThisItem.includes('DISCOVER')) {
                        // we remove NONE from the options
                        allowNone = false;
                        allowDiscover = true;
                    } else {
                        allowNone = true;
                        allowDiscover = true;
                    }

                    return {
                        ...object,
                        allowDiscover,
                        allowNone,
                        objectAuthorization: 'READ', // always set it to read by default
                        canEnableQuickSharing: authorizationsForThisItem.canManageExposedElements,
                        isQuicklyShareable: authorizationsForThisItem.isQuicklyShareable,
                        suggestQuickSharing: authorizationsForThisItem.canManageExposedElements && !authorizationsForThisItem.isQuicklyShareable,
                        enableQuickSharing: authorizationsForThisItem.canManageExposedElements ? true : authorizationsForThisItem.isQuicklyShareable,
                    }
                });
            $ctrl.nbFilteredObjects = selectedObjects.length - $ctrl.filteredSelectedObjects.length;

            let promises = $ctrl.filteredSelectedObjects.map((object) => {
                // we can use object.projectKey as contextProjectKey because if we get to here it means we have the publish to collection auth, which implies read on the source project. So a call 'from the source project' will succeed, regardless of where we actually are.
                return DataikuAPI.datasets.getFullInfo(object.projectKey, object.projectKey, object.id)
                    .then(({data}) => $ctrl.updateObjectInfo(data, object))
                    .catch(function() {
                        // On failure, return a marker like undefined
                        return undefined;
                    });
            });
            $q.all(promises).then(results => {
                const objectsOK = [];
                const objectsFailed = [];
                // Iterate the original list and separate objects
                for (const object of $ctrl.filteredSelectedObjects) {
                    if (results.includes(object.id)) {
                        objectsOK.push(object);
                    } else {
                        objectsFailed.push(object);
                    }
                }
                $ctrl.filteredSelectedObjects = objectsOK;
                $ctrl.excludedObjects = objectsFailed;
            }).catch(error => {
                setErrorInScope.bind($scope)
            });
        }).error(setErrorInScope.bind($scope));

        WT1.tryEvent('data-collection-add-object-open', () => ({ from: 'publish', ...$ctrl.wt1Context }));
    };

    $scope.$on('$destroy', () => {
        if (!succeeded) {
            WT1.tryEvent('data-collection-add-object-cancel', () => ({ from: 'publish', ...$ctrl.wt1Context }));
        }
    });


    DataikuAPI.dataCollections.list("WRITE").success(dataCollectionsList => {
        $ctrl.dataCollectionsList = dataCollectionsList;
    }).error(setErrorInScope.bind($scope.errorScope || $scope.$parent));
    
    $scope.getDataCollectionName = (item) => {
        return item.metadata.displayName;
    };

    function getModalTitle() {
        return `Add datasets to Data Collection`;
    }

    function addObjectFromSelectedObject(selectedObject) {
        const requestedReaderAuthorizationsMapping = {
            'NONE': [],
            'DISCOVER': ['DISCOVER'],
            'READ': ['DISCOVER', 'READ'],
        };

        return {
            ref: refFromSelectedObject(selectedObject),
            requestQuickSharing: selectedObject.suggestQuickSharing && selectedObject.enableQuickSharing,
            requestedReaderAuthorizations: requestedReaderAuthorizationsMapping[selectedObject.objectAuthorization]
        };
    }

    function refFromSelectedObject(selectedObject) {
        return {
            projectKey: selectedObject.projectKey,
            id: selectedObject.id,
            type: selectedObject.type
        };
    }

    function completenessIssuesMessage(addToDataCollectionForm, isAddButton) {
        if(addToDataCollectionForm) {
            if (addToDataCollectionForm.$invalid) {
                return "Please choose a Data collection";
            } else if (!$ctrl.addIsDisabled(addToDataCollectionForm) && isAddButton){
                //sc-244257, if button is enabled, we don't show any message
                if ($ctrl.filteredSelectedObjects !== undefined) {
                    return "Publish "+$ctrl.filteredSelectedObjects.length+" datasets";
                } else {
                    return "";
                }
            }
        }

        const completenessChecks = $ctrl.dataCollectionItem?.metadataCompletenessChecks;
        const missingForColumns = $ctrl.objectWithColumnsIssue?.length > 0 && (completenessChecks?.columnsDescriptionCheck === "ERROR" || !isAddButton);
        const missingForDesc = $ctrl.objectWithDescriptionIssue?.length > 0 && (completenessChecks?.longDescriptionCheck === "ERROR" || !isAddButton);

        if (missingForColumns && missingForDesc) {
            return "Some datasets are missing a long description and column descriptions";
        } else if (missingForColumns) {
            return "Some datasets are missing column descriptions";
        } else if (missingForDesc) {
            return "Some datasets are missing a long description";
        } else if ($ctrl.filteredSelectedObjects !== undefined) {
            return "Publish "+$ctrl.filteredSelectedObjects.length+" datasets";
        } else {
            return "";
        }
    }

    function addObjects() {
        DataikuAPI.dataCollections.addObjects($ctrl.dataCollectionItem.id, $ctrl.filteredSelectedObjects.map(addObjectFromSelectedObject)).success((response) => {
            const collectionName = $ctrl.dataCollectionsList.find(dataCollection => dataCollection.id === $ctrl.dataCollectionItem.id).metadata.displayName;
            succeeded = true;
            const multi = $ctrl.filteredSelectedObjects?.length > 0;
            $ctrl.filteredSelectedObjects.forEach(object =>
                WT1.tryEvent('data-collection-object-added', () => ({
                    from: 'publish',
                    objectType: object.type,
                    dataCollectionh: md5($ctrl.dataCollectionItem.id),
                    originProjecth: md5(object.projectKey),
                    multi,
                    ...$ctrl.wt1Context
                }))
            );

            function buildLinkToDataCollection(dataCollectionId) {
                const href = StateUtils.href.dataCollection(dataCollectionId);
                const linkMessage = `View in ${sanitize(collectionName)}`;
                return `<a href='${href}'>${linkMessage}</a>.`;
            }

            const link = "<div>" +
            buildLinkToDataCollection($ctrl.dataCollectionItem.id)
            + "</div>";

            const dataStewardWarning = response.allDataStewardsDefined ? "" : "<div>No Data Steward set in dataset details.</div>";

            if (response.modified) {
                let message = $ctrl.filteredSelectedObjects.length + " Datasets added to collection!";
                
                if (dataStewardWarning) {
                    ActivityIndicator.warning(message + dataStewardWarning + link, 5000);
                } else {
                    ActivityIndicator.success(message + link, 5000);
                }
            } else {
                const message = "Datasets already in collection";
                if (dataStewardWarning) {
                    ActivityIndicator.warning(message + dataStewardWarning + link, 5000);
                } else {
                    ActivityIndicator.info(message + link, 5000);
                }
            }

            // returns a TaggableObjectsService.TaggableObjectRefWithName
            $scope.resolveModal({projectKey: '', type: 'DATA_COLLECTION', id: $ctrl.dataCollectionItem.id, displayName: collectionName});
            
        }).error((data, status, headers, config, statusText) => {
            setErrorInScope.bind($scope.errorScope || $scope.$parent)(data, status, headers, config, statusText);
        });
    }
});

app.component('addToDataCollectionAuthorizationSelect', {
    template: `<select dku-bs-select
                    class="input-custom-width"
                    ng-model="$ctrl.object.objectAuthorization"
                    options-descriptions="$ctrl.objectAuthorizationDescriptions"
                    layout="list">
                    <option ng-value="'NONE'" ng-disabled="!$ctrl.object.allowNone">None</option>
                    <option ng-value="'DISCOVER'" ng-disabled="!$ctrl.object.allowDiscover">Allow discover</option>
                    <option ng-value="'READ'">Allow read</option>
               </select>`,
    bindings: { object: '<' },
    controller: function() {
        this.objectAuthorizationDescriptions= [ '&quot;None&quot; will prevent users from seeing the dataset in the Data Collection at all',
                                                                     '&quot;Allow Discover&quot; will allow users to see the dataset metadata',
                                                                     '&quot;Allow Read&quot; will allow users to additionally preview the dataset from the collection' ];}
    });

app.component('addToDataCollectionQuickSharingCheckbox', {
    template: `<div class="control-checkbox">
                    <input type="checkbox" 
                        ng-model="$ctrl.object.enableQuickSharing"
                        ng-disabled="!$ctrl.object.suggestQuickSharing"
                        data-toggle="tooltip"
                        data-original-title="{{$ctrl.tooltipText()}}" />
                </div>`,
    bindings: { object: '<' },
    controller: function() {
        this.tooltipText = () => !this.object.isQuicklyShareable ? this.object.canEnableQuickSharing ? '' : 'You don\'t have the permission to change this option.' : 'Quick sharing is already enabled on this dataset';
    }
});


}());


(function() {
'use strict';

var app = angular.module('dataiku.services');

app.factory("Dialogs", ["CreateModalFromTemplate", "$q", "$state", "$timeout","DKUConstants", "translate", function(CreateModalFromTemplate, $q, $state, $timeout,DKUConstants, translate) {
    return {
        ack : function($scope, title, text) {
            var deferred = $q.defer();
            CreateModalFromTemplate("/templates/dialogs/ack-dialog.html", $scope, "ConfirmDialogController", function(newScope) {
                newScope.acceptDeferred = deferred;
                newScope.title = title;
                newScope.text = text;
                newScope.$on("$destroy",function() {
                    if(newScope.acceptDeferred) {
                        newScope.acceptDeferred.reject();
                    }
                    newScope.acceptDeferred = null;
                });
            });
            return deferred.promise;
        },
        ackMarkdown : function($scope, title, text) {
            var deferred = $q.defer();
            CreateModalFromTemplate("/templates/dialogs/ack-dialog-markdown.html", $scope, "ConfirmDialogController", function(newScope) {
                newScope.acceptDeferred = deferred;
                newScope.title = title;
                newScope.text = text;
                newScope.$on("$destroy",function() {
                    if(newScope.acceptDeferred) {
                        newScope.acceptDeferred.reject();
                    }
                    newScope.acceptDeferred = null;
                });
            });
            return deferred.promise;
        },
        error : function($scope, title, text) {
            var deferred = $q.defer();
            CreateModalFromTemplate("/templates/dialogs/error-dialog.html", $scope, "ConfirmDialogController", function(newScope) {
                newScope.acceptDeferred = deferred;
                newScope.title = title;
                newScope.text = text;
                newScope.$on("$destroy",function() {
                    if(newScope.acceptDeferred) {
                        newScope.acceptDeferred.reject();
                    }
                    newScope.acceptDeferred = null;
                });
            });
            return deferred.promise;
        },
        errorUnsafeHTML : function($scope, title, text) {
            var deferred = $q.defer();
            CreateModalFromTemplate("/templates/dialogs/error-dialog-unsafe-html.html", $scope, "ConfirmDialogController", function(newScope) {
                newScope.acceptDeferred = deferred;
                newScope.title = title;
                newScope.text = text;
                newScope.$on("$destroy",function() {
                    if(newScope.acceptDeferred) {
                        newScope.acceptDeferred.reject();
                    }
                    newScope.acceptDeferred = null;
                });
            });
            return deferred.promise;
        },
        confirm : function($scope, title, text, options) {
            var deferred = $q.defer();
            CreateModalFromTemplate("/templates/dialogs/confirm-dialog.html", $scope, "ConfirmDialogController", function(newScope) {
                newScope.acceptDeferred = deferred;
                newScope.positive = false || options ? options.positive : false;
                newScope.title = title;
                newScope.text = text;
                newScope.options = options;
                newScope.translate = translate;
                newScope.$on("$destroy",function() {
                    if(newScope.acceptDeferred) {
                        newScope.acceptDeferred.reject();
                    }
                    newScope.acceptDeferred = null;
                });
            }, null, options && options.confirmOnExit ? 'confirm' : null);
            return deferred.promise;
        },
        confirmUnsafeHTML : function($scope, title, text) {
            var deferred = $q.defer();
            CreateModalFromTemplate("/templates/dialogs/confirm-dialog-unsafe-html.html", $scope, "ConfirmDialogController", function(newScope) {
                newScope.acceptDeferred = deferred;
                newScope.positive = false;
                newScope.title = title;
                newScope.text = text;
                newScope.$on("$destroy",function() {
                    if(newScope.acceptDeferred) {
                        newScope.acceptDeferred.reject();
                    }
                    newScope.acceptDeferred = null;
                });
            });
            return deferred.promise;
        },
        confirmPositive : function($scope, title, text) {
            var deferred = $q.defer();
            CreateModalFromTemplate("/templates/dialogs/confirm-dialog.html", $scope, "ConfirmDialogController", function(newScope) {
                newScope.acceptDeferred = deferred;
                newScope.positive = true;
                newScope.title = title;
                newScope.text = text;
                newScope.$on("$destroy",function() {
                    if(newScope.acceptDeferred) {
                        newScope.acceptDeferred.reject();
                    }
                    newScope.acceptDeferred = null;
                });
            });
            return deferred.promise;
        },
        confirmSimple : function($scope, text, positive = false) {
            var deferred = $q.defer();
            CreateModalFromTemplate("/templates/dialogs/confirm-dialog-simple.html", $scope, "ConfirmDialogController", function(newScope) {
                newScope.acceptDeferred = deferred;
                newScope.positive = positive;
                newScope.text = text;
                newScope.$on("$destroy",function() {
                    if(newScope.acceptDeferred) {
                        newScope.acceptDeferred.reject();
                    }
                    newScope.acceptDeferred = null;
                });
            });
            return deferred.promise;
        },
        confirmImportant: function($scope, title, text) {
            var deferred = $q.defer();
            CreateModalFromTemplate("/templates/dialogs/confirm-dialog.html", $scope, "ConfirmDialogController", function(newScope) {
                newScope.acceptDeferred = deferred;
                newScope.positive = false;
                newScope.title = title;
                newScope.text = text;
                newScope.$on("$destroy",function() {
                    if(newScope.acceptDeferred) {
                        newScope.acceptDeferred.reject();
                    }
                    newScope.acceptDeferred = null;
                });
            },
            false,
            'static');
            return deferred.promise;
        },
        confirmDisclaimer : function($scope, title, text, disclaimer) {
            var deferred = $q.defer();
            CreateModalFromTemplate("/templates/dialogs/confirm-dialog-disclaimer.html", $scope, "ConfirmDialogController", function(newScope) {
                newScope.acceptDeferred = deferred;
                newScope.positive = false;
                newScope.title = title;
                newScope.disclaimer = disclaimer;
                newScope.text = text;
                newScope.$on("$destroy",function() {
                    if(newScope.acceptDeferred) {
                        newScope.acceptDeferred.reject();
                    }
                    newScope.acceptDeferred = null;
                });
            });
            return deferred.promise;
        },

        confirmAlert : function($scope, title, text, alertText, severity) {
            var deferred = $q.defer();
            CreateModalFromTemplate("/templates/dialogs/confirm-dialog-alert.html", $scope, "ConfirmDialogController", function(newScope) {
                newScope.acceptDeferred = deferred;
                newScope.positive = false;
                newScope.title = title;
                newScope.alertText = alertText;
                newScope.severity = severity;
                newScope.text = text;
                newScope.$on("$destroy",function() {
                    if(newScope.acceptDeferred) {
                        newScope.acceptDeferred.reject();
                    }
                    newScope.acceptDeferred = null;
                });
            });
            return deferred.promise;
        },

        confirmInfoMessages : function($scope, title, data, text, skipIfNoMessages) {
            if (skipIfNoMessages && (data == null || data.messages.length == 0)) return $q.when(null);
            var deferred = $q.defer();

            CreateModalFromTemplate("/templates/dialogs/confirm-dialog-info-messages.html", $scope, "ConfirmDialogController", function(newScope) {
                newScope.modalTitle = title;
                newScope.data = data;
                newScope.acceptDeferred = deferred;
                newScope.positive = false;
                newScope.title = title;
                newScope.text = text;
                newScope.$on("$destroy",function() {
                    if(newScope.acceptDeferred) {
                        newScope.acceptDeferred.reject();
                    }
                    newScope.acceptDeferred = null;
                });
            });
            return deferred.promise;
        },

        infoMessagesDisplayOnly : function($scope, title, data, log, hideAlertHeader, backdrop, keyboard) {
            if (data.messages.length == 0) return $q.when(null);
            var deferred = $q.defer();
            CreateModalFromTemplate("/templates/dialogs/info-messages-dialog.html", $scope, null, function(newScope) {
                newScope.DKUConstants = DKUConstants;
                newScope.modalTitle = title;
                newScope.data = data;
                newScope.log = log;
                newScope.hideAlertHeader = hideAlertHeader;
                newScope.$on("$destroy",function() {
                    deferred.resolve();
                });
            }, backdrop, keyboard);
            return deferred.promise;
        },

        prompt : function($scope, title, text, defaultValue, options) {
            var deferred = $q.defer();
            CreateModalFromTemplate("/templates/dialogs/prompt-dialog.html", $scope, "PromptDialogController", function(newScope, newDOMElt) {
                newScope.acceptDeferred = deferred;
                newScope.title = title;
                newScope.text = text;
                newScope.value = defaultValue;
                newScope.options = options;
                newScope.$on("$destroy",function() {
                    if(newScope.acceptDeferred) {
                        newScope.acceptDeferred.reject();
                    }
                    newScope.acceptDeferred = null;
                });
                newDOMElt.on('keydown', 'input', function(e) {
                    if (e.which === 13 && newScope.renameForm.$valid === false) {
                        e.stopPropagation();
                    }
                })

                if (options && options.type === 'textarea') {
                    newDOMElt.on('keydown', 'textarea', function(evt) {
                        if (evt.which === 13) {
                            // prevent ENTER key from validating the popup from inside the textarea
                            evt.stopPropagation();
                        }
                    })
                }
            });
            return deferred.promise;
        },

        select : function($scope, title, text, items, selectedItem, options) {
            var deferred = $q.defer();
            CreateModalFromTemplate("/templates/dialogs/select-dialog.html", $scope, "SelectDialogController", function(newScope) {
                newScope.acceptDeferred = deferred;
                newScope.title = title;
                newScope.text = text;
                newScope.items = items;
                newScope.selectedItem = selectedItem;
                newScope.options = options;
                newScope.$on("$destroy",function() {
                    if(newScope.acceptDeferred) {
                        newScope.acceptDeferred.reject();
                    }
                    newScope.acceptDeferred = null;
                });
            });
            return deferred.promise;
        },

        eeUnavailableFeature : function($scope, lockedMessage, learnMoreURL){
           CreateModalFromTemplate("/templates/dialogs/ee-unavailable-feature-modal.html", $scope, null, function(newScope) {
            newScope.lockedMessage = lockedMessage;
            newScope.learnMoreURL = learnMoreURL;
        });
       },

       displaySerializedError: function($scope, e) {
            CreateModalFromTemplate("/templates/dialogs/serialized-error-modal.html", $scope, null, function(newScope) {
                newScope.error = e;
                newScope.isCredentialError = e && e.code && (e.code==="ERR_CONNECTION_OAUTH2_REFRESH_TOKEN_FLOW_FAIL" || e.code==="ERR_CONNECTION_NO_CREDENTIALS");
            });
        },


       openEditInNotebookConflictDialog: function($scope) {
        var deferred = $q.defer();
        CreateModalFromTemplate("/templates/dialogs/edit-in-notebook-conflict-dialog.html", $scope, "ConflictDialogController", function(newScope) {
            newScope.acceptDeferred = deferred;
            newScope.$on("$destroy", function() {
                if (newScope.acceptDeferred) {
                    newScope.acceptDeferred.reject();
                }
                newScope.acceptDeferred = null;
            });
        });
        return deferred.promise;
       },

       openConflictDialog : function($scope,conflictResult) {

        var deferred = $q.defer();
        CreateModalFromTemplate("/templates/dialogs/save-conflict-dialog.html", $scope, "ConflictDialogController", function(newScope) {
            newScope.acceptDeferred = deferred;
            newScope.conflictResult = conflictResult;
            newScope.$on("$destroy",function() {
                if(newScope.acceptDeferred) {
                    newScope.acceptDeferred.reject();
                }
                newScope.acceptDeferred = null;
            });
        });
        return deferred.promise;
    },

    saveChangesBeforeLeaving: function(scope, dirty, save, revert, msg) {
        if (typeof dirty != 'function') {
            // eslint-disable-next-line no-console
            console.error("Dirtyness detection is not valid. typeof dirty = ", typeof dirty, dirty); /*@console*/ // NOSONAR: OK to use console.
        }
        if (typeof save != 'function') {
            // eslint-disable-next-line no-console
            console.error("Saving function is not valid. typeof save = ", typeof save, save); /*@console*/ // NOSONAR: OK to use console.
        }
        if (revert && typeof revert != 'function') {
            // eslint-disable-next-line no-console
            console.error("Revert function is not valid. typeof revert = ", typeof revert, revert); /*@console*/ // NOSONAR: OK to use console.
        }

        scope.$on('$stateChangeStart', function (event, toState, toParams, fromState, fromParams) {
            var isDirty = false;
                try { // Don't keep the reference to the scope in dssHasDirtyThings, so never fail this check!
                isDirty = dirty(toState, toParams, fromState, fromParams);
            } catch (e) {
                // eslint-disable-next-line no-console
                console.error("Failed to check dirtiness"); /*@console*/ // NOSONAR: OK to use console.
            }
            if (isDirty) {
                event.preventDefault();

                CreateModalFromTemplate("/templates/dialogs/unsaved-changes-warning.html", scope, null, function(modalScope) {
                    modalScope.msg = msg;

                    var goToState = function() {
                        $timeout(function() {
                            $state.go(toState, toParams);
                            modalScope.resolveModal();
                        });
                    };

                    modalScope.saveAndContinue = function() {
                        var saveResult = save();
                        if (saveResult && saveResult.success) {
                            saveResult.success(goToState);
                        } else {
                            goToState();
                        }

                        if (saveResult && saveResult.error) {
                            if (saveResult.errorIsAlreadyParsed) {
                                // When we use the service from Angular, the http service has already called getErrorDetails upstream
                                // so we can't feed it to the classic setErrorInScope. setErrorDetailsInScope does the same thing except it expects an already parsed errorDetails
                                saveResult.error(setErrorDetailsInScope.bind(modalScope));
                            } else {
                                saveResult.error(setErrorInScope.bind(modalScope));
                            }
                        }
                    };

                    modalScope.continueWithoutSaving = function() {
                        if (revert) {
                            revert();
                        }

                        goToState();
                    };
                });

                return false;
            }
        });
    },

    checkChangesBeforeLeaving: checkChangesBeforeLeaving
};

}]);


})();

;
(function() {
'use strict';

const app = angular.module('dataiku.services');


app.factory("WebSocketService", function($q, $rootScope, Notification, WT1, Logger, $$cookieReader) {

    const ERROR_CODE = Object.freeze({
        CONNECTION_LOST: 2,
        CONNECTION_FAILED: 3,
        CONNECTION_ESTABLISHED: 4
    });

    const PING_INTERVAL = 15000;
    const RECONNECT_TIMEOUT = 50000;
    const DEV_RECONNECT_TIMEOUT = 5000;

    // This ID identifies this browser session
    const sessionId = generateRandomId(10);
    // At a single point in time, only one websocket can be active
    const webSocketProtocol = window.location.protocol.indexOf("https") == 0 ? "wss" : "ws";
    const webSocketUrl = webSocketProtocol + "://" + window.location.host + "/dip/websocket?tfaliu=" + sessionId;

    let webSocket = null;
    let reallyConnected = false;
    let everConnected = false;
    let hasFailed = false;

    // Store the event we want to send
    let eventQueue = [];

    function flushEventQueue() {
        if(reallyConnected && webSocket != null) {
             for(const k in eventQueue) {
                webSocket.send(JSON.stringify(eventQueue[k]));
             }
             eventQueue = [];
        }
    }

    function connect() {
        Logger.info("Attempting WS connection");

        if(webSocket != null) {
            return;
        }

        try {
            // Websockets can't have custom headers so we pass the XSRF token through the sub-protocols
            // Plus "dummy" that will get chosen by the server (mandated by WS protocol)
            const xsrfToken = $$cookieReader()[$rootScope.appConfig.xsrfCookieName];
            webSocket = new WebSocket(webSocketUrl, ["dummy", "xsrf-" + xsrfToken]);
        } catch (e) {
            // eslint-disable-next-line no-console
            console.error("WS error: " + e.message, e); /*@console*/  // NOSONAR: OK to use console.
            hasFailed = true;
            if(everConnected) {
                emitToFrontend("websocket-status-changed", {
                    code: ERROR_CODE.CONNECTION_LOST,
                    reason : "Unable to re-create a Websocket connection ("+e.message+")"
                });
            } else {
                emitToFrontend("websocket-status-changed", {
                    code: ERROR_CODE.CONNECTION_FAILED,
                    reason : "Could not create a Websocket connection ("+e.message+")"
                });
                WT1.event("websocket-failed", {reason:e.message});
            }
            return;
        }

        const thisWebSocket = webSocket;

        webSocket.onopen = function() {
            const pingMessage = {
                type: "ping",
                event: {
                    webSocketSessionId: sessionId
                }
            };
            if(thisWebSocket == webSocket) {
                thisWebSocket.send(JSON.stringify(pingMessage));
                const intervalId = setInterval(function() {
                    if(thisWebSocket == webSocket) {
                        thisWebSocket.send(JSON.stringify(pingMessage));
                    } else {
                        clearInterval(intervalId);
                    }
                }, PING_INTERVAL);
            }
        };

        webSocket.onmessage = function (evt) {
            $rootScope.$applyAsync(function() {
                if(!reallyConnected) {
                    emitToFrontend("websocket-status-changed", {
                        code: ERROR_CODE.CONNECTION_ESTABLISHED,
                        reason : "Connection established !"
                    });
                    reallyConnected = true;
                    everConnected = true;
                    flushEventQueue();
                }
                const notification = JSON.parse(evt.data);
                if (notification.type != "pong" && notification.type != "watch-triggered") {
                    Logger.debug("Message from WS: " + notification.type);
                }
                emitToFrontend(notification.type, notification.event);
            });
        };

        webSocket.onerror = function(evt) {
            hasFailed = true;
            // eslint-disable-next-line no-console
            console.warn("Websocket error", evt); /*@console*/ // NOSONAR: OK to use console.
        };

        webSocket.onclose = function(evt) {
            Logger.info("WS closed:" , evt);
            if ((evt instanceof CloseEvent) && (1001 === evt.code || 1011 === evt.code)) {
                // Unlike Chrome, Firefox calls onclose when it is closing a WS because
                // its tab is closing or the user is navigating away, which would cause the
                // "disconnected" overlay to appear before the new page is loaded.
                // See https://developer.mozilla.org/fr/docs/Web/API/CloseEvent
                Logger.info("Closing tab or navigating away. Not executing WS onclose [firefox].");
                return;
            }
            $rootScope.$apply(function() {
                webSocket = null;
                hasFailed = true;
                if(reallyConnected) {
                    emitToFrontend("websocket-status-changed", {
                        code: ERROR_CODE.CONNECTION_LOST,
                        reason : "You lost connection to the server",
                    });
                } else {
                    emitToFrontend("websocket-status-changed", {
                        code: everConnected?ERROR_CODE.CONNECTION_LOST:ERROR_CODE.CONNECTION_FAILED,
                        reason : "Websocket connection failed"
                    });
                    if(!everConnected) {
                        WT1.event("websocket-failed", {reason:'Connection closed'});
                    }
                }
                // after losing connection, the first re-connect attempt we try is instant
                const timeoutDelay = reallyConnected ? 0 : (window.devInstance ? DEV_RECONNECT_TIMEOUT : RECONNECT_TIMEOUT);
                reallyConnected = false;
                setTimeout(function() {
                    connect();
                }, timeoutDelay);
            });
        };
    }

    function broadcastToBackend(type,event) {
        const copied = angular.copy(event ? event : {});
        copied.webSocketSessionId = sessionId;
        eventQueue.push({
            type: type,
            event: copied
        });
        flushEventQueue();
    }

    function emitToFrontend(type,event) {
        Notification.publishToFrontend(type, event);
    }

    Notification._setBackendEventHandler(broadcastToBackend);

    return {
        // Connect the websocket, or force reconnect.
        connect : connect,
        // Returns true if the websocket is connected
        isConnected : function() {
            return reallyConnected;
        },
        // Returns true if the websocket is or has been connected in the past.
        hasEverConnected : function() {
            return everConnected;
        },
        // Returns true if the websocket has been available in the past,
        // or if it didn't fail yet.
        isAvailable : function() {
            return !hasFailed || everConnected;
        },
        getSessionId : function() {
            return sessionId;
        },
        // List of error codes
        ERROR_CODE : ERROR_CODE
    };

});


})();

;
(function(){
'use strict';

const app = angular.module('dataiku.services');


    app.factory("Notification", [function() {

            var dispatcherTable = {};

            var backendEventHandler = null;

            var registerEvent = function(type,eventListener) {
                if(!type) return angular.noop;
                var listeners = dispatcherTable[type];
                if(!listeners) {
                    listeners = [];
                    dispatcherTable[type] = listeners;
                }
                var listenerWrapper = function(type, event) {
                    eventListener(type,event);
                }
                listeners.push(listenerWrapper);
                return function() {
                    var idx = listeners.indexOf(listenerWrapper);
                    if(idx != -1) {
                        listeners.splice(idx,1);
                    }
                };
            };

            var publishToBackend = function(type, event) {
                if(!event) {
                    event={};
                }
                if(backendEventHandler) {
                    backendEventHandler(type,event);
                }
            };

            var publishToFrontend = function(type, event) {
                if(!event) {
                    event={};
                }
                var listeners = dispatcherTable[type];
                if(listeners) {
                    for(const listener of listeners) {
                        listener(type,event);
                    }
                }
            };

            var broadcastToFrontends = function(loopBack) {
                return function(type,event) {
                    publishToBackend('ui-broadcast',{
                        nestedEvent : {
                            type : type,
                            event : event
                        },
                        loopBack : loopBack
                    });
                }
            };

            var setBackendEventHandler = function(handler) {
                backendEventHandler = handler;
            }

            return {
                // Register a new event listener. The event may be coming from the frontend (sent by NotificationService.$broadcast)
                // or from the backend.
                registerEvent: registerEvent,

                // Publish an event to the current frontend
                publishToFrontend : publishToFrontend,

                // Publish an event to the backend
                publishToBackend : publishToBackend,

                // Publish an event to all the frontends (including this one)
                broadcastToFrontends : broadcastToFrontends(true),

                // Publish an event to all the frontends (except this one)
                broadcastToOtherSessions : broadcastToFrontends(false),

                // Register the backend event handler (which is WebSocketService)
                // The purpose is to break the dependency cycle.
                _setBackendEventHandler : setBackendEventHandler

            };
    }]);

})();
;
(function(){
'use strict';

    const app = angular.module('dataiku.services');

    app.factory("IntercomSupport", function($rootScope, $state, Assert, ContextualMenu, LoggerProvider, OpalsService) {
        var Logger = LoggerProvider.getLogger("IntercomSupport");
        var loaded = false;
        var shown = false;
        
        var svc = {
            activate : function(){
                Assert.inScope($rootScope, "appConfig");
                if (!!$rootScope.appConfig.offlineFrontend) {
                    return;
                }

                if (!$rootScope.appConfig.licensing ||
                    !$rootScope.appConfig.licensing.licenseContent ||
                    !$rootScope.appConfig.licensing.licenseContent.properties ||
                    !$rootScope.appConfig.licensing.licenseContent.properties.intercomAppId) {
                    return;
                }

                /* CE users: even if license gives an app id, Intercom is only enabled
                 * during trial period. Except if specially allowed */
                if ($rootScope.appConfig.communityEdition) {
                    if (!$rootScope.appConfig.licensing.ceEntrepriseTrial && 
                        !$rootScope.appConfig.licensing.licenseContent.properties.intercomAfterTrial) {
                        return;
                    }
                }

                var appId = $rootScope.appConfig.licensing.licenseContent.properties.intercomAppId;
                var intercomCode = "<script>(function(){var w=window;var ic=w.Intercom;if(typeof ic==='function'){ic('reattach_activator');ic('update',intercomSettings);}else{var d=document;var i=function(){i.c(arguments)};i.q=[];i.c=function(args){i.q.push(args)};w.Intercom=i;function l(){var s=d.createElement('script');s.type='text/javascript';s.async=true;s.src='https://widget.intercom.io/widget/"+appId+"';var x=d.getElementsByTagName('script')[0];x.parentNode.insertBefore(s,x);} w.dkuIntercomLoadFunction = l;}})()</script>"

                if (!loaded){
                    $("body").append($(intercomCode));
                    loaded = true;
                }
                $rootScope.intercomEnabled = true;

                $rootScope.forceShowIntercom = function(){
                   $("body").removeClass("dku-intercom-hidden");
                   Intercom("showMessages");
                   ContextualMenu.prototype.closeAny();
                }

                var licenseKind = $rootScope.appConfig.licensing.licenseContent.licenseKind;
                var company = $rootScope.appConfig.licensing.licenseContent.licensee.company;
                var niceName = $rootScope.appConfig.user.displayName + " (" + $rootScope.appConfig.user.login + ") ("+ licenseKind + ": " + company + ")";
                Logger.info("Executing Intercom load hook");
                window.dkuIntercomLoadFunction();
                Logger.info("Enqueuing Intercom boot");
                window.Intercom("boot", {
                    app_id: appId,
                    license_kind : $rootScope.appConfig.licensing.licenseContent.licenseKind,
                    license_instance_id : $rootScope.appConfig.licensing.licenseContent.instanceId,
                    licensee_company: company,
                    licensee_email: $rootScope.appConfig.licensing.licenseContent.licensee.name,
                    name : niceName,
                    email: $rootScope.appConfig.user.email,
                    opals_activated: !!$rootScope.appConfig.opalsEnabled,
                });
                Intercom("onShow", function(){
                    shown = true;
                })
                Intercom("onHide", function(){
                    shown = false;
                })
                Intercom('update', {
                  "hide_default_launcher": !!$rootScope.appConfig.opalsEnabled
                });

                if ($state.current.name == "home") {
                    $("body").removeClass("dku-intercom-hidden")
                } else {
                    $("body").addClass("dku-intercom-hidden")
                }

                $rootScope.$on("$stateChangeSuccess", function(event, toState) {
                    if(toState.name != "home") {
                        if (!shown) {
                            $("body").addClass("dku-intercom-hidden");
                        }
                    } else {
                        $("body").removeClass("dku-intercom-hidden");
                    }
                })
            }
        }
        return svc;
    })

    app.factory('TrackingService', function($rootScope, $state, $stateParams, Assert, Notification) {
            var lastEvent = new Date().getTime();
            var isIdle = false;

            // Max idle time before being considered idle (10 mn)
            var idleTime = 10 * 60 * 1000;

            // Track page changes
            $rootScope.$on("$stateChangeSuccess",function(event, toState, toParams, fromState, fromParams){
                // Some parameters (in catalog) are not a string: scope and _type are arrays.
                const arrayParameters =
                    Object.entries(toParams).filter(paramEntry => Array.isArray(paramEntry[1]));
                if (arrayParameters.length > 0) {
                    toParams = angular.copy(toParams);
                    arrayParameters.forEach(parameter => {
                        toParams[parameter[0]] = JSON.stringify(parameter[1]);
                    });
                }
                Notification.publishToBackend('ui-state-changed', {
                      stateName : toState.name,
                      stateParams : toParams
                  });
                  resetIdleTimer();
            });

            if($state.current && $state.current.name) {
                Notification.publishToBackend('ui-state-changed', {
                    stateName : $state.current.name,
                    stateParams : $stateParams
                });
            }

            var idleTimeout = null;

            var resetIdleTimer = function() {
                setIdleState(false);
                lastEvent = new Date().getTime();
                if(idleTimeout !== null) {
                    clearTimeout(idleTimeout);
                }
                idleTimeout = setTimeout(function() {
                    setIdleState(true);
                },idleTime);
            };

            var setIdleState = function(newIdleState) {
                if(isIdle != newIdleState) {
                    $rootScope.$apply(function() {
                        isIdle = newIdleState;
                        Notification.publishToBackend('ui-idle-state-changed',{
                            isIdle : newIdleState
                        });
                    });
                }
            };

            // Reset idle timer on page events
            var eventList = ['mousemove','mousedown','keypress','mousewheel','touchmove'];

            for(var k in eventList) {
                window.addEventListener(eventList[k],resetIdleTimer,false);
            }

            resetIdleTimer();
            Notification.publishToBackend('ui-idle-state-changed',{
                                    isIdle : false
            });

            return {
                isIdle : function() {
                    return isIdle;
                },
                setIdleTime : function(newIdleTime) {
                    idleTime = newIdleTime;
                },
                resetIdleTimer : resetIdleTimer,
                configurePingTracking : function(){
                    Assert.inScope($rootScope, "appConfig");
                    if ($rootScope.appConfig.udrMode === 'DEFAULT' && $rootScope.appConfig.pingTracking) {
                        window.setInterval(function(){
                            if (window.WT1SVC) {
                                window.WT1SVC.event("pingt", {
                                    "idle": isIdle,
                                    "lastEvent": new Date().getTime() - lastEvent
                                })
                            }
                        }, $rootScope.appConfig.pingTrackingInterval);
                    }
                }
            };

    });


    app.factory('WatchService',["Notification", "$rootScope", "$state", "$stateParams", "Debounce", "WebSocketService",
            function(Notification, $rootScope, $state, $stateParams, Debounce, WebSocketService) {

        var registeredWatchers = [];
        var id = 0;

        var newId = function() {
            id++;
            return 'W'+id;
        }

        var updateWatchList = Debounce().withDelay(50,50).wrap(function() {
            var watches = [];
            for(var k in registeredWatchers) {
                watches.push(registeredWatchers[k].watch);
            }
            Notification.publishToBackend('watch-list-changed',{
                watches : watches
            });
        });

        var watchState = function(callback, statePrefix, stateParams) {
            var watcher = {
                callback: callback,
                watch : {
                    statePrefix : statePrefix?statePrefix:'',
                    stateParams : angular.copy(stateParams?stateParams:{}),
                    watchId : newId()
                }
            };
            registeredWatchers.push(watcher);
            updateWatchList();

            return function() {
                 var idx = registeredWatchers.indexOf(watcher);
                 if(idx!=-1) {
                    registeredWatchers.splice(idx,1);
                 }
            };
        };

        Notification.registerEvent('watch-triggered',function(evt, message) {
            for(var k = 0 ; k <  message.results.length ; k++) {
                var theId = message.results[k].watchId;
                for(var j = 0 ; j < registeredWatchers.length ; j++) {
                    if(registeredWatchers[j].watch.watchId == theId) {
                        var watchResult = message.results[k];
                        var conflictingSessions = watchResult.sessions;
                        for(var l in conflictingSessions) {
                            var conflictingSession = conflictingSessions[l];
                            conflictingSession.isCurrentSession =
                                (conflictingSession.sessionId == WebSocketService.getSessionId());
                        }
                        registeredWatchers[j].callback(conflictingSessions);
                        break;
                    }
                }
            }
        });

        return {
            watchState : watchState
        };

    }]);


    app.factory('ConflictDetector', function($state, $stateParams, $rootScope, Notification, WatchService, Debounce, Logger) {
        var trackedStates = [
            {
                state : 'projects.project.datasets.dataset.settings',
                params : ['projectKey','datasetName'],
                title : 'Users editing this dataset'
            },
            {
                state : 'projects.project.datasets.dataset.edit',
                params : ['projectKey','datasetName'],
                title : 'Users editing this dataset'
            },
            {
                state : 'projects.project.recipes.recipe',
                params : ['projectKey','recipeName'],
                title : 'Users editing this recipe'
            },
            {
                state : 'projects.project.datasets.dataset.shakers.shaker',
                params : ['projectKey','datasetName','scriptId'],
                title : 'Users on this preparation script'
            },
            {
                state : 'projects.project.wiki.article.edit',
                params : ['projectKey', 'articleId'],
                title : 'Users on this article'
            },
            {
                state : 'projects.project.notebooks.jupyter_notebook',
                params : ['projectKey','notebookId'],
                title : 'Users on this notebook'
            },
            {
                state : 'projects.project.notebooks.sql_notebook',
                params : ['projectKey','notebookId'],
                title : 'Users on this notebook'
            },
            {
                state : 'projects.project.analyses.analysis',
                params : ['projectKey','analysisId'],
                title : 'Users on this analysis'
            },
            {
                state : 'projects.project.analyses.analysis.ml.predmltask',
                params : ['projectKey', 'mlTaskId'],
                title : 'Users on this ML task'
            },
            {
                state : 'projects.project.analyses.analysis.ml.clustmltask',
                params : ['projectKey', 'mlTaskId'],
                title : 'Users on this ML task'
            },
            {
                state : 'projects.project.dashboards.dashboard.edit',
                params : ['projectKey', 'dashboardId'],
                title : 'Users editing this dashboard'
            },
            {
                state : 'projects.project.dashboards.insights.insight.edit',
                params : ['projectKey', 'insightId'],
                title : 'Users editing this insight'
            },
            {
                state: 'projects.project.scenarios.scenario',
                params : ['projectKey', 'scenarioId'],
                title : 'Users on this scenario'
            },
            {
                state: 'projects.project.webapps.webapp.edit',
                params : ['projectKey', 'webAppId'],
                title : 'Users editing this webapp'
            },
            {
                state: 'projects.project.code-studios.code-studio',
                params : ['projectKey', 'codeStudioObjectId'],
                title : 'Users using this Code Studio'
            },
            {
                state: 'plugindev.editor',
                params : ['pluginId'],
                title : 'Users editing this plugin'
            },
            {
                state : 'projects.project.datasets.dataset.statistics.worksheet',
                params : ['projectKey', 'datasetName', 'worksheetId'],
                title : 'Users on this worksheet'
            },
            {
                state : 'projects.project.datasets.dataset.data-quality.edit',
                params : ['projectKey', 'datasetName'],
                title : 'Users editing these rules'
            },
            {
                state : 'dataquality.templates.template',
                params : ['templateId'],
                title : 'Users editing this template'
            },
            {
                state : 'projects.project.foreigndatasets.dataset.statistics.worksheet',
                params : ['projectKey', 'datasetName','worksheetId'],
                title : 'Users on this worksheet'
            },
            {
                state : 'projects.project.modelevaluationstores.modelevaluationstore',
                params : ['projectKey', 'mesId'],
                title : 'Users on this Store'
            },
            {
                state : 'projects.project.modelcomparisons.modelcomparison',
                params : ['projectKey', 'modelComparisonId'],
                title : 'Users on this Comparator'
            },
            {
                state: 'projects.project.savedmodels.savedmodel.agent.design',
                params: ['projectKey', 'smId', 'fullModelId'],
                title: 'Users editing this Agent version'
            },
            {
                state: 'projects.project.agenttools.agenttool',
                params: ['projectKey', 'agentToolId'],
                title: 'Users editing this Agent Tool'
            },
            {
                state: 'projects.project.savedmodels.savedmodel.retrievalaugmentedllm.design',
                params: ['projectKey', 'smId', 'fullModelId'],
                title: 'Users editing this Retrieval-augmented LLM'
            }
        ];

        // Sort by depth in the state hierarchy
        trackedStates.sort(function(a,b) {
            var cmp = b.state.length - a.state.length;
            if(cmp == 0) {
                cmp = b.params.length - a.params.length;
            }
            return cmp;
        });



        var notifyConflictListChanged = Debounce().withDelay(50,50).wrap(function() {
            $rootScope.$broadcast('conflict-list-changed');
        });

        var rebuildTrackersForState = function(toState,toParams) {
            for(var k in trackedStates) {
                (function(trackedState) {
                    if(trackedState.tracker) {
                        trackedState.tracker();
                        trackedState.tracker = null;
                    }
                    if(toState.indexOf(trackedState.state)== 0) {
                        var params = {};
                        for(var j in trackedState.params) {
                            var paramName = trackedState.params[j];
                            params[paramName] = toParams[paramName];
                        }
                        trackedState.tracker = WatchService.watchState(function(sessions) {
                            trackedState.sessions = [];
                            for(var k in sessions) {
                                var session = sessions[k];
                                //if(!session.isCurrentSession) {
                                    trackedState.sessions.push(session);
                                //}
                            }
                            notifyConflictListChanged();
                        },trackedState.state,params, trackedState.ignoredValues);
                    }
                })(trackedStates[k]);
            }
            notifyConflictListChanged();
        };

        $rootScope.$on("$stateChangeSuccess",function(event, toState, toParams, fromState, fromParams){
            rebuildTrackersForState(toState.name,toParams);
        });

        if($state.current && $state.current.name) {
            rebuildTrackersForState($state.current.name,$stateParams);
        }

        return {
            listConflicts : function() {

                let out = [];
                let userMap = {};

                for(let trackedStateItem in trackedStates) {
                    let trackedState = trackedStates[trackedStateItem];
                    let userList = [];

                    if($state.current.name.indexOf(trackedState.state) == 0) {
                        if(trackedState.sessions && trackedState.sessions.length) {
                            for(let sessionItem in trackedState.sessions) {
                                let session = trackedState.sessions[sessionItem];
                                if(!userMap[session.user.login]) {

                                    let sessionUser = {
                                        userLogin : session.user.login,
                                        userDisplayName : session.user.displayName,
                                        active : !session.isIdle
                                    };

                                    userList.push(sessionUser);
                                    userMap[session.user.login] = sessionUser;

                                } else {
                                    if(!session.isIdle) {
                                        userMap[session.user.login].active = true;
                                    }
                                }
                            }
                        }
                    }
                    if(userList.length>0) {
                        let totalNbWindows = 0;
                        for(let userListItem in userList) {
                            let user = userList[userListItem];
                            user.nbWindows = 0;
                            for(let s in trackedState.sessions) {
                                let userSession = trackedState.sessions[s];
                                if(userSession.user.login == user.userLogin) {
                                    user.nbWindows++;
                                    totalNbWindows++;
                                }
                            }
                        }

                        out.push({
                            state : trackedState.state,
                            params : trackedState.params,
                            title : trackedState.title,
                            warn : totalNbWindows > 1,
                            users : userList
                        });
                    }
                }
                for(let k in out) {
                    if(out[k].warn) {
                        Logger.info('Detected state conflict with another user!',out[k].users)
                    }
                }

               return out;
            }
        };

    });


    /*
    Integration with the fullstory.com advanced tracker.
    Disabled by default and under the dku.feature.fullstory.enabled=true feature flag. Fully disabled if dku.offlineFrontend=true

    WARNING, this is not currently anonymized as WT1 is! (display name/email sent)
    */
    app.factory('FullstorySupport', function($rootScope, $state, Assert, LoggerProvider, FeatureFlagsService) {
        const Logger = LoggerProvider.getLogger("FullstorySupport");
        let loaded = false;

        const svc = {
            activate : function() {
                Assert.inScope($rootScope, "appConfig");
                if (!!$rootScope.appConfig.offlineFrontend) {
                    return;
                }

                if (loaded) {
                    return;
                }
                if (!FeatureFlagsService.featureFlagEnabled('fullstory')) {
                    return;
                }

                Logger.info("Loading Fullstory code");

                window['_fs_debug'] = false;
                window['_fs_host'] = 'fullstory.com';
                window['_fs_script'] = 'edge.fullstory.com/s/fs.js';
                window['_fs_org'] = '10P9EZ';
                window['_fs_namespace'] = 'FS';
                (function(m,n,e,t,l,o,g,y){
                    if (e in m) {if(m.console && m.console.log) { m.console.log('FullStory namespace conflict. Please set window["_fs_namespace"].');} return;}
                    g=m[e]=function(a,b,s){g.q?g.q.push([a,b,s]):g._api(a,b,s);};g.q=[];
                    o=n.createElement(t);o.async=1;o.crossOrigin='anonymous';o.src='https://'+window['_fs_script'];
                    y=n.getElementsByTagName(t)[0];y.parentNode.insertBefore(o,y);
                    g.identify=function(i,v,s){g(l,{uid:i},s);if(v)g(l,v,s)};g.setUserVars=function(v,s){g(l,v,s)};g.event=function(i,v,s){g('event',{n:i,p:v},s)};
                    g.anonymize=function(){g.identify(!!0)};
                    g.shutdown=function(){g("rec",!1)};g.restart=function(){g("rec",!0)};
                    g.log = function(a,b){g("log",[a,b])};
                    g.consent=function(a){g("consent",!arguments.length||a)};
                    g.identifyAccount=function(i,v){o='account';v=v||{};v.acctId=i;g(o,v)};
                    g.clearUserCookie=function(){};
                    g.setVars=function(n, p){g('setVars',[n,p]);};
                    g._w={};y='XMLHttpRequest';g._w[y]=m[y];y='fetch';g._w[y]=m[y];
                    if(m[y])m[y]=function(){return g._w[y].apply(this,arguments)};
                    g._v="1.3.0";
                })(window,document,window['_fs_namespace'],'script','user');


                window['_fs_ready'] = function() {
                    const FS = window.FS;

                    // loading users details
                    // WARNING, this is not currently anonymized as WT1 is!
                    FS.setUserVars({
                        "displayName": $rootScope.appConfig.user.displayName || null,
                        "email": $rootScope.appConfig.user.email || null,
                        "licenseInstanceId_str": $rootScope.appConfig.licensing.licenseContent.instanceId || null,
                        "licenseKind_str": $rootScope.appConfig.licenseKind || null
                    });

                    // integration of wt1 events: level 1, just state-changed
                    if(event.type == 'state-changed') {
                        FS.event("Viewed " + event['dss-state'], {
                            "dssVersion_str": $rootScope.appConfig.version.product_version || null,
                            "userProfile_str": $rootScope.appConfig.userProfile.profile || null,
                            "licenseKind_str": $rootScope.appConfig.licenseKind || null
                        });
                    }

                    // integration of wt1 events: level 2, all events except pingt, v3-report (and state-changed, handled above)
                    if (event.type != 'state-changed' && event.type != 'pingt' && event.type != 'v3-report') {
                        FS.event(event["type"], {
                            "dssVersion_str": $rootScope.appConfig.version.product_version || null,
                            "userProfile_str": $rootScope.appConfig.userProfile.profile || null,
                            "licenseKind_str": $rootScope.appConfig.licenseKind || null
                        });
                    }
                    Logger.info("Fullstory configured");
                };

                loaded = true;


            }
        };
        return svc;

    });

})();
;
(function() {
'use strict';

const app = angular.module('dataiku.common.nav', ['dataiku.notebooks']);


app.service("TopNav", function($stateParams, $rootScope, Logger) {
    const svc = this;

    let currentPageTitle = "Dataiku";
    $rootScope.topNav = { item : {}, isProjectAnalystRO : true, homeSearchFilter: "" }

    function getItemKey(item) {
        const projectKey = item.projectKey || $stateParams.projectKey;
        const type = item.type || "";
        return projectKey + ':' + type + ':' + item.id;
    }

    function sameItem(item1, item2) {
        return item1 && item2 && (getItemKey(item1) == getItemKey(item2));
    }

    svc.setOverrideLeftType = function(type) {
        $rootScope.topNav.overrideLeftType = type;
    };

    svc.setPageTitle = function(title) {
        currentPageTitle = title;
        svc.refreshPageTitle();
    };

    svc.refreshPageTitle = function(){
        var pn = "";
        if ($rootScope.totalUnreadNotifications && $rootScope.totalUnreadNotifications > 0) {
            pn = "(" + $rootScope.totalUnreadNotifications + ") "
        }
        var it = "";
        if ($rootScope.appConfig && $rootScope.appConfig.isAutomation) {
            it = " (Automation)";
        }
        document.title = pn + currentPageTitle + " | Dataiku" + it;
    }

    /**
     * Valid "top" elements
     * Frontend only
     */
    svc.LOGIN = "LOGIN";
    svc.DSS_HOME = "DSS_HOME";
    svc.TOP_HOME = "HOME";
    svc.TOP_ACCESS_REQUEST = "ACCESS_REQUEST";
    svc.TOP_FLOW = "FLOW";
    svc.TOP_ANALYSES = "ANALYSES";
    svc.TOP_NOTEBOOKS = "NOTEBOOKS";
    svc.TOP_JOBS = "JOBS";
    svc.TOP_DASHBOARD = "DASHBOARD";
    svc.TOP_WIKI = "WIKI";
    svc.TOP_DEPLOYER = "DEPLOYER";
    svc.TOP_API_DEPLOYER = "API_DEPLOYER";
    svc.TOP_PROJECT_DEPLOYER = "PROJECT_DEPLOYER";
    svc.TOP_MORE = "MORE";
    svc.TOP_SAVED_MODELS = "SAVED_MODELS";
    svc.TOP_GENAI_MODELS = "GENAI_MODELS";
    svc.TOP_MODEL_EVALUATION_STORES = "MODEL_EVALUATION_STORES";
    svc.TOP_RETRIEVABLE_KNOWLEDGE = "RETRIEVABLE_KNOWLEDGE";
    svc.TOP_MODEL_COMPARISONS = "MODEL_COMPARISONS";
    svc.TOP_EXPERIMENT_TRACKING = "EXPERIMENT_TRACKING";
    svc.TOP_LABELING_TASK = "LABELING_TASK";
    svc.TOP_PROMPT_STUDIOS = "PROMPT_STUDIOS";
    svc.TOP_UNIFIED_MONITORING = "UNIFIED_MONITORING";
    svc.TOP_AGENT_TOOLS = "AGENT_TOOLS";
    svc.TOP_AGENT_HUB = "AGENT_HUB";

    /**
     *  Valid "left" elements
     *  Frontend only
     */
    svc.LEFT_FLOW = "flow";
    svc.LEFT_DATASETS = "datasets";
    svc.LEFT_RECIPES = "recipes";
    svc.LEFT_STREAMING_ENDPOINT = "streaming_endpoints";
    svc.LEFT_ANALYSES = "analyses";
    svc.LEFT_SAVED_MODELS = "saved models";
    svc.LEFT_GENAI_MODELS = "genai models";
    svc.LEFT_AGENT_HUB = "agent hub";
    svc.LEFT_MODEL_EVALUATION_STORES = "model evaluation stores";
    svc.LEFT_RETRIEVABLE_KNOWLEDGE = "knowledge banks";
    svc.LEFT_MODEL_COMPARISONS = "model comparisons";
    svc.LEFT_EXPERIMENT_TRACKING = "experiment tracking";
    svc.LEFT_PROMPT_STUDIOS = "prompt studios";
    svc.LEFT_AGENT_TOOLS = "agent tools";
    svc.LEFT_NOTEBOOKS = "notebooks";
    svc.LEFT_WEB_APPS = "webapps";
    svc.LEFT_REPORTS = "reports";
    svc.LEFT_LIBRARIES = "libraries";
    svc.LEFT_JOBS = "jobs";
    svc.LEFT_SCENARIOS = "scenarios";
    svc.LEFT_MONITORING = "monitoring";
    svc.LEFT_CONTINUOUS_ACTIVITIES = "continuous-activities";
    svc.LEFT_WIKI = "wiki";
    svc.LEFT_DASHBOARDS = "dashboards";
    svc.LEFT_INSIGHTS = "insights";
    svc.LEFT_LAMBDA_SERVICE = "lambda";
    svc.LEFT_BUNDLES_DESIGN = "bundlesdesign";
    svc.LEFT_BUNDLE_AUTOMATION = "bundlesautomation";
    svc.LEFT_VARIABLES = "variables";
    svc.LEFT_MACROS = "runnables";
    svc.LEFT_VERSION_CONTROL = "version-control";
    svc.LEFT_APP_DESIGNER = "appdesigner";
    svc.LEFT_SETTINGS = "settings";
    svc.LEFT_SECURITY = "security";


    /**
     * Valid item types
     * Shared with backend
     */
    svc.ITEM_DATASET = "DATASET";
    svc.ITEM_RECIPE = "RECIPE";
    svc.ITEM_ANALYSIS = "ANALYSIS";
    svc.ITEM_DASHBOARD = "DASHBOARD";
    svc.ITEM_WEB_APP = "WEB_APP";
    svc.ITEM_CODE_STUDIO = "CODE_STUDIO";
    svc.ITEM_REPORT = "REPORT";
    svc.ITEM_SQL_NOTEBOOK = "SQL_NOTEBOOK";
    svc.ITEM_SEARCH_NOTEBOOK = "SEARCH_NOTEBOOK";
    svc.ITEM_JUPYTER_NOTEBOOK = "JUPYTER_NOTEBOOK";
    svc.ITEM_SAVED_MODEL = "SAVED_MODEL";
    svc.ITEM_MODEL_EVALUATION_STORE = "MODEL_EVALUATION_STORE";
    svc.ITEM_RETRIEVABLE_KNOWLEDGE = "RETRIEVABLE_KNOWLEDGE";
    svc.ITEM_MODEL_COMPARISON = "MODEL_COMPARISON";
    svc.ITEM_MANAGED_FOLDER = "MANAGED_FOLDER";
    svc.ITEM_STREAMING_ENDPOINT = "STREAMING_ENDPOINT";
    svc.ITEM_JOB = "JOB";
    svc.ITEM_CONTINUOUS_ACTIVITY = "CONTINUOUS_ACTIVITY";
    svc.ITEM_INSIGHT = "INSIGHT";
    svc.ITEM_LAMBDA_SERVICE = "LAMBDA_SERVICE";
    svc.ITEM_SCENARIO = "SCENARIO";
    svc.ITEM_MONITORING = "MONITORING";
    svc.ITEM_PROJECT = "PROJECT";
    svc.ITEM_ARTICLE = "ARTICLE";
    svc.ITEM_LABELING_TASK = "LABELING_TASK";
    svc.ITEM_PROMPT_STUDIO = "PROMPT_STUDIO";
    svc.ITEM_AGENT_TOOL = "AGENT_TOOL";
    svc.ITEM_UNIFIED_MONITORING = "UNIFIED_MONITORING";

    /**
     * Valid tabs-type
     * Frontend only
     */
    svc.TABS_NONE = "NONE";
    svc.TABS_ANALYSIS = "ANALYSIS";
    svc.TABS_DATASET = "DATASET";
    svc.TABS_STREAMING_ENDPOINT = "STREAMING_ENDPOINT";
    svc.TABS_NEW_DATASET = "NEW-DATASET";
    svc.TABS_SAVED_MODEL = "SAVED_MODEL";
    svc.TABS_SAVED_MODEL_VERSION = "SAVED_MODEL-VERSION";
    svc.TABS_MODEL_EVALUATION_STORE = "MODEL_EVALUATION_STORE";
    svc.TABS_RETRIEVABLE_KNOWLEDGE = "RETRIEVABLE_KNOWLEDGE";
    svc.TABS_MODEL_COMPARISON = "MODEL_COMPARISON";
    svc.TABS_RECIPE = "RECIPE";
    svc.TABS_SQL_NOTEBOOK = "SQL_NOTEBOOK";
    svc.TABS_SEARCH_NOTEBOOK = "SEARCH_NOTEBOOK";
    svc.TABS_JUPYTER_NOTEBOOK = "JUPYTER_NOTEBOOK";
    svc.TABS_DASHBOARD = "DASHBOARD";
    svc.TABS_INSIGHT = "INSIGHT";
    svc.TABS_JOB = "JOB";
    svc.TABS_CONTINUOUS_ACTIVITY = "CONTINUOUS_ACTIVITY";
    svc.TABS_MANAGED_FOLDER = "MANAGED_FOLDER";
    svc.TABS_LAMBDA = "LAMBDA";
    svc.TABS_SCENARIO = "SCENARIO";
    svc.TABS_CODE_STUDIO = "CODE_STUDIO";
    svc.TABS_MONITORING = "MONITORING";
    svc.TABS_RUNNABLE = "RUNNABLE";
    svc.TABS_LABELING_TASK = "LABELING_TASK";
    svc.TABS_UNIFIED_MONITORING = "UNIFIED_MONITORING";


    svc.refreshPageTitle = function() {
        let pn = "";
        if ($rootScope.totalUnreadNotifications && $rootScope.totalUnreadNotifications > 0) {
            pn = "(" + $rootScope.totalUnreadNotifications + ") "
        }
        let it = "";
        if ($rootScope.appConfig && $rootScope.appConfig.isAutomation) {
            it = " (Automation)";
        }
        document.title = pn + currentPageTitle + " | Dataiku" + it;
    };

    /**
     * top = which universe is highlighted in the global nav (+color for item icon)
     * left = which "sub-universe" is active (e.g. Project Home > Settings)
     * tabsType = which tabs to show on the right on secondary nav
     * tab = which tab is active on the right on secondary nav
     */
    svc.setLocation = function setLocation(top, left, tabsType, tab) {
        $rootScope.topNav.top = top;
        $rootScope.topNav.left = left;
        $rootScope.topNav.tabsType = tabsType;
        $rootScope.topNav.tab = tab;

        Logger.debug("Set location to ", $rootScope.topNav);
    };

    svc.setTopLocation = function(top) {
        $rootScope.topNav.top = top;
    }

    svc.setProjectData = function(projectSummary, projectCurrentBranch) {
        $rootScope.topNav.project = projectSummary;
        $rootScope.topNav.projectCurrentBranch = (projectCurrentBranch && projectCurrentBranch !== "master" && projectCurrentBranch !== "main") ? projectCurrentBranch : "";
    };

    svc.setItem = function(type, id, data) {
        Logger.debug("Set item", type, id, data);
        const oldItem = $rootScope.topNav.item;
        const newItem = {
            type: type,
            id: id,
            data: data
        }
        const same = svc.sameItem(oldItem, newItem);
        $rootScope.topNav.item = newItem;
        // If we change item and don't have data yet, show "Loading..." state
        if (type && !same && !data) {
            $rootScope.topNav.item.data = {name: "Loading ...", loading: true };
        }
    };

    svc.getItem = function() {
        return $rootScope.topNav.item;
    };

    svc.setNoItem = function() {
        svc.setItem(null, null, null);
    };

    // Only changes the tab, nothing elses
    svc.setTab = function(tab) {
        $rootScope.topNav.tab = tab;
    };

    svc.sameItem = function(item1, item2) {
        return item1 && item2 && (getItemKey(item1) == getItemKey(item2));
    };

    svc.sameItem = sameItem;
});


app.factory("StateUtils", function($state, $stateParams, $filter, $rootScope, objectTypeFromNodeFlowType, SmartId,
    ActiveProjectKey, FullModelLikeIdUtils, LoggerProvider) {

    const logger = LoggerProvider.getLogger('common.nav.state.utils');

    function makeStateService(handlingFunction) {
        const that = {
            project: function(projectKey, options = {}) {
                const page = options.page || 'home.regular';
                return handlingFunction('projects.project.' + page, {
                    projectKey: projectKey,
                    discussionId: options.discussionId,
                    selectedTab: options.selectedTab
                });
            },
            pinboard: function(projectKey) {
                return handlingFunction('projects.project.pinboard', {
                    projectKey: projectKey
                });
            },
            dataset: function(datasetName, contextProject, options = {}) {
                contextProject = contextProject || ActiveProjectKey.get();
                const ref = SmartId.resolve(datasetName, contextProject);
                const tab = options.tab || 'explore';

                if (contextProject && ref.projectKey != contextProject && !options.moveToTargetProject) {
                    return handlingFunction('projects.project.foreigndatasets.dataset.' + tab, {
                        datasetFullName: datasetName,
                        projectKey: contextProject,
                        discussionId: options.discussionId,
                        chartId: options.chartId,
                    });
                } else {
                    return handlingFunction('projects.project.datasets.dataset.' + tab, {
                        projectKey: ref.projectKey,
                        datasetName: ref.id,
                        discussionId: options.discussionId,
                        chartId: options.chartId,
                    });
                }
            },
            managedFolder: function(id, projectKey, contextProject, options = {}) {
                //Note that foreign dataset view is not implemented
                contextProject = contextProject || ActiveProjectKey.get();
                const ref = SmartId.resolve(id, projectKey);
                const tab = options.tab || 'view'

                if (contextProject && ref.projectKey != contextProject && !options.moveToTargetProject) {
                    return handlingFunction('projects.project.foreignmanagedfolders.managedfolder.' + tab, {
                        projectKey: contextProject,
                        sourceProjectKey: ref.projectKey,
                        odbId: ref.id,
                        discussionId: options.discussionId
                    });
                } else {
                    return handlingFunction('projects.project.managedfolders.managedfolder.' + tab, {
                        projectKey: ref.projectKey,
                        odbId: ref.id,
                        discussionId: options.discussionId
                    });
                }
            },
            streamingEndpoint: function(id, projectKey, contextProject, options = {}) {
                //Note that foreign streaming endpoint view is not implemented
                contextProject = contextProject || ActiveProjectKey.get();
                const ref = SmartId.resolve(id, projectKey);
                const tab = options.tab || 'settings' // TODO:

                if (contextProject && ref.projectKey != contextProject && !options.moveToTargetProject) {
                    return handlingFunction('projects.project.foreignstreaming-endpoints.streaming-endpoint.' + tab, {
                        projectKey: contextProject,
                        sourceProjectKey: ref.projectKey,
                        streamingEndpointId: ref.id,
                        discussionId: options.discussionId
                    });
                } else {
                    return handlingFunction('projects.project.streaming-endpoints.streaming-endpoint.' + tab, {
                        projectKey: ref.projectKey,
                        streamingEndpointId: ref.id,
                        discussionId: options.discussionId
                    });
                }
            },
            savedModel: function(id, projectKey, options = {}) {
                //Note that foreign saved model view is not implemented
                const ref = SmartId.resolve(id, projectKey);
                const tab = options.tab || 'versions';
                return handlingFunction('projects.project.savedmodels.savedmodel.' + tab, {
                    projectKey: ref.projectKey,
                    smId: ref.id,
                    discussionId: options.discussionId
                });
            },
            savedModelVersion: function(taskType, smId, fullModelId, projectKey, savedModelType, options = {}) {
                const tab = options.tab || '';
                let state;
                if (savedModelType === "PYTHON_AGENT" || savedModelType === "PLUGIN_AGENT" || savedModelType === "TOOLS_USING_AGENT") {
                    state = 'projects.project.savedmodels.savedmodel.agent.design';
                } else if (savedModelType === "LLM_GENERIC") {
                    state = 'projects.project.savedmodels.savedmodel.llmGeneric.report';
                }  else if (savedModelType === "RETRIEVAL_AUGMENTED_LLM") {
                    state = 'projects.project.savedmodels.savedmodel.retrievalaugmentedllm.design';
                } else {
                    state = 'projects.project.savedmodels.savedmodel.' +  taskType.toLowerCase() + '.report';
                }
                return handlingFunction(state + tab, { projectKey: projectKey || ActiveProjectKey.get(), smId, fullModelId });
            },
            modelEvaluationStore: function(id, projectKey, options = {}) {
                //Note that foreign model evaluation store view is not implemented
                const ref = SmartId.resolve(id, projectKey);
                return handlingFunction('projects.project.modelevaluationstores.modelevaluationstore.evaluations', {
                    projectKey: ref.projectKey,
                    mesId: ref.id,
                    discussionId: options.discussionId
                });
            },
            retrievableKnowledge: function(id, projectKey, options = {}) {
                const ref = SmartId.resolve(id, projectKey);
                return handlingFunction('projects.project.retrievableknowledges.retrievableknowledge.usage', {
                    projectKey: ref.projectKey,
                    retrievableKnowledgeId: ref.id,
                    discussionId: options.discussionId
                });
            },
            modelComparison: function(id, projectKey, options = {}) {
                const ref = SmartId.resolve(id, projectKey);
                return handlingFunction('projects.project.modelcomparisons.modelcomparison.summary', {
                    projectKey: ref.projectKey,
                    modelComparisonId: ref.id,
                    discussionId: options.discussionId
                });
            },
            modelEvaluation: function(mesId, evaluationId, projectKey, isLLM) {
                const ref = SmartId.resolve(mesId, projectKey);
                const subRoute = isLLM ? 'evaluation.report.llm-evaluation-summary' : 'evaluation.report';
                const route = 'projects.project.modelevaluationstores.modelevaluationstore.' + subRoute;

                return handlingFunction(route, {
                    projectKey: ref.projectKey,
                    mesId: ref.id,
                    evaluationId: evaluationId
                });
            },
            promptStudio: function(promptStudioId, projectKey, options = {}) {
                const ref = SmartId.resolve(promptStudioId, projectKey);
                return handlingFunction('projects.project.promptstudios.promptstudio', {
                    projectKey: ref.projectKey,
                    promptStudioId: ref.id,
                    discussionId: options.discussionId
                });
            },
            agentTool: function(agentToolId, projectKey, options = {}) {
                const ref = SmartId.resolve(agentToolId, projectKey);
                return handlingFunction('projects.project.agenttools.agenttool', {
                    projectKey: ref.projectKey,
                    agentToolId: ref.id,
                    discussionId: options.discussionId
                });
            },
            projectStandards: function(checkId) {
                return handlingFunction('admin.projectstandards.checks', {checkId});
            },
            connection: function(connectionName) {
                return handlingFunction('admin.connections.edit', {
                    connectionName: connectionName,
                });
            },
            labelingTask: function(labelingTask, projectKey, options = {}) {
                const ref = SmartId.resolve(labelingTask, projectKey);
                return handlingFunction('projects.project.labelingtasks.labelingtask', {
                    projectKey: ref.projectKey,
                    labelingTaskId: ref.id,
                    discussionId: options.discussionId
                });
            },
            recipe: function(recipeName, projectKey, options = {}) {
                const ref = SmartId.resolve(recipeName, projectKey);
                return handlingFunction('projects.project.recipes.recipe', {
                    projectKey: ref.projectKey,
                    recipeName: ref.id,
                    discussionId: options.discussionId
                });
            },
            analysis: function(id, projectKey, options = {}) {
                const ref = SmartId.resolve(id, projectKey);
                const tab = options.tab || 'script';
                return handlingFunction('projects.project.analyses.analysis.' + tab, {
                    projectKey: ref.projectKey,
                    analysisId: ref.id,
                    discussionId: options.discussionId
                });
            },
            //deprecated use analysis
            analysisChart: function(chartId, analysisId, projectKey) {
                return handlingFunction('projects.project.analyses.analysis.charts', {
                    chartId,
                    analysisId: analysisId,
                    projectKey: projectKey || ActiveProjectKey.get()
                });
            },
            mlTask: function(id, projectKey, mlTaskType, mlTaskId) {
                const ref = SmartId.resolve(id, projectKey);
                return handlingFunction(
                    'projects.project.analyses.analysis.ml.' + (mlTaskType.toUpperCase() === 'CLUSTERING' ? 'clustmltask' : 'predmltask') + '.list.results',
                    {
                        projectKey: ref.projectKey,
                        analysisId: ref.id,
                        mlTaskId: mlTaskId
                    }
                );
            },
            analysisModelReport: function(mlTaskType, projectKey, analysisId, mlTaskId, fullModelId) {
                return handlingFunction(
                    'projects.project.analyses.analysis.ml.' + (mlTaskType.toUpperCase() === 'CLUSTERING' ? 'clustmltask' : 'predmltask') + '.model.report',
                    {
                        projectKey: projectKey,
                        analysisId: analysisId,
                        mlTaskId: mlTaskId,
                        fullModelId: fullModelId
                    }
                );
            },
            sqlNotebook: function(id, projectKey, options = {}) {
                const ref = SmartId.resolve(id, projectKey);
                return handlingFunction('projects.project.notebooks.sql_notebook', {
                    projectKey: ref.projectKey,
                    notebookId: ref.id,
                    discussionId: options.discussionId,
                    cellId: options.cellId
                });
            },
            searchNotebook: function(id, projectKey, options = {}) {
                const ref = SmartId.resolve(id, projectKey);
                return handlingFunction('projects.project.notebooks.search_notebook', {
                    projectKey: ref.projectKey,
                    notebookId: ref.id,
                    discussionId: options.discussionId
                });
            },
            jupyterNotebook: function(id, projectKey, options = {}) {
                const ref = SmartId.resolve(id, projectKey);
                return handlingFunction('projects.project.notebooks.jupyter_notebook', {
                    projectKey: ref.projectKey,
                    notebookId: ref.id,
                    discussionId: options.discussionId
                });
            },
            notebook: function(notebookType, notebookId, projectKey, options = {}) {
                if (notebookType.toUpperCase().includes('SQL')) {
                    return that.sqlNotebook(notebookId, projectKey, options);
                } else if (notebookType.toLowerCase() === 'search') {
                    return that.searchNotebook(notebookId, projectKey, options);
                }
                return that.jupyterNotebook(notebookId, projectKey, options);
            },
            webapp: function(webAppId, projectKey, options = {}) {
                const ref = SmartId.resolve(webAppId, projectKey);
                const tab = options.tab || 'view';
                return handlingFunction("projects.project.webapps.webapp." + tab, {
                    projectKey: ref.projectKey || ActiveProjectKey.get(),
                    webAppId: ref.id,
                    webAppName: options.name,
                    discussionId: options.discussionId
                });
            },
            codeStudio: function(codeStudioObjectId, projectKey, options = {}) {
                const ref = SmartId.resolve(codeStudioObjectId, projectKey);
                const tab = options.tab || 'view';
                return handlingFunction("projects.project.code-studios.code-studio." + tab, {
                    projectKey: ref.projectKey || ActiveProjectKey.get(),
                    codeStudioObjectId: ref.id,
                    codeStudioObjectName: options.name,
                    discussionId: options.discussionId
                });
            },
            codeStudioTemplate: function(codeStudioTemplateId) {
                return handlingFunction("admin.code-studios.code-studio", {
                    codeStudioTemplateId: codeStudioTemplateId
                });
            },
            plugin: function(pluginId) {
                return handlingFunction("plugin.summary", {
                    pluginId: pluginId
                });
            },
            report: function(reportId, projectKey, options = {}) {
                const ref = SmartId.resolve(reportId, projectKey);
                const tab = options.tab || 'view';
                return handlingFunction("projects.project.reports.report." + tab, {
                    projectKey: ref.projectKey || ActiveProjectKey.get(),
                    reportId: ref.id,
                    reportName: options.name,
                    discussionId: options.discussionId
                });
            },
            scenario: function(scenarioId, projectKey, options = {}) {
                const ref = SmartId.resolve(scenarioId, projectKey);
                const tab = options.tab || 'runs.list';
                return handlingFunction("projects.project.scenarios.scenario." + tab, {
                    projectKey: ref.projectKey || ActiveProjectKey.get(),
                    scenarioId: ref.id,
                    discussionId: options.discussionId,
                    runId: options.runId
                });
            },

            dashboard: function(id, projectKey, options = {}) {
                const ref = SmartId.resolve(id, projectKey);
                const tab = options.tab || 'view';
                return handlingFunction('projects.project.dashboards.dashboard.' + tab, {
                    projectKey: ref.projectKey,
                    dashboardId: ref.id,
                    dashboardName: options.name ? $filter('slugify')(options.name) : '',
                    pageId: options.pageId ? options.pageId : '',
                    fullScreen: options.fullScreen,
                    separator: '_',
                    discussionId: options.discussionId,
                    filters: options.filters
                });
            },
            insight: function(id, projectKey, options = {}) {
                const ref = SmartId.resolve(id, projectKey);
                const tab = options.tab || 'view';
                return handlingFunction('projects.project.dashboards.insights.insight.' + tab, {
                    projectKey: ref.projectKey,
                    insightId: ref.id,
                    insightName: options.name ? $filter('slugify')(options.name) : '',
                    fullScreen: options.fullScreen,
                    discussionId: options.discussionId,
                    originDashboard: options.originDashboard,
                    tabSelect: options.tabSelect,
                    sections: options.sections
                });
            },
            lambdaService: function(id, projectKey, options = {}) {
                const ref = SmartId.resolve(id, projectKey);
                const tab = options.tab || 'endpoints';
                return handlingFunction('projects.project.lambdaservices.service.' + tab, {
                    projectKey: ref.projectKey,
                    serviceId: ref.id,
                    discussionId: options.discussionId
                });
            },
            article: function(articleId, projectKey, options = {}) {
                const ref = SmartId.resolve(articleId, projectKey);
                const tab = options.tab || 'view';
                return handlingFunction("projects.project.wiki.article." + tab, {
                    projectKey: ref.projectKey || ActiveProjectKey.get(),
                    articleId: ref.id,
                    articleName: options.articleName,
                    discussionId: options.discussionId,
                    '#': ''
                });
            },
            cluster: function(clusterId, options = {}) {
                return handlingFunction('admin.clusters.cluster', {
                    clusterId: clusterId,
                    discussionId: options.discussionId
                });
            },
            statisticsWorksheet: function(worksheetId, contextProject) {
                const ref = SmartId.resolve(worksheetId, contextProject);
                return handlingFunction('projects.project.statisticsWorksheet', {
                    projectKey: ref.projectKey,
                    worksheetId: ref.id
                });
            },
            flowZone: function(id, contextProject, options = {}) {
                contextProject = contextProject || ActiveProjectKey.get();
                const ref = SmartId.resolve(id, contextProject);

                return handlingFunction('projects.project.flow', {
                    projectKey: ref.projectKey,
                    zoneId: ref.id,
                });
            },
            continuousActivity: function(id, contextProject, options = {}) {
                contextProject = contextProject || ActiveProjectKey.get();
                const ref = SmartId.resolve(id, contextProject);

                return handlingFunction('projects.project.continuous-activities.continuous-activity.runs', {
                    projectKey: ref.projectKey,
                    continuousActivityId: ref.id,
                });
            },
            chart: function(objectType, projectKey, ownerName, index) {
                if (objectType === 'dataset') {
                    return handlingFunction('projects.project.datasets.dataset.visualize', {
                        projectKey: projectKey,
                        datasetName: ownerName,
                        chartIdx: index
                    });
                } else if (objectType === 'analysis') {
                    return handlingFunction('projects.project.analyses.analysis.charts', {
                        projectKey: projectKey,
                        analysisId: ownerName,
                        chartIdx: index
                    });
                } else {
                    return null;
                }
            },
            /* for all taggable types */
            dssObject: function(type, id, projectKey, options = {}) { //if moveToTargetProject is falsish, explore as foreign object
                projectKey = projectKey || ActiveProjectKey.get();
                switch (type) {
                    case 'DATASET':
                        return that.dataset(id, projectKey, options);
                    case 'SAVED_MODEL':
                        return that.savedModel(id, projectKey, options);
                    case 'MODEL_EVALUATION_STORE':
                        return that.modelEvaluationStore(id, projectKey, options);
                    case 'MODEL_COMPARISON':
                        return that.modelComparison(id, projectKey, options);
                    case 'MANAGED_FOLDER':
                        return that.managedFolder(id, projectKey, null, options);
                    case 'STREAMING_ENDPOINT':
                        return that.streamingEndpoint(id, projectKey, null, options);
                    case 'RECIPE':
                        return that.recipe(id, projectKey, options);
                    case 'ANALYSIS':
                        if (options.mlTaskId && options.subType) {
                            return that.mlTask(id, projectKey, options.subType, options.mlTaskId);
                        }
                        return that.analysis(id, projectKey, options);
                    case 'STATISTICS_WORKSHEET':
                        return that.statisticsWorksheet(id, projectKey, options);
                    case 'SQL_NOTEBOOK':
                        return that.sqlNotebook(id, projectKey, options);
                    case 'SEARCH_NOTEBOOK':
                        return that.searchNotebook(id, projectKey, options);
                    case 'JUPYTER_NOTEBOOK':
                        return that.jupyterNotebook(id, projectKey, options);
                    case 'INSIGHT':
                        return that.insight(id, projectKey, options);
                    case 'WEB_APP':
                        return that.webapp(id, projectKey, options);
                    case 'CODE_STUDIO':
                        return that.codeStudio(id, projectKey, options);
                    case 'REPORT':
                        return that.report(id, projectKey, options);
                    case 'ARTICLE':
                        return that.article(id, projectKey, options);
                    case 'SCENARIO':
                        return that.scenario(id, projectKey, options);
                    case 'DASHBOARD':
                        return that.dashboard(id, projectKey, options);
                    case 'PROJECT':
                        return that.project(id || projectKey, options);
                    case 'APP':
                        return that.app(id);
                    case 'LAMBDA_SERVICE':
                        return that.lambdaService(id, projectKey, options);
                    case 'CLUSTER':
                        return that.cluster(id, options);
                    case 'JOB':
                        return that.job(projectKey, id);
                    case 'FLOW_ZONE':
                        return that.flowZone(id, projectKey, options);
                    case 'CONTINUOUS_ACTIVITY':
                        return that.continuousActivity(id, projectKey, options);
                    case 'LABELING_TASK':
                        return that.labelingTask(id, projectKey, options);
                    case 'DATA_COLLECTION':
                        return that.dataCollection(id, options);
                    case 'PROMPT_STUDIO':
                        return that.promptStudio(id, projectKey, options);
                    case 'AGENT_TOOL':
                        return that.agentTool(id, projectKey, options);
                    case 'PROJECT_STANDARDS_CHECK':
                        return that.projectStandards(id);
                    case 'RETRIEVABLE_KNOWLEDGE':
                        return that.retrievableKnowledge(id, projectKey, options);
                    case 'CONNECTION':
                        return that.connection(id);
                    case 'WORKSPACE':
                        return that.workspace(id);
                }
                throw new Error("Unknown object type: '" + type + "' for " + projectKey + '.' + id);
            },
            taggableObject: function(tor, options = {}) { //if moveToTargetProject is falsish, explore as foreign object
                if (tor.workspaceKey) {
                    if (tor.projectKey) {
                        return that.workspaceObject(tor.workspaceKey, tor.projectKey, tor.type, tor.id, options);
                    }
                    return that.workspace(tor.workspaceKey, options);
                }
                return that.dssObject(tor.type, tor.id, tor.projectKey, options);
            },
            table: function(connection, catalog, schema, table) {
                return handlingFunction(
                    'external-table',
                    { connection, catalog, schema, table }
                );
            },
            node: function(flowNode) {
                if (!flowNode) return;
                switch (flowNode.nodeType) {
                    case 'LOCAL_DATASET':
                        return that.dataset(flowNode.name, flowNode.projectKey);
                    case 'FOREIGN_DATASET':
                        return that.dataset(flowNode.projectKey + '.' + flowNode.name, ActiveProjectKey.get());
                    case 'LOCAL_SAVEDMODEL':
                    case 'FOREIGN_SAVEDMODEL':
                        return that.savedModel(flowNode.name, flowNode.projectKey);
                    case 'LOCAL_MODELEVALUATIONSTORE':
                    case 'FOREIGN_MODELEVALUATIONSTORE':
                        return that.modelEvaluationStore(flowNode.name, flowNode.projectKey);
                    case 'LOCAL_RETRIEVABLE_KNOWLEDGE':
                    case 'FOREIGN_RETRIEVABLE_KNOWLEDGE':
                        return that.retrievableKnowledge(flowNode.name, flowNode.projectKey);
                    case 'LOCAL_MANAGED_FOLDER':
                    case 'FOREIGN_MANAGED_FOLDER':
                        return that.managedFolder(flowNode.name, flowNode.projectKey);
                    case "LOCAL_STREAMING_ENDPOINT":
                    case "FOREIGN_STREAMING_ENDPOINT":
                        return that.streamingEndpoint(flowNode.name, flowNode.projectKey);
                    case "LABELING_TASK":
                        return that.labelingTask(flowNode.name, flowNode.projectKey);
                    case 'RECIPE':
                        return that.recipe(flowNode.name, flowNode.projectKey);
                    case 'ZONE':
                        return that.flowZone(flowNode.name, flowNode.projectKey);
                    case 'JUPYTER_NOTEBOOK':
                        return that.jupyterNotebook(flowNode.id, flowNode.projectKey);
                    case 'SQL_NOTEBOOK':
                        return that.sqlNotebook(flowNode.id, flowNode.projectKey);
                    case 'SEARCH_NOTEBOOK':
                        return that.searchNotebook(flowNode.id, flowNode.projectKey);
                    default:
                        logger.error('Unknown Flow node nodeType: ' + flowNode.nodeType);
                }
            },
            // contextProjectKey is the project the foreign object currently is in
            flowLink: function(flowNode, contextProjectKey) {
                const type = objectTypeFromNodeFlowType(flowNode.nodeType).toLowerCase();
                return that.flowLinkFromProps(type, flowNode.projectKey, flowNode.name, contextProjectKey);
            },
            // contextProjectKey is the project the foreign object currently is in
            flowLinkFromProps: function(objectType, objectProjectKey, objectId, contextProjectKey) {
                let id;
                switch (objectType.toLowerCase()) {
                    case 'dataset':
                        id = "dataset_" + objectProjectKey + '.' + objectId;
                        break;
                    case 'managed_folder':
                        id = "managedfolder_" + objectProjectKey + '.' + objectId;
                        break;
                    case 'model_evaluation_store':
                        id = "modelevaluationstore_" + objectProjectKey + '.' + objectId;
                        break;
                    case 'saved_model':
                        id = "savedmodel_" + objectProjectKey + '.' + objectId;
                        break;
                    case 'retrievable_knowledge':
                        id = "retrievableknowledge_" + objectProjectKey + '.' + objectId;
                        break;
                    case 'streaming_endpoint':
                        id = "streamingendpoint_" + objectProjectKey + '.' + objectId;
                        break;
                    case 'labeling_task':
                        id = "labelingtask_" + objectProjectKey + '.' + objectId;
                        break;
                    case 'recipe':
                        id = "recipe_" + objectId;
                        break;
                }

                return handlingFunction('projects.project.flow', {
                    id,
                    projectKey: contextProjectKey || objectProjectKey
                });
            },
            job: function(projectKey, jobId) {
                return handlingFunction("projects.project.jobs.job", {
                    projectKey : projectKey || ActiveProjectKey.get(),
                    jobId : jobId
                });
            },
            home: function() {
                return handlingFunction("home", {});
            },
            workspaces: function() {
                return handlingFunction("workspaces.home", {});
            },
            workspace: function(workspaceKey, options = {}) {
                return handlingFunction("workspaces.workspace", {
                    workspaceKey: workspaceKey,
                    discussionId: options.discussionId,
                });
            },
            workspaceObject: function(workspaceKey, projectKey, objectType, objectId, options = {}) {
                return handlingFunction("workspaces.object", {
                    workspaceKey,
                    projectKey,
                    objectType,
                    objectId,
                    discussionId: options.discussionId,
                });
            },
            workspaceDashboardInsight: function(workspaceKey, projectKey, dashboardId, insightId) {
                return handlingFunction("workspaces.object.insight.view", {
                    workspaceKey,
                    projectKey,
                    objectType: 'DASHBOARD',
                    objectId: dashboardId,
                    insightId,
                });
            },
            workspaceApp: function(workspaceKey, appId) {
                return handlingFunction("workspaces.app", {
                    workspaceKey,
                    appId
                })
            },
            app: function(appId) {
                let appRef = SmartId.resolve(appId);
                return handlingFunction("apps.app", {
                    appId: appRef.id
                });
            },
            projectFolder: function(folderId) {
                // TODO @homepage cleanup one migration done
                if($rootScope.featureFlagEnabled('homepageRedesign')) {
                    return handlingFunction("homeV2.projects.folder", {
                        folderId: folderId === 'ROOT' ? '' : folderId
                    });
                } else {
                    return handlingFunction("project-list", {
                        folderId: folderId === 'ROOT' ? '' : folderId
                    });
                }

            },
            inboxRequest: function(requestId) {
                return handlingFunction("inbox.requests.selected", {
                    requestId: requestId
                });
            },
            pluginSummary: function(pluginId) {
                return handlingFunction('plugin.summary', {
                    pluginId: pluginId
                });
            },
            pluginStore: function(pluginId) {
                return handlingFunction('plugins.store', {
                    pluginid: pluginId
                });
            },
            pluginDefinition: function(pluginId) {
                return handlingFunction('plugindev.definition', {
                    pluginId: pluginId
                });
            },
            pluginEditor: function(pluginId, path) {
                return handlingFunction('plugindev.editor', {
                    pluginId: pluginId,
                    filePath: path
                });
            },
            projectLibEditor: function(projectKey, path) {
                return handlingFunction('projects.project.libedition.versioned', {
                    projectKey: projectKey,
                    initialPath: path
                });
            },
            globalLibEditor: function(path) {
                return handlingFunction('libedition.libpython', {
                    initialPath: path
                });
            },
            codeEnvCreation: function(id) {
                return handlingFunction('admin.codeenvs-design.create', {
                    draftId: id
                });
            },
            codeEnvEdit: function(envName, envLang) {
                if (envLang === "PYTHON") {
                    return handlingFunction('admin.codeenvs-design.python-edit', {
                        envName: envName
                    });
                } else if (envLang === "R") {
                    return handlingFunction('admin.codeenvs-design.r-edit', {
                        envName: envName
                    });
                } else {
                    logger.error(`Unknown envLang: ${envLang}`);
                    return;
                }
            },
            fullModelLikeId: function(fullId, mlTaskType = 'PREDICTION', isLLM) {
                const item = FullModelLikeIdUtils.parse(fullId);
                if (fullId.startsWith("ME-")) {
                    return that.modelEvaluation(item.id, item.evaluationId, item.projectKey, isLLM);
                } else if (fullId.startsWith("S-")) {
                    return that.savedModelVersion(mlTaskType, item.savedModelId, fullId, item.projectKey);
                } else if (fullId.startsWith("A-")) {
                    return that.analysisModelReport(mlTaskType, item.projectKey, item.analysisId, item.mlTaskId, fullId);
                }
                throw new Error("Unexpected type");
            },
            dataCollection: function(dataCollectionId, fromProject = false) {
                // when using fromProject, You MUST already be in the project (it's not valid to go directly to an in-project view from outside)
                if (fromProject) {
                    return handlingFunction('projects.project.datacatalog.datacollections.datacollection', {dataCollectionId: dataCollectionId})
                } else {
                    return handlingFunction('homeV2.data-catalog.data-collections.data-collection', {dataCollectionId: dataCollectionId})
                }
            },
            apiDeployer: {
                deployment: function(deploymentId, options = {}) {
                    const tab = options.tab || 'status';
                    return handlingFunction('apideployer.deployments.deployment.' + tab, {
                        deploymentId: deploymentId
                    });
                },
                serviceVersions: function(serviceId, versions) {
                    return handlingFunction('apideployer.services.service.status', {
                        serviceId: serviceId,
                        versions: versions
                    });
                }
            },
            projectDeployer: {
                bundle: function(projectKey, bundleId) {
                    return handlingFunction('projectdeployer.projects.project.bundle.status', {
                        publishedProjectKey: projectKey,
                        bundleId: bundleId
                    });
                }
            }
        };
        return that;
    }

    function getDefaultTab(alternate) {
        const scd = $state.current.data;
        return scd && scd.tab ? scd.tab : alternate;
    }

    return {
        href: makeStateService($state.href.bind($state)),
        go: makeStateService($state.go.bind($state)),
        uiSref: makeStateService((ref, params) => (`${ref}(${JSON.stringify(params)})`)),
        // Added to pass options to the underlying $state.go call, such as {reload: true}
        goWithOptions: (options) => makeStateService((to, params) => {
            $state.go(to, params, options)
        }),
        defaultTab: getDefaultTab
    };
});


app.directive("stdObjectBreadcrumb", function($rootScope, $state, Navigator, DatasetCustomFieldsService, translate) {
    return {
        templateUrl: '/templates/widgets/std-object-breadcrumb.html',
        scope: {
            jobDef: "=jobDef",
            jobStatus: "=jobStatus",
            projectAppView: '<?', // for projects / app instances, says if it's a project view or app view
        },
        link: function(scope) {
            scope.topNav = $rootScope.topNav;
            scope.$state = $state;
            scope.Navigator = Navigator;
            scope.DatasetCustomFieldsService = DatasetCustomFieldsService;
            scope.translate = translate;
        }
    };
});

app.component('computableParentLink', {
    bindings: {
        computableFullInfo: '<',
    },
    controller: function ctrlComputableParentLink($state) {
        this.$state = $state;
    },
    templateUrl: '/templates/widgets/computable-parent-link.html'
});

app.component('copyToClipboardIcon', {
    bindings: {
        name: '<',
        value: '<',
        tooltipPosition: '<',
        iconClass: '<',
        iconSize: '<',
        disabled: '<',
    },
    controller: function($scope, $timeout, Logger, translate, ClipboardUtils){
        const ctrl = this;

        ctrl.$onInit = function () {
            ctrl.copied = false;
            ctrl.error = false;
            ctrl.iconSize = ctrl.iconSize || '16';
            ctrl.name = (ctrl.name !== undefined && ctrl.name !== null) ? ctrl.name : translate("COPY_TO_CLIPBOARD_ICON.NAME", "name");
            $scope.translate = translate;
        }

        ctrl.copyContent = function() {
            if (ctrl.disabled) return;

            ClipboardUtils.copyToClipboard(ctrl.value, '', '').then(() => {
                ctrl.copied = true;
                ctrl.inFlightTimeout = $timeout(() => {
                    ctrl.copied = false;
                    $scope.$apply();
                }, 2000);
                $scope.$apply();
            }, (exception) => {
                Logger.error("Failed to copy to clipboard", exception);
                ctrl.error = true;
                ctrl.inFlightTimeout = $timeout(() => {
                    ctrl.error = false;
                    $scope.$apply();
                }, 10000);
                $scope.$apply();
            });
        }

        ctrl.$onChanges = function() {
            if (ctrl.inFlightTimeout) {
                $timeout.cancel(ctrl.inFlightTimeout);
            }
            ctrl.copied = false;
            ctrl.error = false;
        }
    },
    templateUrl: '/templates/widgets/copy-to-clipboard-icon.html'
});


app.directive("itemHeader", function() {
    return {
        scope: {
            item: '=',
            href: '=',
            color: '@',
            icon: '@',
            title: '@',
            class: '@',
            flowLink: '=?',
            exposeObjectFn: '=?',
            exposeIcon: '=?',
            exposeLabel: '=?',
            exposeDisabled: '=?',
            importLbl: '=?',
            navigatorFn: '=?',
            editable: '=?',
            edit: '&?',
            deletable: '=?',
            delete: '&?',
            copyToClipboardValue: '@?'
        },
        transclude: true,
        template:
            `<div class="{{class}} item-header horizontal-flex aic">
                <div class="noflex object-icon universe-background {{color}}" style="margin-bottom:0">
                    <div class="middle"><i class="icon {{icon}}"></i></div>
                </div>
                <h2 class="flex" title="{{title}}">
                    <a href="{{href}}" ng-if="href"><ng-transclude></ng-transclude></a>
                   <span ng-if="!href"><ng-transclude></ng-transclude></span>
                   <copy-to-clipboard-icon ng-if="copyToClipboardValue" value="copyToClipboardValue" class="mleft4" />
                </h2>
                <div class="btn-items">
                    <span title="{{exposeLabel}}" toggle="tooltip"><button disabled-if='exposeDisabled' ng-if="exposeObjectFn" ng-click="exposeObjectFn()" class="btn btn--secondary" container="button"><i class="{{exposeIcon || 'icon-dku-share'}}"></i> {{importLbl || "Use"}}</button></span>
                    <button ng-if="navigatorFn" ng-click="navigatorFn()" class="btn btn--secondary btn--icon" alt="Navigate around" title="Navigate around">
                        <i class="icon-compass"></i>
                    </button>
                    <a ng-if="flowLink" class="btn btn--secondary btn--icon" href="{{flowLink}}" alt="See in flow" title="See in flow">
                        <i class="icon-dku-nav_flow"></i>
                    </a>
                    <button ng-if="editable" ng-click="edit()" class="btn btn--secondary btn--icon" alt="Edit">
                        <i class="icon-pencil"></i>
                    </button>
                    <button ng-if="deletable" ng-click="delete()" class="btn btn--secondary btn--icon" alt="Delete">
                        <i class="icon-trash"></i>
                    </button>
                </div>
            </div>`,
        link: function(scope, element, attrs, ctrl, transclude) {
          //NOSONAR ng1.6 doesnt work; doesnt appear necessary probably due to https://github.com/angular/angular.js/commit/32aa7e7395527624119e3917c54ee43b4d219301 //element.find('ng-transclude').replaceWith(transclude());
        }
    };
});


app.directive("simpleRightColActionHref", function($rootScope) {
    return {
        scope: {
            href: '@',
            label: '@',
            icon: '@',
            title: '@',
            target: '@'
        },
        replace: true,
        template:   `<div class="action-icon" role="button">
                        <a href="{{href}}" target="{{target}}">
                            <i class="{{icon}}"></i>
                            <label>{{label}}</label>
                        </a>
                    </div>`
    };
});


app.directive("simpleRightColActionClick", function($rootScope) {
    return {
        scope: {
            onClick : '&',
            label : '@',
            icon : '@',
            title : '@'
        },
        replace: true,
        template:   `<div class="action-icon" ng-click="onClick()" role="button">
                        <i class="{{icon}}"></i>
                        <label>{{label}}</label>
                    </div>`
    };
});

app.component("simpleRightColShareButton", { // simple-right-col-share-button
        bindings: {
            // for conditions that should hide the button regardless of the share capability of the user (example this is a foreign dataset)
            // use ng-if on the component to make conditions simpler and less redundant.

            // Share options
            canShare: '<', // will show the share button
            shareToProject: '&',
            // Request share options
            canRequestShare: '<', // will show the request share button if canShare is false
            requestShareToProject:'&',
            // Disabled state
            showIfDisabled: '<', // show the share button, but disabled it neither share nor request share is possible
            disabledTooltip : '@',
            // General
            enableWt1ClickIds: '<',
            label: '<' // Not actually necessary for the component by itself but used by the ellipsedList
        },
        templateUrl: '/templates/right-col-share-button-menu.html',
        controller: function($element){
            const ctrl = this;
            /** Update component wrapper visibility */
            const updateComponentWrapperVisibility = () => {
                if (!ctrl.showShareButton && !ctrl.showRequestAccessButton){
                    $element.addClass('hide');
                } else {
                    $element.removeClass('hide');
                }
                if (ctrl.disableShareButton) {
                    $element.addClass('disabled');
                } else {
                    $element.removeClass('disabled');
                }
            }

            this.$onChanges = function () {
                ctrl.showShareButton = ctrl.canShare || (ctrl.showIfDisabled && !ctrl.canRequestShare);
                ctrl.disableShareButton = !ctrl.canShare && !ctrl.canRequestShare && ctrl.showIfDisabled;
                ctrl.showRequestAccessButton = !ctrl.canShare && ctrl.canRequestShare;
                updateComponentWrapperVisibility();
            }
        }
});

app.directive("clickNext", function($timeout, $stateParams, $state, Dialogs) {
    return {
        scope: false,
        restrict: 'A',
        link: function(scope, element, attrs) {
            const $e = $(element);
            $e.on('click', function(evt) {
                $e.next().trigger(evt);
            });
        }
    };
});

app.component('noAccessScreen', {
    bindings: {
        message: '@'
    },
    template: `<div class="no-access-screen">
                   <i class="icon-4x icon-warning-sign"></i>
                   <span class="no-access-screen__text">{{$ctrl.message || 'You do not have the permission to access this page.'}}</span>
               </div>`
});

app.component('requestAccessTopBar', {
    bindings: {
        accessInfo: '<',
        objectType: '<',
        objectName: '<',
        autoOpenModal: '<',
        objectId: '<',
    },
    templateUrl: '/templates/request-access-top-bar.html',
    controller: function ctrlRequestAccessTopBar($scope, CreateModalFromTemplate, DataikuAPI, RequestCenterService) {
        const ctrl = this;
        ctrl.HAS_REQUEST_STATUS = {
            PENDING: 'PENDING',
            HAS_REQUEST:'HAS_REQUEST',
            NO_REQUEST: 'NO_REQUEST'
        };
        ctrl.pendingRequest = ctrl.HAS_REQUEST_STATUS.PENDING;

        function getObjectProjectKey() {
            switch (ctrl.objectType) {
                case 'PROJECT':
                    return ctrl.objectId;
                case 'APP':
                    if (ctrl.objectId.startsWith("PROJECT_")) {
                        return ctrl.objectId.substring("PROJECT_".length);
                    } else if (ctrl.objectId.startsWith("PLUGIN_")) {
                        return ctrl.objectId.substring("PLUGIN_".length);
                    }
                    break;
                default:
                    throw "Unhandled objectType: " + ctrl.objectType;
            }
        }

        ctrl.getLatestRequestForCurrentUser = function() {
            DataikuAPI.requests.getLatestRequestForCurrentUser(ctrl.objectId, ctrl.objectType, getObjectProjectKey()).then(response => {
                ctrl.request = response.data;
                if(ctrl.request.status === 'PENDING'){
                    ctrl.pendingRequest = ctrl.HAS_REQUEST_STATUS.HAS_REQUEST;
                } else {
                    ctrl.pendingRequest = ctrl.HAS_REQUEST_STATUS.NO_REQUEST;
                    if (ctrl.accessInfo.isAccessRequestsEnabled && ctrl.autoOpenModal) {
                        ctrl.openRequestAccessModal();
                    }
                }
            }, error => {
                if(error.status === 404){
                    ctrl.pendingRequest = ctrl.HAS_REQUEST_STATUS.NO_REQUEST;
                    if (ctrl.accessInfo.isAccessRequestsEnabled && ctrl.autoOpenModal) {
                        ctrl.openRequestAccessModal();
                    }
                } else {
                    setErrorInScope.bind($scope)(error);
                }
            });
        }

        ctrl.openRequestAccessModal = () => {
            CreateModalFromTemplate("/templates/request-access-modal.html", $scope, null, (newScope) => {
                newScope.objectType = ctrl.objectType;
                newScope.objectId = ctrl.objectId;
                newScope.objectName = ctrl.objectName;
                newScope.ui = { message: ""};

                newScope.sendRequest = (requestMessage) => {
                    DataikuAPI.requests.createAccessRequest(ctrl.objectType, getObjectProjectKey(), ctrl.objectId, requestMessage).success((data) => {
                        RequestCenterService.WT1Events.onRequestSent(ctrl.objectType, getObjectProjectKey(), ctrl.objectId, requestMessage, data.id);
                        ctrl.getLatestRequestForCurrentUser();
                    }).error(() => {
                        setErrorInScope.bind($scope);
                    });
                    newScope.dismiss();
                };
            });
        };

        ctrl.$onChanges = (changes) => {
            if(changes.accessInfo) {
                ctrl.actionMessage = ctrl.accessInfo.isAccessRequestsEnabled
                    ? ` Contact the project administrators for access.`
                    : ` Contact the project administrators for more information.`;
            }

            if(changes.objectType || changes.objectId) {
                ctrl.getLatestRequestForCurrentUser();
            }
        }
    }
});

app.directive("tabModel", function($timeout, $stateParams, $state, Dialogs) {
    return {
        scope: false,
        restrict: 'A',
        link: function(scope, element, attrs) {
            const $e = $(element),
                expr = attrs.tabModel + ' = $tab',
                klass = attrs.tabActiveClass || 'active',
                notify = attrs.tabModelNotify === "true" ? true : false,
                disableTransition = attrs.disableTransition === "true" ? true : false;

            function transition(evt, e) {
                const tab = e.getAttribute('tab-set');
                if (disableTransition) {
                    scope.$eval.bind(scope, expr, {$tab: tab})();
                } else {
                    $state.go('.', {selectedTab: tab}, {location: true, inherit: true, relative: $state.$current, notify: notify }).then(function() {
                        scope.$eval.bind(scope, expr, {$tab: tab})();
                    });
                }
            }

            $e.on('click', '[tab-set]', function(evt) {
                const that = this;
                if(scope.hooks && scope.hooks.dirty && scope.hooks.dirty()) {
                    Dialogs.confirm(scope, 'Unsaved changes', "You have unsaved changes. Are you sure you want to leave this page ?")
                        .then( _ => transition(evt, that) );
                } else {
                    scope.$apply( _ => transition(evt, that) );
                }
            });

            let activeTab = attrs.tabModel; // Since `updateActiveTab` is called by `$watch`ers below, it..
            const updateActiveTab = () => { // ..shouldn't rely on `attrs.tabModel`. We use `activeTab` instead.
                $e.find('[tab-active]').each(function() {
                    let validTabs = [this.getAttribute('tab-active')];
                    const alternativeTabs = this.getAttribute('alternative-tabs');
                    if (alternativeTabs) {
                        validTabs = validTabs.concat(JSON.parse(alternativeTabs.replace(/'/g, '"')));
                    }
                    this.classList[validTabs.includes(activeTab) ? 'add' : 'remove'](klass);
                });
            }
            // `attrs.tabModel` may be set before some tabs are loaded.
            // Therefore, we `$watch` both `attrs.tabModel` and the DOM.
            const getTabNames = () => $e.find('[tab-active]').toArray().map(e => e.innerText);
            scope.$watchCollection(getTabNames, updateActiveTab);
            scope.$watch(attrs.tabModel, (newVal, _) => {
                activeTab = newVal;
                updateActiveTab();
            });
        }
    };
});


app.service("QuickView", function(CreateCustomElementFromTemplate, $rootScope, $timeout) {
    const svc = this;

    let elScope, removeListener;

    this.show = function(projectKey, objectType, objectId) {
        if (projectKey === false) return;

        if (!elScope) {
            CreateCustomElementFromTemplate("/templates/object-details/quick-view.html", $rootScope, null, function(newScope) {
                elScope = newScope;
                elScope.hasObject = false;
                elScope.objectType = objectType;
                elScope.objectId = objectId;
                elScope.projectKey = projectKey;
                $timeout(function() { $('.object-quick-view-wrapper').addClass('visible'); });
            });
        } else {
            elScope.hasObject = false;
            elScope.objectType = objectType;
            elScope.objectId = objectId;
            elScope.projectKey = projectKey;
        }

        $('.object-quick-view-wrapper').removeClass('loading');
        removeListener = $rootScope.$on("$stateChangeStart", svc.hide);
    };

    this.showObject = function(object, objectType) {
        if (object === false) return;

        const objectData = {};
        objectData[objectType.toLowerCase()] = object;

        if (!elScope) {
            CreateCustomElementFromTemplate("/templates/object-details/quick-view.html", $rootScope, null, function(newScope) {
                elScope = newScope;
                elScope.hasObject = true;
                elScope.objectType = objectType;
                elScope.objectData = objectData;
                $timeout(function() { $('.object-quick-view-wrapper').addClass('visible'); });
            });
        } else {
            elScope.hasObject = true;
            elScope.objectType = objectType;
            elScope.objectData = objectData;
        }

        $('.object-quick-view-wrapper').removeClass('loading');
        removeListener = $rootScope.$on("$stateChangeStart", svc.hide);
    };

    this.hide = function() {
        if (elScope && elScope.dismiss) {
            elScope.dismiss();
            elScope = null;
        }

        if (removeListener) removeListener();
    };

    this.setLoading = function() {
        $('.object-quick-view-wrapper').addClass('loading');
    };
});

app.directive("objectDetails", function ($rootScope, $q, $timeout, $state, $stateParams, $filter, translate, DataikuAPI, DatasetUtils, ActivityIndicator,
    RecipesUtils, QuickView, NotebooksUtils, StateUtils, LoggerProvider, CreateModalFromTemplate, TaggingService, TAGGABLE_TYPES, ActiveProjectKey,
    _SummaryHelper, ObjectDetailsUtils, SavedModelsService, EditDatasetDataStewardModalService, ProjectStandardsService, TypeMappingService) {
    const logger = LoggerProvider.getLogger('objectDetails');

    return {
        restrict: 'E',
        template: '<div ng-if="objectType" ng-include="getTemplateFile()" />',
        scope: {
            projectKey: '=',
            objectType: '@',
            objectId: '=?',
            data: '=?objectData',
            context: '@', // 'right-column', 'right-column-workspace', 'navigator', 'new-insight'
            hoverIntentCallback: '=?',
            editable: '=?',
            editCustomFields: '=',
            showTopBorder: '<'
        },
        link: function($scope, element, attrs) {
            $scope.translate = translate;
            _SummaryHelper.addEditBehaviour($scope, element);
            _SummaryHelper.addInterestsManagementBehaviour($scope);

            $scope.getObjectId = function() {
             return $scope.object.id || $scope.object.name;
            };

            $scope.uiState = {
                isHoverEdit: false
            };
            $scope.appConfig = $rootScope.appConfig;

            $scope.resolveObjectSmartId = resolveObjectSmartId;

            $scope.QuickView = QuickView;
            $scope.StateUtils = StateUtils;

            $scope.canWriteProject = () => $scope.editable;

            $scope.canReadProject = $rootScope.projectSummary && $rootScope.projectSummary.canReadProjectContent;

            $scope.isProjectAdmin = () => $rootScope.projectSummary && $rootScope.projectSummary.isProjectAdmin;

            $scope.saveCustomFields = function (customFields) {
                $scope.$emit('customFieldsSummaryEdited', customFields);
            };

            $scope.inNavigator = function() {
                return ObjectDetailsUtils.inNavigator($scope.context);
            };

            $scope.setHoverEdit = function (on)  {
                $scope.uiState.isHoverEdit = on;
            };

            $scope.inRightColumn = function() {
                return $scope.context == 'right-column' || $scope.context == 'right-column-workspace';
            };

            $scope.inWorkspace = function() {
                return ObjectDetailsUtils.inWorkspace($scope.context)
            };

            $scope.inQuickView = function() {
                return ObjectDetailsUtils.inQuickView($scope.context)
            };

            if (!$scope.context) $scope.context = '';
            if ($scope.inQuickView()) {
                $scope.maxListItems = 5;
            }

            $scope.getTemplateFile = function() {
                return '/templates/object-details/' + $scope.objectType.toLowerCase() + '.html';
            };

            $scope.getTaggableObject = function() {
                return {
                    type: $scope.objectType.toUpperCase(),
                    projectKey: $scope.object.projectKey,
                    id: $scope.object.id || $scope.object.name,
                    displayName: $scope.object.displayName || $scope.object.name
                }
            };

            $rootScope.$on('toggleActiveRightCol', function(){
                $scope.object.active = !$scope.object.active;
            });

            $scope.toggleActive = function(scenario) {
                var message = scenario.active ? 'Activate ' : 'Deactivate ';
                $rootScope.$emit('toggleActiveList');
                message = message + 'auto-triggers of ' + scenario.projectKey + '.' + (scenario.name || scenario.id);
                DataikuAPI.scenarios.saveNoParams(scenario.projectKey, scenario, {commitMessage:message}).success(function(data){
                    // save the expanded states
                    ActivityIndicator.success("Saved");
                }).error(setErrorInScope.bind($scope));
            };

            $scope.isOnEditableTab = function() {
                return $state.current.name == "projects.project.datasets.dataset.edit"
            }

            $scope.isMetaDataEditable = function () {
                return !$scope.inNavigator() && $stateParams.projectKey;
            };

            $scope.isMetaDataSupported = function(){
                return TAGGABLE_TYPES.includes($scope.objectType.toUpperCase());
            }

            $scope.getAllTagsForProject = function () {
                const deferred = $q.defer();
                deferred.resolve(TaggingService.getProjectTags());
                return getRewrappedPromise(deferred);
            }

            $scope.setUpdatedMetaData = function(update) {
                const o = $scope.object;
                o.tags = update.tags;
                o.shortDesc = update.shortDesc;
                o.description = update.description;
            };

            $scope.$watch("data", function(nv) {
                if (!nv) return;
                enrichData();
                if($scope.object) {
                    $scope.object.isFlowObj = isShownInFlow($scope.objectType.toUpperCase());
                    $scope.isLocalObject = $scope.object.projectKey === ActiveProjectKey.get();
                    $scope.typeBadgeList = $scope.object.typeBadges ? Object.keys($scope.object.typeBadges) : [];
                }
            });

            $scope.isDataStewardEditable = function () {
                // objectAuthorizations is only there after an api call
                return $scope.data.objectAuthorizations && $scope.data.objectAuthorizations.canWriteObject;
            };

            $scope.getEffectiveDataSteward = function() {
                return $scope.data.dataSteward || $scope.data.defaultDataSteward || {displayName: 'None', login: undefined};
            }

            $scope.shouldDisplayVersions = function() {
                return $scope.data.model.savedModelType !== "RETRIEVAL_AUGMENTED_LLM";
            };

            $scope.showEditDataStewardModal = function() {
                const dataset = $scope.getTaggableObject();
                EditDatasetDataStewardModalService.showEditDataStewardModal(
                    $scope, dataset.projectKey, dataset.id, $scope.data.dataSteward, $scope.data.defaultDataSteward,
                    { from: 'dataset-right-panel' }
                ).then((dataSteward) => {
                    $scope.data.dataSteward = dataSteward;
                }).catch(() => {}); // rejects if modal is closed
            };

            $scope.showEditMetadataModal = function () {
                if (!$scope.editable) {
                    return;
                }

                // _SummaryHelper add edit behavior and create a shortDesc obj
                // but we can erase safely the things related to the description
                $scope.state.shortDesc = '';
                $scope.state.description = '';
                $scope.state.writeDescriptionsAsSQLComment = $scope?.data?.dataset?.params?.writeDescriptionsAsSQLComment || false;
                $scope.state.customFields = {};

                CreateModalFromTemplate(
                    "/templates/widgets/edit-metadata-modal.html",
                    $scope,
                    "EditMetadataModalController",
                    undefined,
                    true
                );
            };

            $scope.generateDatasetDescription = function() {
                DataikuAPI.datasets.get($scope.object.projectKey, $scope.object.name, ActiveProjectKey.get()).noSpinner()
                    .success(function(data) {
                        $scope.object = data;
                        CreateModalFromTemplate(
                            "/static/dataiku/ai-dataset-descriptions/generate-documentation-modal/generate-documentation-modal.html",
                            $scope,
                            "AIDatasetDescriptionsModalController"
                        )
                    })
                    .error(setErrorInScope.bind($scope));
            };

            function findAgentConnectUsage(objectData) {
                const fieldsMap = {
                    "TOOLS_USING_AGENT": {modelType: "agent", agentConnectField: "agents_ids"},
                    "RETRIEVAL_AUGMENTED_LLM": {modelType: "retrieval-augmented-llm", agentConnectField: "augmented_llms"},
                };
                const fields = fieldsMap[objectData.model.savedModelType];
                const modelId = fields.modelType + ":" + objectData.model.id;
                function filterWebappUsage(webapp) {
                    return webapp.type === "webapp_agent-connect_portal"
                            && ((webapp.config.llm_id === modelId)
                                || ((webapp.config[fields.agentConnectField] || []).includes(objectData.model.projectKey + ":" + modelId)));
                }
                DataikuAPI.webapps.list(objectData.model.projectKey).success(function(data) {
                    objectData.model.summary.webappsUsage = data.filter(filterWebappUsage);
                }).error(setErrorInScope.bind($scope));
            }

            $scope.$on("objectMetaDataChanged", (event, data) => {
                $scope.object.shortDesc = data.shortDesc;
                $scope.object.description = data.description;
            });

            if ($scope.objectType === 'CODE_STUDIO') {
                $scope.showCurrentUsers = function(users) {
                    const modalScope = $scope.$new();
                    modalScope.usersList = users;
                    modalScope.icon = "icon-cogs";
                    modalScope.title = users.length + ' user' + (users.length===1 ? ' is' : 's are') + ' currently using this Code Studio';
                    CreateModalFromTemplate("/templates/interested-users.html", modalScope);
                };
                $scope.showCurrentWebApps = function(webapps) {
                    const modalScope = $scope.$new();
                    modalScope.webappsList = webapps;
                    modalScope.icon = "icon-cogs";
                    modalScope.title = webapps.length + ' webapp' + (webapps.length===1 ? ' is' : 's are') + ' based on this Code Studio';
                    CreateModalFromTemplate("/templates/webapps-list.html", modalScope);
                };
            }
            $scope.getObjectIcon = function(object) {
                switch(object.type) {
                    case 'SAVED_MODEL':
                        return 'dku-icon-machine-learning-regression-16 saved-model';
                    case 'MANAGED_FOLDER':
                        return 'dku-icon-folder-open-16 managed-folder';
                    case 'MODEL_EVALUATION_STORE':
                        return 'dku-icon-model-evaluation-store-16';
                    case 'RETRIEVABLE_KNOWLEDGE':
                        return 'dku-icon-cards-stack-16 retrievable-knowledge';
                    default:
                        return $filter('toModernIcon')($filter('datasetTypeToIcon')(object.type, 16), 16) + ' dataset';
                }
            };

            $scope.getObjectLink = function(object) {
                switch(object.type) {
                    case 'SAVED_MODEL':
                        return StateUtils.href.savedModel(object.id, object.projectKey);
                    case 'MANAGED_FOLDER':
                        return StateUtils.href.managedFolder(object.id, object.projectKey);
                    case 'MODEL_EVALUATION_STORE':
                        return StateUtils.href.modelEvaluationStore(object.id, object.projectKey);
                    case 'RETRIEVABLE_KNOWLEDGE':
                        return StateUtils.href.retrievableKnowledge(object.id, object.projectKey);
                    default:
                        return StateUtils.href.dataset(object.id);
                }
            };

            $scope.$watchCollection('[objectType, projectKey, objectId]', function(nv, ov) {
                if (!nv[0]) return;
                if (!attrs.hasOwnProperty('objectData') && (!nv[1] || !nv[2])) return;

                if (!attrs.hasOwnProperty('objectData')) {
                    switch ($scope.objectType.toUpperCase()) {
                    case 'CONNECTION':
                        return;

                    case 'DATASET_CONTENT': {
                        let projectKey = $scope.projectKey,
                            name = $scope.objectId;
                        const parts = $scope.objectId.split('.');
                        if (parts.length == 2) {
                            projectKey = parts[0];
                            name = parts[1];
                        }
                        DataikuAPI.datasets.get(projectKey, name, ActiveProjectKey.get()).noSpinner()
                            .success(function(data) {
                                $scope.data = {dataset_content: data}
                            })
                            .error(setErrorInScope.bind($scope));
                        return;
                    }
                    case 'RECIPE':
                        DataikuAPI.flow.recipes.getFullInfo($scope.projectKey, $scope.objectId).noSpinner()
                            .success(function(data) {
                                $scope.data = data;
                            })
                            .error(setErrorInScope.bind($scope));
                        return;

                    case 'MANAGED_FOLDER':
                        DataikuAPI.managedfolder.getWithStatus($scope.projectKey, $scope.objectId).noSpinner()
                            .success(function(data) {
                                $scope.data = {folder: data};
                            })
                            .error(setErrorInScope.bind($scope));
                        return;

                    case 'STREAMING_ENDPOINT':
                        DataikuAPI.streamingEndpoints.getFullInfo($scope.projectKey, $scope.objectId).noSpinner()
                            .success(function(data){
                                $scope.data = data;
                            }).error(setErrorInScope.bind($scope));
                        return;

                    case 'SAVED_MODEL':
                        DataikuAPI.savedmodels.get($scope.projectKey, $scope.objectId).noSpinner()
                            .success(function(data) {
                                $scope.data = {model: data};
                            })
                            .error(setErrorInScope.bind($scope));
                        return;

                    case 'MODEL_EVALUATION_STORE':
                        DataikuAPI.modelevaluationstores.get($scope.projectKey, $scope.objectId).noSpinner()
                            .success(function(data) {
                                $scope.data = {model: data};
                            })
                            .error(setErrorInScope.bind($scope));
                        return;

                    case 'PROMPT_STUDIO':
                        DataikuAPI.promptStudios.getFullInfo($scope.projectKey, $scope.objectId).noSpinner()
                            .success(function(data) {
                                $scope.data = data;
                            })
                            .error(setErrorInScope.bind($scope));
                        return;
                    case 'AGENT_TOOL':
                        DataikuAPI.agentTools.getFullInfo($scope.projectKey, $scope.objectId).noSpinner()
                            .success(function(data) {
                                $scope.data = data;
                            })
                            .error(setErrorInScope.bind($scope));
                        return;
                    case 'RETRIEVABLE_KNOWLEDGE':
                        DataikuAPI.retrievableknowledge.getFullInfo($scope.projectKey, $scope.objectId).noSpinner()
                            .success(function(data) {
                                $scope.data = data;
                            })
                            .error(setErrorInScope.bind($scope));
                        return;

                    case 'LABELING_TASK':
                        DataikuAPI.labelingtasks.get($scope.projectKey, $scope.objectId).noSpinner()
                            .success(function(data) {
                                $scope.data = {labelingTask: data};
                            })
                            .error(setErrorInScope.bind($scope));
                        return;

                    case 'MODEL_COMPARISON':
                        DataikuAPI.modelcomparisons.get($scope.projectKey, $scope.objectId).noSpinner()
                            .success(function(data) {
                                $scope.data = {model: data};
                            })
                            .error(setErrorInScope.bind($scope));
                        return;

                    case 'ANALYSIS':
                        DataikuAPI.analysis.getCore($scope.projectKey, $scope.objectId).noSpinner()
                            .success(function(data) {
                                 $scope.data = {analysis: data};
                            })
                            .error(setErrorInScope.bind($scope));
                        return;

                    case 'SQL_NOTEBOOK':
                        DataikuAPI.sqlNotebooks.get($scope.projectKey, $scope.objectId).noSpinner()
                            .success(function(data) {
                                $scope.data = {notebook: data};
                            })
                            .error(setErrorInScope.bind($scope));
                        return;

                    case 'SEARCH_NOTEBOOK':
                        DataikuAPI.searchNotebooks.get($scope.projectKey, $scope.objectId).noSpinner()
                            .success(function(data) {
                                $scope.data = {notebook: data};
                            })
                            .error(setErrorInScope.bind($scope));
                        return;

                    case 'JUPYTER_NOTEBOOK':
                        DataikuAPI.jupyterNotebooks.getNotebook($scope.projectKey, $scope.objectId, undefined).noSpinner()
                            .success(function(data) {
                                $scope.data = {notebook: data};
                            })
                            .error(setErrorInScope.bind($scope));
                        return;

                    case 'INSIGHT':
                        DataikuAPI.dashboards.insights.get($scope.projectKey, $scope.objectId).noSpinner()
                            .success(function(data) {
                                 $scope.data = {insight: data};
                            })
                            .error(setErrorInScope.bind($scope));
                        return;

                    case 'DASHBOARD':
                        DataikuAPI.dashboards.getFullInfo($scope.projectKey, $scope.objectId).noSpinner()
                          .success(function(data) {
                              $scope.data = data;
                          })
                          .error(setErrorInScope.bind($scope));
                        return;

                    case 'FLOW_ZONE':
                        DataikuAPI.zones.getFullInfo($scope.projectKey, $scope.objectId).noSpinner()
                          .success(function(data) {
                              $scope.data = data;
                          })
                          .error(setErrorInScope.bind($scope));
                        return;

                    case 'CONTINUOUS_ACTIVITY':

                        DataikuAPI.continuousActivities.getState(ActiveProjectKey.get(), $stateParams.continuousActivityId).noSpinner()
                            .success(function(data) {
                                $scope.data = data;
                            }).error(setErrorInScope.bind($scope));
                        return;
                    }
                    logger.error("Unknown type: "+$scope.objectType.toUpperCase());
                }
            });

            function refreshMetadata(o) {
                if (o.metaRefreshed) return;
                DataikuAPI.taggableObjects.getMetadata($scope.getTaggableObject()).success(function(data) {
                    o.description = data.description;
                    o.shortDesc = data.shortDesc;
                    o.tags = data.tags; //mjt suspicious that this was missing....
                    o.metaRefreshed = true;
                });
            }

            function isShownInFlow(objType) {

                switch(objType) {
                    case 'DATASET_CONTENT':
                    case 'RECIPE':
                    case 'DATASET':
                    case 'SAVED_MODEL':
                    case 'MODEL_EVALUATION_STORE':
                    case 'RETRIEVABLE_KNOWLEDGE':
                    case 'MANAGED_FOLDER':
                    case 'STREAMING_ENDPOINT':
                    case 'LABELING_TASK':
                        return true;

                    // 'CONNECTION', 'PROJECT', 'SCENARIO', 'ANALYSIS', 'SQL_NOTEBOOK', 'SEARCH_NOTEBOOK',
                    // 'JUPYTER_NOTEBOOK', 'INSIGHT', 'DASHBOARD', 'WEB_APP', 'REPORT', 'CODE_STUDIO'
                    default:
                        return false;
                }
            }

            const Status = {
                RUN_SUCCESS: 'RUN_SUCCESS',
                RUN_ERROR: 'RUN_ERROR',
                // ajouter d'autres statuts si nécessaire
            };

            function mapSeverity(result) {
                switch (result.status) {
                    case Status.RUN_SUCCESS:
                        return result.severity;
                    default:
                        return 0;
                }
            }

            function enrichData() {
                const objectData = $scope.data;
                const objType = $scope.objectType.toUpperCase()

                switch(objType) {

                case 'CONNECTION':
                    return;
                case 'BUNDLE':
                    if ($scope.data.projectStandardsRunReport) {
                        $scope.object = objectData;
                        objectData.projectStandardsSummary = ProjectStandardsService.getProjectStandardsSummaryFromReport($scope.data.projectStandardsRunReport);
                    }
                    return;
                case 'PROJECT':
                    $scope.object = objectData;
                    return;
                case 'SCENARIO':
                    $scope.object = objectData.object;
                    refreshMetadata(objectData.object);
                    return;
                case 'DATASET_CONTENT':
                    if ($scope.data.dataset_content) {
                        $scope.dataset = $scope.data.dataset_content;
                    }
                    $scope.object = $scope.dataset;
                    return;

                case 'ANALYSIS':
                    if (!objectData.mlTasks) {
                        DataikuAPI.analysis.listMLTasks(objectData.analysis.projectKey, objectData.analysis.id)
                            .success(function (data) {
                                objectData.mlTasks = data;
                            })
                            .error(setErrorInScope.bind($scope));
                    }

                    if (!objectData.timeline) {
                        objectData.timeline = {};
                        if (objectData.analysis.creationTag) {
                            objectData.timeline.createdBy = objectData.analysis.creationTag.lastModifiedBy;
                            objectData.timeline.createdOn = objectData.analysis.creationTag.lastModifiedOn;
                        }
                        if (objectData.analysis.versionTag) {
                            objectData.timeline.lastModifiedBy = objectData.analysis.versionTag.lastModifiedBy;
                            objectData.timeline.lastModifiedOn = objectData.analysis.versionTag.lastModifiedOn;
                        }
                    }
                    $scope.object = objectData.analysis;
                    return;
                case 'RECIPE':
                    RecipesUtils.parseScriptIfNeeded(objectData);
                    //fetchTimeline(objectData.recipe.projectKey, objectData.recipe.name);
                    $scope.object = objectData.recipe;
                    return;
                case 'DATASET':
                    //fetchTimeline(objectData.dataset.projectKey, objectData.dataset.name);
                    $scope.object = objectData.dataset;
                    return;
                case 'STREAMING_ENDPOINT':
                    //fetchTimeline(objectData.streamingEndpoint.projectKey, objectData.streamingEndpoint.id);
                    $scope.object = objectData.streamingEndpoint;
                    return;
                case 'SQL_NOTEBOOK':
                    if (!objectData.notebook) objectData.notebook = objectData.sql_notebook;
                    $scope.object = objectData.notebook;
                    if (!objectData.notebook.niceConnection) {
                        objectData.notebook.niceConnection = NotebooksUtils.parseConnection(objectData.notebook.connection).niceConnection;
                    }
                    refreshMetadata(objectData.notebook);
                    return;
                case 'SEARCH_NOTEBOOK':
                    if (!objectData.notebook) {
                        objectData.notebook = objectData.search_notebook;
                    }
                    $scope.object = objectData.notebook;
                    if (!objectData.notebook.niceConnection && objectData.notebook.connection) {
                        objectData.notebook.niceConnection = objectData.notebook.connection;
                    }
                    refreshMetadata(objectData.notebook);
                    return;
                case 'JUPYTER_NOTEBOOK':
                    if (!objectData.notebook) objectData.notebook = objectData.jupyter_notebook;
                    $scope.object = objectData.notebook;
                    refreshMetadata(objectData.notebook);
                    return;
                case 'INSIGHT':
                    $scope.object = objectData.insight;
                    return;
                case 'DASHBOARD':
                    $scope.object = objectData.dashboard;
                    return;
                case 'WEB_APP':
                    $scope.object = objectData.webapp;
                    return;
                case 'CODE_STUDIO':
                    $scope.object = objectData.codeStudioObject;
                    return;
                case 'REPORT':
                    $scope.object = objectData.report;
                    return;
                case 'LABELING_TASK':
                    $scope.object = objectData.labelingTask;
                    return;
                case 'LAMBDA_SERVICE':
                    $scope.object = objectData.object;
                    $scope.packages = objectData.packages;
                    SavedModelsService.listAPIServiceableModels(objectData.object.projectKey).then(function(serviceableModels) {
                        $scope.savedModels = serviceableModels;
                    });
                    return;
                case 'LAMBDA_PACKAGE':
                    $scope.object = objectData.object;

                    SavedModelsService.listAPIServiceableModels($scope.projectKey).then(function(serviceableModels) {
                        $scope.allSavedModels = serviceableModels;
                    });
                    $scope.typeBadges = objectData.config.typeBadges;
                    return;
                case 'FLOW_ZONE':
                    $scope.object = objectData.zone;
                    return;
                case 'SAVED_MODEL':
                    if (!objectData.model) objectData.model = objectData.saved_model;
                    if (!objectData.status) {
                        switch (objectData.model.miniTask.taskType) {
                            case 'CLUSTERING':
                                DataikuAPI.savedmodels.clustering.getStatus(objectData.model.projectKey, objectData.model.id)
                                    .success(function (data) {
                                        objectData.status = data;
                                    })
                                    .error(setErrorInScope.bind($scope));
                                break;
                            case 'PREDICTION':
                                DataikuAPI.savedmodels.prediction.getStatus(objectData.model.projectKey, objectData.model.id)
                                    .success(function (data) {
                                        objectData.status = data;
                                    })
                                    .error(setErrorInScope.bind($scope));
                                break;
                        }
                    }

                    // Agents display a Summary section
                    if (["TOOLS_USING_AGENT", "PYTHON_AGENT", "PLUGIN_AGENT"].includes(objectData.model.savedModelType)) {
                        objectData.model.summary = {
                            webappsUsage: [],
                            // visual agents specific fields
                            prompt: undefined,
                            llm: undefined,
                            tools: []
                        };

                        if (objectData.model.savedModelType === "TOOLS_USING_AGENT") {
                            const agentVersion = objectData.model.inlineVersions.find(v => v.versionId === objectData.model.activeVersion);
                            if (agentVersion) {
                                objectData.model.summary.prompt = agentVersion.toolsUsingAgentSettings.systemPromptAppend;

                                // find the LLM used by the agent
                                DataikuAPI.pretrainedModels.listAvailableLLMs(objectData.model.projectKey, "GENERIC_COMPLETION").success(function(data) {
                                    objectData.model.summary.llm = data.identifiers.find(llm => llm.id === agentVersion.toolsUsingAgentSettings.llmId);
                                }).error(setErrorInScope.bind($scope));

                                // enrich each tool object with their type, name and more
                                DataikuAPI.agentTools.listAvailable(objectData.model.projectKey).success(function(data) {
                                    objectData.model.summary.tools = agentVersion.toolsUsingAgentSettings.tools.map(tool => {
                                        const projectTool = data.find(t => t.id === tool.toolRef);
                                        if (projectTool) {
                                            Object.assign(tool, projectTool);
                                        }
                                        return tool;
                                    });
                                }).error(setErrorInScope.bind($scope));
                                // find agent connect usage (current project only)
                                findAgentConnectUsage(objectData);
                            }
                        }
                    }
                    // Retrieval Augmented LLMs display a Summary section
                    if (objectData.model.savedModelType === "RETRIEVAL_AUGMENTED_LLM") {
                        const ragllmVersion = objectData.model.inlineVersions.find(v => v.versionId === objectData.model.activeVersion);
                        objectData.model.summary = {
                            version: ragllmVersion,
                            settings: ragllmVersion.ragllmSettings,
                            llm: undefined,
                            kb: undefined,
                            webappsUsage: [],
                        };
                        // find the LLM used by the ra-llm
                        DataikuAPI.pretrainedModels.listAvailableLLMs(objectData.model.projectKey, "GENERIC_COMPLETION").success(function(data) {
                            objectData.model.summary.llm = data.identifiers.find(llm => llm.id === ragllmVersion.ragllmSettings.llmId);
                        }).error(setErrorInScope.bind($scope));
                        // find knowledge bank
                        DataikuAPI.retrievableknowledge.get(objectData.model.projectKey, ragllmVersion.ragllmSettings.kbRef).success(knowledgeBank => {
                            objectData.model.summary.kb = knowledgeBank;
                        }).error(setErrorInScope.bind($scope));
                        // find agent connect usage (current project only)
                        findAgentConnectUsage(objectData);
                    }
                    $scope.object = objectData.model;
                    return;
                case 'MODEL_EVALUATION_STORE':
                    if (!objectData.evaluationStore) objectData.evaluationStore = objectData.model_evaluation_store;
                    $scope.object = objectData.evaluationStore;
                    return;
                case 'MODEL_COMPARISON':
                    $scope.object = objectData.modelComparison;
                    return;
                case 'PROMPT_STUDIO':
                    $scope.object = objectData.promptStudio;
                    return;
                case 'AGENT_TOOL':
                    $scope.object = objectData.agentTool;

                    $scope.object.summary = {
                        usedByAgents: [],
                        usesKnowledgeBank: undefined, // Knowledge Bank Search
                        usesSavedModel: undefined, // Model Predict
                        usesDataset: undefined, // Dataset Append and Dataset Lookup
                    };

                    // find agents that use this tool
                    DataikuAPI.agentTools.getUsage($scope.object.projectKey, $scope.object.id).success(data => {
                        $scope.object.summary.usedByAgents = data.agents.map(agent => {
                            agent.computedIcon = TypeMappingService.mapSavedModelSubtypeToIcon(agent.type, agent.backendType, agent.predictionType, agent.savedModelType, null, 20);
                            return agent;
                        });
                    }).error(setErrorInScope.bind($scope));

                    // load knowledge bank if any
                    if ($scope.object.type === 'VectorStoreSearch' && $scope.object.params.knowledgeBankRef) {
                        DataikuAPI.retrievableknowledge.get($scope.object.projectKey, $scope.object.params.knowledgeBankRef).success(knowledgeBank => {
                            $scope.object.summary.usesKnowledgeBank = knowledgeBank;
                        }).error(setErrorInScope.bind($scope));
                    }

                    // load saved model if any
                    if ($scope.object.type === 'ClassicalPredictionModelPredict' && $scope.object.params.smRef) {
                        DataikuAPI.savedmodels.get($scope.object.projectKey, $scope.object.params.smRef).success(savedModel => {
                            $scope.object.summary.usesSavedModel = savedModel;
                            $scope.object.summary.usesSavedModel.computedIcon = TypeMappingService.mapSavedModelSubtypeToIcon(savedModel.type, savedModel.backendType, savedModel.predictionType, savedModel.savedModelType, null, 20);
                        }).error(setErrorInScope.bind($scope));
                    }

                    // load dataset if any
                    if (($scope.object.type === 'DatasetRowAppend' || $scope.object.type === 'DatasetRowLookup') && $scope.object.params.datasetRef) {
                        const datasetLoc = DatasetUtils.getLocFromSmart($scope.object.projectKey, $scope.object.params.datasetRef);
                        DataikuAPI.datasets.get(datasetLoc.projectKey, datasetLoc.name, $scope.object.projectKey).success(dataset => {
                            $scope.object.summary.usesDataset = dataset;
                        }).error(setErrorInScope.bind($scope));
                    }
                    return;
                case 'RETRIEVABLE_KNOWLEDGE':
                    $scope.object = objectData.retrievableKnowledge;
                    return;
                case 'MANAGED_FOLDER':
                    if (!objectData.folder) objectData.folder = objectData.managed_folder;
                    $scope.object = objectData.folder;
                    if (!objectData.timeline) {
                        objectData.timeline = {};
                        if (objectData.folder.creationTag) {
                            objectData.timeline.createdBy = objectData.folder.creationTag.lastModifiedBy;
                            objectData.timeline.createdOn = objectData.folder.creationTag.lastModifiedOn;
                        }
                        if (objectData.folder.versionTag) {
                            objectData.timeline.lastModifiedBy = objectData.folder.versionTag.lastModifiedBy;
                            objectData.timeline.lastModifiedOn = objectData.folder.versionTag.lastModifiedOn;
                        }
                    }
                    return;
                case "ARTICLE":
                    $scope.object = objectData.article ? objectData.article.data : (objectData.object ? objectData.object : undefined);
                    return
                case 'CONTINUOUS_ACTIVITY':
                    $scope.object = objectData.object;
                    return;
                case 'WORKSPACE':
                    $scope.object = objectData;
                    return;
                }

                logger.error("Unknown type: "+$scope.objectType.toUpperCase());
            }

            function fetchTimeline(projectKey, objectId) {
                if (!$scope.data.timeline) {
                    const objectType = $scope.objectType == 'DATASET_CONTENT' ? 'DATASET' : $scope.objectType.toUpperCase();
                    DataikuAPI.timelines.getForObject(projectKey, objectType, objectId)
                        .success(function(data) {
                            $scope.data.timeline = data;
                        })
                        .error(setErrorInScope.bind($scope));
                }
            }
        }
    };
});


app.directive("rightColumnTab", function(QuickView) {
    return {
        scope: false,
        link: function(scope, element, attrs) {
            function updateActiveTab(tabName = "actions", update = false) {
                scope.uiState = { activeTab: tabName };
                if(scope.setCurrentTab !== undefined){ // old right panel still need to work
                    scope.setCurrentTab(tabName, update);
                }
            }

            attrs.$observe("rightColumnTab", value => {
              updateActiveTab(value);
            });

            Mousetrap.bind('space', function() {
                const nextTab = scope.displayedTabs[((scope.displayedTabs.findIndex(tab => tab.name === scope.currentTab) + 1) % scope.displayedTabs.length)];
                if (nextTab !== undefined) {
                    updateActiveTab(nextTab.name, true);
                }
            });
            scope.$on('$destroy', function() {
                Mousetrap.unbind('space');
                QuickView.hide();
            });
        }
    };
});


app.constant("STANDARDIZED_SIDE_PANEL_KEY", "dss.standardizedSidePanel");

app.service("ActivateOldRightPanel", function($state){
    return {
        isActivated: function(){
            return !["projects.project.analyses.list",
                     "projects.project.datasets.list",
                     "projects.project.streaming-endpoints.list",
                     "projects.project.bundlesdesign.list",
                     "projects.project.lambdaservices.list",
                     "projects.project.lambdaservices.service.packages",
                     "projects.project.recipes.list",
                     "projects.project.labelingtasks.list",
                     "projects.project.notebooks.list",
                     "projects.project.scenarios.list",
                     "projects.project.continuous-activities.list",
                     "projects.project.webapps.list",
                     "projects.project.agenthub.list",
                     "projects.project.code-studios.list",
                     "projects.project.reports.list",
                     "projects.project.dashboards.list",
                     "projects.project.dashboards.insights.list",
                     "projects.project.flow",
                     "projects.project.savedmodels.list",
                     "projects.project.genai.list",
                     "projects.project.modelevaluationstores.list",
                     "projects.project.modelcomparisons.list",
                     "projects.project.promptstudios.list",
                     "projects.project.agenttools.list",
                     "projects.project.datasets.dataset.settings",
                     "projects.project.datasets.new_with_type.settings"].includes($state.current.name);
        }
    }
});

app.directive('standardizedSidePanel', function (LocalStorage, STANDARDIZED_SIDE_PANEL_KEY, $rootScope, QuestionnaireService, $stateParams, translate, $timeout) {
    return {
        restrict: "E",
        scope: true,
        templateUrl: '/templates/standardized-right-panel.html',
        link: function($scope, $element, attrs) {
            let allTabs = [
              {
                name: "actions",
                icon: "dku-icon-plus-circle-fill-24"
              },
              {
                name: "details",
                icon: "dku-icon-info-circle-fill-24"
              },
              {
                name: "preview",
                icon: "dku-icon-eye-circle-fill-24"
              },
              {
                name: "schema",
                icon: "dku-icon-text-bullet-list-circle-24"
              },
              {
                name: "Data Quality",
                icon: "dku-icon-checkmark-circle-fill-24"
              },
              {
                name: "lab",
                icon: "dku-icon-microscope-circle-fill-24"
              },
              {
                name: "timeline",
                icon: "dku-icon-clock-circle-fill-24"
              },
              {
                name: "discussions",
                icon: "dku-icon-comment-circle-fill-24"
              },
              {
                name: "Generate recipe",
                icon: "dku-icon-stars-circle-fill-24"
              }
            ];
            const defaultDatasetTabNames = ["actions", "details", "schema", "Data Quality", "lab", "timeline", "discussions"]

            let objectsToTabsMapping = [
              {
                objectTypes: ["DATASET", "LOCAL_DATASET", "FOREIGN_DATASET"],
                tabNames: !$rootScope.appConfig.prepareAICompletionEnabled  ? defaultDatasetTabNames : [...defaultDatasetTabNames, "Generate recipe"]
              },
              {
                objectTypes: ["RECIPE"],
                tabNames: ["actions", "details", "discussions", "timeline"] // TO DO : add & implement preview tab
              },
              {
                objectTypes: ["ANALYSIS"],
                tabNames: ["actions", "details", "discussions", "timeline"]
              },
              {
                objectTypes: ["SQL_NOTEBOOK"],
                tabNames: ["actions", "details", "discussions", "timeline"]
              },
              {
                objectTypes: ["SEARCH_NOTEBOOK"],
                tabNames: ["actions", "details", "discussions", "timeline"]
              },
              {
                objectTypes: ["JUPYTER_NOTEBOOK"],
                tabNames: ["actions", "details", "discussions"]
              },
              {
                objectTypes: ["SCENARIO"],
                tabNames: ["actions", "details", "discussions", "timeline"]
              },
              {
                objectTypes: ["WEB_APP"],
                tabNames: ["actions", "details", "discussions", "timeline"]
              },
              {
                objectTypes: ["CODE_STUDIO"],
                tabNames: ["actions", "details", "discussions"]
              },
              {
                objectTypes: ["REPORT"],
                tabNames: ["actions", "details", "discussions", "timeline"]
              },
              {
                objectTypes: ["SAVED_MODEL", "LOCAL_SAVEDMODEL", "FOREIGN_SAVEDMODEL"],
                tabNames: ["actions", "details", "discussions", "timeline"]
              },
              {
                objectTypes: ["MODEL_EVALUATION_STORE", "LOCAL_MODELEVALUATIONSTORE", "FOREIGN_MODELEVALUATIONSTORE"],
                tabNames: ["actions", "details", "discussions", "timeline"]
              },
              {
                objectTypes: ["PROMPT_STUDIO", "AGENT_TOOL"],
                tabNames: ["actions", "details", "discussions", "timeline"]
              },
              {
                objectTypes: ["RETRIEVABLE_KNOWLEDGE", "LOCAL_RETRIEVABLE_KNOWLEDGE", "FOREIGN_RETRIEVABLE_KNOWLEDGE"],
                tabNames: ["actions", "details", "discussions", "timeline"]
              },
              {
                objectTypes: ["MODEL_COMPARISON"],
                tabNames: ["actions", "details", "discussions"]
              },
              {
                objectTypes: ["MANAGED_FOLDER", "LOCAL_MANAGED_FOLDER", "FOREIGN_MANAGED_FOLDER"],
                tabNames: ["actions", "details", "discussions", "timeline"]
              },
              {
                objectTypes: ["DASHBOARD"],
                tabNames: ["actions", "details", "discussions", "timeline"]
              },
              {
                objectTypes: ["LABELING_TASK"],
                tabNames: ["actions", "details", "discussions", "timeline"]
              },
              {
                objectTypes: ["INSIGHT"],
                tabNames: ["actions", "details", "discussions", "timeline"]
              },
              {
                objectTypes: ["ZONE"],
                tabNames: ["details", "discussions"]
              },
              {
                objectTypes: ["CONTINUOUS_ACTIVITY"],
                tabNames: ["actions", "details"]
              },
              {
                objectTypes: ["STREAMING_ENDPOINT", "LOCAL_STREAMING_ENDPOINT", "FOREIGN_STREAMING_ENDPOINT"], // the foreign version doesn't exist yet
                tabNames: ["actions", "details", "discussions"]
              },
              {
                objectTypes: ["BUNDLES_DESIGN"],
                tabNames: ["actions", "details"]
              },
              {
                objectTypes: ["PROJECT"],
                tabNames: ["details"]
              },
              {
                objectTypes: ["BUNDLES_DESIGN_MULTI"], // not a taggable object, has own multi
                tabNames: ["actions"]
              },
              {
                objectTypes: ["WORKSPACE"],
                tabNames: ["timeline", "discussions"]
              },
              {
                objectTypes: ["WORKSPACE_DATASET", "WORKSPACE_WEB_APP", "WORKSPACE_ARTICLE", "WORKSPACE_DASHBOARD"],
                tabNames: ["actions", "details", "discussions"]
              },
              {
                objectTypes: ["WORKSPACE_APP"],
                tabNames: ["actions"]
              },
              {
                objectTypes: ["LAMBDA_SERVICE"],
                tabNames: ["actions", "details"]
              },
              {
                objectTypes: ["LAMBDA_PACKAGE"],
                tabNames: ["actions", "details"]
              },
              {
                objectTypes: ["LAMBDA_PACKAGE_MULTI"], // not a taggable object, has own multi
                tabNames: ["actions"]
              },
              {
                objectTypes: ["MULTI"],
                tabNames: ["actions"]
              },
              {
                objectTypes: ["MULTI_DATASETS"],
                tabNames: !$rootScope.appConfig.prepareAICompletionEnabled  ? ["actions"] : ["actions", "Generate recipe"],
              },
              {
                objectTypes: ["MY_ITEM"],
                tabNames: [""]
              },
              {
                objectTypes: [""],
                tabNames: []
              }
            ];
            $scope.standardizedSidePanel.tabToToggle = '';

            function getLatestUsedTab(objectType, tabs) {
                const key = !objectType ? `${STANDARDIZED_SIDE_PANEL_KEY}.tab` : `${STANDARDIZED_SIDE_PANEL_KEY}.${objectType}.tab`;
                const lastTabState = LocalStorage.get(key);
                let lastGeneralTab = undefined;
                if (objectType) {
                    lastGeneralTab = getLatestUsedTab(null, tabs);
                }
                if (lastGeneralTab !== undefined) {
                    return lastGeneralTab;
                }
                if (lastTabState !== undefined && Array.isArray(tabs)) {
                    const found = tabs.map(tab => tab.name).find(tabName => tabName === lastTabState);
                    return found !== undefined || objectType === null ? found : $scope.defaultTab;
                }
                return Array.isArray(tabs) && tabs.length > 0 ? tabs[0].name : $scope.defaultTab;
            }

            function updateLatestUsedTab(objectType, tab) {
                const key = !objectType ? `${STANDARDIZED_SIDE_PANEL_KEY}.tab` : `${STANDARDIZED_SIDE_PANEL_KEY}.${objectType}.tab`;
                LocalStorage.set(key, tab);
                if (objectType) {
                    updateLatestUsedTab(null, tab);
                }
            }

            let panel = document.getElementsByClassName('right-panel')[0];
            $scope.standardizedSidePanel.opened = false;
            $scope.defaultTab = "actions";

            let openPanelOnLoad;
            switch (attrs.page) {
                case 'flow':
                    openPanelOnLoad = !QuestionnaireService.isFromQuestionnaire() ? getLastPanelState(true) : false
                    break;
                case 'objects_list':
                    openPanelOnLoad = true;
                    break;
                case 'home':
                    openPanelOnLoad = getLastPanelState(false);
                    break;
                case 'object':
                default:
                    openPanelOnLoad = false;
            }

            if (attrs.panelClosedTitle) {
                if (attrs.panelClosedTitleTranslate) {
                    $scope.panelClosedTitle = translate(attrs.panelClosedTitleTranslate, attrs.panelClosedTitle);
                } else {
                    $scope.panelClosedTitle = attrs.panelClosedTitle;
                }
            }

            function computeTabsToDisplay() {
                for (let mapping of objectsToTabsMapping) {
                    if (mapping.objectTypes.includes(attrs.objectType)) {
                        $scope.displayedTabs = allTabs
                            .filter(tab => mapping.tabNames.includes(tab.name))
                            .sort((a, b) => mapping.tabNames.indexOf(a.name) - mapping.tabNames.indexOf(b.name));
                        if (mapping.tabNames && mapping.tabNames.length > 0 && !mapping.tabNames.includes($scope.defaultTab)) {
                            $scope.defaultTab = mapping.tabNames[0];
                        }
                        break;
                    }
                }
            }
            computeTabsToDisplay();

            attrs.$observe("closeOnClickOutside", newValue => {
                if (newValue === "true") {
                    // Uses timeout to wait the end of page creation in order to have all elements
                    // otherwise the event listener callback will not be called
                    $timeout(() => {
                        let mainPanes = document.getElementsByClassName("main-panel");
                        if (mainPanes.length > 0) {
                            let mainPane = mainPanes[0];
                            // Possible leak here but the event listener will be cleaned when the main-panel element will be destroyed
                            mainPane.addEventListener("click", event => {
                                if (event && event.target && event.target.id === "qa_generic_actions-dropdown") {
                                    return;
                                }
                                // Uses timeout to apply change in next digest cycle
                                $timeout(() => {
                                    $scope.closePanel();
                                });
                            });
                        }
                    });
                }
            });

            attrs.$observe("page", newValue => {
                computeTabsToDisplay();
                $scope.page = newValue;
            });

            attrs.$observe("objectType", newValue => {
                computeTabsToDisplay();
                $scope.objectType = newValue;
                const mayChooseDiscussionsTab = $stateParams.discussionId && $scope.displayedTabs.find(tab => tab.name == 'discussions');
                const lastUsedTab = (mayChooseDiscussionsTab && 'discussions') || getLatestUsedTab(newValue, $scope.displayedTabs);
                if (lastUsedTab !== $scope.currentTab && newValue !== '') {
                    $scope.currentTab = lastUsedTab;
                    // Here we do not update the latest tab when switching to a project/zone because the user did not actively select the tab
                    // and we don't want it to override the tab for other items when unselecting then re-selecting them (see [sc-208324])
                    if (!["PROJECT", "ZONE"].includes(newValue)) {
                        updateLatestUsedTab(newValue, $scope.currentTab);
                    }
                }
                if (mayChooseDiscussionsTab) {
                    $scope.openPanel();
                }
            });

            attrs.$observe("toggleTab", tabName => {
                if (tabName && tabName != "") {
                    $scope.clickTab(tabName, true);
                }
            });

            attrs.$observe("singleType", newValue => {
                $scope.singleType = newValue;
            });

            $scope.getTooltipText = function (tab) {
                return translate("RIGHT_PANEL.TABS." + tab.name.replace(/\s+/g, "_").toUpperCase(), tab.name.charAt(0).toUpperCase() + tab.name.slice(1));
            }

            $scope.togglePanel = function () {
                if ($scope.isPanelOpened()) {
                    $scope.closePanel();
                } else {
                    $scope.openPanel();
                }
            }

            $scope.openPanel = function(saveState) {
                $scope.changePanelStateIfNeeded(true, saveState);
                if (!angular.isDefined($scope.currentTab) || !$scope.currentTab) {
                    $scope.setCurrentTab($scope.defaultTab, false);
                }
            }

            $scope.closePanel = function(saveState) {
                $scope.changePanelStateIfNeeded(false, saveState);
            }

            $scope.clickTab = function (tabName, forceOpen=false) {
                if ($scope.isPanelOpened() && $scope.isCurrentTab(tabName) && !forceOpen) {
                    $scope.closePanel();
                } else {
                    $scope.setCurrentTab(tabName);
                    $scope.openPanel();
                }
            }

            $scope.setCurrentTab = function (tabName, update = true) {
                $scope.currentTab = tabName;
                if (update === true) {
                    if (tabName === 'actions' && attrs.objectType && attrs.objectType.includes('DATASET') && attrs.objectType !== "MULTI_DATASETS") {
                        $rootScope.$broadcast('rightPanelSummary.triggerFullInfoUpdate');
                    }
                    updateLatestUsedTab($scope.objectType, tabName);
                }
            }

            $scope.getCurrentTab = function() {
                return $scope.currentTab;
            };

            $scope.isCurrentTab = function (tabName) {
                return $scope.currentTab === tabName;
            }

            $scope.isPanelOpened = function () {
                return $scope.standardizedSidePanel.opened;
            }

            $scope.isTabActive = function (tabName) {
                return ($scope.isPanelOpened() && $scope.isCurrentTab(tabName));
            }

            $scope.changePanelStateIfNeeded = function(newState, saveState) {
                let currentState = $scope.isPanelOpened();
                if (currentState != newState) {
                    $scope.standardizedSidePanel.slidePanel();
                    if (saveState !== false) {
                        savePanelState();
                    }
                }
            };

            // Init states
            if (openPanelOnLoad) {
                const saveState = false;
                $scope.openPanel(saveState);
            }

            $scope.$on("standardizedSidePanelContentChanged", function() {
                if (getLastPanelState() === undefined) {
                    const saveState = false;
                    $scope.openPanel(saveState);
                }
            });

            $scope.$watchGroup(
                ["standardizedSidePanel.opened", "displayedTabs.length", "currentTab"],
                ([panelOpened, numDisplayedTabs, currentTab]) => {
                    $scope.$emit("opalsCurrentRightPanelTab", panelOpened && numDisplayedTabs > 0 ? currentTab : null);
                }
            );

            $scope.$on("objectMetaDataChanged", $scope.clickTab.bind($scope, "details", true));

            // Activate transitions only after page load
            // N.B. : If we start using this mecanism in other places in the code it would be better
            // to place the following block in a stateChange event in DataikuController
            let httpRequestsListener = $rootScope.$watch('httpRequests.length', (newVal) => {
                if (newVal !== 0) {
                    return;
                }

                const noTransitionsOnLoadClass = 'no-transitions-on-load';
                let noTransitionsElements = document.getElementsByClassName(noTransitionsOnLoadClass);
                const nbElmts = noTransitionsElements.length;

                for (let i = 0; i < nbElmts; i++) {
                    noTransitionsElements[0].classList.remove(noTransitionsOnLoadClass);
                }

                httpRequestsListener();
            });

            // Refresh fat-repeats of the object list views
            panel.addEventListener('transitionend', (ev) => {
                // To do : add event only if the page contains fat-repeat
                if(ev.target === panel) {// we don't want the panel child elements to trigger this
                    $rootScope.$broadcast("reflow"); // To do : call reflow only on the fat-repeat scope ?
                }
            });

            // Settings using Local Storage
            function getLastPanelState(defaultValue) {
                let key = STANDARDIZED_SIDE_PANEL_KEY + '.' + attrs.page + 'Panel';
                let lastPanelState = LocalStorage.get(key);

                if (lastPanelState != undefined) {
                    return lastPanelState;
                } else {
                    return defaultValue;
                }
            }

            function savePanelState() {
                let key = STANDARDIZED_SIDE_PANEL_KEY + '.' + attrs.page + 'Panel';
                LocalStorage.set(key, $scope.isPanelOpened());
            }

        }
    };
});

app.directive("hideIfNoFilter", function($controller) {
    return {
        restrict : 'A',
        link : function(scope, element, attrs) {

            scope.$watch("noTags", function(nv) {
                let elmts = document.getElementsByClassName('list-page__filter');
                let c = 0;

                for(let i = 0; i < elmts.length; i++) {
                    c += elmts[i].childNodes.length;
                }

                if (c == 0 && nv) {
                    element.addClass('display-none');
                } else {
                    element.removeClass('display-none');
                }
            });

        }
    }
});

app.service('EditDatasetDataStewardModalService', function(DataikuAPI, CreateModalFromTemplate, WT1) {
    function showEditDataStewardModal(parentScope, projectKey, datasetId, currentDataSteward, defaultDataSteward, wt1Context) {
        return CreateModalFromTemplate("/templates/widgets/edit-data-steward-modal.html", parentScope, null, function(modalScope) {
            const getLogin = (dataSteward) => dataSteward ? dataSteward.login : undefined;
            modalScope.datasetId = datasetId;
            modalScope.state = {
                selectedDataSteward: currentDataSteward,
                defaultDataStewardName: defaultDataSteward ? ( defaultDataSteward.displayName || defaultDataSteward.login ) : null,
            }

            DataikuAPI.security.listUsers().success(function(data) {
                modalScope.allUsers = data.sort((a, b) => a.displayName.localeCompare(b.displayName));
                modalScope.allUsersLogin = data.map(user => '@' + user.login);
            }).error(setErrorInScope.bind(modalScope));

            modalScope.removeDataSteward = () => modalScope.state.selectedDataSteward = undefined;
            modalScope.canSave = () => getLogin(modalScope.state.selectedDataSteward) !== getLogin(currentDataSteward);

            modalScope.cancel = function() {
                modalScope.dismiss();
            };

            modalScope.save = function() {
                const dataSteward = modalScope.state.selectedDataSteward; // undefined if removed
                DataikuAPI.datasets.setDataSteward(projectKey, datasetId, getLogin(dataSteward))
                .then(function() {
                    const eventType = dataSteward ? 'set-data-steward' : 'remove-data-steward';
                    WT1.event(eventType, {
                        ...wt1Context,
                        objectType: 'DATASET',
                        objectProjectKeyh: md5(projectKey),
                        objectIdh: md5(datasetId),
                    })
                    modalScope.resolveModal(dataSteward);
                })
                .catch(setErrorInScope.bind(modalScope));
            };

        }, true);
    }

    return {
        showEditDataStewardModal,
    };
})

app.service('ObjectDetailsUtils', function() {
    function inWorkspace(context) {
        return context == 'right-column-workspace';
    }

    function inQuickView(context) {
        return context && context.toLowerCase() === 'quick-view';
    }

    function inNavigator(context) {
        return context && context != 'right-column' && context != 'right-column-workspace' && context != 'feature-store';
    }

    function inFeatureStore(context) {
        return context && context.toLowerCase() === 'feature-store';
    }

    return {
        inWorkspace,
        inQuickView,
        inNavigator,
        inFeatureStore
    }
});

app.service('DatasetDetailsUtils', function(ActiveProjectKey, DataikuAPI, FutureProgressModal, Dialogs, FlowTool) {
    function isLocalDataset(data) {
        return data.dataset.projectKey == ActiveProjectKey.get();
    };

    function isPartitioned(data) {
        return data && isDatasetPartitioned(data.dataset);
    }

    function isDatasetPartitioned(dataset) {
        return dataset
            && dataset.partitioning
            && dataset.partitioning.dimensions
            && dataset.partitioning.dimensions.length > 0;
    }

    function refreshAndGetStatus($scope, datasetData, computeRecords, forceRecompute) {
        DataikuAPI.datasets.getRefreshedSummaryStatus(ActiveProjectKey.get(), datasetData.dataset.name, computeRecords, forceRecompute).success(function(data) {
            FutureProgressModal.show($scope, data, "Refresh dataset status").then(function(result){
                datasetData.status = result;
                if (result) { // undefined in case of abort
                    Dialogs.infoMessagesDisplayOnly($scope, "Computation result", result.messages);
                    FlowTool.refreshFlowStateWhenViewIsActive(['COUNT_OF_RECORDS', 'FILESIZE']);
                    var event = new CustomEvent('datasetStatusRefreshed');
                    document.dispatchEvent(event);
                }
            });
        }).error(error => Dialogs.displaySerializedError($scope, error));
    };

    return {
        isLocalDataset,
        isDatasetPartitioned,
        isPartitioned,
        refreshAndGetStatus
    }
});

app.directive('datasetStatus', function(ObjectDetailsUtils, DatasetDetailsUtils, DatasetUtils, translate) {
    return {
        restrict: 'E',
        templateUrl: '/templates/object-details/dataset_status.html',
        transclude: true,
        scope: {
            objectName: '<',
            checklists: '<',
            data: '<',
            context: '<',
            readOnly: '<'
        },
        link: function(scope) {
            scope.DatasetUtils = DatasetUtils;
            scope.translate = translate;

            scope.inWorkspace = function() {
                return ObjectDetailsUtils.inWorkspace(scope.context);
            };
            scope.inQuickView = function() {
                return ObjectDetailsUtils.inQuickView(scope.context);
            };
            scope.inNavigator = function() {
                return ObjectDetailsUtils.inNavigator(scope.context);
            };
            scope.inFeatureStore = function() {
                return ObjectDetailsUtils.inFeatureStore(scope.context);
            };
            scope.isLocalDataset = function() {
                return DatasetDetailsUtils.isLocalDataset(scope.data);
            };
            scope.isPartitioned = function() {
                return DatasetDetailsUtils.isPartitioned(scope.data);
            };
            scope.refreshAndGetStatus = function(datasetData, computeRecords, forceRecompute) {
                return DatasetDetailsUtils.refreshAndGetStatus(scope, datasetData, computeRecords, forceRecompute);
            };
        }
    }
});

app.controller("EditMetadataModalController", function(
    $q,
    $scope,
    $rootScope,
    $timeout,
    DataikuAPI,
    AIExplanationService,
    TaggingService
) {
    const ctrl = this;

    $scope.cancel = function() {
        $scope.dismiss();
    };

    if (!$scope.object) {
        return;
    }

    if (!$scope.state) {
        $scope.state = {};
    }

    $scope.state.tags = {
        newVal: undefined,
        savedVal: angular.copy($scope.object.tags),
        editing: false,
    };
    $scope.state.shortDesc = angular.copy($scope.object.shortDesc);
    $scope.state.description = angular.copy($scope.object.description);
    $scope.state.customFields = angular.copy($scope.object.customFields);

    $scope.startEditTags = function() {
        $scope.state.tags.newVal = angular.copy($scope.state.tags.savedVal);
        $scope.state.tags.editing = true;
    };
    $scope.cancelEditTags = function() {
        $scope.state.tags.newVal = null;
        $scope.state.tags.editing = false;
    };
    $scope.validateEditTags = function() {
        if ($scope.state.tags.editing) {
            $scope.state.tags.savedVal = $scope.state.tags.newVal;
            $scope.state.tags.editing = false;
        }
    };

    $scope.getAllTagsForProject = function() {
        const deferred = $q.defer();
        deferred.resolve(TaggingService.getProjectTags());
        return getRewrappedPromise(deferred);
    };

    ctrl.$onInit = function() {
        $scope.generateDescriptionButtonTitle = AIExplanationService.getObjectNotExplainableReason($scope.objectType);
        $scope.generateDescriptionButtonDisabled = !!$scope.generateDescriptionButtonTitle;
    };

    $scope.generateDescription = function() {
        $scope.generateDescriptionForObject().then(function(description) {
            $scope.state.description = description;
            // The CodeMirror gets refreshed when the edit-metadata-modal is
            // still in the "perspective-modified" state which messes it up
            // when the modal is brought back to the front by the 500ms
            // animation. Let's refresh it again on focus and also after 750ms.
            $scope.refreshDescriptionOnFocus = true;
            $timeout(function() {
                $scope.descriptionUIRefreshToggle = !$scope.descriptionUIRefreshToggle;
            }, 750);
        });
    };

    $scope.onDescriptionFocus = function(codeMirrorInstance) {
        if ($scope.refreshDescriptionOnFocus) {
            codeMirrorInstance.refresh();
            $scope.refreshDescriptionOnFocus = false;
        }
    };

    $scope.save = function() {
        const ui = $scope.state;

        if ($scope.state.tags.editing) {
            $scope.validateEditTags();
        }

        let apiPromise;
        const update = {
            shortDesc: ui.shortDesc,
            description: ui.description,
            customFields: ui.customFields,
            tags: ui.tags.newVal ? ui.tags.newVal : ui.tags.savedVal,
        };
        if ($scope.objectType === "PROJECT") {
            const projectSummary = angular.copy($scope.object);
            Object.assign(projectSummary, update);
            apiPromise = DataikuAPI.projects.saveSummary($scope.object.projectKey, projectSummary);
        } else {
            apiPromise = DataikuAPI.taggableObjects.setMetaData(
                {
                    type: $scope.objectType.toUpperCase(),
                    projectKey: $scope.object.projectKey,
                    id: $scope.object.id || $scope.object.name,
                },
                update
            ).then(function(resp) {
                $rootScope.$broadcast.bind($rootScope, "objectMetaDataChanged", update)
                $scope.warningMessages = resp?.data?.anyMessage ? resp.data : null;
            })
        }
        apiPromise
            .then(function() {
                $scope.setUpdatedMetaData(update);
                if ($scope.warningMessages === null) {
                    $scope.resolveModal();
                }
            })
            .catch(setErrorInScope.bind($scope));
    };
});

})();

;
(function(){
    'use strict';

    var app = angular.module('dataiku.common.lists', []);

    app.factory('ListFilter', function() {

        function preprocessQuery(queryString) {
            let regex = queryString.match(/^\/(.+)\/$/);
            return regex ? new RegExp(regex[1], 'i') : queryString.toLowerCase().split(/\s+/)
        }

        function scoreTokens(input, tokens) {
            return tokens.reduce((score, token) => score + scoreToken(input, token), 0);
        }

        function scoreToken(input, token) {
            let index = input.indexOf(token);
            if (index < 0) {
                return 0;
            }
            const prevChar = index === 0 ? ' ' : input.charAt(index - 1);
            const nextChar = index + token.length >= input.length ? ' ' : input.charAt(index + token.length);
            return 50 + (prevChar === ' ' ? 20 : 0) + ((nextChar === ' ' || nextChar === '.') ? 20 : 0) + (index === 0 ? 10 : 0);
        }

        function scoreQuery(input, query) {
            if (query instanceof RegExp) {
                return query.test(input.replace(/(<([^>]+)>)/ig, '')) ? 100 : 0;
            } else {
                return scoreTokens(input.replace(/(<([^>]+)>)/ig, '').toLowerCase(), query);
            }
        }

        function computeMatchScore(input, queryString) {
            let query = preprocessQuery(queryString);
            return scoreQuery(input, query);
        }

        function objectMatchesQuery(query, object) {
            for (let key in object) {
                if (typeof object[key] === 'object' ) {
                    if (objectMatchesQuery(query, object[key])) {
                        return true;
                    }
                } else if (query instanceof RegExp) {
                    if (query.test(object[key])) {
                        return true;
                    }
                } else {
                    if (String(object[key]).toLowerCase().replace(/(<([^>]+)>)/ig, '').includes(query.toLowerCase())) {
                        return true;
                    }
                }
            }
            return false;
        }

        function objectMatchesQueryWeighted(query, object, keyProperties) {
            // if no match : score = 0
            // if match on non key property : 0 < score <= 100
            // if match on key property : 100 < score <= 200
            let matchScore = 0;
            for (let key in object) {
                let item = object[key];
                if (typeof item === 'object') {
                    matchScore = Math.max(matchScore, objectMatchesQueryWeighted(query, item, keyProperties));
                } else {
                    let isKeyProperty = keyProperties.includes(key);
                    let tmpScore = scoreQuery(("" + item).toLowerCase(), query);
                    if (tmpScore>0) {
                        if (isKeyProperty) {
                            matchScore = Math.max(matchScore, 100 + tmpScore);
                        } else {
                            matchScore = Math.max(matchScore, tmpScore);
                        }
                    }
                }
            }
            return matchScore;
        }

        function filterList(list, query, keyProperties, isFilterPropertyDisciminant) {
            // query is either A. an ["array", "of", "strings"],
            // or B. a single /regexp/
            const threshold = isFilterPropertyDisciminant ? 100 : 0;
            return keyProperties && keyProperties.length > 0
                   ? filterListWeighted(list, query, keyProperties, threshold)
                   : filterListNonWeighted(list, query)
        }

        function filterListNonWeighted(list, query){
            return Array.isArray(query)
                    ? query.reduce(filterList, list)    // A
                    : list.filter(objectMatchesQuery.bind(null, query));  // B
        }

        function matchingQualityList(list, query, keyProperties) {
            return list.map(object => objectMatchesQueryWeighted(query, object, keyProperties));
        }

        function filterListWeighted(list, query, keyProperties, threshold) {
            let matchQualityList = matchingQualityList(list, query, keyProperties);
            return list.map(function(object, i){
                object.matchQuality = matchQualityList[i];
                return object;
            }).filter(object => object.matchQuality > threshold);
        }

        function sortByMatchingQuality(objectsList) {
            objectsList.sort(function(o1, o2) {
                if (o1.matchQuality && o2.matchQuality) {
                    if (o1.matchQuality < o2.matchQuality) {
                        return 1;
                    } else if (o1.matchQuality > o2.matchQuality) {
                        return -1;
                    } else {
                        return 0;
                    }
                } else if (o1.matchQuality) {
                    return -1;
                } else if (o2.matchQuality) {
                    return 1
                } else {
                    return 0;
                }
            });
        }

        function Pagination(list, perPage) {
            this.list = list;
            this.page = 1;  // /!\ 1-based
            this.perPage = perPage || 100;
            this.update();
        }
        Pagination.prototype.update = function updatePagination() {
            if (!this.list || !this.list.length || this.page <= 0) {
                this.slice = [];
                this.from = this.to = this.size = 0;
                return;
            } else {
                this.size = this.list.length;
            }
            this.maxPage = Math.ceil(this.size / this.perPage);
            this.page = Math.min(this.page, this.maxPage);
            this.from = (this.page - 1) * this.perPage;
            this.to = Math.min(this.list.length, this.from + this.perPage) - 1;
            this.slice = this.list.slice(this.from, this.to + 1);
            // page controls, e.g. when on page 6: [1, null, 4, 5, 6, 7, 8, null, 16]
            this.controls = Array(this.maxPage);
            for(var i = this.controls.length; i > 0; i--) { this.controls[i-1] = i; }
            if (this.maxPage > 10) { // keep 2 before, 2 after, and both ends
                if (this.page > 5) {
                    i = this.controls.splice(1, this.page - 4, null).length - 1;
                } // else i = 0; // already from the loop
                if (this.maxPage - this.page > 4) {
                    this.controls.splice(this.page - i + 2, this.maxPage - this.page - 3, null);
                }
            }
        };
        Pagination.prototype.go = function(p) { switch (p) {
            case 0 : this.page = Math.min(this.maxPage, this.page + 1); break;
            case -1: this.page = Math.max(           1, this.page - 1); break;
            default: this.page = p;
        } };    // NB: doesn't call update, this.page is probably $watch()ed
        Pagination.prototype.next = function() { this.go( 0); };
        Pagination.prototype.prev = function() { this.go(-1); };

        Pagination.prototype.nextPage = function(){
            this.page = Math.min(this.maxPage, this.page + 1);
            return this;
        }
        Pagination.prototype.prevPage = function(){
            this.page = Math.max(1, this.page - 1);
            return this;
        }
        // No bounds check is performed. Pages are 1-indexed
        Pagination.prototype.goToPage = function(page){
            this.page = page;
            return this;
        }

        Pagination.prototype.updateAndGetSlice = function(list){
            this.list = list;
            this.update();
            return this.slice;
        }

        return {
            /**
             * Filters a list (array) of Objects according to a queryString.
             * If queryString looks like a /regex/i, filter will use a regex,
             * otherwise it will use whitespace-separated literal tokens.
             *
             * keyProperties If set, objects that matches on one of the key properties are ranked first
             */
            filter: function filter(list, queryString, keyProperties = [], isFilterPropertyDisciminant = false) {
                queryString = queryString && queryString.trim();
                if (!list) return [];
                if (!queryString) return list.concat();  // no-filter fast-pass
                let query = preprocessQuery(queryString)
                return filterList(list, query, keyProperties, isFilterPropertyDisciminant)
            },
            /**
             * Handles pagination.
             * Invoke with `new`, then set its `page` and call `update()`.
             */
            Pagination: Pagination,
            /**
             * Sorts a list of projects by matchQuality property if the list objects have the property.
             */
            sortByMatchingQuality: sortByMatchingQuality,
            /**
             * computes a matching score between a query and a string input.
             * query can be either a regex or a list of tokens
             * No match : score = 0
             * basic match : score = 50
             * match + there is a space before or after : score = 70
             * match + there is a space before and after : score = 90
             * perfect match : score = 100
             */
            computeMatchScore: computeMatchScore
        };
    });

})();

;
// @ts-check
(function () {
    'use strict';
    angular.module('dataiku.common.datastructures', [])
        .factory('LinkedList', function () {
            /**
             * Linked list node.
             * @template T
             * @class LinkedListNode
             */
            class LinkedListNode {
                /**
                 * Creates an instance of LinkedListNode.
                 * @param {T} element
                 * @memberof LinkedListNode
                 */
                constructor(element) {
                    this.element = element;
                    /** @type {LinkedListNode | undefined} */
                    this.next = undefined;
                    /** @type {LinkedListNode | undefined} */
                    this.prev = undefined;
                }
            }

            /**
             * Linked list data structure to be used to as a queue or a stack.
             * @template T
             * @class LinkedList
             */
            class LinkedList {
                /**
                 * Creates an instance of LinkedList.
                 * @param {T [] | undefined} elements
                 * @memberof LinkedList
                 */
                constructor(elements) {
                    /** @type {LinkedListNode | undefined} */
                    this.head = undefined;
                    /** @type {LinkedListNode | undefined} */
                    this.tail = undefined;
                    /** @type {number} */
                    this.length = 0;

                    if (elements !== undefined) {
                        elements.forEach(element => this.push(element));
                    }
                }

                /**
                 * Removes the last element from the linked list and returns it, with O(1) complexity. 
                 * If the linked list is empty, undefined is returned and the linked list is not modified.
                 * @returns {T} the last element from the linked list
                 * @memberof LinkedList<T>
                 */
                pop() {
                    if (this.tail) {
                        const node = this.tail;
                        if (this.length === 1) {
                            this.head = undefined;
                            this.tail = undefined;
                        } else {
                            this.tail = this.tail.prev;
                            this.tail.next = undefined;
                        }
                        this.length--;
                        return node.element;
                    }
                    return undefined;
                }

                /**
                 * Appends a new element to the end of the linked list, and returns the new length of the linked list, with O(1) complexity.
                 * @param {T} element to append at the end of the linked list.
                 * @returns {number} the new length of the linked list
                 * @memberof LinkedList
                 */
                push(element) {
                    const newTail = new LinkedListNode(element);
                    if (this.head === undefined && this.tail === undefined) {
                        this.head = this.tail = newTail;
                    } else {
                        this.connect(this.tail, newTail);
                        this.tail = newTail;
                    }
                    this.length++;
                    return this.length;
                }

                /**
                 * Removes the first element from the linked list and returns it, with O(1) complexity. 
                 * If the linked list is empty, undefined is returned and the linked list is not modified.. 
                 * @returns {T} the last element from the linked list
                 * @memberof LinkedList
                 */
                shift() {
                    if (this.head) {
                        const node = this.head;
                        if (this.length === 1) {
                            this.head = undefined;
                            this.tail = undefined;
                        } else {
                            this.head = this.head.next;
                            this.head.prev = undefined;
                        }
                        this.length--;
                        return node.element;
                    }
                    return undefined;
                }

                /**
                 * Inserts new elements at the start of the linked list, and returns the new length of the linked list, with O(1) complexity.
                 * @param {T} element to append at the start of the linked list.
                 * @returns {number} the new length of the linked list
                 * @memberof LinkedList
                 */
                unshift(element) {
                    const newHead = new LinkedListNode(element);
                    if (this.head === undefined && this.tail === undefined) {
                        this.head = this.tail = newHead;
                    } else {
                        this.connect(newHead, this.head);
                        this.head = newHead;
                    }
                    this.length++;
                    return this.length;
                }

                /**
                 * Connect two linked list nodes
                 * @param {LinkedListNode} prevEl
                 * @param {LinkedListNode} nextEl
                 */
                connect(prevEl, nextEl) {
                    prevEl.next = nextEl;
                    nextEl.prev = prevEl;
                }
            }
            return LinkedList;

        });
})();

;
(function(){
    'use strict';

    var app = angular.module('dataiku.common.func', []);

    app.factory('Collections', function(Fn) {
        const Collections = {

            indexByField : function indexBy(list, field) {
                const ret = {}
                list.forEach(function(x) {
                    ret[x[field]] = x;
                })
                return ret;
            },

            // copy src into dest without dereference.
            // Use dest = updateNoDereference(dest, src) to avoid NPE
            updateNoDereference: function(dest, src) {
              if ($.isPlainObject(dest)) {
                for (let i in dest) {
                  if (src[i] !== undefined) {
                    dest[i] = Collections.updateNoDereference(dest[i], src[i]);
                  } else if (!i.startsWith("$")) {
                    delete dest[i];
                  }
                }

                for (let i in src) {
                  if (dest[i] === undefined) {
                    dest[i] = src[i];
                  }
                }
                return dest;
              }

              if ($.isArray(dest)) {
                for (let i = dest.length-1; i >= 0; i--) {
                  if (src[i] !== undefined) {
                    dest[i] = Collections.updateNoDereference(dest[i], src[i]);
                  } else {
                    dest.splice(i,1);
                  }
                }

                for (let i in src) {
                  if (dest[i] === undefined) {
                    dest[i] = src[i];
                  }
                }
                return dest;
              }

              return src;
            },
        };

        return Collections;
    });

    app.factory('Fn', function() {

        function compose2(f1, f2) {
            return function() { return f2.call(this, f1.apply(this, arguments)); }
        };

        function cartesianProduct(arr)
        {
            return arr.reduce(function(a,b){
                return a.map(function(x){
                    return b.map(function(y){
                        return x.concat(y);
                    })
                }).reduce(function(a,b){ return a.concat(b) },[])
            }, [[]])
        }

        var Fn = {
            // constant functions & reducers /!\ use directly
            NOOP: function NOOP() {},
            SELF: function SELF(a) { return a; },
            INDEX: function INDEX(_, i) { return i; },  // for array utils
            // eslint-disable-next-line no-console
            LOG: function LOG(a) { /*@console*/ console.log(a); return a; }, // NOSONAR - by design
            DEBUG: function DEBUG(a) { debugger; return a; }, // NOSONAR - by design
            AND: function AND(a, b) { return a && b; },
            OR: function OR(a, b) { return a || b; },
            SUM: function SUM(a, b) { return a + b; },  // also works as string joiner
            MUL: function MUL(a, b) { return a * b; },
            MAX: function MAX(a, b) { return Math.max(a,b); },
            MIN: function MIN(a, b) { return Math.min(a,b); },
            CMP: function(a, b) { return a.valueOf() < b.valueOf() ? -1 : (a.valueOf() > b.valueOf() ? 1 : 0) },

            // composers
            not: function not(f) { return function() { return !f.apply(this, arguments); } },
            compose: function compose(f1) { return Array.prototype.slice.call(arguments, 1).reduce(compose2, f1); },
            args: function fnArgs(args, f) { return function() {
                for (var i in args) { if (typeof args[i] !== 'undefined') arguments[i] = args[i]; }
                return f.apply(this, arguments);
            }; },

            // arrays
            // cartesian product
            product: function() {
              return cartesianProduct(arguments);
            },
            // cartesian power
            pow: function(arr, p) {
              var res = [];
              for (var i=0;i<p;i+=1) {
                res.push(arr);
              }
              return cartesianProduct(res);
            },

            /* When this function is called with N arguments, it calls f with only the first argument */
            passFirstArg : function passFirstArg(f) {
                return function() {
                    return f(arguments[0]);
                }
            },

            // ready-made functors
            cst: function cst(a) { return function() { return a; }; },
            eq: function eq(to) { return function(o) { return to === o; }; },
            like: function like(to) { return function(o) { return to == o; }; },
            ofType: function ofType(t) { return function(o) { return typeof o === t; }; },
            unique: function unique() {
                var a = [], t = Fn.inArray(a);
                return function(o) { return !t(o) && a.push(o) && true; };
            },
            inArray: function inArray(arr) { return function(o) { return arr.indexOf(o) !== -1; } },
            regexp: function regexp(re) { return re.test.bind(re); },

            // extractors

            /**
             * Extracts a property from current element, optionally using deep access
             * @param name: the property to extract, or an array for deep access
             *  Fn.prop("a")(x) -> returns x["a"]
             *  Fn.prop(["a", "b"])(x) -> returns x["a"]["b"]
             *  Fn.prop([])(x) -> returns x
             */
            prop: function prop(name) {
                if (!Array.isArray(name))   { return (function(o) { return o[name]}); }
                else if (name.length === 0) { return Fn.SELF; }
                else                        { return Fn.compose.apply(null, name.map(Fn.prop)); }
            },
            /**
             * Extracts a property from current element using string-based deep access
             * @param name: a dotted expression denoting the property to extract
             *  Fn.propStr("a")(x) -> returns x["a"]
             *  Fn.propStr("a.b")(x) -> returns x["a"]["b"]
             *  Fn.propStr("")(x) -> returns x
             */
            propStr: function propStr(name) {
                if (name == null || name.length == 0) return Fn.prop([])
                return Fn.prop(name.split("."))
            },

            // setters
            /**
             * Sets a property from current element, optionally using deep access
             * @param name: the property to extract, or an array for deep access
             *  Fn.setProp(e, "a")(x) -> set x["a"] = e , returns x["a"]
             *  Fn.setProp(e, ["a", "b"])(x) -> sets x["a"]["b"] = e , returns x["a"]["b"]
             *  Fn.setProp(e, [])(x) -> return e , does nothing to x (you should use x = e)
             */
            setProp: function setProp(value, name) {
                if (!Array.isArray(name))   { return (function(o) { if(!o) return o ; o[name] = value ; return o[name] }); }
                else if (name.length === 0) { return (function(o) { return value; }); }
                else                        { return compose2.call(null,
                    Fn.compose.apply(null, name.slice(0,name.length-1).map(Fn.propSafe)) || Fn.SELF ,
                    Fn.setProp.call(null, value, name[name.length-1])
                ); }
            },
            propSafe: function propSafe(name) {
                if (!Array.isArray(name))   { return (function(o) { if(!o[name]) { o[name] = {} } ; return o[name] }); }
                else if (name.length === 0) { return Fn.SELF; }
                else                        { return Fn.compose.apply(null, name.map(Fn.propSafe)); }
            },
            propStrSafe: function propStr(name) {
                if (name == null || name.length == 0) return Fn.propSafe([])
                return Fn.propSafe(name.split("."))
            },
            /**
             * Sets a property from current element using string-based deep access
             * @param name: a dotted expression denoting the property to extract
             *  Fn.setPropStr(e, "a")(x) -> sets x["a"] = e
             *  Fn.setPropStr(e, "a.b")(x) -> sets x["a"]["b"] = e
             *  Fn.setPropStr(e, "")(x) -> return e , does nothing to x (you should use x = e)
             */
            setPropStr: function setPropStr(value, name) {
                if (name == null || name.length == 0) return Fn.setProp(value, [])
                return Fn.setProp(value, name.split("."))
            },


            /** Calls the identified method on the current element (cur.method())
              * @param m: function to call with the current element as @this
              *    or name of the method on the element (NOOP when does not exist).
              * @param args: additional arguments for the call (optional)
              */
            method: function method(m, args) { return function(o) {
                return (typeof m === 'function' ? m : (o[m] || Fn.NOOP)).apply(o, args || []);
            }; },
            assign: function assign(name, f) { return function(o) { o[name] = f.apply(this, arguments); return o; }; },
            from: function from(o, i) { i = i || 0; return (function() { return this[arguments[i]]; }).bind(o); },
            dict: function dict(o, def) { return function(a) {
                return a in o ? o[a] : typeof def ==='function' ? def(a) : def; }; 
            },

            // misc

            /**
             * Returns a function F that executes {@param fn} when F is called with a non-null
             * first argument
             */
            doIfNv : function doIf(fn) {
                return (function(nv) { if (nv !== null && nv !== undefined) fn(); });
            },

            getCustomTimeFormat() {
                var customTimeFormat = d3.time.format.multi([
                    [".%L", function(d) { return d.getMilliseconds(); }],
                    [":%S", function(d) { return d.getSeconds(); }],
                    ["%H:%M", function(d) { return d.getMinutes(); }],
                    ["%H:00", function(d) { return d.getHours(); }],
                    ["%a %d", function(d) { return d.getDay() && d.getDate() != 1; }],
                    ["%b %d", function(d) { return d.getDate() != 1; }],
                    ["%B", function(d) { return d.getMonth(); }],
                    ["%Y", function() { return true; }]
                ]);
                return customTimeFormat;
            }
        };

        Fn.neq = compose2(Fn.eq, Fn.not);

        return angular.extend(Fn.compose, Fn);
    });
})();


;
(function(){
'use strict';
/**
 * Services for building computables
 */

var app = angular.module('dataiku.common.build', []);

app.service('PartitionSelection', ['LocalStorage', '$stateParams', 'Logger', function(LocalStorage, $stateParams, Logger) {
    