(function() {
    'use strict';

    const app = angular.module('dataiku.ml.report');

    app.component('globalExplanationsNavtool', {
        templateUrl: '/templates/ml/prediction-model/feature-importance/global_explanations_navtool.html',
        bindings: { showPartialDependencePlot: '<' },
        controller: function() {
            const $ctrl = this;

            $ctrl.scrollToGraph = function(selectedGraph) {
                if (!selectedGraph) { return }
                const selectedGraphDOM = document.getElementById(selectedGraph);
                if (selectedGraphDOM) {
                    selectedGraphDOM.scrollIntoView({ behavior: 'smooth' });
                }
            };
        }
    });

    app.component('featureFacts', {
        templateUrl: '/templates/ml/prediction-model/feature-importance/facts/feature_facts.html',
        bindings: { featureFacts: '<', selectedClass: '<', selectedColumn: '<'},
        controller: function($filter) {
            const $ctrl = this;
            $ctrl.facts = [];

            $ctrl.buildFactNumericInfo = (fact) => {
                let tooltipText = `Feature impact: ${$filter("nicePrecision")(fact.impact, 2)}.`;
                if (fact.type === "CATEGORICAL") {
                    tooltipText += ` Information gain: ${$filter("nicePrecision")(fact.infoGain, 2)}`;
                } else {
                    tooltipText += ` Correlation: ${$filter("nicePrecision")(fact.correlation, 2)}`;
                }
                return tooltipText
            }

            function buildTopFacts(perClassFacts) {
                const topFacts = {};
                Object.keys(perClassFacts).map((klass) => {
                    topFacts[klass] = Object.entries(perClassFacts[klass]).map(f => f[1]).sort((factA, factB) => factA.rank - factB.rank).slice(0, 3);
                });
                return topFacts
            }

            function selectFacts() {
                if (!$ctrl.featureFacts) return;
                if (!$ctrl.selectedColumn) { // We want a top k
                    $ctrl.topFacts = buildTopFacts($ctrl.featureFacts);
                    $ctrl.facts = $ctrl.topFacts[$ctrl.selectedClass];
                } else {
                    $ctrl.facts = ($ctrl.featureFacts[$ctrl.selectedClass][$ctrl.selectedColumn] && [$ctrl.featureFacts[$ctrl.selectedClass][$ctrl.selectedColumn]]) || [];
                }
            }

            $ctrl.onInit = function() {
                selectFacts();
            }

            $ctrl.$onChanges = function() {
                selectFacts();
            }
        }
    });
})();
