(function() {
    'use strict';

    const app = angular.module('dataiku.directives.simple_report');

    /**
     * Service responsible for retrieving appropriate icon for a given chart type and DSS location.
     * (!) This service previously was in static/dataiku/js/simple_report/chart_type_picker.js
     */
    app.factory('ChartIconUtils', function(WebAppsService) {
        const ret = {
            computeChartIcon: function(type, variant, isInAnalysis, webAppType) {
                if (!ret.typeAndVariantToImageMap) {
                    return '';
                }
                if (typeof (type) !== 'undefined') {
                    if (type == 'webapp') {
                        const loadedDesc = WebAppsService.getWebAppLoadedDesc(webAppType) || {};
                        return loadedDesc && loadedDesc.desc && loadedDesc.desc.meta && loadedDesc.desc.meta.icon ? loadedDesc.desc.meta.icon : 'icon-puzzle-piece';
                    }
                    let imageName = 'basic_graphs';
                    if (typeof (variant) === 'undefined') {
                        variant = 'normal';
                    }
                    if (typeof (ret.typeAndVariantToImageMap[type]) !== 'undefined'
                        && typeof (ret.typeAndVariantToImageMap[type][variant]) !== 'undefined'
                        && typeof (ret.typeAndVariantToImageMap[type][variant]).icon !== 'undefined') {
                        imageName = ret.typeAndVariantToImageMap[type][variant].icon;
                    }
                    let uri = '/static/dataiku/images/charts/icons/';
                    if (isInAnalysis) {
                        uri += 'Chart_Icon_Analysis_';
                    } else {
                        uri += 'Chart_Icon_Dataset_';
                    }
                    return uri + imageName + '.svg';
                }
            },

            computeScatterLegendIcon(type) {
                return `/static/dataiku/images/charts/icons/scatter-legend/symbol_${type}.svg`;
            },

            typeAndVariantToImageMap: {
                'grouped_columns': {
                    'normal': {
                        'icon': 'vertical_bars',
                        'preview': 'grouped_columns'
                    }
                },
                'stacked_bars': {
                    'normal': {
                        'icon': 'horizontal_stacked_bars',
                        'preview': 'bar_graph'
                    },
                    'stacked_100': {
                        'icon': 'bar_stacked_100',
                        'preview': 'bar_graph'
                    }
                },
                'stacked_columns': {
                    'normal': {
                        'icon': 'stacked_color',
                        'preview': 'stacked_columns'
                    },
                    'stacked_100': {
                        'icon': 'stacked_100',
                        'preview': 'stacked_columns'
                    }
                },
                'multi_columns_lines': {
                    'normal': {
                        'icon': 'column__lines',
                        'preview': 'column__lines'
                    }
                },
                'lines': {
                    'normal': {
                        'icon': 'lines',
                        'preview': 'lines'
                    }
                },
                'stacked_area': {
                    'normal': {
                        'icon': 'stacked_areas',
                        'preview': 'stacked_areas'
                    },
                    'stacked_100': {
                        'icon': 'stacked_areas_100',
                        'preview': 'stacked_areas_100'
                    }
                },
                'pivot_table': {
                    'normal': {
                        'icon': 'table',
                        'preview': 'table'
                    }
                },
                'scatter': {
                    'normal': {
                        'icon': 'scatter',
                        'preview': 'scatter'
                    }
                },
                'scatter_multiple_pairs': {
                    'normal': {
                        'icon': 'scatter_multiple_pairs',
                        'preview': 'scatter_multiple_pairs'
                    }
                },
                'grouped_xy': {
                    'normal': {
                        'icon': 'grouped_scatter',
                        'preview': 'grouped_scatter'
                    }
                },
                'binned_xy': {
                    'normal': {
                        'icon': 'bubble',
                        'preview': 'bubble'
                    },
                    'binned_xy_rect': {
                        'icon': 'rectangles',
                        'preview': 'rectangles'
                    },
                    'binned_xy_hex': {
                        'icon': 'hexagons',
                        'preview': 'hexagons'
                    }
                },
                'density_2d': {
                    'normal': {
                        'icon': 'heatmap',
                        'preview': 'heatmap'
                    }
                },
                'kpi': {
                    'normal': {
                        'icon': 'kpi',
                        'preview': 'kpi'
                    }
                },
                'radar': {
                    'normal': {
                        'icon': 'radar_web',
                        'preview': 'radar_web'
                    }
                },
                'gauge': {
                    'normal': {
                        'icon': 'gauge',
                        'preview': 'gauge'
                    }
                },
                'sankey': {
                    'normal': {
                        'icon': 'sankey',
                        'preview': 'sankey'
                    }
                },
                'scatter_map': {
                    'normal': {
                        'icon': 'scatter_map',
                        'preview': 'scatter_map'
                    }
                },
                'density_heat_map': {
                    'normal': {
                        'icon': 'density_heat_map',
                        'preview': 'density_heat_map'
                    }
                },
                'geom_map': {
                    'normal': {
                        'icon': 'geom_map',
                        'preview': 'geom_map'
                    }
                },
                'admin_map': {
                    'normal': {
                        'icon': 'administrative_map',
                        'preview': 'administrative_map'
                    },
                    'filled_map': {
                        'icon': 'administrative_map',
                        'preview': 'administrative_map'
                    }
                },
                'grid_map': {
                    'normal': {
                        'icon': 'grid_map',
                        'preview': 'grid_map'
                    }
                },
                'treemap': {
                    'normal': {
                        'icon': 'tree_map',
                        'preview': 'tree_map'
                    }
                },
                'boxplots': {
                    'normal': {
                        'icon': 'box_plot',
                        'preview': 'box_plot'
                    }
                },
                'pie': {
                    'normal': {
                        'icon': 'pie',
                        'preview': 'pie'
                    },
                    'donut': {
                        'icon': 'donut',
                        'preview': 'donut'
                    }
                },
                'lift': {
                    'normal': {
                        'icon': 'diminishing_return_charts',
                        'preview': 'diminishing-reduction'
                    }
                }
            }
        };

        return ret;
    });

})();
