(function(){
    "use strict";

    const searchNotebookInitModalIndexPattern = {
        bindings : {
            indexPatternScope: "<",
            connection: "<",
            cell: "<"
        },
        require: {
            apiErrorContext: "^apiErrorContext"
        },
        templateUrl: "/static/dataiku/search-notebooks/search-notebook-init-modal-index-pattern/search-notebook-init-modal-index-pattern.component.html",
        controller: function($scope, DataikuAPI, $stateParams) {
            const $ctrl = this;

            $ctrl.$onInit = () => {
                if ($ctrl.cell) {
                    if ($ctrl.cell.searchScope.scope === "INDEX_PATTERN") {
                        $ctrl.indexPatternScope.pattern = $ctrl.cell.searchScope.indexPattern;
                    }
                }
            };

            $ctrl.loadIndicesFromPattern = () => {
                const dataset = {
                    name: "fakeDataset",
                    type: "ElasticSearch",
                    params: {
                        connection: $ctrl.connection,
                        index: $ctrl.indexPatternScope.pattern
                    }
                };
                DataikuAPI.datasets.elasticsearch.listIndices($stateParams.projectKey, dataset)
                    .then(function({data}) {
                        const foundIndices = [];
                        for (const [name, count] of Object.entries(data)) {
                            foundIndices.push({name, count});
                        }
                        $ctrl.indexPatternScope.indices = foundIndices;
                    }).catch($ctrl.apiErrorContext.setError);
            };
        }
    }

    angular.module("dataiku.searchNotebooks").component("searchNotebookInitModalIndexPattern", searchNotebookInitModalIndexPattern);
})();