(function() {
    'use strict';

    angular.module('dataiku.shared').component('pivotFilterNumericalFacet', {
        bindings: {
            filterTmpData: '<', // FilterTmpData
            facetUiState: '<', // FacetUiState
            filterTmpDataChange: '&', // ({ $filterTmpData }) => void
        },
        templateUrl: '/static/dataiku/shared/components/pivot-filter-numerical-facet/pivot-filter-numerical-facet.component.html',
        controller: function($timeout) {
            const ctrl = this;

            ctrl.slideEnd = function() {
                $timeout(function() {
                    if (!ctrl.filterTmpData || !ctrl.facetUiState) {
                        return;
                    } // when a filter is added, you have to wait for the response from the backend before filterTmpData is here
                    const minValue = ctrl.facetUiState.sliderModelMin;
                    // The range-filter library directive does not handle well wrong values especially when max < min. Part of its know issues
                    // https://github.com/danielcrisp/angular-rangeslider#to-do
                    const maxValue = ctrl.facetUiState.sliderModelMax < minValue ? minValue : ctrl.facetUiState.sliderModelMax;
                    ctrl.filterTmpDataChange({ $filterTmpData: { ...ctrl.filterTmpData, minValue, maxValue } });
                });
            };
        }
    });
})();
