/* global describe, it, inject, expect, module, beforeEach */

describe('ChartRequestComputer', function () {
    let ChartRequestComputer;

    function mockDependencies($provide) {
        $provide.value('BinnedXYUtils', {});
        $provide.value('ChartColorUtils', {});
        $provide.value('ChartAxesUtils', {});
        $provide.value('ReferenceLines', {});
        $provide.value('ColumnAvailability', {});
        $provide.value('LoggerProvider', {
            getLogger: () => ({
                info: () => { 
                    // For mocking purpose 
                },
                error: () => { 
                    // For mocking purpose 
                }
            })
        });
        $provide.value('_GeometryCommon', {});
        $provide.value('ChartAxesUtils', {});
        $provide.value('ChartFeatures', {});
    }
    
    beforeEach(() => {
        module('dataiku.charts');
        module('dataiku.mock', mockDependencies);
    });

    beforeEach(inject((_ChartRequestComputer_) => {
        ChartRequestComputer = _ChartRequestComputer_;
    }));

    describe('addFilters', () => {
        let request, chartDef, alphanumFilter, datePartFilter;

        beforeEach(() => {
            request = { type: 'TYPE' };
            chartDef = { 
                filters: [],
             };
            alphanumFilter = {
                active: true,
                column: 'TOTO',
                columnType: 'ALPHANUM',
                excludedValues: {},
                selectedValues: {},
                filterType: 'ALPHANUM_FACET',
                minValue: null,
                maxValue: null
            };

            datePartFilter = {
                active: true,
                column: 'TOTO',
                columnType: 'DATE',
                excludedValues: { 2019: true, 2018: true },
                selectedValues: { 2017: true, 2016: true },
                filterType: 'DATE_FACET',
                dateFilterType: 'YEAR',
                minValue: null,
                maxValue: null
            }
        });

        it('should work if no filter', () => {
            ChartRequestComputer.addFilters(request, chartDef);
            expect(request.filters).toBeDefined();
            expect(request.filters.length).toBe(0);
        });

        describe('for alphanumerical filters', () => {
            beforeEach(() => {
                chartDef.filters = [alphanumFilter];
            });

            it('should convert the correct list of values for charts', () => {
                request.type = 'NOT_FILTERS';

                let filters = angular.copy(chartDef.filters);

                filters[0].isAGlobalFilter = false;
                filters[0].excludeOtherValues = false;
                delete filters[0].selectedValues;

                ChartRequestComputer.addFilters(request, {...chartDef, filters});
                expect(request.filters[0].excludedValues).toBeDefined();
                expect(request.filters[0].selectedValues).toBeUndefined();

                request.filters = [];

                filters = angular.copy(chartDef.filters);
                filters[0].excludeOtherValues = true;
                delete filters[0].excludedValues;

                ChartRequestComputer.addFilters(request, {...chartDef, filters});
                expect(request.filters[0].excludedValues).toBeUndefined();
                expect(request.filters[0].selectedValues).toBeDefined();
            });

            it('should convert the correct list of values', () => {
                request.type = 'FILTERS';
                let filters = angular.copy(chartDef.filters)

                filters[0].excludeOtherValues = false;
                delete filters[0].selectedValues
                ChartRequestComputer.addFilters(request, {...chartDef, filters});
                expect(request.filters[0].excludedValues).toBeDefined();
                expect(request.filters[0].selectedValues).toBeUndefined();

                filters = angular.copy(chartDef.filters)

                filters[0].excludeOtherValues = true;
                delete filters[0].excludedValues
                request.filters = [];
                ChartRequestComputer.addFilters(request, {...chartDef, filters});
                expect(request.filters[0].excludedValues).toBeUndefined();
                expect(request.filters[0].selectedValues).toBeDefined();
            });
        });

        describe('for date part filters', () => {
            beforeEach(() => {
                chartDef.filters = [datePartFilter];
            });

            it('should convert the correct list of values', () => {
                let filters = angular.copy(chartDef.filters);
                request.type = 'NOT_FILTERS';

                filters[0].excludeOtherValues = false;
                delete filters[0].selectedValues;
                ChartRequestComputer.addFilters(request, {...chartDef, filters});
                expect(request.filters[0].excludedValues).toBeDefined();
                expect(request.filters[0].selectedValues).toBeUndefined();

                request.filters = [];
                filters = angular.copy(chartDef.filters);
                filters[0].excludeOtherValues = true;
                delete filters[0].excludedValues;
                ChartRequestComputer.addFilters(request, {...chartDef, filters});
                expect(request.filters[0].excludedValues).toBeUndefined();
                expect(request.filters[0].selectedValues).toBeDefined();
            });
        });
    });

});
