
class SingleOverrideMetrics(object):
    def __init__(self, name, nb_matching_rows, nb_changed_rows):
        self.name = name
        self.nb_matching_rows = nb_matching_rows
        self.nb_changed_rows = nb_changed_rows

    def to_dict(self):
        """
        :rtype: dict
        """
        return {
            "name": self.name,
            "nbMatchingRows": int(self.nb_matching_rows),
            "nbChangedRows": int(self.nb_changed_rows)
        }


class OverridesMetrics(object):

    def __init__(self):
        self.per_override = []

    def to_dict(self):
        """
        :rtype: dict
        """
        return {
            "perOverride": [c.to_dict() for c in self.per_override]
        }

    @staticmethod
    def from_metrics_df(overrides_names, metrics_df):
        """
        Builds Override metrics from a metrics DataFrame that has "nb_matching" and "nb_changed" columns and looks like:
                                nb_matching  nb_changed
                    Override1            20           5
                    Override2            10           9

        :type overrides_names: list[str]
        :type metrics_df: pd.DataFrame
        :rtype: OverridesMetrics
        """
        metrics = OverridesMetrics()
        for override_name in overrides_names:
            matching_rows = 0
            changed_rows = 0
            if override_name in metrics_df.index:
                matching_rows = metrics_df.loc[override_name, "nb_matching"]
                changed_rows = metrics_df.loc[override_name, "nb_changed"]
            metrics.per_override.append(SingleOverrideMetrics(override_name, matching_rows, changed_rows))
        return metrics
