from dataiku.eda.types import Literal

import numpy as np

from dataiku.eda.computations.computation import UnivariateComputation
from dataiku.eda.computations.context import Context
from dataiku.eda.computations.immutable_data_frame import ImmutableDataFrame
from dataiku.eda.exceptions import NoDataError
from dataiku.eda.types import MinModel, MinResultModel


class Min(UnivariateComputation):
    @staticmethod
    def get_type() -> Literal["min"]:
        return "min"

    @staticmethod
    def build(params: MinModel) -> 'Min':
        return Min(params['column'])

    def apply(self, idf: ImmutableDataFrame, ctx: Context) -> MinResultModel:
        series = idf.float_col_no_missing(self.column)

        if len(series) == 0:
            raise NoDataError()

        return {"type": Min.get_type(), "value": np.min(series)}
