import asyncio

from dataiku.llm.python import BaseLLM


class MyLLM(BaseLLM):
    async def aprocess_stream(self, query, settings, trace):
        prompt = query["messages"][-1]["content"]

        await asyncio.sleep(1)
        yield {
            "chunk": {
                "text" : "Hello, I'm an asynchronous agent with streaming support\n"
            }
        }
        await asyncio.sleep(1)
        yield {
            "chunk": {
                "text" : "You asked me: %s\n" % prompt
            }
        }
        await asyncio.sleep(1)
        yield {
            "chunk": {
                "text" : "I should think about how to respond\n"
            }
        }
