import os
from pprint import pprint
import mlflow

path_to_export = os.path.dirname(os.path.realpath(__file__))

# Load the model from current export path
mlflow_model = mlflow.pyfunc.load_model(path_to_export)

# MLflow provides a model.predict method to get scoring for a given input data.
#
# MLflow does not provide a model.predict_proba method to get probabilities in case of classification.
# If you want to get probabilities, use the regular Python export instead, or load the model with
# the load_model method from dataikuscoring.
#
# The accepted format for input data can be either:
# * pandas.DataFrame
# * List of dictionnaries
# * 2D numpy array
# * List of List
#
# The first dimension corresponds to observations
data_to_score = SAMPLE_DATA


# For instance the following will output a numpy array containing the predictions for each
# observation

predict_result = mlflow_model.predict(data_to_score)
print(" \nOutput of model.predict():\n")
pprint(predict_result)

