#!/bin/bash -e

# Returns the list of compliant ecdh curves supported on this OS
# and passing our whitelist
#
# Can be humanly determined with command:
# openssl ecparam -list_curves

MYDIR=$(cd "$(dirname "$0")" && pwd -P)
SECP_CURVES="prime256v1:secp384r1:secp521r1"
BRAINPOOL_CURVES="brainpoolP256r1:brainpoolP384r1:brainpoolP512r1"

detectedDistrib=$("$MYDIR"/_find-distrib.sh 2>/dev/null || echo "unknown unknown")
read distrib distribVersion <<< "$detectedDistrib"

case "$distrib" in
    debian)
        case "$distribVersion" in
            11*) echo "$SECP_CURVES:$BRAINPOOL_CURVES"; exit;;
            12*) echo "$SECP_CURVES:$BRAINPOOL_CURVES"; exit;;
        esac;;
    ubuntu)
        case "$distribVersion" in
            "20.04") echo "$SECP_CURVES:$BRAINPOOL_CURVES"; exit;;
            "22.04") echo "$SECP_CURVES:$BRAINPOOL_CURVES"; exit;;
        esac;;
    centos | redhat | oraclelinux | almalinux | rocky)
        case "$distribVersion" in
            8*) echo "$SECP_CURVES"; exit;;
            9*) echo "$SECP_CURVES:$BRAINPOOL_CURVES"; exit;;
        esac;;
    amazonlinux)
        case "$distribVersion" in
            2) echo "$SECP_CURVES"; exit;;
            2023) echo "$SECP_CURVES:$BRAINPOOL_CURVES"; exit;;
        esac;;
    suse)
        case "$distribVersion" in
            15*) echo "$SECP_CURVES:$BRAINPOOL_CURVES"; exit;;
        esac;;
    osx)
        echo "$SECP_CURVES:$BRAINPOOL_CURVES"; exit;;
esac
echo "$SECP_CURVES"
