
$me=(Split-Path -Path $PSCommandPath -Leaf) # Get script name
$BINDIR=$env:BINDIR

$env:DIP_HOME = Split-Path -Path $BINDIR -Parent

function Usage() {
	Write-Host @"
Usage: $me ACTION [ARGUMENT ...]
Actions:
	install-R-integration [-noDeps] [-repo REPO_URL | -pkgDir DIR]
	install-event-server
	regenerate-config
	run-diagnosis [OPTIONS] OUTPUT_FILE
	install-graphics-export [-noDeps]
	compact-internal-databases
	copy-databases-to-external
	encrypt-password PASSWORD
	jupyter-nbextensions ACTION (list, enable, disable, available) [extension/main]
"@
	Exit
}

if ($args.Length -eq 0) {
    Usage
}

$cmdLine="$me $a"
$ACTION = $args[0]

# Load basic env
. $BINDIR/env-default.ps1

if ($null -eq $env:DKUINSTALLDIR) {
    Write-Host "FATAL: DKUINSTALLDIR is not defined. Please check $BINDIR\env-default.ps1"
    Exit
}

# . = call in same scope, to access functions
. $env:DKUINSTALLDIR/scripts/_startup.inc.ps1

bkdl_set_py_env

##############################################
# Actions definitions
##############################################

# Regenerate the env-default.ps1
function generate_env_default() {
    Write-Host "[+] Generating default env file"
    Copy-Item -Path "$BINDIR/env-default.ps1" -Destination "$BINDIR/env-default.ps1.BAK"
    & "$env:DKUPYTHONBIN" "$env:DKUINSTALLDIR/scripts/dkuinstall/envfiles.py" -save
    Remove-Item -Force "$BINDIR/env-default.ps1.BAK"
}

function generate_supervisor_config() {
	Write-Host "[+] Generating supervisor configuration"
	$params = "$env:DKUINSTALLDIR/scripts/dkuinstall/supervisor_config.py"
	& $env:DKUPYTHONBIN $params | Out-File -FilePath "$env:DIP_HOME/install-support/supervisord.conf" -Encoding "ascii"
}

function generate_nginx_config() {
	Write-Host "[+] Generating nginx configuration"
	New-Item -Path "$env:DIP_HOME/install-support" -Type Directory -ErrorAction Ignore *>$null
	New-Item -Path "$env:DIP_HOME/run/nginx" -Type Directory -ErrorAction Ignore *>$null
	$params = "$env:DKUINSTALLDIR/scripts/dkuinstall/nginx_config.py"
	& $env:DKUPYTHONBIN $params | Out-File -FilePath "$env:DIP_HOME/install-support/nginx.conf" -Encoding "ascii"
}

function regenerate_config() {
	generate_env_default
	. $BINDIR/env-default.ps1
	generate_supervisor_config
	generate_nginx_config
}

switch ($ACTION) {
	"regenerate-config" { regenerate_config }
	"install-graphics-export" {
		& "$env:DKUINSTALLDIR/scripts/_install-graphics-export.ps1"
    }
	"install-R-integration" {
		& "$env:DKUINSTALLDIR/scripts/_install-R-integration.ps1"
	}
	Default {}
}