/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage;

import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.BufferHandle;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.annotations.VisibleForTesting;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import java.util.AbstractCollection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.IntStream;

interface BufferHandlePool {
    public PooledBuffer getBuffer();

    public void returnBuffer(PooledBuffer var1);

    public static BufferHandlePool simple(int capacity) {
        return new SimpleBufferHandlePool(capacity);
    }

    public static BufferHandlePool fixedPool(int bufferCount, int bufferCapacity) {
        return FixedBufferHandlePool.of(bufferCount, bufferCapacity);
    }

    public static final class SimpleBufferHandlePool
    implements BufferHandlePool {
        private final int capacity;

        private SimpleBufferHandlePool(int capacity) {
            this.capacity = capacity;
        }

        @Override
        public PooledBuffer getBuffer() {
            return PooledBuffer.of(BufferHandle.allocate(this.capacity));
        }

        @Override
        public void returnBuffer(PooledBuffer handle) {
        }
    }

    public static final class FixedBufferHandlePool
    implements BufferHandlePool {
        @VisibleForTesting
        final HashSet<PooledBuffer> pool;
        private final int poolMaxSize;
        private final ReentrantLock lock;
        private final Condition notEmpty;
        private final Condition notFull;

        @VisibleForTesting
        FixedBufferHandlePool(HashSet<PooledBuffer> pool) {
            Preconditions.checkArgument(!pool.isEmpty(), "provided pool bust not start empty");
            this.pool = pool;
            this.poolMaxSize = pool.size();
            this.lock = new ReentrantLock();
            this.notEmpty = this.lock.newCondition();
            this.notFull = this.lock.newCondition();
        }

        @Override
        public PooledBuffer getBuffer() {
            try (AcquiredLock ignore = AcquiredLock.lock(this.lock);){
                while (this.pool.isEmpty()) {
                    this.notEmpty.awaitUninterruptibly();
                }
                PooledBuffer pooledBuffer = this.dequeue();
                return pooledBuffer;
            }
        }

        @Override
        public void returnBuffer(PooledBuffer handle) {
            Preconditions.checkNotNull(handle, "handle must be non null");
            try (AcquiredLock ignore = AcquiredLock.lock(this.lock);){
                if (this.pool.contains(handle)) {
                    return;
                }
                while (this.poolMaxSize == this.pool.size()) {
                    this.notFull.awaitUninterruptibly();
                }
                this.enqueue(handle);
            }
        }

        private void enqueue(PooledBuffer pooled) {
            ((ByteBuffer)pooled.getBufferHandle().get()).clear();
            this.pool.add(pooled);
            this.notEmpty.signal();
        }

        private PooledBuffer dequeue() {
            Iterator<PooledBuffer> iterator = this.pool.iterator();
            Preconditions.checkState(iterator.hasNext(), "attempt to acquire pooled buffer failed");
            PooledBuffer poll = iterator.next();
            iterator.remove();
            this.notFull.signal();
            return poll;
        }

        @VisibleForTesting
        static FixedBufferHandlePool of(int bufferCount, int bufferCapacity) {
            HashSet buffers = IntStream.range(0, bufferCount).mapToObj(i -> BufferHandle.allocate(bufferCapacity)).map(PooledBuffer::of).collect(HashSet::new, Set::add, AbstractCollection::addAll);
            return new FixedBufferHandlePool(buffers);
        }
    }

    public static final class AcquiredLock
    implements AutoCloseable {
        private final ReentrantLock lock;

        private AcquiredLock(ReentrantLock lock) {
            this.lock = lock;
            lock.lock();
        }

        @Override
        public void close() {
            this.lock.unlock();
        }

        private static AcquiredLock lock(ReentrantLock lock) {
            return new AcquiredLock(lock);
        }
    }

    public static final class PooledBuffer {
        private final BufferHandle bufferHandle;

        private PooledBuffer(BufferHandle bufferHandle) {
            this.bufferHandle = bufferHandle;
        }

        BufferHandle getBufferHandle() {
            return this.bufferHandle;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof PooledBuffer)) {
                return false;
            }
            PooledBuffer that = (PooledBuffer)o;
            return Objects.equals(System.identityHashCode(this), System.identityHashCode(that));
        }

        public int hashCode() {
            return System.identityHashCode(this);
        }

        @VisibleForTesting
        static PooledBuffer of(BufferHandle bufferHandle) {
            return new PooledBuffer(bufferHandle);
        }
    }
}

