/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage;

import com.google.cloud.hadoop.repackaged.gcs.com.google.api.core.SettableApiFuture;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.gax.grpc.GrpcCallContext;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.gax.rpc.ApiStreamObserver;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.gax.rpc.ClientStreamingCallable;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.ChunkSegmenter;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.Crc32cValue;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.GrpcUtils;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.UnbufferedWritableByteChannelSession;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.WriteCtx;
import com.google.cloud.hadoop.repackaged.gcs.com.google.protobuf.ByteString;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.ChecksummedData;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.ObjectChecksums;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.WriteObjectRequest;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.WriteObjectResponse;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import java.util.function.LongConsumer;
import org.checkerframework.checker.nullness.qual.NonNull;

final class GapicUnbufferedDirectWritableByteChannel
implements UnbufferedWritableByteChannelSession.UnbufferedWritableByteChannel {
    private final SettableApiFuture<WriteObjectResponse> resultFuture;
    private final ChunkSegmenter chunkSegmenter;
    private final ClientStreamingCallable<WriteObjectRequest, WriteObjectResponse> write;
    private final WriteCtx<WriteCtx.SimpleWriteObjectRequestBuilderFactory> writeCtx;
    private final Observer responseObserver;
    private volatile ApiStreamObserver<WriteObjectRequest> stream;
    private boolean open = true;
    private boolean first = true;
    private boolean finished = false;

    GapicUnbufferedDirectWritableByteChannel(SettableApiFuture<WriteObjectResponse> resultFuture, ChunkSegmenter chunkSegmenter, ClientStreamingCallable<WriteObjectRequest, WriteObjectResponse> write, WriteCtx.SimpleWriteObjectRequestBuilderFactory requestFactory) {
        String bucketName = requestFactory.bucketName();
        this.resultFuture = resultFuture;
        this.chunkSegmenter = chunkSegmenter;
        GrpcCallContext internalContext = GrpcUtils.contextWithBucketName(bucketName, GrpcCallContext.createDefault());
        this.write = write.withDefaultCallContext(internalContext);
        this.writeCtx = new WriteCtx<WriteCtx.SimpleWriteObjectRequestBuilderFactory>(requestFactory);
        this.responseObserver = new Observer(this.writeCtx.getConfirmedBytes()::set, resultFuture::set);
    }

    @Override
    public long write(ByteBuffer[] srcs, int srcsOffset, int srcsLength) throws IOException {
        return this.internalWrite(srcs, srcsOffset, srcsLength, false);
    }

    @Override
    public long writeAndClose(ByteBuffer[] srcs, int srcsOffset, int srcsLength) throws IOException {
        long write = this.internalWrite(srcs, srcsOffset, srcsLength, true);
        this.close();
        return write;
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    public void close() throws IOException {
        ApiStreamObserver<WriteObjectRequest> openedStream = this.openedStream();
        if (!this.finished) {
            WriteObjectRequest message = this.finishMessage();
            try {
                openedStream.onNext(message);
                openedStream.onCompleted();
                this.finished = true;
            }
            catch (RuntimeException e) {
                this.resultFuture.setException(e);
                throw e;
            }
        }
        try {
            openedStream.onCompleted();
        }
        catch (RuntimeException e) {
            this.resultFuture.setException(e);
            throw e;
        }
        this.open = false;
        this.responseObserver.await();
    }

    private long internalWrite(ByteBuffer[] srcs, int srcsOffset, int srcsLength, boolean finalize) throws ClosedChannelException {
        if (!this.open) {
            throw new ClosedChannelException();
        }
        ChunkSegmenter.ChunkSegment[] data = this.chunkSegmenter.segmentBuffers(srcs, srcsOffset, srcsLength);
        ArrayList<WriteObjectRequest> messages = new ArrayList<WriteObjectRequest>();
        ApiStreamObserver<WriteObjectRequest> openedStream = this.openedStream();
        int bytesConsumed = 0;
        for (ChunkSegmenter.ChunkSegment datum : data) {
            Crc32cValue.Crc32cLengthKnown crc32c = datum.getCrc32c();
            ByteString b = datum.getB();
            int contentSize = b.size();
            long offset = this.writeCtx.getTotalSentBytes().getAndAdd(contentSize);
            Crc32cValue.Crc32cLengthKnown cumulative = this.writeCtx.getCumulativeCrc32c().accumulateAndGet(crc32c, this.chunkSegmenter.getHasher()::nullSafeConcat);
            ChecksummedData.Builder checksummedData = ChecksummedData.newBuilder().setContent(b);
            if (crc32c != null) {
                checksummedData.setCrc32C(crc32c.getValue());
            }
            WriteObjectRequest.Builder builder = this.writeCtx.newRequestBuilder().setWriteOffset(offset).setChecksummedData(checksummedData.build());
            if (!datum.isOnlyFullBlocks()) {
                builder.setFinishWrite(true);
                if (cumulative != null) {
                    builder.setObjectChecksums(ObjectChecksums.newBuilder().setCrc32C(cumulative.getValue()).build());
                }
                this.finished = true;
            }
            WriteObjectRequest build = GapicUnbufferedDirectWritableByteChannel.possiblyPairDownRequest(builder, this.first).build();
            this.first = false;
            messages.add(build);
            bytesConsumed += contentSize;
        }
        if (finalize && !this.finished) {
            messages.add(this.finishMessage());
            this.finished = true;
        }
        try {
            for (WriteObjectRequest message : messages) {
                openedStream.onNext(message);
            }
        }
        catch (RuntimeException e) {
            this.resultFuture.setException(e);
            throw e;
        }
        return bytesConsumed;
    }

    private @NonNull WriteObjectRequest finishMessage() {
        long offset = this.writeCtx.getTotalSentBytes().get();
        Crc32cValue.Crc32cLengthKnown crc32cValue = this.writeCtx.getCumulativeCrc32c().get();
        WriteObjectRequest.Builder b = this.writeCtx.newRequestBuilder().setFinishWrite(true).setWriteOffset(offset);
        if (crc32cValue != null) {
            b.setObjectChecksums(ObjectChecksums.newBuilder().setCrc32C(crc32cValue.getValue()).build());
        }
        WriteObjectRequest message = GapicUnbufferedDirectWritableByteChannel.possiblyPairDownRequest(b, this.first).build();
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ApiStreamObserver<WriteObjectRequest> openedStream() {
        if (this.stream == null) {
            GapicUnbufferedDirectWritableByteChannel gapicUnbufferedDirectWritableByteChannel = this;
            synchronized (gapicUnbufferedDirectWritableByteChannel) {
                if (this.stream == null) {
                    this.stream = this.write.clientStreamingCall(this.responseObserver);
                }
            }
        }
        return this.stream;
    }

    private static WriteObjectRequest.Builder possiblyPairDownRequest(WriteObjectRequest.Builder b, boolean firstMessageOfStream) {
        if (firstMessageOfStream && b.getWriteOffset() == 0L) {
            return b;
        }
        if (b.getWriteOffset() > 0L) {
            b.clearWriteObjectSpec();
        }
        if (b.getWriteOffset() > 0L && !b.getFinishWrite()) {
            b.clearObjectChecksums();
        }
        return b;
    }

    static class Observer
    implements ApiStreamObserver<WriteObjectResponse> {
        private final LongConsumer sizeCallback;
        private final Consumer<WriteObjectResponse> completeCallback;
        private final SettableApiFuture<Void> invocationHandle;
        private volatile WriteObjectResponse last;

        Observer(LongConsumer sizeCallback, Consumer<WriteObjectResponse> completeCallback) {
            this.sizeCallback = sizeCallback;
            this.completeCallback = completeCallback;
            this.invocationHandle = SettableApiFuture.create();
        }

        @Override
        public void onNext(WriteObjectResponse value) {
            if (value.hasPersistedSize()) {
                this.sizeCallback.accept(value.getPersistedSize());
            } else if (value.hasResource()) {
                this.sizeCallback.accept(value.getResource().getSize());
            }
            this.last = value;
        }

        @Override
        public void onError(Throwable t) {
            this.invocationHandle.setException(t);
        }

        @Override
        public void onCompleted() {
            if (this.last != null && this.last.hasResource()) {
                this.completeCallback.accept(this.last);
            }
            this.invocationHandle.set(null);
        }

        void await() {
            try {
                this.invocationHandle.get();
            }
            catch (InterruptedException | ExecutionException e) {
                if (e.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e.getCause();
                }
                throw new RuntimeException(e);
            }
        }
    }
}

