/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.io.grpc.xds;

import com.google.cloud.hadoop.repackaged.gcs.com.google.common.annotations.VisibleForTesting;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Preconditions;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.Attributes;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.ExperimentalApi;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.ForwardingServerBuilder;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.Internal;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.Server;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.ServerBuilder;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.ServerCredentials;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.netty.shaded.io.grpc.netty.InternalNettyServerBuilder;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.netty.shaded.io.grpc.netty.InternalNettyServerCredentials;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.netty.shaded.io.grpc.netty.InternalProtocolNegotiator;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.netty.shaded.io.grpc.netty.NettyServerBuilder;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.xds.FilterChainMatchingProtocolNegotiators;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.xds.FilterChainSelectorManager;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.xds.FilterRegistry;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.xds.InternalXdsAttributes;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.xds.SharedXdsClientPoolProvider;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.xds.XdsNameResolverProvider;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.xds.XdsServerWrapper;
import com.google.errorprone.annotations.DoNotCall;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/7514")
public final class XdsServerBuilder
extends ForwardingServerBuilder<XdsServerBuilder> {
    private static final long AS_LARGE_AS_INFINITE = TimeUnit.DAYS.toNanos(1000L);
    private final NettyServerBuilder delegate;
    private final int port;
    private XdsServingStatusListener xdsServingStatusListener;
    private AtomicBoolean isServerBuilt = new AtomicBoolean(false);
    private final FilterRegistry filterRegistry = FilterRegistry.getDefaultRegistry();
    private XdsNameResolverProvider.XdsClientPoolFactory xdsClientPoolFactory = SharedXdsClientPoolProvider.getDefaultProvider();
    private long drainGraceTime = 10L;
    private TimeUnit drainGraceTimeUnit = TimeUnit.MINUTES;

    private XdsServerBuilder(NettyServerBuilder nettyDelegate, int port) {
        this.delegate = nettyDelegate;
        this.port = port;
        this.xdsServingStatusListener = new DefaultListener("port:" + port);
    }

    @Override
    @Internal
    protected ServerBuilder<?> delegate() {
        Preconditions.checkState(!this.isServerBuilt.get(), "Server already built!");
        return this.delegate;
    }

    public XdsServerBuilder xdsServingStatusListener(XdsServingStatusListener xdsServingStatusListener) {
        this.xdsServingStatusListener = Preconditions.checkNotNull(xdsServingStatusListener, "xdsServingStatusListener");
        return this;
    }

    public XdsServerBuilder drainGraceTime(long drainGraceTime, TimeUnit drainGraceTimeUnit) {
        Preconditions.checkArgument(drainGraceTime >= 0L, "drain grace time must be non-negative: %s", drainGraceTime);
        Preconditions.checkNotNull(drainGraceTimeUnit, "drainGraceTimeUnit");
        if (drainGraceTimeUnit.toNanos(drainGraceTime) >= AS_LARGE_AS_INFINITE) {
            drainGraceTimeUnit = null;
        }
        this.drainGraceTime = drainGraceTime;
        this.drainGraceTimeUnit = drainGraceTimeUnit;
        return this;
    }

    @DoNotCall(value="Unsupported. Use forPort(int, ServerCredentials) instead")
    public static ServerBuilder<?> forPort(int port) {
        throw new UnsupportedOperationException("Unsupported call - use forPort(int, ServerCredentials)");
    }

    public static XdsServerBuilder forPort(int port, ServerCredentials serverCredentials) {
        Preconditions.checkNotNull(serverCredentials, "serverCredentials");
        InternalProtocolNegotiator.ServerFactory originalNegotiatorFactory = InternalNettyServerCredentials.toNegotiator(serverCredentials);
        ServerCredentials wrappedCredentials = InternalNettyServerCredentials.create(new FilterChainMatchingProtocolNegotiators.FilterChainMatchingNegotiatorServerFactory(originalNegotiatorFactory));
        NettyServerBuilder nettyDelegate = NettyServerBuilder.forPort(port, wrappedCredentials);
        return new XdsServerBuilder(nettyDelegate, port);
    }

    @Override
    public Server build() {
        Preconditions.checkState(this.isServerBuilt.compareAndSet(false, true), "Server already built!");
        FilterChainSelectorManager filterChainSelectorManager = new FilterChainSelectorManager();
        Attributes.Builder builder = Attributes.newBuilder().set(InternalXdsAttributes.ATTR_FILTER_CHAIN_SELECTOR_MANAGER, filterChainSelectorManager);
        if (this.drainGraceTimeUnit != null) {
            builder.set(InternalXdsAttributes.ATTR_DRAIN_GRACE_NANOS, this.drainGraceTimeUnit.toNanos(this.drainGraceTime));
        }
        InternalNettyServerBuilder.eagAttributes(this.delegate, builder.build());
        return new XdsServerWrapper("0.0.0.0:" + this.port, this.delegate, this.xdsServingStatusListener, filterChainSelectorManager, this.xdsClientPoolFactory, this.filterRegistry);
    }

    @VisibleForTesting
    XdsServerBuilder xdsClientPoolFactory(XdsNameResolverProvider.XdsClientPoolFactory xdsClientPoolFactory) {
        this.xdsClientPoolFactory = Preconditions.checkNotNull(xdsClientPoolFactory, "xdsClientPoolFactory");
        return this;
    }

    public XdsServerBuilder overrideBootstrapForTest(Map<String, ?> bootstrapOverride) {
        Preconditions.checkNotNull(bootstrapOverride, "bootstrapOverride");
        if (this.xdsClientPoolFactory == SharedXdsClientPoolProvider.getDefaultProvider()) {
            this.xdsClientPoolFactory = new SharedXdsClientPoolProvider();
        }
        this.xdsClientPoolFactory.setBootstrapOverride(bootstrapOverride);
        return this;
    }

    public ServerBuilder<?> transportBuilder() {
        return this.delegate;
    }

    private static class DefaultListener
    implements XdsServingStatusListener {
        private final Logger logger = Logger.getLogger(DefaultListener.class.getName());
        private final String prefix;
        boolean notServingDueToError;

        DefaultListener(String prefix) {
            this.prefix = prefix;
        }

        @Override
        public void onServing() {
            if (this.notServingDueToError) {
                this.notServingDueToError = false;
                this.logger.warning("[" + this.prefix + "] Entering serving state.");
            }
        }

        @Override
        public void onNotServing(Throwable throwable) {
            this.logger.warning("[" + this.prefix + "] " + throwable.getMessage());
            this.notServingDueToError = true;
        }
    }

    public static interface XdsServingStatusListener {
        public void onServing();

        public void onNotServing(Throwable var1);
    }
}

