/*
 * Decompiled with CFR 0.152.
 */
package io.delta.tables;

import io.delta.tables.DeltaTable;
import io.delta.tables.DeltaTable$;
import io.delta.tables.execution.CreateTableOptions;
import io.delta.tables.execution.DeltaTableBuilderOptions;
import io.delta.tables.execution.ReplaceTableOptions;
import java.io.Serializable;
import org.apache.spark.annotation.Evolving;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.analysis.UnresolvedIdentifier;
import org.apache.spark.sql.catalyst.analysis.UnresolvedIdentifier$;
import org.apache.spark.sql.catalyst.plans.logical.ColumnDefinitionShims$;
import org.apache.spark.sql.catalyst.plans.logical.CreateTable;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.ReplaceTable;
import org.apache.spark.sql.catalyst.plans.logical.TableSpec;
import org.apache.spark.sql.catalyst.plans.logical.TableSpecBase;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap$;
import org.apache.spark.sql.delta.DeltaErrors$;
import org.apache.spark.sql.delta.DeltaTableUtils$;
import org.apache.spark.sql.delta.sources.DeltaSQLConf$;
import org.apache.spark.sql.execution.QueryExecution;
import org.apache.spark.sql.execution.SQLExecution$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Evolving
@ScalaSignature(bytes="\u0006\u0001\t5a\u0001B\u0015+\u0001EB\u0001\u0002\u000f\u0001\u0003\u0002\u0003\u0006I!\u000f\u0005\t\t\u0002\u0011\t\u0011)A\u0005\u000b\"11\n\u0001C\u0001U1Cq!\u0015\u0001A\u0002\u0013%!\u000bC\u0004_\u0001\u0001\u0007I\u0011B0\t\r\u0015\u0004\u0001\u0015)\u0003T\u0011\u001d1\u0007\u00011A\u0005\n\u001dDq\u0001\u001e\u0001A\u0002\u0013%Q\u000f\u0003\u0004x\u0001\u0001\u0006K\u0001\u001b\u0005\bq\u0002\u0001\r\u0011\"\u0003h\u0011\u001dI\b\u00011A\u0005\niDa\u0001 \u0001!B\u0013A\u0007bB?\u0001\u0001\u0004%IA \u0005\n\u00033\u0001\u0001\u0019!C\u0005\u00037Aq!a\b\u0001A\u0003&q\u0010C\u0005\u0002\"\u0001\u0001\r\u0011\"\u0003\u0002$!I\u0011q\u0005\u0001A\u0002\u0013%\u0011\u0011\u0006\u0005\t\u0003[\u0001\u0001\u0015)\u0003\u0002&!I\u0011q\u0006\u0001A\u0002\u0013%\u00111\u0005\u0005\n\u0003c\u0001\u0001\u0019!C\u0005\u0003gA\u0001\"a\u000e\u0001A\u0003&\u0011Q\u0005\u0005\n\u0003s\u0001\u0001\u0019!C\u0005\u0003wA\u0011\"!\u0013\u0001\u0001\u0004%I!a\u0013\t\u0011\u0005=\u0003\u0001)Q\u0005\u0003{A\u0001\"!\u0015\u0001\u0005\u0004%IA\u0015\u0005\b\u0003'\u0002\u0001\u0015!\u0003T\u0011\u001d\t)\u0006\u0001C\u0001\u0003/Bq!!\u001b\u0001\t\u0003\tY\u0007C\u0004\u0002\"\u0001!\t!!\u001d\t\u000f\u0005]\u0004\u0001\"\u0001\u0002z!9\u0011q\u000f\u0001\u0005\u0002\u0005\u0015\u0005bBA<\u0001\u0011\u0005\u00111\u0013\u0005\b\u0003o\u0002A\u0011AAS\u0011\u001d\t9\b\u0001C\u0001\u0003_Cq!a.\u0001\t\u0003\tI\fC\u0004\u0002H\u0002!I!!3\t\u000f\u0005-\u0007\u0001\"\u0001\u0002N\"9\u0011q\u001d\u0001\u0005\u0002\u0005%\bbBAy\u0001\u0011\u0005\u00111\u001f\u0005\b\u0003\u007f\u0004A\u0011\u0001B\u0001\u0005E!U\r\u001c;b)\u0006\u0014G.\u001a\"vS2$WM\u001d\u0006\u0003W1\na\u0001^1cY\u0016\u001c(BA\u0017/\u0003\u0015!W\r\u001c;b\u0015\u0005y\u0013AA5p\u0007\u0001\u0019\"\u0001\u0001\u001a\u0011\u0005M2T\"\u0001\u001b\u000b\u0003U\nQa]2bY\u0006L!a\u000e\u001b\u0003\r\u0005s\u0017PU3g\u0003\u0015\u0019\b/\u0019:l!\tQ$)D\u0001<\u0015\taT(A\u0002tc2T!\u0001\u000f \u000b\u0005}\u0002\u0015AB1qC\u000eDWMC\u0001B\u0003\ry'oZ\u0005\u0003\u0007n\u0012Ab\u00159be.\u001cVm]:j_:\fQBY;jY\u0012,'o\u00149uS>t\u0007C\u0001$J\u001b\u00059%B\u0001%+\u0003%)\u00070Z2vi&|g.\u0003\u0002K\u000f\nAB)\u001a7uCR\u000b'\r\\3Ck&dG-\u001a:PaRLwN\\:\u0002\rqJg.\u001b;?)\riu\n\u0015\t\u0003\u001d\u0002i\u0011A\u000b\u0005\u0006q\r\u0001\r!\u000f\u0005\u0006\t\u000e\u0001\r!R\u0001\u000bS\u0012,g\u000e^5gS\u0016\u0014X#A*\u0011\u0005Q[fBA+Z!\t1F'D\u0001X\u0015\tA\u0006'\u0001\u0004=e>|GOP\u0005\u00035R\na\u0001\u0015:fI\u00164\u0017B\u0001/^\u0005\u0019\u0019FO]5oO*\u0011!\fN\u0001\u000fS\u0012,g\u000e^5gS\u0016\u0014x\fJ3r)\t\u00017\r\u0005\u00024C&\u0011!\r\u000e\u0002\u0005+:LG\u000fC\u0004e\u000b\u0005\u0005\t\u0019A*\u0002\u0007a$\u0013'A\u0006jI\u0016tG/\u001b4jKJ\u0004\u0013a\u00059beRLG/[8oS:<7i\u001c7v[:\u001cX#\u00015\u0011\u0007MJ7.\u0003\u0002ki\t1q\n\u001d;j_:\u00042\u0001\\9T\u001d\tiwN\u0004\u0002W]&\tQ'\u0003\u0002qi\u00059\u0001/Y2lC\u001e,\u0017B\u0001:t\u0005\r\u0019V-\u001d\u0006\u0003aR\nq\u0003]1si&$\u0018n\u001c8j]\u001e\u001cu\u000e\\;n]N|F%Z9\u0015\u0005\u00014\bb\u00023\t\u0003\u0003\u0005\r\u0001[\u0001\u0015a\u0006\u0014H/\u001b;j_:LgnZ\"pYVlgn\u001d\u0011\u0002#\rdWo\u001d;fe&twmQ8mk6t7/A\u000bdYV\u001cH/\u001a:j]\u001e\u001cu\u000e\\;n]N|F%Z9\u0015\u0005\u0001\\\bb\u00023\f\u0003\u0003\u0005\r\u0001[\u0001\u0013G2,8\u000f^3sS:<7i\u001c7v[:\u001c\b%A\u0004d_2,XN\\:\u0016\u0003}\u0004b!!\u0001\u0002\f\u00055QBAA\u0002\u0015\u0011\t)!a\u0002\u0002\u000f5,H/\u00192mK*\u0019\u0011\u0011\u0002\u001b\u0002\u0015\r|G\u000e\\3di&|g.C\u0002s\u0003\u0007\u0001B!a\u0004\u0002\u00165\u0011\u0011\u0011\u0003\u0006\u0004\u0003'Y\u0014!\u0002;za\u0016\u001c\u0018\u0002BA\f\u0003#\u00111b\u0015;sk\u000e$h)[3mI\u0006Y1m\u001c7v[:\u001cx\fJ3r)\r\u0001\u0017Q\u0004\u0005\bI:\t\t\u00111\u0001\u0000\u0003!\u0019w\u000e\\;n]N\u0004\u0013\u0001\u00037pG\u0006$\u0018n\u001c8\u0016\u0005\u0005\u0015\u0002cA\u001aj'\u0006aAn\\2bi&|gn\u0018\u0013fcR\u0019\u0001-a\u000b\t\u0011\u0011\f\u0012\u0011!a\u0001\u0003K\t\u0011\u0002\\8dCRLwN\u001c\u0011\u0002\u0015Q\u0014GnQ8n[\u0016tG/\u0001\buE2\u001cu.\\7f]R|F%Z9\u0015\u0007\u0001\f)\u0004\u0003\u0005e)\u0005\u0005\t\u0019AA\u0013\u0003-!(\r\\\"p[6,g\u000e\u001e\u0011\u0002\u0015A\u0014x\u000e]3si&,7/\u0006\u0002\u0002>A1\u0011qHA#'Nk!!!\u0011\u000b\t\u0005\r\u0013qA\u0001\nS6lW\u000f^1cY\u0016LA!a\u0012\u0002B\t\u0019Q*\u00199\u0002\u001dA\u0014x\u000e]3si&,7o\u0018\u0013fcR\u0019\u0001-!\u0014\t\u0011\u0011<\u0012\u0011!a\u0001\u0003{\t1\u0002\u001d:pa\u0016\u0014H/[3tA\u0005Yai\u0014*N\u0003R{f*Q'F\u000311uJU'B)~s\u0015)T#!\u0003%!\u0018M\u00197f\u001d\u0006lW\rF\u0002N\u00033BQ!U\u000eA\u0002MC3aGA/!\u0011\ty&!\u001a\u000e\u0005\u0005\u0005$bAA2{\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005\u001d\u0014\u0011\r\u0002\t\u000bZ|GN^5oO\u000691m\\7nK:$HcA'\u0002n!1\u0011\u0011\u000e\u000fA\u0002MC3\u0001HA/)\ri\u00151\u000f\u0005\u0007\u0003Ci\u0002\u0019A*)\u0007u\ti&A\u0005bI\u0012\u001cu\u000e\\;n]R)Q*a\u001f\u0002\u0000!1\u0011Q\u0010\u0010A\u0002M\u000bqaY8m\u001d\u0006lW\r\u0003\u0004\u0002\u0002z\u0001\raU\u0001\tI\u0006$\u0018\rV=qK\"\u001aa$!\u0018\u0015\u000b5\u000b9)!#\t\r\u0005ut\u00041\u0001T\u0011\u001d\t\ti\ba\u0001\u0003\u0017\u0003B!a\u0004\u0002\u000e&!\u0011qRA\t\u0005!!\u0015\r^1UsB,\u0007fA\u0010\u0002^Q9Q*!&\u0002\u0018\u0006e\u0005BBA?A\u0001\u00071\u000b\u0003\u0004\u0002\u0002\u0002\u0002\ra\u0015\u0005\b\u00037\u0003\u0003\u0019AAO\u0003!qW\u000f\u001c7bE2,\u0007cA\u001a\u0002 &\u0019\u0011\u0011\u0015\u001b\u0003\u000f\t{w\u000e\\3b]\"\u001a\u0001%!\u0018\u0015\u000f5\u000b9+!+\u0002,\"1\u0011QP\u0011A\u0002MCq!!!\"\u0001\u0004\tY\tC\u0004\u0002\u001c\u0006\u0002\r!!()\u0007\u0005\ni\u0006F\u0002N\u0003cCq!a-#\u0001\u0004\ti!A\u0002d_2D3AIA/\u0003)\tG\rZ\"pYVlgn\u001d\u000b\u0004\u001b\u0006m\u0006bBA_G\u0001\u0007\u0011qX\u0001\u0005G>d7\u000f\u0005\u0003\u0002\u0010\u0005\u0005\u0017\u0002BAb\u0003#\u0011!b\u0015;sk\u000e$H+\u001f9fQ\r\u0019\u0013QL\u0001\u0015m\u0006d\u0017\u000eZ1uKB\u000b'\u000f^5uS>t\u0017N\\4\u0015\u0003\u0001\fQ\u0002]1si&$\u0018n\u001c8fI\nKHcA'\u0002P\"9\u0011\u0011[\u0013A\u0002\u0005M\u0017\u0001C2pY:\u000bW.Z:\u0011\tM\n)nU\u0005\u0004\u0003/$$A\u0003\u001fsKB,\u0017\r^3e}!\u001aQ%a7\u0011\t\u0005u\u0017\u0011]\u0007\u0003\u0003?T1!a\u00195\u0013\u0011\t\u0019/a8\u0003\u000fY\f'/\u0019:hg\"\u001aQ%!\u0018\u0002\u0013\rdWo\u001d;fe\nKHcA'\u0002l\"9\u0011\u0011\u001b\u0014A\u0002\u0005M\u0007f\u0001\u0014\u0002\\\"\u001aa%!\u0018\u0002\u0011A\u0014x\u000e]3sif$R!TA{\u0003sDa!a>(\u0001\u0004\u0019\u0016aA6fs\"1\u00111`\u0014A\u0002M\u000bQA^1mk\u0016D3aJA/\u0003\u001d)\u00070Z2vi\u0016$\"Aa\u0001\u0011\u00079\u0013)!C\u0002\u0003\b)\u0012!\u0002R3mi\u0006$\u0016M\u00197fQ\rA\u0013Q\f\u0015\u0004\u0001\u0005u\u0003")
public class DeltaTableBuilder {
    private final SparkSession spark;
    private final DeltaTableBuilderOptions builderOption;
    private String identifier;
    private Option<Seq<String>> partitioningColumns;
    private Option<Seq<String>> clusteringColumns;
    private scala.collection.mutable.Seq<StructField> columns;
    private Option<String> location;
    private Option<String> tblComment;
    private Map<String, String> properties;
    private final String FORMAT_NAME;

    public DeltaTableBuilder partitionedBy(String ... colNames) {
        return this.partitionedBy((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])colNames));
    }

    public DeltaTableBuilder clusterBy(String ... colNames) {
        return this.clusterBy((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])colNames));
    }

    private String identifier() {
        return this.identifier;
    }

    private void identifier_$eq(String x$1) {
        this.identifier = x$1;
    }

    private Option<Seq<String>> partitioningColumns() {
        return this.partitioningColumns;
    }

    private void partitioningColumns_$eq(Option<Seq<String>> x$1) {
        this.partitioningColumns = x$1;
    }

    private Option<Seq<String>> clusteringColumns() {
        return this.clusteringColumns;
    }

    private void clusteringColumns_$eq(Option<Seq<String>> x$1) {
        this.clusteringColumns = x$1;
    }

    private scala.collection.mutable.Seq<StructField> columns() {
        return this.columns;
    }

    private void columns_$eq(scala.collection.mutable.Seq<StructField> x$1) {
        this.columns = x$1;
    }

    private Option<String> location() {
        return this.location;
    }

    private void location_$eq(Option<String> x$1) {
        this.location = x$1;
    }

    private Option<String> tblComment() {
        return this.tblComment;
    }

    private void tblComment_$eq(Option<String> x$1) {
        this.tblComment = x$1;
    }

    private Map<String, String> properties() {
        return this.properties;
    }

    private void properties_$eq(Map<String, String> x$1) {
        this.properties = x$1;
    }

    private String FORMAT_NAME() {
        return this.FORMAT_NAME;
    }

    @Evolving
    public DeltaTableBuilder tableName(String identifier) {
        this.identifier_$eq(identifier);
        return this;
    }

    @Evolving
    public DeltaTableBuilder comment(String comment) {
        this.tblComment_$eq((Option<String>)Option$.MODULE$.apply((Object)comment));
        return this;
    }

    @Evolving
    public DeltaTableBuilder location(String location) {
        this.location_$eq((Option<String>)Option$.MODULE$.apply((Object)location));
        return this;
    }

    @Evolving
    public DeltaTableBuilder addColumn(String colName, String dataType) {
        this.addColumn(DeltaTable$.MODULE$.columnBuilder(this.spark, colName).dataType(dataType).build());
        return this;
    }

    @Evolving
    public DeltaTableBuilder addColumn(String colName, DataType dataType) {
        this.addColumn(DeltaTable$.MODULE$.columnBuilder(this.spark, colName).dataType(dataType).build());
        return this;
    }

    @Evolving
    public DeltaTableBuilder addColumn(String colName, String dataType, boolean nullable) {
        this.addColumn(DeltaTable$.MODULE$.columnBuilder(this.spark, colName).dataType(dataType).nullable(nullable).build());
        return this;
    }

    @Evolving
    public DeltaTableBuilder addColumn(String colName, DataType dataType, boolean nullable) {
        this.addColumn(DeltaTable$.MODULE$.columnBuilder(this.spark, colName).dataType(dataType).nullable(nullable).build());
        return this;
    }

    @Evolving
    public DeltaTableBuilder addColumn(StructField col) {
        this.columns_$eq((scala.collection.mutable.Seq<StructField>)((scala.collection.mutable.Seq)this.columns().$colon$plus((Object)col, Seq$.MODULE$.canBuildFrom())));
        return this;
    }

    @Evolving
    public DeltaTableBuilder addColumns(StructType cols) {
        this.columns_$eq((scala.collection.mutable.Seq<StructField>)((scala.collection.mutable.Seq)this.columns().$plus$plus((GenTraversableOnce)cols.toSeq(), Seq$.MODULE$.canBuildFrom())));
        return this;
    }

    private void validatePartitioning() {
        if (this.partitioningColumns().nonEmpty() && this.clusteringColumns().nonEmpty()) {
            throw DeltaErrors$.MODULE$.clusterByWithPartitionedBy();
        }
    }

    @Evolving
    public DeltaTableBuilder partitionedBy(Seq<String> colNames) {
        this.partitioningColumns_$eq((Option<Seq<String>>)Option$.MODULE$.apply(colNames));
        this.validatePartitioning();
        return this;
    }

    @Evolving
    public DeltaTableBuilder clusterBy(Seq<String> colNames) {
        this.clusteringColumns_$eq((Option<Seq<String>>)Option$.MODULE$.apply(colNames));
        this.validatePartitioning();
        return this;
    }

    @Evolving
    public DeltaTableBuilder property(String key, String value) {
        this.properties_$eq((Map<String, String>)this.properties().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)value)));
        return this;
    }

    @Evolving
    public DeltaTable execute() {
        return (DeltaTable)DeltaTableUtils$.MODULE$.withActiveSession(this.spark, (Function0 & Serializable & scala.Serializable)() -> {
            CreateTable createTable;
            TableIdentifier tableId;
            if (this.identifier() == null && this.location().isEmpty()) {
                throw DeltaErrors$.MODULE$.createTableMissingTableNameOrLocation();
            }
            if (this.identifier() == null) {
                this.identifier_$eq(new StringBuilder(8).append("delta.`").append(this.location().get()).append("`").toString());
            }
            if (DeltaTableUtils$.MODULE$.isValidPath(tableId = $this.spark.sessionState().sqlParser().parseTableIdentifier(this.identifier())) && this.location().nonEmpty()) {
                String string = tableId.table();
                Object object = this.location().get();
                if (string == null ? object != null : !string.equals(object)) {
                    throw DeltaErrors$.MODULE$.createTableIdentifierLocationMismatch(this.identifier(), (String)this.location().get());
                }
            }
            Seq table = $this.spark.sessionState().sqlParser().parseMultipartIdentifier(this.identifier());
            Seq partitioning = (Seq)((TraversableLike)this.partitioningColumns().map((Function1 & Serializable & scala.Serializable)colNames -> (Seq)colNames.map((Function1 & Serializable & scala.Serializable)name -> DeltaTableUtils$.MODULE$.parseColToTransform((String)name), scala.collection.Seq$.MODULE$.canBuildFrom())).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Nil$.MODULE$)).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(this.clusteringColumns().map((Function1 & Serializable & scala.Serializable)colNames -> DeltaTableUtils$.MODULE$.parseColsToClusterByTransform((Seq<String>)colNames))), scala.collection.Seq$.MODULE$.canBuildFrom());
            Map<String, String> x$1 = this.properties();
            Some x$2 = new Some((Object)this.FORMAT_NAME());
            Map x$3 = Predef$.MODULE$.Map().empty();
            Option<String> x$4 = this.location();
            None$ x$5 = None$.MODULE$;
            Option<String> x$6 = this.tblComment();
            boolean x$7 = false;
            TableSpec tableSpec = new TableSpec(x$1, (Option)x$2, x$3, x$4, x$6, (Option)x$5, x$7);
            DeltaTableBuilderOptions deltaTableBuilderOptions = $this.builderOption;
            if (deltaTableBuilderOptions instanceof CreateTableOptions) {
                CreateTableOptions createTableOptions = (CreateTableOptions)deltaTableBuilderOptions;
                boolean ifNotExists = createTableOptions.ifNotExists();
                UnresolvedIdentifier unresolvedTable = new UnresolvedIdentifier(table, UnresolvedIdentifier$.MODULE$.apply$default$2());
                createTable = new CreateTable((LogicalPlan)unresolvedTable, ColumnDefinitionShims$.MODULE$.parseColumns((Seq<StructField>)this.columns().toSeq(), $this.spark.sessionState().sqlParser()), partitioning, (TableSpecBase)tableSpec, ifNotExists);
            } else if (deltaTableBuilderOptions instanceof ReplaceTableOptions) {
                ReplaceTableOptions replaceTableOptions = (ReplaceTableOptions)deltaTableBuilderOptions;
                boolean orCreate = replaceTableOptions.orCreate();
                UnresolvedIdentifier unresolvedTable = new UnresolvedIdentifier(table, UnresolvedIdentifier$.MODULE$.apply$default$2());
                createTable = new ReplaceTable((LogicalPlan)unresolvedTable, ColumnDefinitionShims$.MODULE$.parseColumns((Seq<StructField>)this.columns().toSeq(), $this.spark.sessionState().sqlParser()), partitioning, (TableSpecBase)tableSpec, orCreate);
            } else {
                throw new MatchError((Object)deltaTableBuilderOptions);
            }
            CreateTable stmt = createTable;
            QueryExecution qe = $this.spark.sessionState().executePlan((LogicalPlan)stmt, $this.spark.sessionState().executePlan$default$2());
            SQLExecution$.MODULE$.withNewExecutionId(qe, (Option)new Some((Object)"create delta table"), (Function0 & Serializable & scala.Serializable)() -> qe.toRdd());
            if (DeltaTableUtils$.MODULE$.isValidPath(tableId)) {
                return DeltaTable$.MODULE$.forPath($this.spark, (String)this.location().get());
            }
            return DeltaTable$.MODULE$.forName($this.spark, this.identifier());
        });
    }

    public DeltaTableBuilder(SparkSession spark, DeltaTableBuilderOptions builderOption) {
        this.spark = spark;
        this.builderOption = builderOption;
        this.identifier = null;
        this.partitioningColumns = None$.MODULE$;
        this.clusteringColumns = None$.MODULE$;
        this.columns = (scala.collection.mutable.Seq)Seq$.MODULE$.empty();
        this.location = None$.MODULE$;
        this.tblComment = None$.MODULE$;
        this.properties = BoxesRunTime.unboxToBoolean((Object)spark.sessionState().conf().getConf(DeltaSQLConf$.MODULE$.TABLE_BUILDER_FORCE_TABLEPROPERTY_LOWERCASE())) ? CaseInsensitiveMap$.MODULE$.apply(Predef$.MODULE$.Map().empty()) : Predef$.MODULE$.Map().empty();
        this.FORMAT_NAME = "delta";
    }
}

