/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta;

import java.io.Serializable;
import java.util.UUID;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.delta.DeltaColumnMapping$;
import org.apache.spark.sql.delta.DeltaErrors$;
import org.apache.spark.sql.delta.RowTracking$;
import org.apache.spark.sql.delta.Snapshot;
import org.apache.spark.sql.delta.actions.Format;
import org.apache.spark.sql.delta.actions.Metadata;
import org.apache.spark.sql.delta.actions.Protocol;
import org.apache.spark.sql.types.StructField;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005%a!B\u0006\r\u0003\u00039\u0002\"\u0002\u0010\u0001\t\u0003y\u0002b\u0002\u0012\u0001\u0005\u00045\ta\t\u0005\b_\u0001\u0011\rQ\"\u0001$\u0011\u0015\u0001\u0004A\"\u00012\u0011\u0015q\u0004\u0001\"\u0003$\u0011\u0019y\u0004\u0001\"\u0001\r\u0001\"1\u0001\u000b\u0001C\u0001\u0019ECQa\u0016\u0001\u0005\u0002aCQA\u0018\u0001\u0005\u0002}Ca\u0001\u001a\u0001\u0005\u00021)'!H'bi\u0016\u0014\u0018.\u00197ju\u0016$'k\\<Ue\u0006\u001c7.\u001b8h\u0007>dW/\u001c8\u000b\u00055q\u0011!\u00023fYR\f'BA\b\u0011\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003#I\tQa\u001d9be.T!a\u0005\u000b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005)\u0012aA8sO\u000e\u00011C\u0001\u0001\u0019!\tIB$D\u0001\u001b\u0015\u0005Y\u0012!B:dC2\f\u0017BA\u000f\u001b\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012\u0001\t\t\u0003C\u0001i\u0011\u0001D\u0001\u001e\u001b\u0006#VIU%B\u0019&SV\tR0D\u001f2+VJT0O\u00036+u\f\u0015*P!V\tA\u0005\u0005\u0002&Y9\u0011aE\u000b\t\u0003Oii\u0011\u0001\u000b\u0006\u0003SY\ta\u0001\u0010:p_Rt\u0014BA\u0016\u001b\u0003\u0019\u0001&/\u001a3fM&\u0011QF\f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005-R\u0012aH'B)\u0016\u0013\u0016*\u0011'J5\u0016#ulQ(M+6suLT!N\u000b~\u0003&+\u0012$J1\u0006AR.[:tS:<W*\u001a;bI\u0006$\u0018-\u0012=dKB$\u0018n\u001c8\u0016\u0003I\u0002B!G\u001a%k%\u0011AG\u0007\u0002\n\rVt7\r^5p]F\u0002\"AN\u001e\u000f\u0005]JdBA\u00149\u0013\u0005Y\u0012B\u0001\u001e\u001b\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001P\u001f\u0003\u0013QC'o\\<bE2,'B\u0001\u001e\u001b\u0003y9WM\\3sCR,W*\u0019;fe&\fG.\u001b>fI\u000e{G.^7o\u001d\u0006lW-\u0001\u000fva\u0012\fG/Z'bi\u0016\u0014\u0018.\u00197ju\u0016$7i\u001c7v[:t\u0015-\\3\u0015\t\u0005;EJ\u0014\t\u0003\u0005\u0016k\u0011a\u0011\u0006\u0003\t2\tq!Y2uS>t7/\u0003\u0002G\u0007\nAQ*\u001a;bI\u0006$\u0018\rC\u0003I\r\u0001\u0007\u0011*\u0001\u0005qe>$xnY8m!\t\u0011%*\u0003\u0002L\u0007\nA\u0001K]8u_\u000e|G\u000eC\u0003N\r\u0001\u0007\u0011)A\u0006pY\u0012lU\r^1eCR\f\u0007\"B(\u0007\u0001\u0004\t\u0015a\u00038fo6+G/\u00193bi\u0006\f\u0001\u0007\u001e5s_^Le-T1uKJL\u0017\r\\5{K\u0012\u001cu\u000e\\;n]:\u000bW.Z\"p]\u001ad\u0017n\u0019;t/&$\bnU2iK6\fGC\u0001*V!\tI2+\u0003\u0002U5\t!QK\\5u\u0011\u00151v\u00011\u0001B\u0003!iW\r^1eCR\f\u0017!G4fi6\u000bG/\u001a:jC2L'0\u001a3D_2,XN\u001c(b[\u0016$2!\u0017/^!\rI\"\fJ\u0005\u00037j\u0011aa\u00149uS>t\u0007\"\u0002%\t\u0001\u0004I\u0005\"\u0002,\t\u0001\u0004\t\u0015\u0001I4fi6\u000bG/\u001a:jC2L'0\u001a3D_2,XN\u001c(b[\u0016|%\u000f\u00165s_^$B\u0001\n1bE\")\u0001*\u0003a\u0001\u0013\")a+\u0003a\u0001\u0003\")1-\u0003a\u0001I\u00059A/\u00192mK&#\u0017\u0001D4fi\u0006#HO]5ckR,Gc\u00014piB\u0019\u0011DW4\u0011\u0005!lW\"A5\u000b\u0005)\\\u0017aC3yaJ,7o]5p]NT!\u0001\u001c\b\u0002\u0011\r\fG/\u00197zgRL!A\\5\u0003\u0013\u0005#HO]5ckR,\u0007\"\u00029\u000b\u0001\u0004\t\u0018\u0001C:oCB\u001c\bn\u001c;\u0011\u0005\u0005\u0012\u0018BA:\r\u0005!\u0019f.\u00199tQ>$\b\"B;\u000b\u0001\u00041\u0018!\u00033bi\u00064%/Y7f!\r9\u00181\u0001\b\u0004q\u0006\u0005aBA=\u0000\u001d\tQhP\u0004\u0002|{:\u0011q\u0005`\u0005\u0002+%\u00111\u0003F\u0005\u0003#II!a\u0004\t\n\u0005ir\u0011\u0002BA\u0003\u0003\u000f\u0011\u0011\u0002R1uC\u001a\u0013\u0018-\\3\u000b\u0005ir\u0001")
public abstract class MaterializedRowTrackingColumn {
    public abstract String MATERIALIZED_COLUMN_NAME_PROP();

    public abstract String MATERIALIZED_COLUMN_NAME_PREFIX();

    public abstract Function1<String, Throwable> missingMetadataException();

    private String generateMaterializedColumnName() {
        return new StringBuilder(0).append(this.MATERIALIZED_COLUMN_NAME_PREFIX()).append(UUID.randomUUID().toString()).toString();
    }

    public Metadata updateMaterializedColumnName(Protocol protocol, Metadata oldMetadata, Metadata newMetadata) {
        if (!RowTracking$.MODULE$.isSupported(protocol)) {
            Map x$1 = (Map)newMetadata.configuration().$minus((Object)this.MATERIALIZED_COLUMN_NAME_PROP());
            String x$2 = newMetadata.copy$default$1();
            String x$3 = newMetadata.copy$default$2();
            String x$4 = newMetadata.copy$default$3();
            Format x$5 = newMetadata.copy$default$4();
            String x$6 = newMetadata.copy$default$5();
            Seq<String> x$7 = newMetadata.copy$default$6();
            Option<Object> x$8 = newMetadata.copy$default$8();
            return newMetadata.copy(x$2, x$3, x$4, x$5, x$6, x$7, (Map<String, String>)x$1, x$8);
        }
        String materializedColumnName = (String)oldMetadata.configuration().getOrElse((Object)this.MATERIALIZED_COLUMN_NAME_PROP(), (Function0 & Serializable & scala.Serializable)() -> this.generateMaterializedColumnName());
        Map x$9 = newMetadata.configuration().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.MATERIALIZED_COLUMN_NAME_PROP()), (Object)materializedColumnName));
        String x$10 = newMetadata.copy$default$1();
        String x$11 = newMetadata.copy$default$2();
        String x$12 = newMetadata.copy$default$3();
        Format x$13 = newMetadata.copy$default$4();
        String x$14 = newMetadata.copy$default$5();
        Seq<String> x$15 = newMetadata.copy$default$6();
        Option<Object> x$16 = newMetadata.copy$default$8();
        return newMetadata.copy(x$10, x$11, x$12, x$13, x$14, x$15, (Map<String, String>)x$9, x$16);
    }

    public void throwIfMaterializedColumnNameConflictsWithSchema(Metadata metadata) {
        String[] logicalColumnNames = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])metadata.schema().fields())).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.name(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        String[] physicalColumnNames = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])metadata.schema().fields())).map((Function1 & Serializable & scala.Serializable)field -> DeltaColumnMapping$.MODULE$.getPhysicalName((StructField)field), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        metadata.configuration().get((Object)this.MATERIALIZED_COLUMN_NAME_PROP()).foreach((Function1 & Serializable & scala.Serializable)columnName -> {
            MaterializedRowTrackingColumn.$anonfun$throwIfMaterializedColumnNameConflictsWithSchema$3(logicalColumnNames, physicalColumnNames, columnName);
            return BoxedUnit.UNIT;
        });
    }

    public Option<String> getMaterializedColumnName(Protocol protocol, Metadata metadata) {
        if (RowTracking$.MODULE$.isEnabled(protocol, metadata)) {
            return metadata.configuration().get((Object)this.MATERIALIZED_COLUMN_NAME_PROP());
        }
        return None$.MODULE$;
    }

    public String getMaterializedColumnNameOrThrow(Protocol protocol, Metadata metadata, String tableId) {
        return (String)this.getMaterializedColumnName(protocol, metadata).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw (Throwable)this.missingMetadataException().apply((Object)tableId);
        });
    }

    public Option<Attribute> getAttribute(Snapshot snapshot, Dataset<Row> dataFrame) {
        if (!RowTracking$.MODULE$.isEnabled(snapshot.protocol(), snapshot.metadata())) {
            return None$.MODULE$;
        }
        String materializedColumnName = this.getMaterializedColumnNameOrThrow(snapshot.protocol(), snapshot.metadata(), snapshot.deltaLog().tableId());
        LogicalPlan analyzedPlan = dataFrame.queryExecution().analyzed();
        return analyzedPlan.outputSet().view().find((Function1 & Serializable & scala.Serializable)attr -> BoxesRunTime.boxToBoolean((boolean)MaterializedRowTrackingColumn.$anonfun$getAttribute$1(materializedColumnName, attr)));
    }

    public static final /* synthetic */ void $anonfun$throwIfMaterializedColumnNameConflictsWithSchema$3(String[] logicalColumnNames$1, String[] physicalColumnNames$1, String columnName) {
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])logicalColumnNames$1)).contains((Object)columnName) || new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])physicalColumnNames$1)).contains((Object)columnName)) {
            throw DeltaErrors$.MODULE$.addingColumnWithInternalNameFailed(columnName);
        }
    }

    public static final /* synthetic */ boolean $anonfun$getAttribute$1(String materializedColumnName$1, Attribute attr) {
        String string = materializedColumnName$1;
        String string2 = attr.name();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }
}

