/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.commands;

import com.databricks.spark.util.DatabricksLogging;
import com.databricks.spark.util.MetricDefinition;
import com.databricks.spark.util.OpType;
import com.databricks.spark.util.TagDefinition;
import java.io.Serializable;
import java.util.ConcurrentModificationException;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkContext$;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.analysis.Analyzer;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.delta.DeltaConfigs$;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.DeltaOperations;
import org.apache.spark.sql.delta.DeltaOperations$Reorg$;
import org.apache.spark.sql.delta.DeltaOptions;
import org.apache.spark.sql.delta.OptimisticTransaction;
import org.apache.spark.sql.delta.RowTracking$;
import org.apache.spark.sql.delta.Snapshot;
import org.apache.spark.sql.delta.actions.Action;
import org.apache.spark.sql.delta.actions.AddFile;
import org.apache.spark.sql.delta.actions.DeletionVectorDescriptor;
import org.apache.spark.sql.delta.actions.FileAction;
import org.apache.spark.sql.delta.actions.RemoveFile;
import org.apache.spark.sql.delta.actions.SetTransaction;
import org.apache.spark.sql.delta.catalog.DeltaTableV2;
import org.apache.spark.sql.delta.commands.ClusteringStrategy;
import org.apache.spark.sql.delta.commands.DeltaCommand;
import org.apache.spark.sql.delta.commands.DeltaOptimizeContext;
import org.apache.spark.sql.delta.commands.DeltaReorgOperation;
import org.apache.spark.sql.delta.commands.OptimizeTableStrategy;
import org.apache.spark.sql.delta.commands.OptimizeTableStrategy$;
import org.apache.spark.sql.delta.commands.ZOrderStrategy;
import org.apache.spark.sql.delta.commands.optimize.DeletionVectorStats;
import org.apache.spark.sql.delta.commands.optimize.FileSizeStatsWithHistogram;
import org.apache.spark.sql.delta.commands.optimize.FileSizeStatsWithHistogram$;
import org.apache.spark.sql.delta.commands.optimize.OptimizeStats;
import org.apache.spark.sql.delta.commands.optimize.OptimizeStats$;
import org.apache.spark.sql.delta.constraints.Constraint;
import org.apache.spark.sql.delta.files.SQLMetricsReporting;
import org.apache.spark.sql.delta.metering.DeltaLogging;
import org.apache.spark.sql.delta.skipping.MultiDimClustering$;
import org.apache.spark.sql.delta.skipping.clustering.ClusteredTableUtils$;
import org.apache.spark.sql.delta.skipping.clustering.ClusteringColumnInfo$;
import org.apache.spark.sql.delta.sources.DeltaSQLConf$;
import org.apache.spark.sql.delta.util.DeltaProgressReporter;
import org.apache.spark.sql.execution.datasources.HadoopFsRelation;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.execution.metric.SQLMetrics$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.SystemClock;
import org.apache.spark.util.ThreadUtils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.MapLike;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005}h\u0001B\r\u001b\u0001\u001dB\u0001b\u000f\u0001\u0003\u0002\u0003\u0006I\u0001\u0010\u0005\t\u0001\u0002\u0011\t\u0011)A\u0005\u0003\"AQ\t\u0001B\u0001B\u0003%a\t\u0003\u0005[\u0001\t\u0005\t\u0015!\u0003\\\u0011!!\u0007A!A!\u0002\u0013)\u0007\u0002\u00035\u0001\u0005\u0003\u0005\u000b\u0011B5\t\u000b1\u0004A\u0011A7\t\u000fU\u0004!\u0019!C\u0005m\"1!\u0010\u0001Q\u0001\n]Dqa\u001f\u0001C\u0002\u0013%A\u0010C\u0004\u0002\u0002\u0001\u0001\u000b\u0011B?\t\u0013\u0005\r\u0001A1A\u0005\n\u0005\u0015\u0001bBA\u0004\u0001\u0001\u0006I!\u001a\u0005\n\u0003\u0013\u0001!\u0019!C\u0005\u0003\u000bAq!a\u0003\u0001A\u0003%Q\rC\u0005\u0002\u000e\u0001\u0011\r\u0011\"\u0003\u0002\u0010!9\u0011\u0011\u0003\u0001!\u0002\u0013Y\u0006bBA\n\u0001\u0011\u0005\u0011Q\u0003\u0005\b\u0003?\u0001A\u0011BA\u0011\u0011\u001d\t\t\u0005\u0001C\u0005\u0003\u0007Bq!a\u0016\u0001\t\u0013\tI\u0006C\u0004\u0002r\u0001!I!a\u001d\t\u000f\u0005=\u0007\u0001\"\u0003\u0002R\"9\u00111\u001b\u0001\u0005\n\u0005U'\u0001E(qi&l\u0017N_3Fq\u0016\u001cW\u000f^8s\u0015\tYB$\u0001\u0005d_6l\u0017M\u001c3t\u0015\tib$A\u0003eK2$\u0018M\u0003\u0002 A\u0005\u00191/\u001d7\u000b\u0005\u0005\u0012\u0013!B:qCJ\\'BA\u0012%\u0003\u0019\t\u0007/Y2iK*\tQ%A\u0002pe\u001e\u001c\u0001aE\u0003\u0001Q9\u0012\u0004\b\u0005\u0002*Y5\t!FC\u0001,\u0003\u0015\u00198-\u00197b\u0013\ti#F\u0001\u0004B]f\u0014VM\u001a\t\u0003_Aj\u0011AG\u0005\u0003ci\u0011A\u0002R3mi\u0006\u001cu.\\7b]\u0012\u0004\"a\r\u001c\u000e\u0003QR!!\u000e\u000f\u0002\u000b\u0019LG.Z:\n\u0005]\"$aE*R\u00196+GO]5dgJ+\u0007o\u001c:uS:<\u0007CA\u0015:\u0013\tQ$F\u0001\u0007TKJL\u0017\r\\5{C\ndW-\u0001\u0007ta\u0006\u00148nU3tg&|g\u000e\u0005\u0002>}5\ta$\u0003\u0002@=\ta1\u000b]1sWN+7o]5p]\u0006\u0019A\u000f\u001f8\u0011\u0005\t\u001bU\"\u0001\u000f\n\u0005\u0011c\"!F(qi&l\u0017n\u001d;jGR\u0013\u0018M\\:bGRLwN\\\u0001\u0013a\u0006\u0014H/\u001b;j_:\u0004&/\u001a3jG\u0006$X\rE\u0002H\u001fJs!\u0001S'\u000f\u0005%cU\"\u0001&\u000b\u0005-3\u0013A\u0002\u001fs_>$h(C\u0001,\u0013\tq%&A\u0004qC\u000e\\\u0017mZ3\n\u0005A\u000b&aA*fc*\u0011aJ\u000b\t\u0003'bk\u0011\u0001\u0016\u0006\u0003+Z\u000b1\"\u001a=qe\u0016\u001c8/[8og*\u0011qKH\u0001\tG\u0006$\u0018\r\\=ti&\u0011\u0011\f\u0016\u0002\u000b\u000bb\u0004(/Z:tS>t\u0017a\u0004>Pe\u0012,'OQ=D_2,XN\\:\u0011\u0007\u001d{E\f\u0005\u0002^C:\u0011al\u0018\t\u0003\u0013*J!\u0001\u0019\u0016\u0002\rA\u0013X\rZ3g\u0013\t\u00117M\u0001\u0004TiJLgn\u001a\u0006\u0003A*\nQ\"[:BkR|7i\\7qC\u000e$\bCA\u0015g\u0013\t9'FA\u0004C_>dW-\u00198\u0002\u001f=\u0004H/[7ju\u0016\u001cuN\u001c;fqR\u0004\"a\f6\n\u0005-T\"\u0001\u0006#fYR\fw\n\u001d;j[&TXmQ8oi\u0016DH/\u0001\u0004=S:LGO\u0010\u000b\b]>\u0004\u0018O]:u!\ty\u0003\u0001C\u0003<\u000f\u0001\u0007A\bC\u0003A\u000f\u0001\u0007\u0011\tC\u0003F\u000f\u0001\u0007a\tC\u0003[\u000f\u0001\u00071\fC\u0003e\u000f\u0001\u0007Q\rC\u0003i\u000f\u0001\u0007\u0011.\u0001\tpaRLW.\u001b>f'R\u0014\u0018\r^3hsV\tq\u000f\u0005\u00020q&\u0011\u0011P\u0007\u0002\u0016\u001fB$\u0018.\\5{KR\u000b'\r\\3TiJ\fG/Z4z\u0003Ey\u0007\u000f^5nSj,7\u000b\u001e:bi\u0016<\u0017\u0010I\u0001\u0013_B,'/\u0019;j_:$\u0016.\\3ti\u0006l\u0007/F\u0001~!\tIc0\u0003\u0002\u0000U\t!Aj\u001c8h\u0003My\u0007/\u001a:bi&|g\u000eV5nKN$\u0018-\u001c9!\u0003AI7o\u00117vgR,'/\u001a3UC\ndW-F\u0001f\u0003EI7o\u00117vgR,'/\u001a3UC\ndW\rI\u0001\u0015SNlU\u000f\u001c;j\t&l7\t\\;ti\u0016\u0014\u0018N\\4\u0002+%\u001cX*\u001e7uS\u0012KWn\u00117vgR,'/\u001b8hA\u0005\t2\r\\;ti\u0016\u0014\u0018N\\4D_2,XN\\:\u0016\u0003m\u000b!c\u00197vgR,'/\u001b8h\u0007>dW/\u001c8tA\u0005Aq\u000e\u001d;j[&TX\r\u0006\u0002\u0002\u0018A!qiTA\r!\ri\u00141D\u0005\u0004\u0003;q\"a\u0001*po\u00069b-\u001b7uKJ\u001c\u0015M\u001c3jI\u0006$XMR5mK2K7\u000f\u001e\u000b\t\u0003G\t\t$!\u000e\u0002@A!qiTA\u0013!\u0011\t9#!\f\u000e\u0005\u0005%\"bAA\u00169\u00059\u0011m\u0019;j_:\u001c\u0018\u0002BA\u0018\u0003S\u0011q!\u00113e\r&dW\r\u0003\u0004\u00024M\u0001\r!`\u0001\f[&tg)\u001b7f'&TX\rC\u0004\u00028M\u0001\r!!\u000f\u0002'5\f\u0007\u0010R3mKR,GMU8xgJ\u000bG/[8\u0011\u0007%\nY$C\u0002\u0002>)\u0012a\u0001R8vE2,\u0007BB\u001b\u0014\u0001\u0004\t\u0019#\u0001\nhe>,\bOR5mKNLe\u000e^8CS:\u001cH\u0003BA#\u0003'\u0002BaR(\u0002HA9\u0011&!\u0013\u0002N\u0005\r\u0012bAA&U\t1A+\u001e9mKJ\u0002R!XA(9rK1!!\u0015d\u0005\ri\u0015\r\u001d\u0005\b\u0003+\"\u0002\u0019AA#\u0003M\u0001\u0018M\u001d;ji&|gn\u001d+p\u0007>l\u0007/Y2u\u0003E\u0011XO\\(qi&l\u0017N_3CS:TuN\u0019\u000b\u000b\u00037\n\u0019'!\u001a\u0002j\u00055\u0004\u0003B$P\u0003;\u0002B!a\n\u0002`%!\u0011\u0011MA\u0015\u0005)1\u0015\u000e\\3BGRLwN\u001c\u0005\u0006\u0001V\u0001\r!\u0011\u0005\b\u0003O*\u0002\u0019AA'\u0003%\u0001\u0018M\u001d;ji&|g\u000eC\u0004\u0002lU\u0001\r!a\t\u0002\u0007\tLg\u000e\u0003\u0004\u0002pU\u0001\r!`\u0001\f[\u0006Dh)\u001b7f'&TX-\u0001\bd_6l\u0017\u000e^!oIJ+GO]=\u0015\u0015\u0005U\u0014qQAE\u0003_\u000bI\f\u0006\u0003\u0002x\u0005u\u0004cA\u0015\u0002z%\u0019\u00111\u0010\u0016\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003\u007f2\u0002\u0019AAA\u0003\u00051\u0007#B\u0015\u0002\u0004\u0006+\u0017bAACU\tIa)\u001e8di&|g.\r\u0005\u0006\u0001Z\u0001\r!\u0011\u0005\b\u0003\u00173\u0002\u0019AAG\u0003Ey\u0007\u000f^5nSj,w\n]3sCRLwN\u001c\t\u0005\u0003\u001f\u000bIK\u0004\u0003\u0002\u0012\u0006\u0015f\u0002BAJ\u0003GsA!!&\u0002\":!\u0011qSAP\u001d\u0011\tI*!(\u000f\u0007%\u000bY*C\u0001&\u0013\t\u0019C%\u0003\u0002\"E%\u0011q\u0004I\u0005\u0003;yI1!a*\u001d\u0003=!U\r\u001c;b\u001fB,'/\u0019;j_:\u001c\u0018\u0002BAV\u0003[\u0013\u0011b\u00149fe\u0006$\u0018n\u001c8\u000b\u0007\u0005\u001dF\u0004C\u0004\u0002,Y\u0001\r!!-\u0011\t\u001d{\u00151\u0017\t\u0005\u0003O\t),\u0003\u0003\u00028\u0006%\"AB!di&|g\u000eC\u0004\u0002<Z\u0001\r!!0\u0002\u000f5,GO]5dgB1Q,a\u0014]\u0003\u007f\u0003B!!1\u0002L6\u0011\u00111\u0019\u0006\u0005\u0003\u000b\f9-\u0001\u0004nKR\u0014\u0018n\u0019\u0006\u0004\u0003\u0013t\u0012!C3yK\u000e,H/[8o\u0013\u0011\ti-a1\u0003\u0013M\u000bF*T3ue&\u001c\u0017\u0001D4fi>\u0003XM]1uS>tGCAAG\u00035\u0019'/Z1uK6+GO]5dgRQ\u0011QXAl\u0003G\f9/a=\t\u000f\u0005e\u0007\u00041\u0001\u0002\\\u0006a1\u000f]1sW\u000e{g\u000e^3yiB!\u0011Q\\Ap\u001b\u0005\u0001\u0013bAAqA\ta1\u000b]1sW\u000e{g\u000e^3yi\"9\u0011Q\u001d\rA\u0002\u0005\r\u0012AC1eI\u0016$g)\u001b7fg\"9\u0011\u0011\u001e\rA\u0002\u0005-\u0018\u0001\u0004:f[>4X\r\u001a$jY\u0016\u001c\b\u0003B$P\u0003[\u0004B!a\n\u0002p&!\u0011\u0011_A\u0015\u0005)\u0011V-\\8wK\u001aKG.\u001a\u0005\b\u0003kD\u0002\u0019AA|\u0003)\u0011X-\\8wK\u0012$ek\u001d\t\u0005\u000f>\u000bI\u0010\u0005\u0003\u0002(\u0005m\u0018\u0002BA\u007f\u0003S\u0011\u0001\u0004R3mKRLwN\u001c,fGR|'\u000fR3tGJL\u0007\u000f^8s\u0001")
public class OptimizeExecutor
implements DeltaCommand,
SQLMetricsReporting,
scala.Serializable {
    private final SparkSession sparkSession;
    private final OptimisticTransaction txn;
    private final Seq<Expression> partitionPredicate;
    private final Seq<String> zOrderByColumns;
    private final boolean isAutoCompact;
    private final DeltaOptimizeContext optimizeContext;
    private final OptimizeTableStrategy org$apache$spark$sql$delta$commands$OptimizeExecutor$$optimizeStrategy;
    private final long operationTimestamp;
    private final boolean isClusteredTable;
    private final boolean isMultiDimClustering;
    private final Seq<String> clusteringColumns;
    private Map<String, SQLMetric> org$apache$spark$sql$delta$files$SQLMetricsReporting$$operationSQLMetrics;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    @Override
    public void registerSQLMetrics(SparkSession spark, Map<String, SQLMetric> metrics) {
        SQLMetricsReporting.registerSQLMetrics$(this, spark, metrics);
    }

    @Override
    public Map<String, String> getMetricsForOperation(DeltaOperations.Operation operation) {
        return SQLMetricsReporting.getMetricsForOperation$(this, operation);
    }

    @Override
    public Option<SQLMetric> getMetric(String name) {
        return SQLMetricsReporting.getMetric$(this, name);
    }

    @Override
    public Seq<Expression> parsePredicates(SparkSession spark, String predicate) {
        return DeltaCommand.parsePredicates$(this, spark, predicate);
    }

    @Override
    public void verifyPartitionPredicates(SparkSession spark, Seq<String> partitionColumns, Seq<Expression> predicates) {
        DeltaCommand.verifyPartitionPredicates$(this, spark, partitionColumns, predicates);
    }

    @Override
    public Map<String, AddFile> generateCandidateFileMap(Path basePath, Seq<AddFile> candidateFiles) {
        return DeltaCommand.generateCandidateFileMap$(this, basePath, candidateFiles);
    }

    @Override
    public Seq<RemoveFile> removeFilesFromPaths(DeltaLog deltaLog, Map<String, AddFile> nameToAddFileMap, Seq<String> filesToRewrite, long operationTimestamp) {
        return DeltaCommand.removeFilesFromPaths$(this, deltaLog, nameToAddFileMap, filesToRewrite, operationTimestamp);
    }

    @Override
    public HadoopFsRelation buildBaseRelation(SparkSession spark, OptimisticTransaction txn, String actionType, Path rootPath, Seq<String> inputLeafFiles, Map<String, AddFile> nameToAddFileMap) {
        return DeltaCommand.buildBaseRelation$(this, spark, txn, actionType, rootPath, inputLeafFiles, nameToAddFileMap);
    }

    @Override
    public AddFile getTouchedFile(Path basePath, String escapedFilePath, Map<String, AddFile> nameToAddFileMap) {
        return DeltaCommand.getTouchedFile$(this, basePath, escapedFilePath, nameToAddFileMap);
    }

    @Override
    public LogicalPlan resolveIdentifier(Analyzer analyzer, TableIdentifier identifier) {
        return DeltaCommand.resolveIdentifier$(this, analyzer, identifier);
    }

    @Override
    public boolean isCatalogTable(Analyzer analyzer, TableIdentifier tableIdent) {
        return DeltaCommand.isCatalogTable$(this, analyzer, tableIdent);
    }

    @Override
    public boolean isPathIdentifier(TableIdentifier tableIdent) {
        return DeltaCommand.isPathIdentifier$(this, tableIdent);
    }

    @Override
    public DeltaLog getDeltaLog(SparkSession spark, Option<String> path, Option<TableIdentifier> tableIdentifier, String operationName, Map<String, String> hadoopConf) {
        return DeltaCommand.getDeltaLog$(this, spark, path, tableIdentifier, operationName, hadoopConf);
    }

    @Override
    public Map<String, String> getDeltaLog$default$5() {
        return DeltaCommand.getDeltaLog$default$5$(this);
    }

    @Override
    public void sendDriverMetrics(SparkSession spark, Map<String, SQLMetric> metrics) {
        DeltaCommand.sendDriverMetrics$(this, spark, metrics);
    }

    @Override
    public DeltaTableV2 getDeltaTable(LogicalPlan target, String cmd) {
        return DeltaCommand.getDeltaTable$(this, target, cmd);
    }

    @Override
    public Option<CatalogTable> getTableCatalogTable(LogicalPlan target, String cmd) {
        return DeltaCommand.getTableCatalogTable$(this, target, cmd);
    }

    @Override
    public Tuple2<Option<TableIdentifier>, Option<String>> getDeltaTablePathOrIdentifier(LogicalPlan target, String cmd) {
        return DeltaCommand.getDeltaTablePathOrIdentifier$(this, target, cmd);
    }

    @Override
    public Tuple2<Option<TableIdentifier>, Option<String>> getTablePathOrIdentifier(LogicalPlan target, String cmd) {
        return DeltaCommand.getTablePathOrIdentifier$(this, target, cmd);
    }

    @Override
    public boolean hasBeenExecuted(OptimisticTransaction txn, SparkSession sparkSession, Option<DeltaOptions> options) {
        return DeltaCommand.hasBeenExecuted$(this, txn, sparkSession, options);
    }

    @Override
    public Option<DeltaOptions> hasBeenExecuted$default$3() {
        return DeltaCommand.hasBeenExecuted$default$3$(this);
    }

    @Override
    public Option<SetTransaction> createSetTransaction(SparkSession sparkSession, DeltaLog deltaLog, Option<DeltaOptions> options) {
        return DeltaCommand.createSetTransaction$(this, sparkSession, deltaLog, options);
    }

    @Override
    public Option<DeltaOptions> createSetTransaction$default$3() {
        return DeltaCommand.createSetTransaction$default$3$(this);
    }

    @Override
    public void recordDeltaEvent(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Object data, Option<Path> path) {
        DeltaLogging.recordDeltaEvent$(this, deltaLog, opType, tags, data, path);
    }

    @Override
    public Map<TagDefinition, String> recordDeltaEvent$default$3() {
        return DeltaLogging.recordDeltaEvent$default$3$(this);
    }

    @Override
    public Object recordDeltaEvent$default$4() {
        return DeltaLogging.recordDeltaEvent$default$4$(this);
    }

    @Override
    public Option<Path> recordDeltaEvent$default$5() {
        return DeltaLogging.recordDeltaEvent$default$5$(this);
    }

    @Override
    public <A> A recordDeltaOperationForTablePath(String tablePath, String opType, Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperationForTablePath$(this, tablePath, opType, tags, thunk);
    }

    @Override
    public <A> Map<TagDefinition, String> recordDeltaOperationForTablePath$default$3() {
        return DeltaLogging.recordDeltaOperationForTablePath$default$3$(this);
    }

    @Override
    public <A> A recordDeltaOperation(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperation$(this, deltaLog, opType, tags, thunk);
    }

    @Override
    public <A> Map<TagDefinition, String> recordDeltaOperation$default$3() {
        return DeltaLogging.recordDeltaOperation$default$3$(this);
    }

    @Override
    public void deltaAssert(Function0<Object> check, String name, String msg, DeltaLog deltaLog, Object data, Option<Path> path) {
        DeltaLogging.deltaAssert$(this, check, name, msg, deltaLog, data, path);
    }

    @Override
    public DeltaLog deltaAssert$default$4() {
        return DeltaLogging.deltaAssert$default$4$(this);
    }

    @Override
    public Object deltaAssert$default$5() {
        return DeltaLogging.deltaAssert$default$5$(this);
    }

    @Override
    public Option<Path> deltaAssert$default$6() {
        return DeltaLogging.deltaAssert$default$6$(this);
    }

    @Override
    public <T> T recordFrameProfile(String group, String name, Function0<T> thunk) {
        return (T)DeltaLogging.recordFrameProfile$(this, group, name, thunk);
    }

    @Override
    public Map<TagDefinition, String> getCommonTags(DeltaLog deltaLog, String tahoeId) {
        return DeltaLogging.getCommonTags$(this, deltaLog, tahoeId);
    }

    @Override
    public Map<String, Object> getErrorData(Throwable e) {
        return DeltaLogging.getErrorData$(this, e);
    }

    @Override
    public void logConsole(String line) {
        DatabricksLogging.logConsole$(this, line);
    }

    @Override
    public void recordUsage(MetricDefinition metric, double quantity, Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public Map<TagDefinition, String> recordUsage$default$3() {
        return DatabricksLogging.recordUsage$default$3$(this);
    }

    @Override
    public String recordUsage$default$4() {
        return DatabricksLogging.recordUsage$default$4$(this);
    }

    @Override
    public boolean recordUsage$default$5() {
        return DatabricksLogging.recordUsage$default$5$(this);
    }

    @Override
    public boolean recordUsage$default$6() {
        return DatabricksLogging.recordUsage$default$6$(this);
    }

    @Override
    public boolean recordUsage$default$7() {
        return DatabricksLogging.recordUsage$default$7$(this);
    }

    @Override
    public void recordEvent(MetricDefinition metric, Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordEvent$(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public Map<TagDefinition, String> recordEvent$default$2() {
        return DatabricksLogging.recordEvent$default$2$(this);
    }

    @Override
    public String recordEvent$default$3() {
        return DatabricksLogging.recordEvent$default$3$(this);
    }

    @Override
    public boolean recordEvent$default$4() {
        return DatabricksLogging.recordEvent$default$4$(this);
    }

    @Override
    public <S> S recordOperation(OpType opType, String opTarget, Map<TagDefinition, String> extraTags, boolean isSynchronous, boolean alwaysRecordStats, boolean allowAuthTags, boolean killJvmIfStuck, MetricDefinition outputMetric, boolean silent, Function0<S> thunk) {
        return (S)DatabricksLogging.recordOperation$(this, opType, opTarget, extraTags, isSynchronous, alwaysRecordStats, allowAuthTags, killJvmIfStuck, outputMetric, silent, thunk);
    }

    @Override
    public <S> String recordOperation$default$2() {
        return DatabricksLogging.recordOperation$default$2$(this);
    }

    @Override
    public <S> boolean recordOperation$default$4() {
        return DatabricksLogging.recordOperation$default$4$(this);
    }

    @Override
    public <S> boolean recordOperation$default$5() {
        return DatabricksLogging.recordOperation$default$5$(this);
    }

    @Override
    public <S> boolean recordOperation$default$6() {
        return DatabricksLogging.recordOperation$default$6$(this);
    }

    @Override
    public <S> boolean recordOperation$default$7() {
        return DatabricksLogging.recordOperation$default$7$(this);
    }

    @Override
    public <S> MetricDefinition recordOperation$default$8() {
        return DatabricksLogging.recordOperation$default$8$(this);
    }

    @Override
    public <S> boolean recordOperation$default$9() {
        return DatabricksLogging.recordOperation$default$9$(this);
    }

    @Override
    public void recordProductUsage(MetricDefinition metric, double quantity, Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordProductUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public Map<TagDefinition, String> recordProductUsage$default$3() {
        return DatabricksLogging.recordProductUsage$default$3$(this);
    }

    @Override
    public String recordProductUsage$default$4() {
        return DatabricksLogging.recordProductUsage$default$4$(this);
    }

    @Override
    public boolean recordProductUsage$default$5() {
        return DatabricksLogging.recordProductUsage$default$5$(this);
    }

    @Override
    public boolean recordProductUsage$default$6() {
        return DatabricksLogging.recordProductUsage$default$6$(this);
    }

    @Override
    public boolean recordProductUsage$default$7() {
        return DatabricksLogging.recordProductUsage$default$7$(this);
    }

    @Override
    public void recordProductEvent(MetricDefinition metric, Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordProductEvent$(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public Map<TagDefinition, String> recordProductEvent$default$2() {
        return DatabricksLogging.recordProductEvent$default$2$(this);
    }

    @Override
    public String recordProductEvent$default$3() {
        return DatabricksLogging.recordProductEvent$default$3$(this);
    }

    @Override
    public boolean recordProductEvent$default$4() {
        return DatabricksLogging.recordProductEvent$default$4$(this);
    }

    @Override
    public <T> T withStatusCode(String statusCode, String defaultMessage, Map<String, Object> data, Function0<T> body) {
        return (T)DeltaProgressReporter.withStatusCode$(this, statusCode, defaultMessage, data, body);
    }

    @Override
    public <T> Map<String, Object> withStatusCode$default$3() {
        return DeltaProgressReporter.withStatusCode$default$3$(this);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    @Override
    public Map<String, SQLMetric> org$apache$spark$sql$delta$files$SQLMetricsReporting$$operationSQLMetrics() {
        return this.org$apache$spark$sql$delta$files$SQLMetricsReporting$$operationSQLMetrics;
    }

    @Override
    public void org$apache$spark$sql$delta$files$SQLMetricsReporting$$operationSQLMetrics_$eq(Map<String, SQLMetric> x$1) {
        this.org$apache$spark$sql$delta$files$SQLMetricsReporting$$operationSQLMetrics = x$1;
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public OptimizeTableStrategy org$apache$spark$sql$delta$commands$OptimizeExecutor$$optimizeStrategy() {
        return this.org$apache$spark$sql$delta$commands$OptimizeExecutor$$optimizeStrategy;
    }

    private long operationTimestamp() {
        return this.operationTimestamp;
    }

    private boolean isClusteredTable() {
        return this.isClusteredTable;
    }

    private boolean isMultiDimClustering() {
        return this.isMultiDimClustering;
    }

    private Seq<String> clusteringColumns() {
        return this.clusteringColumns;
    }

    public Seq<Row> optimize() {
        Seq seq;
        Object object = new Object();
        try {
            seq = (Seq)this.recordDeltaOperation(this.txn.deltaLog(), "delta.optimize", this.recordDeltaOperation$default$3(), (Function0 & Serializable & scala.Serializable)() -> {
                Seq<AddFile> seq;
                long minFileSize = BoxesRunTime.unboxToLong((Object)$this.optimizeContext.minFileSize().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToLong((Object)$this.sparkSession.sessionState().conf().getConf(DeltaSQLConf$.MODULE$.DELTA_OPTIMIZE_MIN_FILE_SIZE()))));
                long maxFileSize = BoxesRunTime.unboxToLong((Object)$this.optimizeContext.maxFileSize().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToLong((Object)$this.sparkSession.sessionState().conf().getConf(DeltaSQLConf$.MODULE$.DELTA_OPTIMIZE_MAX_FILE_SIZE()))));
                double maxDeletedRowsRatio = BoxesRunTime.unboxToDouble((Object)$this.optimizeContext.maxDeletedRowsRatio().getOrElse((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToDouble((Object)$this.sparkSession.sessionState().conf().getConf(DeltaSQLConf$.MODULE$.DELTA_OPTIMIZE_MAX_DELETED_ROWS_RATIO()))));
                Seq<AddFile> candidateFiles = $this.txn.filterFiles($this.partitionPredicate, true);
                StructType partitionSchema = $this.txn.metadata().partitionSchema();
                Option<DeltaReorgOperation> option = $this.optimizeContext.reorg();
                if (option instanceof Some) {
                    Some some = (Some)option;
                    DeltaReorgOperation reorgOperation = (DeltaReorgOperation)some.value();
                    seq = reorgOperation.filterFilesToReorg($this.txn.snapshot(), candidateFiles);
                } else if (None$.MODULE$.equals(option)) {
                    seq = this.filterCandidateFileList(minFileSize, maxDeletedRowsRatio, candidateFiles);
                } else {
                    throw new MatchError(option);
                }
                Seq<AddFile> filesToProcess = seq;
                Seq partitionsToCompact = filesToProcess.groupBy((Function1 & Serializable & scala.Serializable)x$4 -> x$4.partitionValues()).toSeq();
                Seq<Tuple2<Map<String, String>, Seq<AddFile>>> jobs = this.groupFilesIntoBins((Seq<Tuple2<Map<String, String>, Seq<AddFile>>>)partitionsToCompact);
                int maxThreads = BoxesRunTime.unboxToInt((Object)$this.sparkSession.sessionState().conf().getConf(DeltaSQLConf$.MODULE$.DELTA_OPTIMIZE_MAX_THREADS()));
                Seq updates = (Seq)ThreadUtils$.MODULE$.parmap(jobs, "OptimizeJob", maxThreads, (Function1 & Serializable & scala.Serializable)partitionBinGroup -> this.runOptimizeBinJob($this.txn, (Map<String, String>)((Map)partitionBinGroup._1()), (Seq<AddFile>)((Seq)partitionBinGroup._2()), maxFileSize)).flatten((Function1)Predef$.MODULE$.$conforms());
                Seq addedFiles = (Seq)updates.collect((PartialFunction)new scala.Serializable(null){
                    public static final long serialVersionUID = 0L;

                    public final <A1 extends FileAction, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        A1 A1 = x1;
                        if (A1 instanceof AddFile) {
                            AddFile addFile = (AddFile)A1;
                            return (B1)addFile;
                        }
                        return (B1)function1.apply(x1);
                    }

                    public final boolean isDefinedAt(FileAction x1) {
                        FileAction fileAction = x1;
                        return fileAction instanceof AddFile;
                    }
                }, Seq$.MODULE$.canBuildFrom());
                Seq removedFiles = (Seq)updates.collect((PartialFunction)new scala.Serializable(null){
                    public static final long serialVersionUID = 0L;

                    public final <A1 extends FileAction, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                        A1 A1 = x2;
                        if (A1 instanceof RemoveFile) {
                            RemoveFile removeFile = (RemoveFile)A1;
                            return (B1)removeFile;
                        }
                        return (B1)function1.apply(x2);
                    }

                    public final boolean isDefinedAt(FileAction x2) {
                        FileAction fileAction = x2;
                        return fileAction instanceof RemoveFile;
                    }
                }, Seq$.MODULE$.canBuildFrom());
                Seq removedDVs = ((SeqLike)((TraversableLike)filesToProcess.filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)OptimizeExecutor.$anonfun$optimize$7(x$5)))).map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.deletionVector(), Seq$.MODULE$.canBuildFrom())).toSeq();
                if (addedFiles.size() > 0) {
                    Map<String, SQLMetric> metrics = this.createMetrics($this.sparkSession.sparkContext(), (Seq<AddFile>)addedFiles, (Seq<RemoveFile>)removedFiles, (Seq<DeletionVectorDescriptor>)removedDVs);
                    this.commitAndRetry($this.txn, this.getOperation(), (Seq<Action>)updates, metrics, (Function1<OptimisticTransaction, Object>)(Function1 & Serializable & scala.Serializable)newTxn -> BoxesRunTime.boxToBoolean((boolean)OptimizeExecutor.$anonfun$optimize$9(this, candidateFiles, partitionSchema, newTxn)));
                }
                OptimizeStats optimizeStats = new OptimizeStats(OptimizeStats$.MODULE$.apply$default$1(), OptimizeStats$.MODULE$.apply$default$2(), OptimizeStats$.MODULE$.apply$default$3(), OptimizeStats$.MODULE$.apply$default$4(), OptimizeStats$.MODULE$.apply$default$5(), OptimizeStats$.MODULE$.apply$default$6(), OptimizeStats$.MODULE$.apply$default$7(), OptimizeStats$.MODULE$.apply$default$8(), OptimizeStats$.MODULE$.apply$default$9(), OptimizeStats$.MODULE$.apply$default$10(), OptimizeStats$.MODULE$.apply$default$11(), OptimizeStats$.MODULE$.apply$default$12(), OptimizeStats$.MODULE$.apply$default$13(), OptimizeStats$.MODULE$.apply$default$14(), OptimizeStats$.MODULE$.apply$default$15(), OptimizeStats$.MODULE$.apply$default$16(), OptimizeStats$.MODULE$.apply$default$17(), OptimizeStats$.MODULE$.apply$default$18(), OptimizeStats$.MODULE$.apply$default$19());
                optimizeStats.addedFilesSizeStats().merge((Seq<FileAction>)addedFiles);
                optimizeStats.removedFilesSizeStats().merge((Seq<FileAction>)removedFiles);
                optimizeStats.numPartitionsOptimized_$eq(((SeqLike)((SeqLike)jobs.map((Function1 & Serializable & scala.Serializable)j -> (Map)j._1(), Seq$.MODULE$.canBuildFrom())).distinct()).size());
                optimizeStats.numBatches_$eq(jobs.size());
                optimizeStats.totalConsideredFiles_$eq(candidateFiles.size());
                optimizeStats.totalFilesSkipped_$eq(optimizeStats.totalConsideredFiles() - (long)removedFiles.size());
                optimizeStats.totalClusterParallelism_$eq($this.sparkSession.sparkContext().defaultParallelism());
                int numTableColumns = $this.txn.snapshot().metadata().schema().size();
                optimizeStats.numTableColumns_$eq(numTableColumns);
                optimizeStats.numTableColumnsWithStats_$eq(RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(BoxesRunTime.unboxToInt((Object)DeltaConfigs$.MODULE$.DATA_SKIPPING_NUM_INDEXED_COLS().fromMetaData($this.txn.snapshot().metadata()))), numTableColumns));
                if (removedDVs.size() > 0) {
                    optimizeStats.deletionVectorStats_$eq((Option<DeletionVectorStats>)new Some((Object)new DeletionVectorStats(removedDVs.size(), BoxesRunTime.unboxToLong((Object)((TraversableOnce)removedDVs.map((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToLong((long)x$9.cardinality()), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)))));
                }
                this.org$apache$spark$sql$delta$commands$OptimizeExecutor$$optimizeStrategy().updateOptimizeStats(optimizeStats, (Seq<RemoveFile>)removedFiles, jobs);
                throw new NonLocalReturnControl(object, (Object)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.txn.deltaLog().dataPath().toString(), optimizeStats.toOptimizeMetrics()})), (List)Nil$.MODULE$));
            });
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                seq = (Seq)ex.value();
            }
            throw ex;
        }
        return seq;
    }

    private Seq<AddFile> filterCandidateFileList(long minFileSize, double maxDeletedRowsRatio, Seq<AddFile> files) {
        if (this.isMultiDimClustering()) {
            return files;
        }
        return (Seq)files.filter((Function1 & Serializable & scala.Serializable)addFile -> BoxesRunTime.boxToBoolean((boolean)OptimizeExecutor.$anonfun$filterCandidateFileList$2(minFileSize, maxDeletedRowsRatio, addFile)));
    }

    private Seq<Tuple2<Map<String, String>, Seq<AddFile>>> groupFilesIntoBins(Seq<Tuple2<Map<String, String>, Seq<AddFile>>> partitionsToCompact) {
        long maxBinSize = this.org$apache$spark$sql$delta$commands$OptimizeExecutor$$optimizeStrategy().maxBinSize();
        return (Seq)partitionsToCompact.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Map partition = (Map)tuple2._1();
                Seq files = (Seq)tuple2._2();
                ArrayBuffer bins = new ArrayBuffer();
                ArrayBuffer currentBin = new ArrayBuffer();
                LongRef currentBinSize = LongRef.create((long)0L);
                Seq<AddFile> preparedFiles = this.org$apache$spark$sql$delta$commands$OptimizeExecutor$$optimizeStrategy().prepareFilesPerPartition((Seq<AddFile>)files);
                preparedFiles.foreach((Function1 & Serializable & scala.Serializable)file -> {
                    OptimizeExecutor.$anonfun$groupFilesIntoBins$2(currentBinSize, maxBinSize, bins, currentBin, file);
                    return BoxedUnit.UNIT;
                });
                Object object = currentBin.nonEmpty() ? bins.$plus$eq((Object)currentBin.toVector()) : BoxedUnit.UNIT;
                return (ArrayBuffer)((TraversableLike)bins.filter((Function1 & Serializable & scala.Serializable)bin -> BoxesRunTime.boxToBoolean((boolean)OptimizeExecutor.$anonfun$groupFilesIntoBins$3(this, bin)))).map((Function1 & Serializable & scala.Serializable)b -> new Tuple2((Object)partition, b), ArrayBuffer$.MODULE$.canBuildFrom());
            }
            throw new MatchError((Object)tuple2);
        }, Seq$.MODULE$.canBuildFrom());
    }

    private Seq<FileAction> runOptimizeBinJob(OptimisticTransaction txn, Map<String, String> partition, Seq<AddFile> bin, long maxFileSize) {
        Object object;
        Path baseTablePath = txn.deltaLog().dataPath();
        Snapshot x$1 = txn.snapshot();
        Seq<AddFile> x$2 = bin;
        Some x$3 = new Some((Object)"Optimize");
        boolean x$4 = txn.deltaLog().createDataFrame$default$3();
        Dataset<Row> input = txn.deltaLog().createDataFrame(x$1, x$2, x$4, (Option<String>)x$3);
        input = RowTracking$.MODULE$.preserveRowTrackingColumns(input, txn.snapshot());
        if (this.isMultiDimClustering()) {
            long totalSize = BoxesRunTime.unboxToLong((Object)((TraversableOnce)bin.map((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToLong((long)x$10.size()), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
            int approxNumFiles = (int)Math.max(1L, totalSize / maxFileSize);
            object = MultiDimClustering$.MODULE$.cluster(input, approxNumFiles, this.clusteringColumns(), this.org$apache$spark$sql$delta$commands$OptimizeExecutor$$optimizeStrategy().curve());
        } else {
            boolean useRepartition = BoxesRunTime.unboxToBoolean((Object)this.sparkSession.sessionState().conf().getConf(DeltaSQLConf$.MODULE$.DELTA_OPTIMIZE_REPARTITION_ENABLED()));
            object = useRepartition ? input.repartition(1) : input.coalesce(1);
        }
        Dataset<Row> repartitionDF = object;
        String partitionDesc = ((TraversableOnce)partition.toSeq().map((Function1 & Serializable & scala.Serializable)entry -> new StringBuilder(1).append((String)entry._1()).append("=").append(entry._2()).toString(), Seq$.MODULE$.canBuildFrom())).mkString(",");
        String partitionName = partition.isEmpty() ? "" : new StringBuilder(16).append(" in partition (").append(partitionDesc).append(")").toString();
        String description = new StringBuilder(22).append(baseTablePath).append("<br/>Optimizing ").append(bin.size()).append(" files").append(partitionName).toString();
        this.sparkSession.sparkContext().setJobGroup(this.sparkSession.sparkContext().getLocalProperty(SparkContext$.MODULE$.SPARK_JOB_GROUP_ID()), description, this.sparkSession.sparkContext().setJobGroup$default$3());
        OptimizeTableStrategy.BinInfo binInfo = this.org$apache$spark$sql$delta$commands$OptimizeExecutor$$optimizeStrategy().initNewBin();
        Seq addFiles = (Seq)txn.writeFiles(repartitionDF, (Option<DeltaOptions>)None$.MODULE$, true, (Seq<Constraint>)Nil$.MODULE$).collect((PartialFunction)new scala.Serializable(this, binInfo){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OptimizeExecutor $outer;
            private final OptimizeTableStrategy.BinInfo binInfo$1;

            public final <A1 extends FileAction, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof AddFile) {
                    AddFile addFile = (AddFile)A1;
                    return (B1)this.$outer.org$apache$spark$sql$delta$commands$OptimizeExecutor$$optimizeStrategy().tagAddFile(addFile, this.binInfo$1);
                }
                throw new IllegalStateException(new StringBuilder(82).append("Unexpected action ").append(A1).append(" with type ").append(A1.getClass()).append(". File compaction job output").append("should only have AddFiles").toString());
            }

            public final boolean isDefinedAt(FileAction x1) {
                FileAction fileAction = x1;
                if (fileAction instanceof AddFile) {
                    return true;
                }
                return true;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.binInfo$1 = binInfo$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        Seq removeFiles = (Seq)bin.map((Function1 & Serializable & scala.Serializable)f -> f.removeWithTimestamp(this.operationTimestamp(), false), Seq$.MODULE$.canBuildFrom());
        Seq updates = (Seq)addFiles.$plus$plus((GenTraversableOnce)removeFiles, Seq$.MODULE$.canBuildFrom());
        return updates;
    }

    private void commitAndRetry(OptimisticTransaction txn, DeltaOperations.Operation optimizeOperation, Seq<Action> actions, Map<String, SQLMetric> metrics, Function1<OptimisticTransaction, Object> f) {
        while (true) {
            try {
                txn.registerSQLMetrics(this.sparkSession, metrics);
                txn.commit(actions, optimizeOperation, RowTracking$.MODULE$.addPreservedRowTrackingTagIfNotSet(txn.snapshot(), RowTracking$.MODULE$.addPreservedRowTrackingTagIfNotSet$default$2()));
            }
            catch (ConcurrentModificationException e) {
                OptimisticTransaction newTxn = txn.deltaLog().startTransaction(txn.catalogTable(), txn.deltaLog().startTransaction$default$2());
                if (BoxesRunTime.unboxToBoolean((Object)f.apply((Object)newTxn))) {
                    this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Retrying commit after checking for semantic conflicts with concurrent updates.");
                    txn = newTxn;
                    continue;
                }
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Semantic conflicts detected. Aborting operation.");
                throw e;
            }
            break;
        }
    }

    private DeltaOperations.Operation getOperation() {
        if (this.optimizeContext.reorg().nonEmpty()) {
            return new DeltaOperations.Reorg(this.partitionPredicate, DeltaOperations$Reorg$.MODULE$.apply$default$2());
        }
        return new DeltaOperations.Optimize(this.partitionPredicate, this.zOrderByColumns, this.isAutoCompact, (Option<Seq<String>>)(this.isClusteredTable() ? Option$.MODULE$.apply(this.clusteringColumns()).filter((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)x$11.nonEmpty())) : None$.MODULE$));
    }

    private Map<String, SQLMetric> createMetrics(SparkContext sparkContext, Seq<AddFile> addedFiles, Seq<RemoveFile> removedFiles, Seq<DeletionVectorDescriptor> removedDVs) {
        Tuple2 tuple2 = (Tuple2)((TraversableOnce)removedDVs.map((Function1 & Serializable & scala.Serializable)dv -> new Tuple2.mcJJ.sp(dv.cardinality(), (long)dv.sizeInBytes()), Seq$.MODULE$.canBuildFrom())).reduceLeftOption((Function2 & Serializable & scala.Serializable)(dv1, dv2) -> new Tuple2.mcJJ.sp(dv1._1$mcJ$sp() + dv2._1$mcJ$sp(), dv1._2$mcJ$sp() + dv2._2$mcJ$sp())).getOrElse((Function0 & Serializable & scala.Serializable)() -> new Tuple2.mcJJ.sp(0L, 0L));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        long deletionVectorRowsRemoved = tuple2._1$mcJ$sp();
        long deletionVectorBytesRemoved = tuple2._2$mcJ$sp();
        Tuple2.mcJJ.sp sp2 = new Tuple2.mcJJ.sp(deletionVectorRowsRemoved, deletionVectorBytesRemoved);
        long deletionVectorRowsRemoved2 = sp2._1$mcJ$sp();
        long deletionVectorBytesRemoved2 = sp2._2$mcJ$sp();
        Map dvMetrics = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numDeletionVectorsRemoved"), (Object)OptimizeExecutor.setAndReturnMetric$1("total number of deletion vectors removed", removedDVs.size(), sparkContext)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numDeletionVectorRowsRemoved"), (Object)OptimizeExecutor.setAndReturnMetric$1("total number of deletion vector rows removed", deletionVectorRowsRemoved2, sparkContext)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numDeletionVectorBytesRemoved"), (Object)OptimizeExecutor.setAndReturnMetric$1("total number of bytes of removed deletion vectors", deletionVectorBytesRemoved2, sparkContext))}));
        Option<FileSizeStatsWithHistogram> sizeStats = FileSizeStatsWithHistogram$.MODULE$.create((Seq<Object>)((Seq)((SeqLike)addedFiles.map((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToLong((long)x$13.size()), Seq$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.Long$.MODULE$)));
        return ((MapLike)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"minFileSize"), (Object)OptimizeExecutor.setAndReturnMetric$1("minimum file size", ((FileSizeStatsWithHistogram)sizeStats.get()).min(), sparkContext)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"p25FileSize"), (Object)OptimizeExecutor.setAndReturnMetric$1("25th percentile file size", ((FileSizeStatsWithHistogram)sizeStats.get()).p25(), sparkContext)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"p50FileSize"), (Object)OptimizeExecutor.setAndReturnMetric$1("50th percentile file size", ((FileSizeStatsWithHistogram)sizeStats.get()).p50(), sparkContext)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"p75FileSize"), (Object)OptimizeExecutor.setAndReturnMetric$1("75th percentile file size", ((FileSizeStatsWithHistogram)sizeStats.get()).p75(), sparkContext)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"maxFileSize"), (Object)OptimizeExecutor.setAndReturnMetric$1("maximum file size", ((FileSizeStatsWithHistogram)sizeStats.get()).max(), sparkContext)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numAddedFiles"), (Object)OptimizeExecutor.setAndReturnMetric$1("total number of files added.", addedFiles.size(), sparkContext)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numRemovedFiles"), (Object)OptimizeExecutor.setAndReturnMetric$1("total number of files removed.", removedFiles.size(), sparkContext)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numAddedBytes"), (Object)OptimizeExecutor.setAndReturnMetric$1("total number of bytes added", OptimizeExecutor.totalSize$1(addedFiles), sparkContext)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numRemovedBytes"), (Object)OptimizeExecutor.setAndReturnMetric$1("total number of bytes removed", OptimizeExecutor.totalSize$1(removedFiles), sparkContext))}))).$plus$plus((GenTraversableOnce)dvMetrics);
    }

    public static final /* synthetic */ boolean $anonfun$optimize$7(AddFile x$5) {
        return x$5.deletionVector() != null;
    }

    public static final /* synthetic */ boolean $anonfun$optimize$9(OptimizeExecutor $this, Seq candidateFiles$1, StructType partitionSchema$1, OptimisticTransaction newTxn) {
        Set candidateSetNew;
        StructType newPartitionSchema = newTxn.metadata().partitionSchema();
        Set candidateSetOld = ((TraversableOnce)candidateFiles$1.map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.path(), Seq$.MODULE$.canBuildFrom())).toSet();
        if (candidateSetOld.subsetOf((GenSet)(candidateSetNew = ((TraversableOnce)newTxn.filterFiles($this.partitionPredicate, newTxn.filterFiles$default$2()).map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.path(), Seq$.MODULE$.canBuildFrom())).toSet()))) {
            StructType structType = partitionSchema$1;
            StructType structType2 = newPartitionSchema;
            if (!(structType != null ? !structType.equals(structType2) : structType2 != null)) {
                return true;
            }
        }
        Set deleted = (Set)candidateSetOld.$minus$minus((GenTraversableOnce)candidateSetNew);
        $this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(86).append("The following compacted files were delete ").append("during checkpoint ").append(deleted.mkString(",")).append(". Aborting the compaction.").toString());
        return false;
    }

    private static final boolean shouldCompactBecauseOfDeletedRows$1(AddFile file, double maxDeletedRowsRatio$1) {
        return file.deletionVector() != null && file.numPhysicalRecords().isEmpty() || BoxesRunTime.unboxToDouble((Object)file.deletedToPhysicalRecordsRatio().getOrElse((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 0.0)) > maxDeletedRowsRatio$1;
    }

    public static final /* synthetic */ boolean $anonfun$filterCandidateFileList$2(long minFileSize$1, double maxDeletedRowsRatio$1, AddFile addFile) {
        return addFile.size() < minFileSize$1 || OptimizeExecutor.shouldCompactBecauseOfDeletedRows$1(addFile, maxDeletedRowsRatio$1);
    }

    public static final /* synthetic */ void $anonfun$groupFilesIntoBins$2(LongRef currentBinSize$1, long maxBinSize$1, ArrayBuffer bins$1, ArrayBuffer currentBin$1, AddFile file) {
        if (file.size() + currentBinSize$1.elem > maxBinSize$1) {
            bins$1.$plus$eq((Object)currentBin$1.toVector());
            currentBin$1.clear();
            currentBin$1.$plus$eq((Object)file);
            currentBinSize$1.elem = file.size();
            return;
        }
        currentBin$1.$plus$eq((Object)file);
        currentBinSize$1.elem += file.size();
    }

    public static final /* synthetic */ boolean $anonfun$groupFilesIntoBins$3(OptimizeExecutor $this, Seq bin) {
        return bin.size() > 1 || bin.size() == 1 && $this.optimizeContext.reorg().nonEmpty() || $this.isMultiDimClustering();
    }

    private static final SQLMetric setAndReturnMetric$1(String description, long value, SparkContext sparkContext$1) {
        SQLMetric metric = SQLMetrics$.MODULE$.createMetric(sparkContext$1, description);
        metric.set(value);
        return metric;
    }

    public static final /* synthetic */ void $anonfun$createMetrics$1(LongRef totalSize$2, FileAction file) {
        long l;
        FileAction fileAction = file;
        if (fileAction instanceof AddFile) {
            AddFile addFile = (AddFile)fileAction;
            l = addFile.size();
        } else if (fileAction instanceof RemoveFile) {
            RemoveFile removeFile = (RemoveFile)fileAction;
            l = BoxesRunTime.unboxToLong((Object)removeFile.size().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
        } else {
            throw new IllegalArgumentException(new StringBuilder(25).append("Unknown FileAction type: ").append(fileAction.getClass()).toString());
        }
        long fileSize = l;
        totalSize$2.elem += fileSize;
    }

    private static final long totalSize$1(Seq actions) {
        LongRef totalSize = LongRef.create((long)0L);
        actions.foreach((Function1 & Serializable & scala.Serializable)file -> {
            OptimizeExecutor.$anonfun$createMetrics$1(totalSize, file);
            return BoxedUnit.UNIT;
        });
        return totalSize.elem;
    }

    public OptimizeExecutor(SparkSession sparkSession, OptimisticTransaction txn, Seq<Expression> partitionPredicate, Seq<String> zOrderByColumns, boolean isAutoCompact, DeltaOptimizeContext optimizeContext) {
        this.sparkSession = sparkSession;
        this.txn = txn;
        this.partitionPredicate = partitionPredicate;
        this.zOrderByColumns = zOrderByColumns;
        this.isAutoCompact = isAutoCompact;
        this.optimizeContext = optimizeContext;
        Logging.$init$((Logging)this);
        DeltaProgressReporter.$init$(this);
        DatabricksLogging.$init$(this);
        DeltaLogging.$init$(this);
        DeltaCommand.$init$(this);
        SQLMetricsReporting.$init$(this);
        this.org$apache$spark$sql$delta$commands$OptimizeExecutor$$optimizeStrategy = OptimizeTableStrategy$.MODULE$.apply(sparkSession, txn.snapshot(), optimizeContext, zOrderByColumns);
        this.operationTimestamp = new SystemClock().getTimeMillis();
        this.isClusteredTable = ClusteredTableUtils$.MODULE$.isSupported(txn.snapshot().protocol());
        boolean bl = this.isMultiDimClustering = this.org$apache$spark$sql$delta$commands$OptimizeExecutor$$optimizeStrategy() instanceof ClusteringStrategy || this.org$apache$spark$sql$delta$commands$OptimizeExecutor$$optimizeStrategy() instanceof ZOrderStrategy;
        this.clusteringColumns = zOrderByColumns.nonEmpty() ? zOrderByColumns : (this.isClusteredTable() ? ClusteringColumnInfo$.MODULE$.extractLogicalNames(txn.snapshot()) : Nil$.MODULE$);
    }
}

