/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.commands;

import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.delta.Snapshot;
import org.apache.spark.sql.delta.commands.ClusteringStrategy;
import org.apache.spark.sql.delta.commands.CompactionStrategy;
import org.apache.spark.sql.delta.commands.DeltaOptimizeContext;
import org.apache.spark.sql.delta.commands.OptimizeTableMode$;
import org.apache.spark.sql.delta.commands.OptimizeTableStrategy;
import org.apache.spark.sql.delta.commands.ZOrderStrategy;
import org.apache.spark.sql.delta.skipping.clustering.ClusteredTableUtils$;
import org.apache.spark.sql.delta.skipping.clustering.ClusteringColumnInfo$;
import scala.Enumeration;
import scala.Predef$;
import scala.collection.Seq;

public final class OptimizeTableStrategy$ {
    public static OptimizeTableStrategy$ MODULE$;

    static {
        new OptimizeTableStrategy$();
    }

    public OptimizeTableStrategy apply(SparkSession sparkSession, Snapshot snapshot, DeltaOptimizeContext optimizeContext, Seq<String> zOrderBy) {
        Enumeration.Value value = this.getMode(snapshot, zOrderBy);
        Enumeration.Value value2 = OptimizeTableMode$.MODULE$.CLUSTERING();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            return new ClusteringStrategy(sparkSession, ClusteringColumnInfo$.MODULE$.extractLogicalNames(snapshot));
        }
        Enumeration.Value value4 = OptimizeTableMode$.MODULE$.ZORDER();
        Enumeration.Value value5 = value;
        if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
            return new ZOrderStrategy(sparkSession, zOrderBy);
        }
        Enumeration.Value value6 = OptimizeTableMode$.MODULE$.COMPACTION();
        Enumeration.Value value7 = value;
        if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
            return new CompactionStrategy(sparkSession, optimizeContext);
        }
        throw new UnsupportedOperationException(new StringBuilder(17).append("Unsupported mode ").append(value).toString());
    }

    private Enumeration.Value getMode(Snapshot snapshot, Seq<String> zOrderBy) {
        boolean isClusteredTable = ClusteredTableUtils$.MODULE$.isSupported(snapshot.protocol());
        boolean hasClusteringColumns = ClusteringColumnInfo$.MODULE$.extractLogicalNames(snapshot).nonEmpty();
        boolean isZOrderBy = zOrderBy.nonEmpty();
        if (isClusteredTable && hasClusteringColumns) {
            Predef$.MODULE$.assert(!isZOrderBy);
            return OptimizeTableMode$.MODULE$.CLUSTERING();
        }
        if (isZOrderBy) {
            return OptimizeTableMode$.MODULE$.ZORDER();
        }
        return OptimizeTableMode$.MODULE$.COMPACTION();
    }

    private OptimizeTableStrategy$() {
        MODULE$ = this;
    }
}

