/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.deletionvectors;

import com.google.common.primitives.Ints;
import com.google.common.primitives.UnsignedInts;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import org.apache.spark.sql.delta.deletionvectors.NativeRoaringBitmapArraySerializationFormat$;
import org.apache.spark.sql.delta.deletionvectors.PortableRoaringBitmapArraySerializationFormat$;
import org.apache.spark.sql.delta.deletionvectors.RoaringBitmapArray$;
import org.apache.spark.sql.delta.deletionvectors.RoaringBitmapArrayFormat$;
import org.apache.spark.sql.delta.deletionvectors.RoaringBitmapArraySerializationFormat;
import org.roaringbitmap.RelativeRangeConsumer;
import org.roaringbitmap.RoaringBitmap;
import scala.Array$;
import scala.Enumeration;
import scala.Equals;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.NumericRange;
import scala.collection.immutable.Range;
import scala.collection.mutable.ArrayOps;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t-e\u0001B\u001c9\u0005\u0015CQa\u0014\u0001\u0005\u0002ACqa\u0015\u0001A\u0002\u0013%A\u000bC\u0004_\u0001\u0001\u0007I\u0011B0\t\r\u0015\u0004\u0001\u0015)\u0003V\u0011\u00151\u0007\u0001\"\u0001h\u0011\u0019i\u0007\u0001\"\u0005;]\"1A\u000f\u0001C\tuUDq\u0001\u001e\u0001\u0005\u0012i\nI\u0001\u0003\u0005\u0002\u001e\u0001!\t\u0002OA\u0010\u0011\u001d\t\u0019\u0003\u0001C\u0001\u0003KAq!a\n\u0001\t\u0003\tI\u0003C\u0004\u00024\u0001!\t!!\u000e\t\rA\u0004A\u0011AA\u001b\u0011\u001d\tI\u0004\u0001C\u0001\u0003wAq!!\u0010\u0001\t\u0003\ty\u0004C\u0004\u0002B\u0001!\t!a\u0011\t\u000f\u0005\u0015\u0003\u0001\"\u0001\u0002D!9\u0011q\t\u0001\u0005\u0002\u0005%\u0003bBA(\u0001\u0011\u0005\u0011\u0011\u000b\u0005\b\u0003/\u0002A\u0011AA-\u0011\u0019\ti\u0006\u0001C\u0001!\"9\u0011q\f\u0001\u0005\u0002\u0005\u0005\u0004bBA3\u0001\u0011\u0005\u0011q\r\u0005\b\u0003W\u0002A\u0011AA7\u0011\u001d\t\u0019\t\u0001C\u0001\u0003\u000bCq!!(\u0001\t\u0003\ty\nC\u0004\u0002,\u0002!\t!!,\t\u000f\u0005E\u0006\u0001\"\u0001\u00024\"9\u0011Q\u001a\u0001\u0005\u0002\u0005=\u0007bBAn\u0001\u0011\u0005\u0013Q\u001c\u0005\b\u0003O\u0004A\u0011IAu\u0011\u001d\ti\u000f\u0001C!\u0003_Dq!!=\u0001\t\u0003\t\u0019\u0010C\u0005\u0003\u0010\u0001\t\n\u0011\"\u0001\u0003\u0012!I!q\u0005\u0001\u0012\u0002\u0013\u0005!\u0011\u0003\u0005\n\u0005S\u0001\u0011\u0013!C\u0001\u0005#AqAa\u000b\u0001\t\u0003\u0011i\u0003C\u0004\u00036\u0001!\tA!\f\t\u000f\t]\u0002\u0001\"\u0003\u0003:!9!q\b\u0001\u0005\n\t\u0005\u0003\u0002\u0003B#\u0001\u0011E!Ha\u0012\b\u000f\t%\u0003\b#\u0001\u0003L\u00191q\u0007\u000fE\u0001\u0005\u001bBaaT\u0016\u0005\u0002\t=\u0003\"\u0003B)W\t\u0007IQAA\u001e\u0011\u001d\u0011\u0019f\u000bQ\u0001\u000e)D\u0011B!\u0016,\u0005\u0004%)!a\u000f\t\u000f\t]3\u0006)A\u0007U\"9!\u0011L\u0016\u0005\u0002\tm\u0003b\u0002B0W\u0011\u0005!\u0011\r\u0005\b\u0005KZC\u0011\u0001B4\u0011\u001d\u0011Yg\u000bC\u0001\u0005[BqAa\u001e,\t\u0003\u0011I\bC\u0004\u0003\u0004.\"\tA!\"\u0003%I{\u0017M]5oO\nKG/\\1q\u0003J\u0014\u0018-\u001f\u0006\u0003si\nq\u0002Z3mKRLwN\u001c<fGR|'o\u001d\u0006\u0003wq\nQ\u0001Z3mi\u0006T!!\u0010 \u0002\u0007M\fHN\u0003\u0002@\u0001\u0006)1\u000f]1sW*\u0011\u0011IQ\u0001\u0007CB\f7\r[3\u000b\u0003\r\u000b1a\u001c:h\u0007\u0001\u00192\u0001\u0001$M!\t9%*D\u0001I\u0015\u0005I\u0015!B:dC2\f\u0017BA&I\u0005\u0019\te.\u001f*fMB\u0011q)T\u0005\u0003\u001d\"\u0013a!R9vC2\u001c\u0018A\u0002\u001fj]&$h\bF\u0001R!\t\u0011\u0006!D\u00019\u0003\u001d\u0011\u0017\u000e^7baN,\u0012!\u0016\t\u0004\u000fZC\u0016BA,I\u0005\u0015\t%O]1z!\tIF,D\u0001[\u0015\tY&)A\u0007s_\u0006\u0014\u0018N\\4cSRl\u0017\r]\u0005\u0003;j\u0013QBU8be&twMQ5u[\u0006\u0004\u0018a\u00032ji6\f\u0007o]0%KF$\"\u0001Y2\u0011\u0005\u001d\u000b\u0017B\u00012I\u0005\u0011)f.\u001b;\t\u000f\u0011\u001c\u0011\u0011!a\u0001+\u0006\u0019\u0001\u0010J\u0019\u0002\u0011\tLG/\\1qg\u0002\n1!\u00193e)\t\u0001\u0007\u000eC\u0003j\u000b\u0001\u0007!.A\u0003wC2,X\r\u0005\u0002HW&\u0011A\u000e\u0013\u0002\u0005\u0019>tw-\u0001\u0004bI\u0012\fE\u000e\u001c\u000b\u0003A>DQ\u0001\u001d\u0004A\u0002E\faA^1mk\u0016\u001c\bcA$sU&\u00111\u000f\u0013\u0002\u000byI,\u0007/Z1uK\u0012t\u0014\u0001C1eIJ\u000bgnZ3\u0015\u0005\u00014\b\"B<\b\u0001\u0004A\u0018!\u0002:b]\u001e,\u0007cA=\u0002\u00049\u0011!p \b\u0003wzl\u0011\u0001 \u0006\u0003{\u0012\u000ba\u0001\u0010:p_Rt\u0014\"A%\n\u0007\u0005\u0005\u0001*A\u0004qC\u000e\\\u0017mZ3\n\t\u0005\u0015\u0011q\u0001\u0002\u0006%\u0006tw-\u001a\u0006\u0004\u0003\u0003AEc\u00011\u0002\f!1q\u000f\u0003a\u0001\u0003\u001b\u0001R!a\u0004\u0002\u001a)l!!!\u0005\u000b\t\u0005M\u0011QC\u0001\nS6lW\u000f^1cY\u0016T1!a\u0006I\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u00037\t\tB\u0001\u0007Ok6,'/[2SC:<W-\u0001\u0004sK6|g/\u001a\u000b\u0004A\u0006\u0005\u0002\"B5\n\u0001\u0004Q\u0017!B2mK\u0006\u0014H#\u00011\u0002\u0011\r|g\u000e^1j]N$B!a\u000b\u00022A\u0019q)!\f\n\u0007\u0005=\u0002JA\u0004C_>dW-\u00198\t\u000b%\\\u0001\u0019\u00016\u0002\u000fQ|\u0017I\u001d:bsV\u0011\u0011q\u0007\t\u0004\u000fZS\u0017aC2be\u0012Lg.\u00197jif,\u0012A[\u0001\bSN,U\u000e\u001d;z+\t\tY#A\u0006sk:|\u0005\u000f^5nSj,GCAA\u0016\u0003Q\u0011X-\\8wKJ+hnQ8naJ,7o]5p]\u0006\u0011qN\u001d\u000b\u0004A\u0006-\u0003BBA'%\u0001\u0007\u0011+\u0001\u0003uQ\u0006$\u0018!B7fe\u001e,Gc\u00011\u0002T!1\u0011QK\nA\u0002E\u000bQa\u001c;iKJ\fA\u0001Z5gMR\u0019\u0001-a\u0017\t\r\u0005UC\u00031\u0001R\u0003\u0011\u0019w\u000e]=\u0002\u0007\u0005tG\rF\u0002a\u0003GBa!!\u0014\u0017\u0001\u0004\t\u0016AB1oI:{G\u000fF\u0002a\u0003SBa!!\u0014\u0018\u0001\u0004\t\u0016!F:fe&\fG.\u001b>fINK'0Z%o\u0005f$Xm\u001d\u000b\u0004U\u0006=\u0004bBA91\u0001\u0007\u00111O\u0001\u0007M>\u0014X.\u0019;\u0011\t\u0005U\u00141\u0010\b\u0004%\u0006]\u0014bAA=q\u0005A\"k\\1sS:<')\u001b;nCB\f%O]1z\r>\u0014X.\u0019;\n\t\u0005u\u0014q\u0010\u0002\u0006-\u0006dW/Z\u0005\u0004\u0003\u0003C%aC#ok6,'/\u0019;j_:\f\u0011b]3sS\u0006d\u0017N_3\u0015\u000b\u0001\f9)a'\t\u000f\u0005%\u0015\u00041\u0001\u0002\f\u00061!-\u001e4gKJ\u0004B!!$\u0002\u00186\u0011\u0011q\u0012\u0006\u0005\u0003#\u000b\u0019*A\u0002oS>T!!!&\u0002\t)\fg/Y\u0005\u0005\u00033\u000byI\u0001\u0006CsR,')\u001e4gKJDq!!\u001d\u001a\u0001\u0004\t\u0019(\u0001\u000btKJL\u0017\r\\5{K\u0006\u001b()\u001f;f\u0003J\u0014\u0018-\u001f\u000b\u0005\u0003C\u000bI\u000b\u0005\u0003H-\u0006\r\u0006cA$\u0002&&\u0019\u0011q\u0015%\u0003\t\tKH/\u001a\u0005\b\u0003cR\u0002\u0019AA:\u0003-!Wm]3sS\u0006d\u0017N_3\u0015\u0007\u0001\fy\u000bC\u0004\u0002\nn\u0001\r!a#\u0002\u001b\u0019|'/\u00117m\u0013:\u0014\u0016M\\4f)\u001d\u0001\u0017QWA]\u0003\u0007Da!a.\u001d\u0001\u0004Q\u0017!B:uCJ$\bbBA^9\u0001\u0007\u0011QX\u0001\u0007Y\u0016tw\r\u001e5\u0011\u0007\u001d\u000by,C\u0002\u0002B\"\u00131!\u00138u\u0011\u001d\t)\r\ba\u0001\u0003\u000f\f\u0001bY8ogVlWM\u001d\t\u00043\u0006%\u0017bAAf5\n)\"+\u001a7bi&4XMU1oO\u0016\u001cuN\\:v[\u0016\u0014\u0018a\u00024pe\u0016\u000b7\r\u001b\u000b\u0004A\u0006E\u0007bBAj;\u0001\u0007\u0011Q[\u0001\bG>t7/^7f!\u00159\u0015q\u001b6a\u0013\r\tI\u000e\u0013\u0002\n\rVt7\r^5p]F\n\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003W\ty\u000eC\u0004\u0002Ny\u0001\r!!9\u0011\u0007\u001d\u000b\u0019/C\u0002\u0002f\"\u00131!\u00118z\u0003\u0019)\u0017/^1mgR!\u00111FAv\u0011\u001d\t)f\ba\u0001\u0003C\f\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u0003{\u000b\u0001\"\\6TiJLgn\u001a\u000b\t\u0003k\u0014)Aa\u0002\u0003\fA!\u0011q_A\u0000\u001d\u0011\tI0a?\u0011\u0005mD\u0015bAA\u007f\u0011\u00061\u0001K]3eK\u001aLAA!\u0001\u0003\u0004\t11\u000b\u001e:j]\u001eT1!!@I\u0011%\t9,\tI\u0001\u0002\u0004\t)\u0010C\u0005\u0003\n\u0005\u0002\n\u00111\u0001\u0002v\u0006\u00191/\u001a9\t\u0013\t5\u0011\u0005%AA\u0002\u0005U\u0018aA3oI\u0006\u0011Rn[*ue&tw\r\n3fM\u0006,H\u000e\u001e\u00132+\t\u0011\u0019B\u000b\u0003\u0002v\nU1F\u0001B\f!\u0011\u0011IBa\t\u000e\u0005\tm!\u0002\u0002B\u000f\u0005?\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\t\u0005\u0002*\u0001\u0006b]:|G/\u0019;j_:LAA!\n\u0003\u001c\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002%5\\7\u000b\u001e:j]\u001e$C-\u001a4bk2$HEM\u0001\u0013[.\u001cFO]5oO\u0012\"WMZ1vYR$3'A\u0003gSJ\u001cH/\u0006\u0002\u00030A!qI!\rk\u0013\r\u0011\u0019\u0004\u0013\u0002\u0007\u001fB$\u0018n\u001c8\u0002\t1\f7\u000f^\u0001\u000eKb$XM\u001c3CSRl\u0017\r]:\u0015\u0007\u0001\u0014Y\u0004C\u0004\u0003>\u001d\u0002\r!!0\u0002\u00139,w\u000fT3oORD\u0017!D:ie&t7NQ5u[\u0006\u00048\u000fF\u0002a\u0005\u0007BqA!\u0010)\u0001\u0004\ti,A\u0007u_\nKG/\\1qgI\u0012\u0015\u000e\u001e\u000b\u00021\u0006\u0011\"k\\1sS:<')\u001b;nCB\f%O]1z!\t\u00116f\u0005\u0002,\rR\u0011!1J\u0001\u0018\u001b\u0006CvLU#Q%\u0016\u001bVI\u0014+B\u00052+uLV!M+\u0016\u000b\u0001$T!Y?J+\u0005KU#T\u000b:#\u0016I\u0011'F?Z\u000bE*V#!\u0003Yi\u0015\tW0C\u0013Rk\u0015\tU0D\u0003J#\u0015JT!M\u0013RK\u0016aF'B1~\u0013\u0015\nV'B!~\u001b\u0015I\u0015#J\u001d\u0006c\u0015\nV-!\u0003\u0015\t\u0007\u000f\u001d7z)\r\t&Q\f\u0005\u0006aF\u0002\r!]\u0001\nQ&<\u0007NQ=uKN$B!!0\u0003d!)\u0011N\ra\u0001U\u0006AAn\\<CsR,7\u000f\u0006\u0003\u0002>\n%\u0004\"B54\u0001\u0004Q\u0017!\u00063fG>l\u0007o\\:f\u0011&<\u0007\u000eT8x\u0005f$Xm\u001d\u000b\u0005\u0005_\u0012)\bE\u0004H\u0005c\ni,!0\n\u0007\tM\u0004J\u0001\u0004UkBdWM\r\u0005\u0006SR\u0002\rA[\u0001\u0018G>l\u0007o\\:f\rJ|W\u000eS5hQ2{wOQ=uKN$RA\u001bB>\u0005\u007fBqA! 6\u0001\u0004\ti,\u0001\u0003iS\u001eD\u0007b\u0002BAk\u0001\u0007\u0011QX\u0001\u0004Y><\u0018\u0001\u0003:fC\u00124%o\\7\u0015\u0007E\u00139\tC\u0004\u0003\nZ\u0002\r!!)\u0002\u000b\tLH/Z:")
public final class RoaringBitmapArray
implements Equals {
    private RoaringBitmap[] bitmaps = (RoaringBitmap[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(RoaringBitmap.class));

    public static RoaringBitmapArray readFrom(byte[] byArray) {
        return RoaringBitmapArray$.MODULE$.readFrom(byArray);
    }

    public static long composeFromHighLowBytes(int n, int n2) {
        return RoaringBitmapArray$.MODULE$.composeFromHighLowBytes(n, n2);
    }

    public static Tuple2<Object, Object> decomposeHighLowBytes(long l) {
        return RoaringBitmapArray$.MODULE$.decomposeHighLowBytes(l);
    }

    public static int lowBytes(long l) {
        return RoaringBitmapArray$.MODULE$.lowBytes(l);
    }

    public static int highBytes(long l) {
        return RoaringBitmapArray$.MODULE$.highBytes(l);
    }

    public static RoaringBitmapArray apply(Seq<Object> seq) {
        return RoaringBitmapArray$.MODULE$.apply(seq);
    }

    public static long MAX_BITMAP_CARDINALITY() {
        return RoaringBitmapArray$.MODULE$.MAX_BITMAP_CARDINALITY();
    }

    public static long MAX_REPRESENTABLE_VALUE() {
        return RoaringBitmapArray$.MODULE$.MAX_REPRESENTABLE_VALUE();
    }

    private RoaringBitmap[] bitmaps() {
        return this.bitmaps;
    }

    private void bitmaps_$eq(RoaringBitmap[] x$1) {
        this.bitmaps = x$1;
    }

    public void add(long value) {
        Predef$.MODULE$.require(value >= 0L && value <= RoaringBitmapArray$.MODULE$.MAX_REPRESENTABLE_VALUE());
        Tuple2<Object, Object> tuple2 = RoaringBitmapArray$.MODULE$.decomposeHighLowBytes(value);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int high = tuple2._1$mcI$sp();
        int low = tuple2._2$mcI$sp();
        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(high, low);
        int high2 = sp2._1$mcI$sp();
        int low2 = sp2._2$mcI$sp();
        if (high2 >= this.bitmaps().length) {
            this.extendBitmaps(high2 + 1);
        }
        RoaringBitmap highBitmap = this.bitmaps()[high2];
        highBitmap.add(low2);
    }

    public void addAll(Seq<Object> values) {
        values.foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)value -> this.add(value));
    }

    public void addRange(Range range) {
        Predef$.MODULE$.require(0 <= range.start() && range.start() <= range.end());
        if (range.isEmpty()) {
            return;
        }
        if (range.step() != 1) {
            range.foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> this.add(UnsignedInts.toLong((int)i)));
            return;
        }
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.bitmaps())).isEmpty()) {
            this.extendBitmaps(1);
        }
        int end = range.isInclusive() ? range.end() + 1 : range.end();
        ((RoaringBitmap)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.bitmaps())).head()).add(range.start(), end);
    }

    public void addRange(NumericRange<Object> range) {
        int lastHigh;
        Predef$.MODULE$.require(0L <= BoxesRunTime.unboxToLong((Object)range.start()) && BoxesRunTime.unboxToLong((Object)range.start()) <= BoxesRunTime.unboxToLong((Object)range.end()) && BoxesRunTime.unboxToLong((Object)range.end()) <= RoaringBitmapArray$.MODULE$.MAX_REPRESENTABLE_VALUE());
        if (range.isEmpty()) {
            return;
        }
        if (BoxesRunTime.unboxToLong((Object)range.step()) != 1L) {
            range.foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)value -> this.add(value));
            return;
        }
        Tuple2<Object, Object> tuple2 = RoaringBitmapArray$.MODULE$.decomposeHighLowBytes(BoxesRunTime.unboxToLong((Object)range.start()));
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int startHigh = tuple2._1$mcI$sp();
        int startLow = tuple2._2$mcI$sp();
        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(startHigh, startLow);
        int startHigh2 = sp2._1$mcI$sp();
        int startLow2 = sp2._2$mcI$sp();
        Tuple2<Object, Object> tuple22 = RoaringBitmapArray$.MODULE$.decomposeHighLowBytes(BoxesRunTime.unboxToLong((Object)range.end()));
        if (tuple22 == null) {
            throw new MatchError(tuple22);
        }
        int endHigh = tuple22._1$mcI$sp();
        int endLow = tuple22._2$mcI$sp();
        Tuple2.mcII.sp sp3 = new Tuple2.mcII.sp(endHigh, endLow);
        int endHigh2 = sp3._1$mcI$sp();
        int endLow2 = sp3._2$mcI$sp();
        int n = lastHigh = endLow2 == 0 && !range.isInclusive() ? endHigh2 - 1 : endHigh2;
        if (lastHigh >= this.bitmaps().length) {
            this.extendBitmaps(lastHigh + 1);
        }
        for (int currentHigh = startHigh2; currentHigh <= lastHigh; ++currentHigh) {
            long start;
            long l = start = currentHigh == startHigh2 ? UnsignedInts.toLong((int)startLow2) : 0L;
            long end = currentHigh == endHigh2 ? (range.isInclusive() ? UnsignedInts.toLong((int)endLow2) + 1L : UnsignedInts.toLong((int)endLow2)) : 0x100000000L;
            this.bitmaps()[currentHigh].add(start, end);
        }
    }

    public void remove(long value) {
        Predef$.MODULE$.require(value >= 0L && value <= RoaringBitmapArray$.MODULE$.MAX_REPRESENTABLE_VALUE());
        Tuple2<Object, Object> tuple2 = RoaringBitmapArray$.MODULE$.decomposeHighLowBytes(value);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int high = tuple2._1$mcI$sp();
        int low = tuple2._2$mcI$sp();
        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(high, low);
        int high2 = sp2._1$mcI$sp();
        int low2 = sp2._2$mcI$sp();
        if (high2 < this.bitmaps().length) {
            RoaringBitmap highBitmap = this.bitmaps()[high2];
            highBitmap.remove(low2);
            if (highBitmap.isEmpty()) {
                int latestNonEmpty = this.bitmaps().length - 1;
                boolean done = false;
                while (!done && latestNonEmpty >= 0) {
                    if (this.bitmaps()[latestNonEmpty].isEmpty()) {
                        --latestNonEmpty;
                        continue;
                    }
                    done = true;
                }
                this.shrinkBitmaps(latestNonEmpty + 1);
                return;
            }
            return;
        }
    }

    public void clear() {
        this.bitmaps_$eq((RoaringBitmap[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(RoaringBitmap.class)));
    }

    public boolean contains(long value) {
        Predef$.MODULE$.require(value >= 0L && value <= RoaringBitmapArray$.MODULE$.MAX_REPRESENTABLE_VALUE());
        int high = RoaringBitmapArray$.MODULE$.highBytes(value);
        if (high >= this.bitmaps().length) {
            return false;
        }
        RoaringBitmap highBitmap = this.bitmaps()[high];
        int low = RoaringBitmapArray$.MODULE$.lowBytes(value);
        return highBitmap.contains(low);
    }

    public long[] toArray() {
        long cardinality = this.cardinality();
        Predef$.MODULE$.require(cardinality <= Integer.MAX_VALUE);
        long[] values = (long[])Array$.MODULE$.ofDim((int)cardinality, ClassTag$.MODULE$.Long());
        IntRef valuesIndex = IntRef.create((int)0);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.bitmaps())).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)RoaringBitmapArray.$anonfun$toArray$1(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
            RoaringBitmapArray.$anonfun$toArray$2(values, valuesIndex, x$5);
            return BoxedUnit.UNIT;
        });
        return values;
    }

    public long[] values() {
        return this.toArray();
    }

    public long cardinality() {
        return BoxesRunTime.unboxToLong((Object)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.bitmaps())).foldLeft((Object)BoxesRunTime.boxToLong((long)0L), (Function2 & Serializable & scala.Serializable)(sum, bitmap) -> BoxesRunTime.boxToLong((long)RoaringBitmapArray.$anonfun$cardinality$1(BoxesRunTime.unboxToLong((Object)sum), bitmap))));
    }

    public boolean isEmpty() {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.bitmaps())).forall((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)x$6.isEmpty()));
    }

    public boolean runOptimize() {
        BooleanRef changeApplied = BooleanRef.create((boolean)false);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.bitmaps())).foreach((Function1 & Serializable & scala.Serializable)bitmap -> {
            RoaringBitmapArray.$anonfun$runOptimize$1(changeApplied, bitmap);
            return BoxedUnit.UNIT;
        });
        return changeApplied.elem;
    }

    public boolean removeRunCompression() {
        BooleanRef changeApplied = BooleanRef.create((boolean)false);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.bitmaps())).foreach((Function1 & Serializable & scala.Serializable)bitmap -> {
            RoaringBitmapArray.$anonfun$removeRunCompression$1(changeApplied, bitmap);
            return BoxedUnit.UNIT;
        });
        return changeApplied.elem;
    }

    public void or(RoaringBitmapArray that) {
        if (this.bitmaps().length < that.bitmaps().length) {
            this.extendBitmaps(that.bitmaps().length);
        }
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])that.bitmaps())).indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)index -> {
            RoaringBitmap thisBitmap = this.bitmaps()[index];
            RoaringBitmap thatBitmap = that.bitmaps()[index];
            thisBitmap.or(thatBitmap);
        });
    }

    public void merge(RoaringBitmapArray other) {
        this.or(other);
    }

    public void diff(RoaringBitmapArray other) {
        this.andNot(other);
    }

    public RoaringBitmapArray copy() {
        RoaringBitmapArray newBitmap = new RoaringBitmapArray();
        newBitmap.merge(this);
        return newBitmap;
    }

    public void and(RoaringBitmapArray that) {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.bitmaps().length).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)index -> {
            RoaringBitmap thisBitmap = this.bitmaps()[index];
            if (index < that.bitmaps().length) {
                RoaringBitmap thatBitmap = that.bitmaps()[index];
                thisBitmap.and(thatBitmap);
                return;
            }
            thisBitmap.clear();
        });
    }

    public void andNot(RoaringBitmapArray that) {
        int validLength = package$.MODULE$.min(this.bitmaps().length, that.bitmaps().length);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), validLength).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)index -> {
            RoaringBitmap thisBitmap = this.bitmaps()[index];
            RoaringBitmap thatBitmap = that.bitmaps()[index];
            thisBitmap.andNot(thatBitmap);
        });
    }

    public long serializedSizeInBytes(Enumeration.Value format) {
        int magicNumberSize = 4;
        long serializedBitmapsSize = RoaringBitmapArrayFormat$.MODULE$.valueToFormat(format).formatImpl().serializedSizeInBytes(this.bitmaps());
        return (long)magicNumberSize + serializedBitmapsSize;
    }

    public void serialize(ByteBuffer buffer, Enumeration.Value format) {
        ByteOrder byteOrder = ByteOrder.LITTLE_ENDIAN;
        ByteOrder byteOrder2 = buffer.order();
        Predef$.MODULE$.require(!(byteOrder != null ? !byteOrder.equals(byteOrder2) : byteOrder2 != null), (Function0 & Serializable & scala.Serializable)() -> "RoaringBitmapArray has to be serialized using a little endian buffer");
        buffer.putInt(RoaringBitmapArrayFormat$.MODULE$.valueToFormat(format).formatImpl().MAGIC_NUMBER());
        RoaringBitmapArrayFormat$.MODULE$.valueToFormat(format).formatImpl().serialize(this.bitmaps(), buffer);
    }

    public byte[] serializeAsByteArray(Enumeration.Value format) {
        long size = this.serializedSizeInBytes(format);
        if (!RichLong$.MODULE$.isValidInt$extension(Predef$.MODULE$.longWrapper(size))) {
            throw new IOException(new StringBuilder(60).append("A bitmap was too big to be serialized into an array (").append(size).append(" bytes)").toString());
        }
        ByteBuffer buffer = ByteBuffer.allocate((int)size);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        this.serialize(buffer, format);
        return buffer.array();
    }

    public void deserialize(ByteBuffer buffer) {
        RoaringBitmapArraySerializationFormat roaringBitmapArraySerializationFormat;
        int magicNumber;
        ByteOrder byteOrder = ByteOrder.LITTLE_ENDIAN;
        ByteOrder byteOrder2 = buffer.order();
        Predef$.MODULE$.require(!(byteOrder != null ? !byteOrder.equals(byteOrder2) : byteOrder2 != null), (Function0 & Serializable & scala.Serializable)() -> "RoaringBitmapArray has to be deserialized using a little endian buffer");
        int n = magicNumber = buffer.getInt();
        if (NativeRoaringBitmapArraySerializationFormat$.MODULE$.MAGIC_NUMBER() == n) {
            roaringBitmapArraySerializationFormat = NativeRoaringBitmapArraySerializationFormat$.MODULE$;
        } else if (PortableRoaringBitmapArraySerializationFormat$.MODULE$.MAGIC_NUMBER() == n) {
            roaringBitmapArraySerializationFormat = PortableRoaringBitmapArraySerializationFormat$.MODULE$;
        } else {
            throw new IOException(new StringBuilder(43).append("Unexpected RoaringBitmapArray magic number ").append(magicNumber).toString());
        }
        NativeRoaringBitmapArraySerializationFormat$ serializationFormat = roaringBitmapArraySerializationFormat;
        this.bitmaps_$eq(serializationFormat.deserialize(buffer));
    }

    public void forAllInRange(long start, int length, RelativeRangeConsumer consumer) {
        throw new UnsupportedOperationException();
    }

    public void forEach(Function1<Object, BoxedUnit> consume) {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.bitmaps())).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)RoaringBitmapArray.$anonfun$forEach$1(check$ifrefutable$2))).foreach((Function1 & Serializable & scala.Serializable)x$7 -> {
            RoaringBitmapArray.$anonfun$forEach$2(consume, x$7);
            return BoxedUnit.UNIT;
        });
    }

    public boolean canEqual(Object that) {
        return that instanceof RoaringBitmapArray;
    }

    public boolean equals(Object other) {
        Object object = other;
        if (object instanceof RoaringBitmapArray) {
            RoaringBitmapArray roaringBitmapArray = (RoaringBitmapArray)object;
            return this == roaringBitmapArray || Arrays.deepEquals(this.bitmaps(), roaringBitmapArray.bitmaps());
        }
        return false;
    }

    public int hashCode() {
        return 131 * Arrays.deepHashCode(this.bitmaps());
    }

    public String mkString(String start, String sep, String end) {
        return new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(this.toArray())).mkString(start, sep, end);
    }

    public String mkString$default$1() {
        return "";
    }

    public String mkString$default$2() {
        return "";
    }

    public String mkString$default$3() {
        return "";
    }

    public Option<Object> first() {
        Option option;
        Object object = new Object();
        try {
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.bitmaps())).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$3 -> BoxesRunTime.boxToBoolean((boolean)RoaringBitmapArray.$anonfun$first$1(check$ifrefutable$3))).foreach((Function1 & Serializable & scala.Serializable)x$8 -> {
                RoaringBitmapArray.$anonfun$first$2(object, x$8);
                return BoxedUnit.UNIT;
            });
            option = None$.MODULE$;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                option = (Option)ex.value();
            }
            throw ex;
        }
        return option;
    }

    public Option<Object> last() {
        Option option;
        Object object = new Object();
        try {
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.bitmaps())).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).reverse())).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$4 -> BoxesRunTime.boxToBoolean((boolean)RoaringBitmapArray.$anonfun$last$1(check$ifrefutable$4))).foreach((Function1 & Serializable & scala.Serializable)x$9 -> {
                RoaringBitmapArray.$anonfun$last$2(object, x$9);
                return BoxedUnit.UNIT;
            });
            option = None$.MODULE$;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                option = (Option)ex.value();
            }
            throw ex;
        }
        return option;
    }

    private void extendBitmaps(int newLength) {
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.bitmaps())).isEmpty() && newLength == 1) {
            this.bitmaps_$eq((RoaringBitmap[])((Object[])new RoaringBitmap[]{new RoaringBitmap()}));
            return;
        }
        RoaringBitmap[] newBitmaps = (RoaringBitmap[])Array$.MODULE$.ofDim(newLength, ClassTag$.MODULE$.apply(RoaringBitmap.class));
        System.arraycopy(this.bitmaps(), 0, newBitmaps, 0, this.bitmaps().length);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(this.bitmaps().length), newLength).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            newBitmaps$1[i] = new RoaringBitmap();
        });
        this.bitmaps_$eq(newBitmaps);
    }

    private void shrinkBitmaps(int newLength) {
        if (newLength == 0) {
            this.bitmaps_$eq((RoaringBitmap[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(RoaringBitmap.class)));
            return;
        }
        RoaringBitmap[] newBitmaps = (RoaringBitmap[])Array$.MODULE$.ofDim(newLength, ClassTag$.MODULE$.apply(RoaringBitmap.class));
        System.arraycopy(this.bitmaps(), 0, newBitmaps, 0, newLength);
        this.bitmaps_$eq(newBitmaps);
    }

    public RoaringBitmap toBitmap32Bit() {
        RoaringBitmap bitmap32 = new RoaringBitmap();
        this.forEach((Function1<Object, BoxedUnit>)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)value -> {
            int value32 = Ints.checkedCast((long)value);
            bitmap32.add(value32);
        });
        bitmap32.runOptimize();
        return bitmap32;
    }

    public static final /* synthetic */ boolean $anonfun$toArray$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        return tuple2 != null;
    }

    public static final /* synthetic */ void $anonfun$toArray$2(long[] values$1, IntRef valuesIndex$1, Tuple2 x$5) {
        Tuple2 tuple2 = x$5;
        if (tuple2 != null) {
            RoaringBitmap bitmap = (RoaringBitmap)tuple2._1();
            int bitmapIndex = tuple2._2$mcI$sp();
            bitmap.forEach(value -> {
                values$1[valuesIndex$1.elem] = RoaringBitmapArray$.MODULE$.composeFromHighLowBytes(bitmapIndex, value);
                ++valuesIndex$1.elem;
            });
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ long $anonfun$cardinality$1(long sum, RoaringBitmap bitmap) {
        return sum + bitmap.getLongCardinality();
    }

    public static final /* synthetic */ void $anonfun$runOptimize$1(BooleanRef changeApplied$1, RoaringBitmap bitmap) {
        changeApplied$1.elem |= bitmap.runOptimize();
    }

    public static final /* synthetic */ void $anonfun$removeRunCompression$1(BooleanRef changeApplied$2, RoaringBitmap bitmap) {
        changeApplied$2.elem |= bitmap.removeRunCompression();
    }

    public static final /* synthetic */ boolean $anonfun$forEach$1(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        return tuple2 != null;
    }

    public static final /* synthetic */ void $anonfun$forEach$2(Function1 consume$1, Tuple2 x$7) {
        Tuple2 tuple2 = x$7;
        if (tuple2 != null) {
            RoaringBitmap bitmap = (RoaringBitmap)tuple2._1();
            int high = tuple2._2$mcI$sp();
            bitmap.forEach(low -> {
                long value = RoaringBitmapArray$.MODULE$.composeFromHighLowBytes(high, low);
                consume$1.apply$mcVJ$sp(value);
            });
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$first$1(Tuple2 check$ifrefutable$3) {
        Tuple2 tuple2 = check$ifrefutable$3;
        return tuple2 != null;
    }

    public static final /* synthetic */ void $anonfun$first$2(Object nonLocalReturnKey1$1, Tuple2 x$8) {
        Tuple2 tuple2 = x$8;
        if (tuple2 != null) {
            RoaringBitmap bitmap = (RoaringBitmap)tuple2._1();
            int high = tuple2._2$mcI$sp();
            if (!bitmap.isEmpty()) {
                int low = bitmap.first();
                throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)new Some((Object)BoxesRunTime.boxToLong((long)RoaringBitmapArray$.MODULE$.composeFromHighLowBytes(high, low))));
            }
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$last$1(Tuple2 check$ifrefutable$4) {
        Tuple2 tuple2 = check$ifrefutable$4;
        return tuple2 != null;
    }

    public static final /* synthetic */ void $anonfun$last$2(Object nonLocalReturnKey2$1, Tuple2 x$9) {
        Tuple2 tuple2 = x$9;
        if (tuple2 != null) {
            RoaringBitmap bitmap = (RoaringBitmap)tuple2._1();
            int high = tuple2._2$mcI$sp();
            if (!bitmap.isEmpty()) {
                int low = bitmap.last();
                throw new NonLocalReturnControl(nonLocalReturnKey2$1, (Object)new Some((Object)BoxesRunTime.boxToLong((long)RoaringBitmapArray$.MODULE$.composeFromHighLowBytes(high, low))));
            }
            return;
        }
        throw new MatchError((Object)tuple2);
    }
}

