/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.s3a.ProgressableProgressListener;
import org.apache.hadoop.fs.s3a.UploadInfo;
import org.apache.hadoop.fs.s3a.api.RequestFactory;
import org.apache.hadoop.fs.s3a.impl.ClientManager;
import org.apache.hadoop.fs.s3a.impl.MultiObjectDeleteException;
import org.apache.hadoop.fs.s3a.impl.StoreContext;
import org.apache.hadoop.fs.s3a.statistics.S3AStatisticsContext;
import org.apache.hadoop.fs.statistics.DurationTrackerFactory;
import org.apache.hadoop.fs.statistics.IOStatisticsSource;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.services.s3.model.CompleteMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.CompleteMultipartUploadResponse;
import software.amazon.awssdk.services.s3.model.DeleteObjectRequest;
import software.amazon.awssdk.services.s3.model.DeleteObjectResponse;
import software.amazon.awssdk.services.s3.model.DeleteObjectsRequest;
import software.amazon.awssdk.services.s3.model.DeleteObjectsResponse;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.model.UploadPartRequest;
import software.amazon.awssdk.services.s3.model.UploadPartResponse;
import software.amazon.awssdk.transfer.s3.model.CompletedFileUpload;

@InterfaceAudience.LimitedPrivate(value={"Extensions"})
@InterfaceStability.Unstable
public interface S3AStore
extends IOStatisticsSource,
ClientManager {
    public Duration acquireWriteCapacity(int var1);

    public Duration acquireReadCapacity(int var1);

    public StoreContext getStoreContext();

    public DurationTrackerFactory getDurationTrackerFactory();

    public S3AStatisticsContext getStatisticsContext();

    public RequestFactory getRequestFactory();

    public ClientManager clientManager();

    public void incrementReadOperations();

    public void incrementWriteOperations();

    public void incrementPutStartStatistics(long var1);

    public void incrementPutCompletedStatistics(boolean var1, long var2);

    public void incrementPutProgressStatistics(String var1, long var2);

    public DurationTrackerFactory nonNullDurationTrackerFactory(DurationTrackerFactory var1);

    public Map.Entry<Duration, DeleteObjectsResponse> deleteObjects(DeleteObjectsRequest var1) throws MultiObjectDeleteException, SdkException, IOException;

    public Map.Entry<Duration, Optional<DeleteObjectResponse>> deleteObject(DeleteObjectRequest var1) throws SdkException;

    public UploadPartResponse uploadPart(UploadPartRequest var1, RequestBody var2, DurationTrackerFactory var3) throws AwsServiceException, UncheckedIOException;

    public UploadInfo putObject(PutObjectRequest var1, File var2, ProgressableProgressListener var3) throws IOException;

    public CompletedFileUpload waitForUploadCompletion(String var1, UploadInfo var2) throws IOException;

    public CompleteMultipartUploadResponse completeMultipartUpload(CompleteMultipartUploadRequest var1);
}

