/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.spark.aws;

import com.google.gson.JsonObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.log4j.Logger;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;

public class RemoteFetchCredentialsProvider
implements AwsCredentialsProvider {
    private static final Logger logger = Logger.getLogger((String)"dku.aws.creds");
    private static final int MIN_TOKEN_EXPIRY = 60000;
    private final String connectionName;
    private final String projectKey;
    private RawSerializableAWSCredential cred = new RawSerializableAWSCredential();

    public RemoteFetchCredentialsProvider(URI uri, Configuration conf) {
        this.cred.accessKey = conf.get("fs.s3a.access.key", null);
        this.cred.secretKey = conf.get("fs.s3a.secret.key", null);
        this.cred.sessionToken = conf.get("fs.s3a.session.token", null);
        this.cred.expirationTime = Long.parseLong(conf.get("fs.s3a.session.expirationTime", "0"));
        if ("true".equals(conf.get("fs.s3a.session.forceInitialRefresh", null))) {
            this.cred.expirationTime = 1L;
        }
        if (this.cred.accessKey == null || this.cred.secretKey == null || this.cred.sessionToken == null) {
            throw new IllegalArgumentException("Credentials not found");
        }
        this.connectionName = conf.get("fs.s3a.dku.connectionName", null);
        if (this.connectionName == null) {
            throw new IllegalArgumentException("Connection name not found");
        }
        this.projectKey = conf.get("fs.s3a.dku.projectKey", "__DKU_ANY_PROJECT__");
    }

    public AwsCredentials resolveCredentials() {
        if (this.cred.expirationTime > 0L && this.cred.expirationTime - System.currentTimeMillis() < 60000L) {
            this.refresh();
        }
        if (this.cred.sessionToken != null) {
            return AwsSessionCredentials.create((String)this.cred.accessKey, (String)this.cred.secretKey, (String)this.cred.sessionToken);
        }
        return AwsBasicCredentials.create((String)this.cred.accessKey, (String)this.cred.secretKey);
    }

    public void refresh() {
        logger.info((Object)"Refresh credentials");
        try {
            Class<?> cloudStorageConnectionClazz;
            try {
                cloudStorageConnectionClazz = this.getClass().getClassLoader().loadClass("com.dataiku.dip.connections.AbstractCloudStorageConnection");
            }
            catch (ClassNotFoundException e2) {
                logger.warn((Object)"Class not found in hadoop's classloader");
                cloudStorageConnectionClazz = Thread.currentThread().getContextClassLoader().loadClass("com.dataiku.dip.connections.AbstractCloudStorageConnection");
            }
            Method refreshCredentialsMethod = cloudStorageConnectionClazz.getDeclaredMethod("refreshCredentials", String.class, String.class, Boolean.TYPE, Boolean.TYPE);
            JsonObject creds = (JsonObject)refreshCredentialsMethod.invoke(null, this.connectionName, this.projectKey, false, false);
            this.cred = new RawSerializableAWSCredential();
            this.cred.accessKey = creds.get("accessKey").getAsString();
            this.cred.secretKey = creds.get("secretKey").getAsString();
            if (creds.has("sessionToken")) {
                this.cred.sessionToken = creds.get("sessionToken").getAsString();
            }
            if (creds.has("expirationTime")) {
                this.cred.expirationTime = creds.get("expirationTime").getAsLong();
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Can't access remote creds", e);
        }
    }

    public static class RawSerializableAWSCredential {
        public String accessKey;
        public String secretKey;
        public String sessionToken;
        public long expirationTime;
    }
}

