/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glue.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.glue.model.CrawlerTargets;
import java.util.List;

@SdkInternalApi
public class CrawlerTargetsMarshaller {
    private static final MarshallingInfo<List> S3TARGETS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3Targets").build();
    private static final MarshallingInfo<List> JDBCTARGETS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("JdbcTargets").build();
    private static final MarshallingInfo<List> MONGODBTARGETS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MongoDBTargets").build();
    private static final MarshallingInfo<List> DYNAMODBTARGETS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DynamoDBTargets").build();
    private static final MarshallingInfo<List> CATALOGTARGETS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CatalogTargets").build();
    private static final MarshallingInfo<List> DELTATARGETS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeltaTargets").build();
    private static final MarshallingInfo<List> ICEBERGTARGETS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IcebergTargets").build();
    private static final MarshallingInfo<List> HUDITARGETS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("HudiTargets").build();
    private static final CrawlerTargetsMarshaller instance = new CrawlerTargetsMarshaller();

    public static CrawlerTargetsMarshaller getInstance() {
        return instance;
    }

    public void marshall(CrawlerTargets crawlerTargets, ProtocolMarshaller protocolMarshaller) {
        if (crawlerTargets == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(crawlerTargets.getS3Targets(), S3TARGETS_BINDING);
            protocolMarshaller.marshall(crawlerTargets.getJdbcTargets(), JDBCTARGETS_BINDING);
            protocolMarshaller.marshall(crawlerTargets.getMongoDBTargets(), MONGODBTARGETS_BINDING);
            protocolMarshaller.marshall(crawlerTargets.getDynamoDBTargets(), DYNAMODBTARGETS_BINDING);
            protocolMarshaller.marshall(crawlerTargets.getCatalogTargets(), CATALOGTARGETS_BINDING);
            protocolMarshaller.marshall(crawlerTargets.getDeltaTargets(), DELTATARGETS_BINDING);
            protocolMarshaller.marshall(crawlerTargets.getIcebergTargets(), ICEBERGTARGETS_BINDING);
            protocolMarshaller.marshall(crawlerTargets.getHudiTargets(), HUDITARGETS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

