/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.signature;

import com.google.crypto.tink.PrimitiveSet;
import com.google.crypto.tink.PrimitiveWrapper;
import com.google.crypto.tink.PublicKeySign;
import com.google.crypto.tink.Registry;
import com.google.crypto.tink.internal.MonitoringUtil;
import com.google.crypto.tink.internal.MutableMonitoringRegistry;
import com.google.crypto.tink.monitoring.MonitoringClient;
import com.google.crypto.tink.monitoring.MonitoringKeysetInfo;
import com.google.crypto.tink.proto.OutputPrefixType;
import com.google.crypto.tink.subtle.Bytes;
import java.security.GeneralSecurityException;

public class PublicKeySignWrapper
implements PrimitiveWrapper<PublicKeySign, PublicKeySign> {
    private static final byte[] FORMAT_VERSION = new byte[]{0};
    private static final PublicKeySignWrapper WRAPPER = new PublicKeySignWrapper();

    PublicKeySignWrapper() {
    }

    @Override
    public PublicKeySign wrap(PrimitiveSet<PublicKeySign> primitives) {
        return new WrappedPublicKeySign(primitives);
    }

    @Override
    public Class<PublicKeySign> getPrimitiveClass() {
        return PublicKeySign.class;
    }

    @Override
    public Class<PublicKeySign> getInputPrimitiveClass() {
        return PublicKeySign.class;
    }

    public static void register() throws GeneralSecurityException {
        Registry.registerPrimitiveWrapper(WRAPPER);
    }

    private static class WrappedPublicKeySign
    implements PublicKeySign {
        private final PrimitiveSet<PublicKeySign> primitives;
        private final MonitoringClient.Logger logger;

        public WrappedPublicKeySign(PrimitiveSet<PublicKeySign> primitives) {
            this.primitives = primitives;
            if (primitives.hasAnnotations()) {
                MonitoringClient client = MutableMonitoringRegistry.globalInstance().getMonitoringClient();
                MonitoringKeysetInfo keysetInfo = MonitoringUtil.getMonitoringKeysetInfo(primitives);
                this.logger = client.createLogger(keysetInfo, "public_key_sign", "sign");
            } else {
                this.logger = MonitoringUtil.DO_NOTHING_LOGGER;
            }
        }

        @Override
        public byte[] sign(byte[] data) throws GeneralSecurityException {
            byte[] data2 = data;
            if (this.primitives.getPrimary().getOutputPrefixType().equals((Object)OutputPrefixType.LEGACY)) {
                data2 = Bytes.concat(data, FORMAT_VERSION);
            }
            try {
                byte[] output = Bytes.concat(this.primitives.getPrimary().getIdentifier(), this.primitives.getPrimary().getPrimitive().sign(data2));
                this.logger.log(this.primitives.getPrimary().getKeyId(), data2.length);
                return output;
            }
            catch (GeneralSecurityException e) {
                this.logger.logFailure();
                throw e;
            }
        }
    }
}

