/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.metadata;

import com.google.common.base.Preconditions;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaHookLoader;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.RetryingMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.ql.metadata.HiveMetaStoreClientFactory;
import org.apache.hadoop.hive.ql.metadata.SessionHiveMetaStoreClient;

public final class SessionHiveMetaStoreClientFactory
implements HiveMetaStoreClientFactory {
    @Override
    public IMetaStoreClient createMetaStoreClient(HiveConf conf, HiveMetaHookLoader hookLoader, boolean allowEmbedded, ConcurrentHashMap<String, Long> metaCallTimeMap) throws MetaException {
        Preconditions.checkNotNull((Object)conf, (Object)"conf cannot be null!");
        Preconditions.checkNotNull(metaCallTimeMap, (Object)"metaCallTimeMap cannot be null!");
        if (conf.getBoolVar(HiveConf.ConfVars.METASTORE_FASTPATH)) {
            return new SessionHiveMetaStoreClient(conf, hookLoader, allowEmbedded);
        }
        return RetryingMetaStoreClient.getProxy((HiveConf)conf, (HiveMetaHookLoader)hookLoader, metaCallTimeMap, (String)SessionHiveMetaStoreClient.class.getName(), (boolean)allowEmbedded);
    }
}

