/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.glue.catalog.util;

import com.amazonaws.glue.catalog.converters.CatalogToHiveConverter;
import com.amazonaws.glue.catalog.converters.CatalogToHiveConverterFactory;
import com.amazonaws.glue.catalog.converters.GlueInputConverter;
import com.amazonaws.glue.catalog.util.PartitionKey;
import com.amazonaws.glue.catalog.util.PartitionUtils;
import com.amazonaws.services.glue.AWSGlue;
import com.amazonaws.services.glue.model.BatchCreatePartitionRequest;
import com.amazonaws.services.glue.model.BatchCreatePartitionResult;
import com.amazonaws.services.glue.model.EntityNotFoundException;
import com.amazonaws.services.glue.model.GetPartitionRequest;
import com.amazonaws.services.glue.model.GetPartitionResult;
import com.amazonaws.services.glue.model.Partition;
import com.amazonaws.services.glue.model.PartitionError;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.metastore.api.AlreadyExistsException;
import org.apache.log4j.Logger;
import org.apache.thrift.TException;

public final class BatchCreatePartitionsHelper {
    private static final Logger logger = Logger.getLogger(BatchCreatePartitionsHelper.class);
    private final AWSGlue client;
    private final String databaseName;
    private final String tableName;
    private final List<Partition> partitions;
    private final boolean ifNotExists;
    private Map<PartitionKey, Partition> partitionMap;
    private List<Partition> partitionsFailed;
    private TException firstTException;
    private String catalogId;
    private CatalogToHiveConverter catalogToHiveConverter;

    public BatchCreatePartitionsHelper(AWSGlue client, String databaseName, String tableName, String catalogId, List<Partition> partitions, boolean ifNotExists) {
        this.client = client;
        this.databaseName = databaseName;
        this.tableName = tableName;
        this.catalogId = catalogId;
        this.partitions = partitions;
        this.ifNotExists = ifNotExists;
        this.catalogToHiveConverter = CatalogToHiveConverterFactory.getCatalogToHiveConverter();
    }

    public BatchCreatePartitionsHelper createPartitions() {
        this.partitionMap = PartitionUtils.buildPartitionMap(this.partitions);
        this.partitionsFailed = Lists.newArrayList();
        BatchCreatePartitionRequest request = new BatchCreatePartitionRequest().withDatabaseName(this.databaseName).withTableName(this.tableName).withCatalogId(this.catalogId).withPartitionInputList(GlueInputConverter.convertToPartitionInputs(this.partitionMap.values()));
        try {
            BatchCreatePartitionResult result = this.client.batchCreatePartition(request);
            this.processResult(result);
        }
        catch (Exception e) {
            logger.error((Object)"Exception thrown while creating partitions in DataCatalog: ", (Throwable)e);
            this.firstTException = this.catalogToHiveConverter.wrapInHiveException(e);
            if (PartitionUtils.isInvalidUserInputException(e)) {
                this.setAllFailed();
            }
            this.checkIfPartitionsCreated();
        }
        return this;
    }

    private void setAllFailed() {
        this.partitionsFailed = this.partitions;
        this.partitionMap.clear();
    }

    private void processResult(BatchCreatePartitionResult result) {
        List partitionErrors = result.getErrors();
        if (partitionErrors == null || partitionErrors.isEmpty()) {
            return;
        }
        logger.error((Object)String.format("BatchCreatePartitions failed to create %d out of %d partitions. \n", partitionErrors.size(), this.partitionMap.size()));
        for (PartitionError partitionError : partitionErrors) {
            Partition partitionFailed = this.partitionMap.remove(new PartitionKey(partitionError.getPartitionValues()));
            TException exception = this.catalogToHiveConverter.errorDetailToHiveException(partitionError.getErrorDetail());
            if (this.ifNotExists && exception instanceof AlreadyExistsException) continue;
            logger.error((Object)exception);
            if (this.firstTException == null) {
                this.firstTException = exception;
            }
            this.partitionsFailed.add(partitionFailed);
        }
    }

    private void checkIfPartitionsCreated() {
        for (Partition partition : this.partitions) {
            if (this.partitionExists(partition)) continue;
            this.partitionsFailed.add(partition);
            this.partitionMap.remove(new PartitionKey(partition));
        }
    }

    private boolean partitionExists(Partition partition) {
        GetPartitionRequest request = new GetPartitionRequest().withDatabaseName(partition.getDatabaseName()).withTableName(partition.getTableName()).withCatalogId(this.catalogId).withPartitionValues((Collection)partition.getValues());
        try {
            GetPartitionResult result = this.client.getPartition(request);
            Partition partitionReturned = result.getPartition();
            return partitionReturned != null;
        }
        catch (EntityNotFoundException e) {
            return false;
        }
        catch (Exception e) {
            logger.error((Object)String.format("Get partition request %s failed. ", request.toString()), (Throwable)e);
            return false;
        }
    }

    public TException getFirstTException() {
        return this.firstTException;
    }

    public Collection<Partition> getPartitionsCreated() {
        return this.partitionMap.values();
    }

    public List<Partition> getPartitionsFailed() {
        return this.partitionsFailed;
    }
}

