/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.glue.catalog.metastore;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.glue.catalog.converters.BaseCatalogToHiveConverter;
import com.amazonaws.glue.catalog.converters.CatalogToHiveConverter;
import com.amazonaws.glue.catalog.metastore.AWSGlueClientFactory;
import com.amazonaws.glue.catalog.metastore.GlueClientFactory;
import com.amazonaws.glue.catalog.metastore.GlueMetastoreClientDelegate;
import com.amazonaws.glue.catalog.util.BatchDeletePartitionsHelper;
import com.amazonaws.glue.catalog.util.ExpressionHelper;
import com.amazonaws.glue.catalog.util.LoggingHelper;
import com.amazonaws.glue.catalog.util.MetastoreClientUtils;
import com.amazonaws.glue.shims.AwsGlueHiveShims;
import com.amazonaws.glue.shims.ShimsLoader;
import com.amazonaws.services.glue.AWSGlue;
import com.amazonaws.services.glue.model.EntityNotFoundException;
import com.amazonaws.services.glue.model.GetDatabaseRequest;
import com.amazonaws.services.glue.model.Partition;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.common.ObjectPair;
import org.apache.hadoop.hive.common.ValidTxnList;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaHookLoader;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.PartitionDropOptions;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.AggrStats;
import org.apache.hadoop.hive.metastore.api.AlreadyExistsException;
import org.apache.hadoop.hive.metastore.api.ColumnStatistics;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.CompactionResponse;
import org.apache.hadoop.hive.metastore.api.CompactionType;
import org.apache.hadoop.hive.metastore.api.ConfigValSecurityException;
import org.apache.hadoop.hive.metastore.api.CurrentNotificationEventId;
import org.apache.hadoop.hive.metastore.api.DataOperationType;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.EnvironmentContext;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.FireEventRequest;
import org.apache.hadoop.hive.metastore.api.FireEventResponse;
import org.apache.hadoop.hive.metastore.api.ForeignKeysRequest;
import org.apache.hadoop.hive.metastore.api.Function;
import org.apache.hadoop.hive.metastore.api.GetAllFunctionsResponse;
import org.apache.hadoop.hive.metastore.api.GetOpenTxnsInfoResponse;
import org.apache.hadoop.hive.metastore.api.GetPrincipalsInRoleRequest;
import org.apache.hadoop.hive.metastore.api.GetPrincipalsInRoleResponse;
import org.apache.hadoop.hive.metastore.api.GetRoleGrantsForPrincipalRequest;
import org.apache.hadoop.hive.metastore.api.GetRoleGrantsForPrincipalResponse;
import org.apache.hadoop.hive.metastore.api.HeartbeatTxnRangeResponse;
import org.apache.hadoop.hive.metastore.api.HiveObjectPrivilege;
import org.apache.hadoop.hive.metastore.api.HiveObjectRef;
import org.apache.hadoop.hive.metastore.api.HiveObjectType;
import org.apache.hadoop.hive.metastore.api.Index;
import org.apache.hadoop.hive.metastore.api.InvalidInputException;
import org.apache.hadoop.hive.metastore.api.InvalidObjectException;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.InvalidPartitionException;
import org.apache.hadoop.hive.metastore.api.LockRequest;
import org.apache.hadoop.hive.metastore.api.LockResponse;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.MetadataPpdResult;
import org.apache.hadoop.hive.metastore.api.NoSuchLockException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.NoSuchTxnException;
import org.apache.hadoop.hive.metastore.api.NotificationEventResponse;
import org.apache.hadoop.hive.metastore.api.OpenTxnsResponse;
import org.apache.hadoop.hive.metastore.api.PartitionEventType;
import org.apache.hadoop.hive.metastore.api.PartitionValuesRequest;
import org.apache.hadoop.hive.metastore.api.PartitionValuesResponse;
import org.apache.hadoop.hive.metastore.api.PrimaryKeysRequest;
import org.apache.hadoop.hive.metastore.api.PrincipalPrivilegeSet;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.metastore.api.PrivilegeBag;
import org.apache.hadoop.hive.metastore.api.Role;
import org.apache.hadoop.hive.metastore.api.SQLForeignKey;
import org.apache.hadoop.hive.metastore.api.SQLPrimaryKey;
import org.apache.hadoop.hive.metastore.api.SetPartitionsStatsRequest;
import org.apache.hadoop.hive.metastore.api.ShowCompactResponse;
import org.apache.hadoop.hive.metastore.api.ShowLocksRequest;
import org.apache.hadoop.hive.metastore.api.ShowLocksResponse;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.TableMeta;
import org.apache.hadoop.hive.metastore.api.TxnAbortedException;
import org.apache.hadoop.hive.metastore.api.TxnOpenException;
import org.apache.hadoop.hive.metastore.api.UnknownDBException;
import org.apache.hadoop.hive.metastore.api.UnknownPartitionException;
import org.apache.hadoop.hive.metastore.api.UnknownTableException;
import org.apache.hadoop.hive.metastore.partition.spec.PartitionSpecProxy;
import org.apache.log4j.Logger;
import org.apache.thrift.TException;

public class AWSCatalogMetastoreClient
implements IMetaStoreClient {
    private static final Logger logger = Logger.getLogger(AWSCatalogMetastoreClient.class);
    private final HiveConf conf;
    private final AWSGlue glueClient;
    private final Warehouse wh;
    private final GlueMetastoreClientDelegate glueMetastoreClientDelegate;
    private final String catalogId;
    private final CatalogToHiveConverter catalogToHiveConverter;
    private static final int BATCH_DELETE_PARTITIONS_PAGE_SIZE = 25;
    private static final int BATCH_DELETE_PARTITIONS_THREADS_COUNT = 5;
    static final String BATCH_DELETE_PARTITIONS_THREAD_POOL_NAME_FORMAT = "batch-delete-partitions-%d";
    private static final ExecutorService BATCH_DELETE_PARTITIONS_THREAD_POOL = Executors.newFixedThreadPool(5, new ThreadFactoryBuilder().setNameFormat("batch-delete-partitions-%d").setDaemon(true).build());
    private final AwsGlueHiveShims hiveShims = ShimsLoader.getHiveShims();
    private Map<String, String> currentMetaVars;

    public AWSCatalogMetastoreClient(HiveConf conf) throws MetaException {
        this(conf, null);
    }

    public AWSCatalogMetastoreClient(HiveConf conf, HiveMetaHookLoader hook) throws MetaException {
        this.conf = conf;
        this.glueClient = new AWSGlueClientFactory((Configuration)this.conf).newClient();
        this.catalogToHiveConverter = new BaseCatalogToHiveConverter();
        this.wh = new Warehouse((Configuration)this.conf);
        this.glueMetastoreClientDelegate = new GlueMetastoreClientDelegate((Configuration)this.conf, this.glueClient, this.wh);
        this.snapshotActiveConf();
        if (!this.doesDefaultDBExist()) {
            this.createDefaultDatabase();
        }
        this.catalogId = MetastoreClientUtils.getCatalogId((Configuration)conf);
    }

    private AWSCatalogMetastoreClient(Builder builder) throws MetaException {
        this.conf = (HiveConf)Objects.firstNonNull((Object)builder.conf, (Object)new HiveConf());
        this.catalogToHiveConverter = new BaseCatalogToHiveConverter();
        this.wh = builder.wh != null ? builder.wh : new Warehouse((Configuration)this.conf);
        this.catalogId = builder.catalogId != null ? builder.catalogId : null;
        GlueClientFactory clientFactory = (GlueClientFactory)Objects.firstNonNull((Object)builder.clientFactory, (Object)new AWSGlueClientFactory((Configuration)this.conf));
        this.glueClient = clientFactory.newClient();
        this.glueMetastoreClientDelegate = (GlueMetastoreClientDelegate)Objects.firstNonNull((Object)builder.glueMetastoreClientDelegate, (Object)new GlueMetastoreClientDelegate((Configuration)this.conf, this.glueClient, this.wh));
        if (builder.createDefaults && !this.doesDefaultDBExist()) {
            this.createDefaultDatabase();
        }
    }

    private boolean doesDefaultDBExist() throws MetaException {
        try {
            GetDatabaseRequest getDatabaseRequest = new GetDatabaseRequest().withName("default").withCatalogId(this.catalogId);
            this.glueClient.getDatabase(getDatabaseRequest);
        }
        catch (EntityNotFoundException e) {
            return false;
        }
        catch (AmazonServiceException e) {
            String msg = "Unable to verify existence of default database: ";
            logger.error((Object)msg, (Throwable)e);
            throw new MetaException(msg + (Object)((Object)e));
        }
        return true;
    }

    private void createDefaultDatabase() throws MetaException {
        Database defaultDB = new Database();
        defaultDB.setName("default");
        defaultDB.setDescription("Default Hive database");
        defaultDB.setLocationUri(this.wh.getDefaultDatabasePath("default").toString());
        PrincipalPrivilegeSet principalPrivilegeSet = new PrincipalPrivilegeSet();
        principalPrivilegeSet.setRolePrivileges((Map)Maps.newHashMap());
        defaultDB.setPrivileges(principalPrivilegeSet);
        try {
            this.createDatabase(defaultDB);
        }
        catch (AlreadyExistsException e) {
            logger.warn((Object)"database - default already exists. Ignoring..");
        }
        catch (Exception e) {
            logger.error((Object)"Unable to create default database", (Throwable)e);
        }
    }

    public void createDatabase(Database database) throws InvalidObjectException, AlreadyExistsException, MetaException, TException {
        this.glueMetastoreClientDelegate.createDatabase(database);
    }

    public Database getDatabase(String name) throws NoSuchObjectException, MetaException, TException {
        return this.glueMetastoreClientDelegate.getDatabase(name);
    }

    public List<String> getDatabases(String pattern) throws MetaException, TException {
        return this.glueMetastoreClientDelegate.getDatabases(pattern);
    }

    public List<String> getAllDatabases() throws MetaException, TException {
        return this.getDatabases(".*");
    }

    public void alterDatabase(String databaseName, Database database) throws NoSuchObjectException, MetaException, TException {
        this.glueMetastoreClientDelegate.alterDatabase(databaseName, database);
    }

    public void dropDatabase(String name) throws NoSuchObjectException, InvalidOperationException, MetaException, TException {
        this.dropDatabase(name, true, false, false);
    }

    public void dropDatabase(String name, boolean deleteData, boolean ignoreUnknownDb) throws NoSuchObjectException, InvalidOperationException, MetaException, TException {
        this.dropDatabase(name, deleteData, ignoreUnknownDb, false);
    }

    public void dropDatabase(String name, boolean deleteData, boolean ignoreUnknownDb, boolean cascade) throws NoSuchObjectException, InvalidOperationException, MetaException, TException {
        this.glueMetastoreClientDelegate.dropDatabase(name, deleteData, ignoreUnknownDb, cascade);
    }

    public org.apache.hadoop.hive.metastore.api.Partition add_partition(org.apache.hadoop.hive.metastore.api.Partition partition) throws InvalidObjectException, AlreadyExistsException, MetaException, TException {
        this.glueMetastoreClientDelegate.addPartitions(Lists.newArrayList((Object[])new org.apache.hadoop.hive.metastore.api.Partition[]{partition}), false, true);
        return partition;
    }

    public int add_partitions(List<org.apache.hadoop.hive.metastore.api.Partition> partitions) throws InvalidObjectException, AlreadyExistsException, MetaException, TException {
        return this.glueMetastoreClientDelegate.addPartitions(partitions, false, true).size();
    }

    public List<org.apache.hadoop.hive.metastore.api.Partition> add_partitions(List<org.apache.hadoop.hive.metastore.api.Partition> partitions, boolean ifNotExists, boolean needResult) throws TException {
        return this.glueMetastoreClientDelegate.addPartitions(partitions, ifNotExists, needResult);
    }

    public int add_partitions_pspec(PartitionSpecProxy pSpec) throws InvalidObjectException, AlreadyExistsException, MetaException, TException {
        return this.glueMetastoreClientDelegate.addPartitionsSpecProxy(pSpec);
    }

    public void alterFunction(String dbName, String functionName, Function newFunction) throws InvalidObjectException, MetaException, TException {
        this.glueMetastoreClientDelegate.alterFunction(dbName, functionName, newFunction);
    }

    public void alter_index(String dbName, String tblName, String indexName, Index index) throws InvalidOperationException, MetaException, TException {
        throw new UnsupportedOperationException("alter_index is not supported");
    }

    public void alter_partition(String dbName, String tblName, org.apache.hadoop.hive.metastore.api.Partition partition) throws InvalidOperationException, MetaException, TException {
        this.glueMetastoreClientDelegate.alterPartitions(dbName, tblName, Lists.newArrayList((Object[])new org.apache.hadoop.hive.metastore.api.Partition[]{partition}));
    }

    public void alter_partition(String dbName, String tblName, org.apache.hadoop.hive.metastore.api.Partition partition, EnvironmentContext environmentContext) throws InvalidOperationException, MetaException, TException {
        this.glueMetastoreClientDelegate.alterPartitions(dbName, tblName, Lists.newArrayList((Object[])new org.apache.hadoop.hive.metastore.api.Partition[]{partition}));
    }

    public void alter_partitions(String dbName, String tblName, List<org.apache.hadoop.hive.metastore.api.Partition> partitions) throws InvalidOperationException, MetaException, TException {
        this.glueMetastoreClientDelegate.alterPartitions(dbName, tblName, partitions);
    }

    public void alter_partitions(String dbName, String tblName, List<org.apache.hadoop.hive.metastore.api.Partition> partitions, EnvironmentContext environmentContext) throws InvalidOperationException, MetaException, TException {
        this.glueMetastoreClientDelegate.alterPartitions(dbName, tblName, partitions);
    }

    public void alter_table(String dbName, String tblName, Table table) throws InvalidOperationException, MetaException, TException {
        this.alter_table(dbName, tblName, table, false);
    }

    public void alter_table(String dbName, String tblName, Table table, boolean cascade) throws InvalidOperationException, MetaException, TException {
        EnvironmentContext environmentContext = null;
        if (cascade) {
            environmentContext = new EnvironmentContext();
            environmentContext.putToProperties("CASCADE", "true");
        }
        this.glueMetastoreClientDelegate.alterTable(dbName, tblName, table, environmentContext);
    }

    public void alter_table_with_environmentContext(String dbName, String tblName, Table table, EnvironmentContext environmentContext) throws InvalidOperationException, MetaException, TException {
        this.glueMetastoreClientDelegate.alterTable(dbName, tblName, table, environmentContext);
    }

    public org.apache.hadoop.hive.metastore.api.Partition appendPartition(String dbName, String tblName, List<String> values) throws InvalidObjectException, AlreadyExistsException, MetaException, TException {
        return this.glueMetastoreClientDelegate.appendPartition(dbName, tblName, values);
    }

    public org.apache.hadoop.hive.metastore.api.Partition appendPartition(String dbName, String tblName, String partitionName) throws InvalidObjectException, AlreadyExistsException, MetaException, TException {
        List<String> partVals = this.partitionNameToVals(partitionName);
        return this.glueMetastoreClientDelegate.appendPartition(dbName, tblName, partVals);
    }

    public boolean create_role(Role role) throws MetaException, TException {
        return this.glueMetastoreClientDelegate.createRole(role);
    }

    public boolean drop_role(String roleName) throws MetaException, TException {
        return this.glueMetastoreClientDelegate.dropRole(roleName);
    }

    public List<Role> list_roles(String principalName, PrincipalType principalType) throws MetaException, TException {
        return this.glueMetastoreClientDelegate.listRoles(principalName, principalType);
    }

    public List<String> listRoleNames() throws MetaException, TException {
        return this.glueMetastoreClientDelegate.listRoleNames();
    }

    public GetPrincipalsInRoleResponse get_principals_in_role(GetPrincipalsInRoleRequest request) throws MetaException, TException {
        return this.glueMetastoreClientDelegate.getPrincipalsInRole(request);
    }

    public GetRoleGrantsForPrincipalResponse get_role_grants_for_principal(GetRoleGrantsForPrincipalRequest request) throws MetaException, TException {
        return this.glueMetastoreClientDelegate.getRoleGrantsForPrincipal(request);
    }

    public boolean grant_role(String roleName, String userName, PrincipalType principalType, String grantor, PrincipalType grantorType, boolean grantOption) throws MetaException, TException {
        return this.glueMetastoreClientDelegate.grantRole(roleName, userName, principalType, grantor, grantorType, grantOption);
    }

    public boolean revoke_role(String roleName, String userName, PrincipalType principalType, boolean grantOption) throws MetaException, TException {
        return this.glueMetastoreClientDelegate.revokeRole(roleName, userName, principalType, grantOption);
    }

    public void cancelDelegationToken(String tokenStrForm) throws MetaException, TException {
        this.glueMetastoreClientDelegate.cancelDelegationToken(tokenStrForm);
    }

    public String getTokenStrForm() throws IOException {
        return this.glueMetastoreClientDelegate.getTokenStrForm();
    }

    public boolean addToken(String tokenIdentifier, String delegationToken) throws TException {
        return this.glueMetastoreClientDelegate.addToken(tokenIdentifier, delegationToken);
    }

    public boolean removeToken(String tokenIdentifier) throws TException {
        return this.glueMetastoreClientDelegate.removeToken(tokenIdentifier);
    }

    public String getToken(String tokenIdentifier) throws TException {
        return this.glueMetastoreClientDelegate.getToken(tokenIdentifier);
    }

    public List<String> getAllTokenIdentifiers() throws TException {
        return this.glueMetastoreClientDelegate.getAllTokenIdentifiers();
    }

    public int addMasterKey(String key) throws MetaException, TException {
        return this.glueMetastoreClientDelegate.addMasterKey(key);
    }

    public void updateMasterKey(Integer seqNo, String key) throws NoSuchObjectException, MetaException, TException {
        this.glueMetastoreClientDelegate.updateMasterKey(seqNo, key);
    }

    public boolean removeMasterKey(Integer keySeq) throws TException {
        return this.glueMetastoreClientDelegate.removeMasterKey(keySeq);
    }

    public String[] getMasterKeys() throws TException {
        return this.glueMetastoreClientDelegate.getMasterKeys();
    }

    public LockResponse checkLock(long lockId) throws NoSuchTxnException, TxnAbortedException, NoSuchLockException, TException {
        return this.glueMetastoreClientDelegate.checkLock(lockId);
    }

    public void close() {
        this.currentMetaVars = null;
    }

    public void commitTxn(long txnId) throws NoSuchTxnException, TxnAbortedException, TException {
        this.glueMetastoreClientDelegate.commitTxn(txnId);
    }

    public void abortTxns(List<Long> txnIds) throws TException {
        this.glueMetastoreClientDelegate.abortTxns(txnIds);
    }

    @Deprecated
    public void compact(String dbName, String tblName, String partitionName, CompactionType compactionType) throws TException {
        this.glueMetastoreClientDelegate.compact(dbName, tblName, partitionName, compactionType);
    }

    @Deprecated
    public void compact(String dbName, String tblName, String partitionName, CompactionType compactionType, Map<String, String> tblProperties) throws TException {
        this.glueMetastoreClientDelegate.compact(dbName, tblName, partitionName, compactionType, tblProperties);
    }

    public CompactionResponse compact2(String dbName, String tblName, String partitionName, CompactionType compactionType, Map<String, String> tblProperties) throws TException {
        return this.glueMetastoreClientDelegate.compact2(dbName, tblName, partitionName, compactionType, tblProperties);
    }

    public void createFunction(Function function) throws InvalidObjectException, MetaException, TException {
        this.glueMetastoreClientDelegate.createFunction(function);
    }

    public void createIndex(Index index, Table indexTable) throws InvalidObjectException, MetaException, NoSuchObjectException, TException, AlreadyExistsException {
        throw new UnsupportedOperationException("createIndex is not supported");
    }

    public void createTable(Table tbl) throws AlreadyExistsException, InvalidObjectException, MetaException, NoSuchObjectException, TException {
        this.glueMetastoreClientDelegate.createTable(tbl);
    }

    public boolean deletePartitionColumnStatistics(String dbName, String tableName, String partName, String colName) throws NoSuchObjectException, MetaException, InvalidObjectException, TException, InvalidInputException {
        return this.glueMetastoreClientDelegate.deletePartitionColumnStatistics(dbName, tableName, partName, colName);
    }

    public boolean deleteTableColumnStatistics(String dbName, String tableName, String colName) throws NoSuchObjectException, MetaException, InvalidObjectException, TException, InvalidInputException {
        return this.glueMetastoreClientDelegate.deleteTableColumnStatistics(dbName, tableName, colName);
    }

    public void dropFunction(String dbName, String functionName) throws MetaException, NoSuchObjectException, InvalidObjectException, InvalidInputException, TException {
        this.glueMetastoreClientDelegate.dropFunction(dbName, functionName);
    }

    public boolean dropIndex(String dbName, String tblName, String name, boolean deleteData) throws NoSuchObjectException, MetaException, TException {
        throw new UnsupportedOperationException("dropIndex is not supported");
    }

    private void deleteParentRecursive(Path parent, int depth, boolean mustPurge) throws IOException, MetaException {
        if (depth > 0 && parent != null && this.wh.isWritable(parent) && this.wh.isEmpty(parent)) {
            this.wh.deleteDir(parent, true, mustPurge);
            this.deleteParentRecursive(parent.getParent(), depth - 1, mustPurge);
        }
    }

    private boolean isMustPurge(Table table, boolean ifPurge) {
        return ifPurge || "true".equalsIgnoreCase((String)table.getParameters().get("auto.purge"));
    }

    public boolean dropPartition(String dbName, String tblName, List<String> values, boolean deleteData) throws NoSuchObjectException, MetaException, TException {
        return this.glueMetastoreClientDelegate.dropPartition(dbName, tblName, values, false, deleteData, false);
    }

    public boolean dropPartition(String dbName, String tblName, List<String> values, PartitionDropOptions options) throws TException {
        return this.glueMetastoreClientDelegate.dropPartition(dbName, tblName, values, options.ifExists, options.deleteData, options.purgeData);
    }

    public boolean dropPartition(String dbName, String tblName, String partitionName, boolean deleteData) throws NoSuchObjectException, MetaException, TException {
        List<String> values = this.partitionNameToVals(partitionName);
        return this.glueMetastoreClientDelegate.dropPartition(dbName, tblName, values, false, deleteData, false);
    }

    public List<org.apache.hadoop.hive.metastore.api.Partition> dropPartitions(String dbName, String tblName, List<ObjectPair<Integer, byte[]>> partExprs, boolean deleteData, boolean ifExists) throws NoSuchObjectException, MetaException, TException {
        return this.dropPartitions_core(dbName, tblName, partExprs, deleteData, false);
    }

    public List<org.apache.hadoop.hive.metastore.api.Partition> dropPartitions(String dbName, String tblName, List<ObjectPair<Integer, byte[]>> partExprs, boolean deleteData, boolean ifExists, boolean needResults) throws NoSuchObjectException, MetaException, TException {
        return this.dropPartitions_core(dbName, tblName, partExprs, deleteData, false);
    }

    public List<org.apache.hadoop.hive.metastore.api.Partition> dropPartitions(String dbName, String tblName, List<ObjectPair<Integer, byte[]>> partExprs, PartitionDropOptions options) throws TException {
        return this.dropPartitions_core(dbName, tblName, partExprs, options.deleteData, options.purgeData);
    }

    private List<org.apache.hadoop.hive.metastore.api.Partition> dropPartitions_core(String databaseName, String tableName, List<ObjectPair<Integer, byte[]>> partExprs, boolean deleteData, boolean purgeData) throws TException {
        ArrayList deleted = Lists.newArrayList();
        for (ObjectPair<Integer, byte[]> expr : partExprs) {
            byte[] tmp = (byte[])expr.getSecond();
            String exprString = ExpressionHelper.convertHiveExpressionToCatalogExpression(tmp);
            List<Partition> catalogPartitionsToDelete = this.glueMetastoreClientDelegate.getCatalogPartitions(databaseName, tableName, exprString, -1L);
            deleted.addAll(this.batchDeletePartitions(databaseName, tableName, catalogPartitionsToDelete, deleteData, purgeData));
        }
        return deleted;
    }

    private List<org.apache.hadoop.hive.metastore.api.Partition> batchDeletePartitions(final String dbName, final String tableName, List<Partition> partitionsToDelete, boolean deleteData, boolean purgeData) throws TException {
        ArrayList deleted = Lists.newArrayList();
        if (partitionsToDelete == null) {
            return deleted;
        }
        this.validateBatchDeletePartitionsArguments(dbName, tableName, partitionsToDelete);
        ArrayList batchDeletePartitionsFutures = Lists.newArrayList();
        int numOfPartitionsToDelete = partitionsToDelete.size();
        for (int i = 0; i < numOfPartitionsToDelete; i += 25) {
            int j = Math.min(i + 25, numOfPartitionsToDelete);
            final List<Partition> partitionsOnePage = partitionsToDelete.subList(i, j);
            batchDeletePartitionsFutures.add(BATCH_DELETE_PARTITIONS_THREAD_POOL.submit(new Callable<BatchDeletePartitionsHelper>(){

                @Override
                public BatchDeletePartitionsHelper call() throws Exception {
                    return new BatchDeletePartitionsHelper(AWSCatalogMetastoreClient.this.glueClient, dbName, tableName, AWSCatalogMetastoreClient.this.catalogId, partitionsOnePage).deletePartitions();
                }
            }));
        }
        TException tException = null;
        for (Future future : batchDeletePartitionsFutures) {
            try {
                BatchDeletePartitionsHelper batchDeletePartitionsHelper = (BatchDeletePartitionsHelper)future.get();
                for (Partition partition : batchDeletePartitionsHelper.getPartitionsDeleted()) {
                    org.apache.hadoop.hive.metastore.api.Partition hivePartition = this.catalogToHiveConverter.convertPartition(partition);
                    try {
                        this.performDropPartitionPostProcessing(dbName, tableName, hivePartition, deleteData, purgeData);
                    }
                    catch (TException e) {
                        logger.error((Object)"Drop partition directory failed.", (Throwable)e);
                        tException = tException == null ? e : tException;
                    }
                    deleted.add(hivePartition);
                }
                tException = tException == null ? batchDeletePartitionsHelper.getFirstTException() : tException;
            }
            catch (Exception e) {
                logger.error((Object)"Exception thrown by BatchDeletePartitions thread pool. ", (Throwable)e);
            }
        }
        if (tException != null) {
            throw tException;
        }
        return deleted;
    }

    private void validateBatchDeletePartitionsArguments(String dbName, String tableName, List<Partition> partitionsToDelete) {
        Preconditions.checkArgument((dbName != null ? 1 : 0) != 0, (Object)"Database name cannot be null");
        Preconditions.checkArgument((tableName != null ? 1 : 0) != 0, (Object)"Table name cannot be null");
        for (Partition partition : partitionsToDelete) {
            Preconditions.checkArgument((boolean)dbName.equals(partition.getDatabaseName()), (Object)"Database name cannot be null");
            Preconditions.checkArgument((boolean)tableName.equals(partition.getTableName()), (Object)"Table name cannot be null");
            Preconditions.checkArgument((partition.getValues() != null ? 1 : 0) != 0, (Object)"Partition values cannot be null");
        }
    }

    private void performDropPartitionPostProcessing(String dbName, String tblName, org.apache.hadoop.hive.metastore.api.Partition partition, boolean deleteData, boolean ifPurge) throws MetaException, NoSuchObjectException, TException {
        if (deleteData && partition.getSd() != null && partition.getSd().getLocation() != null) {
            Path partPath = new Path(partition.getSd().getLocation());
            Table table = this.getTable(dbName, tblName);
            if (MetastoreClientUtils.isExternalTable(table)) {
                return;
            }
            boolean mustPurge = this.isMustPurge(table, ifPurge);
            this.wh.deleteDir(partPath, true, mustPurge);
            try {
                List values = partition.getValues();
                this.deleteParentRecursive(partPath.getParent(), values.size() - 1, mustPurge);
            }
            catch (IOException e) {
                throw new MetaException(e.getMessage());
            }
        }
    }

    @Deprecated
    public void dropTable(String tableName, boolean deleteData) throws MetaException, UnknownTableException, TException, NoSuchObjectException {
        this.dropTable("default", tableName, deleteData, false);
    }

    public void dropTable(String dbname, String tableName) throws MetaException, TException, NoSuchObjectException {
        this.dropTable(dbname, tableName, true, true, false);
    }

    public void dropTable(String dbname, String tableName, boolean deleteData, boolean ignoreUnknownTab) throws MetaException, TException, NoSuchObjectException {
        this.dropTable(dbname, tableName, deleteData, ignoreUnknownTab, false);
    }

    public void dropTable(String dbname, String tableName, boolean deleteData, boolean ignoreUnknownTab, boolean ifPurge) throws MetaException, TException, NoSuchObjectException {
        this.glueMetastoreClientDelegate.dropTable(dbname, tableName, deleteData, ignoreUnknownTab, ifPurge);
    }

    public org.apache.hadoop.hive.metastore.api.Partition exchange_partition(Map<String, String> partitionSpecs, String srcDb, String srcTbl, String dstDb, String dstTbl) throws MetaException, NoSuchObjectException, InvalidObjectException, TException {
        return this.glueMetastoreClientDelegate.exchangePartition(partitionSpecs, srcDb, srcTbl, dstDb, dstTbl);
    }

    public List<org.apache.hadoop.hive.metastore.api.Partition> exchange_partitions(Map<String, String> partitionSpecs, String sourceDb, String sourceTbl, String destDb, String destTbl) throws MetaException, NoSuchObjectException, InvalidObjectException, TException {
        return this.glueMetastoreClientDelegate.exchangePartitions(partitionSpecs, sourceDb, sourceTbl, destDb, destTbl);
    }

    public AggrStats getAggrColStatsFor(String dbName, String tblName, List<String> colNames, List<String> partName) throws NoSuchObjectException, MetaException, TException {
        return this.glueMetastoreClientDelegate.getAggrColStatsFor(dbName, tblName, colNames, partName);
    }

    public List<String> getAllTables(String dbname) throws MetaException, TException, UnknownDBException {
        return this.getTables(dbname, ".*");
    }

    public String getConfigValue(String name, String defaultValue) throws TException, ConfigValSecurityException {
        if (!Pattern.matches("(hive|hdfs|mapred).*", name)) {
            throw new ConfigValSecurityException("For security reasons, the config key " + name + " cannot be accessed");
        }
        return this.conf.get(name, defaultValue);
    }

    public String getDelegationToken(String owner, String renewerKerberosPrincipalName) throws MetaException, TException {
        return this.glueMetastoreClientDelegate.getDelegationToken(owner, renewerKerberosPrincipalName);
    }

    public List<FieldSchema> getFields(String db, String tableName) throws MetaException, TException, UnknownTableException, UnknownDBException {
        return this.glueMetastoreClientDelegate.getFields(db, tableName);
    }

    public Function getFunction(String dbName, String functionName) throws MetaException, TException {
        try {
            return this.glueMetastoreClientDelegate.getFunction(dbName, functionName);
        }
        catch (NoSuchObjectException e) {
            throw new NoSuchObjectException(functionName + " does not exist");
        }
        catch (AmazonServiceException e) {
            logger.error((Object)e);
            throw this.catalogToHiveConverter.wrapInHiveException(e);
        }
        catch (Exception e) {
            String msg = "Unable to get Function: ";
            logger.error((Object)msg, (Throwable)e);
            throw new MetaException(msg + e);
        }
    }

    public List<String> getFunctions(String dbName, String pattern) throws MetaException, TException {
        if (pattern.equals("*")) {
            pattern = ".*";
        }
        return this.glueMetastoreClientDelegate.getFunctions(dbName, pattern);
    }

    public GetAllFunctionsResponse getAllFunctions() throws MetaException, TException {
        return this.glueMetastoreClientDelegate.getAllFunctions();
    }

    public Index getIndex(String dbName, String tblName, String indexName) throws MetaException, UnknownTableException, NoSuchObjectException, TException {
        throw new UnsupportedOperationException("getIndex is not supported");
    }

    public String getMetaConf(String key) throws MetaException, TException {
        HiveConf.ConfVars metaConfVar = HiveConf.getMetaConf((String)key);
        if (metaConfVar == null) {
            throw new MetaException("Invalid configuration key " + key);
        }
        return this.conf.get(key, metaConfVar.getDefaultValue());
    }

    public org.apache.hadoop.hive.metastore.api.Partition getPartition(String dbName, String tblName, List<String> values) throws NoSuchObjectException, MetaException, TException {
        return this.glueMetastoreClientDelegate.getPartition(dbName, tblName, values);
    }

    public org.apache.hadoop.hive.metastore.api.Partition getPartition(String dbName, String tblName, String partitionName) throws MetaException, UnknownTableException, NoSuchObjectException, TException {
        return this.glueMetastoreClientDelegate.getPartition(dbName, tblName, partitionName);
    }

    public Map<String, List<ColumnStatisticsObj>> getPartitionColumnStatistics(String dbName, String tableName, List<String> partitionNames, List<String> columnNames) throws NoSuchObjectException, MetaException, TException {
        return this.glueMetastoreClientDelegate.getPartitionColumnStatistics(dbName, tableName, partitionNames, columnNames);
    }

    public org.apache.hadoop.hive.metastore.api.Partition getPartitionWithAuthInfo(String databaseName, String tableName, List<String> values, String userName, List<String> groupNames) throws MetaException, UnknownTableException, NoSuchObjectException, TException {
        org.apache.hadoop.hive.metastore.api.Partition partition = this.getPartition(databaseName, tableName, values);
        Table table = this.getTable(databaseName, tableName);
        if ("TRUE".equalsIgnoreCase((String)table.getParameters().get("PARTITION_LEVEL_PRIVILEGE"))) {
            String partName = Warehouse.makePartName((List)table.getPartitionKeys(), values);
            HiveObjectRef obj = new HiveObjectRef();
            obj.setObjectType(HiveObjectType.PARTITION);
            obj.setDbName(databaseName);
            obj.setObjectName(tableName);
            obj.setPartValues(values);
            PrincipalPrivilegeSet privilegeSet = this.get_privilege_set(obj, userName, groupNames);
            partition.setPrivileges(privilegeSet);
        }
        return partition;
    }

    public List<org.apache.hadoop.hive.metastore.api.Partition> getPartitionsByNames(String databaseName, String tableName, List<String> partitionNames) throws NoSuchObjectException, MetaException, TException {
        return this.glueMetastoreClientDelegate.getPartitionsByNames(databaseName, tableName, partitionNames);
    }

    public List<FieldSchema> getSchema(String db, String tableName) throws MetaException, TException, UnknownTableException, UnknownDBException {
        return this.glueMetastoreClientDelegate.getSchema(db, tableName);
    }

    @Deprecated
    public Table getTable(String tableName) throws MetaException, TException, NoSuchObjectException {
        return this.getTable("default", tableName);
    }

    public Table getTable(String dbName, String tableName) throws MetaException, TException, NoSuchObjectException {
        return this.glueMetastoreClientDelegate.getTable(dbName, tableName);
    }

    public List<ColumnStatisticsObj> getTableColumnStatistics(String dbName, String tableName, List<String> colNames) throws NoSuchObjectException, MetaException, TException {
        return this.glueMetastoreClientDelegate.getTableColumnStatistics(dbName, tableName, colNames);
    }

    public List<Table> getTableObjectsByName(String dbName, List<String> tableNames) throws MetaException, InvalidOperationException, UnknownDBException, TException {
        ArrayList hiveTables = Lists.newArrayList();
        for (String tableName : tableNames) {
            hiveTables.add(this.getTable(dbName, tableName));
        }
        return hiveTables;
    }

    public List<String> getTables(String dbname, String tablePattern) throws MetaException, TException, UnknownDBException {
        return this.glueMetastoreClientDelegate.getTables(dbname, tablePattern);
    }

    public List<String> getTables(String dbname, String tablePattern, TableType tableType) throws MetaException, TException, UnknownDBException {
        return this.glueMetastoreClientDelegate.getTables(dbname, tablePattern, tableType);
    }

    public List<TableMeta> getTableMeta(String dbPatterns, String tablePatterns, List<String> tableTypes) throws MetaException, TException, UnknownDBException {
        return this.glueMetastoreClientDelegate.getTableMeta(dbPatterns, tablePatterns, tableTypes);
    }

    public ValidTxnList getValidTxns() throws TException {
        return this.glueMetastoreClientDelegate.getValidTxns();
    }

    public ValidTxnList getValidTxns(long currentTxn) throws TException {
        return this.glueMetastoreClientDelegate.getValidTxns(currentTxn);
    }

    public PrincipalPrivilegeSet get_privilege_set(HiveObjectRef obj, String user, List<String> groups) throws MetaException, TException {
        return this.glueMetastoreClientDelegate.getPrivilegeSet(obj, user, groups);
    }

    public boolean grant_privileges(PrivilegeBag privileges) throws MetaException, TException {
        return this.glueMetastoreClientDelegate.grantPrivileges(privileges);
    }

    public boolean revoke_privileges(PrivilegeBag privileges, boolean grantOption) throws MetaException, TException {
        return this.glueMetastoreClientDelegate.revokePrivileges(privileges, grantOption);
    }

    public void heartbeat(long txnId, long lockId) throws NoSuchLockException, NoSuchTxnException, TxnAbortedException, TException {
        this.glueMetastoreClientDelegate.heartbeat(txnId, lockId);
    }

    public HeartbeatTxnRangeResponse heartbeatTxnRange(long min, long max) throws TException {
        return this.glueMetastoreClientDelegate.heartbeatTxnRange(min, max);
    }

    public boolean isCompatibleWith(HiveConf conf) {
        if (this.currentMetaVars == null) {
            return false;
        }
        boolean compatible = true;
        for (HiveConf.ConfVars oneVar : HiveConf.metaVars) {
            String oldVar = this.currentMetaVars.get(oneVar.varname);
            String newVar = conf.get(oneVar.varname, "");
            if (oldVar != null && !(oneVar.isCaseSensitive() ? !oldVar.equals(newVar) : !oldVar.equalsIgnoreCase(newVar))) continue;
            logger.info((Object)("Mestastore configuration " + oneVar.varname + " changed from " + oldVar + " to " + newVar));
            compatible = false;
        }
        return compatible;
    }

    public void setHiveAddedJars(String s) {
        throw new UnsupportedOperationException("setHiveAddedJars is not supported");
    }

    public boolean isLocalMetaStore() {
        return false;
    }

    private void snapshotActiveConf() {
        this.currentMetaVars = new HashMap<String, String>(HiveConf.metaVars.length);
        for (HiveConf.ConfVars oneVar : HiveConf.metaVars) {
            this.currentMetaVars.put(oneVar.varname, this.conf.get(oneVar.varname, ""));
        }
    }

    public boolean isPartitionMarkedForEvent(String dbName, String tblName, Map<String, String> partKVs, PartitionEventType eventType) throws MetaException, NoSuchObjectException, TException, UnknownTableException, UnknownDBException, UnknownPartitionException, InvalidPartitionException {
        return this.glueMetastoreClientDelegate.isPartitionMarkedForEvent(dbName, tblName, partKVs, eventType);
    }

    public List<String> listIndexNames(String db_name, String tbl_name, short max) throws MetaException, TException {
        throw new UnsupportedOperationException("listIndexNames is not supported");
    }

    public List<Index> listIndexes(String db_name, String tbl_name, short max) throws NoSuchObjectException, MetaException, TException {
        throw new UnsupportedOperationException("listIndexes is not supported");
    }

    public List<String> listPartitionNames(String dbName, String tblName, short max) throws MetaException, TException {
        try {
            return this.listPartitionNames(dbName, tblName, null, max);
        }
        catch (NoSuchObjectException e) {
            return Collections.emptyList();
        }
    }

    public List<String> listPartitionNames(String databaseName, String tableName, List<String> values, short max) throws MetaException, TException, NoSuchObjectException {
        return this.glueMetastoreClientDelegate.listPartitionNames(databaseName, tableName, values, max);
    }

    public PartitionValuesResponse listPartitionValues(PartitionValuesRequest partitionValuesRequest) throws TException {
        return this.glueMetastoreClientDelegate.listPartitionValues(partitionValuesRequest);
    }

    public int getNumPartitionsByFilter(String dbName, String tableName, String filter) throws MetaException, NoSuchObjectException, TException {
        return this.glueMetastoreClientDelegate.getNumPartitionsByFilter(dbName, tableName, filter);
    }

    public PartitionSpecProxy listPartitionSpecs(String dbName, String tblName, int max) throws TException {
        return this.glueMetastoreClientDelegate.listPartitionSpecs(dbName, tblName, max);
    }

    public PartitionSpecProxy listPartitionSpecsByFilter(String dbName, String tblName, String filter, int max) throws MetaException, NoSuchObjectException, TException {
        return this.glueMetastoreClientDelegate.listPartitionSpecsByFilter(dbName, tblName, filter, max);
    }

    public List<org.apache.hadoop.hive.metastore.api.Partition> listPartitions(String dbName, String tblName, short max) throws NoSuchObjectException, MetaException, TException {
        return this.listPartitions(dbName, tblName, null, max);
    }

    public List<org.apache.hadoop.hive.metastore.api.Partition> listPartitions(String databaseName, String tableName, List<String> values, short max) throws NoSuchObjectException, MetaException, TException {
        String expression = null;
        if (values != null) {
            Table table = this.getTable(databaseName, tableName);
            expression = ExpressionHelper.buildExpressionFromPartialSpecification(table, values);
        }
        return this.glueMetastoreClientDelegate.getPartitions(databaseName, tableName, expression, max);
    }

    public boolean listPartitionsByExpr(String databaseName, String tableName, byte[] expr, String defaultPartitionName, short max, List<org.apache.hadoop.hive.metastore.api.Partition> result) throws TException {
        Preconditions.checkNotNull(result, (Object)"The result argument cannot be null.");
        String catalogExpression = ExpressionHelper.convertHiveExpressionToCatalogExpression(expr);
        List<org.apache.hadoop.hive.metastore.api.Partition> partitions = this.glueMetastoreClientDelegate.getPartitions(databaseName, tableName, catalogExpression, max);
        result.addAll(partitions);
        return false;
    }

    public List<org.apache.hadoop.hive.metastore.api.Partition> listPartitionsByFilter(String databaseName, String tableName, String filter, short max) throws MetaException, NoSuchObjectException, TException {
        if (StringUtils.isNotBlank((CharSequence)filter)) {
            filter = ExpressionHelper.replaceDoubleQuoteWithSingleQuotes(filter);
        }
        return this.glueMetastoreClientDelegate.getPartitions(databaseName, tableName, filter, max);
    }

    public List<org.apache.hadoop.hive.metastore.api.Partition> listPartitionsWithAuthInfo(String database, String table, short maxParts, String user, List<String> groups) throws MetaException, TException, NoSuchObjectException {
        List<org.apache.hadoop.hive.metastore.api.Partition> partitions = this.listPartitions(database, table, maxParts);
        for (org.apache.hadoop.hive.metastore.api.Partition p : partitions) {
            HiveObjectRef obj = new HiveObjectRef();
            obj.setObjectType(HiveObjectType.PARTITION);
            obj.setDbName(database);
            obj.setObjectName(table);
            obj.setPartValues(p.getValues());
            PrincipalPrivilegeSet set = this.get_privilege_set(obj, user, groups);
            p.setPrivileges(set);
        }
        return partitions;
    }

    public List<org.apache.hadoop.hive.metastore.api.Partition> listPartitionsWithAuthInfo(String database, String table, List<String> partVals, short maxParts, String user, List<String> groups) throws MetaException, TException, NoSuchObjectException {
        List<org.apache.hadoop.hive.metastore.api.Partition> partitions = this.listPartitions(database, table, partVals, maxParts);
        for (org.apache.hadoop.hive.metastore.api.Partition p : partitions) {
            PrincipalPrivilegeSet set;
            HiveObjectRef obj = new HiveObjectRef();
            obj.setObjectType(HiveObjectType.PARTITION);
            obj.setDbName(database);
            obj.setObjectName(table);
            obj.setPartValues(p.getValues());
            try {
                set = this.get_privilege_set(obj, user, groups);
            }
            catch (MetaException e) {
                logger.info((Object)String.format("No privileges found for user: %s, groups: [%s]", user, LoggingHelper.concatCollectionToStringForLogging(groups, ",")));
                set = new PrincipalPrivilegeSet();
            }
            p.setPrivileges(set);
        }
        return partitions;
    }

    public List<String> listTableNamesByFilter(String dbName, String filter, short maxTables) throws MetaException, TException, InvalidOperationException, UnknownDBException {
        return this.glueMetastoreClientDelegate.listTableNamesByFilter(dbName, filter, maxTables);
    }

    public List<HiveObjectPrivilege> list_privileges(String principal, PrincipalType principalType, HiveObjectRef objectRef) throws MetaException, TException {
        return this.glueMetastoreClientDelegate.listPrivileges(principal, principalType, objectRef);
    }

    public LockResponse lock(LockRequest lockRequest) throws NoSuchTxnException, TxnAbortedException, TException {
        return this.glueMetastoreClientDelegate.lock(lockRequest);
    }

    public void markPartitionForEvent(String dbName, String tblName, Map<String, String> partKVs, PartitionEventType eventType) throws MetaException, NoSuchObjectException, TException, UnknownTableException, UnknownDBException, UnknownPartitionException, InvalidPartitionException {
        this.glueMetastoreClientDelegate.markPartitionForEvent(dbName, tblName, partKVs, eventType);
    }

    public long openTxn(String user) throws TException {
        return this.glueMetastoreClientDelegate.openTxn(user);
    }

    public OpenTxnsResponse openTxns(String user, int numTxns) throws TException {
        return this.glueMetastoreClientDelegate.openTxns(user, numTxns);
    }

    public Map<String, String> partitionNameToSpec(String name) throws MetaException, TException {
        if (name.length() == 0) {
            return new HashMap<String, String>();
        }
        return Warehouse.makeSpecFromName((String)name);
    }

    public List<String> partitionNameToVals(String name) throws MetaException, TException {
        return this.glueMetastoreClientDelegate.partitionNameToVals(name);
    }

    public void reconnect() throws MetaException {
        logger.debug((Object)"reconnect() was called.");
    }

    public void renamePartition(String dbName, String tblName, List<String> partitionValues, org.apache.hadoop.hive.metastore.api.Partition newPartition) throws InvalidOperationException, MetaException, TException {
        org.apache.hadoop.hive.metastore.api.Partition oldPart;
        Table tbl;
        this.setDDLTime(newPartition);
        try {
            tbl = this.getTable(dbName, tblName);
            oldPart = this.getPartition(dbName, tblName, partitionValues);
        }
        catch (NoSuchObjectException e) {
            throw new InvalidOperationException(e.getMessage());
        }
        if (newPartition.getSd() == null || oldPart.getSd() == null) {
            throw new InvalidOperationException("Storage descriptor cannot be null");
        }
        if (!Strings.isNullOrEmpty((String)tbl.getTableType()) && tbl.getTableType().equals(TableType.EXTERNAL_TABLE.toString())) {
            newPartition.getSd().setLocation(oldPart.getSd().getLocation());
            this.renamePartitionInCatalog(dbName, tblName, partitionValues, newPartition);
        } else {
            Path destPath = this.getDestinationPathForRename(dbName, tbl, newPartition);
            Path srcPath = new Path(oldPart.getSd().getLocation());
            FileSystem srcFs = this.wh.getFs(srcPath);
            FileSystem destFs = this.wh.getFs(destPath);
            this.verifyDestinationLocation(srcFs, destFs, srcPath, destPath, tbl, newPartition);
            newPartition.getSd().setLocation(destPath.toString());
            this.renamePartitionInCatalog(dbName, tblName, partitionValues, newPartition);
            boolean success = true;
            try {
                if (srcFs.exists(srcPath)) {
                    Path destParentPath = destPath.getParent();
                    if (!this.hiveShims.mkdirs(this.wh, destParentPath)) {
                        throw new IOException("Unable to create path " + destParentPath);
                    }
                    this.wh.renameDir(srcPath, destPath, true);
                }
            }
            catch (IOException e) {
                success = false;
                throw new InvalidOperationException("Unable to access old location " + srcPath + " for partition " + tbl.getDbName() + "." + tbl.getTableName() + " " + partitionValues);
            }
            finally {
                if (!success) {
                    this.renamePartitionInCatalog(dbName, tblName, newPartition.getValues(), oldPart);
                }
            }
        }
    }

    private void verifyDestinationLocation(FileSystem srcFs, FileSystem destFs, Path srcPath, Path destPath, Table tbl, org.apache.hadoop.hive.metastore.api.Partition newPartition) throws InvalidOperationException {
        String oldPartLoc = srcPath.toString();
        String newPartLoc = destPath.toString();
        if (!FileUtils.equalsFileSystem((FileSystem)srcFs, (FileSystem)destFs)) {
            throw new InvalidOperationException("table new location " + destPath + " is on a different file system than the old location " + srcPath + ". This operation is not supported");
        }
        try {
            srcFs.exists(srcPath);
            if (newPartLoc.compareTo(oldPartLoc) != 0 && destFs.exists(destPath)) {
                throw new InvalidOperationException("New location for this partition " + tbl.getDbName() + "." + tbl.getTableName() + "." + newPartition.getValues() + " already exists : " + destPath);
            }
        }
        catch (IOException e) {
            throw new InvalidOperationException("Unable to access new location " + destPath + " for partition " + tbl.getDbName() + "." + tbl.getTableName() + " " + newPartition.getValues());
        }
    }

    private Path getDestinationPathForRename(String dbName, Table tbl, org.apache.hadoop.hive.metastore.api.Partition newPartition) throws InvalidOperationException, MetaException, TException {
        try {
            Path destPath = new Path(this.hiveShims.getDefaultTablePath(this.getDatabase(dbName), tbl.getTableName(), this.wh), Warehouse.makePartName((List)tbl.getPartitionKeys(), (List)newPartition.getValues()));
            return this.constructRenamedPath(destPath, new Path(newPartition.getSd().getLocation()));
        }
        catch (NoSuchObjectException e) {
            throw new InvalidOperationException("Unable to change partition or table. Database " + dbName + " does not exist Check metastore logs for detailed stack." + e.getMessage());
        }
    }

    private void setDDLTime(org.apache.hadoop.hive.metastore.api.Partition partition) {
        if (partition.getParameters() == null || partition.getParameters().get("transient_lastDdlTime") == null || Integer.parseInt((String)partition.getParameters().get("transient_lastDdlTime")) == 0) {
            partition.putToParameters("transient_lastDdlTime", Long.toString(System.currentTimeMillis() / 1000L));
        }
    }

    private void renamePartitionInCatalog(String databaseName, String tableName, List<String> partitionValues, org.apache.hadoop.hive.metastore.api.Partition newPartition) throws InvalidOperationException, MetaException, TException {
        this.glueMetastoreClientDelegate.renamePartitionInCatalog(databaseName, tableName, partitionValues, newPartition);
    }

    public long renewDelegationToken(String tokenStrForm) throws MetaException, TException {
        return this.glueMetastoreClientDelegate.renewDelegationToken(tokenStrForm);
    }

    public void rollbackTxn(long txnId) throws NoSuchTxnException, TException {
        this.glueMetastoreClientDelegate.rollbackTxn(txnId);
    }

    public void setMetaConf(String key, String value) throws MetaException, TException {
        HiveConf.ConfVars confVar = HiveConf.getMetaConf((String)key);
        if (confVar == null) {
            throw new MetaException("Invalid configuration key " + key);
        }
        String validate = confVar.validate(value);
        if (validate != null) {
            throw new MetaException("Invalid configuration value " + value + " for key " + key + " by " + validate);
        }
        this.conf.set(key, value);
    }

    public boolean setPartitionColumnStatistics(SetPartitionsStatsRequest request) throws NoSuchObjectException, InvalidObjectException, MetaException, TException, InvalidInputException {
        return this.glueMetastoreClientDelegate.setPartitionColumnStatistics(request);
    }

    public void flushCache() {
    }

    public Iterable<Map.Entry<Long, ByteBuffer>> getFileMetadata(List<Long> fileIds) throws TException {
        return this.glueMetastoreClientDelegate.getFileMetadata(fileIds);
    }

    public Iterable<Map.Entry<Long, MetadataPpdResult>> getFileMetadataBySarg(List<Long> fileIds, ByteBuffer sarg, boolean doGetFooters) throws TException {
        return this.glueMetastoreClientDelegate.getFileMetadataBySarg(fileIds, sarg, doGetFooters);
    }

    public void clearFileMetadata(List<Long> fileIds) throws TException {
        this.glueMetastoreClientDelegate.clearFileMetadata(fileIds);
    }

    public void putFileMetadata(List<Long> fileIds, List<ByteBuffer> metadata) throws TException {
        this.glueMetastoreClientDelegate.putFileMetadata(fileIds, metadata);
    }

    public boolean isSameConfObj(HiveConf hiveConf) {
        return this.conf == hiveConf;
    }

    public boolean cacheFileMetadata(String dbName, String tblName, String partName, boolean allParts) throws TException {
        return this.glueMetastoreClientDelegate.cacheFileMetadata(dbName, tblName, partName, allParts);
    }

    public List<SQLPrimaryKey> getPrimaryKeys(PrimaryKeysRequest primaryKeysRequest) throws TException {
        return Lists.newArrayList();
    }

    public List<SQLForeignKey> getForeignKeys(ForeignKeysRequest foreignKeysRequest) throws TException {
        return Lists.newArrayList();
    }

    public void createTableWithConstraints(Table table, List<SQLPrimaryKey> primaryKeys, List<SQLForeignKey> foreignKeys) throws com.amazonaws.services.glue.model.AlreadyExistsException, InvalidObjectException, MetaException, NoSuchObjectException, TException {
        this.glueMetastoreClientDelegate.createTableWithConstraints(table, primaryKeys, foreignKeys);
    }

    public void dropConstraint(String dbName, String tblName, String constraintName) throws MetaException, NoSuchObjectException, TException {
        this.glueMetastoreClientDelegate.dropConstraint(dbName, tblName, constraintName);
    }

    public void addPrimaryKey(List<SQLPrimaryKey> primaryKeyCols) throws MetaException, NoSuchObjectException, TException {
        this.glueMetastoreClientDelegate.addPrimaryKey(primaryKeyCols);
    }

    public void addForeignKey(List<SQLForeignKey> foreignKeyCols) throws MetaException, NoSuchObjectException, TException {
        this.glueMetastoreClientDelegate.addForeignKey(foreignKeyCols);
    }

    public ShowCompactResponse showCompactions() throws TException {
        return this.glueMetastoreClientDelegate.showCompactions();
    }

    public void addDynamicPartitions(long txnId, String dbName, String tblName, List<String> partNames) throws TException {
        this.glueMetastoreClientDelegate.addDynamicPartitions(txnId, dbName, tblName, partNames);
    }

    public void addDynamicPartitions(long txnId, String dbName, String tblName, List<String> partNames, DataOperationType operationType) throws TException {
        this.glueMetastoreClientDelegate.addDynamicPartitions(txnId, dbName, tblName, partNames, operationType);
    }

    public void insertTable(Table table, boolean overwrite) throws MetaException {
        this.glueMetastoreClientDelegate.insertTable(table, overwrite);
    }

    public NotificationEventResponse getNextNotification(long lastEventId, int maxEvents, IMetaStoreClient.NotificationFilter notificationFilter) throws TException {
        return this.glueMetastoreClientDelegate.getNextNotification(lastEventId, maxEvents, notificationFilter);
    }

    public CurrentNotificationEventId getCurrentNotificationEventId() throws TException {
        return this.glueMetastoreClientDelegate.getCurrentNotificationEventId();
    }

    public FireEventResponse fireListenerEvent(FireEventRequest fireEventRequest) throws TException {
        return this.glueMetastoreClientDelegate.fireListenerEvent(fireEventRequest);
    }

    public ShowLocksResponse showLocks() throws TException {
        return this.glueMetastoreClientDelegate.showLocks();
    }

    public ShowLocksResponse showLocks(ShowLocksRequest showLocksRequest) throws TException {
        return this.glueMetastoreClientDelegate.showLocks(showLocksRequest);
    }

    public GetOpenTxnsInfoResponse showTxns() throws TException {
        return this.glueMetastoreClientDelegate.showTxns();
    }

    @Deprecated
    public boolean tableExists(String tableName) throws MetaException, TException, UnknownDBException {
        return this.tableExists("default", tableName);
    }

    public boolean tableExists(String databaseName, String tableName) throws MetaException, TException, UnknownDBException {
        return this.glueMetastoreClientDelegate.tableExists(databaseName, tableName);
    }

    public void unlock(long lockId) throws NoSuchLockException, TxnOpenException, TException {
        this.glueMetastoreClientDelegate.unlock(lockId);
    }

    public boolean updatePartitionColumnStatistics(ColumnStatistics columnStatistics) throws NoSuchObjectException, InvalidObjectException, MetaException, TException, InvalidInputException {
        return this.glueMetastoreClientDelegate.updatePartitionColumnStatistics(columnStatistics);
    }

    public boolean updateTableColumnStatistics(ColumnStatistics columnStatistics) throws NoSuchObjectException, InvalidObjectException, MetaException, TException, InvalidInputException {
        return this.glueMetastoreClientDelegate.updateTableColumnStatistics(columnStatistics);
    }

    public void validatePartitionNameCharacters(List<String> part_vals) throws TException, MetaException {
        try {
            String partitionValidationRegex = this.conf.getVar(HiveConf.ConfVars.METASTORE_PARTITION_NAME_WHITELIST_PATTERN);
            Pattern partitionValidationPattern = Strings.isNullOrEmpty((String)partitionValidationRegex) ? null : Pattern.compile(partitionValidationRegex);
            MetaStoreUtils.validatePartitionNameCharacters(part_vals, (Pattern)partitionValidationPattern);
        }
        catch (Exception e) {
            if (e instanceof MetaException) {
                throw (MetaException)((Object)e);
            }
            throw new MetaException(e.getMessage());
        }
    }

    private Path constructRenamedPath(Path defaultNewPath, Path currentPath) {
        URI currentUri = currentPath.toUri();
        return new Path(currentUri.getScheme(), currentUri.getAuthority(), defaultNewPath.toUri().getPath());
    }

    public static class Builder {
        private HiveConf conf;
        private Warehouse wh;
        private GlueClientFactory clientFactory;
        private boolean createDefaults = true;
        private String catalogId;
        private GlueMetastoreClientDelegate glueMetastoreClientDelegate;

        public Builder withHiveConf(HiveConf conf) {
            this.conf = conf;
            return this;
        }

        public Builder withClientFactory(GlueClientFactory clientFactory) {
            this.clientFactory = clientFactory;
            return this;
        }

        public Builder withCatalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public Builder withGlueMetastoreClientDelegate(GlueMetastoreClientDelegate clientDelegate) {
            this.glueMetastoreClientDelegate = clientDelegate;
            return this;
        }

        public Builder withWarehouse(Warehouse wh) {
            this.wh = wh;
            return this;
        }

        public AWSCatalogMetastoreClient build() throws MetaException {
            return new AWSCatalogMetastoreClient(this);
        }

        public Builder createDefaults(boolean createDefaultDB) {
            this.createDefaults = createDefaultDB;
            return this;
        }
    }
}

