/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.graphx;

import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.graphx.Graph;
import org.apache.spark.graphx.Graph$;
import org.apache.spark.graphx.GraphOps;
import org.apache.spark.graphx.GraphXUtils$;
import org.apache.spark.graphx.PartitionStrategy$;
import org.apache.spark.graphx.util.GraphGenerators$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.SeqLike;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;

public final class SynthBenchmark$ {
    public static SynthBenchmark$ MODULE$;

    static {
        new SynthBenchmark$();
    }

    public void main(String[] args) {
        Tuple2[] options = (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).map((Function1 & Serializable & scala.Serializable)arg -> {
            String[] stringArray = new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(Predef$.MODULE$.augmentString(arg)).dropWhile((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)SynthBenchmark$.$anonfun$main$2(BoxesRunTime.unboxToChar((Object)x$1)))))).split('=');
            Option option = Array$.MODULE$.unapplySeq((Object)stringArray);
            if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(2) == 0) {
                String opt = (String)((SeqLike)option.get()).apply(0);
                String v = (String)((SeqLike)option.get()).apply(1);
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)opt), (Object)v);
            }
            throw new IllegalArgumentException(new StringBuilder(18).append("Invalid argument: ").append((String)arg).toString());
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
        ObjectRef app = ObjectRef.create((Object)"pagerank");
        IntRef niter = IntRef.create((int)10);
        IntRef numVertices = IntRef.create((int)100000);
        ObjectRef numEPart = ObjectRef.create((Object)None$.MODULE$);
        ObjectRef partitionStrategy = ObjectRef.create((Object)None$.MODULE$);
        DoubleRef mu = DoubleRef.create((double)4.0);
        DoubleRef sigma = DoubleRef.create((double)1.3);
        ObjectRef degFile = ObjectRef.create((Object)"");
        IntRef seed = IntRef.create((int)-1);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])options)).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            SynthBenchmark$.$anonfun$main$3(app, niter, numVertices, numEPart, partitionStrategy, mu, sigma, degFile, seed, x0$1);
            return BoxedUnit.UNIT;
        });
        SparkConf conf = new SparkConf().setAppName(new StringBuilder(42).append("GraphX Synth Benchmark (nverts = ").append(numVertices.elem).append(", app = ").append((String)app.elem).append(")").toString());
        GraphXUtils$.MODULE$.registerKryoClasses(conf);
        SparkContext sc = new SparkContext(conf);
        Predef$.MODULE$.println((Object)"Creating graph...");
        Graph unpartitionedGraph = GraphGenerators$.MODULE$.logNormalGraph(sc, numVertices.elem, BoxesRunTime.unboxToInt((Object)((Option)numEPart.elem).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> sc.defaultParallelism())), mu.elem, sigma.elem, (long)seed.elem);
        Graph graph = ((Graph)Option$.MODULE$.option2Iterable((Option)partitionStrategy.elem).foldLeft((Object)unpartitionedGraph, (Function2 & Serializable & scala.Serializable)(x$2, x$3) -> x$2.partitionBy(x$3))).cache();
        long startTime = System.currentTimeMillis();
        long numEdges = graph.edges().count();
        Predef$.MODULE$.println((Object)new StringBuilder(50).append("Done creating graph. Num Vertices = ").append(numVertices.elem).append(", Num Edges = ").append(numEdges).toString());
        long loadTime = System.currentTimeMillis() - startTime;
        if (!((String)degFile.elem).isEmpty()) {
            FileOutputStream fos = new FileOutputStream((String)degFile.elem);
            PrintWriter pos = new PrintWriter(fos);
            Map hist = graph.vertices().leftJoin((RDD)Graph$.MODULE$.graphToGraphOps(graph, ClassTag$.MODULE$.Long(), ClassTag$.MODULE$.Int()).degrees(), (Function3 & Serializable & scala.Serializable)(id, x$4, optDeg) -> BoxesRunTime.boxToInteger((int)SynthBenchmark$.$anonfun$main$6(BoxesRunTime.unboxToLong((Object)id), BoxesRunTime.unboxToLong((Object)x$4), optDeg)), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int()).map((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToInteger((int)p._2$mcI$sp()), ClassTag$.MODULE$.Int()).countByValue((Ordering)Ordering.Int$.MODULE$);
            hist.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                SynthBenchmark$.$anonfun$main$9(pos, x0$2);
                return BoxedUnit.UNIT;
            });
        }
        startTime = System.currentTimeMillis();
        String string = (String)app.elem;
        String string2 = "pagerank";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            Predef$.MODULE$.println((Object)"Running PageRank");
            GraphOps qual$1 = Graph$.MODULE$.graphToGraphOps(graph, ClassTag$.MODULE$.Long(), ClassTag$.MODULE$.Int());
            int x$1 = niter.elem;
            double x$22 = qual$1.staticPageRank$default$2();
            double totalPR = RDD$.MODULE$.doubleRDDToDoubleRDDFunctions(qual$1.staticPageRank(x$1, x$22).vertices().map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToDouble((double)x$5._2$mcD$sp()), ClassTag$.MODULE$.Double())).sum();
            Predef$.MODULE$.println((Object)new StringBuilder(17).append("Total PageRank = ").append(totalPR).toString());
        } else {
            String string3 = (String)app.elem;
            String string4 = "cc";
            if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                Predef$.MODULE$.println((Object)"Running Connected Components");
                long numComponents = Graph$.MODULE$.graphToGraphOps(graph, ClassTag$.MODULE$.Long(), ClassTag$.MODULE$.Int()).connectedComponents().vertices().map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToLong((long)x$6._2$mcJ$sp()), ClassTag$.MODULE$.apply(Long.TYPE)).distinct().count();
                Predef$.MODULE$.println((Object)new StringBuilder(23).append("Number of components = ").append(numComponents).toString());
            }
        }
        long runTime = System.currentTimeMillis() - startTime;
        Predef$.MODULE$.println((Object)new StringBuilder(15).append("Num Vertices = ").append(numVertices.elem).toString());
        Predef$.MODULE$.println((Object)new StringBuilder(12).append("Num Edges = ").append(numEdges).toString());
        Predef$.MODULE$.println((Object)new StringBuilder(24).append("Creation time = ").append((double)loadTime / 1000.0).append(" seconds").toString());
        Predef$.MODULE$.println((Object)new StringBuilder(19).append("Run time = ").append((double)runTime / 1000.0).append(" seconds").toString());
        sc.stop();
    }

    public static final /* synthetic */ boolean $anonfun$main$2(char x$1) {
        return x$1 == '-';
    }

    public static final /* synthetic */ void $anonfun$main$3(ObjectRef app$1, IntRef niter$1, IntRef numVertices$1, ObjectRef numEPart$1, ObjectRef partitionStrategy$1, DoubleRef mu$1, DoubleRef sigma$1, ObjectRef degFile$1, IntRef seed$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String string = (String)tuple2._1();
            String v = (String)tuple2._2();
            if ("app".equals(string)) {
                app$1.elem = v;
                return;
            }
        }
        if (tuple2 != null) {
            String string = (String)tuple2._1();
            String v = (String)tuple2._2();
            if ("niters".equals(string)) {
                niter$1.elem = new StringOps(Predef$.MODULE$.augmentString(v)).toInt();
                return;
            }
        }
        if (tuple2 != null) {
            String string = (String)tuple2._1();
            String v = (String)tuple2._2();
            if ("nverts".equals(string)) {
                numVertices$1.elem = new StringOps(Predef$.MODULE$.augmentString(v)).toInt();
                return;
            }
        }
        if (tuple2 != null) {
            String string = (String)tuple2._1();
            String v = (String)tuple2._2();
            if ("numEPart".equals(string)) {
                numEPart$1.elem = new Some((Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(v)).toInt()));
                return;
            }
        }
        if (tuple2 != null) {
            String string = (String)tuple2._1();
            String v = (String)tuple2._2();
            if ("partStrategy".equals(string)) {
                partitionStrategy$1.elem = new Some((Object)PartitionStrategy$.MODULE$.fromString(v));
                return;
            }
        }
        if (tuple2 != null) {
            String string = (String)tuple2._1();
            String v = (String)tuple2._2();
            if ("mu".equals(string)) {
                mu$1.elem = new StringOps(Predef$.MODULE$.augmentString(v)).toDouble();
                return;
            }
        }
        if (tuple2 != null) {
            String string = (String)tuple2._1();
            String v = (String)tuple2._2();
            if ("sigma".equals(string)) {
                sigma$1.elem = new StringOps(Predef$.MODULE$.augmentString(v)).toDouble();
                return;
            }
        }
        if (tuple2 != null) {
            String string = (String)tuple2._1();
            String v = (String)tuple2._2();
            if ("degFile".equals(string)) {
                degFile$1.elem = v;
                return;
            }
        }
        if (tuple2 != null) {
            String string = (String)tuple2._1();
            String v = (String)tuple2._2();
            if ("seed".equals(string)) {
                seed$1.elem = new StringOps(Predef$.MODULE$.augmentString(v)).toInt();
                return;
            }
        }
        if (tuple2 != null) {
            String opt = (String)tuple2._1();
            throw new IllegalArgumentException(new StringBuilder(16).append("Invalid option: ").append(opt).toString());
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ int $anonfun$main$6(long id, long x$4, Option optDeg) {
        return BoxesRunTime.unboxToInt((Object)optDeg.getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
    }

    public static final /* synthetic */ void $anonfun$main$9(PrintWriter pos$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            int deg = tuple2._1$mcI$sp();
            long count = tuple2._2$mcJ$sp();
            pos$1.println(new StringBuilder(3).append(deg).append(" \t ").append(count).toString());
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    private SynthBenchmark$() {
        MODULE$ = this;
    }
}

