/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.aggregate;

import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.dsl.package$expressions$;
import org.apache.spark.sql.catalyst.expressions.Add;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.CheckOverflowInSum;
import org.apache.spark.sql.catalyst.expressions.DecimalAddNoOverflowCheck;
import org.apache.spark.sql.catalyst.expressions.EvalMode$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.If;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.KnownNotNull;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.Predicate;
import org.apache.spark.sql.catalyst.expressions.SupportQueryContext;
import org.apache.spark.sql.catalyst.expressions.aggregate.DeclarativeAggregate;
import org.apache.spark.sql.catalyst.expressions.aggregate.Sum$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.trees.SQLQueryContext;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.trees.TreePattern$;
import org.apache.spark.sql.catalyst.trees.UnaryLike;
import org.apache.spark.sql.catalyst.util.TypeUtils$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AnsiIntervalType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DayTimeIntervalType;
import org.apache.spark.sql.types.DayTimeIntervalType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.IntegralType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.NumericType$;
import org.apache.spark.sql.types.TypeCollection$;
import org.apache.spark.sql.types.YearMonthIntervalType;
import org.apache.spark.sql.types.YearMonthIntervalType$;
import scala.Enumeration;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(expr) - Returns the sum calculated from values of a group.", examples="\n    Examples:\n      > SELECT _FUNC_(col) FROM VALUES (5), (10), (15) AS tab(col);\n       30\n      > SELECT _FUNC_(col) FROM VALUES (NULL), (10), (15) AS tab(col);\n       25\n      > SELECT _FUNC_(col) FROM VALUES (NULL), (NULL) AS tab(col);\n       NULL\n  ", group="agg_funcs", since="1.0.0")
@ScalaSignature(bytes="\u0006\u0001\t5e\u0001B\u0017/\u0001vB\u0001b\u0017\u0001\u0003\u0016\u0004%\t\u0001\u0018\u0005\t;\u0002\u0011\t\u0012)A\u0005\u0019\"Aa\f\u0001BK\u0002\u0013\u0005q\f\u0003\u0005i\u0001\tE\t\u0015!\u0003a\u0011\u0015I\u0007\u0001\"\u0001k\u0011\u0015I\u0007\u0001\"\u0001o\u0011\u0015\u0001\b\u0001\"\u0003r\u0011\u0015)\b\u0001\"\u0011r\u0011\u00151\b\u0001\"\u0011x\u0011\u0015q\b\u0001\"\u0011\u0000\u0011\u001d\ty\u0002\u0001C!\u0003CA\u0011\"a\f\u0001\u0005\u0004%)%!\r\t\u0011\u0005m\u0003\u0001)A\u0007\u0003gA!\"!\u0018\u0001\u0011\u000b\u0007I\u0011BA0\u0011)\ti\u0007\u0001EC\u0002\u0013%\u0011q\u000e\u0005\u000b\u0003o\u0002\u0001R1A\u0005\n\u0005=\u0004BCA=\u0001!\u0015\r\u0011\"\u0003\u0002|!9\u00111\u0011\u0001\u0005\n\u0005\u0015\u0005BCAH\u0001!\u0015\r\u0011\"\u0011\u0002\u0012\"Q\u0011Q\u0013\u0001\t\u0006\u0004%\t%a&\t\u0015\u0005m\u0005\u0001#b\u0001\n\u0003\n9\n\u0003\u0006\u0002\u001e\u0002A)\u0019!C!\u0003/C\u0011\"a(\u0001\u0011\u000b\u0007I\u0011\t/\t\u000f\u0005\u0005\u0006\u0001\"\u0011\u0002$\"9\u0011\u0011\u0017\u0001\u0005B\u0005M\u0006bBAa\u0001\u0011E\u00131\u0019\u0005\n\u0003\u0013\u0004\u0011\u0011!C\u0001\u0003\u0017D\u0011\"!5\u0001#\u0003%\t!a5\t\u0013\u0005%\b!%A\u0005\u0002\u0005-\b\"CAx\u0001\u0005\u0005I\u0011IAy\u0011%\u0011\u0019\u0001AA\u0001\n\u0003\u0011)\u0001C\u0005\u0003\u000e\u0001\t\t\u0011\"\u0001\u0003\u0010!I!Q\u0003\u0001\u0002\u0002\u0013\u0005#q\u0003\u0005\n\u0005G\u0001\u0011\u0011!C\u0001\u0005KA\u0011B!\u000b\u0001\u0003\u0003%\tEa\u000b\b\u0013\t=c&!A\t\u0002\tEc\u0001C\u0017/\u0003\u0003E\tAa\u0015\t\r%,C\u0011\u0001B1\u0011%\u0011\u0019'JA\u0001\n\u000b\u0012)\u0007C\u0005\u0003h\u0015\n\t\u0011\"!\u0003j!I!qN\u0013\u0012\u0002\u0013\u0005\u00111\u001e\u0005\n\u0005c*\u0013\u0011!CA\u0005gB\u0011B!!&#\u0003%\t!a;\t\u0013\t\rU%!A\u0005\n\t\u0015%aA*v[*\u0011q\u0006M\u0001\nC\u001e<'/Z4bi\u0016T!!\r\u001a\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003gQ\n\u0001bY1uC2L8\u000f\u001e\u0006\u0003kY\n1a]9m\u0015\t9\u0004(A\u0003ta\u0006\u00148N\u0003\u0002:u\u00051\u0011\r]1dQ\u0016T\u0011aO\u0001\u0004_J<7\u0001A\n\b\u0001y\u0012ei\u0014*Y!\ty\u0004)D\u0001/\u0013\t\teF\u0001\u000bEK\u000ed\u0017M]1uSZ,\u0017iZ4sK\u001e\fG/\u001a\t\u0003\u0007\u0012k\u0011\u0001M\u0005\u0003\u000bB\u0012a#S7qY&\u001c\u0017\u000e^\"bgRLe\u000e];u)f\u0004Xm\u001d\t\u0004\u000f*cU\"\u0001%\u000b\u0005%\u0013\u0014!\u0002;sK\u0016\u001c\u0018BA&I\u0005%)f.\u0019:z\u0019&\\W\r\u0005\u0002D\u001b&\u0011a\n\r\u0002\u000b\u000bb\u0004(/Z:tS>t\u0007CA\"Q\u0013\t\t\u0006GA\nTkB\u0004xN\u001d;Rk\u0016\u0014\u0018pQ8oi\u0016DH\u000f\u0005\u0002T-6\tAKC\u0001V\u0003\u0015\u00198-\u00197b\u0013\t9FKA\u0004Qe>$Wo\u0019;\u0011\u0005MK\u0016B\u0001.U\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003\u0015\u0019\u0007.\u001b7e+\u0005a\u0015AB2iS2$\u0007%\u0001\u0005fm\u0006dWj\u001c3f+\u0005\u0001\u0007CA1e\u001d\t\u0019%-\u0003\u0002da\u0005AQI^1m\u001b>$W-\u0003\u0002fM\n)a+\u00197vK&\u0011q\r\u0016\u0002\f\u000b:,X.\u001a:bi&|g.A\u0005fm\u0006dWj\u001c3fA\u00051A(\u001b8jiz\"2a\u001b7n!\ty\u0004\u0001C\u0003\\\u000b\u0001\u0007A\nC\u0004_\u000bA\u0005\t\u0019\u00011\u0015\u0005-|\u0007\"B.\u0007\u0001\u0004a\u0015AE:i_VdG\r\u0016:bG.L5/R7qif,\u0012A\u001d\t\u0003'NL!\u0001\u001e+\u0003\u000f\t{w\u000e\\3b]\u0006Aa.\u001e7mC\ndW-\u0001\u0005eCR\fG+\u001f9f+\u0005A\bCA=}\u001b\u0005Q(BA>5\u0003\u0015!\u0018\u0010]3t\u0013\ti(P\u0001\u0005ECR\fG+\u001f9f\u0003)Ig\u000e];u)f\u0004Xm]\u000b\u0003\u0003\u0003\u0001b!a\u0001\u0002\u0014\u0005ea\u0002BA\u0003\u0003\u001fqA!a\u0002\u0002\u000e5\u0011\u0011\u0011\u0002\u0006\u0004\u0003\u0017a\u0014A\u0002\u001fs_>$h(C\u0001V\u0013\r\t\t\u0002V\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t)\"a\u0006\u0003\u0007M+\u0017OC\u0002\u0002\u0012Q\u00032!_A\u000e\u0013\r\tiB\u001f\u0002\u0011\u0003\n\u001cHO]1di\u0012\u000bG/\u0019+za\u0016\f1c\u00195fG.Le\u000e];u\t\u0006$\u0018\rV=qKN$\"!a\t\u0011\t\u0005\u0015\u00121F\u0007\u0003\u0003OQ1!!\u000b3\u0003!\tg.\u00197zg&\u001c\u0018\u0002BA\u0017\u0003O\u0011q\u0002V=qK\u000eCWmY6SKN,H\u000e^\u0001\r]>$W\rU1ui\u0016\u0014hn]\u000b\u0003\u0003g\u0001b!a\u0001\u0002\u0014\u0005U\u0002\u0003BA\u001c\u0003+rA!!\u000f\u0002R9!\u00111HA(\u001d\u0011\ti$!\u0014\u000f\t\u0005}\u00121\n\b\u0005\u0003\u0003\nIE\u0004\u0003\u0002D\u0005\u001dc\u0002BA\u0004\u0003\u000bJ\u0011aO\u0005\u0003siJ!a\u000e\u001d\n\u0005U2\u0014BA\u001a5\u0013\tI%'C\u0002\u0002T!\u000b1\u0002\u0016:fKB\u000bG\u000f^3s]&!\u0011qKA-\u0005-!&/Z3QCR$XM\u001d8\u000b\u0007\u0005M\u0003*A\u0007o_\u0012,\u0007+\u0019;uKJt7\u000fI\u0001\u000be\u0016\u001cX\u000f\u001c;UsB,WCAA1%\u0019\t\u0019'a\u001aS1\u001a1\u0011Q\r\u0001\u0001\u0003C\u0012A\u0002\u0010:fM&tW-\\3oiz\u00022!_A5\u0013\r\tYG\u001f\u0002\u000b\u0003R|W.[2UsB,\u0017aA:v[V\u0011\u0011\u0011\u000f\t\u0004\u0007\u0006M\u0014bAA;a\t\u0011\u0012\t\u001e;sS\n,H/\u001a*fM\u0016\u0014XM\\2f\u0003\u001dI7/R7qif\fAA_3s_V\u0011\u0011Q\u0010\t\u0004\u0007\u0006}\u0014bAAAa\t9A*\u001b;fe\u0006d\u0017aA1eIR)A*a\"\u0002\f\"1\u0011\u0011\u0012\nA\u00021\u000bA\u0001\\3gi\"1\u0011Q\u0012\nA\u00021\u000bQA]5hQR\f1#Y4h\u0005V4g-\u001a:BiR\u0014\u0018NY;uKN,\"!a%\u0011\r\u0005\r\u00111CA9\u00035Ig.\u001b;jC24\u0016\r\\;fgV\u0011\u0011\u0011\u0014\t\u0006\u0003\u0007\t\u0019\u0002T\u0001\u0012kB$\u0017\r^3FqB\u0014Xm]:j_:\u001c\u0018\u0001E7fe\u001e,W\t\u001f9sKN\u001c\u0018n\u001c8t\u0003I)g/\u00197vCR,W\t\u001f9sKN\u001c\u0018n\u001c8\u0002\u001b\u0019d\u0017\r^!sOVlWM\u001c;t+\t\t)\u000b\u0005\u0004\u0002\u0004\u0005\u001d\u00161V\u0005\u0005\u0003S\u000b9B\u0001\u0005Ji\u0016\u0014\u0018\r^8s!\r\u0019\u0016QV\u0005\u0004\u0003_#&aA!os\u0006\u0001\u0012N\\5u#V,'/_\"p]R,\u0007\u0010\u001e\u000b\u0003\u0003k\u0003RaUA\\\u0003wK1!!/U\u0005\u0019y\u0005\u000f^5p]B\u0019q)!0\n\u0007\u0005}\u0006JA\bT#2\u000bV/\u001a:z\u0007>tG/\u001a=u\u0003Q9\u0018\u000e\u001e5OK^\u001c\u0005.\u001b7e\u0013:$XM\u001d8bYR\u0019A*!2\t\r\u0005\u001d'\u00041\u0001M\u0003!qWm^\"iS2$\u0017\u0001B2paf$Ra[Ag\u0003\u001fDqaW\u000e\u0011\u0002\u0003\u0007A\nC\u0004_7A\u0005\t\u0019\u00011\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011Q\u001b\u0016\u0004\u0019\u0006]7FAAm!\u0011\tY.!:\u000e\u0005\u0005u'\u0002BAp\u0003C\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\rH+\u0001\u0006b]:|G/\u0019;j_:LA!a:\u0002^\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011Q\u001e\u0016\u0004A\u0006]\u0017!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002tB!\u0011Q_A\u0000\u001b\t\t9P\u0003\u0003\u0002z\u0006m\u0018\u0001\u00027b]\u001eT!!!@\u0002\t)\fg/Y\u0005\u0005\u0005\u0003\t9P\u0001\u0004TiJLgnZ\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0005\u000f\u00012a\u0015B\u0005\u0013\r\u0011Y\u0001\u0016\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003W\u0013\t\u0002C\u0005\u0003\u0014\u0001\n\t\u00111\u0001\u0003\b\u0005\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"A!\u0007\u0011\r\tm!\u0011EAV\u001b\t\u0011iBC\u0002\u0003 Q\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\tIK!\b\u0002\u0011\r\fg.R9vC2$2A\u001dB\u0014\u0011%\u0011\u0019BIA\u0001\u0002\u0004\tY+\u0001\u0004fcV\fGn\u001d\u000b\u0004e\n5\u0002\"\u0003B\nG\u0005\u0005\t\u0019AAVQM\u0001!\u0011\u0007B\u001c\u0005s\u0011iDa\u0010\u0003D\t\u0015#\u0011\nB&!\r\u0019%1G\u0005\u0004\u0005k\u0001$!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0005w\t\u0011i\u0018$V\u001d\u000e{\u0006&\u001a=qe&\u0002S\u0006\t*fiV\u0014hn\u001d\u0011uQ\u0016\u00043/^7!G\u0006d7-\u001e7bi\u0016$\u0007E\u001a:p[\u00022\u0018\r\\;fg\u0002zg\rI1!OJ|W\u000f\u001d\u0018\u0002\u0011\u0015D\u0018-\u001c9mKN\f#A!\u0011\u0002\u0003\u007fT\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006fY8mS\u00012%kT'!-\u0006cU+R*!QUJC\u0006\t\u00152a%b\u0003\u0005K\u00196S\u0001\n5\u000b\t;bE\"\u001aw\u000e\\\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AM\u0002$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK2pY&\u0002cIU(NAY\u000bE*V#TA!rU\u000b\u0014'*Y\u0001B\u0013\u0007M\u0015-A!\nT'\u000b\u0011B'\u0002\"\u0018M\u0019\u0015d_2L3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u001a6\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"\u001aw\u000e\\\u0015!\rJ{U\n\t,B\u0019V+5\u000b\t\u0015O+2c\u0015\u0006\f\u0011)\u001dVcE*\u000b\u0011B'\u0002\"\u0018M\u0019\u0015d_2L3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t(V\u00192S\u0001\u0005I\u0001\u0006OJ|W\u000f]\u0011\u0003\u0005\u000f\n\u0011\"Y4h?\u001a,hnY:\u0002\u000bMLgnY3\"\u0005\t5\u0013!B\u0019/a9\u0002\u0014aA*v[B\u0011q(J\n\u0005K\tU\u0003\fE\u0004\u0003X\tuC\nY6\u000e\u0005\te#b\u0001B.)\u00069!/\u001e8uS6,\u0017\u0002\u0002B0\u00053\u0012\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c83)\t\u0011\t&\u0001\u0005u_N#(/\u001b8h)\t\t\u00190A\u0003baBd\u0017\u0010F\u0003l\u0005W\u0012i\u0007C\u0003\\Q\u0001\u0007A\nC\u0004_QA\u0005\t\u0019\u00011\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uII\nq!\u001e8baBd\u0017\u0010\u0006\u0003\u0003v\tu\u0004#B*\u00028\n]\u0004#B*\u0003z1\u0003\u0017b\u0001B>)\n1A+\u001e9mKJB\u0001Ba +\u0003\u0003\u0005\ra[\u0001\u0004q\u0012\u0002\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$#'A\u0006sK\u0006$'+Z:pYZ,GC\u0001BD!\u0011\t)P!#\n\t\t-\u0015q\u001f\u0002\u0007\u001f\nTWm\u0019;")
public class Sum
extends DeclarativeAggregate
implements ImplicitCastInputTypes,
UnaryLike<Expression>,
SupportQueryContext {
    private AtomicType resultType;
    private AttributeReference sum;
    private AttributeReference isEmpty;
    private Literal zero;
    private Seq<AttributeReference> aggBufferAttributes;
    private Seq<Expression> initialValues;
    private Seq<Expression> updateExpressions;
    private Seq<Expression> mergeExpressions;
    private Expression evaluateExpression;
    private final Expression child;
    private final Enumeration.Value evalMode;
    private final Seq<Enumeration.Value> nodePatterns;
    private Option<SQLQueryContext> queryContext;
    private transient Seq<Expression> children;
    private volatile int bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public static Enumeration.Value $lessinit$greater$default$2() {
        return Sum$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple2<Expression, Enumeration.Value>> unapply(Sum sum) {
        return Sum$.MODULE$.unapply(sum);
    }

    public static Enumeration.Value apply$default$2() {
        return Sum$.MODULE$.apply$default$2();
    }

    public static Function1<Tuple2<Expression, Enumeration.Value>, Sum> tupled() {
        return Sum$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Enumeration.Value, Sum>> curried() {
        return Sum$.MODULE$.curried();
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$catalyst$expressions$SupportQueryContext$$super$copyTagsFrom(Expression other) {
        super.copyTagsFrom(other);
    }

    @Override
    public SQLQueryContext getContextOrNull() {
        return SupportQueryContext.getContextOrNull$(this);
    }

    @Override
    public String getContextOrNullCode(CodegenContext ctx, boolean withErrorContext) {
        return SupportQueryContext.getContextOrNullCode$(this, ctx, withErrorContext);
    }

    @Override
    public boolean getContextOrNullCode$default$2() {
        return SupportQueryContext.getContextOrNullCode$default$2$(this);
    }

    @Override
    public void copyTagsFrom(Expression other) {
        SupportQueryContext.copyTagsFrom$(this, other);
    }

    @Override
    public final TreeNode mapChildren(Function1 f) {
        return UnaryLike.mapChildren$(this, f);
    }

    @Override
    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return UnaryLike.withNewChildrenInternal$(this, newChildren);
    }

    @Override
    public Option<SQLQueryContext> queryContext() {
        return this.queryContext;
    }

    @Override
    public void queryContext_$eq(Option<SQLQueryContext> x$1) {
        this.queryContext = x$1;
    }

    private Seq<Expression> children$lzycompute() {
        Sum sum = this;
        synchronized (sum) {
            if (!this.bitmap$trans$0) {
                this.children = UnaryLike.children$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.children;
    }

    @Override
    public final Seq<Expression> children() {
        if (!this.bitmap$trans$0) {
            return this.children$lzycompute();
        }
        return this.children;
    }

    @Override
    public Expression child() {
        return this.child;
    }

    public Enumeration.Value evalMode() {
        return this.evalMode;
    }

    private boolean shouldTrackIsEmpty() {
        AtomicType atomicType = this.resultType();
        if (atomicType instanceof DecimalType) {
            return true;
        }
        if (atomicType instanceof IntegralType ? true : atomicType instanceof AnsiIntervalType) {
            Enumeration.Value value = this.evalMode();
            Enumeration.Value value2 = EvalMode$.MODULE$.TRY();
            if (!(value != null ? !value.equals(value2) : value2 != null)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public DataType dataType() {
        return this.resultType();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)new .colon.colon((Object)TypeCollection$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{NumericType$.MODULE$, YearMonthIntervalType$.MODULE$, DayTimeIntervalType$.MODULE$})), (List)Nil$.MODULE$);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return TypeUtils$.MODULE$.checkForAnsiIntervalOrNumericType(this.child());
    }

    @Override
    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private AtomicType resultType$lzycompute() {
        Sum sum = this;
        synchronized (sum) {
            if ((this.bitmap$0 & 1) == 0) {
                LongType$ longType$;
                DecimalType decimalType;
                Option option;
                DataType dataType = this.child().dataType();
                if (dataType instanceof DecimalType && !(option = DecimalType.Fixed$.MODULE$.unapply(decimalType = (DecimalType)dataType)).isEmpty()) {
                    int precision = ((Tuple2)option.get())._1$mcI$sp();
                    int scale = ((Tuple2)option.get())._2$mcI$sp();
                    longType$ = DecimalType$.MODULE$.bounded(precision + 10, scale);
                } else if (dataType instanceof IntegralType) {
                    longType$ = LongType$.MODULE$;
                } else if (dataType instanceof YearMonthIntervalType) {
                    YearMonthIntervalType yearMonthIntervalType = (YearMonthIntervalType)dataType;
                    longType$ = yearMonthIntervalType;
                } else if (dataType instanceof DayTimeIntervalType) {
                    DayTimeIntervalType dayTimeIntervalType = (DayTimeIntervalType)dataType;
                    longType$ = dayTimeIntervalType;
                } else {
                    longType$ = DoubleType$.MODULE$;
                }
                this.resultType = longType$;
                this.bitmap$0 |= 1;
            }
        }
        return this.resultType;
    }

    private AtomicType resultType() {
        if ((this.bitmap$0 & 1) == 0) {
            return this.resultType$lzycompute();
        }
        return this.resultType;
    }

    private AttributeReference sum$lzycompute() {
        Sum sum = this;
        synchronized (sum) {
            if ((this.bitmap$0 & 2) == 0) {
                String x$1 = "sum";
                AtomicType x$2 = this.resultType();
                boolean x$3 = AttributeReference$.MODULE$.apply$default$3();
                Metadata x$4 = AttributeReference$.MODULE$.apply$default$4();
                ExprId x$5 = AttributeReference$.MODULE$.apply$default$5(x$1, (DataType)x$2, x$3, x$4);
                Seq<String> x$6 = AttributeReference$.MODULE$.apply$default$6(x$1, (DataType)x$2, x$3, x$4);
                this.sum = new AttributeReference(x$1, (DataType)x$2, x$3, x$4, x$5, x$6);
                this.bitmap$0 |= 2;
            }
        }
        return this.sum;
    }

    private AttributeReference sum() {
        if ((this.bitmap$0 & 2) == 0) {
            return this.sum$lzycompute();
        }
        return this.sum;
    }

    private AttributeReference isEmpty$lzycompute() {
        Sum sum = this;
        synchronized (sum) {
            if ((this.bitmap$0 & 4) == 0) {
                String x$1 = "isEmpty";
                BooleanType$ x$2 = BooleanType$.MODULE$;
                boolean x$3 = false;
                Metadata x$4 = AttributeReference$.MODULE$.apply$default$4();
                ExprId x$5 = AttributeReference$.MODULE$.apply$default$5(x$1, (DataType)x$2, x$3, x$4);
                Seq<String> x$6 = AttributeReference$.MODULE$.apply$default$6(x$1, (DataType)x$2, x$3, x$4);
                this.isEmpty = new AttributeReference(x$1, (DataType)x$2, x$3, x$4, x$5, x$6);
                this.bitmap$0 |= 4;
            }
        }
        return this.isEmpty;
    }

    private AttributeReference isEmpty() {
        if ((this.bitmap$0 & 4) == 0) {
            return this.isEmpty$lzycompute();
        }
        return this.isEmpty;
    }

    private Literal zero$lzycompute() {
        Sum sum = this;
        synchronized (sum) {
            if ((this.bitmap$0 & 8) == 0) {
                this.zero = Literal$.MODULE$.default((DataType)this.resultType());
                this.bitmap$0 |= 8;
            }
        }
        return this.zero;
    }

    private Literal zero() {
        if ((this.bitmap$0 & 8) == 0) {
            return this.zero$lzycompute();
        }
        return this.zero;
    }

    private Expression add(Expression left, Expression right) {
        DataType dataType = left.dataType();
        if (dataType instanceof DecimalType) {
            return new DecimalAddNoOverflowCheck(left, right, left.dataType());
        }
        return new Add(left, right, this.evalMode());
    }

    private Seq<AttributeReference> aggBufferAttributes$lzycompute() {
        Sum sum = this;
        synchronized (sum) {
            if ((this.bitmap$0 & 0x10) == 0) {
                List list;
                if (this.shouldTrackIsEmpty()) {
                    AttributeReference attributeReference = this.sum();
                    AttributeReference attributeReference2 = this.isEmpty();
                    list = Nil$.MODULE$.$colon$colon((Object)attributeReference2).$colon$colon((Object)attributeReference);
                } else {
                    AttributeReference attributeReference = this.sum();
                    list = Nil$.MODULE$.$colon$colon((Object)attributeReference);
                }
                this.aggBufferAttributes = list;
                this.bitmap$0 |= 0x10;
            }
        }
        return this.aggBufferAttributes;
    }

    @Override
    public Seq<AttributeReference> aggBufferAttributes() {
        if ((this.bitmap$0 & 0x10) == 0) {
            return this.aggBufferAttributes$lzycompute();
        }
        return this.aggBufferAttributes;
    }

    private Seq<Expression> initialValues$lzycompute() {
        Sum sum = this;
        synchronized (sum) {
            if ((this.bitmap$0 & 0x20) == 0) {
                this.initialValues = this.shouldTrackIsEmpty() ? (Seq)new .colon.colon((Object)this.zero(), (List)new .colon.colon((Object)new Literal(BoxesRunTime.boxToBoolean((boolean)true), (DataType)BooleanType$.MODULE$), (List)Nil$.MODULE$)) : (Seq)new .colon.colon((Object)new Literal(null, (DataType)this.resultType()), (List)Nil$.MODULE$);
                this.bitmap$0 |= 0x20;
            }
        }
        return this.initialValues;
    }

    @Override
    public Seq<Expression> initialValues() {
        if ((this.bitmap$0 & 0x20) == 0) {
            return this.initialValues$lzycompute();
        }
        return this.initialValues;
    }

    private Seq<Expression> updateExpressions$lzycompute() {
        Sum sum = this;
        synchronized (sum) {
            if ((this.bitmap$0 & 0x40) == 0) {
                Seq seq;
                if (this.shouldTrackIsEmpty()) {
                    Expression sumExpr = this.child().nullable() ? new If((Expression)((Object)package$expressions$.MODULE$.DslExpression(this.child()).isNull()), this.sum(), this.add(this.sum(), package$expressions$.MODULE$.DslExpression(new KnownNotNull(this.child())).cast((DataType)this.resultType()))) : this.add(this.sum(), package$expressions$.MODULE$.DslExpression(this.child()).cast((DataType)this.resultType()));
                    Literal isEmptyExpr = this.child().nullable() ? (Expression)((Object)package$expressions$.MODULE$.DslExpression(this.isEmpty()).$amp$amp((Expression)((Object)package$expressions$.MODULE$.DslExpression(this.child()).isNull()))) : new Literal(BoxesRunTime.boxToBoolean((boolean)false), (DataType)BooleanType$.MODULE$);
                    seq = (Seq)new .colon.colon((Object)sumExpr, (List)new .colon.colon((Object)isEmptyExpr, (List)Nil$.MODULE$));
                } else {
                    seq = this.child().nullable() ? (Seq)new .colon.colon((Object)package$expressions$.MODULE$.coalesce((Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.add(package$expressions$.MODULE$.coalesce((Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.sum(), this.zero()})), package$expressions$.MODULE$.DslExpression(this.child()).cast((DataType)this.resultType())), this.sum()})), (List)Nil$.MODULE$) : (Seq)new .colon.colon((Object)this.add(package$expressions$.MODULE$.coalesce((Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.sum(), this.zero()})), package$expressions$.MODULE$.DslExpression(this.child()).cast((DataType)this.resultType())), (List)Nil$.MODULE$);
                }
                this.updateExpressions = seq;
                this.bitmap$0 |= 0x40;
            }
        }
        return this.updateExpressions;
    }

    @Override
    public Seq<Expression> updateExpressions() {
        if ((this.bitmap$0 & 0x40) == 0) {
            return this.updateExpressions$lzycompute();
        }
        return this.updateExpressions;
    }

    private Seq<Expression> mergeExpressions$lzycompute() {
        Sum sum = this;
        synchronized (sum) {
            if ((this.bitmap$0 & 0x80) == 0) {
                Seq seq;
                if (this.shouldTrackIsEmpty()) {
                    Predicate bufferOverflow = package$expressions$.MODULE$.DslExpression((Expression)((Object)package$expressions$.MODULE$.DslExpression(this.RichAttribute(this.isEmpty()).left()).unary_$bang())).$amp$amp((Expression)((Object)package$expressions$.MODULE$.DslExpression(this.RichAttribute(this.sum()).left()).isNull()));
                    Predicate inputOverflow = package$expressions$.MODULE$.DslExpression((Expression)((Object)package$expressions$.MODULE$.DslExpression(this.RichAttribute(this.isEmpty()).right()).unary_$bang())).$amp$amp((Expression)((Object)package$expressions$.MODULE$.DslExpression(this.RichAttribute(this.sum()).right()).isNull()));
                    seq = (Seq)new .colon.colon((Object)new If((Expression)((Object)package$expressions$.MODULE$.DslExpression((Expression)((Object)bufferOverflow)).$bar$bar((Expression)((Object)inputOverflow))), Literal$.MODULE$.create(null, (DataType)this.resultType()), this.add(new KnownNotNull(this.RichAttribute(this.sum()).left()), new KnownNotNull(this.RichAttribute(this.sum()).right()))), (List)new .colon.colon((Object)((Expression)((Object)package$expressions$.MODULE$.DslExpression(this.RichAttribute(this.isEmpty()).left()).$amp$amp(this.RichAttribute(this.isEmpty()).right()))), (List)Nil$.MODULE$));
                } else {
                    seq = (Seq)new .colon.colon((Object)package$expressions$.MODULE$.coalesce((Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.add(package$expressions$.MODULE$.coalesce((Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.RichAttribute(this.sum()).left(), this.zero()})), this.RichAttribute(this.sum()).right()), this.RichAttribute(this.sum()).left()})), (List)Nil$.MODULE$);
                }
                this.mergeExpressions = seq;
                this.bitmap$0 |= 0x80;
            }
        }
        return this.mergeExpressions;
    }

    @Override
    public Seq<Expression> mergeExpressions() {
        if ((this.bitmap$0 & 0x80) == 0) {
            return this.mergeExpressions$lzycompute();
        }
        return this.mergeExpressions;
    }

    private Expression evaluateExpression$lzycompute() {
        Sum sum = this;
        synchronized (sum) {
            if ((this.bitmap$0 & 0x100) == 0) {
                Expression expression;
                AtomicType atomicType = this.resultType();
                if (atomicType instanceof DecimalType) {
                    DecimalType decimalType = (DecimalType)atomicType;
                    Enumeration.Value value = this.evalMode();
                    Enumeration.Value value2 = EvalMode$.MODULE$.ANSI();
                    CheckOverflowInSum checkOverflowInSum = new CheckOverflowInSum(this.sum(), decimalType, value == null ? value2 != null : !value.equals(value2), this.getContextOrNull());
                    expression = new If(this.isEmpty(), Literal$.MODULE$.create(null, (DataType)this.resultType()), checkOverflowInSum);
                } else {
                    expression = this.shouldTrackIsEmpty() ? new If(this.isEmpty(), Literal$.MODULE$.create(null, (DataType)this.resultType()), this.sum()) : this.sum();
                }
                this.evaluateExpression = expression;
                this.bitmap$0 |= 0x100;
            }
        }
        return this.evaluateExpression;
    }

    @Override
    public Expression evaluateExpression() {
        if ((this.bitmap$0 & 0x100) == 0) {
            return this.evaluateExpression$lzycompute();
        }
        return this.evaluateExpression;
    }

    @Override
    public Iterator<Object> flatArguments() {
        return package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.child()}));
    }

    @Override
    public Option<SQLQueryContext> initQueryContext() {
        Enumeration.Value value = this.evalMode();
        Enumeration.Value value2 = EvalMode$.MODULE$.ANSI();
        if (!(value != null ? !value.equals(value2) : value2 != null)) {
            return new Some((Object)this.origin().context());
        }
        return None$.MODULE$;
    }

    @Override
    public Expression withNewChildInternal(Expression newChild) {
        return this.copy(newChild, this.copy$default$2());
    }

    public Sum copy(Expression child, Enumeration.Value evalMode) {
        return new Sum(child, evalMode);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public Enumeration.Value copy$default$2() {
        return this.evalMode();
    }

    @Override
    public String productPrefix() {
        return "Sum";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.child();
            }
            case 1: {
                return this.evalMode();
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Sum;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Sum)) return false;
        boolean bl = true;
        if (!bl) return false;
        Sum sum = (Sum)x$1;
        Expression expression = this.child();
        Expression expression2 = sum.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Enumeration.Value value = this.evalMode();
        Enumeration.Value value2 = sum.evalMode();
        if (value == null) {
            if (value2 != null) {
                return false;
            }
        } else if (!value.equals(value2)) return false;
        if (!sum.canEqual(this)) return false;
        return true;
    }

    public Sum(Expression child, Enumeration.Value evalMode) {
        this.child = child;
        this.evalMode = evalMode;
        ExpectsInputTypes.$init$(this);
        UnaryLike.$init$(this);
        SupportQueryContext.$init$(this);
        this.nodePatterns = (Seq)new .colon.colon((Object)TreePattern$.MODULE$.SUM(), (List)Nil$.MODULE$);
    }

    public Sum(Expression child) {
        this(child, EvalMode$.MODULE$.fromSQLConf(SQLConf$.MODULE$.get()));
    }
}

