/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.jdbc42.internal.apache.arrow.vector.complex.impl;

import com.databricks.client.jdbc42.internal.apache.arrow.vector.complex.impl.AbstractFieldReader;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.complex.writer.DateMilliWriter;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.holders.DateMilliHolder;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.holders.NullableDateMilliHolder;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.types.Types;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.util.DateUtility;
import java.time.LocalDateTime;

public class DateMilliHolderReaderImpl
extends AbstractFieldReader {
    private DateMilliHolder holder;

    public DateMilliHolderReaderImpl(DateMilliHolder holder) {
        this.holder = holder;
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException("You can't call size on a Holder value reader.");
    }

    @Override
    public boolean next() {
        throw new UnsupportedOperationException("You can't call next on a single value reader.");
    }

    @Override
    public void setPosition(int index) {
        throw new UnsupportedOperationException("You can't call next on a single value reader.");
    }

    @Override
    public Types.MinorType getMinorType() {
        return Types.MinorType.DATEMILLI;
    }

    @Override
    public boolean isSet() {
        return true;
    }

    @Override
    public void read(DateMilliHolder h) {
        h.value = this.holder.value;
    }

    @Override
    public void read(NullableDateMilliHolder h) {
        h.value = this.holder.value;
        h.isSet = this.isSet() ? 1 : 0;
    }

    @Override
    public LocalDateTime readLocalDateTime() {
        return DateUtility.getLocalDateTimeFromEpochMilli(this.holder.value);
    }

    @Override
    public Object readObject() {
        return this.readLocalDateTime();
    }

    @Override
    public void copyAsValue(DateMilliWriter writer) {
        writer.write(this.holder);
    }
}

