/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.sqlengine.executor.datawrapper;

import com.databricks.client.dsi.dataengine.utilities.DataWrapper;
import com.databricks.client.dsi.exceptions.IncorrectTypeException;
import com.databricks.client.sqlengine.exceptions.SQLEngineException;
import com.databricks.client.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.databricks.client.sqlengine.executor.datawrapper.DefaultSqlDataWrapper;
import com.databricks.client.sqlengine.utilities.SQLEngineMessageKey;
import com.databricks.client.support.exceptions.ErrorException;
import java.math.BigInteger;

public final class SqlIntegerDataWrapper
extends DefaultSqlDataWrapper {
    private long m_data;
    private boolean m_isSet = false;
    private boolean m_isNull = false;

    @Override
    public BigInteger getBigInt() throws ErrorException, NullPointerException {
        return BigInteger.valueOf(this.getData());
    }

    @Override
    public double getDouble() throws ErrorException, NullPointerException {
        return this.getData();
    }

    @Override
    public long getInteger() throws ErrorException, NullPointerException {
        return this.getData();
    }

    @Override
    public int getType() {
        return 4;
    }

    @Override
    public boolean isSet() {
        return this.m_isSet;
    }

    @Override
    public boolean isNull() {
        return this.m_isNull;
    }

    @Override
    public void setBoolean(boolean bl) {
        this.m_isSet = true;
        this.m_isNull = false;
        this.m_data = bl ? 1L : 0L;
    }

    @Override
    public void setInteger(long l) {
        this.setData(l);
    }

    @Override
    public void setSmallInt(int n) {
        this.setData(n);
    }

    @Override
    public void setTinyInt(short s) {
        this.setData(s);
    }

    @Override
    public void setNull() {
        this.m_isSet = true;
        this.m_isNull = true;
    }

    private long getData() throws ErrorException {
        if (!this.m_isSet) {
            throw SQLEngineExceptionFactory.requestedDataNotSet();
        }
        if (this.m_isNull) {
            throw new NullPointerException("Data requested, but the data is null.");
        }
        return this.m_data;
    }

    private void setData(long l) {
        this.m_isSet = true;
        this.m_data = l;
        this.m_isNull = false;
    }

    @Override
    public void setValue(DataWrapper dataWrapper) throws ErrorException {
        if (dataWrapper.isNull()) {
            this.setNull();
        } else {
            try {
                switch (dataWrapper.getType()) {
                    case 16: {
                        this.setBoolean(dataWrapper.getBoolean());
                        break;
                    }
                    case -7: {
                        this.setBoolean(dataWrapper.getBit());
                        break;
                    }
                    case 4: {
                        this.setInteger(dataWrapper.getInteger());
                        break;
                    }
                    case 5: {
                        this.setSmallInt(dataWrapper.getSmallInt());
                        break;
                    }
                    case -6: {
                        this.setTinyInt(dataWrapper.getTinyInt());
                        break;
                    }
                    default: {
                        throw SQLEngineExceptionFactory.invalidSqlTypeForWrapperException(dataWrapper.getType());
                    }
                }
            }
            catch (IncorrectTypeException incorrectTypeException) {
                throw new SQLEngineException(SQLEngineMessageKey.INVALID_OPERATION.name(), incorrectTypeException);
            }
        }
    }

    @Override
    public void retrieveData(DataWrapper dataWrapper) throws ErrorException {
        if (!this.m_isSet) {
            throw new IllegalStateException("ISqlDataWrapper is not set with data for retrieval");
        }
        if (this.m_isNull) {
            dataWrapper.setNull(4);
            return;
        }
        dataWrapper.setInteger(this.m_data);
    }
}

