/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.models.ui;

import com.dataiku.common.server.APIError;
import com.dataiku.gh.core.models.ui.UIArtifact;
import com.dataiku.gh.core.models.ui.UIArtifactException;
import com.dataiku.gh.core.utils.Either;
import com.dataiku.j2ts.annotations.UIModel;
import java.util.List;
import java.util.stream.Collectors;

@UIModel
public class UIGetArtifactsResult {
    public final List<UIArtifact> uiArtifacts;
    public final List<ArtifactAPIError> errors;

    private UIGetArtifactsResult(List<UIArtifact> uiArtifacts, List<ArtifactAPIError> errors) {
        this.uiArtifacts = uiArtifacts;
        this.errors = errors;
    }

    public static <E extends Exception> UIGetArtifactsResult build(List<Either<UIArtifactException, UIArtifact>> artifactsOrExceptions) {
        List<UIArtifact> uiArtifacts = artifactsOrExceptions.stream().filter(Either::isRight).map(Either::getRight).collect(Collectors.toList());
        List<ArtifactAPIError> errors = artifactsOrExceptions.stream().filter(Either::isLeft).map(item -> ArtifactAPIError.build((UIArtifactException)item.getLeft())).collect(Collectors.toList());
        return new UIGetArtifactsResult(uiArtifacts, errors);
    }

    public static class ArtifactAPIError {
        public final String artifactId;
        public final APIError error;

        private ArtifactAPIError(String artifactId, Exception exception) {
            this.artifactId = artifactId;
            this.error = new APIError((Throwable)exception, false);
        }

        public static ArtifactAPIError build(UIArtifactException uiArtifactException) {
            return new ArtifactAPIError(uiArtifactException.artifactId, uiArtifactException.exception);
        }
    }
}

