/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.blueprints;

import com.dataiku.gh.core.models.blueprints.Blueprint;
import com.dataiku.gh.core.models.blueprints.BlueprintVersion;
import com.dataiku.gh.core.models.blueprints.BlueprintVersionId;
import com.dataiku.gh.core.models.blueprints.BlueprintVersionStatus;
import com.dataiku.gh.core.models.blueprints.BlueprintVersionTrace;
import com.dataiku.gh.core.models.enriched.EnrichedBlueprint;
import com.dataiku.gh.core.models.enriched.EnrichedBlueprintVersion;
import com.dataiku.gh.core.models.migration_paths.BlueprintVersionMigrationPath;
import com.dataiku.gh.core.models.search.ArtifactFilter;
import com.dataiku.gh.core.models.search.ArtifactSearchSourceConfig;
import com.dataiku.gh.core.services.artifacts.IArtifactsDataService;
import com.dataiku.gh.core.services.artifacts.migrator.IArtifactMigrator;
import com.dataiku.gh.core.services.blueprints.IBlueprintsDataService;
import com.dataiku.gh.core.services.roles_and_permissions.assignments.IBlueprintRoleAssignmentsDataService;
import com.dataiku.gh.core.services.roles_and_permissions.permissions.IBlueprintPermissionsDataService;
import com.dataiku.gh.core.services.signoff.ISignoffsDataService;
import com.dataiku.gh.core.services.utils.GHReadonlyTransaction;
import com.dataiku.gh.core.services.utils.GHWriteTransaction;
import com.dataiku.gh.core.services.validation.errors.ValidationException;
import com.dataiku.gh.core.storage.blueprints.IBlueprintDAO;
import com.dataiku.gh.core.storage.blueprints.IBlueprintVersionDAO;
import com.dataiku.gh.core.storage.blueprints.IBlueprintVersionTraceDAO;
import com.dataiku.gh.core.storage.migration_paths.IBlueprintVersionMigrationPathDAO;
import com.dataiku.gh.core.storage.roles.assignments.IBlueprintRoleAssignmentsDAO;
import com.dataiku.gh.core.storage.roles.permissions.IBlueprintPermissionsDAO;
import com.dataiku.gh.core.storage.signoff.ISignoffsConfigurationsDAO;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BlueprintsDataService
implements IBlueprintsDataService {
    @Autowired
    private IBlueprintDAO blueprintDAO;
    @Autowired
    private IBlueprintVersionDAO blueprintVersionDAO;
    @Autowired
    private IBlueprintVersionTraceDAO blueprintVersionTraceDAO;
    @Autowired
    private IBlueprintRoleAssignmentsDAO blueprintRoleAssignmentsDAO;
    @Autowired
    private IBlueprintRoleAssignmentsDataService blueprintRoleAssignmentsDataService;
    @Autowired
    private IBlueprintPermissionsDAO blueprintPermissionsDAO;
    @Autowired
    private IBlueprintPermissionsDataService blueprintPermissionsDataService;
    @Autowired
    private IArtifactsDataService artifactsDataService;
    @Autowired
    private IArtifactMigrator artifactMigrator;
    @Autowired
    ISignoffsConfigurationsDAO signoffsConfigurationsDAO;
    @Autowired
    private ISignoffsDataService signoffsDataService;
    @Autowired
    private IBlueprintVersionMigrationPathDAO blueprintVersionMigrationPathDAO;

    @Override
    @GHReadonlyTransaction
    public EnrichedBlueprint getBlueprint(String blueprintId) throws IOException {
        return (EnrichedBlueprint)this.blueprintDAO.getMandatory(blueprintId);
    }

    @Override
    @GHReadonlyTransaction
    public EnrichedBlueprint getBlueprintOrNull(String blueprintId) throws IOException {
        return (EnrichedBlueprint)this.blueprintDAO.getOrNull(blueprintId);
    }

    @Override
    @GHReadonlyTransaction
    public List<EnrichedBlueprint> listBlueprints() throws IOException {
        return this.blueprintDAO.list();
    }

    @Override
    @GHWriteTransaction
    public EnrichedBlueprint storeBlueprint(Blueprint blueprint, boolean creation) throws IOException {
        this.lockBlueprint(blueprint.id);
        if (creation) {
            this.blueprintDAO.create(blueprint);
        } else {
            this.blueprintDAO.save(blueprint);
        }
        return (EnrichedBlueprint)this.blueprintDAO.getMandatory(blueprint.id);
    }

    @Override
    @GHWriteTransaction
    public void deleteBlueprint(String blueprintId) throws IOException {
        this.lockBlueprint(blueprintId);
        if (this.blueprintPermissionsDAO.exists(blueprintId)) {
            this.blueprintPermissionsDataService.deleteBlueprintPermissions(blueprintId);
        }
        if (this.blueprintRoleAssignmentsDAO.exists(blueprintId)) {
            this.blueprintRoleAssignmentsDataService.deleteBlueprintRoleAssignments(blueprintId);
        }
        this.blueprintDAO.delete(blueprintId);
    }

    @Override
    @GHReadonlyTransaction
    public EnrichedBlueprintVersion getBlueprintVersion(BlueprintVersionId blueprintVersionId) throws IOException {
        return (EnrichedBlueprintVersion)this.blueprintVersionDAO.getMandatory(blueprintVersionId);
    }

    @Override
    @GHReadonlyTransaction
    @Nullable
    public EnrichedBlueprintVersion getBlueprintVersionOrNull(BlueprintVersionId blueprintVersionId) throws IOException {
        return (EnrichedBlueprintVersion)this.blueprintVersionDAO.getOrNull(blueprintVersionId);
    }

    @Override
    @GHReadonlyTransaction
    public List<EnrichedBlueprintVersion> listBlueprintVersions() throws IOException {
        return this.blueprintVersionDAO.list();
    }

    @Override
    @GHReadonlyTransaction
    public List<EnrichedBlueprintVersion> listBlueprintVersionsByBlueprint(String blueprintId) throws IOException {
        return this.blueprintVersionDAO.listByBlueprint(blueprintId);
    }

    @Override
    @GHWriteTransaction
    public EnrichedBlueprintVersion createBlueprintVersion(BlueprintVersion blueprintVersion, @Nullable String originVersionId) throws IOException {
        this.lockBlueprintVersion(blueprintVersion.id);
        if (StringUtils.isNotBlank((CharSequence)originVersionId)) {
            BlueprintVersionId originBlueprintVersionId = BlueprintVersionId.build(blueprintVersion.id.blueprintId, originVersionId);
            this.lockBlueprintVersion(originBlueprintVersionId);
        }
        BlueprintVersionTrace blueprintVersionTrace = new BlueprintVersionTrace();
        blueprintVersionTrace.blueprintVersionId = blueprintVersion.id;
        blueprintVersionTrace.status = BlueprintVersionStatus.DRAFT;
        blueprintVersionTrace.originVersionId = originVersionId;
        this.blueprintVersionDAO.create(blueprintVersion);
        this.blueprintVersionTraceDAO.create(blueprintVersionTrace);
        return (EnrichedBlueprintVersion)this.blueprintVersionDAO.getMandatory(blueprintVersion.id);
    }

    @Override
    @GHWriteTransaction
    public EnrichedBlueprintVersion saveBlueprintVersion(BlueprintVersion blueprintVersion, boolean dangerZoneAccepted) throws IOException {
        this.lockBlueprintVersion(blueprintVersion.id);
        BlueprintVersionTrace blueprintVersionTrace = (BlueprintVersionTrace)this.blueprintVersionTraceDAO.getMandatory(blueprintVersion.id);
        if (StringUtils.isNotBlank((CharSequence)blueprintVersionTrace.originVersionId)) {
            BlueprintVersionId originBlueprintVersionId = BlueprintVersionId.build(blueprintVersionTrace.blueprintVersionId.blueprintId, blueprintVersionTrace.originVersionId);
            this.lockBlueprintVersion(originBlueprintVersionId);
        }
        this.checkDangerZone(blueprintVersion.id, dangerZoneAccepted);
        List<String> existingStepIds = blueprintVersion.workflowDefinition.stepDefinitions.stream().map(stepDefinition -> stepDefinition.id).collect(Collectors.toList());
        this.signoffsDataService.deleteSignoffConfigurationsForNonExistingSteps(blueprintVersion.id, existingStepIds);
        this.signoffsDataService.deleteSignoffsForNonExistingSteps(blueprintVersion.id, existingStepIds);
        this.blueprintVersionDAO.save(blueprintVersion);
        this.artifactMigrator.migrateImpactedArtifacts(blueprintVersion.id);
        return (EnrichedBlueprintVersion)this.blueprintVersionDAO.getMandatory(blueprintVersion.id);
    }

    @Override
    @GHWriteTransaction
    public EnrichedBlueprintVersion updateBlueprintVersionStatus(BlueprintVersionId blueprintVersionId, BlueprintVersionStatus blueprintVersionStatus) throws IOException {
        this.lockBlueprintVersion(blueprintVersionId);
        BlueprintVersionTrace blueprintVersionTrace = (BlueprintVersionTrace)this.blueprintVersionTraceDAO.getMandatory(blueprintVersionId);
        blueprintVersionTrace.status = blueprintVersionStatus;
        this.blueprintVersionTraceDAO.save(blueprintVersionTrace);
        return (EnrichedBlueprintVersion)this.blueprintVersionDAO.getMandatory(blueprintVersionId);
    }

    @Override
    @GHWriteTransaction
    public void deleteBlueprintVersion(BlueprintVersionId blueprintVersionId) throws IOException {
        this.lockBlueprintVersion(blueprintVersionId);
        List<BlueprintVersionTrace> children = this.blueprintVersionTraceDAO.listByOriginVersion(blueprintVersionId);
        for (BlueprintVersionTrace blueprintVersionTrace : children) {
            this.lockBlueprintVersion(blueprintVersionTrace.blueprintVersionId);
        }
        this.checkDangerZone(blueprintVersionId, false);
        for (BlueprintVersionTrace blueprintVersionTrace : this.blueprintVersionTraceDAO.listByOriginVersion(blueprintVersionId)) {
            blueprintVersionTrace.originVersionId = null;
            this.blueprintVersionTraceDAO.save(blueprintVersionTrace);
        }
        this.signoffsDataService.deleteSignoffConfigurationsByBlueprintVersion(blueprintVersionId);
        this.blueprintVersionTraceDAO.delete(blueprintVersionId);
        this.blueprintVersionDAO.delete(blueprintVersionId);
    }

    @Override
    @GHReadonlyTransaction
    public long countBlueprintVersionExistingArtifacts(BlueprintVersionId blueprintVersionId) throws IOException {
        return this.artifactsDataService.searchArtifactsCount(ArtifactSearchSourceConfig.AllArtifactSearchSource.build(), Collections.singletonList(ArtifactFilter.BlueprintVersionsArtifactFilter.build(blueprintVersionId)));
    }

    private void lockBlueprint(String blueprintId) throws IOException {
        this.blueprintDAO.lock(blueprintId);
        this.blueprintRoleAssignmentsDAO.lock(blueprintId);
        this.blueprintPermissionsDAO.lock(blueprintId);
    }

    private void lockBlueprintVersion(BlueprintVersionId blueprintVersionId) throws IOException {
        this.lockBlueprint(blueprintVersionId.blueprintId);
        this.blueprintVersionDAO.lock(blueprintVersionId);
        this.blueprintVersionTraceDAO.lock(blueprintVersionId);
        this.signoffsConfigurationsDAO.lockByBlueprintVersion(blueprintVersionId);
        List<BlueprintVersionMigrationPath> relatedMigrations = this.blueprintVersionMigrationPathDAO.listByRelatedBlueprintVersion(blueprintVersionId);
        for (BlueprintVersionMigrationPath migration : relatedMigrations) {
            this.blueprintVersionMigrationPathDAO.lock(migration.id);
        }
    }

    private void checkDangerZone(BlueprintVersionId blueprintVersionId, boolean dangerZoneAccepted) throws IOException {
        if (!dangerZoneAccepted && this.countBlueprintVersionExistingArtifacts(blueprintVersionId) > 0L) {
            throw new ValidationException("This blueprint version has existing artifacts attached to it: " + String.valueOf(blueprintVersionId));
        }
    }
}

